<?php

    class mcontadodetalle extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "contado_detalle";
            $this->alias = 'cd';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idCuenta
            ,".$this->alias.".cuenta
            ,".$this->alias.".formaPago
            ,".$this->alias.".comprobante
            ,".$this->alias.".tipo
            ,".$this->alias.".descripcion
            ,".$this->alias.".importe
            ,".$this->alias.".saldo
            ,".$this->alias.".statusDetalle
            ,".$this->alias.".movimiento
            ,".$this->alias.".fecha
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idCuenta' => '',
                'cuenta' => '',
                'formaPago' => '',
                'comprobante' => '',
                'tipo' => '',
                'descripcion' => '',
                'importe' => '',
                'saldo' => '',
                'statusDetalle' => '',
                'movimiento' => '',
                'fecha' => '',
                'status' => '',
                'txtstatus' => ''
            );
            
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idCuenta'] = $r->row()->idCuenta;
                $array['cuenta'] = $r->row()->cuenta;
                $array['formaPago'] = $r->row()->formaPago;
                $array['comprobante'] = $r->row()->comprobante;
                $array['tipo'] = $r->row()->tipo;
                $array['descripcion'] = $r->row()->descripcion;
                $array['importe'] = $r->row()->importe;
                $array['saldo'] = $r->row()->saldo;
                $array['statusDetalle'] = $r->row()->statusDetalle;
                $array['movimiento'] = $r->row()->movimiento;
                $array['fecha'] = $r->row()->fecha;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
          /*  $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);*/
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows() > 0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdContado($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idCuenta' => $id);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', 'desc');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getSumImporteByIdContadoTipo($id, $tipo){
            $this->db->select_sum($this->alias.'.importe');
            $arrayWhere = array($this->alias.'.idCuenta' => $id, $this->alias.'.tipo' => $tipo);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->importe > 0){
                return $query->row()->importe;
            }
            else{
                return 0;
            }
        }

        function getByIdContadoAnticipo($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idCuenta' => $id);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', 'asc');
            $this->db->limit(1);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
                
        //FUNCIONES DEL SERVERSIDE
        var $column_order = array(null, 'idCuenta','formaPago','formaPago','tipo','descripcion','importe','saldo','statusDetalle','movimiento','fecha'); //set column field database for datatable orderable
        var $column_search = array('idCuenta','formaPago','comprobante','tipo','descripcion','importe','saldo','statusDetalle','movimiento','fecha'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order
        var $serverIdContado = null;
        
        function get_datatables($idContado = null)
        {
            $this->serverIdContado = $idContado;
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }
        
        private function _get_datatables_query()
        {

            $this->db->from($this->table);
            /*
                if($_SESSION["viv"]["idEmpresa"] > 0){
                    $id=$_SESSION["viv"]["idEmpresa"];
                    $arrayWhere = array('idEmpresa' => $id);
                    $this->db->where($arrayWhere);
                }
            */

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }

            $arrayWhere = array('idCuenta' => $this->serverIdContado);
            $this->db->where($arrayWhere);
        }

        function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
    }