<?php

class mcomparativa extends MY_Model{

    var $column_order = array('fraccionamiento','nombre_almacen','nLotes','clave','articulo','unidad_venta','proveedor','precio_ppto','unidades_ppto','importe_ppto','folios_c','unidades_doc','precio_doc','importe_doc','folios_oc','unidades_dc','precio_dc','importe_dc','folios_rc','unidades_drc','precio_drc','importe_drc','cantidad_ppto','precio_unitario','importe','cantidad_ppto2','precio_unitario2','importe2');
    var $column_search = array('fraccionamiento','nombre_almacen','nLotes','clave','articulo','unidad_venta','proveedor','folios_oc', 'folios_c', 'folios_rc');
    var $order = array('nombre_almacen' => 'desc'); // default order
    var $info;
    var $query="";
    protected $CI;
    public function __construct()
    {
        parent::__construct();
        $this->CI =& get_instance();
        $this->load->database();
    }

    ///////////Inician funciones de carga del lado del servidor///////////
    private function _get_datatables_query(){
        $nsession=$this->CI->config->item('nsession');
        $this->info=$_REQUEST["info"];
        //print_r($this->info);
        //exit();
        $idEmpresa=$_SESSION[$nsession]["idEmpresa"];
        $filter=$filter2="";
        if($this->info["fraccionamiento"] > 0){
            $filter.=" AND mate.idFraccionamiento=".$this->info["fraccionamiento"];
            $filter2.=" AND mate.idFraccionamiento=".$this->info["fraccionamiento"];
        }
        if($this->info["almacen"] > 0){
            $filter.=" AND dc.idPaquete=".$this->info["almacen"];
            $filter2.=" AND mate.idPaquete=".$this->info["almacen"];
        }
        if($this->info["articulo"] > 0){
            $filter.=" AND dc.id_articulo=".$this->info["articulo"];
            $filter2.=" AND mact.idMaterial=".$this->info["articulo"];
        }
        if($this->info["proveedor"] > 0){
            $filter.=" AND c.id_proveedor=".$this->info["proveedor"];
            $filter2.=" AND pmat.idProveedor=".$this->info["proveedor"];
        }
        if ($this->info['fecha_inicio'] != "" && $this->info['fecha_fin']  != "") {
            $fecha_inicio = date_format(new DateTime($this->info['fecha_inicio']),"Y-m-d");
            $fecha_fin = date_format(new DateTime($this->info['fecha_fin']),"Y-m-d");
            if($fecha_inicio != $fecha_fin){
                $filter.=" AND DATE(c.fecha) >= DATE('$fecha_inicio') AND DATE(c.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                $filter2.=" AND DATE(c.fecha) >= DATE('$fecha_inicio') AND DATE(c.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
            }else{
                $filter.=" AND DATE(c.fecha) = DATE('$fecha_inicio') ";
                $filter2.=" AND DATE(c.fecha) = DATE('$fecha_inicio') ";
            }
        }

        //Inicia armado de columnas
        $precio_doc="ROUND(AVG(doc.precio_unitario),2)";
        $importe_doc="ROUND(SUM(DISTINCT ROUND(doc.precio_unitario * doc.unidades,2) + doc.id) - SUM(DISTINCT doc.id),2)";
        $unidades_doc="ROUND($importe_doc / $precio_doc,2)";

        $precio_dc="ROUND(AVG(dc.precio_unitario),2)";
        $importe_dc="ROUND(SUM(DISTINCT ROUND(dc.precio_unitario * dc.unidades,2) + dc.id) - SUM(DISTINCT dc.id),2)";
        $unidades_dc="ROUND($importe_dc / $precio_dc,2)";

        $precio_drc="ROUND(AVG(drc.precio_unitario),2)";
        $importe_drc="ROUND(SUM(DISTINCT ROUND(drc.precio_unitario * drc.unidades,2) + drc.id) - SUM(DISTINCT drc.id),2)";
        $unidades_drc="ROUND($importe_drc / $precio_drc,2)";

        $precio_ppto="AVG((pmat.precioUnitario / 1.16))";
        $importe_ppto="( (SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id)) / 1.16 )";
        $unidades_ppto="ROUND(($importe_ppto / $precio_ppto),2)";
        //Inicia query customizada
        $this->query="            
        SELECT * FROM ( (SELECT
        fr.titulo fraccionamiento,
        al.nombre nombre_almacen,
        paq.nLotes,
        mat.clave clave,
        mat.nombre articulo,
        mat.unidad_venta,
        prov.nombre proveedor,
        
        $unidades_ppto unidades_ppto,
        $precio_ppto precio_ppto,
        $importe_ppto importe_ppto,

        GROUP_CONCAT(DISTINCT oc.folio  SEPARATOR ' ') folios_oc,
        $unidades_doc unidades_doc,
        $precio_doc precio_doc,
        $importe_doc importe_doc,

        GROUP_CONCAT(DISTINCT c.folio  SEPARATOR ' ') folios_c,
        $unidades_dc unidades_dc,
        $precio_dc precio_dc,
        $importe_dc importe_dc,

        GROUP_CONCAT(DISTINCT rc.folio  SEPARATOR ' ') folios_rc,
        $unidades_drc unidades_drc,
        $precio_drc precio_drc,
        $importe_drc importe_drc,

        ($unidades_ppto - $unidades_doc) cantidad_ppto,
        ($precio_ppto - $precio_doc) precio_unitario,
        ($importe_ppto - $importe_doc) importe,

        ($unidades_ppto - $unidades_dc) cantidad_ppto2,
        ($precio_ppto - $precio_dc) precio_unitario2,
        ($importe_ppto - $importe_dc) importe2

        FROM detalle_compra dc
        LEFT JOIN compra c ON dc.id_compra=c.id AND c.idPaquete=dc.idPaquete AND c.idEmpresa=$idEmpresa
        LEFT JOIN almacenes al ON al.idPaquete=dc.idPaquete AND al.idEmpresa=$idEmpresa
        LEFT JOIN materiales mat ON mat.id=dc.id_articulo AND mat.idEmpresa=$idEmpresa
        LEFT JOIN paquetes paq ON paq.id=al.idPaquete

        LEFT JOIN detalle_orden doc ON doc.id_articulo=dc.id_articulo AND doc.idPaquete=dc.idPaquete AND doc.idEmpresa=$idEmpresa
        LEFT JOIN orden_compra oc ON oc.id=doc.id_orden_compra AND oc.idEmpresa=$idEmpresa

        LEFT JOIN detalle_recepcion drc ON drc.id_articulo=dc.id_articulo AND drc.idPaquete=dc.idPaquete AND drc.idEmpresa=$idEmpresa
        LEFT JOIN recepcion rc ON rc.id=drc.id_recepcion AND drc.idEmpresa=$idEmpresa

        LEFT JOIN material mate ON mate.idPaquete=paq.id AND mate.idEmpresa=$idEmpresa
        LEFT JOIN presupuesto_mat pmat ON pmat.idMaterial=mate.id AND (SELECT act.idMaterial FROM materialesactividadprototipo act WHERE act.id=pmat.idMateriales)=dc.id_articulo
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
        LEFT JOIN proveedores prov ON prov.id=c.id_proveedor AND prov.idEmpresa=$idEmpresa
        LEFT JOIN fraccionamientos fr ON fr.id=mate.idFraccionamiento

        WHERE
        dc.idEmpresa=$idEmpresa $filter
        AND dc.idPaquete > 0
        GROUP BY dc.idPaquete, dc.id_articulo)";

        //segunda query
        $precio_ppto="AVG(DISTINCT (pmat.precioUnitario / 1.16))";
        $importe_ppto="((SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id)) / 1.16)";
        $this->query.="
        UNION ALL
        (SELECT 
        fr.titulo fraccionamiento,
        al.nombre nombre_almacen,
        paq.nLotes,
        mat.clave clave,
        mat.nombre articulo,
        mat.unidad_venta,
        prov.nombre proveedor,

        ROUND(($importe_ppto / $precio_ppto),2) unidades_ppto,
        $precio_ppto precio_ppto,
        $importe_ppto importe_ppto,

        '' folios_oc,
        0 unidades_doc,
        0 precio_doc,
        0 importe_doc,

        '' folios_c,
        0 unidades_dc,
        0 precio_dc,
        0 importe_dc,

        '' folios_rc,
        0 unidades_drc,
        0 precio_drc,
        0 importe_drc,

        0 cantidad_ppto,
        0 precio_unitario,
        0 importe,

        0 cantidad_ppto2,
        0 precio_unitario2,
        0 importe2

        FROM presupuesto_mat pmat 
        LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
        LEFT JOIN material mate ON mate.id=pmat.idMaterial AND mate.idEmpresa=$idEmpresa
        LEFT JOIN paquetes paq ON paq.id=mate.idPaquete
        LEFT JOIN almacenes al ON al.idPaquete=mate.idPaquete AND al.idEmpresa=$idEmpresa
        LEFT JOIN materiales mat ON mat.id=mact.idMaterial AND mat.idEmpresa=$idEmpresa
        LEFT JOIN proveedores prov ON prov.id=pmat.idProveedor AND prov.idEmpresa=$idEmpresa
        LEFT JOIN fraccionamientos fr ON fr.id=mate.idFraccionamiento
        LEFT OUTER JOIN detalle_compra dc ON dc.id_articulo=mact.idMaterial AND dc.idEmpresa=$idEmpresa AND dc.idPaquete=paq.id
        LEFT OUTER JOIN compra c ON dc.id_compra=c.id AND c.idPaquete=dc.idPaquete AND c.idEmpresa=$idEmpresa
        WHERE dc.id IS NULL AND al.id $filter2
        GROUP BY mate.idPaquete, mact.idMaterial) ) AS tbl WHERE nLotes > 0
        ";
        //Adaptación especial para que trabaje con UNION
        $i=0;
        foreach ($this->column_search as $item){
            if($_POST['search']['value']) {

                if($i===0){
                    $this->query.=" AND (".$item." LIKE '%".$_POST['search']['value']."%'";
                }else{
                    $this->query.=" OR ".$item." LIKE '%".$_POST['search']['value']."%'";
                }
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->query.=")";
            }
            $i++;
        }
        //Termina adaptación especial

        $this->query.= " ";
        //Adaptación genérica, no se modifica.
        if(isset($_POST['order'])){
            $this->query.=" ORDER BY ".$this->column_order[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
        }else if(isset($this->order)){
            $order = $this->order;
            $this->query.=" ORDER BY ".key($order)." ".$order[key($order)];
        }
        //Termina adaptación genérica
    }

    function get_datatables(){
        $this->info=$_REQUEST["info"];
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->query.=" LIMIT ".$_POST['start'].",".$_POST['length'];
        /*echo $this->query;
        exit();*/
        $this->query = $this->db->query($this->query);
        if($this->query->num_rows() > 0){
            return $this->query;
        }else{
            return 0;
        }
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }
    ////////////Terminan de carga del del lado del servidor////////////

}
