<?php
    class mcategoriamat extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "categorias_mat";
            $this->alias = 'cmat';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".clave
            ,".$this->alias.".categoria
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                 $this->alias.".id
            ,".$this->alias.".clave
            ,".$this->alias.".categoria as titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'clave' => '',
                'categoria' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['clave'] = $r->row()->clave;
                $array['categoria'] = $r->row()->categoria;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByClave($clave){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.clave' => $clave);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        
        function getSelectResultNotInId($ids){
            $this->db->select($this->selectResult,FALSE);
            if( count($ids) > 0){
                $this->db->where_not_in($this->alias.'.id', $ids);
            }
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }