<?php

    class mcartaasignacion extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "cartaasignacion";
            $this->alias = 'm';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idActivo
            ,".$this->alias.".idUsuario
            ,".$this->alias.".notas
            ,".$this->alias.".fechaAsignacion
            ,".$this->alias.".fechaDesasignacion
            ,".$this->alias.".pdf_1
            ,".$this->alias.".statusCarta
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idActivo' => '',
                'idUsuario' => '',
                'notas' => '',
                'fechaAsignacion' => '',
                'fechaDesasignacion' => '',
                'statusCarta' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idActivo'] = $r->row()->idActivo;
                $array['idUsuario'] = $r->row()->idUsuario;
                $array['notas'] = $r->row()->notas;
                $array['fechaAsignacion'] = $r->row()->fechaAsignacion;
                $array['fechaDesasignacion'] = $r->row()->fechaDesasignacion;
                $array['pdf_1'] = $r->row()->pdf_1;
                $array['statusCarta'] = $r->row()->statusCarta;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdActivo($id=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idActivo' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getReporte($info){
            $fecha_inicio=$info['fecha_inicio'];
            $fecha_fin=$info['fecha_fin'];

            $query="SELECT * FROM cartaasignacion WHERE status=1 ";

            if($info["statusCarta"] != '' && $info["statusCarta"] != null){
                $query.="AND statusCarta=".$info["statusCarta"]." ";
            }

            if($info["idUsuario"] != '' && $info["idUsuario"] != null){
                $query.="AND idUsuario=".$info["idUsuario"]." ";
            }

            if($info["tipo"] != '' && $info["tipo"] != null){
                $idActivo=$info["tipo"]." ";
                $query.="AND idActivo IN (SELECT id FROM activos WHERE idActivo=$idActivo)";
            }

            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio= str_replace("/","-",$fecha_inicio);
                $fecha_inicio=date_format(new DateTime($fecha_inicio),"Y-m-d");
                $fecha_fin= str_replace("/","-",$fecha_fin);
                $fecha_fin=date_format(new DateTime($fecha_fin),"Y-m-d");
               $query .= "AND CAST(fechaAsignacion AS DATE) BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }
            $query.=" ORDER BY `id` DESC";
            $query=$this->db->query($query);

            if ($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }

    }