<?php

    class mbonificacion extends MY_Model{
        // Inicio variables para server side
        var $column_order = array(
            1 => 'linea',
            2 => 'cliente',
            3 => 'fraccionamiento',
            4 => 'proy.precioVenta',
            5 => 'ronda',
            6 => 'proy.manzana',
            7 => 'proy.lote',
            8 => 'b.bonificacion',
            9 => 'b.fechaPago',
            10 => 'b.tipo',
        );
        var $column_order2 = array(
            1 => 'b.fechaAutorizado',
            2 => 'linea',
            3 => 'cliente',
            4 => 'fraccionamiento',
            5 => 'proy.precioVenta',
            6 => 'ronda',
            7 => 'proy.manzana',
            8 => 'proy.lote',
            9 => 'b.bonificacion',
            10 => 'b.fechaPago',
            11 => 'b.tipo',
        );
        var $column_search = array(
            "b.id", 
            "b.idAltaVenta", 
            "b.bonificacion", 
            "b.fechaPago", 
            "b.idTipo", 
            "b.tipo", 
            "b.statusAutorizado", 
            "b.fechaAutorizado", 
            "CONCAT(pros.nombre,' ',pros.apellidoP,' ',pros.apellidoM)", 
            "f.titulo",
            "proy.lineaCredito",
            "proy.manzana",
            "proy.lote",
            "proy.precioVenta",
            "(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = av.id)",
        );
        var $order = array('b.id' => 'desc'); // default order
        var $info;
        var $query="";
        // Fin variables para server side

        public function __construct(){
            parent :: __construct();
            $this->table = "bonificaciones";
            $this->alias = 'b';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".bonificacion
            ,".$this->alias.".fechaPago
            ,".$this->alias.".idTipo
            ,".$this->alias.".tipo
            ,".$this->alias.".statusAutorizado
            ,".$this->alias.".fechaAutorizado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'bonificacion' => '',
                'fechaPago' => '',
                'idTipo' => '',
                'tipo' => '',
                'statusAutorizado' => '',
                'fechaAutorizado' => '',
                'status' => '',
                'txtstatus' => ''
            );
            
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['bonificacion'] = $r->row()->bonificacion;
                $array['fechaPago'] = $r->row()->fechaPago;
                $array['idTipo'] = $r->row()->idTipo;
                $array['tipo'] = $r->row()->tipo;
                $array['statusAutorizado'] = $r->row()->statusAutorizado;
                $array['fechaAutorizado'] = $r->row()->fechaAutorizado;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows() > 0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        ///////////Inician funciones de carga del lado del servidor///////////
        private function _get_datatables_query(){
            //Inicia query customizada
            $this->query = "";
            $id=$_SESSION['viv']['id'];
            $this->query="SELECT $this->selectDefault
            ,proy.lineaCredito AS 'linea'
            ,UPPER(CONCAT(pros.nombre,' ',pros.apellidoP,' ',pros.apellidoM)) AS 'cliente'
            ,UPPER(f.titulo) AS 'fraccionamiento'
            ,proy.manzana
            ,proy.lote
            ,proy.precioVenta
            ,(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = av.id) AS 'ronda'
            FROM $this->table AS $this->alias
            INNER JOIN alta_venta AS av ON  $this->alias.idAltaVenta = av.id
            INNER JOIN proyectos AS proy ON  proy.id = av.idProyecto
            INNER JOIN prospectos AS pros ON pros.id = av.idProspecto
            INNER JOIN fraccionamientos AS f ON f.id = proy.idFraccionamiento
            WHERE $this->alias.status = 1
                AND f.status = 1
                AND av.idProyecto > 0
                AND av.id IN (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = av.id AND statusEntrega = '1')
            ";
            if( $_SESSION['viv']['rol'] > 1 ){
                $this->query.=" AND av.idProyecto IN (SELECT id FROM proyectos WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario = $id) ) ";
            }

            //Adaptación genérica, no se modifica.
            $i=0;
            foreach ($this->column_search as $item){
               if( isset($_POST['search']['value']) && !empty($_POST['search']['value']) ) {
                    if($i===0){
                        $this->query.=" AND (".$item." LIKE '%".$_POST['search']['value']."%'";
                    }else{
                        $this->query.=" OR ".$item." LIKE '%".$_POST['search']['value']."%'";
                    }
                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->query.=")";
                }
                $i++;
            }

            //Llamando a la función que creará los filtros
            $this->createFilters();

            if(isset($_POST['order'])){
                if($this->info['statusAutorizado'] == 0){
                    $this->query.=" ORDER BY ".$this->column_order[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
                }else{
                    $this->query.=" ORDER BY ".$this->column_order2[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
                }
            }else if(isset($this->order)){
                $order = $this->order;
                $this->query.=" ORDER BY ".key($order)." ".$order[key($order)];
            }
            //Termina adaptación genérica
        }

        function get_datatables(){
            $this->info=$_REQUEST["info"];
            $this->_get_datatables_query();
            if( isset($_POST['length']) && $_POST['length'] != -1)
            $this->query.=" LIMIT ".$_POST['start'].",".$_POST['length'];
            $this->query = $this->db->query($this->query);
            if($this->query->num_rows() > 0){
                return $this->query;
            }else{
                return 0;
            }
        }

        function count_filtered(){
            $this->_get_datatables_query();
            $this->query = $this->db->query($this->query);
            return $this->query->num_rows();
        }

        public function count_all(){
            $this->_get_datatables_query();
            $this->query = $this->db->query($this->query);
            return $this->query->num_rows();
        }

        //Función para filtros automáticos
        public function createFilters(){
            foreach ($this->info as $key => $val) {
                if( $val != "" ){
                    switch($key){
                        case 'fecha_inicio': 
                            $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                            break;
                        case 'fecha_fin': 
                            $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                            if ($fecha_inicio != "" && $fecha_fin != "") {
                                if($fecha_inicio != $fecha_fin){
                                    $this->query.=" AND $this->alias.fechaPago >= '$fecha_inicio' AND $this->alias.fechaPago <= '$fecha_fin' + INTERVAL 1 DAY ";
                                }else{
                                    $this->query.=" AND DATE($this->alias.fechaPago) = DATE('$fecha_inicio') ";
                                }
                            }
                            break;
                        case 'statusAutorizado':
                                $this->query.=" AND $this->alias.statusAutorizado = $val";
                            break;
                        default: $this->query.=" AND $this->alias.{$key} = {$val} ";
                            break;
                    }
                }
            }
            //echo $this->query;
            //exit();
        }

        ////////////Terminan de carga del del lado del servidor////////////
        function getAllExcelRows($status){
            $id=$_SESSION['viv']['id'];
            $fechaAutorizado = ( $status )? ",DATE_FORMAT(b.fechaAutorizado, '%d/%m/%Y') AS 'fechaAutorizado'": "";
            $this->query = "";
            $this->query = "SELECT IF($this->alias.statusAutorizado > 0, 'PAGADO','POR AUTORIZAR')  AS 'status'
            $fechaAutorizado
            ,proy.lineaCredito AS 'linea'
            ,UPPER(CONCAT(pros.nombre, ' ', pros.apellidoP, ' ', pros.apellidoM)) AS 'cliente'
            ,UPPER(f.titulo) AS 'fraccionamiento'
            ,CONCAT('$', proy.precioVenta) AS 'precio'
            ,(SELECT ronda FROM gestoria WHERE gestoria.idAltaVenta = av.id) AS 'ronda'
            ,proy.manzana
            ,proy.lote
            ,CONCAT('$', $this->alias.bonificacion) AS 'bonificacion'
            ,DATE_FORMAT(b.fechaPago, '%d/%m/%Y') AS 'fechaPago'
            ,UPPER(b.tipo) AS 'tipo'
            FROM $this->table AS $this->alias
            INNER JOIN alta_venta AS av ON  $this->alias.idAltaVenta = av.id
            INNER JOIN proyectos AS proy ON  proy.id = av.idProyecto
            INNER JOIN prospectos AS pros ON pros.id = av.idProspecto
            INNER JOIN fraccionamientos AS f ON f.id = proy.idFraccionamiento
            WHERE $this->alias.status = 1
                AND f.status = 1
                AND av.idProyecto > 0
                AND av.id IN (SELECT idAltaVenta FROM entrega WHERE entrega.idAltaVenta = av.id AND statusEntrega = '1')
                AND $this->alias.statusAutorizado = $status
            ";
            if( $_SESSION['viv']['rol'] > 1 ){
                $this->query.=" AND av.idProyecto IN (SELECT id FROM proyectos WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario = $id) ) ";
            }
            $this->query.="ORDER BY $this->alias.id DESC";
            $query = $this->db->query($this->query);
            if($query->num_rows() > 0){
                return $query;
            }else{
                return 0;
            }
        }
    }