<?php

    class mavaluoproyecto extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "avaluos_proyectos";
            $this->alias = 'ap';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAvaluo
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idProspecto
            ,".$this->alias.".fechaAsignacion
            ,".$this->alias.".fechaDesasignacion
            ,".$this->alias.".statusAsignacion
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAvaluo' => '',
                'idProyecto' => '',
                'idProspecto' => '',
                'fechaAsignacion' => '',
                'fechaDesasignacion' => '',
                'statusAsignacion' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAvaluo'] = $r->row()->idAvaluo;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idProspecto'] = $r->row()->idProspecto;
                $array['fechaAsignacion'] = $r->row()->fechaAsignacion;
                $array['fechaDesasignacion'] = $r->row()->fechaDesasignacion;
                $array['statusAsignacion'] = $r->row()->statusAsignacion;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdAvaluo($id=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAvaluo' => $id);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdProyectoProspecto($idProyecto=NULL,$idProspecto=NULL){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $idProyecto,$this->alias.'.idProspecto' => $idProspecto, $this->alias.'.statusAsignacion' => 1);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }   
        }

        function getByIdAvaluoActivo($id=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAvaluo' => $id, $this->alias.'.statusAsignacion' => 1);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdAvaluoInactivo($id=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAvaluo' => $id, $this->alias.'.statusAsignacion' => 0);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }