<?php
    class mautenticacion extends MY_Model{
public function __construct(){
            parent :: __construct();
            $this->table = "autenticacion";
            $this->alias = 'a';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idProspecto
            ,".$this->alias.".token
            ,".$this->alias.".expired_at
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idProspecto' => '',
                'token' => '',
                'expired_at' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idProspecto'] = $r->row()->idProspecto;
                $array['token'] = $r->row()->token;
                $array['expired_at'] = $r->row()->expired_at;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        
        function getByIdProspectoToken($idProspecto, $token){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idProspecto' => $idProspecto, $this->alias.'.token' => $token);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
        
        function getLastLoginByIdProspecto($idProspecto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idProspecto' => $idProspecto);
            $this->db->where($arrayWhere);
            $this->db->limit(1);
            $this->db->order_by($this->alias.'.expired_at', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
    }