<?php

    class majustes extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "ajustes";
            $this->alias = 'a';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".cantidad
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".tipo
            ,".$this->alias.".tipoPpto
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idPresupuesto' => '',
                'cantidad' => '',
                'precioUnitario' => '',
                'tipo' => '',
                'tipoPpto' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['cantidad'] = $r->row()->cantidad;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['tipo'] = $r->row()->tipo;
                $array['tipoPpto'] = $r->row()->tipoPpto;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }