<?php
class mactivos extends MY_Model{

	public function __construct(){
		parent :: __construct();
		$this->table = "activos";
        $this->alias = 'a';

        $this->selectDefault = "".
            $this->alias.".id
        ,".$this->alias.".idActivo
        ,".$this->alias.".idCategoria
        ,".$this->alias.".disponible
        ,".$this->alias.".descripcion
        ,".$this->alias.".inventarioInterno
        ,".$this->alias.".serie
        ,".$this->alias.".marca
        ,".$this->alias.".modelo
        ,".$this->alias.".anio
        ,".$this->alias.".placas
        ,".$this->alias.".vigenciaPoliza
        ,".$this->alias.".diasMantenimiento
        ,".$this->alias.".pdf_1
        ,".$this->alias.".pdf_2
        ,".$this->alias.".pdf_3
        ,".$this->alias.".created
        ,".$this->alias.".created_by
        ,".$this->alias.".status
        ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
	}

    private function _populateValues($r)
    {
        $array = array(
            'id' => '',
            'idActivo' => '',
            'idCategoria' => '',
            'disponible' => '',
            'descripcion' => '',
            'inventarioInterno' => '',
            'serie' => '',
            'marca' => '',
            'modelo' => '',
            'anio' => '',
            'placas' => '',
            'vigenciaPoliza' => '',
            'diasMantenimiento' => '',
            'pdf_1' => '',
            'pdf_2' => '',
            'pdf_3' => '',
            'created' => '',
            'created_by' => '',
            'status' => '',
            'txtstatus' => ''
        );

        if (!is_numeric($r)) {
            $array['id'] = $r->row()->id;
            $array['idActivo'] = $r->row()->idActivo;
            $array['idCategoria'] = $r->row()->idCategoria;
            $array['disponible'] = $r->row()->disponible;
            $array['descripcion'] = $r->row()->descripcion;
            $array['inventarioInterno'] = $r->row()->inventarioInterno;
            $array['serie'] = $r->row()->serie;
            $array['marca'] = $r->row()->marca;
            $array['modelo'] = $r->row()->modelo;
            $array['anio'] = $r->row()->anio;
            $array['placas'] = $r->row()->placas;
            $array['vigenciaPoliza'] = $r->row()->vigenciaPoliza;
            $array['diasMantenimiento'] = $r->row()->diasMantenimiento;
            $array['pdf_1'] = $r->row()->pdf_1;
            $array['pdf_2'] = $r->row()->pdf_2;
            $array['pdf_3'] = $r->row()->pdf_3;
            $array['created'] = $r->row()->created;
            $array['created_by'] = $r->row()->created_by;
            $array['status'] = $r->row()->status;
            $array['txtstatus'] = $r->row()->txtstatus;

        }
            $array['msg'] = '';
        return $array;
    }

	function getById($id){
        $this->db->select($this->selectDefault, FALSE);
        $arrayWhere = array($this->alias.'.id' => $id);
        $this->db->where($arrayWhere);
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $this->_populateValues($query);
        }else {
            return 0;
        }
	}

    function getAll($idActivo=0){
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        if($idActivo>0){
            $this->db->where($this->alias.'.idActivo =', $idActivo);
        }
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getActivos($id=-1){
        $query="SELECT id,IF(idActivo=1 OR idActivo=2,CONCAT(descripcion,'(',inventarioInterno,')'),CONCAT(marca,' ',modelo,'(',inventarioInterno,')')) AS titulo FROM activos WHERE status=1";
        if($id!=-1){
            $query.=" AND disponible=".$id;
        }
        $query=$this->db->query($query);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getActivo($idActivo=0){
        $query="SELECT id,IF(idActivo=1 OR idActivo=2,CONCAT(descripcion,'(',inventarioInterno,')'),CONCAT(marca,' ',modelo,'(',inventarioInterno,')')) AS titulo FROM activos WHERE id=$idActivo";//status=1 AND
        $query=$this->db->query($query);
        if($query->num_rows()>0){
            $query=$query->row();
            return $query->titulo;
        }else{
            return 0;
        }
    }

}