<?php if ( ! defined('BASEPATH')) exit('No se permite el acceso directo al script');

class SubirArchivo {
/*
    Creacion: 04/11/16 ^-^
    Vercion : 1.0 _(*-*_)
    V codeigniter: 3.1.2 \(*-*)/
//---------------------------------
//|  El dominio total del mundo!! |
//---------------------------------
//     \    /
//      \  /
//       \/
//.......(\_/)
//......( ='_'=)
//..../""""""""""""======---|>
///"""""""""""""""""""
//_@_@_@_@_@_@_@_@_@_/
  @author  Pedro Pinto // pedro.m.pinto.c@gmail.com
*/
    //se obtien CI como instancia
	public function __construct()
    {
		$this->CI =& get_instance();
    }
/*
    parametros requeridos (algunos ya se inicializan con algún valor):
    @files      | array | Obligatorio | variable $_FILES
    @id         | int   | Obligatorio | id que del registro nuevo o existente
    @ruta       | text  | Obligatorio | dirección física donde se guardara el archivo
    @formatos   | text  | Opcional    | formatos permitidos
    @max_size   | int   | Opcional    | peso maximo del archivo en KB
    @width      | int   | Opcional    | altura maxima de la foto en PX
    @height     | int   | Opcional    | anchura maxima de la foto en PX
    @widthT     | int   | Opcional    | altura definida para el thumbnail en PX
    @heightT    | int   | Opcional    | anchura definida para el thumbnail en PX
*/
    function subirFoto($files='foto',$id='0',$ruta='',$formatos='gif|jpg|png',$max_size=500,$width=1920,$height=1080,$widthT=150,$heightT=150){
        //se inicializa la variable a retornar
        $imgData = 'Selecciona una imagen.';

        $config=array();
        //se cargan las librerias
        $this->CI->load->library('upload', $config);
        $this->CI->load->library('image_lib');


        $imagenes = array();
        //se comprueba que se recibio un array
        if(is_array($files)){
            //se obtiene el numero de archivos
            foreach($files as $key=>$value){
                if ($files[$key]['size'] > 0){
                    $files[$key]['name'] = strtolower($files[$key]['name']);
                    $imagenes[] = $key;
                }
            }
            $totalImagenes = count($imagenes);
            //se sobreescribe la variable a retornar y se prepara el array
            if($totalImagenes>0){
                $imgData = array();
            }
            for($i=0; $i< $totalImagenes; $i++){
                //opteniendo extencion del archivo
                $ext = pathinfo($files[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                //se crea el nombre unico para el archivo
                $file_name = "foto_".$id."_".$i;

                //parametros de configuracion
                $config['upload_path']      = $ruta;
                $config['allowed_types']    = $formatos;
                $config['file_name']        = $file_name;
                $config['overwrite']        = TRUE;
                $config['max_size']         = $max_size;
                $config['max_width']        = $width;
                $config['max_height']       = $height;

                //se inicializa upload
                $this->CI->upload->initialize($config);

                //nombre de la imagen guradada en el array imagenes
                if ( ! $this->CI->upload->do_upload($imagenes[$i]))
                {
                    $error = $this->CI->upload->display_errors();
                    $imgData = $error;
                    //$this->CI->load->view('upload_form', $error);
                }
                else
                {
                    $data = array();
                    //parametros de configuracion del thumbnail
                    $configT['upload_path'] = $ruta;
                    $configT['image_library']   = 'gd2';
                    //se crea el nombre del thumbnail
                    $nameT = $file_name."_thumb.".$ext;
                    //se pasa la ruta de la imagen original que se redimencionara
                    $configT['source_image']    = $ruta.$file_name.".".$ext;
                    $configT['create_thumb']    = TRUE;
                    $configT['maintain_ratio']  = FALSE;
                    $configT['width']           = $widthT;
                    $configT['height']          = $heightT;

                    //se limpia la configuracion
                    $this->CI->image_lib->clear();
                    //se inicializa el thumbnail
                    $this->CI->image_lib->initialize($configT);
                    //se redimienciona y se crea el thumbnail
                    $this->CI->image_lib->resize();
                    //success
                    $imgData[$imagenes[$i]]['foto'] = $file_name.".".$ext;
                    $imgData[$imagenes[$i]]['thumbnail'] = $nameT;
                }
            }

        }else{
            //si no es un array retorna error
            $imgData = 'Selecciona una imagen.';
        }
        //se retorna el resultado
        return $imgData;
   }
}

?>