<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rtest extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rtest'; // form validation variable
            $this->mainView = 'rtest';
            $this->data['fjs'] = '';
            $this->data['js'] = '<script src="assets/js/rtest/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto', 'musuario', 'mrtest', 'mfraccionamiento', 'mprototipos', 'mconstructores', 'mpaquete', 'mestimacionprograma', 'mestimacionesprograma', 'mestimadosprograma', 'mpresupuestomo', 'mactividadesprototipo', 'mactividadmo', 'mavanceobra', 'mordenpago', 'mdetalleop', 'mcategoriamo', 'mmaterialesactividadprototipo', 'mmaterial', 'mpresupuestomat', 'mordencompra', 'mdetalleorden', 'mmateriales', 'munidades', 'mproveedor', 'mareamaterial', 'mmaterialesactividadprototipo', 'mmanoobra', 'mprototipoxfraccionamiento', 'mdetallepaquete'));

            // Lbrerias
            $this->load->library('csvimport');
            // $this->load->library(array('email','session'));
            // $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

           // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("ventas",$this->fv);
    }

	public function index()
	{
		$data['q'] = '';
        $data['fraccionamientos']=$this->mfraccionamiento->getAll();
        $data['prototipos']=array();
        $data['constructores']=$this->mconstructores->getAll();
        $data['residentes']=$this->musuario->getResidenteObraBySelectResult();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $list = $this->mrtest->get_datatables();

        if(!is_numeric($list)){
            foreach ($list->result() as $row) {
                $detPack = $this->mdetallepaquete->getByIdPaquete($row->id);
                $qManoObra = $this->mmanoobra->getById($row->idManoObra);
                //inicia listado
                $array[] = array(
                    'id' => createLink("paquetes/editar/".$row->id,$row->id,"","","_blank"),
                    'paquete' => createLink($this->mainView . "/detalles/" . $row->id,$row->titulo,"","","_blank"),
                    'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$qManoObra['idFraccionamiento']),
                    'prototipo' => $this->mprototipos->getCampo("nombre",$qManoObra['idPrototipo']),
                    'constructor' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)",$row->idConstructor),
                    'nLotes' => $row->lotes,
                    //'rango_lotes' => $row->rango_lotes,
                    'fecha_inicio' => date_format(New DateTime($row->fecha_inicio),"d-m-Y"),
                    'fecha_fin' => date_format(New DateTime($row->fecha_fin),"d-m-Y"),
                    'statusPaquete' => getStatusPaquete($row->statusPaquete),
                    //'acciones' => ""
                );
            }
        }else{
            $array[] = array(
                'id' => "No hay registros",
                'paquete' => "No hay registros",
                'fraccionamiento' => "No hay registros",
                'prototipo' => "No hay registros",
                'constructor' => "No hay registros",
                'nLotes' => "No hay registros",
                //'rango_lotes' => "No hay registros",
                'fecha_inicio' => "No hay registros",
                'fecha_fin' => "No hay registros",
                'statusPaquete' => "No hay registros",
                //'acciones' => "No hay registros"
            );
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mrtest->count_all(),
                        "recordsFiltered" => $this->mrtest->count_filtered(),
                        "data" => $array,
                );
        //output to json format
        echo json_encode($output);
    }

    public function detalles($id = null){
        $data['totalUMO'] = precio_format(0);
        $data['totalUMat'] = precio_format(0);
        $ordenesPO = array();
        $ordenesCom = array();
        $totalU = 0;
        $totalMO = 0;
        $totalMat = 0;
        $totalM = 0;
        $totalPMat = 0;
        $totalPMO = 0;
        $totalUnitario = 0;
        $retencion = 0;
        $retenVicios = 0;
        $retenTotal = 0;
        $numSemana = 'Ninguno';
        $porcentReal = 0;
        $porcentProg = 0;
        $qPaquete = $this->mpaquete->getById($id);
        if(!is_numeric($qPaquete)){
            $detPack = $this->mdetallepaquete->getByIdPaquete($id);
            $qManoObra = $this->mmanoobra->getbyId($qPaquete['idManoObra']);
            $data['paquete'] = $qPaquete['titulo'];
            $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']);
            $data['prototipo'] = $this->mprototipos->getCampo('nombre', $qManoObra['idPrototipo']);
            $data['lotes'] = (!is_numeric($detPack))? $detPack->num_rows() : 0;
            $qOrdenesP = $this->mordenpago->getAllPagadoFracturadoByIdPaquete($qPaquete['id']);
            if(!is_numeric($qOrdenesP)){
                foreach ($qOrdenesP->result() as $ordenP) {
                    $precioU = 0;
                    $importe = 0;
                    $lotes = 0;
                    $arrLotes = array();
                    switch ($ordenP->statusPago) {
                        case 1:
                            $statusP = 'Pendiente por pagar';
                            break;
                        case 2:
                            $statusP = 'Pagado';
                            break;
                        case 3:
                            $statusP = 'Facturado';
                            break;
                        case 4:
                            $statusP = 'Cancelado';
                            break;
                        default:
                            $statusP = '';
                            break;
                    }
                    $qDetallesOP = $this->mdetalleop->getAllByIdOrdenPago($ordenP->id);
                    foreach ($qDetallesOP->result() as $detalleOp) {
                        $porcentTem = 0;
                        $ltA = explode(',', $detalleOp->lotes);
                        foreach ($ltA as $lots) {
                            if(!empty($lots) && !in_array($lots, $arrLotes)){
                                $arrLotes[$lots] = $lots;
                                $lotes = $lotes + 1;
                            }
                        }
                        $pctjeActividad = $this->mpresupuestomo->getCampo('pctjeActividad', $detalleOp->idPresupuesto);
                        if(is_numeric($pctjeActividad)){
                            $porcentTem = ($pctjeActividad * contarLotes($detalleOp->lotes)) / $data['lotes'];
                        }
                        $precioU = $precioU + $detalleOp->precioUnitario;
                        $porcentReal = $porcentReal + $porcentTem;
                    }
                    $semana = $this->mestimacionesprograma->getCampo('nEstimacion', $ordenP->idEstimaciones);
                    $retencion = $retencion + $ordenP->retencion;
                    $retenVicios = $retenVicios + $ordenP->retencionvicios;
                    $retencionT = $ordenP->retencion + $ordenP->retencionvicios;
                    $importe = $ordenP->monto - $retencion;
                    $ordenesPO[] = array('id' => createLink("paquetes/verOrden/".$ordenP->id,$ordenP->id,"","","_blank"),
                        'semana' => (!empty($semana) && !is_null($semana))? $semana : '',
                        'fecha' => (!empty($ordenP->fechaAplicado) && !is_null($ordenP->fechaAplicado))? $ordenP->fechaAplicado : '',
                        'statusPago' => $statusP,
                        'lotes' => $lotes,
                        'totalU' => precio_format($precioU),
                        'subtotal' => precio_format($ordenP->monto),
                        'retencion' => precio_format($ordenP->retencion),
                        'retencionV' => precio_format($ordenP->retencionvicios),
                        'retencionT' => precio_format($retencionT),
                        'porPagar' => precio_format($importe)
                    );
                    $totalMO = $totalMO + $ordenP->monto;
                    $retenTotal = $retenTotal + $retencionT;
                }
            }
            else{
                $ordenesPO[] = array('id' => 'No hay registros',
                    'semana' => 'No hay registros',
                    'fecha' => 'No hay registros',
                    'statusPago' => 'No hay registros',
                    'lotes' => 'No hay registros',
                    'totalU' => 'No hay registros',
                    'subtotal' => 'No hay registros',
                    'retencion' => 'No hay registros',
                    'retencionV' => 'No hay registros',
                    'retencionT' => 'No hay registros',
                    'porPagar' => 'No hay registros'
                );
            }
            if(!is_numeric($qManoObra)){
                $totalU = $this->mpresupuestomo->getSumTotalUnitario($qManoObra['id']);
                $data['totalUMO'] = precio_format($totalU);
                $totalPMO = $totalPMO + ($data['lotes'] * $totalU);
                $qEstimacion = $this->mestimacionprograma->getByIdPaquete($qPaquete['id']);
                $pctAT = $this->mpresupuestomo->getSumTotalPorcentaje($qManoObra['id']);
                if(!is_numeric($qEstimacion)){
                    $qEstimaciones = $this->mestimacionesprograma->getByIdEstimacion($qEstimacion['id']);
                    if(!is_numeric($qEstimaciones)){
                        foreach($qEstimaciones->result() as $esti){
                            $fecha_fin = new DateTime($esti->fecha);
                            $intervalo = new DateInterval('P6D');
                            $fecha_fin->add($intervalo);
                            if($esti->fecha <= date('Y-m-d')){
                                $idEstis[$esti->id] = $esti->id;
                                if($fecha_fin->format('Y-m-d') >= date('Y-m-d') && $esti->fecha <= date('Y-m-d')){
                                    $numSemana = $esti->nEstimacion;
                                }
                            }
                        }
                        $qEstimados = $this->mestimadosprograma->getAllInIdEstimaciones($idEstis);
                        if(!is_numeric($qEstimados)){
                            foreach($qEstimados->result() as $esdos){
                                $temLots = $esdos->estimacion;
                                if($temLots > 0){
                                    $porcentTem = 0;
                                    $pctjeActividad = $this->mpresupuestomo->getCampo('pctjeActividad', $esdos->idPresupuesto);
                                    if(is_numeric($pctjeActividad)){
                                        $porcentTem = ($pctjeActividad * $temLots) / $data['lotes'];
                                    }
                                    $porcentProg = $porcentProg + $porcentTem;
                                }
                            }
                        }
                    }
                }
            }
            $qMaterial = $this->mmaterial->getbyIdManoObra($qPaquete['idManoObra']);
            if(!is_numeric($qMaterial)){
                $qOrdenesC = $this->mordencompra->getAllByIdPaquete($qPaquete['id']);
                if(!is_numeric($qOrdenesC)){
                    foreach ($qOrdenesC->result() as $ordenC) {
                        $precioU = $this->mdetalleorden->getPrecioUnitarioByIdOrden($ordenC->id);
                        $importe = $this->mdetalleorden->getImporteByIdOrden($ordenC->id);
                        $ordenesCom[] = array('id' => createLink("orden_compra/ver/".$ordenC->id,$ordenC->id,"","","_blank"),
                            'semana' => $this->mdetalleorden->getSemanaByIdOrden($ordenC->id),
                            'fecha' => (!empty($ordenC->fecha) && !is_null($ordenC->fecha))? $ordenC->fecha : '',
                            'cantidad' => $this->mdetalleorden->getCantidadByIdOrden($ordenC->id),
                            'totalU' => precio_format($precioU),
                            'importe' => precio_format($importe)
                        );
                        $totalMat = $totalMat + $importe;
                    }
                }
                else{
                    $ordenesCom[] = array('id' => 'No hay registros',
                        'semana' => 'No hay registros',
                        'fecha' => 'No hay registros',
                        'cantidad' => 'No hay registros',
                        'totalU' => 'No hay registros',
                        'importe' => 'No hay registros'
                    );
                }
                $totalUnitario = $this->mpresupuestomat->getSumTotalUnitario($qMaterial['id']);
                $data['totalUMat'] = precio_format($totalUnitario);
                $totalU = $totalU + $totalUnitario;
                $totalPMat = $totalPMat + ($data['lotes'] * $totalUnitario);
            }

        }
        $totalG = $totalPMO + $totalPMat;
        $totalMG = $totalMO + $totalMat;
        $data['id'] = $id;
        $data['ordenesPO'] = $ordenesPO;
        $data['ordenesCom'] = $ordenesCom;
        $data['semana'] = $numSemana;
        $data['totalU'] = precio_format($totalU);
        $data['totalMat'] = precio_format($totalMat);
        $data['totalMO'] = precio_format($totalMO);
        $data['totalMO2'] = precio_format($totalMO - $retenTotal);
        $data['totalM'] = precio_format($totalMG);
        $data['totalG'] = precio_format($totalG);
        $data['totalPMO'] = precio_format($totalPMO);
        $data['totalPMat'] = precio_format($totalPMat);
        $data['pendiMO'] = precio_format($totalPMO - $totalMO);
        $data['pendiMat'] = precio_format($totalPMat - $totalMat);
        $data['retencion'] = precio_format($retencion);
        $data['retenVicios'] = precio_format($retenVicios);
        $data['retenTotal'] = precio_format($retenTotal);
        $data['porcentReal'] = ($pctAT == $porcentReal)? '%100' : '%' . number_format((($porcentReal)), 2);
        $data['porcentRest'] = ($pctAT == $porcentReal)? '%0' : '%' . number_format((($porcentProg - $porcentReal)), 2);
        $data['porcentProg'] = ($pctAT == $porcentProg)? '%100' : '%' . number_format((($porcentProg)), 2);
        $this->data['contenido'] = $this->load->view($this->mainView . '/detalles_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }
}
