<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');
	class Rgerente extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'rgerente'; // form validation variable
			$this->mainView = 'rgerente';
			$this->data['fjs'] = '';
            $this->data['js'] = '
                    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
                    <script src="assets/js/rgerente/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
                                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.1.3/css/fixedHeader.dataTables.min.css">';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mproyecto','musuario','mprototipoxfraccionamiento','mfraccionamientoxusuario','mprototipos'));

			// Lbrerias
			// $this->load->library(array('email','session'));
			// $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

           //Validación de usuarios
		   valSession("ventas",$this->fv);
		}

		public function index(){
    		$data['q'] = '';
    		$data['prototipos'] = $this->mprototipoxfraccionamiento->getAll();
            $data['prototipos_'] = $this->mprototipos->getAll();
    		$promotores = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($_SESSION['viv']['idFraccionamiento']);
    		$pData = array();
    		foreach ($promotores->result() as $row) {
    			$data['promotores'][$row->id] = $this->musuario->getCampo("nombre",$row->id)." ".$this->musuario->getCampo("apellidoP",$row->id);
    		}
            $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
            $this->load->view('templates/main_template',$this->data);
    	}

    	public function listado() {
    		$r['idPrototipo'] = $_REQUEST['idPrototipo'];
	        $r['statusProyecto'] = $_REQUEST['statusProyecto'];
	        $r['fecha_inicio'] = $_REQUEST['fecha_inicio'];
	        $r['fecha_fin'] = $_REQUEST['fecha_fin'];
	        $r['lineaCredito'] = $_REQUEST['lineaCredito'];
	        $r['promotor'] = $_REQUEST['promotor'];

    		$q = $this->mproyecto->inventarioGerente($r);

    		if ( !is_numeric($q) ) {
    			foreach ($q->result() as $row) {
    				$array['aaData'][] = array(
    					"titulo" => $row->id,
    					"manzana" => $row->manzana,
    					"nOficial" => $row->nOficial,
    					"calle" => $row->calle,
    					"numPaquete" => $row->numPaquete,
    					"cuv" => $row->cuv,
    					"claveCatastral" => $row->claveCatastral,
    					"supTerreno" => $row->supTerreno,
    					"supConstruccion" => $row->supConstruccion,
                        // "prototipo" => $row->idPrototipo,
    					"prototipo" => $this->mprototipos->getCampo("nombre",$row->idPrototipo),
    					"precioVenta" => $row->precioVenta,
    					"puntaje" => $row->puntaje,
    					"statusProyecto" => $row->statusProyecto,
    					"porcentajeAvance" => $row->porcentajeAvance,
    					"fechaDtu" => $row->fechaDtu,
    					"fechaVencimiento" => $row->fechaVencimiento,
    					"contratista" => $row->contratista,
    					"avaluo" => $row->avaluo,
    					"unidadVerificadora" => $row->unidadVerificadora,
    					"lineaCredito" => $row->lineaCredito,
    					"statusProRep" => estatus_proyecto_reporte($row->statusVenta),
    					"nomPromotor" => ($row->idProspecto != NULL ? $this->musuario->getCampo("nombre",$row->idProspecto)." ".$this->musuario->getCampo("apellidoP",$row->idProspecto) : 'Sin promotor')
    				);
    			}
    		}
    		else {
    			$array['aaData'][] = array(
					"titulo" => 'No hay registros',
					"manzana" => 'No hay registros',
					"nOficial" => 'No hay registros',
					"calle" => 'No hay registros',
					"numPaquete" => 'No hay registros',
					"cuv" => 'No hay registros',
					"claveCatastral" => 'No hay registros',
					"supTerreno" => 'No hay registros',
					"supConstruccion" => 'No hay registros',
					"prototipo" => 'No hay registros',
					"precioVenta" => 'No hay registros',
					"puntaje" => 'No hay registros',
					"statusProyecto" => 'No hay registros',
					"porcentajeAvance" => 'No hay registros',
					"fechaDtu" => 'No hay registros',
					"fechaVencimiento" => 'No hay registros',
					"contratista" => 'No hay registros',
					"avaluo" => 'No hay registros',
					"unidadVerificadora" => 'No hay registros',
					"lineaCredito" => 'No hay registros',
					"statusProRep" => 'No hay registros',
					"nomPromotor" => 'No hay registros'
				);
    		}
    		echo json_encode($array);
    	}
	}
?>