<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restimacion extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'restimacion'; // form validation variable
            $this->mainView = 'restimacion';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/restimacion/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mconstructores','mop_detalle','mprototipos','mconstructores','mfraccionamiento','mcortes','mpaquete','mmovimientos'));
            valSession("obra",$this->fv);
    }

    public function index(){
		$data['q'] = '';
		$data['texto'] = '';
		$data['corteActual']=$this->mcortes->getCorteActual();
		$data['constructores']=$this->mconstructores->getSelectResult();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

	public function exportar(){
		$filter="";
		if(COUNT($_POST)>0){
			$info=$_POST;
			if($info["ano"] > 0){
                $filter.=" AND YEAR(opd.fecha)=".$info["ano"];
            }
			if($info["semana"] > 0){
                $filter.=" AND WEEK(opd.fecha,7)=".$info["semana"];
            }
            if($info["constructor"] > 0){
                $filter.=" AND opd.idConstructor=".$info["constructor"];
            }
			if($info["tipoLote"] > 0){
                $filter.=" AND opd.tipoLote=".$info["tipoLote"];
            }
            if ($info['fecha_inicio'] != "" && $info['fecha_fin']  != "") {
                $fecha_inicio = date_format(new DateTime($info['fecha_inicio']),"Y-m-d");
                $fecha_fin = date_format(new DateTime($info['fecha_fin']),"Y-m-d");
                if($fecha_inicio != $fecha_fin){
                    $filter.=" AND DATE(opd.fecha) >= DATE('$fecha_inicio') AND DATE(opd.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                }else{
                    $filter.=" AND DATE(opd.fecha) = DATE('$fecha_inicio') ";
                }
            }
		}
		$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
		$objPHPExcel->getActiveSheet()->setTitle('RESUMEN');
		$objPHPExcel->setActiveSheetIndex(0);

		$fInicio=1;
		$cInicio="A";

		$fracc = $this->db->query(
			"SELECT fr.id,fr.titulo FROM detalle_paquete dp
			LEFT JOIN paquetes paq ON paq.id=dp.idPaquete 
			LEFT JOIN arranque arr ON paq.id IN (arr.idPaquetes) 
			LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
			LEFT JOIN fraccionamientos fr ON fr.id=pro.idFraccionamiento
			WHERE arr.estatus_arranque = 2
			GROUP BY fr.id 
			ORDER BY fr.titulo"
		);
		$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,"CONTRATISTA");
		$coords=$this->createTable($objPHPExcel,$fracc, $fInicio,$cInicio,1,$filter,true);
		$fInicio=$coords["fInicio"];
		$fInicio=$fInicio+2;
		$objPHPExcel=$coords["objPHPExcel"];
		//complementaria
		$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,"COMPLEMENTARIA");
		$coords=$this->createTable($objPHPExcel,$fracc,$fInicio,"A",2,$filter);
		$fInicio=$coords["fInicio"];
		$fInicio=$fInicio+2;
		$objPHPExcel=$coords["objPHPExcel"];
		//URBANIZACION
		$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,"URBANIZACIÓN");
		$coords=$this->createTable($objPHPExcel,$fracc,$fInicio,"A",3,$filter);
		$fInicio=$coords["fInicio"];
		$fInicio=$fInicio+2;
		$objPHPExcel=$coords["objPHPExcel"];
		//URBANIZACION
		$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,"EXTRAS");
		$coords=$this->createTable($objPHPExcel,$fracc,$fInicio,"A",6,$filter);
		$objPHPExcel=$coords["objPHPExcel"];
		//totales
		$fInicio=$coords["fInicio"];
		$cInicio="B";
		if($fracc->num_rows() > 0){
			$fInicioTemp=$fInicio;
			$fInicio++;
			$fracc=array_merge($fracc->result_array(),$this->getColumns());
			foreach ($fracc as $row) {
				$objPHPExcel->getActiveSheet()->SetCellValue("$cInicio$fInicio","=SUM($cInicio"."2:$cInicio$fInicioTemp)");
				$cInicio++;;
			}
		}

		$name = 'RESUMEN';
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
		header('Cache-Control: max-age=0'); //no cache
		$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
		// Forzamos a la descarga
		$objWriter->save('php://output');
	}

	public function createTable($objPHPExcel,$fracc,$fInicio2,$cInicio,$tipoLote,$filter,$first=false){
		$info=$_POST;
		$ano=(isset($info["ano"])) ? $info["ano"] : 0;
		$semana=(isset($info["semana"])) ? $info["semana"] : 0;
		$fInicio=$fInicio2;
		//inicia armado de contratistas
		$cons=$this->getQuery("opd.tipoLote=$tipoLote ".$filter);

		if($cons->num_rows()>0){
			foreach ($cons->result() as $rowCons) {
				$fInicio++;
				$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,$rowCons->constructor);
			}
		}
		//armado de fraccionamientos
		$constructores=$cons->result_array();
		if($fracc->num_rows() > 0){
			$fraccs=$fracc->result_array();
			foreach ($fraccs as $rowFracc) {
				$cInicio++;
				$fInicio=$fInicio2;
				($first) ? $objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,$rowFracc["titulo"]) : "";
				//ARMADO POR 
				//if($rowFracc["id"] > 0){
					if(COUNT($constructores)>0){
						foreach ($cons->result() as $rowCons) {
							$fInicio=$fInicio+1;
							$idFracc=$rowFracc["id"];
							$consFracc=$this->getQuery("opd.idConstructor=$rowCons->idConstructor AND opd.idFraccionamiento=$idFracc AND opd.tipoLote=$tipoLote ".$filter);
							if($consFracc->num_rows() > 0){
								$consFracc=$consFracc->row();
								$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,$consFracc->importe);
							}else{
								$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,0);
							}
						}
					}
				//}
			}
			
		}
		//armado de totales
		$columns=$this->getColumns();
		$cInicioTemp=$cInicio;
		$fInicio=$fInicio2;
		if(COUNT($constructores)>0){
			if($first){
				for ($i=1; $i < COUNT($columns) + 1; $i++) { 
					$cInicio++;
					$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,$columns[$i]);
				}
			}
			$cInicio=$cInicioTemp;
			$fInicio++;
			foreach ($cons->result() as $rowCons) {
				for ($i=1; $i < COUNT($columns) + 1; $i++) { 
					($columns[$i] != "TOTAL") ? $cInicio++ : false;
					$valor="";
					switch ($columns[$i]) {
						case 'FG':
							$consFracc=$this->getQuery("opd.idConstructor=$rowCons->idConstructor AND opd.tipoLote=$tipoLote ".$filter);
							$valor="-".$consFracc->row()->fg;
							break;
						case 'PRESTAMOS':
							$mov=$this->mmovimientos->getByIdConstructorAndTipo($rowCons->idConstructor,$ano,$semana,1);
							$valor=(!is_numeric($mov)) ? $mov->row()->monto : 0;
							break;
						case 'AMORTIZACIONES':
							$mov=$this->mmovimientos->getByIdConstructorAndTipo($rowCons->idConstructor,$ano,$semana,3);
							$valor=(!is_numeric($mov)) ? $mov->row()->monto : 0;
							break;
						case 'RETENCIONES':
							$consFracc=$this->getQuery("opd.idConstructor=$rowCons->idConstructor AND opd.tipoLote=$tipoLote ".$filter);
							$mov=$this->mmovimientos->getByIdConstructorAndTipo($rowCons->idConstructor,$ano,$semana,7);
							$mov2=$this->mmovimientos->getByIdConstructorAndTipo($rowCons->idConstructor,$ano,$semana,8);
							$valor=(!is_numeric($mov)) ? "-".$mov->row()->monto : 0;
							$valor2=(!is_numeric($mov2)) ? "-".(($mov2->row()->monto/100)*$consFracc->row()->importe) : 0;
							$valor=$valor+$valor2;
							break;
						case 'TOTAL':
							$cTemp=$cInicio--;
							$valor="=SUM(B$fInicio:$cTemp$fInicio)";
							$cInicio++;
							break;			
					}
					$objPHPExcel->getActiveSheet()->SetCellValue($cInicio.$fInicio,$valor);
				}
				$fInicio++;
				$cInicio=$cInicioTemp;
			}
		}
		return ['fInicio'=>$fInicio,'cInicio'=>$cInicio,"objPHPExcel"=>$objPHPExcel];
	}

	public function getColumns($index=0){
		$columns=[
			1 =>"FG",
			2 =>"PRESTAMOS",
			3 =>"AMORTIZACIONES",
			4 =>"RETENCIONES",
			5 =>"TOTAL",
		];
		return ($index > 0) ? $columns[$index] : $columns;
	}

	public function getQuery($filter=""){
		$filter=($filter!="") ? "AND ".$filter : $filter;
		$constructor="CONCAT_WS(' ',cons.nombre,cons.apellidoP,cons.apellidoM) constructor";
		$cons=$this->db->query("SELECT opd.idConstructor, $constructor, 0 anticipos, 0 prestamos, SUM(opd.importe) importe, SUM(opd.fg) fg, SUM(opd.importe - opd.fg) total FROM op_detalle opd
		LEFT JOIN constructores cons ON cons.id=opd.idConstructor
		WHERE opd.status AND opd.calidad='A' $filter
		GROUP BY opd.idConstructor");
		return $cons;
	}

}


