<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class recepcion extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'recepcion'; // form validation variable
            $this->mainView = 'recepcion';
            $this->data['fjs'] = '';
            $this->data['js'] = ' 
                                 <script src="assets/js/recepcion/listado.js" type="text/javascript"></script>
                                 <script src="assets/js/recepcion/listadoVer.js" type="text/javascript"></script>
                                ';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproveedor','musuario','mempresas','mrecepcion','malmacenes','mdetallerecepcion'));
            $this->load->library('excel');
            $this->load->library("curl");
            valSession("materiales",$this->fv);
    }

    public function index(){
        $data['q'] = '';
     /*   $data['seccion'] = $this->uri->segment(1);*/
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function excel(){
              $q = $this->mrecepcion->getAllExcelRows();
       $columnas = array(
                    0 => 'ORDEN COMPRA',
                    1 => 'PROVEEDOR',
                    2 => 'ALMACEN',
                    3 => 'MONEDA',
                    4 => 'FECHA',
                    5 => 'FOLIO',
                    6 => 'IMPORTE',
                    7 => 'NO.ARTICULOS',
                    8 => 'FECHA ENTREGA',
                    9 => 'ESTATUS',
        );
       crearExcel($q,'recepcion',$columnas);
    }


    public function listado(){
        $list = $this->mrecepcion->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $recep) {
            $nomProveedor = $this->mproveedor->getCampo('nombre',$recep->id_proveedor);
            $nomAlmacen = $this->malmacenes->getCampo('nombre',$recep->id_almacen);
            $acciones = acciones($recep->id, $this->router->class, true,false,false);            
/*            $validar = true;
            $acciones = accionesrecepcion($proveedor->id, $this->router->class, false, false, false,false , false, true);*/
            $no++;
            $row = array();
            //$row[] = $no;
            $row[] = $acciones;
            $row[] = $recep->id_orden_compra; 
            $row[] = date_format(new DateTime($recep->fecha),'d/m/Y');
            $row[] = ($recep->folio != '' || $recep->folio != null)? $recep->folio:'';
            $row[] = ($nomProveedor != '' || $nomProveedor != null)?$nomProveedor:'';

            $row[] =  $nomAlmacen;
            $row[] = precio_format($recep->id_moneda);
            $row[] = ($recep->importe_neto !='' || $recep->importe_neto != null )?$recep->importe_neto :'' ;
            $row[] = $recep->numero_articulos;

            $row[] = ($recep->fecha_entrega !='')? date_format(new DateTime($recep->fecha_entrega),'d/m/Y') : '';
            $row[] = $recep->estatus;
            $data[] = $row;
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mrecepcion->count_all(),
                        "recordsFiltered" => $this->mrecepcion->count_filtered(),
                        "data" => $data,
                );
        echo json_encode($output);
  
    }

    public function exportarPpto($idProveedor){
/*        $proveedores = $this->mproveedor->getById($idProveedor);*/
        $exportar = false;
/*        if(!is_numeric($proveedores)){*/
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();/*
        echo '<pre>'; print_r($objPHPExcel); exit();*/
            $objPHPExcel->getActiveSheet()->setTitle('Proveedores');
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'RAZON SOCIAL');
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CLAVE');
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'RFC');
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'CIUDAD');
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'C.P.');
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'EMAIL');
            $q = $this->mproveedor->getAll();
            $rowCount = 2;
            foreach($q->result() as $row){
               $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row->nombre);
               $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->clave);
               $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->rfc);
               $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->cp);
               $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->cp);
                $rowCount++;
            }
 /*       if($exportar){*/
            $name = 'Proveedores';
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
            // Forzamos a la descarga
            $objWriter->save('php://output');
     /*   }*/
    }


    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';


        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['clave'] = $this->input->post('clave', TRUE);
            $pData['razonSocial'] = $this->input->post('razonSocial', TRUE);
            $pData['rfc'] = $this->input->post('rfc', TRUE);

            $pData['status'] = 1;
            $id = $this->mproveedor->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['clave'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                  $pData['clave'] = $this->input->post('clave', TRUE);
                  $pData['razonSocial'] = $this->input->post('razonSocial', TRUE);
                  $pData['rfc'] = $this->input->post('rfc', TRUE);
                  $pData['status'] =$this->input->post('status',TRUE);
                $this->mproveedor->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mproveedor->getById($id);

        $data = $info;
        $data['msg']=$msg;

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null){
        $data='';
        $info =  $this->mdetallerecepcion->getById($id);
        $data['id_recepcion'] = $info['id_recepcion'];
        $data['id_articulo'] = $info['id_articulo'];
        $data['clave_articulo'] = $info['clave_articulo'];
        $data['unidades'] = $info['unidades'];
        $data['precio_unitario'] = $info['precio_unitario'];
        $data['descuento_art'] = $info['descuento_art'];

        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function listadoVer()
    {
        
        $q = $this->mdetallerecepcion->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                'id_recepcion' => $row->id_recepcion,
                'id_articulo' => $row->id_articulo,
                'clave_articulo' => $row->clave_articulo,
                'unidades' => $row->unidades,
                'precio_unitario' => $row->precio_unitario,
                'descuento_art' => $row->descuento_art,
                );
            }
        } else{
            $array['aaData'][] = array(
                'id_recepcion' => 'No hay registros',
                'id_articulo' => 'No hay registros',
                'clave_articulo' => 'No hay registros',
                'unidades' => 'No hay registros',
                'precio_unitario' => 'No hay registros',
                'descuento_art' => 'No hay registros',
                );

        }
        echo json_encode($array);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mproveedor->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mproveedor->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function updateWS(){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $datos = json_encode(array("un" => 1));
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetProveedores",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['status'] = false;

        $json = [];
        if ($err) {
            echo "cURL Error #:" . $err;
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
              switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {   
                case 200:
                    $nInsert=0;
                    $nUpdate=0;

                        $json = json_decode($json);
                        foreach ($json->object_result as $row) {
                            foreach ($row as $key => $val){
                                switch ($key) {
                                    default:
                                        $data[$key]=$val;
                                }
                            }    
                            if($this->mproveedor->valInsert($data["id"])){
                                $this->mproveedor->insertar($data);
                                $nInsert++; 
                            }else if($this->mproveedor->valUpdate($row->id,$data)){
                                $this->mproveedor->actualizar($data,$data["id"]);
                                $nUpdate++;
                            }
                        }

                    echo "Insertados: ".$nInsert." <br> ";
                    echo "Actualizados: ".$nUpdate." <br> ";
                    curl_close($curl);
                    redirect($this->mainView);
                    break;
                case 404:
                    echo "Not found";
                    break;
                default:
                    echo 'Unexpected HTTP code: ', $http_code, "\n";
              }
            }
        }
    }

}


