<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Rcontado extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rcontado'; // form validation variable
            $this->mainView = 'rcontado';
            $this->data['fjs'] = '';
            $this->data['js'] = '<script src="assets/js/rcontado/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','form','date','text','security'));
            // Modelos
            $this->load->model(array('mrcontado','musuario', 'mfraccionamiento', 'mprospecto'));

            // Lbrerias
            $this->load->library('csvimport');
            $this->load->library('excel');

            valSession("ventas",$this->fv);
    }

	public function index()
	{
		$data['q'] = '';
        $fraccionamientos = $this->db->query("SELECT id, titulo FROM fraccionamientos WHERE status = 1");
        $data['fraccionamientos'] = ($fraccionamientos->num_rows() > 0) ? $fraccionamientos : 0;
        $promotores = $this->db->query("SELECT id, UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) AS titulo FROM usuarios WHERE rol = 2 AND status = 1");
        $data['promotores'] = ($promotores->num_rows() > 0) ? $promotores : 0;
        $manzanas = $this->db->query("SELECT manzana AS id, manzana AS titulo FROM proyectos GROUP BY manzana ORDER BY manzana ASC");
        $data['manzanas'] = ($manzanas->num_rows() > 0) ? $manzanas : 0;
        //$data['clientes'] = $this->mprospecto->getAllCron();
        $prototipos = $this->db->query("SELECT id, nombre AS titulo FROM prototipos WHERE status = 1");
        $data['prototipos'] = ($prototipos->num_rows() > 0) ? $prototipos : 0;
        $data['status'] = array(1 => 'EN TIEMPO', 2 => 'VENCIDO');
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $list = $this->mrcontado->get_datatables();

        if(!is_numeric($list)){
            foreach ($list->result() as $row) {

                $comprobante = 'NO HAY COMPROBANTE';
                if($row->comprobante != ''){
                    $ext = substr($row->comprobante, -4, 4);
                    $class = '';
                    $target = 'target="_blank"';
                    if($ext != '.pdf'){
                        $class = "magnificPopup";
                        $target = "";
                    }
                    $comprobante = '<a class="'.$class.'" href="'.base_url().'/uploads/contado_detalle/'.$row->comprobante.'" '.$target.'>';
                    if($ext != '.pdf'){
                        $comprobante .='   <center><img height="60" src="'.base_url().'/uploads/contado_detalle/'.$row->comprobante.'"><center/>';
                    }else{
                        $comprobante .='   <center><img height="60" src="'.base_url().'/uploads/contado_detalle/'.$row->comprobante.'" style="display:none"><i class="fa fa-eye" aria-hidden="true"></i><center/>';
                    }
                    $comprobante .='</a>';
                }

                $array[] = array(
                    'id' => $row->id,
                    'cliente' => $row->cliente,
                    'fraccionamiento' => $row->fraccionamiento,
                    'manzana' => $row->manzana,
                    'lote' => $row->lote,
                    'nOficial' => $row->nOficial,
                    'prototipo' => $row->prototipo,
                    'superficie' => $row->supTerreno,
                    'plazos' => $row->plazos,
                    'monto' => precio_format($row->monto),
                    'monto_' => $row->monto,
                    'importe' => precio_format($row->importe),
                    'importe_' => $row->importe,
                    'pagos' => precio_format($row->pagos),
                    'pagos_' => $row->pagos,
                    'saldo' => precio_format($row->saldo),
                    'saldo_' => $row->saldo,
                    'movimiento' =>$row->movimiento,
                    'comprobante' => $comprobante,
                    'statusDetalle' => strtoupper(statusDetalle($row->statusDetalle))
                );
            }
        }else{
            $array[] = array(
                'id' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'nOficial' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'superficie' => 'No hay registros',
                'plazos' => 'No hay registros',
                'monto' => 'No hay registros',
                'monto_' => 'No hay registros',
                'importe' => 'No hay registros',
                'importe_' => 'No hay registros',
                'pagos' => 'No hay registros',
                'pagos_' => 'No hay registros',
                'saldo' => 'No hay registros',
                'saldo_' => 'No hay registros',
                'movimiento' => 'No hay registros',
                'comprobante' => 'No hay registros',
                'statusDetalle' => 'No hay registros'
            );
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mrcontado->count_all(),
                        "recordsFiltered" => $this->mrcontado->count_filtered(),
                        "data" => $array,
                );
        //output to json format
        echo json_encode($output);
    }

    public function exportExcel()
    {
        $array = array();
        $columnas = array(
            0 => 'CLIENTE',
            1 => 'FRACCIONAMIENTO',
            2 => 'MANZANA',
            3 => 'LOTE',
            4 => '# EXT',
            5 => 'PROTOTIPO',
            6 => 'SUPERFICIE',
            7 => 'PLAZO',
            8 => 'MONTO',
            9 => 'IMPORTE',
            10 => 'PAGOS',
            11 => 'SALDO',
            12 => 'MOVIMIENTO',
            13 => 'ESTATUS',
        );

        $q = $this->mrcontado->getAllExcel();
        if(!is_numeric($q)){
            $i = 0;
            $totRCMonto=0;
            $totRCImporte=0;
            $totRCPagos=0;
            $totRCSaldo=0;
            foreach ($q->result() as $row) {

                $totRCMonto += ($row->monto != '') ? $row->monto : 0;
                $totRCImporte += ($row->importe != '') ? $row->importe : 0;
                $totRCPagos += ($row->pagos != '') ? $row->pagos : 0;
                $totRCSaldo += ($row->saldo != '') ? $row->saldo : 0;

                $array[$i] = array(
                    'cliente' => $row->cliente,
                    'fraccionamiento' => $row->fraccionamiento,
                    'manzana' => $row->manzana,
                    'lote' => $row->lote,
                    'nOficial' => $row->nOficial,
                    'prototipo' => $row->prototipo,
                    'superficie' => $row->supTerreno,
                    'plazos' => $row->plazos,
                    'monto' => precio_format($row->monto),
                    'importe' => precio_format($row->importe),
                    'pagos' => precio_format($row->pagos),
                    'saldo' => precio_format($row->saldo),
                    'movimiento' =>$row->movimiento,
                    'statusDetalle' => strtoupper(statusDetalle($row->statusDetalle))
                );

                $i++;
            }

            $array[$i] = array(
                'cliente' => 'TOTALES:',
                'fraccionamiento' => '',
                'manzana' => '',
                'lote' => '',
                'nOficial' => '',
                'prototipo' => '',
                'superficie' => '',
                'plazos' => '',
                'monto' => precio_format($totRCMonto),
                'importe' => precio_format($totRCImporte),
                'pagos' => precio_format($totRCPagos),
                'saldo' => precio_format($totRCSaldo),
                'movimiento' => '',
                'statusDetalle' => ''
            );
        }

        $nombre = 'Reporte_contado';

        crearExcel($array,$nombre,$columnas,'array');
    }

}
