<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class rcomparativa extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'rcomparativa'; // form validation variable
            $this->mainView = 'rcomparativa';
            $this->data['fjs'] = '';
            $this->data['js'] = '<script src="assets/js/rcomparativa/listado.js?v=0.1" type="text/javascript"></script>';
            $this->data['css'] = '';
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipos', 'mpaquete', 'mdetallepaquete', 'mmaterialesactividadprototipo', 'mmaterial',
             'mpresupuestomat', 'mordencompra', 'mmanoobra', 'mmateriales', 'mproveedor', 'mareamaterial', 'musuario', 'mempresas', 'mconstructores', 
             'mrecepcion', 'mcompra', 'marranque','mcomparativa'));

            // Lbrerias
            $this->load->library('csvimport');

           // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
           $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);
            valSession("materiales",$this->fv);
    }

	public function index(){
        $texto = '';
        if( isset($_SESSION['mensaje'])){
            $texto = $_SESSION['mensaje'];
            unset($_SESSION['mensaje']);
        }
        $data["empresa"]=$this->mempresas->getCampo("titulo",$_SESSION[$this->nsession]["idEmpresa"]);
        $data['texto'] = $texto;
        $ids = array();
        $qArranque = $this->marranque->getAllByEstatusNoPendiente();
        if( !is_numeric($qArranque) ){
            foreach($qArranque->result() as $arranque){
                $temp = explode(',', $arranque->idPaquetes);
                if( !empty($temp[0]) ){
                    foreach($temp as $v){
                        if( !in_array($v, $ids, true) && is_numeric($v)){
                            $ids[] = $v;
                        }
                    }
                }
            }
        }
        $data['fraccionamientos']=$this->mfraccionamiento->getAllFiltro();
        $data['almacenes'] = ( empty($ids) )? 0 : $this->mpaquete->getSelectResultInIds($ids);
        $data['articulos']=$this->mmateriales->getAllFiltro($_SESSION[$this->nsession]["idEmpresa"]);
        $data['proveedores']=$this->mproveedor->getAllFiltro($_SESSION[$this->nsession]["idEmpresa"]);
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $list = $this->mcomparativa->get_datatables();
        if(!is_numeric($list)){
            foreach ($list->result() as $row) {
                $array[] = array(
                    'fraccionamiento' => $row->fraccionamiento,
                    'nombre_almacen' => $row->nombre_almacen,
                    'nLotes' => $row->nLotes,
                    'clave' => $row->clave,
                    'articulo' => $row->articulo,
                    'unidad_venta' => $row->unidad_venta,
                    'proveedor' => $row->proveedor,
                    'unidades_ppto' =>  $this->toNumber($row->unidades_ppto,false),
                    'precio_ppto' => $this->toNumber($row->precio_ppto),
                    'importe_ppto' =>  $this->toNumber($row->importe_ppto),
                    'folios_oc' => $row->folios_oc,
                    'unidades_doc' =>  $this->toNumber($row->unidades_doc,false),
                    'precio_doc' => $this->toNumber($row->precio_doc),
                    'importe_doc' => $this->toNumber($row->importe_doc),
                    'folios_c' => $row->folios_c,
                    'unidades_dc' => $this->toNumber($row->unidades_dc,false),
                    'precio_dc' => $this->toNumber($row->precio_dc),
                    'importe_dc' => $this->toNumber($row->importe_dc),
                    'folios_rc' => $row->folios_rc,
                    'unidades_drc' => $this->toNumber($row->unidades_drc,false),
                    'precio_drc' => $this->toNumber($row->precio_drc),
                    'importe_drc' => $this->toNumber($row->importe_drc),
                    'cantidad_ppto' => $this->toNumber($row->cantidad_ppto,false),
                    'precio_unitario' => $this->toNumber($row->precio_unitario),
                    'importe' => $this->toNumber($row->importe),
                    'cantidad_ppto2' => $this->toNumber($row->cantidad_ppto2,false),
                    'precio_unitario2' => $this->toNumber($row->precio_unitario),
                    'importe2' => $this->toNumber($row->importe2),
                );
            }
        }else{
            $array[] = [];
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mcomparativa->count_all(),
                        "recordsFiltered" => $this->mcomparativa->count_filtered(),
                        "data" => $array,
                );
        //output to json format
        echo json_encode($output);
    }

    public function toNumber($number,$moneda=true){
        $result=0;
        if(is_numeric($number)){   
            $result=number_format($number,2);
        }else{
            $result=number_format(0,2);
        }
        $result=($moneda) ? "$".$result : $result;
        return $result;
    }
}