<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ractividades extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'ractividades'; // form validation variable
            $this->mainView = 'ractividades';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/ractividades/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('musuario','mop_detalle','mfraccionamiento','mconstructores','mprototipos','mpaquete','mcortes',
			'mconstructores','mpaquete','mproyecto'));
            valSession("obra",$this->fv);
    }

    public function index(){
		$data['q'] = '';
		$data['corteActual']=$this->mcortes->getCorteActual();
		$data['fraccionamientos']=$this->mfraccionamiento->getAllFiltro();
		$data['constructores']=$this->mconstructores->getSelectResult();
		$data['prototipos']=$this->mprototipos->getAll();
		$data['supervisores']=$this->musuario->getResidenteObraBySelectResult();
		$data['paquetes']=$this->mpaquete->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

	public function listado(){
        if(isset($_POST["info"])){
			$info=$_POST["info"];
            $filter="";
			if($info["ano"] > 0){
                $filter.=" AND YEAR(opd.fecha)=".$info["ano"];
            }
			if($info["semana"] > 0){
                $filter.=" AND WEEK(opd.fecha,7)=".$info["semana"];
            }
            if($info["fraccionamiento"] > 0){
                $filter.=" AND opd.idFraccionamiento=".$info["fraccionamiento"];
            }
			if($info["paquete"] > 0){
                $filter.=" AND opd.idPaquete=".$info["paquete"];
            }
            if($info["constructor"] > 0){
                $filter.=" AND opd.idConstructor=".$info["constructor"];
            }
			if($info["prototipo"] > 0){
                $filter.=" AND pro.idPrototipo=".$info["prototipo"];
            }
			if($info["supervisor"] > 0){
                $filter.=" AND dp.idResidente=".$info["supervisor"];
            }
			if($info["tipoLote"] > 0){
                $filter.=" AND opd.tipoLote=".$info["tipoLote"];
            }
			if($info["estatusCalidad"] != 0){
                $filter.=" AND opd.calidad='".$info["estatusCalidad"]."'";
            }
            if ($info['fecha_inicio'] != "" && $info['fecha_fin']  != "") {
                $fecha_inicio = date_format(new DateTime($info['fecha_inicio']),"Y-m-d");
                $fecha_fin = date_format(new DateTime($info['fecha_fin']),"Y-m-d");
                if($fecha_inicio != $fecha_fin){
                    $filter.=" AND DATE(opd.fecha) >= DATE('$fecha_inicio') AND DATE(opd.fecha) <= DATE('$fecha_fin') + INTERVAL 1 DAY ";
                }else{
                    $filter.=" AND DATE(opd.fecha) = DATE('$fecha_inicio') ";
                }
            }
		}
		$constructor="CONCAT_WS(' ',cons.nombre,cons.apellidoP,cons.apellidoM) constructor";
		$supervisor="CONCAT_WS(' ',usr.nombre,usr.apellidoP,usr.apellidoM) supervisor";
		$q=$this->db->query("SELECT $constructor,$supervisor,opd.calidad,opd.precioUnitario,opd.cantidad,opd.semanaActual, opd.semanaAnual, opd.fecha, opd.tipoLote, fra.titulo titleFracc, 
		paq.titulo titlePaq, pro.lote, pro.manzana, opd.importe importe, opd.fg fg, (opd.importe - opd.fg) total, actmo.descripcion, cat.categoria, prot.nombre titleProto,
		opd.idSupervisor, opd.idInspector
		FROM op_detalle opd
		LEFT JOIN constructores cons ON cons.id=opd.idConstructor
		LEFT JOIN paquetes paq ON paq.id=opd.idPaquete
		LEFT JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
		LEFT JOIN fraccionamientos fra ON fra.id=opd.idFraccionamiento
		LEFT JOIN proyectos pro ON pro.id=opd.idProyecto
		LEFT JOIN prototipos prot ON prot.id=pro.idPrototipo
		LEFT JOIN presupuesto_mo pmo ON pmo.id=opd.idPresupuesto
		LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
		LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
		LEFT JOIN detalle_paquete dp ON dp.idPaquete=opd.idPaquete AND dp.idProyecto=opd.idProyecto
		LEFT JOIN usuarios usr ON usr.id=dp.idResidente
		LEFT JOIN categorias_mo cat ON cat.id=actmo.idCategoria
		WHERE opd.status AND opd.tipoActividad=1 $filter ");
		$array=[];
		$importe=0;
		$fg=0;
		$total=0;
		if ($q->num_rows()>0){
			foreach ($q->result() as $row){
				$importe+=$row->importe;
				$fg+=$row->fg;
				$total+=$row->total;
				$array['aaData'][] = array(
					'tipo' => 'column',
					'fraccionamiento' => $row->titleFracc,
					'manzana' => $row->manzana,
					'lote' => $row->lote,
					'prototipo' => $row->titleProto,
					'constructor' => $row->constructor,
					'supervisor' => $row->supervisor,
					'inspector' => $this->musuario->getCampo("CONCAT_WS(' ',nombre,apellidoP,apellidoM)",$row->idInspector),
					'descripcion' => $row->descripcion,
					'categoria' => $row->categoria,	
					'semanaActual' => $row->semanaActual,
					'semanaAnual' => $row->semanaAnual,
					'calidad' => $row->calidad,
					'tipoLote' => tipoLote($row->tipoLote),		
					'paquete' => $row->titlePaq,												
					'precioUnitario' => toNumber($row->precioUnitario),
					'cantidad' => $row->cantidad,
					'importe' => toNumber($row->importe),
					'fg' => toNumber($row->fg),
					'total' => toNumber($row->total),
				);
			}
		}
		$q2=$this->db->query("SELECT opd.* FROM op_detalle opd
		LEFT OUTER JOIN proyectos pro ON pro.id=opd.idProyecto
		LEFT OUTER JOIN detalle_paquete dp ON dp.idPaquete=opd.idPaquete
		WHERE opd.tipoActividad=2 $filter GROUP BY opd.id");
		if ($q2->num_rows()>0){
			foreach ($q2->result() as $row){
				$importe+=$row->importe;
				$fg+=$row->fg;
				$total+=($row->importe-$row->fg);
				$array['aaData'][] = array(
					'tipo' => 'column',
					'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$row->idFraccionamiento),
					'manzana' => ($row->tipoExtra==1) ? $this->mproyecto->getCampo("manzana",$row->idProyecto) : "",
					'lote' => ($row->tipoExtra==1) ? $this->mproyecto->getCampo("lote",$row->idProyecto) : "",
					'prototipo' => ($row->tipoExtra==1) ? $this->mprototipos->getCampo("nombre",$this->mproyecto->getCampo("idPrototipo",$row->idProyecto)) : "",
					'constructor' => $this->mconstructores->getCampo("CONCAT_WS(' ',nombre,apellidoP,apellidoM)",$row->idConstructor),
					'supervisor' => "",
					'inspector' => "",
					'descripcion' => $row->descripcion,
					'categoria' => "Extras",	
					'semanaActual' => $row->semanaActual,
					'semanaAnual' => $row->semanaAnual,
					'calidad' => $row->calidad,
					'tipoLote' => tipoLote($row->tipoLote),		
					'paquete' => ($row->tipoExtra==1) ? $this->mpaquete->getCampo("titulo",$row->idPaquete) : "",										
					'precioUnitario' => toNumber($row->precioUnitario),
					'cantidad' => $row->cantidad,
					'importe' => toNumber($row->importe),
					'fg' => toNumber($row->fg),
					'total' => toNumber($row->importe-$row->fg),
				);
			}
		}
		if($q->num_rows()>0 || $q2->num_rows()>0){
			$array['aaData'][] = array(
				'tipo' => 'footer',
				'fraccionamiento' => '',
				'manzana' => '',
				'lote' => '',
				'prototipo' => '',
				'constructor' => '',
				'supervisor' => '',
				'inspector' => '',
				'descripcion' => '',
				'categoria' => '',
				'semanaActual' => '',
				'semanaAnual' => '',
				'calidad' => '',
				'tipoLote' => '',
				'paquete' => '',
				'precioUnitario' => '',
				'cantidad' => '',
				'importe' => toNumber($importe),
				'fg' => toNumber($fg),
				'total' => toNumber($total),
			);
		}else{
			$array['aaData']=[];
		}
		echo json_encode($array);
	}

}


