<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Puestos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$allowed;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'puestos'; // form validation variable
            $this->mainView = 'puestos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/puestos/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mpuestos','musuario','mareas'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           $this->allowed=permisos("rh",$this->fv);
           //Validación de usuarios
           valSession("rh",$this->fv);
    }

	public function index(){
        $data['allowed'] = $this->allowed;
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mpuestos->getAll();
        $permisos=permisos($this->fv);
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'titulo' => $row->titulo,
                    'idArea' => $this->mareas->getCampo('titulo',$row->idArea),
                    'statusChatbot' =>  rhactiveCheck($row->id,$row->statusChatbot),
                    'txtstatus' => $row->txtstatus,
                    'acciones' => acciones($row->id,$this->router->class),
                    );
            }
        }else{
            $array['aaData']=[];
        }
        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';
        $data["areas"]=$this->mareas->getAll();
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            echo $data['msg'];
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['titulo'] = $this->input->post('titulo', TRUE);
            $pData['idArea'] = $this->input->post('idArea', TRUE);
            $pData['status'] = 1;
            $id = $this->mpuestos->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {

                $pData['titulo'] = $this->input->post('titulo', TRUE);
                $pData['idArea'] = $this->input->post('idArea', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);

                $this->mpuestos->actualizar($pData, $id);
                redirect($this->router->class);
            }
        }
        // Obteniendo la información
        $info = $this->mpuestos->getById($id);

        $data = $info;
        $data['msg']=$msg;
        $data["areas"]=$this->mareas->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mpuestos->getById($id);
        $cValor = "true";
        $this->mpuestos->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function changeStatus(){
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $status=($status=="true") ? 1 : 0;
        $this->mpuestos->actualizar(["statusChatbot"=>$status],$id);
        echo json_encode("listo");

    }



}


