<?php
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('America/Mexico_City');
class Proyectos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'proyectos'; // form validation variable
            $this->mainView = 'proyectos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/proyectos/listado.js?v=0.9" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproyecto','mfraccionamiento','mprototipoxfraccionamiento','maltaventa','musuario','mfraccionamientoxusuario','mautorizacion',
            'mcomisionbono','mentrega','mdeposito','mencuestavivienda','mpostventa','mprototipos','mincidente','mpaquete','mdetallepaquete','mlineascredito','mdetallepaquete'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            $this->load->library('csvimport');
           	$this->data['fotos_www'] = $this->config->item('base_www')."/csv/";
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("ventas",$this->fv);

           $this->idFraccionamiento = 0;

            $this->urlLogo = '';
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);
    }

    public function setLogo()
    {
        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
    }

	public function index($id=0,$idFraccionamiento=null){
        $this->load->dbutil();
        $this->load->helper('download');
        $data['error']="";
        $data["fraccionamientos"]=$this->musuario->getFraccionamientos();
        $data['idFraccionamiento'] =($this->input->post('fraccionamiento', TRUE)=='')? $idFraccionamiento: $this->input->post('fraccionamiento', TRUE);

        //Creando CSV
        if($id==1){
            $query = $this->mproyecto->getCSV($data['idFraccionamiento']);
            if (!is_numeric($query)){
                $date=new DateTime();
                $name = "Inventario";
                $columnas = array(
                        0 => 'ID',
                        1 => 'NOMBRE DE ASENTAMIENTO',
                        2 => 'TIPO DE VIALIDAD1',
                        3 => 'NOMBRE DE VIALIDAD',
                        4 => 'SUPERMANZANA',
                        5 => 'MANZANA',
                        6 => 'LOTE',
                        7 => 'NUM. EXTERIOR',
                        8 => 'NÚMERO CATASTRAL DEL LOTE',
                        9 => 'COSTO',
                        10 => 'COMISIÓN TOTAL',
                        11 => 'Al 90%',
                        12 => 'IMPUESTOS 9% 1ERA COMISIÓN',
                        13 => 'TOTAL PAGO 1',
                        14 => 'AL 10%',
                        15 => 'IMPUESTOS 9% 2DA COMISIÓN',
                        16 => 'TOTAL PAGO 2',
                        17 => 'BONO EQUIPAMIENTO',
                        18 => 'METROS CUADRADOS LOTE',
                        19 => 'METROS FRENTE LOTE',
                        20 => 'ORIENTACIÓN',
                        21 => 'LÍNEA DE CRÉDITO',
                        22 => 'AVALUO FOLIO',
                        23 => 'RONDA',
                        24 => 'FECHA ALTA DE VENTA',
                        25 => 'FECHA APARTADO',
                        26 => 'FECHA PROCESO',
                        27 => 'FECHA INSCRIPCION',
                        28 => 'FECHA FIRMA',
                        29 => 'FECHA DETONACION',
                        30 => 'DIAS',
                        31 => 'PROTOTIPO',
                        32 => '% AVANCE',
                        33 => 'ESTATUS',
                        34 => 'NOMBRE CLIENTE',
                        35 => 'NOMBRE PROMOTOR',
                        36 => 'TIPO PROMOTOR',
                        37 => 'CUV',
                        38 => 'PUNTAJE',
                        39 => 'CONTRATISTA',
                        40 => 'PAQUETE'
                );

                foreach ($query->result() as $row) {
                    $contratista=$this->mincidente->getConstructorByIdProyecto($row->id);
                    $detallePaq = $this->mdetallepaquete->getByIdProyecto($row->id);
                    if(!is_numeric($detallePaq)){
                        $idPaquete = $detallePaq->row()->idPaquete;
                        $paquete = $this->mpaquete->getCampo('titulo',$idPaquete);
                    }else{
                        $paquete = '';
                    }
                    $array[] = array(
                        0 => $row->id,
                        1 => $row->asentamiento,
                        2 => $row->tVialidad1,
                        3 => $row->nombreVialidad,
                        4 => $row->supermanzana,
                        5 => $row->manzana,
                        6 => $row->lote,
                        7 => $row->numExterior,
                        8 => $row->claveCatastral,
                        9 => $row->costo,
                        10 => $row->comisionTotal,
                        11 => $row->al90,
                        12 => $row->impuestosComision1,
                        13 => $row->totalPago1,
                        14 => $row->al10,
                        15 => $row->impuestosComision2,
                        16 => $row->totalPago2,
                        17 => $row->bonoEquipamiento,
                        18 => $row->supTerreno,
                        19 => $row->metrosFrente,
                        20 => $row->orientacion,
                        21 => $row->lineaCredito,
                        22 => $row->avaluo,
                        23 => $row->ronda,
                        24 => $row->fechaAv,
                        25 => $row->fechaApartado,
                        26 => $row->fechaProceso,
                        27 => $row->fechaInscripcion,
                        28 => $row->fechaFirma,
                        29 => $row->fechaDetonacion,
                        30 => $row->dias,
                        31 => $row->prototipo,
                        32 => $row->avance,
                        33 => $row->estatus,
                        34 => $row->nombreCliente,
                        35 => $row->nombrePromotor,
                        36 => $row->tipoPromotor,
                        37 => $row->cuv,
                        38 => $row->puntaje,
                        39 => !is_numeric($contratista) ? $contratista : $this->mproyecto->getCampo('contratista',$row->id),
                        40 => $paquete

                    );
                }
                crearExcel2($array,$name,$columnas,'array');

                //VERSIÓN ANTIGUA EN CSV
                /*$csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
                $date=new DateTime();
                $name = "Inventario-".$date->format("d-m-Y").".csv";
                force_download($name, $csv);*/

            }else{
                //redirect('proyectos');
                $data['msgInvalid'] = "No existen registros para exportar";
            }


        }else if(isset($_FILES["foto"]) && $_SERVER['REQUEST_METHOD'] == 'POST'){
            $config['upload_path'] = $this->data['fotos_www'];
            $config['allowed_types'] = 'csv';
            $config['max_size'] = '2000';

            $this->load->library('upload', $config);
            // If upload failed, display error
            if (!$this->upload->do_upload("foto")) {
                $data['error'] = $this->upload->display_errors();
            }else {
                $file_data = $this->upload->data();
                $file_path = $this->data['fotos_www'].$file_data['file_name'];

                if ($this->csvimport->get_array($file_path,'',TRUE)) {
                    $csv_array = $this->csvimport->get_array($file_path);

                    $registros = array();
                    //if (isset($csv_array[0]['ID'])){
                    if (isset($csv_array[0]['LOTE'])){
                        foreach ($csv_array as $row) {
                                $idFraccionamiento=$this->mfraccionamiento->getByTitulo($row['NOMBRE DE ASENTAMIENTO']);
                                $idPrototipo = $this->mprototipos->getByTitulo($row['PROTOTIPO']);
                                //Se valida si existe el id o es nuevo
                                $idArray=$this->db->query("SELECT id FROM proyectos;");
                                $idArray=$idArray->result_array();
                                $idArray=array_column($idArray, 'id');

                                $insert_data = array(
                                    'idFraccionamiento'=>$idFraccionamiento,
                                    'idPrototipo'=>$idPrototipo,
                                    'numPaquete'=>'',
                                    'lote'=>$row['LOTE'],
                                    'manzana'=>$row['MANZANA'],
                                    'calle'=>$row['NOMBRE DE VIALIDAD'],
                                    'nOficial'=>$row['NUM. EXTERIOR'],
                                    'cuv'=>$row['CUV'],
                                    'claveCatastral'=>$row['NUMERO CATASTRAL DEL LOTE'],
                                    'supTerreno'=>$row['METROS CUADRADOS LOTE'],
                                    'supConstruccion'=>0,
                                    'precioVenta'=>$row['COSTO'],//0,
                                    'statusProyecto'=>'',
                                    'puntaje'=>0,
                                    'porcentajeAvance'=>0,
                                    'contratista'=>'',
                                    'avaluo'=>0,
                                    'unidadVerificadora'=>'',
                                    //'fechaVencimiento'=>'',
                                    //'fechaDtu'=>'',
                                    'lineaCredito'=>$row['LINEA DE CREDITO'],
                                    'folioAvaluo'=>$row['AVALUO FOLIO'],
                                    'tipoVialidad'=>$row['TIPO DE VIALIDAD1'],
                                    'nombreVialidad'=>$row['NOMBRE DE VIALIDAD'],
                                    //'nivel'=>$row['NIVEL'],
                                    //'estacionamiento'=>$row['ESTACIONAMIENTO'],
                                    //'tipoPrimeraVialidad'=>$row['TIPO DE VIALIDAD2'],
                                    //'primeraEntreVialidad'=>$row['NOMBRE DE LA PRIMERA ENTRE VIALIDAD'],
                                    //'tipoSegundaVialidad'=>$row['TIPO DE VIALIDAD3'],
                                    //'segundaEntreVialidad'=>$row['NOMBRE DE LA SEGUNDA ENTRE VIALIDAD'],
                                    //'tipoVialidadPosterior'=>$row['TIPO DE VIALIDAD4'],
                                    //'nombreVialidadPosterior'=>$row['NOMBRE DE LA VIALIDAD POSTERIOR'],
                                    'metrosFrente'=>$row['METROS FRENTE LOTE'],
                                    'orientacion'=>$row['ORIENTACION'],
                                    'created' => date("Y-m-d H:i:s"),
                                    'updated' => date("Y-m-d H:i:s")
                                );
                                
                                if(  $insert_data['lineaCredito'] == 2 ){
                                    $insert_data['statusObra'] = 2;
                                }else{
                                    $insert_data['statusObra'] = 0;
                                }

                                if(!isset($row['ID'])){
                                    $row['ID'] = '';
                                }

                                if(!in_array($row['ID'], $idArray)){
                                    if($idFraccionamiento != 0){
                                        array_push($registros, $insert_data);
                                    }else{
                                        $data['error'].="El registro con id:".$row['ID']." no se pudo insertar, debido a que no existe el nombre de asentamiento:".$row['NOMBRE DE ASENTAMIENTO']."<br>";
                                    }
                                }else{
                                    $this->mproyecto->actualizar($insert_data,$row["ID"]);
                                    $data['error'] = "El inventario se ha actualizado";
                                }
                        }

                        if (count($registros)>0){
                                $this->mproyecto->insertBatchRegistros($registros);
                                //$data['error'] = "El inventario se ha actualizado con ".count($registros)." registros nuevos";
                                $data['error'] = "El inventario se ha actualizado";
                                //$this->autoRespuestaNuevoInventario();
                        }
                    }
                    @unlink($file_path);
                } else{
                    $data['error'] = "Ocurrió un error";

                }
            }
        }

        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado($idFraccionamiento=null){
        $q = $this->mproyecto->getAll($idFraccionamiento);
        // print_r($q->result()); exit();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $editar=true;
                $statusGestoria=$this->db->query("SELECT statusGestoria FROM gestoria WHERE idAltaVenta = (SELECT id FROM alta_venta WHERE idProyecto=$row->id ORDER BY id DESC LIMIT 1)");
                if($statusGestoria->num_rows() > 0){
                    $statusGestoria=$statusGestoria->row()->statusGestoria;
                    $editar=($statusGestoria=="detonado") ? false : true;
                }
                $detallepaquete=$this->mdetallepaquete->getByIdProyecto($row->id);
                $idManoObra=0;
                if(!is_numeric($detallepaquete)){
                    $idManoObra=$this->mpaquete->getCampo("idManoObra",$detallepaquete->row()->idPaquete);
                }
                $btnLiberar = '';
                $btnLiberar .= ($row->statusVenta==1)?'<a href="javascript:void(0);" onclick="modalLiberar('.$row->id.')" class="btn btn-default bg-2" style="color:#fff!important;">Liberar Lote</a>':'';
                $array['aaData'][] = array(
                    'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                    'titulo' => $row->lote,
                    'manzana' => $row->manzana,
                    'nOficial' => $row->nOficial,
                    'calle' => $row->calle,
                    // 'prototipo' => $this->mprototipoxfraccionamiento->getCampo("titulo",$row->idPrototipo),
                    'prototipo' => $this->mprototipos->getCampo("nombre",$row->idPrototipo),
                    'precioVenta' => precio_format($row->precioVenta),
                    'avaluo' => precio_format($row->avaluo),
                    'statusVivienda' => estatus_proyecto_reporte($row->statusVenta)." ".$btnLiberar,
                    'txtstatus' => $row->statusProyecto,
                    'porcentajeAvance' => $row->porcentajeAvance."%",
                    'costoAvance' => precio_format($row->costoAvance),
                    'acciones' => accionesProyecto($row->id,$this->router->class,true, $editar, $idManoObra)
                    );
            }
        }else{
            $array['aaData'][] = array(
                'fraccionamiento' => 'No hay registros',
                'titulo' => 'No hay registros',
                'manzana' => 'No hay registros',
                'nOficial' => 'No hay registros',
                'calle' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'avaluo' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'porcentajeAvance' => 'No hay registros',
                'costoAvance' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function nuevo()
    {

        $infoLast = $this->mproyecto->getLast();
        if (!is_numeric($infoLast)){
            $data = $infoLast;
        }

        // Mensajes
        $data['msg'] = '';
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAll();
        $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data['avaluo'] = $this->input->post('avaluo', TRUE);
            $lineasCredito=$this->mlineascredito->getAll();
            $tempLineasCredito=[];
            foreach($lineasCredito->result() as $row){
                $tempLineasCredito[$row->valor]=$row->titulo;
            }
            $data["lineasCredito"]=$tempLineasCredito;
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
            $pData['numPaquete'] = $this->input->post('numPaquete', TRUE);
            $pData['lote'] = $this->input->post('lote', TRUE);
            $pData['manzana'] = $this->input->post('manzana', TRUE);
            $pData['calle'] = $this->input->post('calle', TRUE);
            $pData['nOficial'] = $this->input->post('nOficial', TRUE);
            $pData['numeroInterior'] = $this->input->post('numeroInterior', TRUE);
            $pData['cuv'] = $this->input->post('cuv', TRUE);
            $pData['claveCatastral'] = $this->input->post('claveCatastral', TRUE);
            $pData['supTerreno'] = $this->input->post('supTerreno', TRUE);
            $pData['supConstruccion'] = $this->input->post('supConstruccion', TRUE);
            $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
            $precioVenta = $this->input->post('precioVenta', TRUE);
            $pData['precioVenta'] = ($precioVenta!='')?toInt($precioVenta):0.00;
            $pData['statusProyecto'] = $this->input->post('statusProyecto', TRUE);
            $pData['puntaje'] = $this->input->post('puntaje', TRUE);
            // $pData['porcentajeAvance'] = $this->input->post('porcentajeAvance', TRUE);
            $pData['contratista'] = $this->input->post('contratista', TRUE);
            $avaluo = $this->input->post('avaluo', TRUE);
            $pData['avaluo'] = ($avaluo!='')?toInt($avaluo):0.00;
            $pData['unidadVerificadora'] = $this->input->post('unidadVerificadora', TRUE);
            $fechaVencimiento = $this->input->post('fechaVencimiento', TRUE);
            $fechaVencimiento =  str_replace('/', '-', $fechaVencimiento);
            $pData['fechaVencimiento'] = ($fechaVencimiento!='')?date('Y-m-d', strtotime($fechaVencimiento)):'0000-00-00';//date_format(new DateTime($fechaVencimiento), 'Y-m-d');
            $fechaDtu = $this->input->post('fechaDtu', TRUE);
            $fechaDtu =  str_replace('/', '-', $fechaDtu);
            $pData['fechaDtu'] = ($fechaDtu!='')?date('Y-m-d', strtotime($fechaDtu)):'0000-00-00';//date_format(new DateTime($fechaDtu), 'Y-m-d');
            $pData['lineaCredito'] = $this->input->post('lineaCredito', TRUE);

            $pData['tipoVialidad'] = $this->input->post('tipoVialidad', TRUE);
            $pData['nombreVialidad'] = $this->input->post('nombreVialidad', TRUE);
            $pData['nivel'] = $this->input->post('nivel', TRUE);
            $pData['estacionamiento'] = $this->input->post('estacionamiento', TRUE);
            $pData['tipoPrimeraVialidad'] = $this->input->post('tipoPrimeraVialidad', TRUE);
            $pData['primeraEntreVialidad'] = $this->input->post('primeraEntreVialidad', TRUE);
            $pData['tipoSegundaVialidad'] = $this->input->post('tipoSegundaVialidad', TRUE);
            $pData['segundaEntreVialidad'] = $this->input->post('segundaEntreVialidad', TRUE);
            $pData['tipoVialidadPosterior'] = $this->input->post('tipoVialidadPosterior', TRUE);
            $pData['nombreVialidadPosterior'] = $this->input->post('nombreVialidadPosterior', TRUE);
            $pData['metrosFrente'] = $this->input->post('metrosFrente', TRUE);
            $pData['orientacion'] = $this->input->post('orientacion', TRUE);

            $pData['status'] = 1;

            $proData['checkboxCimentacion'] = ($this->input->post('checkboxCimentacion', TRUE) != 1 ? 0 : $this->input->post('checkboxCimentacion', TRUE));
            $proData['checkboxAlbPlantaBaja'] = ($this->input->post('checkboxAlbPlantaBaja', TRUE) != 1 ? 0 : $this->input->post('checkboxAlbPlantaBaja', TRUE));
            $proData['checkboxLosaEntrepiso'] = ($this->input->post('checkboxLosaEntrepiso', TRUE) != 1 ? 0 : $this->input->post('checkboxLosaEntrepiso', TRUE));
            $proData['checkboxAlbPrimerNivel'] = ($this->input->post('checkboxAlbPrimerNivel', TRUE) != 1 ? 0 : $this->input->post('checkboxAlbPrimerNivel', TRUE));
            $proData['checkboxLosaPrimerNivel'] = ($this->input->post('checkboxLosaPrimerNivel', TRUE) != 1 ? 0 : $this->input->post('checkboxLosaPrimerNivel', TRUE));
            $proData['checkboxAzotea'] = ($this->input->post('checkboxAzotea', TRUE) != 1 ? 0 : $this->input->post('checkboxAzotea', TRUE));
            $proData['checkboxFachada'] = ($this->input->post('checkboxFachada', TRUE) != 1 ? 0 : $this->input->post('checkboxFachada', TRUE));
            $proData['checkboxAcabados'] = ($this->input->post('checkboxAcabados', TRUE) != 1 ? 0 : $this->input->post('checkboxAcabados', TRUE));
            $proData['checkboxPisos'] = ($this->input->post('checkboxPisos', TRUE) != 1 ? 0 : $this->input->post('checkboxPisos', TRUE));
            $proData['checkboxInstHidroGas'] = ($this->input->post('checkboxInstHidroGas', TRUE) != 1 ? 0 : $this->input->post('checkboxInstHidroGas', TRUE));
            $proData['checkboxCanceleria'] = ($this->input->post('checkboxCanceleria', TRUE) != 1 ? 0 : $this->input->post('checkboxCanceleria', TRUE));
            $proData['checkboxElectrica'] = ($this->input->post('checkboxElectrica', TRUE) != 1 ? 0 : $this->input->post('checkboxElectrica', TRUE));
            $proData['checkboxObraExterior'] = ($this->input->post('checkboxObraExterior', TRUE) != 1 ? 0 : $this->input->post('checkboxObraExterior', TRUE));
            $proData['checkboxBardas'] = ($this->input->post('checkboxBardas', TRUE) != 1 ? 0 : $this->input->post('checkboxBardas', TRUE));
            $proData['checkboxLimpieza'] = ($this->input->post('checkboxLimpieza', TRUE) != 1 ? 0 : $this->input->post('checkboxLimpieza', TRUE));
            $proData['checkboxExtra'] = ($this->input->post('checkboxExtra', TRUE) != 1 ? 0 : $this->input->post('checkboxExtra', TRUE));
            $proData['checkboxImpermeabilizacion'] = ($this->input->post('checkboxImpermeabilizacion', TRUE) != 1 ? 0 : $this->input->post('checkboxImpermeabilizacion', TRUE));
            $proData['checkboxEcotecnologias'] = ($this->input->post('checkboxEcotecnologias', TRUE) != 1 ? 0 : $this->input->post('checkboxEcotecnologias', TRUE));
            $checkAvance = "";
            foreach ($proData as $key => $value) {
                $checkAvance .= $value.",";
            }
            $checkAvance = trim($checkAvance,",");

            $pData['costoAvance'] = $this->input->post('costoTotal', TRUE);
            $pData['porcentajeAvance'] = $this->input->post('avanceTotal', TRUE);
            $pData['checkAvance'] = $checkAvance;

            if ( $pData['statusProyecto'] == 'dtu' ) {
                $dPromotores = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($pData['idFraccionamiento']);
                if ( !is_numeric($dPromotores) ) {
                    $arrMails = [];
                    foreach ($dPromotores->result() as $row) {
                        $arrProm = array(
                            "correo" => $this->musuario->getCampo('email',$row->id),
                            "nombre" => $this->musuario->getCampo('nombre',$row->id) . ' ' . $this->musuario->getCampo('apellidoP',$row->id) . ' ' . $this->musuario->getCampo('apellidoM',$row->id)
                        );
                        array_push( $arrMails, $arrProm );
                    }
                    //print_r($arrMails);exit();
                    //$autores = $this->autoRespuesta($arrMails, $pData);
                    // echo "<br><br>";
                    // print_r($dPromotores->result()); exit();
                }
                $pData['statusAlertDTU'] = 1;
            }
            if(  $pData['lineaCredito'] == 2 ){
                $pData['statusObra'] = 2;
            }else{
                $pData['statusObra'] = 0;
            }
            $id = $this->mproyecto->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function liberar(){
        $id = $this->input->post('elid', TRUE);//idProyecto
        $rowAV = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $cValor = "false";
        if ($id>0 && !is_numeric($rowAV)){
            $idAltaVenta = $rowAV->row()->id;
            /*echo "ALTAVENTA:".$idAltaVenta."<br>Proyecto:".$id;
            exit();*/
            $this->db->query("UPDATE alta_venta SET idProyecto=NULL, statusValidacion = 0 WHERE id=".$idAltaVenta);
            $this->db->query("UPDATE proyectos SET statusVenta=0 WHERE id=".$id);
            $cValor = "true";
        }
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['lote'])) {
            $boolFV = ($_SESSION[$this->nsession]['rol'] != 9 )?FALSE:TRUE;
            if ($this->form_validation->run($this->fv) == $boolFV) {
                $msg = validation_errors();
            } else {
                $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
                $pData['lote'] = $this->input->post('lote', TRUE);
                if ( $_SESSION[$this->nsession]['rol'] != 9 ) {
                    $pData['numPaquete'] = $this->input->post('numPaquete', TRUE);
                    $pData['manzana'] = $this->input->post('manzana', TRUE);
                    $pData['calle'] = $this->input->post('calle', TRUE);
                    $pData['nOficial'] = $this->input->post('nOficial', TRUE);
                    $pData['numeroInterior'] = $this->input->post('numeroInterior', TRUE);
                    $pData['cuv'] = $this->input->post('cuv', TRUE);
                    $pData['claveCatastral'] = $this->input->post('claveCatastral', TRUE);
                    $pData['supTerreno'] = $this->input->post('supTerreno', TRUE);
                    $pData['supConstruccion'] = $this->input->post('supConstruccion', TRUE);
                    $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
                    $precioVenta = $this->input->post('precioVenta', TRUE);
                    $pData['precioVenta'] = ($precioVenta!='')?toInt($precioVenta):0.00;
                    $pData['statusProyecto'] = $this->input->post('statusProyecto', TRUE);
                    $pData['puntaje'] = $this->input->post('puntaje', TRUE);
                    $pData['porcentajeAvance'] = $this->input->post('porcentajeAvance', TRUE);
                    $pData['contratista'] = $this->input->post('contratista', TRUE);
                    $avaluo = $this->input->post('avaluo', TRUE);
                    $pData['avaluo'] = ($avaluo!='')?toInt($avaluo):0.00;
                    $pData['unidadVerificadora'] = $this->input->post('unidadVerificadora', TRUE);
                    $pData['unidadVerificadora'] = $this->input->post('unidadVerificadora', TRUE);
                    $fechaVencimiento = $this->input->post('fechaVencimiento', TRUE);
                    $fechaVencimiento =  str_replace('/', '-', $fechaVencimiento);
                    $pData['fechaVencimiento'] = ($fechaVencimiento!='')?date('Y-m-d', strtotime($fechaVencimiento)):'0000-00-00';//date_format(new DateTime($fechaVencimiento), 'Y-m-d');
                    $fechaDtu = $this->input->post('fechaDtu', TRUE);
                    $fechaDtu =  str_replace('/', '-', $fechaDtu);
                    $pData['fechaDtu'] = ($fechaDtu!='')?date('Y-m-d', strtotime($fechaDtu)):'0000-00-00';
                    $pData['lineaCredito'] = $this->input->post('lineaCredito', TRUE);

                    $pData['tipoVialidad'] = $this->input->post('tipoVialidad', TRUE);
                    $pData['nombreVialidad'] = $this->input->post('nombreVialidad', TRUE);
                    $pData['nivel'] = $this->input->post('nivel', TRUE);
                    $pData['estacionamiento'] = $this->input->post('estacionamiento', TRUE);
                    $pData['tipoPrimeraVialidad'] = $this->input->post('tipoPrimeraVialidad', TRUE);
                    $pData['primeraEntreVialidad'] = $this->input->post('primeraEntreVialidad', TRUE);
                    $pData['tipoSegundaVialidad'] = $this->input->post('tipoSegundaVialidad', TRUE);
                    $pData['segundaEntreVialidad'] = $this->input->post('segundaEntreVialidad', TRUE);
                    $pData['tipoVialidadPosterior'] = $this->input->post('tipoVialidadPosterior', TRUE);
                    $pData['nombreVialidadPosterior'] = $this->input->post('nombreVialidadPosterior', TRUE);
                    $pData['metrosFrente'] = $this->input->post('metrosFrente', TRUE);
                    $pData['orientacion'] = $this->input->post('orientacion', TRUE);

                    $pData['status'] =$this->input->post('status',TRUE);
                }


                $proData['checkboxCimentacion'] = ($this->input->post('checkboxCimentacion', TRUE) != 1 ? 0 : $this->input->post('checkboxCimentacion', TRUE));
                $proData['checkboxAlbPlantaBaja'] = ($this->input->post('checkboxAlbPlantaBaja', TRUE) != 1 ? 0 : $this->input->post('checkboxAlbPlantaBaja', TRUE));
                $proData['checkboxLosaEntrepiso'] = ($this->input->post('checkboxLosaEntrepiso', TRUE) != 1 ? 0 : $this->input->post('checkboxLosaEntrepiso', TRUE));
                $proData['checkboxAlbPrimerNivel'] = ($this->input->post('checkboxAlbPrimerNivel', TRUE) != 1 ? 0 : $this->input->post('checkboxAlbPrimerNivel', TRUE));
                $proData['checkboxLosaPrimerNivel'] = ($this->input->post('checkboxLosaPrimerNivel', TRUE) != 1 ? 0 : $this->input->post('checkboxLosaPrimerNivel', TRUE));
                $proData['checkboxAzotea'] = ($this->input->post('checkboxAzotea', TRUE) != 1 ? 0 : $this->input->post('checkboxAzotea', TRUE));
                $proData['checkboxFachada'] = ($this->input->post('checkboxFachada', TRUE) != 1 ? 0 : $this->input->post('checkboxFachada', TRUE));
                $proData['checkboxAcabados'] = ($this->input->post('checkboxAcabados', TRUE) != 1 ? 0 : $this->input->post('checkboxAcabados', TRUE));
                $proData['checkboxPisos'] = ($this->input->post('checkboxPisos', TRUE) != 1 ? 0 : $this->input->post('checkboxPisos', TRUE));
                $proData['checkboxInstHidroGas'] = ($this->input->post('checkboxInstHidroGas', TRUE) != 1 ? 0 : $this->input->post('checkboxInstHidroGas', TRUE));
                $proData['checkboxCanceleria'] = ($this->input->post('checkboxCanceleria', TRUE) != 1 ? 0 : $this->input->post('checkboxCanceleria', TRUE));
                $proData['checkboxElectrica'] = ($this->input->post('checkboxElectrica', TRUE) != 1 ? 0 : $this->input->post('checkboxElectrica', TRUE));
                $proData['checkboxObraExterior'] = ($this->input->post('checkboxObraExterior', TRUE) != 1 ? 0 : $this->input->post('checkboxObraExterior', TRUE));
                $proData['checkboxBardas'] = ($this->input->post('checkboxBardas', TRUE) != 1 ? 0 : $this->input->post('checkboxBardas', TRUE));
                $proData['checkboxLimpieza'] = ($this->input->post('checkboxLimpieza', TRUE) != 1 ? 0 : $this->input->post('checkboxLimpieza', TRUE));
                $proData['checkboxExtra'] = ($this->input->post('checkboxExtra', TRUE) != 1 ? 0 : $this->input->post('checkboxExtra', TRUE));
                $proData['checkboxImpermeabilizacion'] = ($this->input->post('checkboxImpermeabilizacion', TRUE) != 1 ? 0 : $this->input->post('checkboxImpermeabilizacion', TRUE));
                $proData['checkboxEcotecnologias'] = ($this->input->post('checkboxEcotecnologias', TRUE) != 1 ? 0 : $this->input->post('checkboxEcotecnologias', TRUE));
                $checkAvance = "";
                foreach ($proData as $key => $value) {
                    $checkAvance .= $value.",";
                }
                $checkAvance = trim($checkAvance,",");

                $pData['costoAvance'] = $this->input->post('costoTotal', TRUE);
                $pData['porcentajeAvance'] = $this->input->post('avanceTotal', TRUE);
                $pData['checkAvance'] = $checkAvance;

                if ( $_SESSION[$this->nsession]['rol'] != 9 ) {
                    if ( $pData['statusProyecto'] == 'dtu' ) {
                        $statusAlertDTU = $this->mproyecto->getCampo('statusAlertDTU',$id);
                        if ( $statusAlertDTU == 0 ) {
                            $dPromotores = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($pData['idFraccionamiento']);
                            if ( !is_numeric($dPromotores) ) {
                                $arrMails = [];
                                foreach ($dPromotores->result() as $row) {
                                    $arrProm = array(
                                        "correo" => $this->musuario->getCampo('email',$row->id),
                                        "nombre" => $this->musuario->getCampo('nombre',$row->id) . ' ' . $this->musuario->getCampo('apellidoP',$row->id) . ' ' . $this->musuario->getCampo('apellidoM',$row->id)
                                    );
                                    array_push( $arrMails, $arrProm );
                                }
                                 //print_r($arrMails);exit();
                                // $statusAlertDTU = $this->mproyecto->getCampo('statusAlertDTU',$id);
                                // if ( $statusAlertDTU == 0 ) { $autores = $this->autoRespuesta($arrMails, $pData); }

                        //$autores = $this->autoRespuesta($arrMails, $pData);

                                // echo "<br><br>";
                                // print_r($dPromotores->result()); exit();
                            }
                            $pData['statusAlertDTU'] = 1;
                        }
                    }
                }

                //print_r($pData); exit();
                $oldLinea = $this->mproyecto->getCampo('lineaCredito', $id);
                if(  $pData['lineaCredito'] != $oldLinea ){
                    if(  $pData['lineaCredito'] == 2 ){
                        $pData['statusObra'] = 2;
                    }
                    else{
                        $statusObra = $this->mproyecto->getCampo('statusObra', $id);
                        if(  $pData['statusObra'] == 2 ){
                            //$pData['statusObra'] = 0;
                        }
                    }
                }
                $this->mproyecto->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mproyecto->getById($id);

        $data = $info;
        $data['msg']=$msg;
        $lineasCredito=$this->mlineascredito->getAll();
        $tempLineasCredito=[];
        foreach($lineasCredito->result() as $row){
            $tempLineasCredito[$row->valor]=$row->titulo;
        }
        $data["lineasCredito"]=$tempLineasCredito;
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        $data["dPrototipo"] = 0;
        if( $info['idPrototipo'] != 0 ) {
            $data["dPrototipo"] = $this->mprototipos->getById($info['idPrototipo']);
        }
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAll();
        $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null, $module = null){

        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';
        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                //print_r($data['detalle_venta']);exit();
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                //echo "<h1>".$data['detalle_venta']['id']."</h1>";exit();
                /*-------------------------------Comisiones-------------------------------*/
                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;
                    /*echo "<pre>";
                    print_r($data['detalle_comisionbono']);
                    echo "</pre>";
                    exit();*/

                }
                /*-----------------------------Autorizaciones-----------------------------*/
                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }
                /*--------------------------------Deposito--------------------------------*/
                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }
                /*--------------------------------Entrega---------------------------------*/
                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }
                /*--------------------------------Encuesta--------------------------------*/
                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }
                /*-------------------------------Postventa--------------------------------*/
                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:
                # code...
                break;
        }

        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";
        // exit();
        $data['module'] = ( !is_null($module) ? 'busqueda_vivienda' : 0);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mproyecto->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mproyecto->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function imprimirAvance($id = null)
    {
        $this->load->library("mpdf_lib");

        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';
        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                //echo "<h1>".$data['detalle_venta']['id']."</h1>";exit();
                /*-------------------------------Comisiones-------------------------------*/
                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;
                }
                /*-----------------------------Autorizaciones-----------------------------*/
                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }
                /*--------------------------------Deposito--------------------------------*/
                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }
                /*--------------------------------Entrega---------------------------------*/
                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }
                /*--------------------------------Encuesta--------------------------------*/
                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }
                /*-------------------------------Postventa--------------------------------*/
                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:
                # code...
                break;
        }
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $data['mfraccionamiento'] = $this->mfraccionamiento;

        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";
        // exit();
        // $data['idFraccionamiento'] = $_SESSION['viv']['idFraccionamiento'];
        $html = $this->load->view('proyectos/formatopdf_view.php',$data,true);
        // echo $html; exit();
        $this->mpdf_lib->downloadPDF($html,"detalle_proyecto",0,'footer','header',$this->urlLogo);
    }


    function autoRespuesta( $promotores = null, $proyecto = null ) {
        // $copias = "ruben@navegantes.mx";
        $copiasNV = 'sistemas@viviend.mx';

        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx';*/

        // $para = $emailCliente; // Comprador

        $subject = 'Proyecto en DTU'; // titulo

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $proyecto['idFraccionamiento'];
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';

        $data = array();

        $cuerpo = '<table id="table-proyecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lote: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['lote'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Manzana: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['manzana'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> N&uacute;mero oficial: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['nOficial'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Calle: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['calle'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"> # Paquete: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['numPaquete'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Clave catastral: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['claveCatastral'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie terreno: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supTerreno'].' m<sup>2</sup></td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Superficie construcci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['supConstruccion'].' m<sup>2</sup></td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Precio venta: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($proyecto['precioVenta']).' </td>
                            </tr>
                        </tbody>
                    </table>
                    <!--<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Lote: '.$proyecto['lote'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Manzana: '.$proyecto['manzana'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        N&uacute;mero oficial: '.$proyecto['nOficial'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Calle: '.$proyecto['calle'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Clave catastral: '.$proyecto['claveCatastral'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Superficie terreno: '.$proyecto['supTerreno'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Superficie construcci&oacute;n: '.$proyecto['supConstruccion'].'
                    </span><br>
                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
                        Precio venta: '.$proyecto['precioVenta'].'
                    </span>-->';


        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Proyecto con estatus DTU </h1>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el promotor -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        foreach ($promotores as $row) {
            mail( $row["correo"], $subject, $mensaje, $cabeceras );
        }
        // exit();

        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        /*if ($para !=null){
            mail($para, $subject, $mensaje, $cabeceras);
        }*/

        // para el gerente  -------------------------------------------------
        $subject = 'Viviend - Mensaje de proyecto con estatus DTU';
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: '.$data['nombre'].' <'.$para.'>' . "\r\n";

        $subject2 = 'Viviend - Mensaje de Proyecto DTU';

        // para el administrador
        //mail($copias, $subject2, $mensaje, $cabecerasAdmin);

        // para el NV  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";


        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);


        return true;
    }

    public function autoRespuestaNuevoInventario(){
        $subject = 'Actualización Nuevo Inventario | '.date("d-m-Y H:i"); // titulo


        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";

        $urlLogoFracc = 'http://viviend.mx/sistema/img/logo-300.png';

        $cuerpo = '';
        $cuerpo .= '
            <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-bottom: 30px;">
                <tbody>
                    <tr>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ENLACE DE DESCARGA: </td>
                        <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">
                            <a href="'.base_url().'notificaciones/nuevoInventario">DESCARGAR</a>
                        </td>
                    </tr>
                </tbody>
            </table>';

            $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Actualización de Nuevo Inventario </h3>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        $gerentes = "";
        $gestores = "";
        $usuarios = $this->musuario->getAll();
        if ( !is_numeric($usuarios) ){
            foreach ($usuarios->result() as $key3 => $value3) {
                if ( $value3->rol == 3 ) { $gestores .= $value3->email.","; }
                //if ( $value3->rol == 4 ) { $gerentes .= $value3->email.","; }
            }
            $gestores = trim($gestores, ',');
            $gerentes = trim($gerentes, ',');
        }

        if ( $gerentes != "" ) {
            mail($gerentes, $subject, $mensaje, $cabeceras);
        }
        if ( $gestores != "" ) {
            mail($gestores, $subject, $mensaje, $cabeceras);
        }

        //tecnica
        $user_tecnica = $this->musuario->getTecnicaBySelectResult();
        if ( !is_numeric($user_tecnica) ) {
            foreach ($user_tecnica->result() as $row) {
                $mail_ = $this->musuario->getCampo('email',$row->id);
                if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
            }
        }
        //conta
        $user_conta = $this->musuario->getContabilidadBySelectResult();
        if ( !is_numeric($user_conta) ) {
            foreach ($user_conta->result() as $row) {
                $mail_ = $this->musuario->getCampo('email',$row->id);
                if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
            }
        }
        //merca
        $user_merca = $this->musuario->getMercaBySelectResult();
        if ( !is_numeric($user_merca) ) {
            foreach ($user_merca->result() as $row) {
                $mail_ = $this->musuario->getCampo('email',$row->id);
                if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
            }
        }
        //merca
        $user_obra = $this->musuario->getResidenteObraBySelectResult();
        if ( !is_numeric($user_obra) ) {
            foreach ($user_obra->result() as $row) {
                $mail_ = $this->musuario->getCampo('email',$row->id);
                if ( $mail_ != null && $mail_ != '' ) { mail($mail_, $subject, $mensaje, $cabeceras); }
            }
        }

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';

        // para el administrador
        mail($copiasNV, $subject, $mensaje, $cabeceras);

        /*echo $mensaje;
        exit();*/
    }

    public function importar()
    {
        $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
        $data = array();
        $data['msg'] = '';
        $this->load->library('form_validation');
        if(isset($_FILES['archivo'])){
            $_POST['archivo'] = $_FILES['archivo']['name'];
            $this->form_validation->set_rules('archivo', 'Archivo de Coordenadas', 'required');
            if ($this->form_validation->run() == FALSE) {
                $data['msg'] = validation_errors();
            }else{
                if (isset($_FILES['archivo']) && $_SERVER['REQUEST_METHOD'] == 'POST'){
                    $config['upload_path'] = $this->data['fotos_www'];
                    $config['allowed_types'] = 'csv';
                    $config['max_size'] = '2000';

                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload("archivo")) {
                        $msg = $this->upload->display_errors();
                    }else{
                        $file_data = $this->upload->data();
                        $file_path = $this->data['fotos_www'] . $file_data['file_name'];

                        if ($this->csvimport->get_array($file_path, '', TRUE)) {
                            $csv_array = $this->csvimport->get_array($file_path);
                            if (isset($csv_array[0]['idFraccionamiento']) && isset($csv_array[0]['idProyecto']) && isset($csv_array[0]['lote']) && isset($csv_array[0]['manzana']) && isset($csv_array[0]['coordenadas'])) {
                                $array = array();
                                foreach ($csv_array as $r) {
                                    $idFraccionamiento = $r['idFraccionamiento'];
                                    $lote = $r['lote'];
                                    $manzana = $r['manzana'];
                                    $datos['idFraccionamiento'] = $idFraccionamiento;
                                    $datos['idProyecto'] = 0;
                                    $datos['lote'] = $lote;
                                    $datos['manzana'] = $manzana;
                                    $datos['coordenadas'] = $r['coordenadas'];
                                    $datos['status'] = 1;
                                    $datos['created'] = date("Y-m-d H:i:s");
                                    $datos['updated'] = date("Y-m-d H:i:s");
                                    $datos['created_by'] = $sessionId;
                                    $datos['updated_by'] = $sessionId;
                                    $query = $this->db->query("SELECT id FROM proyectos WHERE idFraccionamiento = $idFraccionamiento AND lote = $lote AND manzana = $manzana");
                                    if($query->num_rows() > 0){
                                        $datos['idProyecto'] = $query->row()->id;
                                    }

                                    array_push($array, $datos);
                                }

                                $this->db->insert_batch('coordenadas_lotes', $array);
                            }

                            @unlink($file_path);
                        }

                        redirect($this->router->class);
                    }
                }
            }
        }
        $this->data['contenido'] = $this->load->view($this->mainView . '/importar_view', $data, true);
		$this->load->view('templates/main_template', $this->data);
    }

}