<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proveedores extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'proveedores'; // form validation variable
            $this->mainView = 'proveedores';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/proveedores/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mproveedor','musuario','mempresas', 'mlogsws'));
            $this->load->library('excel');
            $this->load->library("curl");
            valSession("materiales",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $logsWs = $this->mlogsws->getByIdEmpresaTabla($idEmpresa, 'proveedores');
        $msgLogs = '';
        $showNotification = 0;
        if(!is_numeric($logsWs)){
            if($logsWs['status'] == 0){
                $user = $this->musuario->getById($logsWs['created_by']);
                $msgLogs = 'Sincronización Realizada Por: '.$user['nombre'].' '.$user['apellidoP'].'<br><br><br>';
                $msgLogs .= 'Registros Insertados: '.$logsWs['insertados'].'<br><br>';
                $msgLogs .= 'Registros Actualizados: '.$logsWs['actualizados'].'<br><br>';
                $msgLogs .= 'Total Registros: '.$logsWs['totalRegistros'].'<br><br>';
                $showNotification = 1;
                $pData['status'] = 1;
                $this->mlogsws->actualizar($pData, $logsWs['id']);
            }
        }
        $data['msgLogs'] = $msgLogs;
        $data['showNotification'] = $showNotification;
     /*   $data['seccion'] = $this->uri->segment(1);*/
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }


    public function listado(){
        $list = $this->mproveedor->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $proveedor) {
            $validar = true;
            //$acciones = accionesProveedores($proveedor->id, $this->router->class, false, false, false,false , false, false);
            $no++;
            $row = array();
            //$row[] = $no;
            // $row[] = $acciones;
          /*  $row[] = $proveedor->id;*/
            $row[] = $proveedor->nombre;
            $row[] = $proveedor->clave;
            $row[] = $proveedor->rfc;
            $row[] = $proveedor->ciudad;
            $row[] = $proveedor->cp;
            $row[] = $proveedor->email;
            $data[] = $row;
        }
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mproveedor->count_all(),
                        "recordsFiltered" => $this->mproveedor->count_filtered(),
                        "data" => $data,
                );
        echo json_encode($output);
  
    }

    public function excel(){
       $q = $this->mproveedor->getAllExcelRows();
       $columnas = array(
                /*    0 => 'ID',*/
                    0 => 'RAZON SOCIAL',
                    1 => 'CLAVE',
                    2 => 'RFC',
                    3 => 'CIUDAD',
                    4 => 'C.P',
                    5 => 'EMAIL'
        );
       crearExcel($q,'proveedores',$columnas);
    }

    public function createExel($data,$nombre,$columnas=array()){
            //echo '<pre>';  print_r(count($columnas)); exit();
            //echo '<pre>';  print_r($columnas); exit();

     /*       $exportar = false;
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();

            $objPHPExcel->getActiveSheet()->setTitle($nombre);
            $objPHPExcel->setActiveSheetIndex(0);*/
            //CREAR LOS ENCABEZADOS DINAMICOS

         /*   $letra= 'A';
            $i=0;
            foreach ($columnas as $row) {
                 $objPHPExcel->getActiveSheet()->SetCellValue($letra.'1', $columnas[$i]);
                 $letra++;
                 $i++;
            }*/

/*
             echo '<pre>'; print_r($data); exit();
            $rowCount = 2;
            $i=0;
            $i2= 0;
            foreach ($data as  $key =>  $val) {
                 $i2++;
                    foreach ($val as $k => $v) {
               echo '<pre>';  print_r($v) ; 
                $i2++;

                    }
                $i++;
            }*/


        /*    break;*/



         /*   $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'RAZON SOCIAL');
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CLAVE');
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'RFC');
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'CIUDAD');
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'C.P.');
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'EMAIL');*/
    /*     
            $rowCount = 2;
            foreach($data->result() as $row){
               $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row->nombre);
               $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row->clave);
               $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row->rfc);
               $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row->ciudad);
               $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row->cp);
               $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row->email);
                $rowCount++;
            }*/
 
            $name = $nombre;
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
            // Forzamos a la descarga
            $objWriter->save('php://output');
     
    }


    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';


        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['clave'] = $this->input->post('clave', TRUE);
            $pData['razonSocial'] = $this->input->post('razonSocial', TRUE);
            $pData['rfc'] = $this->input->post('rfc', TRUE);

            $pData['status'] = 1;
            $id = $this->mproveedor->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['clave'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                  $pData['clave'] = $this->input->post('clave', TRUE);
                  $pData['razonSocial'] = $this->input->post('razonSocial', TRUE);
                  $pData['rfc'] = $this->input->post('rfc', TRUE);
                  $pData['status'] =$this->input->post('status',TRUE);
                $this->mproveedor->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mproveedor->getById($id);

        $data = $info;
        $data['msg']=$msg;

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null){
        $info = $this->mproveedor->getById($id);
        $data = $info;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mproveedor->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mproveedor->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function updateWS(){
        ini_set('max_execution_time', 300);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos = json_encode(array("un" => $idEmpresa));
        $time_start = microtime(true);
        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetProveedores",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30000,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $res['status'] = false;

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'proveedores';
            $dataL['funcion'] = 'GetProveedores';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {   
                    case 200:
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;

                            $json = json_decode($json);
                            foreach ($json->object_result as $row) {
                                foreach ($row as $key => $val){
                                    switch ($key) {
                                        default:
                                            $data[$key]=$val;
                                    }
                                }    
                                $data["idEmpresa"]=$idEmpresa;
                                if($this->mproveedor->valInsert($data["id"],$idEmpresa)){
                                    $this->mproveedor->insertar($data);
                                    $nInsert++; 
                                }else if($this->mproveedor->valUpdate($row->id,$data)){
                                    $this->mproveedor->actualizar($data,$data["id"]);
                                    $nUpdate++;
                                }
                                $nTotal++;
                            }

                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        curl_close($curl);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        redirect($this->mainView);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'proveedores';
                        $dataL['funcion'] = 'GetProveedores';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
    }

}


