<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Prospectos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$appProduction;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');

            $this->fv = 'prospectos'; // form validation variable
            $this->mainView = 'prospectos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/prospectos/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mprospecto','mprospecto2','musuario','mfraccionamiento','maltaventa','mgestoria','mproyecto','mprototipos','mprototipoxfraccionamiento','mfraccionamientoxusuario','mlugaresprospeccion'));
            $this->appProduction = $this->config->item('appProduction');
            // Debugging
            $this->output->enable_profiler(false);
            //limite de tiempo y memoria
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);
           //Validación de usuarios
	        valSession("ventas",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        //$delDia = $this->mprospecto->getCurrentDay();
        //print_r($delDia);exit();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function checkLugar(){
        $idLugar = $this->input->post('idLugar', TRUE);
        $rowLugar = $this->mlugaresprospeccion->getById($idLugar);
        if (!is_numeric($rowLugar)){
            $data['statusDescripcion'] = $rowLugar['statusDescripcion'];
        }else{
            $data['statusDescripcion'] = 0;
        }
        echo json_encode($data);
    }

/*    public function listado(){
        $q = $this->mprospecto->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $av = $this->maltaventa->getByIdProspecto($row->id);
                if (!is_numeric($av)){
                    $idProyecto = $av['idProyecto'];
                    $fechaAv  = ($av['fechaVenta']!='' && $av['fechaVenta']!='0000-00-00')?$av['fechaVenta']:''; // este campo se guadr por default con la fecha de la alta de venta
                    $eliminar = false;
                }else{
                    $idProyecto = 0;
                    $fechaAv = '';
                    $eliminar = true;
                }
                $array['aaData'][] = array(
                    'promotor' => ($row->idPromotor >0)?strtoupper($this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor)):'',
                    'nombre' => strtoupper($row->nombre." ".$row->apellidoP),
                    'lugarProspeccion' => ($row->idLugar>0)?strtoupper($this->mlugaresprospeccion->getCampo('titulo',$row->idLugar)):'',//$row->lugarProspeccion,
                    'rfc' => strtoupper($row->rfc),
                    'telefono' => $row->telefono,
                    'puntaje' => $row->puntaje,
                    'valorCredito' => $row->valorCredito,
                    'statusProspecto2' => strtoupper($row->statusProspecto2),
                    //'nombreConyuge' => $row->nombre2." ".$row->apellidoP2,
                    //'rfcConyuge' => $row->rfc2,
                    'desarrollo' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                    'interesadoEn' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),//$row->interesadoEn,
                    'nss' => $row->nss.".",
                    'fechaAv' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',
                    //'lugarProspeccion' => $row->lugarProspeccion,
                    'prototipo' => ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'', //$row->prototipo,
                    'fecha' => ($row->fecha!='' && $row->fecha!='0000-00-00')?date_format(new DateTime($row->fecha),'d/m/Y'):'',//date_format($row->fecha, "d-m-Y"),
                    'statusVivienda' => strtoupper(estatus_proyecto_reporte(($idProyecto>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto):0)),
                    'acciones' => accionesP($row->id,$this->router->class, true, true, $eliminar)
                    );
            }
        }else{
            $array['aaData'][] = array(
                'promotor'=> 'No hay registros',
                'nombre' => 'No hay registros',
                'rfc' => 'No hay registros',
                'telefono' => 'No hay registros',
                'puntaje' => 'No hay registros',
                'valorCredito' => 'No hay registros',
                'statusProspecto2' => 'No hay registros',
                'desarrollo' => 'No hay registros',
                'interesadoEn' => 'No hay registros',
                'nss' => 'No hay registros',
                'fechaAv' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'fecha' => 'No hay registros',
                'lugarProspeccion' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }*/

    public function listado(){
        $list = $this->mprospecto2->get_datatables();
        $data = array();
        $no = $_POST['start'];

        foreach ($list as $row) {
            $av = $this->maltaventa->getByIdProspecto($row->id);
            if (!is_numeric($av)){
                $idProyecto = $av['idProyecto'];
                $fechaAv  = ($av['fechaVenta']!='' && $av['fechaVenta']!='0000-00-00')?$av['fechaVenta']:''; // este campo se guadr por default con la fecha de la alta de venta
                $eliminar = false;
                $ronda = ($this->mgestoria->getRondaByIdAv($av['id'])!=0)?$this->mgestoria->getRondaByIdAv($av['id']):'';
            }else{
                $idProyecto = 0;
                $fechaAv = '';
                $eliminar = true;
                $ronda = '';
            }
            $no++;
            $list = array();
            $list[] = accionesP($row->id,$this->router->class, true, true, $eliminar);
            $list[] = strtoupper(estatus_proyecto_reporte(($idProyecto>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto):0));
            $list[] = $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento);
            $list[] = ($row->idPromotor >0)?strtoupper($this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor)):'';
            $list[] = strtoupper($row->nombre." ".$row->apellidoP);
            $list[] = rfcAEdad($row->rfc);
            $list[] = $row->salario;
            $list[] = ($row->idLugar>0)?strtoupper($this->mlugaresprospeccion->getCampo('titulo',$row->idLugar)):'';
            $list[] = $ronda;
            $list[] = strtoupper($row->rfc);
            $list[] = $row->telefono;
            $list[] = $row->puntaje;
            $list[] = $row->valorCredito;
            $list[] = strtoupper($row->statusProspecto2);
            $list[] = $row->nss.".";
            $list[] = ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'';
            $list[] = $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento);
            $list[] = ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'';
            $list[] = ($row->fecha!='' && $row->fecha!='0000-00-00')?date_format(new DateTime($row->fecha),'d/m/Y'):'';
            $data[] = $list;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mprospecto2->count_all(),
                        "recordsFiltered" => $this->mprospecto2->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function nuevo($pre=0)
    {
        // Mensajes
        $data['msg'] = '';
        $data['promotores'] = [];
        $data['prototipos'] = [];
        if($pre=="p"){
            $data["pre"]=true;
            $this->fv.="_pre";
        }
        // $data['promotores'] = $this->musuario->getPromotoresBySelectResult();
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        $data['lugaresProspeccion'] = $this->mlugaresprospeccion->getByModulo(1); //modulo 1 = prospectos
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
        // $data['prototipos'] = 0;
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
              /*  echo ($data['msg']);
            exit();*/
            $idFraccionamiento = $this->input->post('idFraccionamiento', TRUE);
            if ( $idFraccionamiento != '' && $idFraccionamiento > 0 ) {
                $data['promotores'] =  $this->getPromotores($idFraccionamiento);
                $data['prototipos'] =  $this->getPrototiposByFraccForSelect($idFraccionamiento);
                // echo "<pre>"; print_r($data); echo "</pre>"; exit();
            }
            else {
                $data['promotores'] = [];
                $data['prototipos'] = [];
            }

        } else {
            $fechaNac = rfcANacimiento($this->input->post('rfc', TRUE));
            $pData['idPromotor'] = $this->input->post('idPromotor', TRUE);
            $pData['curp'] = $this->input->post('curp', TRUE);
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
            $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
            $pData['edad'] = rfcAEdad($this->input->post('rfc', TRUE));
            $pData['salario'] = $this->input->post('salario', TRUE);
            $pData['rfc'] = $this->input->post('rfc', TRUE);
            $pData['telefono'] = $this->input->post('telefono', TRUE);
            $pData['nombre2'] = $this->input->post('nombre2', TRUE);
            $pData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
            $pData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
            $pData['rfc2'] = $this->input->post('rfc2', TRUE);
            $pData['telefono2'] = $this->input->post('telefono2', TRUE);
            $fecha = $this->input->post('fecha', TRUE);
            $fecha =  str_replace('/', '-', $fecha);
            $pData['fecha'] = ($fecha!='')?date('Y-m-d', strtotime($fecha)):'0000-00-00';//date_format(new DateTime($fecha),'Y-m-d');
            $pData['fechaNac'] = ($fechaNac!='')?date('Y-m-d', strtotime($fechaNac)):'0000-00-00';//date_format(new DateTime($fechaNac),'Y-m-d');
            $fechaNac2 = $this->input->post('fechaNac2', TRUE);
            $fechaNac2 =  str_replace('/', '-', $fechaNac2);
            $pData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';
            $pData['paisNac'] = $this->input->post('paisNac', TRUE);
            $pData['nacionalidad'] = ($pData['paisNac']=='méxico')?'mexicana':'extranjera';//$this->input->post('nacionalidad', TRUE);
            $pData['paisResidencia'] = ($pData['paisNac']=='méxico')?'méxico':'extranjero';//$this->input->post('paisResidencia', TRUE);
            //$pData['lugarProspeccion'] = $this->input->post('lugarProspeccion', TRUE);
            $pData['otroLugar'] = $this->input->post('otroLugar', TRUE);
            $pData['idLugar'] = $this->input->post('idLugar', TRUE);
            $pData['nss'] = $this->input->post('nss', TRUE);
            $pData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);
            //$pData['interesadoEn'] = $this->input->post('interesadoEn', TRUE);
            $pData['prototipo'] = $this->input->post('prototipo', TRUE);
            $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
            $pData['puntaje'] = $this->input->post('puntaje', TRUE);
            $pData['valorCredito'] = $this->input->post('valorCredito', TRUE);
            $pData['statusProspecto2'] = $this->input->post('statusProspecto2', TRUE);

            $pData['comentario'] = $this->input->post('comentario', TRUE);
            $pData['status'] = 1;
            $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);//$_SESSION[$this->nsession]['idFraccionamiento'];

            $pData['mercadotecnia'] = 0;

            $validNss = $this->mprospecto->existNss($pData['nss']);
            if ($validNss == 0 || $pData['nss']==''){ // validamos que sea un nss no registrado
                $id = $this->mprospecto->insertar($pData);
                $this->db->query("UPDATE prospectos SET created_by=".$pData['idPromotor']." WHERE id=".$id);
                $pData['lugarProspeccion'] = ($pData['idLugar'] > 0)?$this->mlugaresprospeccion->getCampo('titulo',$pData['idLugar']):'';
                $autores = $this->autoRespuesta($pData);

                redirect($this->router->class);
            }else{
                $data['msgInvalid'] = 'El NSS ya se encuentra registrado';
            }

        }

        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['nombre'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $fechaNac = rfcANacimiento($this->input->post('rfc', TRUE));
                $pData['idPromotor'] = $this->input->post('idPromotor', TRUE);
                $pData['curp'] = $this->input->post('curp', TRUE);
                $pData['nombre'] = $this->input->post('nombre', TRUE);
                $pData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                $pData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                $pData['edad'] = rfcAEdad($this->input->post('rfc', TRUE));
                $pData['salario'] = $this->input->post('salario', TRUE);
                $pData['rfc'] = $this->input->post('rfc', TRUE);
                $pData['telefono'] = $this->input->post('telefono', TRUE);
                $pData['nombre2'] = $this->input->post('nombre2', TRUE);
                $pData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
                $pData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
                $pData['rfc2'] = $this->input->post('rfc2', TRUE);
                $pData['telefono2'] = $this->input->post('telefono2', TRUE);
                $fecha = $this->input->post('fecha', TRUE);
                $fecha =  str_replace('/', '-', $fecha);
                $pData['fecha'] = ($fecha!='')?date('Y-m-d', strtotime($fecha)):'0000-00-00';//date_format(new DateTime($fecha),'Y-m-d');
                $pData['fechaNac'] = ($fechaNac!='')?date('Y-m-d', strtotime($fechaNac)):'0000-00-00';
                $fechaNac2 = $this->input->post('fechaNac2', TRUE);
                $fechaNac2 =  str_replace('/', '-', $fechaNac2);
                $pData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';
                $pData['paisNac'] = $this->input->post('paisNac', TRUE);
                $pData['nacionalidad'] = ($pData['paisNac']=='méxico')?'mexicana':'extranjera';//$this->input->post('nacionalidad', TRUE);
                $pData['paisResidencia'] = ($pData['paisNac']=='méxico')?'méxico':'extranjero';//$this->input->post('paisResidencia', TRUE);
                //$pData['lugarProspeccion'] = $this->input->post('lugarProspeccion', TRUE);
                $pData['otroLugar'] = $this->input->post('otroLugar', TRUE);
                $pData['idLugar'] = $this->input->post('idLugar', TRUE);
                $pData['nss'] = $this->input->post('nss', TRUE);
                $pData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);
                $pData['comentario'] = $this->input->post('comentario', TRUE);
                //$pData['interesadoEn'] = $this->input->post('interesadoEn', TRUE);
                $pData['puntaje'] = $this->input->post('puntaje', TRUE);
                $pData['valorCredito'] = $this->input->post('valorCredito', TRUE);
                $pData['statusProspecto2'] = $this->input->post('statusProspecto2', TRUE);
                $pData['prototipo'] = $this->input->post('prototipo', TRUE);
                $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
                $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);//$_SESSION[$this->nsession]['idFraccionamiento'];
                // echo "<pre>"; print_r($pData); echo "</pre>"; exit();

                $this->mprospecto->actualizar($pData, $id);
                $this->db->query("UPDATE prospectos SET created_by=".$pData['idPromotor']." WHERE id=".$id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mprospecto->getById($id);

        $data = $info;
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $data['msg']=$msg;
        // $data['promotores'] = $this->musuario->getPromotoresBySelectResult();
        $data['promotores'] = $this->musuario->getPromotoresBySelectResult2($info['idFraccionamiento']);
        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        $data['lugaresProspeccion'] = $this->mlugaresprospeccion->getByModulo(1); //modulo 1 = prospectos
        // $data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
        $data['prototipos'] =  $this->getPrototiposByFraccForSelect($info['idFraccionamiento']);
        $idLugar = $this->mprospecto->getCampo('idLugar',$id);
        $idLugar = ($idLugar > 0)?$idLugar :0;
        $data['statusDescripcion'] = $this->mlugaresprospeccion->getCampo('statusDescripcion',$idLugar);
        // echo "<pre>"; print_r($data['promotores']); echo "</pre>"; exit();

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function reporte(){
        $data=[];
        $this->data['contenido'] = $this->load->view($this->mainView . '/reporte_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function exportarReporte(){
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', 0);
        $filter="";
        if(isset($_POST["fecha_inicio"]) && isset($_POST["fecha_fin"])){
            $fechaInicio=$_POST["fecha_inicio"];
            $fechaFin=$_POST["fecha_fin"];
            if($fechaInicio != "" && $fechaFin != ""){
                $fechaInicio = date_format(new DateTime($fechaInicio),"Y-m-d");
                $fechaFin = date_format(new DateTime($fechaFin),"Y-m-d");
                $filter.=" AND (pr.fecha >= DATE('$fechaInicio') AND pr.fecha <= DATE('$fechaFin') + INTERVAL 1 DAY)";
            }
        }
        $query=$this->db->query("SELECT pr.id,CONCAT(u.nombre,' ',u.apellidoP,' ',u.apellidoM) asesor,pr.fecha, DATEDIFF(CURDATE(),pr.fecha) dias, CONCAT(pr.nombre,' ',pr.apellidoP,' ',pr.apellidoM) cliente, 
        pr.nss,pr.valorCredito,pr.tCreditoInteresado,lp.titulo titulol, fr.titulo titulof, pr.comentario,IF(pr.status=1,'Activo','Inactivo') Estatus FROM prospectos pr
        LEFT JOIN usuarios u ON u.id=pr.idPromotor
        LEFT JOIN lugares_prospeccion lp ON lp.id=pr.idLugar
        LEFT JOIN fraccionamientos fr ON fr.id=pr.idFraccionamiento  
        WHERE pr.id $filter
        ORDER BY `pr`.`fecha` DESC");
        if($query->num_rows() > 0){
            $query=$query->result_array();
            $columnas = array(
                0 => 'ID',
                1 => 'ASESOR',
                2 => 'FECHA DE REGISTRO',
                3 => 'DIAS TRANSCURRIDOS',
                4 => 'CLIENTE',
                5 => 'NSS',
                6 => 'MONTO(VALOR CREDITO)',
                7 => 'TIPO CREDITO INTERESADO',
                8 => 'LUGAR DE PROSPECCION',
                9 => 'FRACCIONAMIENTO',
                10 => 'COMENTARIOS',
                11 => 'ESTATUS',
            );
            crearExcel($query,'Reporte de Seguimiento',$columnas,"array");
        }else{
            echo "No existen datos para exportar";
        }

    }

    public function getInfo(){
        $result = array();
        $id = $this->input->post('idProspecto', TRUE);
        if ($id > 0){
            $p_data = $this->mprospecto->getById($id);
            if (!is_numeric($p_data)){
                //$r = $p_data->row();
                // echo "<pre>"; print_r($p_data); echo "</pre>"; exit();
                $data['id'] = $p_data['id'];
                $data['idPromotor'] = $p_data['idPromotor'];

                $data['promotor'] = $this->musuario->getCampo("nombre",$data['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$data['idPromotor']);
                $data['nombre'] = $p_data['nombre'];
                $data['apellidoP'] = $p_data['apellidoP'];
                $data['apellidoM'] = $p_data['apellidoM'];
                $data['nombre2'] = $p_data['nombre2'];
                $data['apellidoP2'] = $p_data['apellidoP2'];
                $data['apellidoM2'] = $p_data['apellidoM2'];
                $data['curp'] = $p_data['curp'];
                $data['rfc'] = $p_data['rfc'];
                $data['telefono'] = $p_data['telefono'];
                $data['fecha'] = date_format(new DateTime($p_data['fecha']),'d/m/Y');
                $data['fechaNac'] = date_format(new DateTime($p_data['fechaNac']),'d/m/Y');
                $data['nss'] = $p_data['nss'];
                $data['statusProspecto'] = $p_data['statusProspecto'];
                $data['status'] = $p_data['status'];
                $data['success'] = 1;

                $data['idFraccionamiento'] = $p_data['idFraccionamiento'];
                $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$p_data['idFraccionamiento']);

                $lotes = $this->mproyecto->getBySelectResult2($p_data['idFraccionamiento']);
                //print_r($lotes);exit();
                $data['proyectos'] = (!is_numeric($lotes))?$lotes->result():$lotes;
                // echo "<pre>"; print_r($data); echo "</pre>"; exit();
            }else{
                $data['success'] = 0;
            }
        }else{
            $data['success'] = 0;
        }

        echo json_encode($data);
    }

    public function validarNss(){
        $nss = $this->input->post('nss', TRUE);
        $data['success'] = true;
        $validNss = $this->mprospecto->existNss($nss);
        if ($validNss!=0){
            $data['success'] = false;
        }
        if ($nss==''){
            $data['success'] = true;
        }
        echo json_encode($data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mprospecto->getById($id);
        $cValor = "true";
        $this->mprospecto->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function ver($id = null)
    {
        $info = $this->mprospecto->getById($id);
        $data = $info;
        $data['module'] = 0;
        $data['mpromotor'] = $this->musuario;
        $data['mprototipos'] = $this->mprototipos;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    function autoRespuesta( $prospecto = null ) {
        // $copias = "ruben@navegantes.mx";

        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx';*/

        $copiasNV = 'sistemas@viviend.mx';

        // $para = $emailCliente; // Comprador

        $subject = 'Nuevo prospecto de vivienda'; // titulo

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $prospecto['idFraccionamiento'];
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';

        $data = array();

        $promotor = $this->musuario->getById($prospecto['idPromotor']);
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];
        $nombrePrototipo = ($prospecto['idPrototipo']>0)?$this->mprototipos->getCampo('nombre',$prospecto['idPrototipo']):'';

        $cuerpo = '
                    <table id="table-prospecto" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospección: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre de prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Teléfono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nss'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de nacimiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fechaNac']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Status prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['statusProspecto'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lugar de prospección: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['lugarProspeccion'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Prototipo: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePrototipo.' </td>
                            </tr>
                            <!-- <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"> Promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;"> '.$nomPromotor.' </td>
                            </tr> -->
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Comentarios: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['comentario'].' </td>
                            </tr>
                        </tbody>
                    </table>';


        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }

                table#table-prospecto td:nth-child(1) {
                    width: 50%;
                    padding-left: 10px;
                }
                table#table-prospecto td:nth-child(2) {
                    width: 50%;
                    padding-left: 10px;
                }

                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nuevo prospecto </h3>
                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        //echo $mensaje;exit();
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // $para = $this->musuario->getCampo("email", $this->musuario->getGerente());
        //$para = $this->musuario->getCampo("email", $this->musuario->getGerentes2($idFraccionamiento));
         if($this->appProduction){
            $qGerentes = $this->musuario->getGerentes2($idFraccionamiento);
            if( !is_numeric($qGerentes) ){
                foreach($qGerentes->result() as $gteV){
                    $para = $this->musuario->getCampo("email", $gteV->id);
                    if ($para){
                        mail($para, $subject, $mensaje, $cabeceras);
                    }
                }
            }

            // Enviar autorespuesta a gestores por fraccionamiento -------------
            $gestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($idFraccionamiento);
            if ( !is_numeric($gestores) ) {
                $correoGestor = '';
                $bandRow = 0;
                foreach ($gestores->result() as $key => $value) {
                    if ( $bandRow > 0 ) { $correoGestor .= ", "; }
                    $correoGestor .= $this->musuario->getCampo('email',$value->id);
                    $bandRow = $bandRow + 1;
                }
                mail($correoGestor, $subject, $mensaje, $cabeceras);
            }
        } else{
            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
            mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);    
            mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);    
        }
        
        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        //mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }

    public function getPromotores($id='')
    {
        $promotores = $this->mfraccionamientoxusuario->getPromotoresSelectResultByIdFracc($id);
        $response = array();
        if ( !is_numeric($promotores) ) {
            foreach ($promotores->result() as $key => $value) {
                $response[$value->id] = $this->musuario->getCampo('nombre',$value->id)." ".$this->musuario->getCampo('apellidoP',$value->id)." ".$this->musuario->getCampo('apellidoM',$value->id);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getPrototiposByFraccForSelect($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $response[$value->idPrototipo] = $this->mprototipos->getCampo('nombre',$value->idPrototipo);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function excel($tipo)
    {
        $array = array();
        switch ($tipo) {
            case 1:
                $columnas = array(
                    0 => 'ESTATUS',
                    1 => 'FRACCIONAMIENTO',
                    2 => 'PROMOTOR',
                    3 => 'CLIENTE',
                    4 => 'LUGAR DE PROSPECCION',
                    5 => 'RONDA',
                    6 => 'RFC',
                    7 => 'TELEFONO',
                    8 => 'PUNTAJE',
                    9 => 'VALOR CREDITO',
                    10 => 'COMPLETA/NO COMPLETA',
                    11 => 'NSS',
                    12 => 'FECHA ALTA',
                    13 => 'INTERESADO EN',
                    14 => 'PROTOTIPO',
                    15 => 'FECHA PROSPECCION',
                );
                $nombre = 'Prospectos';
                $q = $this->mprospecto->getAll();
                if (!is_numeric($q)){
                    $i=0;
                    foreach ($q->result() as $row){
                        $av = $this->maltaventa->getByIdProspecto($row->id);
                        if (!is_numeric($av)){
                            $idProyecto = $av['idProyecto'];
                            $fechaAv  = ($av['fechaVenta']!='' && $av['fechaVenta']!='0000-00-00')?$av['fechaVenta']:''; // este campo se guadr por default con la fecha de la alta de venta
                            $eliminar = false;
                            $ronda = ($this->mgestoria->getRondaByIdAv($av['id'])!=0)?$this->mgestoria->getRondaByIdAv($av['id']):'';
                        }else{
                            $idProyecto = 0;
                            $fechaAv = '';
                            $eliminar = true;
                            $ronda = '';
                        }
                        $array[$i] = array(
                            'statusVivienda' => strtoupper(estatus_proyecto_reporte(($idProyecto>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto):0)),
                            'desarrollo' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),
                            'promotor' => ($row->idPromotor >0)?strtoupper($this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor)):'',
                            'nombre' => strtoupper($row->nombre." ".$row->apellidoP),
                            'lugarProspeccion' => ($row->idLugar>0)?strtoupper($this->mlugaresprospeccion->getCampo('titulo',$row->idLugar)):'',//$row->lugarProspeccion,
                            'ronda' => $ronda,
                            'rfc' => strtoupper($row->rfc),
                            'telefono' => $row->telefono,
                            'puntaje' => $row->puntaje,
                            'valorCredito' => $row->valorCredito,
                            'statusProspecto2' => strtoupper($row->statusProspecto2),
                            'nss' => $row->nss.".",
                            'fechaAv' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',
                            'interesadoEn' => $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento),//$row->interesadoEn,
                            'prototipo' => ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'', //$row->prototipo,
                            'fecha' => ($row->fecha!='' && $row->fecha!='0000-00-00')?date_format(new DateTime($row->fecha),'d/m/Y'):'',//date_format($row->fecha, "d-m-Y"),
                            );

                        $i++;
                    }
                }

                break;
        }

        crearExcel($array,$nombre,$columnas,'array');
    }
}

?>