<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Presupuestos extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'presupuestos'; // form validation variable
			$this->mainView = 'presupuestos';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/presupuestos/listado.js?v=0.1" type="text/javascript"></script>
								  <script src="assets/js/presupuestos/listadoDetalle.js?v=0.2" type="text/javascript"></script>
								  <script src="assets/js/presupuestos/listadoResumen.js?v=0.1" type="text/javascript"></script>
								  <script src="assets/js/presupuestos/bootstrap-fileinput.js" type="text/javascript"></script> ';
			$this->data['css'] = '<link href="assets/css/bootstrap-fileinput.css" rel="stylesheet" type="text/css" />';
			// Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mfraccionamiento', 'mprototipoxfraccionamiento', 'mprototipos', 'mpaquete', 'mactividadesprototipo', 
			'mmaterialesactividadprototipo', 'mmaterial', 'mpresupuestomat','mmateriales', 'munidades', 'mproveedor', 'mareamaterial', 'musuario', 
			'mmanoobra','mordencompra','mdetallepaquete','mpresupuestomo','malmacenes','mconstructores','mempresas','mcategoriamat','marranque','majustes',
			'mpresupuestos'));

			$this->load->library('csvimport');
			$this->load->library('excel');
            $this->data['fotos_www'] = $this->config->item('base_www').'/presupuestos/';
			valSession("costos",$this->fv);
		}

		public function index(){
			$data['q'] = '';
			$data['msg'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
	        $this->load->view('templates/main_template',$this->data);
		}

		public function listado(){
	        $q = $this->mpresupuestos->getAll();
	        if (!is_numeric($q)){
				foreach ($q->result() as $row){
					$totalpmo = $this->mpresupuestomo->getSumTotalUnitario($row->idPmo);
					$totalpmat = $this->mpresupuestomat->getSumTotalUnitario($row->idPmat);
	                $array['aaData'][] = array(
						'titulo' => $row->titulo,
						'empresa' => $this->mempresas->getCampo("titulo",$row->idEmpresa),
	                    'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$row->idFraccionamiento),
	                    'prototipo' => $this->mprototipos->getCampo2('nombre', $row->idPrototipo),
	                   	'totalpmo' => precio_format($totalpmo),
	                   	'totalpmat' => precio_format($totalpmat),
	                    'total' => precio_format($totalpmat+$totalpmo),
						'estatus' => "ACTIVO",
						'creacion' => $this->mpresupuestos->getCampo('created', $row->id),
						'modificacion' => $this->mpresupuestos->getCampo('updated', $row->id),
	                    'acciones' => accionesPptos($row->idPmo,$row->idPmat),
	                );
	            }
	        }else{
	            $array['aaData'] = [];
	        }
	        echo json_encode($array);
	    }

		public function nuevo()
	    {
			$data['msg'] = '';
			$data['msgFile'] = '';
			$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
			$data['empresas']= $this->mempresas->getAll();
			$data['prototipos']= 0;

			$this->load->library('form_validation');
			if(isset($_POST['idFraccionamiento'])){
				if ($this->form_validation->run($this->fv) == FALSE) {
					$data['msg'] = validation_errors();
				}else{
					$idFraccionamiento=$this->input->post('idFraccionamiento', TRUE);
					$idPrototipo=$this->input->post('idPrototipo', TRUE);
					$idEmpresa=$this->input->post('idEmpresa', TRUE);
					$titulo=$this->input->post('titulo', TRUE);
					$this->insertPptos([
						"idFraccionamiento"=>$idFraccionamiento,
						"idPrototipo"=>$idPrototipo,
						"titulo"=>$titulo,
						"idEmpresa"=>$idEmpresa,
					]);
					redirect($this->router->class);
				}
			}
			$this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

		public function insertPptos($data,$return=false){
			$pptomo['idFraccionamiento'] =$data["idFraccionamiento"];
			$pptomo['idPrototipo'] =$data["idPrototipo"];
			$pptomo['titulo'] =$data["titulo"];
			$pptomo['tipo'] = 2;
			$pptomo['status'] = 1;
			$idPmo=$this->mmanoobra->insertar($pptomo);

			$pptomat['idFraccionamiento'] =$data["idFraccionamiento"];
			$pptomat['idPrototipo'] =$data["idPrototipo"];
			$pptomat['idEmpresa'] = $data["idEmpresa"];
			$pptomat['idPaquete'] =0;
			$pptomat['tipo'] = 2;
			$pptomat['status'] = 1;
			$idPmat=$this->mmaterial->insertar($pptomat);

			$ppto['titulo'] = $data["titulo"];
			$ppto['idFraccionamiento'] =$data["idFraccionamiento"];
			$ppto['idPrototipo'] =$data["idPrototipo"];
			$ppto['idEmpresa'] =$data["idEmpresa"];
			$ppto['idPmo']=$idPmo;
			$ppto['idPmat']=$idPmat;
			$ppto['status'] = 1;
			$idPpto = $this->mpresupuestos->insertar($ppto);
			$res=[
				"idPmo"=>$idPmo,
				"idPmat"=>$idPmat,
				"idPpto"=>$idPpto,
			];
			if($return) {
				return $res;
			}
		}

		public function getPrototiposByFracc($id = ''){
			$prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
			$array = array();
			$response = array();
			if (!is_numeric($prototipos)) {
				foreach ($prototipos->result() as $key => $value) {
					$array = array(
						'id' => $value->idPrototipo,
						'titulo' => $this->mprototipos->getCampo('nombre', $value->idPrototipo)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		public function getAll(){
			$presupuestos=0;
			if(
				isset($_POST["idFraccionamiento"]) &&
				isset($_POST["idPrototipo"]) &&
				isset($_POST["idEmpresa"])
			){
				$idFraccionamiento=$_POST["idFraccionamiento"];
				$idPrototipo=$_POST["idPrototipo"];
				$idEmpresa=$_POST["idEmpresa"];
				$presupuestos=$this->mpresupuestos->getByCond(['idFraccionamiento'=>$idFraccionamiento,'idPrototipo'=>$idPrototipo,'idEmpresa'=>$idEmpresa]);
				$presupuestos=(!is_numeric($presupuestos)) ? $presupuestos->result() : 0;
			}
			echo json_encode($presupuestos);
		}

		public function eliminar(){
			$id = $this->input->post('elid');
			$q = $this->mmaterial->getById($id);
			$cValor = "true";
			$valorBorrar = $this->mmaterial->borrar($id);
			$this->db->query("DELETE FROM presupuesto_mat WHERE idMaterial=$id");
			$data = json_encode(array("valor" => $cValor));
			echo $data;
		}
		
	}
?>