<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Postulaciones extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$allowed;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'postulaciones'; // form validation variable
            $this->mainView = 'postulaciones';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/postulaciones/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // postulaciones //,"mpolizas"
            $this->load->model(array('mpostulaciones',"mareas","mpuestos","musuario"));
            $this->data['fotos_www'] = $this->config->item('base_www').'/postulaciones/';

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           $this->allowed=permisos("ventas",$this->fv);
           //Validación de usuarios
           valSession("rh",$this->fv);
    }

	public function index(){
        $data['allowed'] = $this->allowed;
        $data['q'] = '';
		$data['puestos'] = $this->mpuestos->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mpostulaciones->getAll();
        $ciudad=[
            "",
            "Gómez Palacio",
            "San Pedro",
            "Lerdo",
            "Otro",
        ];
        $nivel=[
            "",
            "Licenciatura",
            "Ingeniería",
            "Carrera trunca",
            "Preparatoria",
        ];
        $anos=[
            "",
            "1 año a 2 años",
            "3 a 5 años",
            "Más",
        ];
        $sino=[
            "",
            "SI",
            "NO"
        ];
        $baseUrl="https://viviend.mx/sistema/uploads/postulaciones/";
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $pdf=$baseUrl.$row->id.".pdf";
                $array['aaData'][] = array(
                    'id' => $row->id,
                    'fecha' => $this->mpostulaciones->getCampo("created",$row->id),
                    'idArea' => $this->mareas->getCampo("titulo",$row->idArea),
                    'idPuesto' => $this->mpuestos->getCampo("titulo",$row->idPuesto),
                    'nombre' => $row->nombre,
                    'telefono' => $row->telefono,
                    'ciudad' => $ciudad[$row->ciudad],
                    'nivel' => $nivel[$row->nivel],
                    'anos' => $anos[$row->anos],
                    'salario' => $row->salario,
                    'licencia' => $sino[$row->licencia],
                    'pdf' => '<a href="'.$pdf.'" target="_blank" class="btn btn-default bg-2" style="border-radius: 20px!important;-moz-border-radius: 20px!important;-webkit-border-radius: 20px!important;color:#fff!important;float: right;margin-top: 5px;">
                                Ver CV
                            </a>',
                );
            }
        } else{
            $array['aaData']=[];

        }

        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';
        $data["areas"]=$this->mareas->getAll();
        $data["puestos"]=$this->mpuestos->getAll();
        //$data["polizas"]=$this->mpolizas->getAll();
        $this->load->library('SubirArchivo');
        $this->load->library('form_validation');

        if ($this->form_validation->run($this->fv) == FALSE) {

            $data['msg'] = validation_errors();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        }else{
              //(_*-*)_ subir foto
            $rutaSubida = $this->data['fotos_www'];
            //siguiente id a insertar ^^
            $nextId = $this->mpersonal->nextId();
            //arreglo con los nombres de foros y thumbnail creados >_<
            $fotos = $this->subirarchivo->subirfoto($_FILES,$nextId,$rutaSubida);
            //comprobamos si subio alguna foto

               //ya se a comprobado que es una array anteriormente pero por si acaso o por si acaso
                    if(is_array($fotos)){
                        //se comprueba si existe name de input file y se obtienen los nombres de las fotos subidas
                        if(array_key_exists('foto',$fotos)){
                            $pData['foto'] = $fotos['foto']['foto'];
                            $pData['thumbnail'] = $fotos['foto']['thumbnail'];
                        }
                    }

            $pData['idArea'] = $this->input->post('idArea', TRUE);
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['apellido'] = $this->input->post('apellido', TRUE);
            $pData['direccion'] = $this->input->post('direccion', TRUE);
            $pData['emergencia'] = $this->input->post('emergencia', TRUE);
            $pData['pertenece_a'] = $this->input->post('pertenece_a', TRUE);
            $pData['celular'] = $this->input->post('celular', TRUE);
            $pData['email'] = $this->input->post('email', TRUE);
            $pData['idPuesto'] = $this->input->post('idPuesto', TRUE);
            // echo  $pData['idPuesto'];
            // exit();
            $pData['precio'] = $this->input->post('precio', TRUE);
            $pData['status'] = 1;
            $id = $this->mpersonal->insertar($pData);
            redirect($this->router->class);
        }
    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';

        /* VALIDAR FORMULARIO*/
        $this->load->library('SubirArchivo');
        $this->load->library('form_validation');

        if (isset($_POST['nombre'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
            //(_*-*)_ subir foto
            $rutaSubida = $this->data['fotos_www']."/";
            //id del registro actual ^^
            $nextId = $id;
            //arreglo con los nombres de foros y thumbnail creados >_<
            $fotos = $this->subirarchivo->subirfoto($_FILES,$nextId,$rutaSubida);
            //comprobamos si subio alguna foto

                if(isset($_POST['foto']) && !is_array($fotos)){
                   $error = $fotos;
                }else {
                    //ya se a comprobado que es una array anteriormente pero por si acaso o por si acaso
                    if(is_array($fotos)){
                        //se comprueba si existe con el name de input file
                        if(array_key_exists('foto',$fotos)){
                            $pData['foto'] = $fotos['foto']['foto'];
                            $pData['thumbnail'] = $fotos['foto']['thumbnail'];
                        }
                    }
                }

            $pData['idArea'] = $this->input->post('idArea', TRUE);
            $pData['nombre'] = $this->input->post('nombre', TRUE);
            $pData['apellido'] = $this->input->post('apellido', TRUE);
            $pData['direccion'] = $this->input->post('direccion', TRUE);
            $pData['emergencia'] = $this->input->post('emergencia', TRUE);
            $pData['pertenece_a'] = $this->input->post('pertenece_a', TRUE);
            $pData['celular'] = $this->input->post('celular', TRUE);
            $pData['email'] = $this->input->post('email', TRUE);
            $pData['idPuesto'] = $this->input->post('idPuesto', TRUE);
            $pData['precio'] = $this->input->post('precio', TRUE);
            $pData['status'] = 1;

            $this->mpersonal->actualizar($pData, $id);
            redirect($this->router->class);
            }
        }
        // Obteniendo la información
        $info = $this->mpersonal->getById($id);

        $data = $info;
        $data['msg']=$msg;
        //$data["polizas"]=$this->mpolizas->getAll();
        $data["areas"]=$this->mareas->getAll();
        $data["puestos"]=$this->mpuestos->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mpersonal->getById($id);
        $cValor = "true";
        $this->mpersonal->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

}


