<?php
	defined('BASEPATH') OR exit('No direct script access allowed');

	class Pmo extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'pmo'; // form validation variable
			$this->mainView = 'pmo';
			$this->data['fjs'] = '';
			$this->data['js'] = ' <script src="assets/js/pmo/listado.js?v=0.2" type="text/javascript"></script>
								  <script src="assets/js/pmo/listadoDetalle.js" type="text/javascript"></script>
								  <script src="assets/js/pmo/listadoResumen.js" type="text/javascript"></script>
								  <script src="assets/js/pmo/bootstrap-fileinput.js" type="text/javascript"></script> ';
			$this->data['css'] = '<link href="assets/css/bootstrap-fileinput.css" rel="stylesheet" type="text/css" />';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mfraccionamiento', 'mprototipoxfraccionamiento', 'mprototipos', 'mpaquete', 'mdetallepaquete', 
			'mactividadesprototipo', 'mactividadmo', 'mconstructores', 'mmanoobra', 'mpresupuestomo', 'mcategoriamo', 'munidades', 'musuario',
			 'mestimacion','mestimaciones', 'mestimados', 'mavanceobra', 'mmaterialesactividadprototipo', 'mmaterialesactividadprototipo', 'marranque',
			  'mdetalleop', 'mestimacionprograma','mempresas','mpresupuestos','mpmo'));

			$this->load->library('csvimport');
			$this->load->library('excel');
			$this->data['fotos_www'] = $this->config->item('base_www').'/pmo/';

			$this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);

			//Validación de usuarios
			valSession("obra",$this->fv);
		}

		public function index(){
			$data['q'] = '';
			$data['msg'] = '';
	        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
	        $this->load->view('templates/main_template',$this->data);
		}

		public function listado(){
	        $q = $this->mpmo->get_datatables();
	        if (!is_numeric($q)){
				foreach ($q->result() as $row) {
					$validar=true;
					$borrar=true;
					$qArranque = $this->db->query("SELECT id FROM paquetes p WHERE idManoObra=$row->id AND (SELECT estatus_arranque FROM arranque WHERE status = 1 AND FIND_IN_SET(p.id,idPaquetes) LIMIT 1) > 1");
					$qArranqueBorrar = $this->db->query("SELECT id FROM paquetes p WHERE idManoObra=$row->id");
					if($qArranque->num_rows() > 0){
						$validar = false;
					}
					if($qArranqueBorrar->num_rows() > 0){
						$borrar = false;
					}
					//validar temporal
					//$validar=true;
					//fin de validacion
					$inputFile =  'No disponible';
					$inputFile = '<form id="' . $row->id . '" role="form" enctype="multipart/form-data" action="' . $this->router->class . '/editar/' . $row->id . '" method="post">
											<!--<label><input type="checkbox" name="checkEliminar"> Actualizar Y Eliminar</label><br>-->
											<div class="form-group">
												<div class="col-md-2">
													<div class="fileinput fileinput-new" data-provides="fileinput">
														<div class="input-group">
															<div class="form-control uneditable-input input-fixed" data-trigger="fileinput">
																<i class="fa fa-file fileinput-exists"></i>&nbsp;
																<span class="fileinput-filename"> </span>
															</div>
															<span class="input-group-addon btn default btn-file">
																<span class="fileinput-new"> Seleccionar </span>
																<span class="fileinput-exists"> Cambiar </span>
																<input type="file" name="archivoObra" accept=".csv"> </span>
															<a href="javascript:;" class="input-group-addon btn red fileinput-exists" data-dismiss="fileinput" onClick="editar(' . $row->id . ');"> Actualizar </a>
														</div>
													</div>
												</div>
											</div>
										</form>';

					if($qArranque->num_rows() > 0){
						$inputFile = "<p>Paquete : En Curso o Finalizada :  No Puedes Actualizar.</p>";
					}
					
					$prototipo = $this->mprototipos->getCampo2('nombre', $row->idPrototipo);
					/*$paquete = $this->mpaquete->getCampo2('titulo', $row->idPaquete);
					$lotes = $this->mpaquete->getCampo2('rango_lotes', $row->idPaquete);
					$contarLotes = contarLotes($lotes);*/
					$totalUnitario = $this->mpresupuestomo->getSumTotalUnitario($row->id);
					//$totalPresupuesto = $contarLotes * $totalUnitario;
					$array[] = array(
						'titulo' => $row->titulo,
						'prototipo' => $prototipo,
						'totalUnitario' => precio_format($totalUnitario),
						'inputFile'=>$inputFile,
						'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","pmo")['w']))? accionesPresupuestoMO($row->id, $this->router->class, false, false, $borrar, $validar, true, false, true, false) : ''
					);
				}
			}else{
				$array=[];
	        }
			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->mpmo->count_all(),
				"recordsFiltered" => $this->mpmo->count_filtered(),
				"data" => $array,
			);
			//output to json format
			echo json_encode($output);
	    }

	    public function nuevo()
	    {
			$data['msg'] = '';
			$data['msgFile'] = '';
			$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
			$data['empresas']= $this->mempresas->getAll();
			$data['prototipos'] = 0;
			$data['titulo'] = '';


			$this->load->library('form_validation');
			if(isset($_POST['idFraccionamiento'])){
				if ($this->form_validation->run($this->fv) == FALSE) {
					$data['msg'] = validation_errors();
				}else {
					$mData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
					$mData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
					$mData['idPresupuesto'] = $this->input->post('idPresupuesto', TRUE);
					$mData['titulo'] = $this->input->post('titulo', TRUE);
					$mData['status'] = 1;
					
					if($_POST["statusArchivo"]==0){
						$this->pptoByPrototipo($mData);
					}else if($_POST["statusArchivo"]==1 ){
						// Importar CSV Mano de Obra
						if (isset($_FILES['archivoObra']) && $_SERVER['REQUEST_METHOD'] == 'POST'){
							$config['upload_path'] = $this->data['fotos_www'];
							$config['allowed_types'] = 'csv';
							$config['max_size'] = '2000';

							$this->load->library('upload', $config);
							if (!$this->upload->do_upload("archivoObra")) {
								$msg = $this->upload->display_errors();
							}else{
								$file_data = $this->upload->data();
								$file_path = $this->data['fotos_www'] . $file_data['file_name'];

								if ($this->csvimport->get_array($file_path, '', TRUE)) {
									$csv_array = $this->csvimport->get_array($file_path);
									$this->db->trans_begin();

									if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO'])) {
										$arrayPrototipo = array();
										foreach ($csv_array as $row) {
											$actividad=$this->mactividadmo->getByClave($row["CLAVE"]);
											$actividadPrototipo=$this->mactividadesprototipo->getActividadByIdPrototipo($mData['idPrototipo'],$actividad->id);
											$cantidad=0;
											if(isset($row["CANTIDAD"])){
												if(is_numeric($row["CANTIDAD"])){
													$cantidad=$row["CANTIDAD"];
												}
											}else if(!is_numeric($actividadPrototipo)){
												$cantidad=$actividadPrototipo->cantidad;
											}
											if(!is_numeric($actividad)){
												$datActProt['idPrototipo'] = $mData['idPrototipo'];
												$datActProt['idCategoria'] = $actividad->idCategoria;
												$datActProt['idActividad'] = $actividad->id;
												$datActProt['cantidad'] = $cantidad;
												$datActProt['tipo'] = 2;
												$idActProt = $this->mactividadesprototipo->insertar($datActProt);
											}
											$arrayActividad = array();
											if(!is_numeric($actividad)){
												$arrayActividad = array('idActividadPrototipo' => $idActProt, 'cantidad' => $cantidad, 
												'precioUnitario' => $row["PRECIO UNITARIO"]);
												if (!array_key_exists($actividad->clave, $arrayPrototipo)) {
													$arrayPrototipo[$actividad->clave] = $arrayActividad;
												}
											}
										}
										//Insercion de presupueso mo
										if(isset($arrayPrototipo) && count($arrayPrototipo) > 0){
											$idManoObra = $this->mmanoobra->insertar($mData);
											foreach($arrayPrototipo as $row){
												$pData['idManoObra'] = $idManoObra;
												$pData['idActividadPrototipo'] = $row['idActividadPrototipo'];
												$pData['precioUnitario'] = round ($row['precioUnitario'], 2);
												$pData['importe'] = round($row['cantidad'] * $row['precioUnitario'], 2);
												$pData['status'] = 1;
												$idPresupuesto = $this->mpresupuestomo->insertar($pData);
											}
						
											//Todo correctamente
											$updatePctjeActividad = $this->updatePorcentajeActividad($idManoObra);
											if ($this->db->trans_status() === FALSE){
												$this->db->trans_rollback();
											}else{
												$this->db->trans_commit();
											}
											redirect($this->router->class . '/detallepmo/' . $idManoObra);
										}
									}else{
										// El archivo no tiene columnas especificada
										//$msg = "El archivo no contiene ninguna columna especificada";
									}
									@unlink($file_path);
								}
							}
						}
					}
					redirect($this->router->class);
				}
			}

			$this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
			$this->load->view('templates/main_template', $this->data);

	    }

		public function eliminar(){
			$id = $this->input->post('elid');
			$q = $this->mmanoobra->getById($id);
			$cValor = "true";
			$valorBorrar = $this->mmanoobra->borrar($id);
			$this->db->query("DELETE FROM presupuesto_mo WHERE idManoObra=$id");
			$data = json_encode(array("valor" => $cValor));
			echo $data;
		}
		
		public function pptoByPrototipo($mData){
			$idManoObra=0;
			if($mData["idPresupuesto"]){
				$ppto=$this->mpresupuestos->getById($mData["idPresupuesto"]);
				$pmo=$this->mpresupuestomo->getByIdManoObra($ppto["idPmo"]);
				if(!is_numeric($pmo)){
					$idManoObra = $this->mmanoobra->insertar($mData);
					foreach($pmo->result_array() as $rowPmo){
						$act=$this->mactividadesprototipo->getById($rowPmo["idActividadPrototipo"]);
						unset($act["id"]);
						unset($act["txtstatus"]);
						unset($act["msg"]);
						unset($rowPmo["id"]);
						unset($rowPmo["txtstatus"]);
						//inserciones
						$rowPmo["idActividadPrototipo"]=$this->mactividadesprototipo->insertar($act);
						$rowPmo["idManoObra"]=$idManoObra;
						$this->mpresupuestomo->insertar($rowPmo);
					}
				}
			}	
			return $idManoObra;
		}

	    public function editar($id = null)
	    {
			$idManoObra = $id;
			$titulo = $this->mmanoobra->getCampo2('titulo', $idManoObra);
			$idPrototipo = $this->mmanoobra->getCampo2('idPrototipo', $idManoObra);
			$actualizados = 0;
			$registrados = 0;
			$noRegistrados = 0;
			$eliminados = 0;
			$noEliminados = 0;
			if(isset($_FILES['archivoObra']) && !empty($_FILES['archivoObra']['name'])){
				$checkEliminar = $this->input->post('checkEliminar', TRUE);
				$actividadesPrototipo = $this->mactividadesprototipo->getActividadesNews($idManoObra);

				$arrayPresupuestoMO = array();
				$seguir = false;
				if (!is_numeric($actividadesPrototipo)) {
					foreach ($actividadesPrototipo->result() as $row) {
						$actividad = $this->mactividadmo->getById($row->idActividad);
						$arrayActividad = array();
						if (!is_numeric($actividad)) {
							$seguir = true;

							$arrayActividad = array('id'=>$row->id,'idActividadPrototipo' => $row->idActividadPrototipo, 'cantidad' => $row->cantidad, 
							'precioUnitario' => $row->precioUnitario,);
							if (!array_key_exists($actividad['clave'], $arrayPresupuestoMO)) {
								$arrayPresupuestoMO[$actividad['clave']] = $arrayActividad;
							}
						}
					}
				}
				//Validaciones de insercion, actualizacion y eliminacion
				if($seguir){
					if (isset($_FILES['archivoObra']) && $_SERVER['REQUEST_METHOD'] == 'POST') {
						$config['upload_path'] = $this->data['fotos_www'];
						$config['allowed_types'] = 'csv';
						$config['max_size'] = '2000';

						$this->load->library('upload', $config);
						if (!$this->upload->do_upload("archivoObra")) {
							$msg = $this->upload->display_errors();
						} else {
							$file_data = $this->upload->data();
							$file_path = $this->data['fotos_www'] . $file_data['file_name'];

							if ($this->csvimport->get_array($file_path, '', TRUE)) {
								$csv_array = $this->csvimport->get_array($file_path);

								$registros = array();

								if (isset($csv_array[0]['CLAVE']) && isset($csv_array[0]['PRECIO UNITARIO'])) {
									foreach ($csv_array as $row) {
										if(array_key_exists($row["CLAVE"],$arrayPresupuestoMO)){
											$presupuesto= $arrayPresupuestoMO[$row["CLAVE"]];
											if ((floatval($row["PRECIO UNITARIO"]) != floatval($presupuesto["precioUnitario"])) || (floatval($row["CANTIDAD"]) != floatval($presupuesto["cantidad"]))) {
												$datActProt['cantidad'] = $row["CANTIDAD"];
												$idActProt = $this->mactividadesprototipo->actualizar($datActProt,$presupuesto["idActividadPrototipo"]);
												$pData['precioUnitario'] = round ($row['PRECIO UNITARIO'], 2);
												$pData['importe'] = round($row['CANTIDAD'] * $row['PRECIO UNITARIO'], 2);
												$this->mpresupuestomo->actualizar($pData,$presupuesto["id"]);
												$actualizados++;
											}
										}else{
											$actividad=$this->mactividadmo->getByClave($row["CLAVE"]);
											$cantidad=0;
											if(!is_numeric($actividad)){
												$actividadPrototipo=$this->mactividadesprototipo->getActividadByIdPrototipo($idPrototipo,$actividad->id);
												if(isset($row["CANTIDAD"])){
													if(is_numeric($row["CANTIDAD"])){
														$cantidad=$row["CANTIDAD"];
													}
												}else if(!is_numeric($actividadPrototipo)){
													$cantidad=$actividadPrototipo->cantidad;
												}
												$clave=$row["CLAVE"];
												$clavePpto=$this->db->query("SELECT id FROM presupuesto_mo WHERE idManoObra=$id AND (SELECT clave FROM actividades_mo WHERE 
												id=(SELECT idActividad FROM actividadesprototipo WHERE id=idActividadPrototipo)) LIKE '%$clave%'");
												if($clavePpto->num_rows() == 0){
													$datActProt['idPrototipo'] = $idPrototipo;
													$datActProt['idCategoria'] = $actividad->idCategoria;
													$datActProt['idActividad'] = $actividad->id;
													$datActProt['cantidad'] = $cantidad;
													$datActProt['tipo'] = 2;
													$idActividadProt = $this->mactividadesprototipo->insertar($datActProt);
													//Insercion de presupueso mo
													$pData['idManoObra'] = $idManoObra;
													$pData['idActividadPrototipo'] = $idActividadProt;
													$pData['precioUnitario'] = round($row['PRECIO UNITARIO'], 2);
													$pData['importe'] = round($cantidad * $row['PRECIO UNITARIO'], 2);
													$pData['status'] = 1;
													$idPresupuesto = $this->mpresupuestomo->insertar($pData);
													$registrados++;
												}else{
													$noRegistrados++;
												}
											}else{
												$noRegistrados++;
											}
											//Todo correctamente
											$updatePctjeActividad = $this->updatePorcentajeActividad($idManoObra);
										}
										unset($arrayPresupuestoMO[$row['CLAVE']]);
									}
									/*echo "<pre>";
									print_r($arrayPresupuestoMO);
									exit();
									Eliminaciones
									foreach ($arrayPresupuestoMO as $row){
										$this->mactividadesprototipo->borrar($row["idActividadPrototipo"]);
										$this->mpresupuestomo->borrar($row["id"]);
										$eliminados++;
									}*/
									//Todo correctamente
									$updatePctjeActividad = $this->updatePorcentajeActividad($idManoObra);
								} else {
									// El archivo no tiene columnas especificada
									//$msg = "El archivo no contiene ninguna columna especificada";
								}
								
								@unlink($file_path);
							}
						}
					}
				}else{
					//No se pudo importar el archivo
				}
			}

			$data['msg'] = "<div style='text-align: center'>
								<p> Registros Actualizados : ".$actualizados."</p>
								<p> Registros Insertados : ".$registrados."</p>
								<p> Registros Eliminados : ".$eliminados."</p>
								<p> Registros No Insertados : ".$noRegistrados."</p>
							</div>";

			$this->data['contenido'] = $this->load->view($this->mainView . '/index_view', $data, true);
			$this->load->view('templates/main_template', $this->data);
	    }

	    public function detallepmo($id=0){
			$qPaquete = $this->mpaquete->getByIdManoObra($id);
			$idPaquete=0;
			if(isset($qPaquete['id'])){
				$idPaquete = ($qPaquete['id'] != '') ? $qPaquete['id'] : 0;
			}
			$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$idPaquete',idPaquetes)");
			if($qArranque->num_rows() > 0){
				if($qArranque->row()->estatus_arranque == 2 || $qArranque->row()->estatus_arranque == 3){
					redirect($this->router->class);
				}
			}
			$data["msg"]="";
			$data['manoObra'] = $this->mmanoobra->getById($id);
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['manoObra']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['manoObra']['idPrototipo']);
			$data['impTotal'] = $this->mpresupuestomo->getSumTotalUnitario($id);
			$data['categorias'] = $this->mcategoriamo->getSelectResult();
    		$this->data['contenido'] = $this->load->view($this->mainView.'/detalle_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }

		public function listadoDetallepmo($idManoObra=0){
			$idPrototipo = $this->mmanoobra->getCampo2('idPrototipo', $idManoObra);
			$actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($idManoObra);
			$validar = false;
			$qPaquete = $this->mpaquete->getAllByIdManoObra($idManoObra);
			if( !is_numeric($qPaquete) ){
				foreach( $qPaquete->result() as $pack){
					$qArranque = $this->marranque->getByIdPaquete($pack->id);
					if( !is_numeric($qArranque) ) {
						if($qArranque['estatus_arranque'] == 2 || $qArranque['estatus_arranque'] == 3){
							$validar = true;
						}
					}
				}
			}
			$empty = true;
			if(!is_numeric($actividadesPresupuesto)){
				$arrayPresupuestoMO = array();
				$arrayCategoria = array();
				$countArray = 0;
				foreach ($actividadesPresupuesto->result() as $row) {
					$existe = 0;
					$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
					if (!is_numeric($actividadPrototipo)) {
						$actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
						if (!is_numeric($actividad)) {
							$empty = false;
							$categoria = $this->mcategoriamo->getById($actividadPrototipo['idCategoria']);
							if(!is_numeric($categoria)){
								if(count($arrayPresupuestoMO) > 0){
									$countArray = count($arrayPresupuestoMO)-1;
									for($j = 0; $j<=$countArray; $j++){
										if($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']){
											$existe++;
											$precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
											$importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
											$arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
											$arrayPresupuestoMO[$j]['importe'] = $importe;
										}
									}
									if($existe == 0){
										array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
									}
								}else{
									array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
								}
							}

							$unidad = $this->munidades->getById($actividad['idUnidad']);
							if(!is_numeric($unidad)){
								array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => $actividadPrototipo['semana']));
							}
						}
					}
				}
			}

			if(!$empty){
				if(count($arrayPresupuestoMO) > 0){
					foreach($arrayPresupuestoMO as $row){
						//validacion temporal
							/*$idPresupuesto= $row['idPresupuesto'];
							$op=$this->db->query("SELECT dop.id FROM detalle_op dop INNER JOIN orden_pago op ON op.id=dop.idOrdenPago WHERE
							dop.idPresupuesto=$idPresupuesto AND (op.statusPago=1 OR op.statusPago=2 OR op.statusPago=3)");
							if($op->num_rows()==0){
								$validar=false;
							}else{
								$validar=true;
							}*/
						//fin de validacion temporal
						$borrar = '';
						$inputSemana = '';
						if($row['tipo'] != 'C'){
							$cantidad = '<span id="cantidadPresupuesto_' . $row['idPresupuesto'] . '">' . $row['cantidad'] . '</span>';
							if(!$validar){
								$input = '<div class="input-group">
												<input id="' . $row['idPresupuesto'] . '" type="text" class="form-control" value="' . $row['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
												<span class="input-group-addon">
													<a title="Editar" id="editar_'. $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" data-categoria="' . $row['categoria'] . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
												</span>
												<span class="input-group-addon">
													<a title="Guardar" id="aceptar_'. $row['idPresupuesto'] . '" data-id="' . $row['idPresupuesto'] . '" data-categoria="' . $row['categoria'] . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
												</span>
										</div>';
								$inputSemana = '<input id="semana_' . $row['idPresupuesto'] . '" type="text" class="form-control" value="' . $row['semana'] . '" data-id="'.$row['idPresupuesto'].'" style="width: 50px;" onkeyup="updateSemana($(this));">';
                        		$borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$row['idPresupuesto'].'" data-id="'.$row['idPresupuesto'].'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';
							}else{
								$input = '<span>'. number_format($row['precioUnitario'],2) .'</span>';
								$inputSemana = '<span>'. $row['semana'] .'</span>';
							}
							$importe = '<span id="importePresupuesto_' . $row['idPresupuesto'] . '">' . number_format($row['importe'],2) . '</span>';
						}else{
							$cantidad = $row['cantidad'];
							$input = '<span id="precioUnitarioCategoria_'.$row['categoria'].'">'. number_format($row['precioUnitario'],2) .'</span>';
							$importe = '<span id="importeCategoria_'.$row['categoria'].'" class="importeCategoria" title="'.$row['importe'].'">'. number_format($row['importe'],2) .'</span>';
						}
						$array['aaData'][] = array(
							'tipo' => $row['tipo'],
							'clave' => $row['clave'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $cantidad,
							'precioUnitario' => $input,
							'importe' => $importe,
							'semana' => $inputSemana,
							'acciones' => $borrar
						);
					}
				}else{
					$array['aaData'][] = array(
						'tipo' => 'No hay registros',
						'clave' => 'No hay registros',
						'descripcion' => 'No hay registros',
						'unidad' => 'No hay registros',
						'cantidad' => 'No hay registros',
						'precioUnitario' => 'No hay registros',
						'importe' => 'No hay registros',
						'semana' => 'No hay registros',
						'acciones' => 'No hay registros'
					);
				}
			}else{
				$array['aaData'][] = array(
					'tipo' => 'No hay registros',
					'clave' => 'No hay registros',
					'descripcion' => 'No hay registros',
					'unidad' => 'No hay registros',
					'cantidad' => 'No hay registros',
					'precioUnitario' => 'No hay registros',
					'importe' => 'No hay registros',
					'semana' => 'No hay registros',
					'acciones' => 'No hay registros'
				);
			}
	        echo json_encode($array);
		}
		
		public function resumenpmo($id=0){
	    	$data["msg"]="";
			$data['manoObra'] = $this->mmanoobra->getById($id);
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['manoObra']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['manoObra']['idPrototipo']);
			//$data['paquete'] = $this->mpaquete->getCampo2('titulo', $data['manoObra']['idPaquete']);
    		$this->data['contenido'] = $this->load->view($this->mainView.'/resumen_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }

		public function listadoResumenpmo($idManoObra=0){
	        //$idPaquete = $this->mmanoobra->getCampo2('idPaquete', $idManoObra);
			$idPrototipo = $this->mmanoobra->getCampo2('idPrototipo', $idManoObra);
			$actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($idManoObra);
			$empty = true;
			if(!is_numeric($actividadesPresupuesto)){
				$arrayPresupuestoMO = array();
				$arrayCategoria = array();
				$countArray = 0;
				foreach ($actividadesPresupuesto->result() as $row) {
					$existe = 0;
					$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
					if (!is_numeric($actividadPrototipo)) {
						$actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
						if (!is_numeric($actividad)) {
							$empty = false;
							$categoria = $this->mcategoriamo->getById($actividadPrototipo['idCategoria']);
							if(!is_numeric($categoria)){
								if(count($arrayPresupuestoMO) > 0){
									$countArray = count($arrayPresupuestoMO)-1;
									for($j = 0; $j<=$countArray; $j++){
										if($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']){
											$existe++;
											$precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
											$importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
											$arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
											$arrayPresupuestoMO[$j]['importe'] = $importe;
										}
									}
									if($existe == 0){
										array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => ''));
									}
								}else{
									array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => ''));
								}
							}

							$unidad = $this->munidades->getById($actividad['idUnidad']);
							if(!is_numeric($unidad)){
								array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => $actividadPrototipo['semana']));
							}
						}
					}
				}
			}

			if(!$empty){
				if(count($arrayPresupuestoMO) > 0){
					foreach($arrayPresupuestoMO as $row){
						$array['aaData'][] = array(
							'tipo' => $row['tipo'],
							'clave' => $row['clave'],
							'descripcion' => $row['descripcion'],
							'unidad' => $row['unidad'],
							'cantidad' => $row['cantidad'],
							'precioUnitario' => precio_format($row['precioUnitario']),
							'importe' => ($row['tipo'] == "C") ?
							"<span class='importeCategoria' title='".$row['importe']."'>".precio_format($row['importe'])."</span>" : precio_format($row['importe']),
							'semana' => $row['semana']
						);
					}
				}else{
					$array['aaData'][] = array(
						'tipo' => 'No hay registros',
						'clave' => 'No hay registros',
						'descripcion' => 'No hay registros',
						'unidad' => 'No hay registros',
						'cantidad' => 'No hay registros',
						'precioUnitario' => 'No hay registros',
						'importe' => 'No hay registros',
						'semana' => 'No hay registros'
					);
				}
			}else{
				$array['aaData'][] = array(
					'tipo' => 'No hay registros',
					'clave' => 'No hay registros',
					'descripcion' => 'No hay registros',
					'unidad' => 'No hay registros',
					'cantidad' => 'No hay registros',
					'precioUnitario' => 'No hay registros',
					'importe' => 'No hay registros',
					'semana' => 'No hay registros'
				);
			}
	        echo json_encode($array);
		}

		public function getPrototiposByFracc($id = '')
		{
			$prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
			$array = array();
			$response = array();
			if (!is_numeric($prototipos)) {
				foreach ($prototipos->result() as $key => $value) {
					$array = array(
						'id' => $value->idPrototipo,
						'titulo' => $this->mprototipos->getCampo('nombre', $value->idPrototipo)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}

		/*public function getPaquetesByFraccProto($idFraccionamiento = '', $idPrototipo = '')
		{
			$paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, true, 'mano_obra');
			$array = array();
			$response = array();
			if (!is_numeric($paquetes)) {
				foreach ($paquetes->result() as $key => $value) {
					$array = array(
						'id' => $value->id,
						'titulo' => $this->mpaquete->getCampo('titulo', $value->id)
					);
					array_push($response, $array);
				}
			} else {
				$response = 0;
			}
			echo json_encode($response);
		}*/

		public function updatePrecio(){
			$idPresupuesto = $this->input->post('idPresupuesto');
			$idManoObra = $this->input->post('idManoObra');
			$idCategoria = $this->input->post('idCategoria');
			$cantidad = $this->input->post('cantidad');
			$precioUnitario = $this->input->post('precioUnitario');
			
			$pData['precioUnitario'] = round($precioUnitario, 2);
			$pData['importe'] = round($cantidad * $pData['precioUnitario'], 2);
			$this->mpresupuestomo->actualizar($pData, $idPresupuesto);
			$updatePctjeActividad = $this->updatePorcentajeActividad($idManoObra);

			$actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($idManoObra);
			$totalPrecioUnitario = 0;
			$totalImporte = 0;
			if (!is_numeric($actividadesPresupuesto)) {
				foreach($actividadesPresupuesto->result() as $row){
					$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
					if(!is_numeric($actividadPrototipo)){
						if($actividadPrototipo['idCategoria'] == $idCategoria){
							$totalPrecioUnitario = $totalPrecioUnitario + $row->precioUnitario;
							$totalImporte = $totalImporte + $row->importe;
						}
					}
				}
			}

			$array = array('importe' => precio_format($pData['importe']), 'totalUnitario' => precio_format($totalPrecioUnitario), 'totalImporte' => precio_format($totalImporte), '_importe' => $totalImporte);
			echo json_encode($array);
		}

		public function updatePorcentajeActividad($idManoObra){
			$query = $this->db->query('UPDATE presupuesto_mo AS p, (SELECT p.id, TRUNCATE(p.importe * 100 / (SELECT SUM(importe) FROM presupuesto_mo WHERE p.idManoObra = '. $idManoObra .'), 2) AS porcentaje FROM presupuesto_mo AS p WHERE p.idManoObra = ' . $idManoObra . ') AS c
									   SET p.pctjeActividad = c.porcentaje
									   WHERE p.idManoObra = '. $idManoObra .' AND p.id = c.id;
									');
			return $query;
		}

		public function exportarEjemplo(){
			$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
			$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Obra');
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE');
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'DESCRIPCION');
			$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'PRECIO UNITARIO');
			$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'CANTIDAD');

			$name = 'Ejemplo de Importación de Presupuesto de Obra';
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
			header('Cache-Control: max-age=0'); //no cache
			$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
			// Forzamos a la descarga
			$objWriter->save('php://output');
		}

		public function exportarExample($idManoObra){
			$manoObra = $this->mmanoobra->getById($idManoObra);
			$exportar = false;
			if(!is_numeric($manoObra)){
				$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
				$objPHPExcel->getActiveSheet()->setTitle('Presupuesto de Mano de Obra');
				$objPHPExcel->setActiveSheetIndex(0);
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'CLAVE ACTIVIDAD');
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'DESCRIPCION');
				$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'PRECIO UNITARIO');

				$presupuesto = $this->mpresupuestomo->getByIdManoObra($manoObra['id']);
				if(!is_numeric($presupuesto)){
					$exportar = true;
					$rowCount = 2;
					foreach($presupuesto->result() as $row){
						$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
						if(!is_numeric($actividadPrototipo)){
							$actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
							if(!is_numeric($actividad)){
								$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $actividad['clave']);
								$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $actividad['descripcion']);
								$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row->precioUnitario);
							}
						}
						$rowCount++;
					}
				}
			}

			if($exportar){
				$name = 'Presupuesto de Mano de Obra';
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
				header('Cache-Control: max-age=0'); //no cache
				$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
				// Forzamos a la descarga
				$objWriter->save('php://output');
			}
		}

		public function exportarPpto($idManoObra){
			$manoObra = $this->mmanoobra->getById($idManoObra);
			$fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
			$prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
			$paquete = $this->mpaquete->getByIdManoObra($idManoObra);
			$paqueteLotes = 0;
			$manzana = '';
            $lotes = '';
            $presupuestoUnit = 0;
			if(!is_numeric($paquete)){
				$manzana = $paquete['manzana'];
				$lotes = $paquete['rango_lotes'];
				$paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
				$paqueteLotes = $paqueteLotes['total'];
				/*$detallePaquete = $this->mdetallepaquete->getByIdPaquete($paquete['id']);
				if(!is_numeric($detallePaquete)){
					$paqueteLotes = $detallePaquete->num_rows();
				}*/
			}
			/*
			$constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
			$constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
			$constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
			$constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM; */
			$actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($idManoObra);
			$empty = true;
			$arrayPresupuestoMO = array();
			$countArray = 0;
			if (!is_numeric($actividadesPresupuesto)) {
				foreach ($actividadesPresupuesto->result() as $row) {
					$existe = 0;
					$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
					if (!is_numeric($actividadPrototipo)) {
						$actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
						if (!is_numeric($actividad)) {
							$empty = false;
							$categoria = $this->mcategoriamo->getById($actividadPrototipo['idCategoria']);
							if (!is_numeric($categoria)) {
								if (count($arrayPresupuestoMO) > 0) {
									$countArray = count($arrayPresupuestoMO) - 1;
									for ($j = 0; $j <= $countArray; $j++) {
										if ($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']) {
											$existe++;
											$precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
											$importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
											$arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
											$arrayPresupuestoMO[$j]['importe'] = $importe;
										}
									}
									if ($existe == 0) {
										array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
									}
								} else {
									array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
								}
							}

							$unidad = $this->munidades->getById($actividad['idUnidad']);
							if (!is_numeric($unidad)) {
								array_push($arrayPresupuestoMO, array('categoria' => $actividadPrototipo['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
							}
						}
					}
				}
			}

			if (!$empty) {
				if (count($arrayPresupuestoMO) > 0) {
					$objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
					$objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO DE MANO DE OBRA');
					$objPHPExcel->setActiveSheetIndex(0);

					$objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

					$gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
					// Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
					$objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
					$objDrawing->setName('Logo Vviend');
					$objDrawing->setDescription('Logo Viviend');
					$objDrawing->setImageResource($gdImage);
					$objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
					$objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
					$objDrawing->setOffsetX(150);
					$objDrawing->setOffsetY(0);
					$objDrawing->setWidth(900);
					$objDrawing->setHeight(140);
					$objDrawing->setCoordinates('A1');
					$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

					$objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
					$objPHPExcel->getActiveSheet()->SetCellValue('B13', 'DESCRIPCION');
					$objPHPExcel->getActiveSheet()->SetCellValue('C13', 'UNIDAD');
					$objPHPExcel->getActiveSheet()->SetCellValue('D13', 'CANTIDAD');
					$objPHPExcel->getActiveSheet()->SetCellValue('E13', 'PRECIO UNITARIO');
					$objPHPExcel->getActiveSheet()->SetCellValue('F13', 'IMPORTE');
					//$objPHPExcel->getActiveSheet()->SetCellValue('G13', 'IMPORTE POR PAQUETE');

					$objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
						array('fill' => array(
							'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
							'color' => array('rgb' => 'FFE699')
						))
					);

					/* $objPHPExcel->getActiveSheet()->getStyle('D9:D11')->applyFromArray(
						array('fill' => array(
							'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
							'color' => array('rgb' => 'FFE699')
						))
					); */


					$objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

					$objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

					$objPHPExcel->getActiveSheet()->SetCellValue('A11', 'PRESUPUESTO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('B11', $manoObra['titulo']);
					$objPHPExcel->getActiveSheet()->getStyle('B11')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);

					$objPHPExcel->getActiveSheet()->SetCellValue('A12', 'PPTO. UNITARIO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('B12', precio_format($presupuestoUnit));

					/*
					$objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANA:');
					$objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzana);

					$objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
					$objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

					$objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
					$objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

					$objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('D12', '');*/

					//

					/*$objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
					$objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('G9', '');

					$objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
					$objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
					$objPHPExcel->getActiveSheet()->SetCellValue('G10', '');

					$objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
					$objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
					$objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

					$objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
					$objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
					$objPHPExcel->getActiveSheet()->SetCellValue('G12', '');*/

					$rowCount = 14;
					$rowCategoria=0;
					$importeCategoria = 0;
					$importePaqueteCategoria = 0;
					foreach ($arrayPresupuestoMO as $row) {
						if ($row['tipo'] == 'C') {
							$clave = $row['clave'];
							$descripcion = $row['descripcion'];
							$unidad = '';
							$cantidad = '';
							$precioUnitario = '';
							$importe = '';
							$importePaquete = '';
							$rowCategoria = $rowCount;
							$importeCategoria = 0;
							$importePaqueteCategoria = 0;

							$objPHPExcel->getActiveSheet()->getStyle('A' . $rowCategoria . ':B' . $rowCategoria)->applyFromArray(
								array('fill' => array(
									'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
									'color' => array('rgb' => 'D9D9D9')
								))
							);

							$objPHPExcel->getActiveSheet()->getStyle('C' . $rowCategoria . ':F' . $rowCategoria)->applyFromArray(
								array('fill' => array(
									'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
									'color' => array('rgb' => '595959')
								))
							);
						} else {
							$clave = $row['clave'];
							$descripcion = $row['descripcion'];
							$unidad = $row['unidad'];
							$cantidad = $row['cantidad'];
							$precioUnitario = precio_format($row['precioUnitario']);
							$importe = $row['importe'];
							$presupuestoUnit = $presupuestoUnit + $importe;
							$importePaquete = $row['importe'];

							$importeCategoria = $importeCategoria + $importe;
							$importePaqueteCategoria = $importePaqueteCategoria + $importePaquete;

							$objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount.':F'.$rowCount)->applyFromArray(
								array('fill' => array(
									'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
									'color' => array('rgb' => 'FFFFFF')
								))
							);

						}

						$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $clave);
						$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $descripcion);
						$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $unidad);
						$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $cantidad);
						$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $precioUnitario);
						$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, precio_format($importe));
						//$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, precio_format($importePaquete));

						$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCategoria, precio_format($importeCategoria));
						//$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCategoria, precio_format($importePaqueteCategoria));

						$rowCount++;
					}

					$objPHPExcel->getActiveSheet()->SetCellValue('B12', precio_format($presupuestoUnit));
					$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($presupuestoUnit));

					$styleArray = array(
						'borders' => array(
							'allBorders' => array(
								'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
							)
						)
					);

					$objPHPExcel->getActiveSheet()->getStyle(
						'A13:F'.$rowCount
					)->applyFromArray($styleArray);

					$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
					$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
					$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
					$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
					$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
					$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
					//$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);

					$name = $manoObra['id'].".".$manoObra['titulo'];
					header('Content-Type: application/vnd.ms-excel');
					header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
					header('Cache-Control: max-age=0'); //no cache
					$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
					// Forzamos a la descarga
					$objWriter->save('php://output');
				}
			}
		}

		public function borrarMOPresupuesto()
		{
			$response['status'] = 0;
			$idPresupuesto = $_POST['idPresupuesto'];
			$qPresupuesto = $this->mpresupuestomo->getById($idPresupuesto);
			$existInOrdenP = $this->mdetalleop->existeByIdPresupuesto($idPresupuesto);
			if( !$existInOrdenP ){
				$idCategoria = $this->mactividadesprototipo->getCampo('idCategoria', $qPresupuesto['idActividadPrototipo']);
				$this->mactividadesprototipo->borrar($qPresupuesto['idActividadPrototipo']);
				$this->mpresupuestomo->borrar($idPresupuesto);
				$response['status'] = 1;
				$response['idCategoria'] = $idCategoria;
				$response['impCat'] = $this->mpresupuestomo->getSumImportexCategoriaByIdMOCat($qPresupuesto['idManoObra'], $idCategoria);
				$response['preCat'] = $this->mpresupuestomo->getSumUnitarioxCategoriaByIdMOCat($qPresupuesto['idManoObra'], $idCategoria);
				$response['impTotal'] = $this->mpresupuestomo->getSumTotalUnitario($qPresupuesto['idManoObra']);
			}

			echo json_encode($response);
		}
		
		public function getActividadesByCategoriaPost()
		{
			$response['valor'] = 0;
			$idCat = $_POST['idCat'];
			$selec = explode('-', $_POST['select']);
			if(	count($selec) == 2 && is_numeric($idCat) ){
				$array = array();
				$data = array();
				$response['select'] = $selec[1];
				$actividades = $this->mactividadmo->getByIdCategoria($idCat);
				if (!is_numeric($actividades)) {
					foreach ($actividades->result() as $act) {
						$array = array(
							'id' => $act->id,
							'text' => $act->clave . ' | ' . $act->descripcion
						);
						array_push($data, $array);
					}
					$response['actividades'] = $data;
					$response['valor'] = 1;
				}
			}

			echo json_encode($response);
		}

		public function addActividad(){
			$response['status'] = 0;
			$response['error'] = '';
			$error = '';
			$response['count'] = 0;
			$response['rows'] = array();
			$continuar = true;
			$arrayActividad = $_POST['arrayActividad'];
			$count = count($arrayActividad);
			$qPaquete = $this->mpaquete->getAllByIdManoObra($_POST['idManoObra']);
			if( !is_numeric($qPaquete) ){
				foreach($qPaquete->result() as $paq){
					if($paq->statusPaquete == 2 || $paq->statusPaquete == 3){
						$continuar = false;
					}
					/*$qEstimacion = $this->mestimacionprograma->getByIdPaquete($paq->id);
					if( !is_numeric($qEstimacion) ) {
						$continuar = true;
					}*/
				}
			}
			//validacion temporal
			//$continuar=true;
			//finaliza validacion temporal
			if( $continuar ){
				$qMO = $this->mmanoobra->getById($_POST['idManoObra']);
				if( !is_numeric($qMO) ){
					foreach ($arrayActividad as $key => $value) {
						$existActProt = $this->mactividadesprototipo->getByIdCatActMO($value['idCategoria'], $value['idActividad'], $qMO['id']);

						if( $existActProt == 0 ){
							$apData['idPrototipo'] = $qMO['idPrototipo'];
							$apData['idCategoria'] = $value['idCategoria'];
							$apData['idActividad'] = $value['idActividad'];
							$apData['cantidad'] = $value['cantidad'];
							$apData['cantidad'] = ($value['cantidad'] != '')? $value['cantidad'] : 0;
							$apData['tipo'] = 2;
							$apData['status'] = 1;
							$idActProt = $this->mactividadesprototipo->insertar($apData);

							$pData['idManoObra'] = $qMO['id'];
							$pData['idActividadPrototipo'] = $idActProt;
							$pData['idManoObra'] = $qMO['id'];
							$pData['precioUnitario'] = ($value['precioUnitario'] != '')? $value['precioUnitario'] : 0;
							$pData['precioUnitario'] = round($pData['precioUnitario'], 2);
							$pData['importe'] = $pData['precioUnitario'] * $apData['cantidad'];
							$pData['pctjeActividad'] = 0;
							$pData['lotesCompletados'] = 0;
							$pData['status'] = 1;
							$idPresupuesto = $this->mpresupuestomo->insertar($pData);

							$response['count'] = $response['count'] + 1;
							
							$input = '<div class="input-group">
											<input id="' . $idPresupuesto . '" type="text" class="form-control" value="' . $pData['precioUnitario'] . '" disabled="disabled" style="width: 80px;">
											<span class="input-group-addon">
												<a title="Editar" id="editar_'. $idPresupuesto . '" data-id="' . $idPresupuesto . '" data-categoria="' . $apData['idCategoria'] . '" onclick="habilitarInput($(this));"><i class="fa fa-edit" /></i></a>
											</span>
											<span class="input-group-addon">
												<a title="Guardar" id="aceptar_'. $idPresupuesto . '" data-id="' . $idPresupuesto . '" data-categoria="' . $apData['idCategoria'] . '" onclick="updatePrecio($(this));"><i class="fa fa-check" /></i></a>
											</span>
										</div>';
                        	$borrar = '<a href="javascript:void(0);" id="accionBorrar-'.$idPresupuesto.'" data-id="'.$idPresupuesto.'" onclick="accionBorrar($(this));"><i class="fa fa-trash" aria-hidden="true"></i></a>';
							$importe = '<span id="importePresupuesto_' . $idPresupuesto . '">' . number_format($pData['importe'],2) . '</span>';
							
							$clave = $this->mactividadmo->getCampo('clave', $value['idActividad']);
							$actDescripcion = $this->mactividadmo->getCampo('descripcion', $value['idActividad']);
							$unidad = $this->mactividadmo->getCampo('idUnidad', $value['idActividad']);
							$unidad = $this->munidades->getCampo('abreviatura', $unidad);

							$response['rows'][$key] = "<tr>
															<td>".$clave."</td>
															<td>".$actDescripcion."</td>
															<td>".$unidad."</td>
															<td>".$apData['cantidad']."</td>
															<td".$input."</td>
															<td>".$importe."</td>
															<td>".$borrar."</td>
														</tr>";
							unset($dData);
						}else{
							$clave = $this->mactividadmo->getCampo('clave', $value['idActividad']);
							$actDescripcion = $this->mactividadmo->getCampo('descripcion', $value['idActividad']);
							$error = $error . "<br>$clave | $actDescripcion";
						}
					}

					if($error != ''){
						$response['error'] = 'LOS SIGUIENTES PRESUPUESTOS NO SE PUDIERON AGREGAR PORQUE YA EXISTE LA ACTIVIDAD EN ESA CATEGORIA <br><br><br> ' . $error;
					}

					$response['importe'] = $this->mpresupuestomo->getSumTotalUnitario($qMO['id']);
				}else{
					$response['error'] = 'EL PRESUPUESTO DE MANO DE OBRA NO EXISTE';
				}
			}else{
				$response['error'] = 'YA NO SE PUEDE MODIFICAR EL PRESUPUESTO PORQUE UNO O VARIOS PAQUETES YA SE ENCUENTRAN "EN CURSO"';
			}
	
			if($response['count'] == $count){
				$response['status'] = 1;
			}
	
			echo json_encode($response);
		}

		public function updateSemana(){
			$idPresupuesto = $this->input->post('idPresupuesto');
			$idManoObra = $this->input->post('idManoObra');
			$semana = $this->input->post('semana');

			$response['status'] = 0;

			$actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($idManoObra);
			if (!is_numeric($actividadesPresupuesto)) {
				foreach($actividadesPresupuesto->result() as $row){
					if($row->id == $idPresupuesto){
						$actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
						if(!is_numeric($actividadPrototipo)){
							$pData['semana'] = $semana;
							$this->mactividadesprototipo->actualizar($pData, $actividadPrototipo['id']);
							$response['status'] = 1;
						}
					}
				}
			}

			echo json_encode($response);
		}

		public function programaObra($id=0){
			$qPaquete = $this->mpaquete->getByIdManoObra($id);
			$idPaquete = ($qPaquete['id'] != '') ? $qPaquete['id'] : 0;
			$qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$idPaquete',idPaquetes)");
			if($qArranque->num_rows() > 0){
				if($qArranque->row()->estatus_arranque == 2 || $qArranque->row()->estatus_arranque == 3){
					redirect($this->router->class);
				}
			}
			$data["msg"]="";
			$data['manoObra'] = $this->mmanoobra->getById($id);
			$data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['manoObra']['idFraccionamiento']);
			$data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['manoObra']['idPrototipo']);
			$data['impTotal'] = $this->mpresupuestomo->getSumTotalUnitario($id);
			$data['categorias'] = $this->mcategoriamo->getSelectResult();
			$data['lotesMza'] = $this->mdetallepaquete->getProyectosByPaquete($idPaquete);
    		$this->data['contenido'] = $this->load->view($this->mainView.'/programa_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }

		public function updateSemana2(){
			$sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
			$idPresupuesto = $this->input->post('idPresupuesto');
			$lote = $this->input->post('lote');
			$manzana = $this->input->post('manzana');
			$idManoObra = $this->input->post('idManoObra');
			$semana = $this->input->post('semana');

			$response['status'] = 0;

			$qPrograma = $this->db->query("SELECT * FROM programa_obra WHERE idPresupuesto = $idPresupuesto AND lote = $lote AND manzana = $manzana");
			if($qPrograma->num_rows() > 0){
				$uData['idPresupuesto'] = $idPresupuesto;
				$uData['lote'] = $lote;
				$uData['manzana'] = $manzana;
				$uData['semana'] = $semana;
				$uData['status'] = 1;
				$uData['updated'] = date("Y-m-d H:i:s");
        		$uData['updated_by'] = $sessionId;


				$this->db->where('id', $qPrograma->row()->id);
				$this->db->update('programa_obra', $uData);
				$response['status'] = 1;
			}else{
				$pData['idPresupuesto'] = $idPresupuesto;
				$pData['lote'] = $lote;
				$pData['manzana'] = $manzana;
				$pData['semana'] = $semana;
				$pData['status'] = 1;
				$pData['created'] = date("Y-m-d H:i:s");
				$pData['updated'] = date("Y-m-d H:i:s");
				$pData['created_by'] = $sessionId;
        		$pData['updated_by'] = $sessionId;

				$this->db->set($pData);
				$this->db->insert('programa_obra');
				$response['status'] = 1;
			}

			echo json_encode($response);
		}

	}
?>