<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Paquetes extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'paquetes'; // form validation variable
            $this->mainView = 'paquetes';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/paquetes/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mpaquete','musuario','mfraccionamiento','mprototipoxfraccionamiento','mprototipos','mconstructores', 'mestimacionprograma', 'mestimacionesprograma', 'mestimadosprograma', 'mmanoobra','mpresupuestomo', 'mmaterial', 'mpresupuestomat', 'mactividadesprototipo', 'mactividadmo', 'mavanceobra', 'mordenpago', 'mdetalleop', 'mcategoriamo', 'mproyecto', 'mdetallepaquete', 'mpaquetepresupuesto', 'munidades', 'msubcategoriamo', 'mmaterialesactividadprototipo', 'mmateriales', 'mproveedor', 'mroles', 'marranque'));

            $this->load->library('csvimport');
			$this->load->library('excel');

            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));

           //Validación de usuarios
           $this->data['fotos_www'] = $this->config->item('base_www').'/paquetes/';
	       			valSession("obra",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $data['status'] = array(1 => 'Pendiente por pagar', 2 => 'Pagado', 3 => 'Facturado');
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }
    
    public function formatos($id){
        $data['q'] = '';
        $data['id'] = $id;

        $this->data['contenido'] = $this->load->view($this->mainView.'/formatos_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->mpaquete->getAll();
        if (!is_numeric($q)){
            foreach ($q->result() as  $row){
                $validarEditar = true;  
                $qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$row->id',idPaquetes)");
                if($qArranque->num_rows() > 0){
                    if($qArranque->row()->estatus_arranque == 2 || $qArranque->row()->estatus_arranque == 3){
                        $validarEditar = false;
                    }
                }
                $detallePaquete = $this->mdetallepaquete->getByIdPaquete($row->id);
                $qEstimacion = $this->mestimacionprograma->getByIdPaquete($row->id);
                $qOrden = $this->mordenpago->getAllByIdPaquete($row->id);
                /*$ac = (!is_numeric($qEstimacion))? true : false;
                $ac2 = (!is_numeric($qOrden))? true : false;*/
                $ac = false;
                $ac2 = false;
                $manoObra = $this->mmanoobra->getById($row->idManoObra);
                //$material = $this->mmaterial->getByIdPaquete($row->id);
                $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($manoObra['id']);
                //$totalPresupuestoMAT = $this->mpresupuestomat->getSumTotalUnitario($material['id']);
                $totalUnitario = $totalPresupuestoMO; // + $totalPresupuestoMAT;
                $lotes = (!is_numeric($detallePaquete)) ? $detallePaquete->num_rows() : 0;
                $totalPaquete = $totalUnitario * $lotes;
                $array['aaData'][] = array(
                    'titulo' => $row->titulo,
                    'manzana' => $row->manzana,
                    'fraccionamiento' => $this->mfraccionamiento->getCampo("titulo",$manoObra['idFraccionamiento']),
                    'prototipo' => $this->mprototipos->getCampo("nombre",$manoObra['idPrototipo']),
                    'constructor' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)",$row->idConstructor),
                    'totalUnitario' => precio_format($totalUnitario),
                    'totalPaquete' => precio_format($totalPaquete),
                    'paqueteViviendas' => $lotes,
                    'lotes' => $row->rango_lotes,
                    'fecha_inicio' => ($row->fecha_inicio!='' && $row->fecha_inicio!='0000-00-00')?date('d/m/Y',strtotime($row->fecha_inicio)):'',//$row->fecha_inicio,
                    'fecha_fin' => ($row->fecha_fin!='' && $row->fecha_fin!='0000-00-00')?date('d/m/Y',strtotime($row->fecha_fin)):'',//$row->fecha_fin,
                    'fecha_fin' => ($row->fecha_fin!='' && $row->fecha_fin!='0000-00-00')?date('d/m/Y',strtotime($row->fecha_fin)):'',//$row->fecha_fin,
                    'statusPaquete' => bgStatus(($qArranque->num_rows() > 0) ? $qArranque->row()->estatus_arranque : ''),
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","paquetes")['w']))? accionesPaquetes($row->id, $this->router->class, true, $validarEditar, false, $ac, $ac2, false, false, false,true, true) : ''
                );
            }
        } else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'manzana' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'constructor' => 'No hay registros',
                'totalUnitario' => 'No hay registros',
                'totalPaquete' => 'No hay registros',
                'paqueteViviendas' => 'No hay registros',
                'lotes' => 'No hay registros',
                'fecha_inicio' => 'No hay registros',
                'fecha_fin' => 'No hay registros',
                'statusPaquete' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }

    public function agregar($id=null,$nuevo=0){ // al acceder a vista agregar
        $errorT = $this->session->flashdata('error');
        $idResidente = '';
        $rangoLotes = '';
        $arrayIdsResidentes = array();
        $arrayIdsResidentes2 = array();
        $arrayRL = array();
        $data['existeResidente'] = false;
        $paquete = $this->mpaquete->getById($id);
        $detalle = $this->mdetallepaquete->getByIdPaquete($id);
        /*if(!is_numeric($paquete)){
            $lotesResidentes = explode(' ', $paquete['idResidentes']);
            if(count($lotesResidentes)>0){
                for ($i=0; $i <count($lotesResidentes); $i++) {
                    $idResidente = explode('_', $lotesResidentes[$i]);
                    if($idResidente[0]>0){
                        $arrayIdsResidentes[] = $idResidente[0];
                        $residentesLotes = array(
                            "idR" => $idResidente[0],
                            "residente" => $this->musuario->getCampo2('nombre',$idResidente[0])." ".$this->musuario->getCampo2('apellidoP',$idResidente[0])." ".$this->musuario->getCampo2('apellidoM', $idResidente[0]),
                            "lotes" => $idResidente[1]
                        );
                        array_push($arrayRL, $residentesLotes);
                        $data['existeResidente'] = true;
                        $rangoLotes .= $idResidente[1].",";
                    }
                }
            }
        }*/

        
        if(!is_numeric($detalle)){
            foreach($detalle->result() as $row){
                if($row->idResidente > 0){
                    $idResidente = $row->idResidente;
                    array_push($arrayIdsResidentes, $idResidente);
                    if (!array_key_exists($idResidente, $arrayIdsResidentes)) {
                        $arrayIdsResidentes2[$idResidente] = $idResidente;
                    }else{
                        $arrayIdsResidentes2[$idResidente] = $idResidente;
                    }
                    $rol = $this->musuario->getCampo2('rol', $idResidente);
                    if (!array_key_exists($idResidente, $arrayRL)) {
                        $lotes = $row->rango_lotes;
                        $arrRng = array($row->rango_lotes);
                        $arrayRL[$idResidente] = array('idResidente' => $idResidente, 'lotes' => $lotes, 'residente' => $this->musuario->getCampo2('nombre',$idResidente)." ".$this->musuario->getCampo2('apellidoP',$idResidente)." ".$this->musuario->getCampo2('apellidoM', $idResidente), 'rango' => $arrRng, 'rol' => $this->mroles->getCampo2('nombre',$rol));
                    }else{
                        $arrRng = $arrayRL[$idResidente]['rango'];
                        if(!in_array($row->rango_lotes, $arrRng)){
                            $arrRng[] = $row->rango_lotes;
                            $lotes = $arrayRL[$idResidente]['lotes'].' '.$row->rango_lotes;
                            $arrayRL[$idResidente] = array('idResidente' => $idResidente, 'lotes' => $lotes, 'residente' => $this->musuario->getCampo2('nombre',$idResidente)." ".$this->musuario->getCampo2('apellidoP',$idResidente)." ".$this->musuario->getCampo2('apellidoM', $idResidente), 'rango' => $arrRng, 'rol' => $this->mroles->getCampo2('nombre',$rol));
                        }
                    }
                    $data['existeResidente'] = true;
                }
            }
        }
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']);
        $data['prototipo'] = $this->mprototipos->getCampo('nombre', $qManoObra['idPrototipo']);
        $data['paquete'] = $paquete;
        $data['detalle'] = $detalle;
        //$data['rangoLotesCurrent'] = substr($rangoLotes, 0,-1);
        $data['residentes'] = $this->musuario->getResidenteObraByPaquete($arrayIdsResidentes);
        $data['residentesLotes'] = $arrayRL;
        $data['residentesAsignados'] = $arrayIdsResidentes2;
        $data['detalleLotes'] = $this->mdetallepaquete->getByAsignado($id);
        $data['id'] = $id;
        $data['nuevo'] = $nuevo; //si es 1 indica que vino desde boton nuevo registro, para que al finalizar no se aplique el ?close del window
        $data['errorT'] = $errorT;
        $this->data['contenido'] = $this->load->view($this->mainView . '/agregar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function guardarResidente(){ // para acciones editar y eliminar residente en vista agregar
        $cValor = "true";
        $id = $this->input->post('id', TRUE);
        $rango = $this->input->post('rango', TRUE);
        $rangoOld = $this->input->post('rangoOld', TRUE);
        $rango = str_replace(' ', '', $rango);
        $residente = $this->input->post('residente', TRUE);
        $residenteOld = $this->input->post('residenteOld', TRUE);
        $accionR = $this->input->post('accionR', TRUE);
        $rangoResidente = ($id>0 && $rango!='')?$residente."_".$rango:'';
        if($rangoResidente!=''){
            $rangoAnterior = $this->mpaquete->getCampo2('idResidentes',$id);
            if($accionR==1){
                //echo $rangoResidente;
                $data['idResidentes'] = str_replace($residenteOld."_".$rangoOld,$rangoResidente,$rangoAnterior);
            }elseif($accionR==2){
                $data['idResidentes'] = str_replace($residente."_".$rangoOld,"",$rangoAnterior);
            }else{               
                $data['idResidentes'] = ($rangoAnterior!='')?$rangoAnterior." ".$rangoResidente:$rangoResidente; 
            }
            $data['idResidentes'] = preg_replace("/[[:blank:]]+/"," ",$data['idResidentes']);

            $this->mpaquete->actualizar($data,$id);
        }
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function checkLotes(){// función que valida si hay lotes disponibles, antes de asignar nuevos lotes a residente
        $cValor = "false";
        $rangoLotes = '';
        $id = $this->input->post('id', TRUE);
        $accionR = $this->input->post('accionR', TRUE);
        $rango = $this->input->post('rango', TRUE);
        $cantidadGuardadaResidentes = $this->mpaquete->getCampo2('idResidentes',$id);
        $lotesResidentes = explode(' ', $cantidadGuardadaResidentes);
        if(count($lotesResidentes)>0){
            for ($i=0; $i <count($lotesResidentes); $i++) {
                $idResidente = explode('_', $lotesResidentes[$i]);
                if($idResidente[0]>0){
                    $rangoLotes .= $idResidente[1].",";
                }
            }
        }
        $cantidadGuardadaResidentes = substr($rangoLotes, 0,-1);
        $cantidadGuardadaResidentes = contarLotes($cantidadGuardadaResidentes);
        if($accionR==1){
            $catidadNueva = contarLotes($rango);
        }else{
            $catidadNueva = contarLotes($rango) + $cantidadGuardadaResidentes;
        }        
        $cantidadTotalPaquete = contarLotes($this->mpaquete->getCampo2('rango_lotes',$id));
        if ($catidadNueva<=$cantidadTotalPaquete) {
            $cValor = "true";
        }
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function nuevo(){
        // Mensajes
        $data['msg'] = '';
        //$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        //$data['prototipos'] = $this->mprototipoxfraccionamiento->getAllList();
		$data['manoObra'] = $this->mmanoobra->getAll();
        $data['constructores'] = $this->mconstructores->getSelectResult();
        //print_r($data['constructores']->result());exit();
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
             // Subida de imagenes
            $config = array();
            $this->load->library('upload', $config);
            $this->load->library('image_lib');            
            if (isset($_FILES)){
                $imagenes = array();
                //print_r($_FILES); exit();
                foreach($_FILES as $key=>$value){
                    if ($_FILES[$key]['size'] > 0){
                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                        $imagenes[] = $key;
                    }
                }
                $totalImagenes = count($imagenes);
                for($i=0; $i< $totalImagenes; $i++){
                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                    //Configuracion del thumbnail
                    if($imagenes[$i]!='pdf'){
                        $nCampoC = explode("_",$imagenes[$i]);
                        $tipo = $nCampoC[0];
                        $v = $nCampoC[1];

                    } else {
                        $v = 0;
                        $tipo = 'pdf';
                    }
                    if ($tipo == 'pdf'){
                        $uploaddir = $this->data['fotos_www'];
                        /*$nextId = $idGestoria;*/
                        $nextId = $this->mpaquete->nextId();
                        $config['file_name'] =  $nextId."_".$v;
                        $config['overwrite'] = TRUE;
                        $config['upload_path'] = $uploaddir;
                        $config['max_size'] = '8000';
                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload($imagenes[$i]) )
                        {
                            $redirect = 1;
                            $data['error'] = $this->upload->display_errors();
                        }
                        else
                        {
                            $contadorArchivos++;
                            $dataFile = $this->upload->data($imagenes[$i]);
                            $fotoI = 'pdf_'.$v;
                            //$thumbI = 'thumbnail_'.$v;
                            if ($v == 0){
                                //Foto default
                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                            } else {
                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                            }
                        }
                    }
                }
            }

            $pData['titulo'] = $this->input->post('titulo', TRUE);
            //$pData['manzana'] = $this->input->post('manzana', TRUE);
            //$pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
            //$pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
            $pData['idManoObra'] = $this->input->post('idManoObra', TRUE);
            $pData['idConstructor'] = $this->input->post('idConstructor', TRUE);
            //$pData['rango_lotes'] = $this->input->post('rango_lotes', TRUE);
            $lotes = $_POST["lotes"];

            $fechaInicio = $this->input->post('fecha_inicio', TRUE);
            $fechaInicio = str_replace('/', '-', $fechaInicio);
            $pData['fecha_inicio'] = ($fechaInicio!='')?date('Y-m-d', strtotime($fechaInicio)):null;
            
            $fechaFin = $this->input->post('fecha_fin', TRUE);
            $fechaFin = str_replace('/', '-', $fechaFin);
            $pData['fecha_fin'] = ($fechaFin!='')?date('Y-m-d', strtotime($fechaFin)):null;
            $pData['anticipo'] = $this->input->post('anticipo', TRUE);
            $pData['tipo'] = ($this->input->post('tipo',TRUE) == "on") ? 2 : 1;
            $pData['status'] = 1;
            $pData['statusPaquete'] = 2;

            //$LotesManzanas = contarLotesManzanas($pData['rango_lotes']);
            $idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $pData['idManoObra']);
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $pData['idManoObra']);
            $errorT = '';
            //foreach($LotesManzanas['arrayMzs'] as $manzana => $lots){
                //foreach($lots as $lt){
            foreach($lotes as $lote){
                    //$existe = $this->mproyecto->getLoteByIdFracIdProtLtMz($idFraccionamiento, $idPrototipo, $lt, $manzana);
                $existe = $this->mproyecto->getById($lote);
                if(!is_numeric($existe)){
                    $lt = $existe['lote'];
                    $manzana = $existe['manzana'];
                    //if($existe->row()->statusVenta != 0){
                    //if(($existe['statusVenta'] == 1) || ($existe['statusVenta'] == 3 && $existe['lineaCredito'] != 3)){
                    /*if($existe['statusVenta'] == 0){
                        $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO ESTA DISPONIBLE </p>";
                    }else{*/
                        //$lotes[] = $existe->row()->id;
                        $lotesProyecto = $this->mdetallepaquete->getByIdProyecto($lote);
                        if ( $pData['tipo'] == 1 ){
                            if( (is_numeric($lotesProyecto) ) ){
                                $arrMZ[$manzana][] = $lt;
                            }else{
                                $errorT .= "<p> EL LT $lt DE LA MZA $manzana PERTENECE A OTRO PAQUETE </p>";
                            }
                        }else{
                            if( !is_numeric($lotesProyecto) && $pData['tipo'] == 2 ){
                                $arrMZ[$manzana][] = $lt;
                            }else{
                                $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO HA SIDO CONSTRUIDO. </p>";
                            }
                        }
                    //}
                }
                    /*else{
                        $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO EXISTE </p>";
                    }
                }*/
            }

            if($errorT != ''){
                $data['msg'] = validation_errors();
                $data['errorT'] = $errorT;
                $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
                $this->load->view('templates/main_template', $this->data);
            }
            else{
                $txtRango = '';
                foreach($arrMZ as $manz => $lot){
                    sort($lot);
                    $arrMZ[$manz] = $lot;
                    $ini = 0;
                    $fin = 0;
                    $con = 0;
                    $txtM = '';
                    foreach($lot as $lot2){
                        if($ini == 0){
                            $ini = $lot2;
                            $fin = $lot2;
                        }
                        else {
                            if($fin == $ini){
                                $con = $lot2;
                                if( ($con - $fin) == 1 ){
                                    $fin = $lot2;
                                }
                                else{
                                    $txtM = $txtM . $ini . ',';
                                    $ini = $con;
                                    $fin = $con;
                                }
                            }
                            else{
                                $con = $lot2;
                                if( ($con - $fin) == 1 ){
                                    $fin = $lot2;
                                }
                                else{
                                    $txtM = $txtM . $ini . '-' . $fin . ',';
                                    $ini = $con;
                                    $fin = $con;
                                }
                            }
                        }
                    }
                    if($ini > 0 && $ini == $fin){
                        $txtM = $txtM . $ini . ',';
                    }
                    if($ini > 0 && $ini != $fin){
                        $txtM = $txtM . $ini . '-' . $fin . ',';
                    }
                    $txtM = substr($txtM, 0, -1);
                    $txtRango = $txtRango . $txtM . '_' . $manz . ' ';
                }
                $pData['rango_lotes'] = substr($txtRango, 0, -1);
                $idPaquete = $this->mpaquete->insertar($pData);

                foreach($lotes as $lote){
                    $dData['idPaquete'] = $idPaquete;
                    $dData['idProyecto'] = $lote;
                    $dData['idResidente'] = 0;
                    $dData['statusAsignado'] = 0;
                    $dData['status'] = 1;
    
                    $idDetalle = $this->mdetallepaquete->insertar($dData);
                }
    
                $qPresupuestos = $this->mpresupuestomo->getByIdManoObra($pData['idManoObra']);
                if(!is_numeric($qPresupuestos)){
                    foreach($qPresupuestos->result() as $pmo){
                        $ppData['idPaquete'] = $idPaquete;
                        $ppData['idPresupuestoMO'] = $pmo->id;
                        $ppData['lotesCompletados'] = 0;
                        $idPackPresu = $this->mpaquetepresupuesto->insertar($ppData); 
                    }
                }
                redirect($this->router->class."/agregar/".$idPaquete."/1/");
            }            
        }

    }

    public function editar($id){
        // Mensajes
        $qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$id',idPaquetes)");
        if($qArranque->num_rows() > 0){
            if($qArranque->row()->estatus_arranque == 2 || $qArranque->row()->estatus_arranque == 3){
                redirect($this->router->class);
            }
        }
        $errorT = $this->session->flashdata('error');
        $msg = '';        
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['titulo'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                       // Subida de imagenes
                $config = array();
                $this->load->library('upload', $config);
                $this->load->library('image_lib');            
                if (isset($_FILES)){
                    $imagenes = array();
                    //print_r($_FILES); exit();
                    foreach($_FILES as $key=>$value){
                        if ($_FILES[$key]['size'] > 0){
                            $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                            $imagenes[] = $key;
                        }
                    }
                    $totalImagenes = count($imagenes);
                    for($i=0; $i< $totalImagenes; $i++){
                        $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                        //Configuracion del thumbnail
                        if($imagenes[$i]!='pdf'){
                            $nCampoC = explode("_",$imagenes[$i]);
                            $tipo = $nCampoC[0];
                            $v = $nCampoC[1];

                        } else {
                            $v = 0;
                            $tipo = 'pdf';
                        }
                        if ($tipo == 'pdf'){
                            $uploaddir = $this->data['fotos_www'];
                            /*$nextId = $idGestoria;*/
                            $nextId = $this->mpaquete->nextId();
                            $config['file_name'] =  $nextId."_".$v;
                            $config['overwrite'] = TRUE;
                            $config['upload_path'] = $uploaddir;
                            $config['max_size'] = '8000';
                            $config['allowed_types'] = '*';//pdf|jpg|jpeg|png|gif
                            $this->upload->initialize($config);
                            if ( ! $this->upload->do_upload($imagenes[$i]) )
                            {
                                $redirect = 1;
                                $data['error'] = $this->upload->display_errors();
                            }
                            else
                            {
                                $contadorArchivos++;
                                $dataFile = $this->upload->data($imagenes[$i]);
                                $fotoI = 'pdf_'.$v;
                                //$thumbI = 'thumbnail_'.$v;
                                if ($v == 0){
                                    //Foto default
                                    $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                                    $pData['statusPaquete'] = 2;
                                } else {
                                    $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                                }
                            }

                        }

                    }
                }


                $pData['titulo'] = $this->input->post('titulo', TRUE);
                //$pData['manzana'] = $this->input->post('manzana', TRUE);
                //$pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
                //$pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
                $pData['idManoObra'] = $this->input->post('idManoObra', TRUE);
                $pData['idConstructor'] = $this->input->post('idConstructor', TRUE);
                //$pData['rango_lotes'] = $this->input->post('rango_lotes', TRUE);
                $lotes = $_POST["lotes"];
                $fechaInicio = $this->input->post('fecha_inicio', TRUE);
                $fechaInicio = str_replace('/', '-', $fechaInicio);
                $pData['fecha_inicio'] = ($fechaInicio!='')?date('Y-m-d', strtotime($fechaInicio)):null;               
                $fecha_inicio_real= $this->input->post('fecha_inicio_real', TRUE);
                $fecha_inicio_real = str_replace('/', '-', $fecha_inicio_real);
                $pData['fecha_inicio_real'] = ($fecha_inicio_real!='')?date('Y-m-d', strtotime($fecha_inicio_real)):null;
                $fechaFin = $this->input->post('fecha_fin', TRUE);
                $fechaFin = str_replace('/', '-', $fechaFin);
                $pData['fecha_fin'] = ($fechaFin!='')?date('Y-m-d', strtotime($fechaFin)):null;
                $pData['anticipo'] = $this->input->post('anticipo', TRUE);
                $pData['tipo'] = ($this->input->post('tipo',TRUE) == "on") ? 2 : 1;
                
                $pData['status'] = 1;
                //$LotesManzanas = contarLotesManzanas($pData['rango_lotes']);
                $idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $pData['idManoObra']);
                $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $pData['idManoObra']);
                $errorT = '';
                /*foreach($LotesManzanas['arrayMzs'] as $manzana => $lots){
                    foreach($lots as $lt){*/
                foreach($lotes as $lote){
                    $existe = $this->mproyecto->getById($lote);
                        //$existe = $this->mproyecto->getLoteByIdFracIdProtLtMz($idFraccionamiento, $idPrototipo, $lt, $manzana);
                    if(!is_numeric($existe)){
                        $lt = $existe['lote'];
                        $manzana = $existe['manzana'];
                            //if($existe->row()->statusVenta != 0){
                        /*if($existe['statusVenta'] == 0){
                            $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO ESTA DISPONIBLE </p>";
                        }else{*/
                            //$lotes[] = $existe->row()->id;
                            $arrMZ[$manzana][] = $lt;
                            $lotesCom[$lote] = array('id' => $lote, 'mza' => $manzana, 'lt' => $lt);
                        //}
                    }
                        /*else{
                            $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO EXISTE </p>";
                        }
                    }
                }*/
                }
                if($errorT != ''){
                    $msg = validation_errors();
                    $this->session->set_flashdata('error', $errorT);
                    redirect($this->router->class."/editar/".$id);
                }
                else{
                    $txtRango = '';
                    foreach($arrMZ as $manz => $lot){
                        sort($lot);
                        $arrMZ[$manz] = $lot;
                        $ini = 0;
                        $fin = 0;
                        $con = 0;
                        $txtM = '';
                        foreach($lot as $lot2){
                            if($ini == 0){
                                $ini = $lot2;
                                $fin = $lot2;
                            }
                            else {
                                if($fin == $ini){
                                    $con = $lot2;
                                    if( ($con - $fin) == 1 ){
                                        $fin = $lot2;
                                    }
                                    else{
                                        $txtM = $txtM . $ini . ',';
                                        $ini = $con;
                                        $fin = $con;
                                    }
                                }
                                else{
                                    $con = $lot2;
                                    if( ($con - $fin) == 1 ){
                                        $fin = $lot2;
                                    }
                                    else{
                                        $txtM = $txtM . $ini . '-' . $fin . ',';
                                        $ini = $con;
                                        $fin = $con;
                                    }
                                }
                            }
                        }
                        if($ini > 0 && $ini == $fin){
                            $txtM = $txtM . $ini . ',';
                        }
                        if($ini > 0 && $ini != $fin){
                            $txtM = $txtM . $ini . '-' . $fin . ',';
                        }
                        $txtM = substr($txtM, 0, -1);
                        $txtRango = $txtRango . $txtM . '_' . $manz . ' ';
                    }
                    $pData['rango_lotes'] = substr($txtRango, 0, -1);
                    //$this->input->post('status',TRUE);
                    $infoDetalle = $this->mdetallepaquete->getByIdPaquete($id);
                    if(!is_numeric($infoDetalle)){
                        $qResult = $infoDetalle->result_array();
                        $qResult = array_column($qResult, 'idProyecto');
                        //$qResult = array_flip($qResult);
                        //$idArray = array_flip($idArray);
                        $diffAdd = array_diff($lotes, $qResult);
                        $diffDel = array_diff($qResult, $lotes);

                        if(count($diffAdd)){
                            foreach($diffAdd as $add){
                                $lotesProyecto = $this->mdetallepaquete->getByIdProyecto($add);
                                if ( $pData['tipo'] == 1 ){
                                    if( (is_numeric($lotesProyecto) ) ){
                                        $dData['idPaquete']= $id;
                                        $dData['idProyecto'] = $add;
                                        $dData['idResidente'] = 0;
                                        $dData['statusAsignado'] = 0;
                                        $dData['status'] = 1;
                        
                                        $idAgregados[] = $this->mdetallepaquete->insertar($dData);
                                    }
                                    else{
                                        $errorT .= "<p> EL LT $lotesCom[$add][lt] DE LA MZA $lotesCom[$add][mza] PERTENECE A OTRO PAQUETE </p>";
                                    }
                                }
                                else{
                                    if( !is_numeric($lotesProyecto) && $pData['tipo'] == 2 ){
                                        $dData['idPaquete']= $id;
                                        $dData['idProyecto'] = $add;
                                        $dData['idResidente'] = 0;
                                        $dData['statusAsignado'] = 0;
                                        $dData['status'] = 1;
                        
                                        $idAgregados[] = $this->mdetallepaquete->insertar($dData);
                                    }
                                    else{
                                        $errorT .= "<p> EL LT $lotesCom[$add][lt] DE LA MZA $lotesCom[$add][mza] NO HA SIDO CONSTRUIDO. </p>";
                                    }
                                }
                            }
                        }

                        if($errorT != ''){
                            foreach($idAgregados as $del){
                                $this->mdetallepaquete->borrar($del);
                            }
                            unset($pData['rango_lotes']);
                            $this->mpaquete->actualizar($pData, $id);
                            $msg = validation_errors();
                            $this->session->set_flashdata('error', $errorT);
                            redirect($this->router->class."/editar/".$id);
                        }
                        else{
                            if(count($diffDel) > 0){
                                foreach($diffDel as $del){
                                    $loteDel = $this->mdetallepaquete->getByIdPaqueteIdProyecto($id, $del);
                                    if(!is_numeric($loteDel)){
                                        $this->mdetallepaquete->borrar($loteDel['id']);
                                    }
                                }
                            }
                        }
                    }
                    $this->mpaquete->actualizar($pData, $id);

                    if($fecha_inicio_real!=''){
                        $qEstimacion = $this->mestimacionprograma->getByIdPaquete($id);
                        if(!is_numeric($qEstimacion)){
                            $qEstimaciones = $this->mestimacionesprograma->getByIdEstimacion($qEstimacion['id']);
                            if(!is_numeric($qEstimaciones)){
                                $fecha_inicio = new DateTime(date('Y-m-d', strtotime($fecha_inicio_real)));
                                $intervalo = new DateInterval('P7D');
                                foreach ($qEstimaciones->result() as $esti) {
                                    $eData['fecha'] = $fecha_inicio->format('Y-m-d');
                                    //aqui se suma la semana
                                    $fecha_inicio->add($intervalo);
                                    $this->mestimacionesprograma->actualizar($eData, $esti->id);
                                }        
                            }
                        }
                    }
                    $pdf = $this->mpaquete->getCampo2('pdf',$id);
                    $fecha_inicio_real = $this->mpaquete->getCampo2('fecha_inicio_real',$id);
                    //echo $fecha_inicio_real; exit();

                    if ($pdf != '' && $fecha_inicio_real == '' ) {
                        redirect($this->router->class."/editar/".$id);
                    }elseif ($pdf != '' && $fecha_inicio_real != '' ) {
                        redirect($this->router->class."/agregar/".$id);
                    }else{
                        redirect($this->router->class."/agregar/".$id);
                    }
                }
            }
        }
        // Obteniendo la información
        $info = $this->mpaquete->getById($id);
        $infoDetalle = $this->mdetallepaquete->getByIdPaquete($info['id']);
        if(!is_numeric($infoDetalle)){
            $qResult = $infoDetalle->result_array();
            $qResult = array_column($qResult, 'idProyecto');
			//$idArray = array_flip($idArray);
        }else{
            $qResult = array();
        }

        $data = $info;
        $data['msg']=$msg;
        $data['msg'] = '';
        $data['errorT'] = $errorT;
        //$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
        //$data['prototipos'] = $this->getPrototiposByFraccForSelect($info['idFraccionamiento']);
        $qManoObra =$this->mmanoobra->getById($info['idManoObra']);
        $data['lotes'] = $this->mproyecto->getByIdFraccionamientoPrototipo($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], false, '');
        $data['idsLotes'] = (count($qResult) > 0) ? implode('-', $qResult) : array();
        $data['manoObra'] = $this->getMOByFraccProtoForSelect($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $info['idManoObra']);
        $data['constructores'] = $this->mconstructores->getSelectResult();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function getPrototiposByFraccForSelect($id=''){
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $response[$value->idPrototipo] = $this->mprototipos->getCampo('nombre',$value->idPrototipo);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getMOByFraccProtoForSelect($idFraccionamiento = '', $idPrototipo = '', $idMO = ''){
		$manoobra = $this->mmanoobra->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, true, 'paquetes', $idMO);
        $array = array();
        $response = array();
        if ( !is_numeric($manoobra) ) {
            foreach ($manoobra->result() as $key => $value) {
                $response[$value->id] = $value->titulo;
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function ver($id = null){
        $info = $this->mpaquete->getById($id);
        $data = $info;
        $manoObra = $this->mmanoobra->getById($info['idManoObra']);
        $idConstructor = $info['idConstructor'];
        $data['constructor'] = $this->mconstructores->getCampo2('nombre',$idConstructor).' '. $this->mconstructores->getCampo2('apellidoP',$idConstructor);
        $idPrototipo = $manoObra['idPrototipo'];
        $data['prototipo'] = $this->mprototipos->getCampo2('nombre',$idPrototipo);
        $idFraccionamiento = $manoObra['idFraccionamiento'];
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo',$idFraccionamiento);
        $statusPaquete = $info['statusPaquete'];
        $data['statusPaquete'] = getStatusPaquete($statusPaquete);
        $data['detallePaquete'] = $this->mdetallepaquete->getByIdPaquete($id);
        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($manoObra['id']);
        $totalUnitario = $totalPresupuestoMO;
        $lotes = (!is_numeric($data['detallePaquete'])) ? $data['detallePaquete']->num_rows() : 0;
        $totalPaquete = $totalUnitario * $lotes;
        $data['totalUnitario'] = precio_format($totalUnitario);
        $data['totalPaquete'] = precio_format($totalPaquete);
        $data['retencion'] = ($info['porcentaje_retencion'] == 0)? $totalPaquete * .05 : $totalPaquete * ($info['porcentaje_retencion'] / 100);
       // $data['retencionvicios'] = ($info['porcentaje_rvicios'] == 0)? $totalPaquete * .03 : $totalPaquete * ($info['porcentaje_rvicios'] / 100);
        $LotesManzanas = contarLotesManzanas($info['rango_lotes']);
        $manzanas = array_keys($LotesManzanas['arrayMzs']);
        $textoM = '';
        foreach($manzanas as $mz){
            $textoM = $textoM . $mz . ', ';
        }        
        $data['manzana'] = substr($textoM, 0, -2);
        $data['lotes'] = $LotesManzanas['lotes'];
        $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($id);
        $textoM = '';
        if(!is_numeric($residentes)){
            foreach($residentes->result() as $idR){
                $residente = $this->musuario->getCampo('nombre', $idR->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idR->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idR->idResidente);
                $textoM = $textoM . $residente . '<br>';
            }
        }
        else{
            $textoM = 'No tiene residentes asignados<br>';
        }
        $data['residente'] = substr($textoM, 0, -4);
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mpaquete->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mpaquete->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getEstimacionesByPaquete(){
        $semana = array();
        $ids = array();
        $qEstimacion = $this->mestimacionprograma->getByIdPaquete($_POST['id']);
        if(!is_numeric($qEstimacion)){
            $qEstimaciones = $this->mestimacionesprograma->getByIdEstimacion($qEstimacion['id']);
            if(!is_numeric($qEstimaciones)){
                foreach ($qEstimaciones->result() as $value) {
                    $qOrden = $this->mordenpago->getActiveByIdEstimaciones($value->id);
                    if(is_numeric($qOrden)){
                        $fecha_fin = new DateTime($value->fecha);
                        $intervalo = new DateInterval('P6D');
                        $fecha_fin->add($intervalo);
                        if($fecha_fin->format('Y-m-d') <= date('Y-m-d') || ($fecha_fin->format('Y-m-d') >= date('Y-m-d') && $value->fecha <= date('Y-m-d'))){
                            $ids[] = $value->id;
                            $semana[] = 'Semana ' . $value->nEstimacion . ' (' . $value->fecha . ' - ' . $fecha_fin->format('Y-m-d') . ')';
                        }
                    }
                }
            }
        }
        $datitos['semana'] = $semana;
        $datitos['id'] = $ids;
        
        echo json_encode($datitos);
    }

    public function guardarOP(){
        $datitos['msg'] = 'Debe seleccionar la semana';
        $arrayLotes = array();
        $qEstimaciones = $this->mestimacionesprograma->getById($_POST['idEstimaciones']);
        if(!is_numeric($qEstimaciones)){
            $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $qEstimaciones['idEstimacion']);
            $idManoObra = $this->mpaquete->getCampo('idManoObra', $idPaquete);
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idManoObra);
            $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($idPrototipo);
            if(!is_numeric($qCatProt)){
                foreach ($qCatProt->result() as $CategoriaProt) {
                    $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($idManoObra, $CategoriaProt->idCategoria);
                    if(!is_numeric($qActProt)){
                        $Categorias[$CategoriaProt->idCategoria] = $qActProt->num_rows();
                        foreach ($qActProt->result() as $ActividadProt) {
                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idManoObra, $ActividadProt->id);
                            if(!is_numeric($qPresupuesto)){
                                $qPackPresu = $this->mpaquetepresupuesto->getByIdPaqueteIdPresupuesto($idPaquete, $qPresupuesto['id']);
                                if(!is_numeric($qPackPresu)){
                                    $lotesHechos = explode(',', $qPackPresu['lotes']);
                                    foreach($lotesHechos as $LtH){
                                        if(isset($LtH) && !empty($LtH) && !is_null($LtH)){
                                            if(isset($arrayLotes[$LtH])){
                                                $cat = $arrayLotes[$LtH];
                                                if(isset($cat[$CategoriaProt->idCategoria])){
                                                    $cat[$CategoriaProt->idCategoria][] = $qPackPresu['idPresupuestoMO'];
                                                    $arrayLotes[$LtH] = $cat;
                                                }
                                                else{
                                                    $cat[$CategoriaProt->idCategoria] = array($qPackPresu['idPresupuestoMO']);
                                                    $arrayLotes[$LtH] = $cat;
                                                }
                                            }
                                            else{
                                                unset($cat);
                                                $cat[$CategoriaProt->idCategoria] = array($qPackPresu['idPresupuestoMO']);
                                                $arrayLotes[$LtH] = $cat;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            foreach($arrayLotes as $lote => $categ){
                foreach($categ as $idCate => $arrayCate){
                    if(count($arrayCate) != $Categorias[$idCate]){
                        unset($arrayLotes[$lote][$idCate]);
                    }
                }
                if(empty($arrayLotes[$lote])){
                    unset($arrayLotes[$lote]);
                }
            }
            if(!empty($arrayLotes)){
                $totalS = 0;
                $qOrdenP = $this->mordenpago->getAllByIdPaquete($idPaquete);
                if(!is_numeric($qOrdenP)){
                    foreach($qOrdenP->result() as $ordenes){
                        $detallesOP = $this->mdetalleop->getAllByIdOrdenPago($ordenes->id);
                        if(!is_numeric($detallesOP)){
                            foreach($detallesOP->result() as $detOP){
                                $detLotes = explode(',', $detOP->lotes);
                                foreach($arrayLotes as $lote => $categ){
                                    if(in_array($lote, $detLotes)){
                                        foreach($categ as $idCate => $arrayCate){
                                            if(in_array($detOP->idPresupuesto, $arrayCate)){
                                                unset($arrayLotes[$lote][$idCate]);
                                            }
                                        }
                                        if(empty($arrayLotes[$lote])){
                                            unset($arrayLotes[$lote]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    foreach($arrayLotes as $lote => $categ){
                        foreach($categ as $idCate => $arrayCate){
                            foreach($arrayCate as $presupuesto){
                                $qPresupuesto = $this->mpresupuestomo->getById($presupuesto);
                                if(isset($arrayPresu[$presupuesto])){
                                    $arrayPresu[$presupuesto]['lotes'] = $arrayPresu[$presupuesto]['lotes'] . ',' . $lote;
                                    $arrayPresu[$presupuesto]['monto'] = $arrayPresu[$presupuesto]['monto'] + $qPresupuesto['importe'];
                                }
                                else{
                                    $arrayPresu[$presupuesto] = array(
                                        'idPresupuesto' => $presupuesto,
                                        'lotes' => $lote,
                                        'precioUnitario' => $qPresupuesto['importe'],
                                        'monto' => $qPresupuesto['importe']
                                    );
                                }
                                $totalS = $totalS + $qPresupuesto['importe'];
                            }
                        }
                    }
                    if($totalS > 0){
                        $oData['idPaquete'] = $idPaquete;
                        $oData['idEstimaciones'] = $qEstimaciones['id'];
                        $oData['monto'] = $totalS;
                        $oData['statusPago'] = 1;
                        $retencion = $this->mpaquete->getCampo('porcentaje_retencion', $idPaquete);
                        $retencionvicios = $this->mpaquete->getCampo('porcentaje_rvicios', $idPaquete);
                        $oData['retencion'] = ($retencion == 0)? $totalS * .05 : $totalS * ($retencion / 100);
                        $oData['retencionvicios'] = ($retencionvicios == 0)? $totalS * .03 : $totalS * ($retencionvicios / 100);
                        $id = $this->mordenpago->insertar($oData);
                        if(is_numeric($id) && $id > 0){
                            set_time_limit(300);
                            foreach($arrayPresu as $presu){
                                $dData['idPresupuesto'] = $presu['idPresupuesto'];
                                $dData['idOrdenPago'] = $id;
                                $dData['lotes'] = $presu['lotes'];
                                $dData['precioUnitario'] = $presu['precioUnitario'];
                                $dData['monto'] = $presu['monto'];
                                $idD = $this->mdetalleop->insertar($dData);
                            }
                            $datitos['msg'] = '';
                        }
                    }
                    else{
                        $datitos['msg'] = 'No hay actividades en esta semana';
                    }
                }
                else{
                    foreach($arrayLotes as $lote => $categ){
                        foreach($categ as $idCate => $arrayCate){
                            foreach($arrayCate as $presupuesto){
                                $qPresupuesto = $this->mpresupuestomo->getById($presupuesto);
                                if(isset($arrayPresu[$presupuesto])){
                                    $arrayPresu[$presupuesto]['lotes'] = $arrayPresu[$presupuesto]['lotes'] . ',' . $lote;
                                    $arrayPresu[$presupuesto]['monto'] = $arrayPresu[$presupuesto]['monto'] + $qPresupuesto['importe'];
                                }
                                else{
                                    $arrayPresu[$presupuesto] = array(
                                        'idPresupuesto' => $presupuesto,
                                        'lotes' => $lote,
                                        'precioUnitario' => $qPresupuesto['importe'],
                                        'monto' => $qPresupuesto['importe']
                                    );
                                }
                                $totalS = $totalS + $qPresupuesto['importe'];
                            }
                        }
                    }
                    if($totalS > 0){
                        $oData['idPaquete'] = $idPaquete;
                        $oData['idEstimaciones'] = $qEstimaciones['id'];
                        $oData['monto'] = $totalS;
                        $oData['statusPago'] = 1;
                        $retencion = $this->mpaquete->getCampo('porcentaje_retencion', $idPaquete);
                        $retencionvicios = $this->mpaquete->getCampo('porcentaje_rvicios', $idPaquete);
                        $oData['retencion'] = ($retencion == 0)? $totalS * .05 : $totalS * ($retencion / 100);
                        $oData['retencionvicios'] = ($retencionvicios == 0)? $totalS * .03 : $totalS * ($retencionvicios / 100);
                        $id = $this->mordenpago->insertar($oData);
                        if(is_numeric($id) && $id > 0){
                            set_time_limit(300);
                            foreach($arrayPresu as $presu){
                                $dData['idPresupuesto'] = $presu['idPresupuesto'];
                                $dData['idOrdenPago'] = $id;
                                $dData['lotes'] = $presu['lotes'];
                                $dData['precioUnitario'] = $presu['precioUnitario'];
                                $dData['monto'] = $presu['monto'];
                                $idD = $this->mdetalleop->insertar($dData);
                            }
                            $datitos['msg'] = '';
                        }
                    }
                }
            }
            else{
                $datitos['msg'] = 'No hay actividades en esta semana';
            }
            
            ///Por estimaciones :V
            /*$qEstimado = $this->mestimadosprograma->getAllByIdEstimaciones($qEstimaciones['id']);
            if(!is_numeric($qEstimado)){
                $totalS = 0;
                foreach ($qEstimado->result() as $esdos) {
                    $lotes = 0;
                        $qAvance = $this->mavanceobra->getByIdEstimado($esdos->id);
                    if(!is_numeric($qAvance)){
                        $ltA = explode(',', $qAvance['lotes']);
                        foreach ($ltA as $lots) {
                            $lotes = (!empty($lots))? $lotes + 1 : $lotes;
                        }
                    }
                    $importe = $this->mpresupuestomo->getCampo('importe', $esdos->idPresupuesto);
                    $acumulado = $lotes * $importe;
                    if($lotes){
                        $total[$esdos->idPresupuesto] = array('idPresupuesto' => $esdos->idPresupuesto,
                            'avances' => $qAvance['id'],
                            'lotes' => $lotes,
                            'lts' => $qAvance['lotes'],
                            'precioU' => $importe,
                            'aPagar' => $acumulado
                        );
                    }
                    $totalS = $totalS + $acumulado;
                }
                if($totalS){
                    $oData['idPaquete'] = $idPaquete;
                    $oData['idEstimaciones'] = $qEstimaciones['id'];
                    $oData['monto'] = $totalS;
                    $oData['statusPago'] = 1;
                    $retencion = $this->mpaquete->getCampo('porcentaje_retencion', $idPaquete);
                    $retencionvicios = $this->mpaquete->getCampo('porcentaje_rvicios', $idPaquete);
                    $oData['retencion'] = ($retencion == 0)? $totalS * .05 : $totalS * ($retencion / 100);
                    $oData['retencionvicios'] = ($retencionvicios == 0)? $totalS * .03 : $totalS * ($retencionvicios / 100);
                    $id = $this->mordenpago->insertar($oData);
                    if(is_numeric($id) && $id > 0){
                        set_time_limit(300);
                        foreach ($total as $key) {
                            $dData['idPresupuesto'] = $key['idPresupuesto'];
                            $dData['idOrdenPago'] = $id;
                            $dData['lotes'] = $key['lts'];
                            $dData['precioUnitario'] = $key['precioU'];
                            $dData['monto'] = $key['aPagar'];
                            $idD = $this->mdetalleop->insertar($dData);
                        }
                    }
                    $datitos['msg'] = '';
                }
                else{
                    $datitos['msg'] = 'No hay actividades en esta semana';
                }
            }*/
        }

        echo json_encode($datitos);
    }

    public function listarOrdenes($idPaquete){
        $q = $this->mordenpago->getAllbyIdPaquete($idPaquete);
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $ac = false;
                switch ($row->statusPago) {
                    case 1:
                        $statusP = 'Pendiente por pagar';
                        $ac = true;
                        break;
                    case 2:
                        $statusP = 'Pagado';
                        break;
                    case 3:
                        $statusP = 'Facturado';
                        break;
                    case 4:
                        $statusP = 'Cancelado';
                        break;
                    default:
                        $statusP = '';
                        break;
                }
                
                $array['aaData'][] = array(
                    'semana' =>  ($row->idEstimaciones != '')? 'Semana ' . $this->mestimacionesprograma->getCampo('nEstimacion',$row->idEstimaciones):'',
                    'monto' => ($row->monto != '')? $row->monto : '',
                    'statusPago' => $statusP,
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","paquetes")['w']))? accionesOrdenes($row->id, $this->router->class, true, false, $ac, $ac) : ''
                );
            }
        } else{
            $array['aaData'][] = array(
                'semana' => 'No hay registros',
                'monto' => 'No hay registros',
                'statusPago' => 'No hay registros',
                'acciones' => 'No hay registros'
            );
        }
        echo json_encode($array);
    }

    public function verOrden($id = null){
        $info = $this->mordenpago->getById($id);
        if(!is_numeric($info)){
            switch ($info['statusPago']) {
                    case 1:
                        $statusP = 'Pendiente por pagar';
                        break;
                    case 2:
                        $statusP = 'Pagado';
                        break;
                    case 3:
                        $statusP = 'Facturado';
                        break;
                    case 4:
                        $statusP = 'Cancelado';
                        break;
                    default:
                        $statusP = '';
                        break;
                }
            $data['paquete'] = $this->mpaquete->getCampo('titulo', $info['idPaquete']);
            $data['semana'] = $this->mestimacionesprograma->getCampo('nEstimacion', $info['idEstimaciones']);
            $data['status'] = $statusP;
            $data['monto'] = precio_format($info['monto']);
            $data['rvicios'] = precio_format($info['retencionvicios']);
            $data['retencion'] = precio_format($info['retencion']);
            $data['total'] = precio_format($info['monto'] - ($info['retencionvicios'] + $info['retencion']));
            $qDetalles = $this->mdetalleop->getAllByIdOrdenPago($info['id']);
            
            if(!is_numeric($qDetalles)){
                foreach ($qDetalles->result() as $detalle) {
                    $lotes = 0;
                    $ltA = explode(',', $detalle->lotes);
                    foreach ($ltA as $lots) {
                        $lotes = (!empty($lots))? $lotes + 1 : $lotes;
                    }
                    $idActProt = $this->mpresupuestomo->getCampo('idActividadPrototipo', $detalle->idPresupuesto);
                    $idAct = $this->mactividadesprototipo->getCampo('idActividad', $idActProt);
                    $idCat = $this->mactividadesprototipo->getCampo('idCategoria', $idActProt);
                    $clave = $this->mactividadmo->getCampo('clave', $idAct);
                    $acti = $this->mactividadmo->getCampo('descripcion', $idAct);
                    $actividades[$idCat][] = array(
                        'lotes' => $lotes,
                        'clave' => $clave,
                        'descripcion' => $acti,
                        'precioU' => precio_format($detalle->precioUnitario),
                        'pagar' => precio_format($detalle->monto)
                    );
                    if(isset($categoria)){
                            if(!in_array($idCat, $categoria) ){
                            $categoria[$idCat] = array('id' => $idCat,
                                'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                            );
                        }
                    }
                    else{
                        $categoria[$idCat] = array('id' => $idCat,
                            'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                        );
                    }
                }
                
            }
        }
        $data['id'] = $id;
        $data['categorias'] = $categoria;
        $data['actividades'] = $actividades;
        $this->data['contenido'] = $this->load->view($this->mainView . '/orden_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar_archivo()
    {
        if (isset($_POST['elid'])){
            $id = $this->input->post('elid');
            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
            if($campo !="0"){
                $archivo = $this->mpaquete->getCampo('pdf_'.$campo,$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf_'.$campo] ='';
                    $this->mpaquete->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }else{
                $archivo = $this->mpaquete->getCampo('pdf',$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf'] ='';
                    $this->mpaquete->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;

        }
    }

    public function actualizarPagado(){
        if(isset($_POST['id'])){
            $data['statusPago'] = 2;
            $data['fechaAplicado'] = date('Y-m-d');
            $this->mordenpago->actualizar($data, $_POST['id']);
        }
    }

    public function actualizarCancelado(){
        if(isset($_POST['id'])){
            $data['statusPago'] = 4;
            $this->mordenpago->actualizar($data, $_POST['id']);
        }
    }

    public function getManoObraByFraccProto($idFraccionamiento = '', $idPrototipo = '')
    {
        $manoobra = $this->mmanoobra->getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, true, 'paquetes');
        $array = array();
        $response = array();
        if (!is_numeric($manoobra)) {
            foreach ($manoobra->result() as $key => $value) {
                $array = array(
                    'id' => $value->id,
                    'titulo' => $value->titulo
                );
                array_push($response, $array);
            }
        } else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getLotesByManoObra($idManoObra='')
    {
        $manoObra = $this->mmanoobra->getById($idManoObra);
        if(!is_numeric($manoObra)){
            $lotes = $this->mproyecto->getByIdFraccionamientoPrototipo($manoObra['idFraccionamiento'], $manoObra['idPrototipo'], false, '');
            $array = array();
            $response = array();
            if ( !is_numeric($lotes) ) {
                foreach ($lotes->result() as $key => $value) {
                    $array = array(
                        'id' => $value->id,
                        'titulo' => $value->titulo
                    );
                    array_push($response, $array);
                }
            }
            else {
                $response = 0;
            }
        }else{
            $response = 0;
        }
        echo json_encode($response);
    }

    public function updateLotes(){
        $idPaquete = $this->input->post('idPaquete', TRUE);
        $idResidente = $this->input->post('idResidente', TRUE);
        $detalles = $_POST["idDetalle"];
        $rango_lotes = $this->mpaquete->getCampo('rango_lotes', $idPaquete);
        $idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
        $idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $idMO);
        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idMO);
        /*$detalles = $this->input->post('idDetalle', TRUE);
        if(is_array($detalles)){
            $detalles = $detalles[0];
        }*/
        $LotesManzanas = contarLotesManzanas($rango_lotes);
        //$LotsManzs = contarLotesManzanas($detalles);
        $errorT = '';
        foreach($detalles as $lote){
            $idProy = $this->mdetallepaquete->getCampo('idProyecto', $lote);
            $existe = $this->mproyecto->getById($idProy);
            if(!is_numeric($existe)){
                $lt = $existe['lote'];
                $manzana = $existe['manzana'];
                $LotsManzs['arrayMzs'][$manzana][] = $lt;
                $lotes[] = array('id' => $lote, 'mza' => $manzana, 'lt' => $lt);

            }
        }
        foreach($LotsManzs['arrayMzs'] as $manz => $lot){
            sort($lot);
            $LotsManzs['arrayMzs'][$manz] = $lot;
            $ini = 0;
            $fin = 0;
            $con = 0;
            $txtM = '';
            foreach($lot as $lot2){
                if($ini == 0){
                    $ini = $lot2;
                    $fin = $lot2;
                }
                else {
                    if($fin == $ini){
                        $con = $lot2;
                        if( ($con - $fin) == 1 ){
                            $fin = $lot2;
                        }
                        else{
                            $txtM = $txtM . $ini . ',';
                            $ini = $con;
                            $fin = $con;
                        }
                    }
                    else{
                        $con = $lot2;
                        if( ($con - $fin) == 1 ){
                            $fin = $lot2;
                        }
                        else{
                            $txtM = $txtM . $ini . '-' . $fin . ',';
                            $ini = $con;
                            $fin = $con;
                        }
                    }
                }
            }
            if($ini > 0 && $ini == $fin){
                $txtM = $txtM . $ini . ',';
            }
            if($ini > 0 && $ini != $fin){
                $txtM = $txtM . $ini . '-' . $fin . ',';
            }
            $txtM = substr($txtM, 0, -1);
            $LotsManzs['arrayRangos'][$manz] = $txtM . '_' . $manz;
        }
        
        /*foreach($LotsManzs['arrayMzs'] as $manzana => $lots){
            if( array_key_exists($manzana, $LotesManzanas['arrayMzs']) ){
                foreach($lots as $lt){
                    if( !in_array($lt, $LotesManzanas['arrayMzs'][$manzana]) ){
                        $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO ESTA EN EL PAQUETE </p>";
                    }
                    else{
                        $existe = $this->mproyecto->getLoteByIdFracIdProtLtMz($idFraccionamiento, $idPrototipo, $lt, $manzana);
                        if(!is_numeric($existe)){
                            $lotes[] = array('id' => $existe->row()->id, 'mza' => $manzana, 'lt' => $lt);
                        }
                        else{
                            $errorT .= "<p> EL LT $lt DE LA MZA $manzana NO EXISTE </p>";
                        }
                    }
                }
            }
            else{
                $errorT .= "<p> LA MZA $manzana NO ESTA EN EL PAQUETE </p>";
            }
        }*/
        if($errorT != ''){
            $this->session->set_flashdata('error', $errorT);
        }
        else{
            $lotesResidente = $this->mdetallepaquete->getByIdResidente($idPaquete, $idResidente);
            if(!is_numeric($lotesResidente)){
                foreach($lotesResidente->result() as $row){
                    $dData['idResidente'] = 0;
                    $dData['statusAsignado'] = 0;
                    $dData['rango_lotes'] = NULL;

                    $this->mdetallepaquete->actualizar($dData, $row->id);
                }
            }

            foreach($lotes as $value){
                //$detalleXProyecto = $this->mdetallepaquete->getByIdPaqueteIdProyecto($idPaquete, $value['id']);
                $detalleXProyecto = $this->mdetallepaquete->getById($value['id']);
                if(!is_numeric($detalleXProyecto)){
                    if($detalleXProyecto['idResidente'] == 0){
                        $pData['idResidente'] = $idResidente;
                        $pData['statusAsignado'] = 1;
                        $pData['rango_lotes'] = $LotsManzs['arrayRangos'][$value['mza']];
                        $this->mdetallepaquete->actualizar($pData, $detalleXProyecto['id']);                        
                    }
                    else{
                        $errorT .= "<p> EL LT $value[lt] DE LA MZA $value[mza] TIENE OTRO RESIDENTE </p>";
                    }
                }
                else{
                    $errorT .= "<p> EL LT $value[lt] DE LA MZA $value[mza] NO ESTA REGISTRADO EN EL PAQUETE </p>";
                }
            }
            if($errorT != ''){
                $lotesResidente2 = $this->mdetallepaquete->getByIdResidente($idPaquete, $idResidente);
                if(!is_numeric($lotesResidente2)){
                    foreach($lotesResidente2->result() as $row){
                        $dData['idResidente'] = 0;
                        $dData['statusAsignado'] = 0;
                        $dData['rango_lotes'] = NULL;
    
                        $this->mdetallepaquete->actualizar($dData, $row->id);
                    }
                }
                if(!is_numeric($lotesResidente)){
                    foreach($lotesResidente->result() as $row){
                        $dData['idResidente'] = $row->idResidente;
                        $dData['statusAsignado'] = 1;
                        $dData['rango_lotes'] = (empty($row->rango_lotes))? NULL : $row->rango_lotes;
    
                        $this->mdetallepaquete->actualizar($dData, $row->id);
                    }
                }
                $this->session->set_flashdata('error', $errorT);
            }
        }
        redirect($this->router->class."/agregar/".$idPaquete."/1/");
    }

    public function getByIdResidente($idPaquete='', $idResidente='')
    {
        $lotes = $this->mdetallepaquete->getByIdResidente($idPaquete, $idResidente);
        $array = array();
        $response = array();
        if ( !is_numeric($lotes) ) {
            foreach ($lotes->result() as $key => $value) {
                $array = array(
                    'id' => $value->id,
                    'titulo' => $value->titulo
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function updateAsignado($idPaquete, $idResidente){
        $lotes = $this->mdetallepaquete->getByIdResidente($idPaquete, $idResidente);
        $response['success'] = false;
        if (!is_numeric($lotes)) {
            foreach ($lotes->result() as $key => $value) {
                $dData['idResidente'] = 0;
                $dData['statusAsignado'] = 0;
                $dData['rango_lotes'] = NULL;

                $this->mdetallepaquete->actualizar($dData, $value->id);
                $response['success'] = true;
            }
        }
        echo json_encode($response);
    }

    public function exportar($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            /*$detallePaquete = $this->mdetallepaquete->getByIdPaquete($paquete['id']);
            if (!is_numeric($detallePaquete)) {
                $paqueteLotes = $detallePaquete->num_rows();
            }*/
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $presupuestoUnit = 0;
            $totalContrato = 0;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($paquete['idManoObra']);
            $empty = true;
            $arrayPresupuestoMO = array();
            $countArray = 0;
            if (!is_numeric($actividadesPresupuesto)) {
                foreach ($actividadesPresupuesto->result() as $row) {
                    $existe = 0;
                    $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                    if (!is_numeric($actividadPrototipo)) {
                        $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                        if (!is_numeric($actividad)) {
                            $empty = false;
                            $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                            if (!is_numeric($categoria)) {
                                if (count($arrayPresupuestoMO) > 0) {
                                    $countArray = count($arrayPresupuestoMO) - 1;
                                    for ($j = 0; $j <= $countArray; $j++) {
                                        if ($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']) {
                                            $existe++;
                                            $precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
                                            $importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
                                            $arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
                                            $arrayPresupuestoMO[$j]['importe'] = $importe;
                                        }
                                    }
                                    if ($existe == 0) {
                                        array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                    }
                                } else {
                                    array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                }
                            }

                            $unidad = $this->munidades->getById($actividad['idUnidad']);
                            if (!is_numeric($unidad)) {
                                array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                            }
                        }
                    }
                }
            }
        }

        if (!$empty) {
            if (count($arrayPresupuestoMO) > 0) {
                $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MANO OBRA PAQUETE');
                $objPHPExcel->setActiveSheetIndex(0);

                $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                $objDrawing->setName('Logo Viviend');
                $objDrawing->setDescription('Logo Viviend');
                $objDrawing->setImageResource($gdImage);
                $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                $objDrawing->setOffsetX(150);
                $objDrawing->setOffsetY(0);
                $objDrawing->setWidth(900);
                $objDrawing->setHeight(140);
                $objDrawing->setCoordinates('A1');
                $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'DESCRIPCION');
                $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'UNIDAD');
                $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'CANTIDAD');
                $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'PRECIO UNITARIO');
                $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'IMPORTE');
                $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'IMPORTE POR PAQUETE');

                $objPHPExcel->getActiveSheet()->getStyle('B8:B12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->SetCellValue('A8', 'PAQUETE:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B8', strtoupper($paquete["titulo"]));

                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                //

                $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                //

                $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                $rowCount = 14;
                $rowCategoria = 0;
                $importeCategoria = 0;
                $importePaqueteCategoria = 0;
                foreach ($arrayPresupuestoMO as $row) {
                    if ($row['tipo'] == 'C') {
                        $clave = $row['clave'];
                        $descripcion = $row['descripcion'];
                        $unidad = '';
                        $cantidad = '';
                        $precioUnitario = '';
                        $importe = '';
                        $importePaquete = '';
                        $rowCategoria = $rowCount;
                        $importeCategoria = 0;
                        $importePaqueteCategoria = 0;

                        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCategoria . ':B' . $rowCategoria)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D9D9D9')
                            ))
                        );

                        $objPHPExcel->getActiveSheet()->getStyle('C' . $rowCategoria . ':G' . $rowCategoria)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => '595959')
                            ))
                        );
                    } else {
                        $clave = $row['clave'];
                        $descripcion = $row['descripcion'];
                        $unidad = $row['unidad'];
                        $cantidad = $row['cantidad'];
                        $precioUnitario = precio_format($row['precioUnitario']);
                        $importe = $row['importe'];
                        $presupuestoUnit = $presupuestoUnit + $importe;
                        $importePaquete = $row['importe'] * $paqueteLotes;
                        $totalContrato = $totalContrato + $importePaquete;

                        $importeCategoria = $importeCategoria + $importe;
                        $importePaqueteCategoria = $importePaqueteCategoria + $importePaquete;

                        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':G' . $rowCount)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => 'FFFFFF')
                            ))
                        );
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $clave);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $descripcion);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $unidad);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $cantidad);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $precioUnitario);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($importe));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($importePaquete));

                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCategoria, precio_format($importeCategoria));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCategoria, precio_format($importePaqueteCategoria));

                    $rowCount++;
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($presupuestoUnit));
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($totalContrato));

                $styleArray = array(
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        )
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle(
                    'A13:G' . $rowCount
                )->applyFromArray($styleArray);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);

                // $name = $paquete["id"].".".$paquete["titulo"];
                $name = 'Ppto. Obras'.' - '.$paquete["titulo"];
                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                // Forzamos a la descarga
                $objWriter->save('php://output');
            }
        }
    }


    public function exportarPMO($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            /*$detallePaquete = $this->mdetallepaquete->getByIdPaquete($paquete['id']);
            if (!is_numeric($detallePaquete)) {
                $paqueteLotes = $detallePaquete->num_rows();
            }*/
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $presupuestoUnit = 0;
            $totalContrato = 0;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($paquete['idManoObra']);
            $empty = true;
            $arrayPresupuestoMO = array();
            $arrayMzaLotes = array();
            $countArray = 0;
            $qLotes=$this->mdetallepaquete->getProyectosByPaquete($idPaquete);
            if(!is_numeric($qLotes)){
                foreach ($qLotes->result() as $val) {
                    if(!in_array($val->manzana, $arrayMzaLotes)){
                        $arrayMzaLotes[$val->manzana][$val->lote] = array('lote' => $val->lote);
                    }else{
                        $arrayMzaLotes[$val->manzana][$val->lote] = array('lote' => $val->lote);
                    }
                }
            }
            if (!is_numeric($actividadesPresupuesto)) {
                foreach ($actividadesPresupuesto->result() as $row) {
                    $existe = 0;
                    $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                    if (!is_numeric($actividadPrototipo)) {
                        $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                        if (!is_numeric($actividad)) {
                            $empty = false;
                            $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                            if (!is_numeric($categoria)) {
                                if (count($arrayPresupuestoMO) > 0) {
                                    $countArray = count($arrayPresupuestoMO) - 1;
                                    for ($j = 0; $j <= $countArray; $j++) {
                                        if ($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']) {
                                            $existe++;
                                            $precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
                                            $importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
                                            $arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
                                            $arrayPresupuestoMO[$j]['importe'] = $importe;
                                        }
                                    }
                                    if ($existe == 0) {
                                        array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => ''));
                                    }
                                } else {
                                    array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => ''));
                                }
                            }

                            $unidad = $this->munidades->getById($actividad['idUnidad']);
                            if (!is_numeric($unidad)) {
                                array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'semana' => $actividadPrototipo['semana']));
                            }
                        }
                    }
                }
            }
        }

        if (!$empty) {
            if (count($arrayPresupuestoMO) > 0) {
                $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MANO OBRA PAQUETE');
                $objPHPExcel->setActiveSheetIndex(0);

                $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                $objDrawing->setName('Logo Vviend');
                $objDrawing->setDescription('Logo Viviend');
                $objDrawing->setImageResource($gdImage);
                $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                $objDrawing->setOffsetX(150);
                $objDrawing->setOffsetY(0);
                $objDrawing->setWidth(900);
                $objDrawing->setHeight(140);
                $objDrawing->setCoordinates('A1');
                $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                $estimacion = $this->mestimacionprograma->getByIdPaquete($paquete['id']);
                if(!is_numeric($estimacion)){
                    $estimaciones = $this->mestimacionesprograma->getByIdEstimacion($estimacion['id']);
                    if(!is_numeric($estimaciones)){
                        $letraIC = 'C';
                        foreach($estimaciones->result() as $r){
                            $fechaInicio = $r->fecha;
                            $fechaTermino = strtotime ('+6 day',strtotime($fechaInicio)) ;
                            $fechaInicio = date ('d-m-Y',strtotime($fechaInicio));
                            $fechaTermino = date ('d-m-Y',$fechaTermino);

                            $objPHPExcel->getActiveSheet()->SetCellValue($letraIC.'1', 'SEMANA '. $r->nEstimacion);
                            //$objPHPExcel->getActiveSheet()->SetCellValue($letraIC.'2', );
                            $objPHPExcel->getActiveSheet()->getStyle($letraIC.'2:'.$letraIC.'2')->applyFromArray(
                                array('fill' => array(
                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                    'color' => array('rgb' => getColor($r->nEstimacion))
                                ))
                            );
                            $objPHPExcel->getActiveSheet()->SetCellValue($letraIC.'3', $fechaInicio);


                            $letraIC++;
                        }
                    }
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'DESCRIPCION');
                /*$objPHPExcel->getActiveSheet()->SetCellValue('C13', 'UNIDAD');
                $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'CANTIDAD');
                $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'PRECIO UNITARIO');
                $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'IMPORTE');
                $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'IMPORTE POR PAQUETE');*/

                $objPHPExcel->getActiveSheet()->getStyle('B8:B12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->SetCellValue('A8', 'PAQUETE:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B8', strtoupper($paquete["titulo"]));

                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                //

                $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                //

                $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                $rowCount = 14;
                $letraFinal = '';
                $rowCategoria = 0;
                $importeCategoria = 0;
                $importePaqueteCategoria = 0;
                foreach ($arrayPresupuestoMO as $row) {
                    if ($row['tipo'] == 'C') {
                        $clave = $row['clave'];
                        $descripcion = $row['descripcion'];
                        $unidad = '';
                        $cantidad = '';
                        $precioUnitario = '';
                        $importe = '';
                        $importePaquete = '';
                        $rowCategoria = $rowCount;
                        $importeCategoria = 0;
                        $importePaqueteCategoria = 0;

                        if($rowCount == 14){
                            if(count($arrayMzaLotes) > 0){
                                //$letraMza = 'C';
                                $letraLotes = 'C';
                                $letraMza = $letraLotes;
                                $lI = '';
                                $lF = '';
                                $rowMza = 13;
                                foreach($arrayMzaLotes as $key => $value){
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraLotes.$rowMza, 'MZA '.$key);
                                    $letraMza = $letraLotes;
                                    $lI = $letraMza;
                                    foreach($arrayMzaLotes[$key] as $k => $v){
                                        $lF = $letraLotes;
                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraLotes.$rowCount, 'LOTE '.$k);
                                        $letraMza = $letraLotes;
                                        $letraLotes++;
                                    }
                                    $objPHPExcel->getActiveSheet()->mergeCells($lI.$rowMza.':'.$lF.$rowMza);
                                    $style = array(
                                        'alignment' => array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                        )
                                    );
                                    $objPHPExcel->getActiveSheet()->getStyle($lI.$rowMza.':'.$lF.$rowMza)->applyFromArray($style);
                                    //$letraMza++;
                                }
                            }
                        }

                        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCategoria . ':B' . $rowCategoria)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D9D9D9')
                            ))
                        );

                        

                        /*$objPHPExcel->getActiveSheet()->getStyle('C' . $rowCategoria . ':G' . $rowCategoria)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => '595959')
                            ))
                        );*/
                    } else {
                        $clave = $row['clave'];
                        $descripcion = $row['descripcion'];
                        $unidad = $row['unidad'];
                        $cantidad = $row['cantidad'];
                        $precioUnitario = precio_format($row['precioUnitario']);
                        $importe = $row['importe'];
                        $presupuestoUnit = $presupuestoUnit + $importe;
                        $importePaquete = $row['importe'] * $paqueteLotes;
                        $totalContrato = $totalContrato + $importePaquete;

                        $importeCategoria = $importeCategoria + $importe;
                        $importePaqueteCategoria = $importePaqueteCategoria + $importePaquete;

                        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':G' . $rowCount)->applyFromArray(
                            array('fill' => array(
                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                'color' => array('rgb' => 'FFFFFF')
                            ))
                        );

                         if(count($arrayMzaLotes) > 0){
                            $letraLotesS = 'C';
                            foreach($arrayMzaLotes as $key => $value){
                                foreach($arrayMzaLotes[$key] as $k => $v){

                                    $qPrograma = $this->db->query("SELECT * FROM programa_obra WHERE idPresupuesto = ".$row['idPresupuesto']." AND lote = $k AND manzana = $key");
                                    $sem = ($qPrograma->num_rows() > 0) ? $qPrograma->row()->semana : $row['semana'];

                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraLotesS.$rowCount, $sem);

                                    $qAvance = $this->db->query("SELECT av.*, es.nEstimacion FROM estimacion_programa AS en INNER JOIN estimaciones_programa AS es ON en.id = es.idEstimacion INNER JOIN estimados_programa AS eds ON es.id = eds.idEstimaciones INNER JOIN avanceobra AS av ON eds.id = av.idEstimado WHERE en.idPaquete = $idPaquete AND eds.idPresupuesto = ".$row['idPresupuesto']);
                                    
                                    if($qAvance->num_rows() > 0){
                                        foreach($qAvance->result() as $av){
                                            if($av->lotes != ''){
                                                $lts = explode(',', $av->lotes);
                                                $countLt = count($lts);

                                                for($i=0; $i<$countLt;$i++){
                                                    $lt = explode('/', $lts[$i]);
                                                    if($k == $lt[0]){
                                                        $objPHPExcel->getActiveSheet()->getStyle($letraLotesS.$rowCount.':'.$letraLotesS.$rowCount)->applyFromArray(
                                                            array('fill' => array(
                                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                'color' => array('rgb' => getColor($av->nEstimacion))
                                                            ))
                                                        );
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    /*if($qPrograma->num_rows() > 0){
                                        $objPHPExcel->getActiveSheet()->getStyle($letraLotesS.$rowCount.':'.$letraLotesS.$rowCount)->applyFromArray(
                                            array('fill' => array(
                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                'color' => array('rgb' => getColor($qPrograma->row()->semana))
                                            ))
                                        );
                                    }*/
                                    $letraFinal = $letraLotesS;
                                    $letraLotesS++;
                                }
                            }
                        }
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $clave);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $descripcion);
                    /*$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $unidad);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $cantidad);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $precioUnitario);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($importe));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($importePaquete));

                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCategoria, precio_format($importeCategoria));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCategoria, precio_format($importePaqueteCategoria));*/

                    $rowCount++;
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                //$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($presupuestoUnit));
                //$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($totalContrato));

                $styleArray = array(
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        )
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle(
                    'A13:'.$letraFinal . $rowCount
                )->applyFromArray($styleArray);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);

                // $name = $paquete["id"].".".$paquete["titulo"];
                $name = 'Ppto. Obras'.' - '.$paquete["titulo"];
                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                // Forzamos a la descarga
                $objWriter->save('php://output');
            }
        }
    }

    public function exportarPrograma($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $estimaciones = 0;
        $lotes = 0;
        if(!is_numeric($paquete)){
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $objPHPExcel->getActiveSheet()->setTitle('PROGRAMA DE OBRA');
            $objPHPExcel->setActiveSheetIndex(0);

            $inicial = 'A';
            $final = '';
            $letra = 'D';
            $diaEstimado = 'D';
            $diaInicial = 1;
            $rowFinal = 0;
            $lastColumn = '';
            $estimacion = $this->mestimacionprograma->getByIdPaquete($paquete['id']);
            if(!is_numeric($estimacion)){
                //ARMADO DE COLUMNA A - C
                $lotes=$this->mdetallepaquete->getProyectosByPaquete($idPaquete);
                $objPHPExcel->getActiveSheet()->getColumnDimension("A")->setWidth(5);
                $objPHPExcel->getActiveSheet()->SetCellValue('B7','LOTE');
                $objPHPExcel->getActiveSheet()->getColumnDimension("B")->setWidth(12);
                $objPHPExcel->getActiveSheet()->SetCellValue('C7','MANZANA');
                $objPHPExcel->getActiveSheet()->getColumnDimension("C")->setWidth(12);
                $objPHPExcel->getActiveSheet()->getStyle("A7:C7")->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $fontStyle = array(
                    'font' => array(
                        'size' => 10
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle('A7:C7')->applyFromArray($fontStyle);


                $estimaciones = $this->mestimacionesprograma->getByIdEstimacion($estimacion['id']);
                if(!is_numeric($estimaciones)){
                    foreach($estimaciones->result() as $e){
                        $rowInicial = 1;
                        $rowFinal = 6;
                        $letraInicial = $letra;
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . '4', 'SEMANA ' . $e->nEstimacion);
                        $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setWidth(4);

                        for ($rowInicial; $rowInicial <= $rowFinal; $rowInicial++) {
                            $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setWidth(4);
                            switch ($rowInicial) {
                                case 1:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'L');
                                    break;
                                case 2:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'M');
                                    break;
                                case 3:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'M');
                                    break;
                                case 4:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'J');
                                    break;
                                case 5:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'V');
                                    break;
                                case 6:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'S');
                                    break;
                                case 7:
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '5', 'D');
                                    break;
                            }

                            //AGREGANDO LOS NUMEROS PERTENECIENTES A LOS LOTES POR SEMANA
                            $i=8;
                            foreach($lotes->result() as $row){
                                $objPHPExcel->getActiveSheet()->SetCellValue($letra.$i,$e->nEstimacion);
                                $objPHPExcel->getActiveSheet()->getStyle($letra.$i)->getAlignment()->applyFromArray(
                                    array(
                                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                    )
                                );
                                $styleArray = array(
                                    'font' => array(
                                        'size' => 10
                                    ),
                                    'borders' => array(
                                        'outline' => array(
                                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                        )
                                    )
                                );
                                $objPHPExcel->getActiveSheet()->getStyle($letra.$i)->applyFromArray($styleArray);
                                $i++;
                            }

                            //$objPHPExcel->getActiveSheet()->SetCellValue($letra . '10', $diaInicial);
                            if ($rowInicial == 6) {
                                //$semana++;
                                //$calculoDias = $semana * $diasSemana;
                                $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '4:' . $letra . '4');

                                $styleArrayS = array(
                                    'borders' => array(
                                        'outline' => array(
                                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                        )
                                    )
                                );

                                $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '4:' . $letra . '6')->applyFromArray($styleArrayS);
                            }

                            $objPHPExcel->getActiveSheet()->getStyle($letra . '9')->getAlignment()->applyFromArray(
                                array(
                                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                )
                            );

                            $letra++;
                        }
                        $final = $letra;
                    }

                    $lastColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle($diaEstimado . '4:' . $lastColumn . '5')->applyFromArray($styleArray);
                }
            }

            $tituloFraccionamiento = '';
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            if(!is_numeric($manoObra)){
                $tituloFraccionamiento = $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']);
                //LISTADO DE SUBCATEGORIAS
                $querySubCategoria = $this->msubcategoriamo->getSubCategoriasByPaquete($idPaquete);

                if(!is_numeric($querySubCategoria)){
                    $letraSubCategoriaInicial = 'D';
                    $i=1;
                    foreach($querySubCategoria->result() as $r){
                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSubCategoriaInicial . '6', $r->subCategoria);
                        $objPHPExcel->getActiveSheet()->getStyle($letraSubCategoriaInicial . '6')->getAlignment()->setTextRotation(90);
                        $objPHPExcel->getActiveSheet()->getRowDimension(6)->setRowHeight(150);

                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSubCategoriaInicial . '7', $i);
                        $objPHPExcel->getActiveSheet()->getStyle($letraSubCategoriaInicial . '7')->getAlignment()->applyFromArray(
                            array(
                                'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            )
                        );
                        $i++;

                        $fontStyleSubCategoria = array(
                            'font' => array(
                                'size' => 10
                            )
                        );
                        $fontStyleSubCategoriaNumber = array(
                            'font' => array(
                                'size' => 9
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle($letraSubCategoriaInicial . '6')->applyFromArray($fontStyleSubCategoria);
                        $objPHPExcel->getActiveSheet()->getStyle($letraSubCategoriaInicial . '7')->applyFromArray($fontStyleSubCategoriaNumber);
                        $letraSubCategoriaInicial++;
                    }
                }
            }

            //AGREGANDO TABLA DE ESTIMACIONES
            $letra++;
            $inicioTabla=$letra;
            $objPHPExcel->getActiveSheet()->SetCellValue($letra . '6', implode("\n", str_split("SEMANA")));
            $letra++;
            $objPHPExcel->getActiveSheet()->SetCellValue($letra . '6', implode("\n", str_split("INICIO")));            
            $letra++;
            $objPHPExcel->getActiveSheet()->SetCellValue($letra . '6', implode("\n", str_split("TERMINO")));

            $styleHeaderTabla = array(
                'font' => array(
                    'size' => 13
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($inicioTabla . '6:' . $letra . '6')->applyFromArray($styleHeaderTabla);
            $objPHPExcel->getActiveSheet()->getStyle($inicioTabla . '6:' . $letra . '6')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle($inicioTabla . '6:' . $letra . '6')->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            
            //AGREGANDO FECHAS Y COLORES AL CUERPO DE LA TABLA
            $i=8;
            $estimaciones=(!is_numeric($estimaciones)) ? $estimaciones->result_array() : array();
            for ($j=0; $j < COUNT($estimaciones); $j++) {
                $inicioEstim=$inicioTabla;
                $fechaInicio = $estimaciones[$j]["fecha"];
                $fechaTermino = strtotime ('+6 day',strtotime($fechaInicio)) ;
                $fechaInicio = date ('d-m-Y',strtotime($fechaInicio));
                $fechaTermino = date ('d-m-Y',$fechaTermino);

                $objPHPExcel->getActiveSheet()->SetCellValue($inicioEstim . $i, $i - 7);
                $inicioEstim++;
                $objPHPExcel->getActiveSheet()->SetCellValue($inicioEstim . $i, $fechaInicio);            
                $inicioEstim++;
                $objPHPExcel->getActiveSheet()->SetCellValue($inicioEstim . $i, $fechaTermino);

                $styleBodyTabla = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        )
                    ),
                    'fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => getColor($estimaciones[$j]["nEstimacion"]))
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($inicioTabla.$i.':'.$letra.$i)->applyFromArray($styleBodyTabla);

                //INICIA ARMADO DE ARRAY PARA PINTAR EL AVANCE DE OBRA POR subCategoria
                $y=8;
                foreach($lotes->result() as $row){
                    //INICIA ARMADO DE ARRAY PARA PINTAR EL AVANCE DE OBRA POR subCategoria
                    $nEstimacion=$estimaciones[$j]["nEstimacion"];
                    $subCategorias=$querySubCategoria->result_array();;
                    $subCategoriasAvance=$this->msubcategoriamo->getSubCategoriasFinalizadasByLote($idPaquete,$nEstimacion,$row->lote."/".$row->manzana);

                    $letraInicialAvance="D";
                    if(!is_numeric($subCategoriasAvance)){
                        for ($z=0; $z < COUNT($subCategoriasAvance) ; $z++) {
                            $key = array_search($subCategoriasAvance[$z]["idSubCategoria"], array_column($subCategorias, 'idSubCategoria'));
                            $letraTemp=$this->getColumna($letraInicialAvance,$key);

                            if($objPHPExcel->getActiveSheet()->getStyle($letraTemp.$y)->getFill()->getStartColor()->getRGB() == "FFFFFF"){
                                if(($subCategoriasAvance[$z]["n"] == $subCategorias[$key]["n"])){
                                    $styleArray = array(
                                                    'fill' => array(
                                                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                        'color' => array('rgb' => getColor($nEstimacion))
                                                    )
                                                );           
                                    $objPHPExcel->getActiveSheet()->getStyle($letraTemp.$y)->applyFromArray($styleArray);
                                }
                            }
                        }
                    }
                    $y++;
                }
                $i++;
            }

            //ARMADO DE LOTES Y MANZANAS
            if(!is_numeric($lotes)){
                $i=8;
                foreach($lotes->result() as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$i-7);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$row->lote);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$row->manzana);
                    $styleArray = array(
                        'font' => array(
                            'size' => 10
                        ),
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle("A".$i.":C".$i)->applyFromArray($styleArray);
                    $objPHPExcel->getActiveSheet()->getStyle("A".$i.":C".$i)->getAlignment()->applyFromArray(
                        array(
                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                        )
                    );
                    $i++;
                }
            }

            //INFORMACION GENERAL DEL PAQUETE
            $objPHPExcel->getActiveSheet()->SetCellValue('C5', 'DIAS');
            $styleArray = array(
                'font' => array(
                    'size' => 10
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'FFFFFF')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:C5')->applyFromArray($styleArray);

            $objPHPExcel->getActiveSheet()->mergeCells('A6:C6');
            $styleArray = array(
                'font' => array(
                    'size' => 10
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => '000000')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => '58b04b')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A6:C6')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('A6:C6')->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A6')->getAlignment()->setWrapText(true);
            $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$paquete["idManoObra"]));
            $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $paquete["idConstructor"]);
            $infoPaquete="PROTOTIPO: ".$prototipo."\n";
            $infoPaquete.="CONTRATISTA: ".$contratista."\n";
            $infoPaquete.="FECHA INICIO: ".$paquete["fecha_inicio"]."\n";
            $infoPaquete.="FECHA TERMINO: ".$paquete["fecha_fin"]."\n";
            $objPHPExcel->getActiveSheet()->SetCellValue('A6',$infoPaquete);

            //ENCABEZADO CON FRACCIONAMIENTO
            $objPHPExcel->getActiveSheet()->mergeCells($diaEstimado . '1:' . $lastColumn . '3');
            $objPHPExcel->getActiveSheet()->SetCellValue($diaEstimado . '1', 'FRACCIONAMIENTO '. $tituloFraccionamiento);

            $fontStyleTitle = array(
                'font' => array(
                    'size' => 20
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($diaEstimado . '1:' . $lastColumn . '3')->applyFromArray($fontStyleTitle);
            $objPHPExcel->getActiveSheet()->getStyle($inicial . '1:' . $final . '5')->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $name = 'PROGRAMA DE OBRA';
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
            // Forzamos a la descarga
            $objWriter->save('php://output');
        }
    }

    public function getColumna($columna, $n){
        for ($i=0; $i < $n; $i++) { 
            $columna++;
        }
        return $columna;
    }

    public function resumen(){
        //COLOR DDEBF7
        $paquetes = $this->mpaquete->getAllByTipo();
        $paquetesExtra = $this->mpaquete->getAllByTipo(2);
        if(!is_numeric($paquetes)){
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $objPHPExcel->getActiveSheet()->setTitle('RESUMEN');
            $objPHPExcel->setActiveSheetIndex(0);

            //TITULOS PRINCIPALES
            $objPHPExcel->getActiveSheet()->SetCellValue("B4","Sali Edificaciones, S.A. de C.V.");
            $objPHPExcel->getActiveSheet()->SetCellValue("B5","Avance de Obra FRACC. MISIONES MIRAVALLE");
            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 13
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle("B4")->applyFromArray($styleArray);


            //ENCABEADO DE LA TABLA DE RESUMEN
            $fInicioHeader=7;
            $fInicio=8;
            $cInicio="A";
            $cFinal="T";
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicioHeader,"REAL");
            $objPHPExcel->getActiveSheet()->mergeCells('H'.$fInicioHeader.":I".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicioHeader, 'CONTRATO');
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicioHeader,"AVANCE");
            $objPHPExcel->getActiveSheet()->mergeCells('L'.$fInicioHeader.":N".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicioHeader,"POR EJECUTAR");
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$fInicioHeader.":P".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicioHeader,"RETENCIONES");
            $objPHPExcel->getActiveSheet()->mergeCells('Q'.$fInicioHeader.":T".$fInicioHeader);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fInicio, 'No. Viviendas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fInicio, 'Manzanas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fInicio, 'Lotes');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fInicio, 'Prototipo');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fInicio, 'No. Sistema');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicio, 'Fecha Inicio');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicio, 'Fecha Final');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fInicio, 'Duracion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicio, 'Contrato');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicio, 'No. Estim.');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicio, 'Avance Acumulado');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicio, 'Pdte. por Ejecutar');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicio, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicio, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fInicio, 'Retencion Otras');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fInicio, '%');

            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('H'.$fInicioHeader.":I".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('H'.$fInicioHeader.":I".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);

            //ARMADO DEL CUERPO DE LA TABLA RESUMEN
            //VARIABLES GLOBALES
            $total=0;
            $totalViviendas=0;
            $totalContrato=0;
            $totalEstimaciones=0;
            $totalAcumulado=0;
            $totalPctjeAcumulado=0;
            $totalPdteEjecutar=0;
            $totalPctjePdteEjecutar=0;
            $totalRetencion=0;
            $totalPctjeRetencion=0;
            $totalOtros=0;
            $totalPctjeOtros=0;
            $fFinalBody=9;
            $fInicioBody=9;
            if(!is_numeric($paquetes)){
                foreach ($paquetes->result() as $row) {
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $nEs=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $lotesManzanas=contarLotesManzanas($row->rango_lotes);
                    $manzanas=implode(", ",array_keys($lotesManzanas["arrayMzs"]));
                    $lotes = $lotesManzanas['lotes'];
                    $duracion=$this->mprototipos->getCampo("estimaciones",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $estimP=$this->mordenpago->getEstimacionesByPaquete($row->id);
                    $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($row->idManoObra);
                    $contrato="$".number_format($totalUnitarioMO * $lotesManzanas["total"],2);
                    $pdteEjecutar=($totalUnitarioMO * $lotesManzanas["total"]) - $estimP->acumulado;
                    $PctjeAcumulado=($estimP->acumulado * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeEjecutar=($pdteEjecutar * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeRetencion=($estimP->retencion * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeOtros=($estimP->otros * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    //TOTALES GLOBALES
                    $total++;
                    $totalViviendas+=$lotesManzanas["total"];
                    $totalContrato+=$totalUnitarioMO * $lotesManzanas["total"];
                    $totalEstimaciones+=$estimP->n;
                    $totalAcumulado+=$estimP->acumulado;
                    $totalPctjeAcumulado+=$PctjeAcumulado;
                    $totalPdteEjecutar+=$pdteEjecutar;
                    $totalPctjePdteEjecutar+=$PctjeEjecutar;
                    $totalRetencion+=$estimP->retencion;
                    $totalPctjeRetencion+=$PctjeRetencion;
                    $totalOtros+=$estimP->otros;
                    $totalPctjeOtros+=$PctjeOtros;

                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $lotesManzanas["total"]);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, $manzanas);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, $lotes);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, $prototipo);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, $row->id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, $row->fecha_inicio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, $row->fecha_fin);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, $duracion." SEM.");
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, $contrato);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $estimP->n);
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, "$".number_format($estimP->acumulado,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, round($PctjeAcumulado).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, "$".number_format($pdteEjecutar,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, round($PctjeEjecutar).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, "$".number_format($estimP->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, round($PctjeRetencion).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($estimP->otros,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, round($PctjeOtros).'%');
                    $fFinalBody++;
                }

                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }

            //FOOTER DE LA TABLA DE RESUMEN
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $totalViviendas);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, "$".number_format($totalContrato,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $totalEstimaciones);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, "$".number_format($totalAcumulado,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, round($totalPctjeAcumulado / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, "$".number_format($totalPdteEjecutar,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, round($totalPctjePdteEjecutar / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, round($totalPctjeRetencion / $total)."%");
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($totalOtros,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, round($totalPctjeOtros / $total)."%");

            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);

            //ENCABEzADO DE LA TABLA EXTRAS------------------------
            $fInicioHeader2=$fFinalBody + 4;
            $fInicio2=$fInicioHeader2 + 1;
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicioHeader2,"EXTRAS");
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicioHeader2,"REAL");
            $objPHPExcel->getActiveSheet()->mergeCells('H'.$fInicioHeader2.":I".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicioHeader2, 'CONTRATO');
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicioHeader2,"AVANCE");
            $objPHPExcel->getActiveSheet()->mergeCells('L'.$fInicioHeader2.":N".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicioHeader2,"POR EJECUTAR");
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$fInicioHeader2.":P".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicioHeader2,"RETENCIONES");
            $objPHPExcel->getActiveSheet()->mergeCells('Q'.$fInicioHeader2.":T".$fInicioHeader2);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fInicio2, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fInicio2, 'No. Viviendas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fInicio2, 'Manzanas');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fInicio2, 'Lotes');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fInicio2, 'Prototipo');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fInicio2, 'No. Sistema');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fInicio2, 'Fecha Inicio');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fInicio2, 'Fecha Final');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fInicio2, 'Duracion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fInicio2, 'Contrato');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fInicio2, 'No. Estim.');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fInicio2, 'Avance Acumulado');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fInicio2, 'Pdte. por Ejecutar');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fInicio2, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fInicio2, '%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fInicio2, 'Retencion Otras');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fInicio2, '%');

            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );

            $styleAlignment=array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            );

            $objPHPExcel->getActiveSheet()->getStyle('B'.$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('B'.$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);

            $objPHPExcel->getActiveSheet()->getStyle('H'.$fInicioHeader2.":I".$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('H'.$fInicioHeader2.":I".$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);

            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader2.":T".$fInicioHeader2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader2.":T".$fInicioHeader2)->getAlignment()->applyFromArray($styleAlignment);

            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio2.":".$cFinal.$fInicio2)->getAlignment()->setWrapText(true);

            //ARMADO DEL CUERPO DE LA TABLA EXTRAS
            //VARIABLES GLOBALES
            $total=0;
            $totalViviendas=0;
            $totalContrato=0;
            $totalEstimaciones=0;
            $totalAcumulado=0;
            $totalPctjeAcumulado=0;
            $totalPdteEjecutar=0;
            $totalPctjePdteEjecutar=0;
            $totalRetencion=0;
            $totalPctjeRetencion=0;
            $totalOtros=0;
            $totalPctjeOtros=0;
            $fFinalBody=$fInicio2 + 1;
            $fInicioBody=$fInicio2 + 1;
            if(!is_numeric($paquetesExtra)){
                foreach ($paquetesExtra->result() as $row) {
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $prototipo=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $nEs=$this->mprototipos->getCampo("nombre",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $lotesManzanas=contarLotesManzanas($row->rango_lotes);
                    $manzanas=implode(", ",array_keys($lotesManzanas["arrayMzs"]));
                    $lotes = $lotesManzanas['lotes'];
                    $duracion=$this->mprototipos->getCampo("estimaciones",$this->mmanoobra->getCampo("idPrototipo",$row->idManoObra));
                    $estimP=$this->mordenpago->getEstimacionesByPaquete($row->id);
                    $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($row->idManoObra);
                    $contrato="$".number_format($totalUnitarioMO * $lotesManzanas["total"],2);
                    $pdteEjecutar=($totalUnitarioMO * $lotesManzanas["total"]) - $estimP->acumulado;
                    $PctjeAcumulado=($estimP->acumulado * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeEjecutar=($pdteEjecutar * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeRetencion=($estimP->retencion * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    $PctjeOtros=($estimP->otros * 100) / ($totalUnitarioMO * $lotesManzanas["total"]);
                    //TOTALES GLOBALES
                    $total++;
                    $totalViviendas+=$lotesManzanas["total"];
                    $totalContrato+=$totalUnitarioMO * $lotesManzanas["total"];
                    $totalEstimaciones+=$estimP->n;
                    $totalAcumulado+=$estimP->acumulado;
                    $totalPctjeAcumulado+=$PctjeAcumulado;
                    $totalPdteEjecutar+=$pdteEjecutar;
                    $totalPctjePdteEjecutar+=$PctjeEjecutar;
                    $totalRetencion+=$estimP->retencion;
                    $totalPctjeRetencion+=$PctjeRetencion;
                    $totalOtros+=$estimP->otros;
                    $totalPctjeOtros+=$PctjeOtros;

                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $lotesManzanas["total"]);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, $manzanas);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, $lotes);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, $prototipo);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, $row->id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, $row->fecha_inicio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, $row->fecha_fin);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, $duracion." SEM.");
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, $contrato);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $estimP->n);
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, "$".number_format($estimP->acumulado,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, round($PctjeAcumulado).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, "$".number_format($pdteEjecutar,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, round($PctjeEjecutar).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, "$".number_format($estimP->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, round($PctjeRetencion).'%');
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($estimP->otros,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, round($PctjeOtros).'%');
                    $fFinalBody++;
                }

                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }

            //FOOTER DE LA TABLA DE EXTRAS
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$fFinalBody, $totalViviendas);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$fFinalBody, '');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$fFinalBody, "$".number_format($totalContrato,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(7);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$fFinalBody, $totalEstimaciones);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$fFinalBody, "$".number_format($totalAcumulado,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$fFinalBody, ($total > 0)  ? round($totalPctjeAcumulado / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$fFinalBody, "$".number_format($totalPdteEjecutar,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('P'.$fFinalBody, ($total > 0)  ?  round($totalPctjePdteEjecutar / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$fFinalBody, ($total > 0)  ? round($totalPctjeRetencion / $total)."%" : '0%');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($totalOtros,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(5);
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$fFinalBody, ($total > 0)  ? round($totalPctjeOtros / $total)."%" : '0%');

            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);

            //ENCABEZADO DE LA TABLA ESTIMACIONES
            $fInicioHeader=7;
            $fInicio=8;
            $cInicio="V";
            $cFinal="Y";
            $objPHPExcel->getActiveSheet()->mergeCells('W'.$fInicioHeader.':Y'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicioHeader, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Neto');

            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);

            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=9;
            $fInicioBody=9;
            if(!is_numeric($paquetes)){
                foreach ($paquetes->result() as $row) {
                    $estim=$this->mordenpago->getResumenEstimacionesByPaquete($row->id);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);

                    $totalEstimacion+=$estim->estimacion;
                    $totalRetencion+=$estim->retencion;
                    $totalNeto+=$estim->estimacion - $estim->retencion;

                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($estim->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($estim->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($estim->estimacion - $estim->retencion,2));
                    $fFinalBody++;
                }

                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }

            //FOOTER DE LA TABLA DE ESTIMACIONES
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);

            //ENCABEZADO DE LA TABLA ESTIMACIONES EXTRA
            $fInicioHeader=$fFinalBody+4;
            $fInicio=$fInicioHeader+1;
            $cInicio="V";
            $cFinal="Y";
            $objPHPExcel->getActiveSheet()->mergeCells('W'.$fInicioHeader.':Y'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicioHeader, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Neto');

            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$fInicioHeader.":T".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);

            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES EXTRA-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=$fInicio+1;
            $fInicioBody=$fInicio+1;
            if(!is_numeric($paquetesExtra)){
                foreach ($paquetesExtra->result() as $row) {
                    $estim=$this->mordenpago->getResumenEstimacionesByPaquete($row->id);
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);

                    $totalEstimacion+=$estim->estimacion;
                    $totalRetencion+=$estim->retencion;
                    $totalNeto+=$estim->estimacion - $estim->retencion;

                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($estim->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($estim->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($estim->estimacion - $estim->retencion,2));
                    $fFinalBody++;
                }

                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }

            //FOOTER DE LA TABLA DE ESTIMACIONES EXTRA
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);


            //ENCABEZADO DE LA TABLA ESTIMACIONES TOTALES
            $fInicioHeader=$fFinalBody+4;
            $fInicio=$fInicioHeader+1;
            $cInicio="V";
            $cFinal="Y";
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fInicio, 'Retencion FG');
            $objPHPExcel->getActiveSheet()->mergeCells('W'.$fInicioHeader.':Y'.$fInicioHeader);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicioHeader, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fInicio, 'Contratista');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fInicio, 'Estimacion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fInicio, 'Retencion');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(9);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fInicio, 'Neto');

            //FONDO DE DE ENCABEZADOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDDDFF')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            //PINTANDO FONDO
            $objPHPExcel->getActiveSheet()->getStyle('S'.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('S'.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle('W'.$fInicioHeader.":Y".$fInicioHeader)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            //FONDO DE TITULOS
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicio.":".$cFinal.$fInicio)->getAlignment()->setWrapText(true);

            //ARMADO DEL CUERPO DE LA TABLA ESTIMACIONES TOTALES-------------------------------------
            //VARIABLES GLOBALES
            $total=0;
            $totalRetencionFG=0;
            $totalEstimacion=0;
            $totalRetencion=0;
            $totalNeto=0;
            $fFinalBody=$fInicio+1;
            $fInicioBody=$fInicio+1;
            $contratistas=$this->mordenpago->getResumenEstimacionesByContratista();
            if(!is_numeric($contratistas)){
                foreach ($contratistas->result() as $row) {
                    $contratista=$this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $row->idConstructor);
                    $retencionFG=$this->mpaquete->getCampo("porcentaje_retencion",$row->idPaquete);
                    $totalRetencionFG+=$row->estimacion * ($retencionFG / 100);
                    $totalEstimacion+=$row->estimacion;
                    $totalRetencion+=$row->retencion;
                    $totalNeto+=$row->estimacion - $row->retencion;

                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($row->estimacion * ($retencionFG / 100),2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, $contratista);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($row->estimacion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($row->retencion,2));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($row->estimacion - $row->retencion,2));
                    $fFinalBody++;
                }

                $styleArray = array(
                    'font' => array(
                        'size' => 9
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('rgb' => 'DDEBF7')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                    array(
                        'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioBody.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);
            }

            //FOOTER DE LA TABLA DE ESTIMACIONES TOTALES
            $fInicioFooter=$fFinalBody;
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$fFinalBody, "$".number_format($totalRetencionFG,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(15);
            $objPHPExcel->getActiveSheet()->SetCellValue('V'.$fFinalBody, 'Total');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('W'.$fFinalBody, "$".number_format($totalEstimacion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(11);
            $objPHPExcel->getActiveSheet()->SetCellValue('X'.$fFinalBody, "$".number_format($totalRetencion,2));
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(10);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$fFinalBody, "$".number_format($totalNeto,2));
            $styleArray = array(
                'font' => array(
                    'size' => 9
                ),
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('rgb' => 'DDEBF7')
                    )
                ),
                'fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'DDEBF7')
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle("S".$fInicioFooter)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle("S".$fInicioFooter)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($cInicio.$fInicioFooter.":".$cFinal.$fFinalBody)->getAlignment()->setWrapText(true);

            $name = 'RESUMEN';
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
            header('Cache-Control: max-age=0'); //no cache
            $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
            // Forzamos a la descarga
            $objWriter->save('php://output');
        }
    }

    public function exportarMateriales($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        if(!is_numeric($paquete)){
            $getInfo = $this->getInfoVer($paquete['id']);
            $material = $this->mmaterial->getByIdPaquete($paquete['id']);
            //
            $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
            $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
            $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
            $paqueteLotes = 0;
            /*$detallePaquete = $this->mdetallepaquete->getByIdPaquete($paquete['id']);
            if (!is_numeric($detallePaquete)) {
                $paqueteLotes = $detallePaquete->num_rows();
            }*/
            $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
            $lotes = $paqueteLotes['lotes'];
            $manzanas=implode(", ",array_keys($paqueteLotes["arrayMzs"]));
            $paqueteLotes = $paqueteLotes['total'];
            $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
            $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
            $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
            $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
            $totalViviendas = $paqueteLotes;
            $qTotalPresupuestoMO = $this->db->query("SELECT SUM(importe) as totalImporte FROM presupuesto_mo WHERE idManoObra = ".$manoObra['id']);
            $presupuestoUnit = ($qTotalPresupuestoMO->row()->totalImporte != '') ? $qTotalPresupuestoMO->row()->totalImporte : 0;
            $totalContrato = $presupuestoUnit * $paqueteLotes;
            $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
            $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
            $empty = true;
            $arrayPresupuestoMAT = array();
            $countArray = 0;

            if(!is_numeric($material)){
                $semanas = $this->db->query('SELECT p.semana AS id, p.semana AS titulo FROM material AS m INNER JOIN presupuesto_mat AS p ON m.id = p.idMaterial
                        INNER JOIN paquetes pa ON m.idPaquete = pa.id INNER JOIN mano_obra AS mo ON pa.idManoObra = mo.id WHERE pa.id = '. $idPaquete . '
                        GROUP BY p.semana ORDER BY p.semana ASC;');

                if($semanas->num_rows() > 0){
                    foreach($semanas->result() as $r){
                        $presupuestoMat = $this->mpresupuestomat->getByIdMaterial($material['id'], $r->id);
                        if(!is_numeric($presupuestoMat)){
                            $empty = false;
                            foreach($presupuestoMat->result() as $row){
                                $materialActividadPrototipo = $this->mmaterialesactividadprototipo->getById($row->idMateriales);
                                $materiales = $this->mmateriales->getById2($materialActividadPrototipo['idMaterial']);
                                $proveedores = $this->mproveedor->getById($row->idProveedor);

                                if(!array_key_exists($row->semana, $arrayPresupuestoMAT)){
                                    $arrayPresupuestoMAT[$row->semana][0] = array(
                                                                            'clave' => $materiales['clave'],
                                                                            'area' => $materiales['linea_art'],
                                                                            'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                                            'semana' => $row->semana,
                                                                            'descripcion' => $materiales['nombre'],
                                                                            'unidadMedida' => $materiales['unidad_compra'],
                                                                            'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                                            'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                                            'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                                            'precioNeto' => $row->precioUnitario,
                                                                            'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                                            'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                                                        );
                                }else{
                                    $array = array(
                                                'clave' => $materiales['clave'],
                                                'area' => $materiales['linea_art'],
                                                'proveedor' => (!is_numeric($proveedores)) ? $proveedores['nombre'] : '',
                                                'semana' => $row->semana,
                                                'descripcion' => $materiales['nombre'],
                                                'unidadMedida' => $materiales['unidad_compra'],
                                                'cantidadViv' => $materialActividadPrototipo['cantidad'],
                                                'cantidadTotal' => $materialActividadPrototipo['cantidad'] * $totalViviendas,
                                                'precioSinIva' => $row->precioUnitario - ($row->precioUnitario * 0.16),
                                                'precioNeto' => $row->precioUnitario,
                                                'totalPorViv' => $materialActividadPrototipo['cantidad'] * $row->precioUnitario,
                                                'total' => ($materialActividadPrototipo['cantidad'] * $totalViviendas) * $row->precioUnitario,
                                            );
                                    array_push($arrayPresupuestoMAT[$row->semana], $array);
                                }
                            }
                        }
                    }
                }
            }

            if(!$empty){
                if(count($arrayPresupuestoMAT) > 0){
                    $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                    $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MATERIALES PAQUETE');
                    $objPHPExcel->setActiveSheetIndex(0);

                    $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                    $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                    // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                    $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                    $objDrawing->setName('Logo Vviend');
                    $objDrawing->setDescription('Logo Viviend');
                    $objDrawing->setImageResource($gdImage);
                    $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                    $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                    $objDrawing->setOffsetX(150);
                    $objDrawing->setOffsetY(0);
                    $objDrawing->setWidth(900);
                    $objDrawing->setHeight(140);
                    $objDrawing->setCoordinates('A1');
                    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                    $objPHPExcel->getActiveSheet()->getStyle('B8:B12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('J9:J12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->SetCellValue('A8', 'PAQUETE:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B8', strtoupper($paquete["titulo"]));

                    $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                    //

                    $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                    $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    //

                    $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                    $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                    $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H9:I9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H9', 'ALMACEN:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J9', $paquete['titulo']);

                    $objPHPExcel->getActiveSheet()->mergeCells('H10:I10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H10', 'COSTO X M2:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J10', (!is_numeric($getInfo)) ? $getInfo['costoM2'] : '');

                    $objPHPExcel->getActiveSheet()->mergeCells('H11:I11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H11', 'M2 X VIVIENDA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J11', (!is_numeric($getInfo)) ? $getInfo['m2Viv'] : '');

                    $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'AREA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'PROVEEDOR');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'SEM');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'DESCRIPCION');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'U.M');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'CANTIDAD POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H13', 'TOTAL');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I13', 'PRECIO SIN IVA');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J13', 'PRECIO NETO');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K13', 'TOTAL POR VIV');
                    $objPHPExcel->getActiveSheet()->SetCellValue('L13', 'TOTAL');

                    $rowCount = 14;
                    $rowCountInicial = 14;
                    $rowCountFinal = 0;
                    $letraSemana = "N";
                    $arrayTotales = array(); 
                    $arrayTotal = array();
                    $totalSemana = 0; 
                    foreach($arrayPresupuestoMAT as $k=>$v){

                        //$objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'SEMANA '.$k);

                        //$objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                        $rowInicial = $rowCount;

                        foreach($arrayPresupuestoMAT[$k] as $row){
                            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $row['clave']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $row['area']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $row['proveedor']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $row['semana']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $row['descripcion']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $row['unidadMedida']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $row['cantidadViv']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $row['cantidadTotal']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, precio_format($row['precioSinIva']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, precio_format($row['precioNeto']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, precio_format($row['totalPorViv']));
                            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, precio_format($row['total']));

                            //$objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowCount, precio_format($row['total']));

                            $totalSemana = $totalSemana + $row['total'];

                            $arrayTotal[$rowCount] = array('total' => $row['total']);
                            //$arrayTotales[$k] = array('letra' => $letraSemana, 'rowInicial' => $rowInicial, 'rowFinal' => $rowCount, 'total' => $totalSemana);

                            $rowCount++;
                        }

                        $letraSemana++;
                    }

                    //$objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.'13', 'TOTAL');
                    //$objPHPExcel->getActiveSheet()->getColumnDimension($letraSemana)->setWidth(15);

                    $rowC = 0;
                    $totalC = 0;
                    /*foreach($arrayTotal as $k=>$v){
                        $rowC = $k;
                        $tot = $v['total'];
                        $totalC = $totalC + $tot;
                        $objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$k, precio_format($tot));

                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letraSemana.$k.':'.$letraSemana.$k
                        )->applyFromArray($styleArray);
                    }*/

                    $rowC++;

                    /*$objPHPExcel->getActiveSheet()->SetCellValue($letraSemana.$rowC, precio_format($totalC));

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        $letraSemana.'13:'.$letraSemana.$rowC
                    )->applyFromArray($styleArray);*/

                    //

                    $rowCount = $rowCount - 1;

                    $rowCountFinal = $rowCount;

                    /*foreach($arrayPresupuestoMAT as $key=>$val){
                        $rInicio = $rowCountInicial;
                        $rFinal = $rowCountFinal;
                        $letra = $arrayTotales[$key]['letra'];
                        $inicio = $arrayTotales[$key]['rowInicial'];
                        $final = $arrayTotales[$key]['rowFinal'];
                        $total = $arrayTotales[$key]['total'];

                        for ($rInicio; $rInicio <= $rFinal; $rInicio++) { 
                            if($rInicio >= $inicio && $rInicio <= $final){

                            }else{
                                $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format(0));
                            }

                        }

                        
                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, precio_format($total));

                        $rInicio++;

                        $objPHPExcel->getActiveSheet()->SetCellValue($letra.$rInicio, $total / $totalC);

                        $objPHPExcel->getActiveSheet()->getStyle($letra.$rInicio)
                            ->getNumberFormat()->applyFromArray( 
                            array( 
                                'code' => PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_PERCENTAGE_00
                            )
                        );
                        
                        $styleArray = array(
                            'borders' => array(
                                'allBorders' => array(
                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                )
                            )
                        );

                        $objPHPExcel->getActiveSheet()->getStyle(
                            $letra.'13:'.$letra.$rInicio
                        )->applyFromArray($styleArray);
                    }*/

                    //

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        'A13:L' . $rowCount
                    )->applyFromArray($styleArray);
                    

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);

                    //$name = $paquete["id"].".".$paquete["titulo"];
                    $name =  'Ppto. Materiales'.' - '.$paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
            }
        }
    }

    public function getInfoVer($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);

        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
        
        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        if (!is_numeric($paquete) && !is_numeric($prototipo) && !is_numeric($material)) {
            $presupuestoViv = $this->mpresupuestomat->getSumTotalImporte($material['id']);
            $lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
            $presupuestoPaq = $presupuestoViv * $lotes;
            $costoM2 = $presupuestoViv / $superficieM2;
            $response = array('prototipo' => $prototipo['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
                'presupuestoViv' => precio_format($presupuestoViv),
                'presupuestoPaq' => precio_format($presupuestoPaq),
                'costoM2' => precio_format($costoM2),
                'm2Viv' => $prototipo['superficieM2']
            );
        } else {
            $response = 0;
        }
        return $response;
    }

    public function programaObra($id=0){
        $qPaquete = $this->mpaquete->getById($id);
        $idPaquete = ($qPaquete['id'] != '') ? $qPaquete['id'] : 0;
        $qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$idPaquete',idPaquetes)");
        if($qArranque->num_rows() > 0){
            if($qArranque->row()->estatus_arranque == 2 || $qArranque->row()->estatus_arranque == 3){
                redirect($this->router->class);
            }
        }
        $data["msg"]="";
        $data['manoObra'] = $this->mmanoobra->getById($qPaquete['idManoObra']);
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo2('titulo', $data['manoObra']['idFraccionamiento']);
        $data['prototipo'] = $this->mprototipos->getCampo2('nombre', $data['manoObra']['idPrototipo']);
        $data['impTotal'] = $this->mpresupuestomo->getSumTotalUnitario($qPaquete['idManoObra']);
        $data['categorias'] = $this->mcategoriamo->getSelectResult();
        $data['lotesMza'] = $this->mdetallepaquete->getProyectosByPaquete($idPaquete);
        $data['paquete'] = $qPaquete;
        $this->data['contenido'] = $this->load->view($this->mainView.'/programa_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function updateSemana2(){
        $sessionId = (isset($_SESSION[$this->nsession]['id']) && (!empty($_SESSION[$this->nsession] ['id'])) ? $_SESSION[$this->nsession]['id'] : 0);
        $idPresupuesto = $this->input->post('idPresupuesto');
        $lote = $this->input->post('lote');
        $manzana = $this->input->post('manzana');
        $idManoObra = $this->input->post('idManoObra');
        $semana = $this->input->post('semana');

        $response['status'] = 0;

        $qPrograma = $this->db->query("SELECT * FROM programa_obra WHERE idPresupuesto = $idPresupuesto AND lote = $lote AND manzana = $manzana");
        if($qPrograma->num_rows() > 0){
            $uData['idPresupuesto'] = $idPresupuesto;
            $uData['lote'] = $lote;
            $uData['manzana'] = $manzana;
            $uData['semana'] = $semana;
            $uData['status'] = 1;
            $uData['updated'] = date("Y-m-d H:i:s");
            $uData['updated_by'] = $sessionId;


            $this->db->where('id', $qPrograma->row()->id);
            $this->db->update('programa_obra', $uData);
            $response['status'] = 1;
        }else{
            $pData['idPresupuesto'] = $idPresupuesto;
            $pData['lote'] = $lote;
            $pData['manzana'] = $manzana;
            $pData['semana'] = $semana;
            $pData['status'] = 1;
            $pData['created'] = date("Y-m-d H:i:s");
            $pData['updated'] = date("Y-m-d H:i:s");
            $pData['created_by'] = $sessionId;
            $pData['updated_by'] = $sessionId;

            $this->db->set($pData);
            $this->db->insert('programa_obra');
            $response['status'] = 1;
        }

        echo json_encode($response);
    }
}