<?php  
	defined('BASEPATH') OR exit('No direct script access allowed');
	
	class Notificacion_blackboard extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;
		
		public function __construct(){
			$this->nsession = $this->config->item('nsession');
			$this->fv = 'notificaciones'; // form validation variable
			$this->mainView = 'notificaciones';
			$this->data['fjs'] = '';
			$this->data['js'] = '';
			$this->data['css'] = '';
			
			// Tools
			$this->load->helper(array('tools','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mblackboard'));
		}
		
		public function index(){
			$blackboard = $this->mblackboard->getAllByCronJob();
			$count=0;
			if (!is_numeric($blackboard)){
				foreach($blackboard->result() as $row){
					$dateBlackboard = new DateTime($row->fechaTermino);
					$dateRequired = addDaysToDate($dateBlackboard->format("d-m-Y"),1);
					$dateNow = new DateTime();
					
					if( $dateRequired == $dateNow->format("d/m/Y") ) {
						$count+=1;
						//AQUI AGREGAR EL ENVIO DEL CORREO
						if ( $row->statusAlert == 0 ) { $autores = $this->autoRespuesta($row->id); }
						// $this->db->query("UPDATE blackboard SET statusAlert = 1 WHERE id=".$row->id);
						//$autores = $this->autoRespuesta($row->id);
					}
				}
			}
			return $count;
		}
		
		public function reportDay() {
			$blackboard=$this->mblackboard->getAllByCronJob();
			$count=0;
			foreach($blackboard->result() as $row){
				$dateBlackboard = new DateTime($row->fechaTermino);
				$dateRequired = addDaysToDate($dateBlackboard->format("d-m-Y"),5);
				$dateRequired2 = addDaysToDate($dateBlackboard->format("d-m-Y"),10);
				$dateRequired3 = addDaysToDate($dateBlackboard->format("d-m-Y"),15);
				$dateNow = new DateTime();
				
				if ( $dateRequired == $dateNow->format("d/m/Y") ) {
					$count+=1;
					$autores = $this->autoRespuesta2($row->id, 5);
				}
				if ( $dateRequired2 == $dateNow->format("d/m/Y") ) {
					$count+=1;
					$autores = $this->autoRespuesta2($row->id, 10);
				}
				if ( $dateRequired3 == $dateNow->format("d/m/Y") ) {
					$count+=1;
					$autores = $this->autoRespuesta2($row->id, 15);
				}
			}
			return $count;
		}
		
		public function reportToday()
		{
			$blackboard = $this->mblackboard->getAllByCronJob();
			$count=0;
			if (!is_numeric($blackboard)){
				foreach($blackboard->result() as $row){
					$dateBlackboard = new DateTime($row->fechaTermino);
					$dateRequired = $dateBlackboard->format("d/m/Y");
					$dateNow = new DateTime();
					
					if( $dateRequired == $dateNow->format("d/m/Y") ) {
						$count+=1;
						//AQUI AGREGAR EL ENVIO DEL CORREO
						if ( $row->statusAlert == 0 ) { $autores = $this->autoRespuestaToday($row->id); }
						// $this->db->query("UPDATE blackboard SET statusAlert = 1 WHERE id=".$row->id);
					}
				}
			}
			return $count;
		}
		
		
		function autoRespuesta( $idBlackboard = null ) {
			// $copias = "ruben@navegantes.mx";
			/*$copiasNV = 'sistemas@viviend.mx, ';
			$copiasNV .= 'jesus@navegantes.mx';*/
			
			$copiasNV = 'hsalinas@viviend.mx'. ', ';
			$copiasNV .= 'esalinas@viviend.mx';
			
			$blackboard = $this->mblackboard->getById($idBlackboard);
			
			$subject = 'Alerta De Vencimiento  |  Blackboard'; // Viviend - 
			
			$liga="http://viviend.mx/sistema/emailresources/";
			$liga2="http://viviend.mx/sistema/img/";
			$liga3="http://viviend.mx/sistema/";
			$tp = '';
			
			$data = array();
			
			
			$cuerpo = '<table id="table-notificacion-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
							<tbody>
								<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Asunto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['asunto'].' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Proyecto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['proyecto'].' </td>
	                            </tr>
	        					<!--<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre Delegado: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['delegado'].' </td>
	                            </tr>-->
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de inicio: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de termino: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').' </td>
	                            </tr>
							</tbody>
						</table>
						<!--<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
							Asunto: '.$blackboard['asunto'].'
						</span><br>
						<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
							Proyecto: '.$blackboard['proyecto'].'
						</span><br>
						<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
							Nombre Delegado: '.$blackboard['delegado'].'
						</span><br>
						<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
							Fecha de inicio: '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').'
						</span><br>
						<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
							Fecha de termino: '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').'
						</span><br>-->';
			
			
			$mensaje = '
			<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
			<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>Email</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
				<link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
				<style>
					body, tr, td, span, div, p, a, li {
						-moz-text-size-adjust:none !important;
						-webkit-text-size-adjust:none !important;
						margin:0px !important;
						-ms-text-size-adjust:none !important;
						white-space: wrap;
					}
					.lato-light{
						font-family: "lato" sans-serif !important;
						font-weight: 300;
					}
					.lato-bold{
						font-family: "lato" sans-serif !important;
						font-weight: 700;
					}
					td img {
						display: block;
					}
					.ReadMsgBody {
						width: 100%;
					}
					.ExternalClass * {
						line-height: 100%;
					}
					@media only screen and (max-width:480px) {
						#logosim {
							padding:0!important;
						}
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 320px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
					@media only screen and (min-width:480px) and (max-width:599px) {
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 480px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
				</style>
			</head>
			<body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
				<table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
					<tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
					<tr>
						<td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
							<tr>
								<td>
									<a href="'.$liga3.'" target="_blank">
										<table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
											<tr>
												<td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
													<img src="'.$liga2.'logo-300.png" />
												</td>
											</tr>
										</table>
									</a>
								</td>
							</tr>
							<tr>
								<td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
									<table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
										<tr>
											<td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
												<!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Fecha de termino excedido </h1>-->
												<h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento de pendiente </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$blackboard['delegado'].' </h4>
												<br><br>
												'.$cuerpo.'
											</td>
										</tr>
									</table>
									<div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
								</td>
							</tr>
						</td>
					</tr>
				</table>
			</body>
			</html>';
			
			// para el gerente de ventas -------------------------------------------------
			// Para enviar un correo HTML, debe establecerse la cabecera Content-type
			$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
			$cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
			        
			// $para = "sistemas@viviend.mx";
			$para = $blackboard['mail'];
			
			// Cabeceras adicionales
			$cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
			if ($para != null) {
				mail($para, $subject, $mensaje, $cabeceras);
			}
			
	        $subject2 = $subject;
	        
	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
	        
	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        
	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

			return true;
		}
		
		function autoRespuesta2( $idBlackboard = null, $days = null ) {
			// $copias = "ruben@navegantes.mx";
			/*$copiasNV = 'sistemas@viviend.mx, ';
			$copiasNV .= 'jesus@navegantes.mx';*/
			
			$copiasNV = 'hsalinas@viviend.mx'. ', ';
			$copiasNV .= 'esalinas@viviend.mx';
			
			$blackboard = $this->mblackboard->getById($idBlackboard);
			
			$subject = 'Alerta De Vencimiento Excedido  |  Blackboard';
			
			$liga="http://viviend.mx/sistema/emailresources/";
			$liga2="http://viviend.mx/sistema/img/";
			$liga3="http://viviend.mx/sistema/";
			$tp = '';
			
			$data = array();
			
			
			$cuerpo = '<table id="table-notificacion-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
							<tbody>
								<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Asunto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['asunto'].' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Proyecto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['proyecto'].' </td>
	                            </tr>
	        					<!--<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre Delegado: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['delegado'].' </td>
	                            </tr>-->
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de inicio: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de termino: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').' </td>
	                            </tr>
							</tbody>
						</table>';
			
			
			$mensaje = '
			<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
			<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>Email</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
				<link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
				<style>
					body, tr, td, span, div, p, a, li {
						-moz-text-size-adjust:none !important;
						-webkit-text-size-adjust:none !important;
						margin:0px !important;
						-ms-text-size-adjust:none !important;
						white-space: wrap;
					}
					.lato-light{
						font-family: "lato" sans-serif !important;
						font-weight: 300;
					}
					.lato-bold{
						font-family: "lato" sans-serif !important;
						font-weight: 700;
					}
					td img {
						display: block;
					}
					.ReadMsgBody {
						width: 100%;
					}
					.ExternalClass * {
						line-height: 100%;
					}
					@media only screen and (max-width:480px) {
						#logosim {
							padding:0!important;
						}
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 320px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
					@media only screen and (min-width:480px) and (max-width:599px) {
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 480px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
				</style>
			</head>
			<body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
				<table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
					<tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
					<tr>
						<td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
							<tr>
								<td>
									<a href="'.$liga3.'" target="_blank">
										<table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
											<tr>
												<td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
													<img src="'.$liga2.'logo-300.png" />
												</td>
											</tr>
										</table>
									</a>
								</td>
							</tr>
							<tr>
								<td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
									<table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
										<tr>
											<td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
												<!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Fecha de termino excedido </h1>-->
												<h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Vencimiento de pendiente excedido </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$days.' </h4>
												<br><br>
												'.$cuerpo.'
											</td>
										</tr>
									</table>
									<div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
								</td>
							</tr>
						</td>
					</tr>
				</table>
			</body>
			</html>';
			
			// para el gerente de ventas -------------------------------------------------
			// Para enviar un correo HTML, debe establecerse la cabecera Content-type
			$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
			$cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
			        
			// $para = "sistemas@viviend.mx";
			$para = $blackboard['mail'];
			
			// Cabeceras adicionales
			$cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
			if ($para != null) {
				mail($para, $subject, $mensaje, $cabeceras);
			}
			
	        $subject2 = $subject;
	        
	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
	        
	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        
	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

			return true;
		}
		
		function autoRespuestaToday( $idBlackboard = null ) {
			/*$copiasNV = 'sistemas@viviend.mx'. ', ';
			$copiasNV .= 'ruben@navegantes.mx';*/
			
			$copiasNV = 'hsalinas@viviend.mx'. ', ';
			$copiasNV .= 'esalinas@viviend.mx';
			
			$blackboard = $this->mblackboard->getById($idBlackboard);
			
			$subject = 'Alerta De Vencimiento  |  Blackboard'; // Viviend - 
			
			$liga="http://viviend.mx/sistema/emailresources/";
			$liga2="http://viviend.mx/sistema/img/";
			$liga3="http://viviend.mx/sistema/";
			$tp = '';
			
			$data = array();
			
			
			$cuerpo = '<table id="table-notificacion-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
							<tbody>
								<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Asunto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['asunto'].' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Proyecto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['proyecto'].' </td>
	                            </tr>
	        					<!--<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre Delegado: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['delegado'].' </td>
	                            </tr>-->
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de inicio: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de termino: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').' </td>
	                            </tr>
							</tbody>
						</table>';
			
			
			$mensaje = '
			<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
			<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>Email</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
				<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
				<link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
				<style>
					body, tr, td, span, div, p, a, li {
						-moz-text-size-adjust:none !important;
						-webkit-text-size-adjust:none !important;
						margin:0px !important;
						-ms-text-size-adjust:none !important;
						white-space: wrap;
					}
					.lato-light{
						font-family: "lato" sans-serif !important;
						font-weight: 300;
					}
					.lato-bold{
						font-family: "lato" sans-serif !important;
						font-weight: 700;
					}
					td img {
						display: block;
					}
					.ReadMsgBody {
						width: 100%;
					}
					.ExternalClass * {
						line-height: 100%;
					}
					@media only screen and (max-width:480px) {
						#logosim {
							padding:0!important;
						}
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 320px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
					@media only screen and (min-width:480px) and (max-width:599px) {
						*[class="code4email_wrapper"] {
							width: 100% !important;
						}
						*[class="code4email_main_table"] {
							width: 480px !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_hide"] {
							display: none !important;
						}
						*[class="code4email_center"] {
							text-align: center !important;
							padding:10px !important;
							height:20px !important;
						}
						*[class="code4email_clear"] {
							width: 100% !important;
							clear: both !important;
							float: left !important;
						}
						*[class="code4email_br"] {
							display:block !important;
							width: 1px !important;
							height:6px !important;
							clear: both !important;
						}
						*[class="code4email_text_p10"] {
							padding: 0px 10px 10px 10px !important;
							height:20px !important;
						}
						*[class="code4email_w20"] {
							width: 20px !important;
						}
						*[class="code4email_h20"] {
							height: 20px !important;
						}
						*[class="code4email_h20_center"] {
							height: 20px !important;
							text-align: center !important;
						}
					}
				</style>
			</head>
			<body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
				<table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
					<tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
					<tr>
						<td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
							<tr>
								<td>
									<a href="'.$liga3.'" target="_blank">
										<table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
											<tr>
												<td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
													<img src="'.$liga2.'logo-300.png" />
												</td>
											</tr>
										</table>
									</a>
								</td>
							</tr>
							<tr>
								<td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
									<table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
										<tr>
											<td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
												<h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Día de vencimiento de pendiente </h3>
	                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$blackboard['delegado'].' </h4>-->
												<br><br>
												'.$cuerpo.'
											</td>
										</tr>
									</table>
									<div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
								</td>
							</tr>
						</td>
					</tr>
				</table>
			</body>
			</html>';
			
			// para el gerente de ventas -------------------------------------------------
			// Para enviar un correo HTML, debe establecerse la cabecera Content-type
			$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
			$cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
			        
			// $para = "sistemas@viviend.mx";
			$para = $blackboard['mail'];
			
			// Cabeceras adicionales
			$cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
			if ($para != null) {
				mail($para, $subject, $mensaje, $cabeceras);
			}
			
	        $subject2 = $subject;
	        
	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
	        
	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        
	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

			return true;
		}
	}
?>