<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Materiales extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
        $this->fv = 'materiales'; // form validation variable
        $this->mainView = 'materiales';
        $this->data['fjs'] = '';
        $this->data['js'] = ' <script src="assets/js/materiales/listado.js" type="text/javascript"></script>';
        $this->data['css'] = '';
        // Tools
        $this->load->helper(array('tools','numeros','url','form','date','text','security'));
        // Modelos
        $this->load->model(array('mmateriales','musuario','munidades','mproveedor','mareamaterial','mempresas', 'mlogsws'));
        $this->load->library("curl");
        valSession("materiales",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $logsWs = $this->mlogsws->getByIdEmpresaTabla($idEmpresa, 'materiales');
        $msgLogs = '';
        $showNotification = 0;
        if(!is_numeric($logsWs)){
            if($logsWs['status'] == 0){
                $user = $this->musuario->getById($logsWs['created_by']);
                $nombre = (!is_numeric($user)) ? $user['nombre'] : '';
                $apellidoP = (!is_numeric($user)) ? $user['apellidoP'] : '';
                $msgLogs = 'Sincronización Realizada Por: '.$nombre.' '.$apellidoP.'<br><br><br>';
                $msgLogs .= 'Registros Insertados: '.$logsWs['insertados'].'<br><br>';
                $msgLogs .= 'Registros Actualizados: '.$logsWs['actualizados'].'<br><br>';
                $msgLogs .= 'Total Registros: '.$logsWs['totalRegistros'].'<br><br>';
                $showNotification = 1;
                $pData['status'] = 1;
                $this->mlogsws->actualizar($pData, $logsWs['id']);
            }
        }
        $data['msgLogs'] = $msgLogs;
        $data['showNotification'] = $showNotification;
        // $data['seccion'] = $this->uri->segment(1);
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }


    public function excel(){
       $q = $this->mmateriales->getAllExcelRows();
       $columnas = array(
                    0 => 'CLAVE',
                    1 => 'NOMBRE',
                    2 => 'LINEA DE ARTICULO',
                    3 => 'UNIDAD DE VENTA',
                    4 => 'UNIDAD DE COMPRA',
        );
       crearExcel($q,'materiales',$columnas);
    }

    public function listado(){
        $list = $this->mmateriales->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $materiales) {
            $no++;
            $row = array();
            //$row[] = $no;
            $row[] = $materiales->clave;
            $row[] = $materiales->nombre;
            $row[] = $materiales->linea_art;
            $row[] = $materiales->unidad_venta;
            $row[] = $materiales->unidad_compra;

            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mmateriales->count_all(),
                        "recordsFiltered" => $this->mmateriales->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }
/*    public function listado(){
        $q = $this->mmateriales->getAll();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'clave' => $row->clave,
                    'nombre' => $row->nombre,
                    'linea_art' => $row->linea_art,
                    'unidad_venta' => $row->unidad_venta,
                    'unidad_compra' => $row->unidad_compra,
                    'acciones' => acciones($row->id,$this->router->class,false, true, true)
                );
            }
        } else{
            $array['aaData'][] = array(
                'clave' => 'No hay registros',
                'nombre' => 'No hay registros',
                'linea_art' => 'No hay registros',
                'unidad_venta' => 'No hay registros',
                'unidad_compra' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }*/

    public function nuevo()
    {
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data['unidad']= $this->munidades->getSelectResult();
            $data['proveedor']= $this->mproveedor->getSelectResult();
            $data['area']= $this->mareamaterial->getSelectResult();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['clave'] = $this->input->post('clave', TRUE);
            $pData['material'] = $this->input->post('material', TRUE);
            $pData['idUnidad'] = $this->input->post('idUnidad', TRUE);
            $pData['idArea'] = $this->input->post('idArea', TRUE);
            $pData['idProveedor'] = $this->input->post('idProveedor', TRUE);
            $pData['precioUnitario'] = $this->input->post('precioUnitario', TRUE);
            $pData['status'] = 1;
            $id = $this->mmateriales->insertar($pData);
            redirect($this->router->class);
        }
    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');
        if (isset($_POST['clave'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['clave'] = $this->input->post('clave', TRUE);
                $pData['material'] = $this->input->post('material', TRUE);
                $pData['idUnidad'] = $this->input->post('idUnidad', TRUE);
                $pData['idArea'] = $this->input->post('idArea', TRUE);
                $pData['idProveedor'] = $this->input->post('idProveedor', TRUE);
                $pData['precioUnitario'] = $this->input->post('precioUnitario', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);
                $this->mmateriales->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mmateriales->getById($id);
        $data = $info;
        $data['msg']=$msg;
        $data['unidad']= $this->munidades->getSelectResult();
        $data['proveedor']= $this->mproveedor->getSelectResult();
        $data['area']= $this->mareamaterial->getSelectResult();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function ver($id = null){
        $info = $this->mmateriales->getById($id);
        $data = $info;
        $proveedor = '';
        if( is_numeric($info['idProveedor']) ){
            $proveedor = $this->mproveedores->getCampo('nombre', $info['idProveedor']);
        }
        $data['idProveedor'] = $proveedor;
        $data['precioUnitario'] = (is_numeric($info['precioUnitario']))? precio_format($info['precioUnitario']) : precio_format(0.00);
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mmateriales->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mmateriales->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function updateWS(){
        ini_set('max_execution_time', 0);
        $curl = curl_init();
        //INFORMACION A ENVIAR POR POST EN FORMATO JSON
        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
        $idUsuario = $_SESSION["viv"]['id'];
        $datos = json_encode(array("un" => $idEmpresa));
        $time_start = microtime(true);

        curl_setopt_array($curl, array(
            CURLOPT_PORT => $this->config->item('portmicro'),
            CURLOPT_URL => $this->config->item('dnsmicro')."GetArticulos",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 3600,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => 1,
            CURLOPT_POSTFIELDS => $datos,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: ab5bf890-47c6-d504-ba8f-82667b58bebd",
                'Content-Type:application/json'
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);

        $json = [];
        if ($err) {
            echo "CURL Error #:" . $err;
            $time_end = microtime(true);
            $time = $time_end - $time_start;
            $dataL['time'] = $time;
            $dataL['idEmpresa'] = $idEmpresa;
            $dataL['nombreTabla'] = 'materiales';
            $dataL['funcion'] = 'GetArticulos';
            $dataL['http_code'] = 0;
            $dataL['insertados'] = 0;
            $dataL['actualizados'] = 0;
            $dataL['totalRegistros'] = 0;
            $dataL['json'] = "CURL Error #:" . $err;
            $dataL['created'] = date("Y-m-d H:i:s");
            $dataL['updated'] = date("Y-m-d H:i:s");
            $dataL['created_by'] = $idUsuario;
            $dataL['updated_by'] = $idUsuario;
            $this->db->insert('logs_ws', $dataL);
        }else{
            $json = $response;
            // Comprueba el código de estado HTTP
            if (!curl_errno($curl)) {
                switch ($http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE)) {
                    case 200:
                        //Contadores de prueba
                        $nInsert=0;
                        $nUpdate=0;
                        $nTotal=0;
                        //Objeto de respuesta
                        $json = json_decode($json);
                        //Recorre objeto stdClass
                        foreach($json->object_result as $row){
                            foreach ($row as $key => $val){
                                switch ($key) {
                                    default:
                                        $data[$key]=str_replace("'","",$val);
                                }
                            }       
                            //Validaciones de sincronizacion de materiales
                            $data["idEmpresa"]=$idEmpresa;
                            if($this->mmateriales->valInsert($data['id'],$idEmpresa)){
                                $this->mmateriales->insertar($data);
                                $nInsert++;
                            }else if($this->mmateriales->valUpdate($data['id'],$data)){
                                echo $data['id']."<br>";
                                $this->mmateriales->actualizar($data,$data['id']);
                                $nUpdate++;
                            }
                            $nTotal++;
                        }
                        echo "Insertados: ".$nInsert." <br> ";
                        echo "Actualizados: ".$nUpdate." <br> ";
                        echo "Total de registros: ".$nTotal." <br> ";
                        curl_close($curl);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = $nInsert;
                        $dataL['actualizados'] = $nUpdate;
                        $dataL['totalRegistros'] = $nTotal;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        redirect($this->mainView);
                        break;
                    case 404:
                        echo "Not found";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                    default:
                        echo 'Unexpected HTTP code: ', $http_code, "\n";
                        $json = json_decode($json);
                        unset($json->object_result);
                        $json = json_encode($json);
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        $dataL['time'] = $time;
                        $dataL['idEmpresa'] = $idEmpresa;
                        $dataL['nombreTabla'] = 'materiales';
                        $dataL['funcion'] = 'GetArticulos';
                        $dataL['http_code'] = $http_code;
                        $dataL['insertados'] = 0;
                        $dataL['actualizados'] = 0;
                        $dataL['totalRegistros'] = 0;
                        $dataL['json'] = $json;
                        $dataL['created'] = date("Y-m-d H:i:s");
                        $dataL['updated'] = date("Y-m-d H:i:s");
                        $dataL['created_by'] = $idUsuario;
                        $dataL['updated_by'] = $idUsuario;
                        $this->db->insert('logs_ws', $dataL);
                        break;
                }
            }
        }
    }
}