<?php // Promotor
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');
	class Gestoria extends MX_Controller {
		public $data,$vParameters,$mainView,$fv,$appProduction,$idFraccionamiento;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'gestoria'; // form validation variable
			$this->mainView = 'gestoria';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/gestoria/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mtitulacion2','maltaventa','mprospecto','mfraccionamiento','mfraccionamientoxusuario','musuario','mprototipoxfraccionamiento',
			'mgestoria','mcomisionbono','mnotaria','mproyecto','mprototipos','mavaluoproyecto','mareastatus','mdiferenciapromotor', 'mmovimientospromotor','mlineascredito'));//maltaventa tiene los datos para gestoria, mgestoria se usa para obtener la funcion getNext id al guardar archivos
			$this->appProduction = $this->config->item('appProduction');
			// Lbrerias
			//$this->load->library(array('pdfmerger'));
			$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/gestoria/';

			// Debugging
			$this->output->enable_profiler(false);

           //Validación de usuarios
			valSession("ventas",$this->fv);
		}

		public function setLogo()
	    {
	        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
	        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
	        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
	    }

	    
	    public function mergePdf($idAv=0,$idG=0,$tipo="download"){ //se unen archivos pdf expedientes

	        $path = $this->config->item('base_www');
	        $path = $path."/expedientes/";
			$crear = false;

	        /*if (!file_exists($path)) {
	            mkdir($path, 0777, true);
	        }*/

	        //exit();

	        $this->load->library('pdfmerger');

	        $idCliente = $this->maltaventa->getCampo('idProspecto',$idAv);

	        $nombreExpediente = url_title(($idCliente>0)?$idAv."-".$this->mprospecto->getCampo('nombre',$idCliente).$this->mprospecto->getCampo('apellidoP',$idCliente):$idAv);

	        $nombreExpediente = $nombreExpediente.".pdf";
	        //echo $nombreExpediente;exit();

	        $pdf_1 = $this->maltaventa->getCampo("pdf_1",$idAv);

	        $pdf_9 = $this->mgestoria->getCampo("pdf_9",$idG);

	        $pdf_15 = $this->mgestoria->getCampo("pdf_15",$idG);

	        $ruta_fichero = 'uploads/alta_venta/';//ruta fisica del archivo

	        if ($pdf_1!='' && file_exists($ruta_fichero.$pdf_1)){
				$crear = true;
	            $this->pdfmerger->addPDF('uploads/alta_venta/'.$pdf_1);
	        }

	        if ($pdf_9!='' && file_exists($ruta_fichero."gestoria/".$pdf_9)){
				$crear = true;
	            $this->pdfmerger->addPDF('uploads/alta_venta/gestoria/'.$pdf_9);
	        }

	        if ($pdf_15!='' && file_exists($ruta_fichero."gestoria/".$pdf_15)){
				$crear = true;
	            $this->pdfmerger->addPDF('uploads/alta_venta/gestoria/'.$pdf_15);
	        }        

	        //$this->pdfmerger->addPDF('pdf-sample.pdf');

	        if($tipo=='download'){
				if($crear){
	            	$this->pdfmerger->merge('download',$nombreExpediente);
				}
	        }elseif($tipo=='zip'){
				if($crear){
	            	$this->pdfmerger->merge('file', $path.$nombreExpediente);
					//chown($path.$nombreExpediente, 'angel');
					//chgrp($path.$nombreExpediente, 'angel');
					//chmod($path.$nombreExpediente, 0777);
				}
	        }        

			if(!$crear){
				redirect($this->router->class);
			}
	        //$this->zip();
	    }

	    public function zip(){ // se genera zip de un folder especifico

	        /*$this->load->library('zip');
			
			$path = 'expedientes';

	        $this->zip->read_dir($path);

	        $this->zip->download('expedientes-'.date('d-m-Y').'.zip');*/

			$path = $this->config->item('base_www');

	        $path = $path."/expedientes/";
			
			$nombreArchivoZip = $path."expedientes-".date('d-m-Y').".zip";

			$rootPath = realpath($path);

			$zip = new ZipArchive();

			$zip->open($nombreArchivoZip, ZipArchive::CREATE | ZipArchive::OVERWRITE);

			$files = new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($rootPath),
				RecursiveIteratorIterator::LEAVES_ONLY
			);

			foreach ($files as $name => $file)
			{
				if (!$file->isDir())
				{
					$filePath = $file->getRealPath();
					$relativePath = substr($filePath, strlen($rootPath) + 1);

					$zip->addFile($filePath, $relativePath);
				}
			}

			$resultado = $zip->close();

			if($resultado){

				header("Content-type: application/octet-stream");
				header("Content-disposition: attachment; filename=expedientes-".date('d-m-Y').".zip");
	
				readfile($nombreArchivoZip);
	
				unlink($nombreArchivoZip);
			}
	    }

		public function index($id=0) {
			$data['q'] = '';
			$data['rondaV'] = null;
			$data['msgExp'] = "";
			if($id==1){
	            $this->load->dbutil();
	            $this->load->helper('download');
	            $query = $this->maltaventa->csvCufrisa();
	            if (!is_numeric($query)){
	                $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
	                $date=new DateTime();
	                $name = "Formato-sofom-".$date->format("d-m-Y").".csv";
	                force_download($name, $csv);
	            }else{
	                //redirect('proyectos');
	                $data['msgInvalid'] = "No existen registros para exportar";
	            }

        	}
        	if($id==2){
	            $this->load->dbutil();
	            $this->load->helper('download');
	            $query = $this->maltaventa->getPendientesTitulacionCSV();
	            if (!is_numeric($query)){
	                $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
	                $date=new DateTime();
	                $name = "pendientes-titulacion-".$date->format("d-m-Y").".csv";
	                force_download($name, $csv);
	            }else{
	                //redirect('proyectos');
	                $data['msgInvalid'] = "No existen registros para exportar";
	                exit();
	            }

        	}
        	if($id==3){//indica que se generara el zip de expedientes

        		$path=$this->config->item('base_www');

        		$path = $path."/expedientes/";
				   
				$files = glob($path.'/*');  
				   
				foreach($files as $file) { // antes de generar el zip de expedientes eliminamos los archivos dentro de la carpeta
				   
				    if(is_file($file))  
				    
				        unlink($file);  
				} 

        		$ronda = $this->input->post('ronda', TRUE);

        		$data['rondaV'] = $ronda;

        		$query = $this->mgestoria->getByRonda($ronda);
        		/*echo "<pre>";
        		print_r($query->result());
        		exit();*/

        		if (!is_numeric($query)){

	        		foreach ($query->result() as $row) {

	        			$idAv = $row->idAltaVenta;

	        			$idG = $row->id;

	        			$pdf_1 = $this->maltaventa->getCampo("pdf_1",$idAv);

		        		$pdf_9 = $this->mgestoria->getCampo("pdf_9",$idG);

		        		$pdf_15 = $this->mgestoria->getCampo("pdf_15",$idG);

	        			if($pdf_1!='' && $pdf_9 !='' && $pdf_15!=''){

							$this->mergePdf($idAv,$idG,'zip');

						}

	        		}

	        		$this->zip();    

        		}else{
						$data['msgExp'] = "<span style='color:red;'>No se encontraron resultados</span>";						
        		}

        	}
        	
        	$data['rondas'] = $this->mgestoria->getRondas();
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}

	    public function listado(){
	        $q = $this->mtitulacion2->get_datatables();
	        // print_r($q->result()); exit();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	            	$idGestoria = $this->mgestoria->getIdByIdAv($row->id);
	            	$calcelarProceso = ($row->statusGestoria !='detonado')?true:false;

	            	$esperaIns = $this->mareastatus->getByIdAreaAv(2,$row->id,'espera de inscripcion');
	            	$inscrito = $this->mareastatus->getByIdAreaAv(2,$row->id,'inscrito');
	            	$ahorroVol = $this->mareastatus->getByIdAreaAv(2,$row->id,'ahorro voluntario');
	            	$revCondiciones = $this->mareastatus->getByIdAreaAv(2,$row->id,'revision de condiciones');
	            	$notaria = $this->mareastatus->getByIdAreaAv(2,$row->id,'notaria');
	            	$firmaEscritura = $this->mareastatus->getByIdAreaAv(2,$row->id,'programado firma de escritura');
	            	$firmado = $this->mareastatus->getByIdAreaAv(2,$row->id,'firmado');
	            	$detonado = $this->mareastatus->getByIdAreaAv(2,$row->id,'detonado');

	            	//damos formato de fecha a cada estatus, si existe
	            	$fechaEsperaIns = (!is_numeric($esperaIns))?$esperaIns['fecha']:'';
	            	$fechaEsperaIns = ($fechaEsperaIns!='' && $fechaEsperaIns!='0000-00-00')?date('d/m/Y',strtotime($fechaEsperaIns)):'';
	            	$fechaInscrito = (!is_numeric($inscrito))?$inscrito['fecha']:'';
	            	$fechaInscrito = ($fechaInscrito!='' && $fechaInscrito!='0000-00-00')?date('d/m/Y',strtotime($fechaInscrito)):'';
	            	$fechaAhorroVol = (!is_numeric($ahorroVol))?$ahorroVol['fecha']:'';
	            	$fechaAhorroVol = ($fechaAhorroVol!='' && $fechaAhorroVol!='0000-00-00')?date('d/m/Y',strtotime($fechaAhorroVol)):'';
	            	$fechaRevCondiciones = (!is_numeric($revCondiciones))?$revCondiciones['fecha']:'';
	            	$fechaRevCondiciones = ($fechaRevCondiciones!='' && $fechaRevCondiciones!='0000-00-00')?date('d/m/Y',strtotime($fechaRevCondiciones)):'';
	            	$fechaNotaria = (!is_numeric($notaria))?$notaria['fecha']:'';
	            	$fechaNotaria = ($fechaNotaria!='' && $fechaNotaria!='0000-00-00')?date('d/m/Y',strtotime($fechaNotaria)):'';
	            	$fechaFirmaEscritura = (!is_numeric($firmaEscritura))?$firmaEscritura['fecha']:'';
	            	$fechaFirmaEscritura = ($fechaFirmaEscritura!='' && $fechaFirmaEscritura!='0000-00-00')?date('d/m/Y',strtotime($fechaFirmaEscritura)):'';
	            	$fechaFirmado = (!is_numeric($firmado))?$firmado['fecha']:'';
	            	$fechaFirmado = ($fechaFirmado!='' && $fechaFirmado!='0000-00-00')?date('d/m/Y',strtotime($fechaFirmado)):'';
	            	$fechaDetonado = (!is_numeric($detonado))?$detonado['fecha']:'';
	            	$fechaDetonado = ($fechaDetonado!='' && $fechaDetonado!='0000-00-00')?date('d/m/Y',strtotime($fechaDetonado)):'';
					//Nuevas fechas
					$fechaAlta=$this->maltaventa->getCampo("created",$row->id);
					$fechaProspeccion=$this->mprospecto->getCampo("fecha",$row->idProspecto);

	                $array[] = array(
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                    'nombre' => strtoupper($row->nombre.' '.$row->apellidoP.' '.$row->apellidoM),
	                    'nss' => $row->nss.".",
	                    'promotor' => strtoupper($row->idPromotor > 0)?strtoupper($this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor)):'',
	                    'lote' => $row->lote,
	                    'manzana' => $row->manzana,
	                    'ronda' => $row->ronda,
	                    'valorTerreno' => precio_format($row->valorTerreno),
	                    'supTerreno' => $row->supTerreno,
	                    'nOficial' => $row->nOficial,
	                    'calle' => $row->calle,
	                    'cuv' => $row->cuv.".",
	                    'monto' => precio_format($row->monto),
	                    'gastosOperacion' => precio_format($row->gastosOperacion),
	                    'total' => precio_format($row->total),
	                    'diferencia' => precio_format($row->difPropioPeculioTitulacion),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
	                    'numeroCredito' => $row->numeroCredito,
	                    'precioVentaOci' => precio_format($row->precioVentaOci),
	                    'montoOci' => precio_format($row->montoOci),
	                    'gastosTitulacion' => precio_format($row->gastosTitulacion),
	                    'ahorroVol' => precio_format($row->ahorroVol),
	                    'subsidio' => precio_format($row->subsidio),
	                    'sumaFinal' => precio_format($row->sumaFinal),
	                    'fechaFirma' => ($row->fechaFirma!='' && $row->fechaFirma!='0000-00-00')?date_format(new DateTime($row->fechaFirma),'d/m/Y'):'',
	                    'fechaProceso' => ($row->fechaProceso!='' && $row->fechaProceso!='000-00-00')?date('d/m/Y',strtotime($row->fechaProceso)):'',//fecha proceso

	                    'fechaEsperaIns' => $fechaEsperaIns,
	                    'fechaInscrito' => $fechaInscrito,
	                    'fechaAhorroVol' => $fechaAhorroVol,
	                    'fechaRevCondiciones' => $fechaRevCondiciones,
	                    'fechaNotaria' => $fechaNotaria,
	                    'fechaFirmaEscritura' => $fechaFirmaEscritura,
	                    'fechaFirmado' => $fechaFirmado,
	                    'fechaDetonado' => $fechaDetonado,
						//FECHAS AGREGADAS
						'fechaPreca' => ($row->fechaPreca != "" && $row->fechaPreca != "0000-00-00") ? date_format(new DateTime($row->fechaPreca), 'd-m-Y') : '',
						'fechaAlta' => ($fechaAlta != "") ? date_format(new DateTime($fechaAlta), 'd-m-Y') : '',
						'fechaProspeccion' => ($fechaProspeccion != "") ? date_format(new DateTime($fechaProspeccion), 'd-m-Y') : '',
						'ronda'=> $row->ronda,

	                    'fechaVenta' => ($row->fechaVenta!='0000-00-00' && $row->fechaVenta!='')?date_format(new DateTime($row->fechaVenta),'d/m/Y'):'',
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
	                    'statusGestoria' => strtoupper($row->statusGestoria),
	                    'fechaCambio' => ($row->fechaCambio!='' && $row->fechaCambio!='000-00-00')?date('d/m/Y',strtotime($row->fechaCambio)):'',
	                    'acciones' => (getSession('ventas','gestoria_edit')) ? acciones($row->id,$this->router->class, true, true, false,'','',false,0,$calcelarProceso,$idGestoria) : accionesNoEdit($row->id,$this->router->class)
	                    );
	            }
	        } else{
	            $array[] = array(
	            	'fraccionamiento' => 'No hay registros',
	                'nombre' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'ronda' => 'No hay registros',
	                'valorTerreno' => 'No hay registros',
                    'supTerreno' => 'No hay registros',
	                'nOficial' => 'No hay registros',
	                'calle' => 'No hay registros',
	                'cuv' => 'No hay registros',
	                'monto' => 'No hay registros',
	                'gastosOperacion' => 'No hay registros',
	                'total' => 'No hay registros',
	                'diferencia' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                'numeroCredito' => 'No hay registros',
	                'precioVentaOci' => 'No hay registros',
	                'montoOci' => 'No hay registros',
	                'gastosTitulacion' => 'No hay registros',
	                'ahorroVol' => 'No hay registros',
	                'subsidio' => 'No hay registros',
	                'sumaFinal' => 'No hay registros',
	                'fechaFirma' => 'No hay registros',
	                'fechaProceso' => 'No hay registros',
	                'fechaEsperaIns' => 'No hay registros',
	                'fechaInscrito' => 'No hay registros',
	                'fechaAhorroVol' => 'No hay registros',
	                'fechaRevCondiciones' => 'No hay registros',
	                'fechaNotaria' => 'No hay registros',
	                'fechaFirmaEscritura' => 'No hay registros',
	                'fechaFirmado' => 'No hay registros',
	                'fechaDetonado' => 'No hay registros',
	                'fechaVenta' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusGestoria' => 'No hay registros',
	                'fechaCambio' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }
	        $output = array(
	                        "draw" => $_POST['draw'],
	                        "recordsTotal" => $this->mtitulacion2->count_all(),
	                        "recordsFiltered" => $this->mtitulacion2->count_filtered(),
	                        "data" => $array,
	                );
	        //output to json format
	        echo json_encode($output);
	    }

	    public function listado2(){
	        $q = $this->maltaventa->getPendientesTitulacion();
	        // print_r($q->result()); exit();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){
	                $array['aaData'][] = array(
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                    'nombre' => $row->nombre.' '.$row->apellidoP.' '.$row->apellidoM,
	                    'nss' => $row->nss.".",
	                    'promotor' =>  ($row->idPromotor > 0)?$this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor):'',
	                    'lote' => $row->lote,
	                    'manzana' => $row->manzana,
	                    'nOficial' => $row->nOficial,
	                    'calle' => $row->calle,
	                    'cuv' => $row->cuv.".",
	                    'monto' => precio_format($row->monto),
	                    'gastosOperacion' => precio_format($row->gastosOperacion),
	                    'total' => precio_format($row->total),
	                    'diferencia' => precio_format($row->diferencia),
	                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
	                    'numeroCredito' => '',//$row->numeroCredito,
	                    'precioVentaOci' => '',//precio_format($row->precioVentaOci),
	                    'montoOci' => '',//precio_format($row->montoOci),
	                    'gastosTitulacion' => '',//precio_format($row->gastosTitulacion),
	                    'ahorroVol' => '',//precio_format($row->ahorroVol),
	                    'subsidio' => '',//precio_format($row->subsidio),
	                    'sumaFinal' => '',//precio_format($row->sumaFinal),
	                    'fechaFirma' => '',//date_format(new DateTime($row->fechaFirma),'d/m/Y'),
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'statusVivienda' => estatus_proyecto_reporte($row->statusVenta),
	                    'statusGestoria' => '',//$row->statusGestoria,
	                    'fechaCambio' => '',//($row->fechaCambio!='' && $row->fechaCambio!='000-00-00')?date('d/m/Y',strtotime($row->fechaCambio)):'',
	                    'acciones' => (getSession('ventas','gestoria_edit'))  ? '<a class="btn blue" href="'.$this->router->class.'/nuevo/'.$row->idProspecto.'">Validar</a>

	                    <a style="margin-top:10px" class="btn blue" href="javascript:void(0)"  onclick="revertir('.$row->id.')" >Revertir</a>':'',

	                    //($_SESSION["viv"]["rol"] != 7) ? acciones($row->id,$this->router->class, true, true, false) : accionesNoEdit($row->id,$this->router->class)
	                    );
	            }
	        } else{
	            $array['aaData'][] = array(
	            	'fraccionamiento' => 'No hay registros',
	                'nombre' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'nOficial' => 'No hay registros',
	                'calle' => 'No hay registros',
	                'cuv' => 'No hay registros',
	                'monto' => 'No hay registros',
	                'gastosOperacion' => 'No hay registros',
	                'total' => 'No hay registros',
	                'diferencia' => 'No hay registros',
	                'bonoEquipamiento' => 'No hay registros',
	                'numeroCredito' => 'No hay registros',
	                'precioVentaOci' => 'No hay registros',
	                'montoOci' => 'No hay registros',
	                'gastosTitulacion' => 'No hay registros',
	                'ahorroVol' => 'No hay registros',
	                'subsidio' => 'No hay registros',
	                'sumaFinal' => 'No hay registros',
	                'fechaFirma' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusGestoria' => 'No hay registros',
	                'fechaCambio' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }
	   /*Funcion para cambiar de estatus*/
	   public function ProcesarModalRevertir()
	    {
	    	$idAltaVenta= $this->input->post('idAltaVenta', TRUE);
	    	$statusAnt =$this->maltaventa->getCampo('statusValidacion',$idAltaVenta);
	    /*	echo $statusAnt;
	    	exit();*/
		    	if ($statusAnt == 2 ){
	    			$pStatus['statusValidacion'] = 1;
		    		$this->maltaventa->actualizar($pStatus,$idAltaVenta) ;
		    		$response = array(
	    			'success' => true,
	    			'msg' => 'Actualizacion Exitosa'
	    			);
		    	}

		    	else {
		    		$response = array(
		    			'success' => false,
		    			'msg' => 'Fallo la actualizacion'
		    		);
		    	}
	    	echo json_encode( $response );
	    }

	    public function nuevo($idProspecto=null){

	        $data['msg'] = '';
	        $contadorArchivos = 0;
	    	$data['disabled'] = true;
	    	$bloquedSelectNss = ($idProspecto!=null)?true:false;
	    	$data['idProspecto'] = '';
	    	$data['fraccionamiento'] = '';
	    	$data['id'] = '';
	    	$data['msgInvalid'] = '';
	    	$subirArchivo = false;
	    	$txtNotif = '';
	    	$qTxtNoti = 0;

	        if (isset($_POST['idProspecto']) || $idProspecto!=null){
	        	$idProspecto = ($idProspecto!=null)?$idProspecto:$this->input->post('idProspecto', TRUE);
	        	$info = $this->maltaventa->getByIdProspecto($idProspecto);
	        	$data = (!is_numeric($info))?$info:'';
	        	$data['fraccionamiento'] = (!is_numeric($info))?$this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']):'';
	        	//print_r($data);exit();
	        	$data['disabled'] = (!is_numeric($info))?false:true;
	        	$data['idProspecto'] = $idProspecto;
	        	$data['msg'] = '';

	        	if(is_numeric($info)){
	        		$data['id']='';
	        		$data['msgInvalid'] = 'El NSS elegido no está asociado a un prospecto';
	        	}else{
	        		$data['msgInvalid'] = '';
	        	}
	        }
	        if (isset($_POST['statusGestoria'])){
	        	$data['idProspecto'] = $this->input->post('idProspecto', TRUE);
	        	$fvg= $this->input->post('statusGestoria', TRUE);
	        	if($fvg=='detonado'){
		        	$valDeton='gestoria';
		       	}else{
		        	$valDeton='gestoria2';
		        }
		        //print_r($data['altas']->result());exit();
		        $this->load->library('form_validation');
		        if ($this->form_validation->run($valDeton) == FALSE) {
		            $data['msg'] = validation_errors();
		        } else {
		        	if (!is_numeric($info)){
		        		$statusValidacion_old = $this->maltaventa->getCampo('statusValidacion',$info['id']);
		        	}else{
		        		$statusValidacion_old = 0;
		        	}


		        	// Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);

		            if (isset($_FILES)){
		                $imagenes = array();
		                foreach($_FILES as $key=>$value){
		                    if ($_FILES[$key]['size'] > 0){
		                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
		                        $imagenes[] = $key;
		                    }
		                }
		                $totalImagenes = count($imagenes);
		                for($i=0; $i< $totalImagenes; $i++){
		                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
		                    //Configuracion del thumbnail
		                    if($imagenes[$i]!='pdf'){
		                        $nCampoC = explode("_",$imagenes[$i]);
		                        $tipo = $nCampoC[0];
		                        $v = $nCampoC[1];

		                    } else {
		                        $v = 0;
		                        $tipo = 'pdf';
		                    }
		                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
		                        $uploaddir = $this->data['fotos_www'];
		                        $nextId = $this->mgestoria->nextId();
		                        $config['file_name'] =  $nextId."_".$v;
		                        $config['overwrite'] = TRUE;
		                        $config['upload_path'] = $uploaddir;
		                        $config['max_size'] = '8000';
		                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
		                        $this->upload->initialize($config);
		                        if ( ! $this->upload->do_upload($imagenes[$i]) )
		                        {
		                            $redirect = 1;
		                            $data['error'] = $this->upload->display_errors();
		                        }
		                        else
		                        {
	                        		$contadorArchivos++;
		                            $dataFile = $this->upload->data($imagenes[$i]);
		                            $fotoI = 'pdf_'.$v;
		                            //$thumbI = 'thumbnail_'.$v;
		                            if ($v == 0){
		                                //Foto default
		                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
		                            } else {
		                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
		                            }
		                        }
		                    }

		                }
		            }

		        	$pData['statusGestoria'] = $this->input->post('statusGestoria', TRUE);
		        	if ($pData['statusGestoria']=='detonado'){
		        		if ($contadorArchivos<3){
		        			$subirArchivo = true;
		        		}
		        	}
		        	if ($subirArchivo==false){
		        		$pData['fechaCambio'] = date("Y-m-d H:i:s");
			        	$pData['aplicaFolio'] = $this->input->post('aplicaFolio', TRUE);
			        	//$pData['tipoCredito'] = $this->input->post('tipoCredito', TRUE);
			        	$pData['numeroFolio'] = $this->input->post('numeroFolio', TRUE);
			        	$pData['numeroCredito'] = $this->input->post('numeroCredito', TRUE);
			        	$pData['numeroEscritura'] = $this->input->post('numeroEscritura', TRUE);
			        	$pData['numeroCredito2'] = $this->input->post('numeroCredito2', TRUE);
			        	$valorTerreno = $this->input->post('valorTerreno', TRUE);
			        	$pData['valorTerreno'] = ($valorTerreno!='')?toInt($valorTerreno):0.00;
			        	$pData['numeroAvaluo'] = $this->input->post('numeroAvaluo', TRUE);
						$pData['superficieTerreno'] = $this->input->post('superficieTerreno', TRUE);
			        	$fechaIngreso = $this->input->post('fechaIngreso', TRUE);
			        	$fechaIngreso =  str_replace('/', '-', $fechaIngreso);
			        	$pData['fechaIngreso'] = ($fechaIngreso!='')?date('Y-m-d', strtotime($fechaIngreso)):NULL;//date_format(new DateTime($fechaIngreso),'Y-m-d');
						$fechaEscritura = $this->input->post('fechaEscritura', TRUE);
			        	$fechaEscritura =  str_replace('/', '-', $fechaEscritura);
			        	$pData['fechaEscritura'] = ($fechaEscritura!='')?date('Y-m-d', strtotime($fechaEscritura)):NULL;//date_format(new DateTime($fechaEscritura),'Y-m-d');
			        	$pData['certificadoLibertad'] = $this->input->post('certificadoLibertad', TRUE);
			        	$pData['constanciaNoAdeudo'] = $this->input->post('constanciaNoAdeudo', TRUE);
			        	$pData['precioVentaOci'] = ($this->input->post('precioVentaOci', TRUE)!='')?$this->input->post('precioVentaOci', TRUE):0.00;
						$pData['montoOci'] = ($this->input->post('montoOci', TRUE)!='')?$this->input->post('montoOci', TRUE):0.00;
			        	$pData['subCuenta'] = ($this->input->post('subCuenta', TRUE)!='')?$this->input->post('subCuenta', TRUE):0.00;
			        	$pData['gastosTitulacion'] = ($this->input->post('gastosTitulacion', TRUE)!='')?$this->input->post('gastosTitulacion', TRUE):0.00;
			        	$pData['ahorroVol'] = ($this->input->post('ahorroVol', TRUE)!='')?$this->input->post('ahorroVol', TRUE):0.00;
			        	$pData['seguroCalidad'] = ($this->input->post('seguroCalidad', TRUE)!='')?toInt($this->input->post('seguroCalidad', TRUE)):0.00;
			        	$pData['subsidio'] = ($this->input->post('subsidio', TRUE)!='')?$this->input->post('subsidio', TRUE):0.00;
			        	$pData['sumaFinal'] = $pData['montoOci'] + $pData['subCuenta'] + $pData['subsidio'] + $pData['ahorroVol'] - $pData['gastosTitulacion'];//$this->input->post('total', TRUE);
			        	$fechaFirma = $this->input->post('fechaFirma', TRUE);
			        	$fechaFirma =  str_replace('/', '-', $fechaFirma);
			        	$pData['fechaFirma'] = ($pData['statusGestoria']=='firmado')?date('Y-m-d'):null;//($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):null;
			        	$pData['ronda'] = $this->input->post('ronda', TRUE);
			        	$difPropioPeculioTitulacion = $this->input->post('difPropioPeculioTitulacion', TRUE);
			        	$pData['difPropioPeculioTitulacion'] = ($difPropioPeculioTitulacion!='')?toInt($difPropioPeculioTitulacion):0.00;

			        	//Datos para actualizar tabla alta_venta
			        	$diferencia = $this->input->post('diferencia', TRUE);
			        	$avData['diferencia'] = ($diferencia!='')?toInt($diferencia):0.00;
		        		$bonoEquipamiento = $this->input->post('bonoEquipamiento', TRUE);
	        			$avData['bonoEquipamiento'] = ($bonoEquipamiento!='')?toInt($bonoEquipamiento):0.00;

			        	$id = $this->input->post('idAltaVenta', TRUE);
			        	$validId = $this->maltaventa->existRowByIdForGestoria($id);
			        	if ($validId > 0){
			        		$pData['idAltaVenta'] = $id;
			        		// exit();

			        		$validaIdG = $this->mgestoria->getIdByIdAv($id);
			        		if($validaIdG>0){
			        			$this->mgestoria->actualizar($pData,$validaIdG);
			        		}else{
			        			$id_gestoria = $this->mgestoria->insertar($pData);
			        		}

			        		$existeEstatusDetonado = $this->mareastatus->getByIdAreaAv(3,$id,'detonado');
			        		$existeEstatusProceso = $this->mareastatus->getByIdAreaAv(3,$id,'proceso');
			        		//insertamos fecha de proceso y detonado (si aplica)
			        		if($pData['statusGestoria']=='detonado' && is_numeric($existeEstatusDetonado) && is_numeric($existeEstatusProceso)){
			        			$ae['idArea'] = 3;
			        			$ae['idAltaVenta'] = $id;
			        			$ae['idStatus'] = 'proceso';
			        			$ae['fecha'] = date('Y-m-d H:i:s');
			        			$this->mareastatus->insertar($ae);

			        			$ae['idArea'] = 3;
			        			$ae['idAltaVenta'] = $id;
			        			$ae['idStatus'] = 'detonado';
			        			$ae['fecha'] = date('Y-m-d H:i:s');
			        			$this->mareastatus->insertar($ae);

			        			$ae['idArea'] = 4;
			        			$ae['idAltaVenta'] = $id;
			        			$ae['idStatus'] = 'pendientes';
			        			$ae['fecha'] = date('Y-m-d H:i:s');
			        			$this->mareastatus->insertar($ae);

			        		}elseif(is_numeric($existeEstatusProceso)){
			        			$ae['idArea'] = 3;
			        			$ae['idAltaVenta'] = $id;
			        			$ae['idStatus'] = 'proceso';
			        			$ae['fecha'] = date('Y-m-d H:i:s');
			        			$this->mareastatus->insertar($ae);
			        		}
			        		//validamos inserción del estatus en la tabla relacion area estatus
			        		if($pData['statusGestoria']!=''){
			        			switch ($pData['statusGestoria']) {
			        				case 'inscrito':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'inscrito');
			        					$txtNotif = 'inscrito';
			        					break;

		        					case 'programado firma de escritura':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'programado firma de escritura');
			        					$txtNotif = 'programado firma de escritura';
			        					break;

		        					case 'detonado':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'detonado');
			        					$txtNotif = 'detonado';
			        					break;
			        				
			        				default:
			        					# code...
			        					break;
			        			}
			        			$ae['idArea'] = 2;
			        			$ae['idAltaVenta'] = $id;
			        			$ae['idStatus'] = $pData['statusGestoria'];
			        			$ae['fecha'] = date('Y-m-d H:i:s');
			        			$this->mareastatus->insertar($ae);
			        		}

				        	$avData['statusValidacion'] = 3;//($pData['numeroCredito'] !='')?4:3; // indica que la venta se encuentra en etapa de gestoría
				        	if ( $statusValidacion_old > 4 && $pData['statusGestoria'] == 'detonado') {
			        			$avData['statusValidacion'] = $statusValidacion_old;
			        		}else{
			        			$avData['statusValidacion'] = 3;
			        		}

				        	$this->maltaventa->actualizar($avData,$id);
				        	$idProyecto = $this->maltaventa->getCampo("idProyecto",$id);
							$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$idProyecto);
				        	if ( $pData['statusGestoria'] != 'detonado' ) {
				        		$pyData['statusVenta'] = 2;
				        		$fechaProceso['fechaProceso'] = date('Y-m-d');
				        		$this->maltaventa->actualizar($fechaProceso, $id);
				        	}
				        	if ( $pData['statusGestoria'] == 'detonado' ) {
				        		$pyData['statusVenta'] = 3;
								//if( $lineaCredito == 3 ){
									$pyData['statusObra'] = 2;
								//}
				        		// Guardar fecha de venta de proyecto
				        		$obj['fechaProceso'] = date('Y-m-d');
				        		$obj['fechaVenta'] = date('Y-m-d');
				        		$obj['statusValidacion'] = ($statusValidacion_old > 4)?$statusValidacion_old:4;
				        		$this->maltaventa->actualizar($obj, $id);

				        		//insertamos si existe diferencia del asesor
					        	if($this->input->post('revisionMontos2', TRUE) == 'diferencia' && is_numeric($existeEstatusDetonado)){
					        		$idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
					        		//$rowdp = $this->mdiferenciapromotor->getByIdPromotor($idPromotor);
					        		//$saldoAnterior = (!is_numeric($rowdp))?$rowdp->row()->saldo:0.00;
					        		//$saldoAnterior = ($saldoAnterior<0)?$saldoAnterior:0.00;
					        		$dData['idAltaventa'] = $id;
					        		$dData['idPromotor'] = $idPromotor;
					        		$dData['cargo'] = $this->maltaventa->getCampo('diferenciaAsesor',$id);//$pData['diferenciaAsesor'];
					        		$dData['tipo'] = 'Ingresos';
					        		//$dData['saldo'] = $saldoAnterior - $dData['cargo'];
				        			//print_r($dData);
				        			//exit();	
				        			//$this->mdiferenciapromotor->insertar($dData);	
				        			$this->mmovimientospromotor->insertar($dData);	
					        	}

				        	}


				        	$resPry = $this->mproyecto->actualizar($pyData, $idProyecto);
				        	$autores = $this->autoRespuesta($pData);
				        	if(is_numeric($qTxtNoti)){ // validamos para enviar notificación por email/wapp
				        		require('Cronjob.php');
				                $cronjob = new Cronjob();
				                $pData2['idProyecto'] = $idProyecto;
				        		switch ($txtNotif) {
				        			case 'inscrito':
						                $pData2['tipo'] = 'inscripcion de credito2';
				                		$insert = $cronjob->insertLogsNotifications($pData2);
				        				break;
			        				case 'programado firma de escritura':
						                $pData2['tipo'] = 'programacion de firma de escrituras';
				                		$insert = $cronjob->insertLogsNotifications($pData2);
				        				break;

			        				case 'detonado':
						                $pData2['tipo'] = 'formalizacion de la venta';
				                		$insert = $cronjob->insertLogsNotifications($pData2);
				        				break;
				        			
				        			default:				        				
				        				break;
				        		}
				        	}
				        	if ($pData['certificadoLibertad'] == 'si' ){
								$this->autoRespuestaCertificado($pData);
							}
							redirect($this->router->class);
			        	}else{
			        		$data['msgInvalid'] = 'Verifique que la información es correcta';
			        	}
		        	}else{
		        		$data['msgInvalid'] = 'Es necesario subir todos los documentos';
		        	}
		        }
	        }

	        $data['altas'] = $this->maltaventa->getNSSValidVenta();
	        $data['mpromotor'] = $this->musuario;
	        $data['mnotaria'] = $this->mnotaria;
	        $data['bloquedSelectNss'] = $bloquedSelectNss;

	        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);

	    }


	    public function editar($id = null, $idGestoria = null){ // $id = id en tabla alta venta, idGestoria es el id en la tabla gestoria

	    	$data['disabled'] = true;
	    	$data['id'] = '';
	    	$data['msgInvalid'] = '';
	        $data['msg'] = '';
	        $contadorArchivos = 0;
	        $subirArchivo = false;
	        $txtNotif = '';
	    	$qTxtNoti = 0;
			$info = $this->maltaventa->getByIdForGestoria($id);

        	$data = (!is_numeric($info))?$info:'';
        	$data['disabled'] = (!is_numeric($info))?false:true;

        	if(is_numeric($info)){
        		$data['id']='';
        		$data['msgInvalid'] = 'El NSS elegido no está asociado a un prospecto';
        	}else{
        		$data['msgInvalid'] = '';
        	}

	        if (isset($_POST['statusGestoria'])){
		        $fvg= $this->input->post('statusGestoria', TRUE);

		        if($fvg=='detonado'){
		        	$valDeton='gestoria';
		       	}else{
		        	$valDeton='gestoria2';
		        }

		        $this->load->library('form_validation');
		        if ($this->form_validation->run($valDeton) == FALSE) {
		            $data['msg'] = validation_errors();
		            //print_r($data['msg']);exit();
		        }
		        else {
		        	$statusValidacion_old = $this->maltaventa->getCampo('statusValidacion',$id);

	                // Subida de pdf
		            $config = array();
		            $this->load->library('upload', $config);

		            if (isset($_FILES)){
		                $imagenes = array();
		                foreach($_FILES as $key=>$value){
		                    if ($_FILES[$key]['size'] > 0){
		                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
		                        $imagenes[] = $key;
		                    }
		                }
		                $totalImagenes = count($imagenes);
		                for($i=0; $i< $totalImagenes; $i++){
		                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
		                    //Configuracion del thumbnail
		                    if($imagenes[$i]!='pdf'){
		                        $nCampoC = explode("_",$imagenes[$i]);
		                        $tipo = $nCampoC[0];
		                        $v = $nCampoC[1];

		                    } else {
		                        $v = 0;
		                        $tipo = 'pdf';
		                    }
		                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
		                        $uploaddir = $this->data['fotos_www'];
		                        $nextId = $idGestoria;
		                        $config['file_name'] =  $nextId."_".$v;
		                        $config['overwrite'] = TRUE;
		                        $config['upload_path'] = $uploaddir;
		                        $config['max_size'] = '8000';
		                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
		                        $this->upload->initialize($config);
		                        if ( ! $this->upload->do_upload($imagenes[$i]) )
		                        {
		                            $redirect = 1;
		                            $data['error'] = $this->upload->display_errors();
		                        }
		                        else
		                        {
		                        	$contadorArchivos++;
		                            $dataFile = $this->upload->data($imagenes[$i]);
		                            $fotoI = 'pdf_'.$v;
		                            //$thumbI = 'thumbnail_'.$v;
		                            if ($v == 0){
		                                //Foto default
		                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
		                            } else {
		                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
		                            }
		                        }
		                    }

		                }
		            }
		            $statusGestoria_old = $this->mgestoria->getCampo('statusGestoria', $idGestoria);
		            $campoFechaFirma = $this->mgestoria->getCampo('fechaFirma', $idGestoria);

		            $pData['statusGestoria'] = $this->input->post('statusGestoria', TRUE);

		            if ($pData['statusGestoria']=='detonado'){
		            	$pdf_8 = $this->mgestoria->getCampo('pdf_8', $idGestoria);
		            	$pdf_9 = $this->mgestoria->getCampo('pdf_9', $idGestoria);
		            	$pdf_15 = $this->mgestoria->getCampo('pdf_15', $idGestoria);

		        		/*if ($contadorArchivos<3){
		        			$subirArchivo = true;
		        		}*/
		        	}

		        	//insertamos estatus del proceso
		        	$existeEstatusDetonado = $this->mareastatus->getByIdAreaAv(3,$id,'detonado');

		        	if ($statusGestoria_old!='detonado' && $pData['statusGestoria']=='detonado' && is_numeric($existeEstatusDetonado)){
		        		$ae['idArea'] = 3;
	        			$ae['idAltaVenta'] = $id;
	        			$ae['idStatus'] = 'detonado';
	        			$ae['fecha'] = date('Y-m-d H:i:s');
	        			$this->mareastatus->insertar($ae);

	        			$ae['idArea'] = 4;
	        			$ae['idAltaVenta'] = $id;
	        			$ae['idStatus'] = 'pendientes';
	        			$ae['fecha'] = date('Y-m-d H:i:s');
	        			$this->mareastatus->insertar($ae);
		        	}

		        	if($subirArchivo==false){
			            if ($statusGestoria_old != $pData['statusGestoria']){ //validamos si hubo cambio en el status
			            	$pData['fechaCambio'] = date("Y-m-d H:i:s");
			            }
			        	$pData['aplicaFolio'] = $this->input->post('aplicaFolio', TRUE);
			        	//$pData['tipoCredito'] = $this->input->post('tipoCredito', TRUE);
			        	$pData['numeroFolio'] = $this->input->post('numeroFolio', TRUE);
			        	$pData['numeroCredito'] = $this->input->post('numeroCredito', TRUE);
			        	$pData['numeroEscritura'] = $this->input->post('numeroEscritura', TRUE);
			        	$pData['numeroCredito2'] = $this->input->post('numeroCredito2', TRUE);
			        	$valorTerreno = $this->input->post('valorTerreno', TRUE);
			        	$pData['valorTerreno'] = toInt($valorTerreno);
			        	$pData['numeroAvaluo'] = $this->input->post('numeroAvaluo', TRUE);
						$pData['superficieTerreno'] = $this->input->post('superficieTerreno', TRUE);
			        	$fechaIngreso = $this->input->post('fechaIngreso', TRUE);
			        	$fechaIngreso =  str_replace('/', '-', $fechaIngreso);
			        	$pData['fechaIngreso'] = ($fechaIngreso!='')?date('Y-m-d', strtotime($fechaIngreso)):NULL;
						$fechaEscritura = $this->input->post('fechaEscritura', TRUE);
			        	$fechaEscritura =  str_replace('/', '-', $fechaEscritura);
			        	$pData['fechaEscritura'] = ($fechaEscritura!='')?date('Y-m-d', strtotime($fechaEscritura)):NULL;
			        	$pData['certificadoLibertad'] = $this->input->post('certificadoLibertad', TRUE);
			        	$pData['constanciaNoAdeudo'] = $this->input->post('constanciaNoAdeudo', TRUE);
			        	$pData['precioVentaOci'] = ($this->input->post('precioVentaOci', TRUE)!='')?$this->input->post('precioVentaOci', TRUE):0.00;
						$pData['montoOci'] = ($this->input->post('montoOci', TRUE)!='')?$this->input->post('montoOci', TRUE):0.00;
			        	$pData['subCuenta'] = ($this->input->post('subCuenta', TRUE)!='')?$this->input->post('subCuenta', TRUE):0.00;
			        	$pData['gastosTitulacion'] = ($this->input->post('gastosTitulacion', TRUE)!='')?$this->input->post('gastosTitulacion', TRUE):0.00;
			        	$pData['ahorroVol'] = ($this->input->post('ahorroVol', TRUE)!='')?$this->input->post('ahorroVol', TRUE):0.00;
		        		$pData['seguroCalidad'] = ($this->input->post('seguroCalidad', TRUE)!='')?toInt($this->input->post('seguroCalidad', TRUE)):0.00;
			        	$pData['subsidio'] = ($this->input->post('subsidio', TRUE)!='')?$this->input->post('subsidio', TRUE):0.00;
			        	$pData['sumaFinal'] = $pData['montoOci'] + $pData['subCuenta'] + $pData['subsidio'] + $pData['ahorroVol'] - $pData['gastosTitulacion'];//$this->input->post('total', TRUE);
			        	//echo $pData['sumaFinal'];exit();
			        	$fechaFirma = $this->input->post('fechaFirma', TRUE);
			        	$fechaFirma =  str_replace('/', '-', $fechaFirma);
			        	if( ($campoFechaFirma=='' || $campoFechaFirma=='0000-00-00') && $pData['statusGestoria']=='firmado'){
			        		$pData['fechaFirma'] = date('Y-m-d');//($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):'0000-00-00';//date_format(new DateTime($fechaFirma),'Y-m-d');
			        	}
			        	$pData['ronda'] = $this->input->post('ronda', TRUE);
			        	$difPropioPeculioTitulacion = $this->input->post('difPropioPeculioTitulacion', TRUE);
			        	$pData['difPropioPeculioTitulacion'] = ($difPropioPeculioTitulacion!='')?toInt($difPropioPeculioTitulacion):0.00;

			        	//Datos para actualizar tabla alta_venta
			        	$diferencia = $this->input->post('diferencia', TRUE);
			        	$avData['diferencia'] = ($diferencia!='')?toInt($diferencia):0.00;
		        		$bonoEquipamiento = $this->input->post('bonoEquipamiento', TRUE);
	        			$avData['bonoEquipamiento'] = ($bonoEquipamiento!='')?toInt($bonoEquipamiento):0.00;

			        	$validId = $this->maltaventa->existRowByIdForGestoria($id);

			        	//if ($validId > 0){ //COMENTAMOS LA VALIDACION XQ ESTE REGISTRO PUEDE ETAR EN UN ESTATU DE ENTREGA CON UN STATUSVALIDACION > 2
				        	$this->mgestoria->actualizar($pData, $idGestoria);

				        	$rowEstatus = $this->mareastatus->getByIdAreaAv(2,$id);
				        	$estatusOld = '';
				        	if(!is_numeric($rowEstatus)){
				        		$estatusOld = $rowEstatus['idStatus'];
				        	}
				        	//validamos inserción del estatus en la tabla relacion area estatus
				        	if($estatusOld != $pData['statusGestoria'] && $pData['statusGestoria']!=''){

				        		switch ($pData['statusGestoria']) {
			        				case 'inscrito':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'inscrito');
			        					$txtNotif = 'inscrito';
			        					break;

		        					case 'programado firma de escritura':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'programado firma de escritura');
			        					$txtNotif = 'programado firma de escritura';
			        					break;

		        					case 'detonado':
			        					$qTxtNoti = $this->mareastatus->getByIdAreaAv(2,$id,'detonado');
			        					$txtNotif = 'detonado';
			        					break;
			        				
			        				default:
			        					# code...
			        					break;
			        			}

				        		$ae['idArea'] = 2;
				        		$ae['idAltaVenta'] = $id;
				        		$ae['idStatus'] = $pData['statusGestoria'];
				        		$ae['fecha'] = date('Y-m-d H:i:s');
				        		$this->mareastatus->insertar($ae);
				        	}

				        	$avData['statusValidacion'] = ($pData['numeroCredito'] !='')?4:3; // indica que la venta se encuentra en etapa de gestoría
				        	if ( $statusValidacion_old >= 4 && $pData['statusGestoria'] == 'detonado') {
			        			$avData['statusValidacion'] = $statusValidacion_old;
			        		}else{
			        			$avData['statusValidacion'] = 3;
			        		}
				        	$this->maltaventa->actualizar($avData,$id);

				        	if ( $pData['statusGestoria'] != 'detonado' ) {
				        		$pyData['statusVenta'] = 2;
				        	}
							
				        	$idProyecto = $this->maltaventa->getCampo("idProyecto",$id);
							$lineaCredito = $this->mproyecto->getCampo("lineaCredito",$idProyecto);

				        	if ( $pData['statusGestoria'] == 'detonado' ) {
				        		$pyData['statusVenta'] = 3;
								//if( $lineaCredito == 3 ){
									$pyData['statusObra'] = 2;
								//}
				        		//$pData['idAltaVenta'] = $id;
				        		//$autores = $this->autoRespuesta( $pData );
				        		$idComosionB = $this->mcomisionbono->getByIdAV($id);
				        		$avDataD['statusValidacion'] = (!is_numeric($idComosionB))?5:4;
				        		$this->maltaventa->actualizar($avDataD,$id);

				        		if ($statusGestoria_old != 'detonado') {
				        			$pData['idAltaVenta'] = $id;
				        			//$autores = $this->autoRespuesta( $pData );
				        			$obj['fechaVenta'] = date('Y-m-d');
					        		$this->maltaventa->actualizar($obj,$id);
				        		}

				        		//insertamos si existe diferencia del asesor
					        	if($this->input->post('revisionMontos2', TRUE) == 'diferencia' && is_numeric($existeEstatusDetonado)){
					        		$idProspecto = $this->maltaventa->getCampo('idProspecto',$id);
					        		$idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
					        		//$rowdp = $this->mdiferenciapromotor->getByIdPromotor($idPromotor);
					        		//$saldoAnterior = (!is_numeric($rowdp))?$rowdp->row()->saldo:0.00;
					        		//$saldoAnterior = ($saldoAnterior<0)?$saldoAnterior:0.00;
					        		$dData['idAltaventa'] = $id;
					        		$dData['idPromotor'] = $idPromotor;
					        		$dData['cargo'] = $this->maltaventa->getCampo('diferenciaAsesor',$id);//$pData['diferenciaAsesor'];
					        		$dData['tipo'] = 'Ingresos';
					        		//$dData['saldo'] = $saldoAnterior - $dData['cargo'];
				        			//print_r($dData);
				        			//exit();	
				        			//$this->mdiferenciapromotor->insertar($dData);	
				        			$this->mmovimientospromotor->insertar($dData);	
					        	}				        		

				        	}
				        	$resPry = $this->mproyecto->actualizar($pyData, $idProyecto);

				        	if(is_numeric($qTxtNoti)){ // validamos para enviar notificación por email/wapp
				        		require('Cronjob.php');
				                $cronjob = new Cronjob();
				                $pData2['idProyecto'] = $idProyecto;
				        		switch ($txtNotif) {
				        			case 'inscrito':
										$lineaCredito=$this->mproyecto->getCampo("lineaCredito",$idProyecto);
										if($lineaCredito=="2"){
											$pData2['tipo'] = 'inscripcion de credito2';	
											$insert = $cronjob->insertLogsNotifications($pData2);
										}else if($lineaCredito=="3"){
											$pData2['tipo'] = 'inscripcion de credito3';
											$insert = $cronjob->insertLogsNotifications($pData2);	
										}
				        				break;
			        				case 'programado firma de escritura':
						                $pData2['tipo'] = 'programacion de firma de escrituras';
				                		$insert = $cronjob->insertLogsNotifications($pData2);
				        				break;
			        				case 'detonado':
						                $pData2['tipo'] = 'formalizacion de la venta';
				                		$insert = $cronjob->insertLogsNotifications($pData2);
				        				break;
				        			
				        			default:				        				
				        				break;
				        		}
				        	}

				        	//actualizamos en comisiones si hubo cambio en difPropPeculio
				        	$existeComision = $this->mcomisionbono->getByIdAV($id);
				        	if(!is_numeric($existeComision)){
				        		$idComision = $existeComision['id'];
				        		$coData['difPropioPeculio'] = $pData['difPropioPeculioTitulacion'];
				        		$this->mcomisionbono->actualizar($coData,$idComision);
				        	}

				        	if ($pData['certificadoLibertad'] == 'si' ){
			        			$pData['idAltaVenta'] = $id;
			        			$this->autoRespuestaCertificado($pData);
			        		}

				        	redirect($this->router->class."?close");
		        	}else{
		        		$data['msgInvalid'] = 'Es necesario subir todos los documentos';
		        	}

		        }
	        }

	        $data['altas'] = $this->maltaventa->getNSSValidVenta();
	        $data['mpromotor'] = $this->musuario;
	        $data['mnotaria'] = $this->mnotaria;
	        $data['fraccionamiento'] = (!is_numeric($info))?$this->mfraccionamiento->getCampo('titulo',$info['idFraccionamiento']):'';
	        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);

	    }

	    public function condicionesFinales($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';

	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;

	        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($data['idProyecto']);

	        /*print_r($data['detalle_venta']);
	        exit();*/
	        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);
	        /*if ( !is_numeric($comisiones) ) {
	            $data['etapa_comisionbono'] = true;
	            $data['detalle_comisionbono'] = $comisiones;
	        }*/
	        $data['etapa_comisionbono'] = true;
	        $data['mpromotor'] = $this->musuario;
	        $data['mfraccionamiento'] = $this->mfraccionamiento;
	        $data['mprototipo'] = $this->mprototipoxfraccionamiento;

	        $this->idFraccionamiento = $data['detalle_venta']['idFraccionamiento'];
	        $this->setLogo();
	        $html = $this->load->view('comisiones_bonos/condicionesfinales_view.php',$data,true);
/*	        echo $html;
	        exit();*/
	        $this->mpdf_lib->downloadPDF($html,"condicionesFinales",0,'footer','header',$this->urlLogo,'','',true,false,$this->idFraccionamiento);
	    }

		public function cartaEntrega($id = null){
	        $this->load->library("mpdf_lib");
	        $data = '';
	        $info = $this->maltaventa->getByIdAll($id);
	        $data = $info;

	        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($data['idProyecto']);
			if($data['detalle_venta']['idNotaria'] != ''){
				$data['mfraccionamiento'] = $this->mfraccionamiento;
				$this->idFraccionamiento = $data['detalle_venta']['idFraccionamiento'];
				$this->setLogo();
				$html = $this->load->view('gestoria/formato_view.php',$data,true);
				$margins=["ml"=>"20","mr"=>"20"];
				$this->mpdf_lib->downloadPDF($html,"Carta de Entrega",0,'footer','header',$this->urlLogo,'','',false,$margins,$this->idFraccionamiento);
			}else{
				echo "No se ha seleccionado una notaria";
			}
	    }

	    public function ver($id = null)
	    {
	        //Obtenemos el id del Proyecto a aprtir de id alta venta
	        $id = $this->maltaventa->getCampo("idProyecto",$id);
	        $info = $this->mproyecto->getById($id);
	        $data = $info;
	        $data['etapa_alta_venta'] = false;
	        $data['etapa_validacion_venta'] = false;
	        $data['etapa_gestoria'] = false;
	        $data['etapa_comisionbono'] = false;
	        $data['etapa_autorizaciones'] = false;
	        $data['etapa_deposito'] = false;
	        $data['etapa_entrega'] = false;
	        $data['etapa_encuesta'] = false;
	        $data['etapa_postventa'] = false;

	        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
	        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
	        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';

	/*        switch ($statusProyecto) {
	            case '0':
	                $data['etapa_alta_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
	                break;
	            case '1':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '2':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
	                break;
	            case '3':
	            case '4':
	            case '5':
	                $data['etapa_alta_venta'] = true;
	                $data['etapa_validacion_venta'] = true;
	                $data['etapa_gestoria'] = true;
	                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

	                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
	                if ( !is_numeric($comisiones) ) {
	                    $data['etapa_comisionbono'] = true;
	                    $data['detalle_comisionbono'] = $comisiones;

	                }

	                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($autorizaciones) ) {
	                    $data['etapa_autorizaciones'] = true;
	                    $data['detalle_autorizaciones'] = $autorizaciones;
	                }

	                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($deposito) ) {
	                    $data['etapa_deposito'] = true;
	                    $data['detalle_deposito'] = $deposito;
	                }

	                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_entrega'] = true;
	                    $data['detalle_entrega'] = $entrega;
	                }

	                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($entrega) ) {
	                    $data['etapa_encuesta'] = true;
	                    $data['detalle_encuesta'] = $encuesta;
	                }

	                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
	                if ( !is_numeric($postventa) ) {
	                    $data['etapa_postventa'] = true;
	                    $data['detalle_postventa'] = $postventa;
	                }
	                break;
	            default:

	                break;
	        }*/

	        $data['etapa_alta_venta'] = true;
            $data['etapa_validacion_venta'] = true;
            $data['etapa_gestoria'] = true;
            $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

	        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
	        $data['mpromotor'] = $this->musuario;
	        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
	        $data['mprototipos'] = $this->mprototipos;
	        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);
	    }

	    public function getInfoVenta(){ //obtenenmos los datos de venta (vivienda que ya está validada por gestoría)
        	$id = $this->input->post('idProyecto', TRUE);
        	if ($id > 0){
        		$info = $this->maltaventa->getGestoriaByIdProy($id);
        		if (!is_numeric($info)){
        			$data['id'] = $info['id'];//id en tabla alta venta
        			$data['idProyecto'] = $info['idProyecto'];
        			$avaluo = $info['avaluo'];
        			$data['avaluo'] = precio_format($avaluo);
        			$precioVentaOci = $info['precioVentaOci'];
        			$data['precioVentaOci'] = precio_format($precioVentaOci);
        			$precioVenta = $info['precioVenta'];
        			$data['precioVenta'] = precio_format($precioVenta);
        			$montoFinal = $info['sumaFinal'];
        			$data['montoFinal'] = precio_format($montoFinal);
        			$data['difPropioPeculio'] = precio_format($info['precioVentaOci'] - $info['sumaFinal']);
        			$data['numeroCredito'] = $info['numeroCredito'];
        			$resultado = $info['sumaFinal'] - $info['precioVenta'];
        			$data['resultado'] = precio_format($resultado);
        			$bonoPresupuestoInicial = $info['bonoEquipamiento'];
        			$data['bonoPresupuestoInicial'] = precio_format($bonoPresupuestoInicial);
        			$saldo = $resultado - $bonoPresupuestoInicial;
        			$data['saldo'] = precio_format($saldo);
        			$cierre = $montoFinal - $data['bonoPresupuestoInicial'];
        			$data['cierre'] = precio_format($cierre);
        			$data['nombrePromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
        			$data['tipoPromotor'] = $this->musuario->getCampo("tipoPromotor",$info['idPromotor']);
        			$data['comision'] = $this->musuario->getCampo("comision",$info['idPromotor']);
        			$importeComision = $cierre * $data['comision']/100;
        			$data['importeComision'] = precio_format($importeComision);
        			$netoVenta = $cierre - $importeComision;
        			$data['netoVenta'] = precio_format($netoVenta);
        			$data['fecha'] = date_format(new DateTime($info['fecha']),'d/m/Y');
        			$data['success'] = 1;
        		}else{
        			$data['success'] = 0;
        		}
        	}else{
        		$data['success'] = 0;
        	}
        	echo json_encode($data);
	    }


        public function eliminar_archivo()
	    {

	        if (isset($_POST['elid'])){
	            $id = $this->input->post('elid');
	            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
	            if($campo !="0"){
	                $archivo = $this->mgestoria->getCampo('pdf_'.$campo,$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf_'.$campo] ='';
	                    $this->mgestoria->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }else{
	                $archivo = $this->mgestoria->getCampo('pdf',$id);
	                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
	                    $c_data['pdf'] ='';
	                    $this->mgestoria->actualizar($c_data,$id);
	                    $c_valor = "true";
	                    //$this->msomos->borrar($id);
	                }else{ $c_valor = "false";}
	            }
	            $data = json_encode(array("valor"=>$c_valor));
	            echo $data;

	        }
	    }

	    function autoRespuesta( $gestoria = null ) {

        	$copiasNV = 'hsalinas@viviend.mx'. ', ';
        	$copiasNV .= 'esalinas@viviend.mx'. ', ';
        	$copiasNV .= 'mejora@viviend.mx'. ', ';
        	$copiasNV .= 'sistemas@viviend.mx';

	        $alta_venta = $this->maltaventa->getById($gestoria['idAltaVenta']);
	        $prospecto = $this->mprospecto->getById($this->maltaventa->getCampo("idProspecto",$gestoria['idAltaVenta']));
	        $proyecto = $this->mproyecto->getById($this->maltaventa->getCampo("idProyecto",$gestoria['idAltaVenta']));
	        $promotor = $this->musuario->getById($this->maltaventa->getCampo("created_by",$gestoria['idAltaVenta']));
	        // $gerente = $this->musuario->getById($this->musuario->getGerente());
	        $gerente = $this->musuario->getById($this->musuario->getGerente2($proyecto['idFraccionamiento']));
	        $notaria = $this->mnotaria->getById($alta_venta['idNotaria']);
	        $gestor = $this->musuario->getById($_SESSION[$this->nsession]['id']);//$_SESSION[$this->nsession]['rol']


	        $subject = 'Notificación sobre ingreso de expediente | Gestoria'; // titulo

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $proyecto['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $cuerpo = '';


	        /*-------------------------------------------------CLIENTE-------------------------------------------------------------------*/
	        $cuerpo .= '
	        <table id="table-cliente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Cliente</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Lote:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['lote'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"># Paquete:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['numPaquete'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio Venta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['precioVenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Avaluo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['avaluo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Promotor:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
	        		</tr>
	        			<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Gerente:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente['nombre'].' '.$gerente['apellidoP'].' '.$gerente['apellidoM'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Tipo Credito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['precioVentaOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['montoOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subCuenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['gastosTitulacion'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['ahorroVol'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subsidio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['sumaFinal'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------Promotor----------------------------------------------------------------------*/

	    	/*$cuerpo .= '
	        <table id="table-promotor" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Promotor</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Gerente----------------------------------------------------------*/

	        /*$cuerpo .= '
	        <table id="table-gerente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Gerente de ventas</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Gerente:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente['nombre'].' '.$gerente['apellidoP'].' '.$gerente['apellidoM'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Gestoria----------------------------------------------------------*/

	        /*$cuerpo .= '
	        <table id="table-gestoria" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos gestoría</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Tipo Credito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha de ingreso:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaIngreso']), 'd/m/Y').'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Montos----------------------------------------------------------*/

	    	/*$cuerpo .= '
	        <table id="table-montos" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">$ Montos</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['precioVentaOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['montoOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subCuenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['gastosTitulacion'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['ahorroVol'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subsidio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['sumaFinal'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img width="280" src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Proyecto con estatus DTU </h1>-->
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Ingreso de expediente </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$gestor['nombre'].' '.$gestor['apellidoP'].' '.$gestor['apellidoM'].' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el promotor -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

			//mail para gerente
	        //$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($proyecto['idFraccionamiento']));
	        if($this->appProduction){
				$qGerentes = $this->musuario->getGerentes2($proyecto['idFraccionamiento']);
				if( !is_numeric($qGerentes) ){
					foreach($qGerentes->result() as $gteV){
						$para = $this->musuario->getCampo("email", $gteV->id);
						if ($para){
							mail($para, $subject, $mensaje, $cabeceras);
						}
					}
				}

	        	$dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($proyecto['idFraccionamiento']);
	            if ( !is_numeric($dGestores) ) {
	                foreach ($dGestores->result() as $row) {
	                	mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
	                }
	            }
		        // para el gerente  -------------------------------------------------
		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // Copy developer  -------------------------------------------------
		        $subject2 = 'Viviend - Notificación sobre ingreso de expediente | Gestoria | Copia';
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
		     }else{
	     		mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             	mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);
             	mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);
		     }
	        // echo $mensaje;exit();
	        return true;
	    }

	    function autoRespuestaCertificado( $gestoria = null ) {

        	$copiasNV = 'hsalinas@viviend.mx'. ', ';
        	$copiasNV .= 'sistemas@viviend.mx';

	        $alta_venta = $this->maltaventa->getById($gestoria['idAltaVenta']);
	        $prospecto = $this->mprospecto->getById($this->maltaventa->getCampo("idProspecto",$gestoria['idAltaVenta']));
	        $proyecto = $this->mproyecto->getById($this->maltaventa->getCampo("idProyecto",$gestoria['idAltaVenta']));
	        $promotor = $this->musuario->getById($this->maltaventa->getCampo("created_by",$gestoria['idAltaVenta']));
	        // $gerente = $this->musuario->getById($this->musuario->getGerente());
	        //$gerente = $this->musuario->getById($this->musuario->getGerente2($proyecto['idFraccionamiento']));
			$qGerentes = $this->musuario->getGerentes2($proyecto['idFraccionamiento']);
			$gerente = '';
			if( !is_numeric($qGerentes) ){
				foreach($qGerentes->result() as $gteV){
					$qGerente = $this->musuario->getById($gteV->id);
					if( !is_numeric($qGerente) ){
						$gerente = $gerente.$qGerente['nombre'].' '.$qGerente['apellidoP'].' '.$qGerente['apellidoM'].', ';
					}
				}
			}
			if( !empty($gerente) ){
				$gerente = substr($gerente, 0, -2);
			}
	        $notaria = $this->mnotaria->getById($alta_venta['idNotaria']);
	        $gestor = $this->musuario->getById($_SESSION[$this->nsession]['id']);//$_SESSION[$this->nsession]['rol']


	        $subject = 'Notificación sobre ingreso de expediente | Gestoria'; // titulo

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $proyecto['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $cuerpo = '';


	        /*-------------------------------------------------CLIENTE-------------------------------------------------------------------*/
	        $cuerpo .= '
	        <table id="table-cliente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Cliente</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Lote:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['lote'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;"># Paquete:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['numPaquete'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio Venta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['precioVenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Avaluo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$proyecto['avaluo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Promotor:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Gerente:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente.'</td>
	        		</tr>
	        			<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha de ingreso:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaIngreso']), 'd/m/Y').'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
	        		</tr>
	        			<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['precioVentaOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['montoOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subCuenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['gastosTitulacion'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['ahorroVol'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subsidio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['sumaFinal'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------Promotor----------------------------------------------------------------------*/

	    	/* $cuerpo .= '
	        <table id="table-promotor" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Promotor</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Promotor:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Gerente----------------------------------------------------------*/

		    /*$cuerpo .= '
	        <table id="table-gerente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Gerente de ventas</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Nombre Gerente:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gerente['nombre'].' '.$gerente['apellidoP'].' '.$gerente['apellidoM'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Gestoria----------------------------------------------------------*/

	       /* $cuerpo .= '
	        <table id="table-gestoria" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos gestoría</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['statusGestoria'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$alta_venta['tipoCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Aplica folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['aplicaFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Número de crédito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['numeroCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha de ingreso:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaIngreso']), 'd/m/Y').'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['certificadoLibertad'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['constanciaNoAdeudo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Notaría:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$notaria['nombre'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Fecha firma:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/

	        /*----------------------------------------------------------Montos----------------------------------------------------------*/
			/*
	        $cuerpo .= '
	        <table id="table-montos" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">$ Montos</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['precioVentaOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Monto OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['montoOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subcuenta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subCuenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['gastosTitulacion'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['ahorroVol'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Subsidio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['subsidio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 14px;color: #548C43;font-weight: 800;">Suma final:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 13px;color: #8C8C8C;">'.$gestoria['sumaFinal'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';*/


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img width="280" src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Proyecto con estatus DTU </h1>-->
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Ingreso de expediente </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$gestor['nombre'].' '.$gestor['apellidoP'].' '.$gestor['apellidoM'].' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el promotor -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

			//mail para gerente
	    	/*$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($proyecto['idFraccionamiento']));
	        if ($para){
            	mail($para, $subject, $mensaje, $cabeceras);
        	}
        	$dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($proyecto['idFraccionamiento']);
            if ( !is_numeric($dGestores) ) {
                foreach ($dGestores->result() as $row) {
                	mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
                }
            }*/
	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        // Copy developer  -------------------------------------------------
	        $subject2 = 'Viviend - Notificación sobre ingreso de expediente | Gestoria | Copia';

	        if($this->appProduction){
	        	mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
	        } else{
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);    
	            mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);    
	        }
	        //echo $mensaje;exit();
	        return true;
	    }

	    public function cancelProcess()
	    {
	    	$idGestoria = $this->input->post('idGestoria', TRUE);
	    	$idMotivo = $this->input->post('idMotivo', TRUE);
	    	$motivoCancelacion = $this->input->post('motivoCancelacion', TRUE);
	    	if ( $idGestoria != null && $idGestoria != '' && $idGestoria > 0) {
	    		$idAltaVenta = $this->mgestoria->getCampo("idAltaVenta",$idGestoria);
		    	$idProyecto = $this->maltaventa->getCampo("idProyecto",$idAltaVenta);
		    	$idProspecto = $this->maltaventa->getCampo("idProspecto",$idAltaVenta);
		    	// $alta_venta = $this->maltaventa->getById($idAltaVenta);
		    	$dateCancel = date('Y-m-d');

		    	$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdProyectoProspecto($idProyecto,$idProspecto);

		    	//penmdiente un update status 0 en prospectos

		    	$autores = $this->autoRespuestaCancel($idGestoria);
		    	// exit();
		    	$this->db->trans_start();
		    	$r['gestoria'] = $this->db->query("UPDATE gestoria SET status = 0, statusGestoria = '', motivoCancelacion = '".$motivoCancelacion."', idMotivo = '".$idMotivo."', fechaCancelacion = '".$dateCancel."' WHERE id=".$idGestoria);
		    	$r['alta_venta'] = $this->db->query("UPDATE alta_venta SET status=0, statusValidacion=0, statusValidacion2='' WHERE id=".$idAltaVenta);
		    	$this->db->query("UPDATE alta_venta SET idProyecto=NULL WHERE id=".$idAltaVenta);
		    	$r['proyecto'] = $this->db->query("UPDATE proyectos SET statusVenta=0 WHERE id=".$idProyecto);
		    	$r['prospecto'] = $this->db->query("UPDATE prospectos SET status=0 WHERE id=".$idProspecto);
		    	$r['area_status'] = $this->db->query("DELETE FROM area_status WHERE idAltaVenta=".$idAltaVenta);
		    	if (!is_numeric($rowAvaluoProyecto)){
		    		$ap['statusAsignacion'] = 0;
		    		$this->mavaluoproyecto->actualizar($ap,$rowAvaluoProyecto['id']);
		    	}
		    	$this->db->trans_complete();
		    	$response = array(
		    		'success' => TRUE,
		    		'idGestoria' => $idGestoria,
		    		'idAltaVenta' => $idAltaVenta,
		    		'idProyecto' => $idProyecto,
		    		'responseUpd' => $r,
		    		'responseMail' =>$autores
		    	);
	    	}
	    	else {
	    		$response = array(
	    			'success' => FALSE,
	    			'msg' => 'Id gestoria con valor null'
	    		);
	    	}
	    	echo json_encode( $response );
	    }

	    function autoRespuestaCancel( $idGestoria = null ) {
	        /*$copiasNV = 'sistemas@viviend.mx, ';
	        $copiasNV .= 'ruben@navegantes.mx';*/
	        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        	$copiasNV .= 'esalinas@viviend.mx';

	        $gestoria = $this->mgestoria->getById($idGestoria);
	        $idAltaVenta = $gestoria['idAltaVenta'];
	        $alta_venta = $this->maltaventa->getById($idAltaVenta);
	        $idProspecto = $this->maltaventa->getCampo("idProspecto",$idAltaVenta);
	        $prospecto = $this->mprospecto->getById($idProspecto);

	        $idProyecto = $this->maltaventa->getCampo("idProyecto",$idAltaVenta);

	        $proyecto = $this->mproyecto->getById($idProyecto);

	        $promotor = $this->musuario->getById($this->maltaventa->getCampo("created_by",$idAltaVenta));
	        // $gerente = $this->musuario->getById($this->musuario->getGerente());
	        //$idGerente = $this->musuario->getGerente2($proyecto['idFraccionamiento']);
	        //$gerente = $this->musuario->getById($idGerente);
			$qGerentes = $this->musuario->getGerentes2($proyecto['idFraccionamiento']);
			$gerente = '';
			if( !is_numeric($qGerentes) ){
				foreach($qGerentes->result() as $gteV){
					$qGerente = $this->musuario->getById($gteV->id);
					if( !is_numeric($qGerente) ){
						$gerente = $gerente.$qGerente['nombre'].' '.$qGerente['apellidoP'].' '.$qGerente['apellidoM'].', ';
					}
				}
			}
			if( !empty($gerente) ){
				$gerente = substr($gerente, 0, -2);
			}

	        $notaria = $this->mnotaria->getById($alta_venta['idNotaria']);
	        $gestor = $this->musuario->getById($_SESSION[$this->nsession]['id']);


	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $proyecto['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
	        $cuerpo = '';
	        $arrRespo = array();


	        /*-------------------------------------------------CLIENTE-------------------------------------------------------------------*/
	        $cuerpo .= '
	        <table id="table-cliente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Cliente</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Lote:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$proyecto['lote'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"># Paquete:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$proyecto['numPaquete'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Precio Venta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$proyecto['precioVenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Avaluo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$proyecto['avaluo'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------Promotor----------------------------------------------------------------------*/

	        $cuerpo .= '
	        <table id="table-promotor" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Promotor</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$promotor['nombre'].' '.$promotor['apellidoP'].' '.$promotor['apellidoM'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------------------Gerente----------------------------------------------------------*/

	        $cuerpo .= '
	        <table id="table-gerente" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Gerente de ventas</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Nombre:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gerente.'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------------------Gestoria----------------------------------------------------------*/

	        $cuerpo .= '
	        <table id="table-gestoria" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">Datos gestoría</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['statusGestoria'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Estatus:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$alta_venta['tipoCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Aplica folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['aplicaFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Número de folio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['numeroFolio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Número de crédito:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['numeroCredito'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Fecha de ingreso:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.date_format(new DateTime($gestoria['fechaIngreso']), 'd/m/Y').'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Certificado de libertad:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['certificadoLibertad'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Constancia de no adeudo:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['constanciaNoAdeudo'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Notaría:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$notaria['nombre'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Fecha firma:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.date_format(new DateTime($gestoria['fechaFirma']), 'd/m/Y').'</td>
	        		</tr>
	        	</tbody>
	        </table>';

	        /*----------------------------------------------------------Montos----------------------------------------------------------*/

	        $cuerpo .= '
	        <table id="table-montos" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;margin-top:50px;">
	        	<thead>
	        		<tr>
	        			<th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">$ Montos</th>
	        		</tr>
	        	</thead>
	        	<tbody>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Precio venta OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['precioVentaOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Monto OCI:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['montoOci'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Subcuenta:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['subCuenta'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Gastos de titulación:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['gastosTitulacion'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Ahorro voluntario:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['ahorroVol'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Subsidio:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['subsidio'].'</td>
	        		</tr>
	        		<tr>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">Suma final:</td>
	        			<td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;">'.$gestoria['sumaFinal'].'</td>
	        		</tr>
	        	</tbody>
	        </table>';


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img width="280" src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;"> Proyecto con estatus DTU </h1>-->
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Cancelación de proceso </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$gestor['nombre'].' '.$gestor['apellidoP'].' '.$gestor['apellidoM'].' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el promotor -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $subject = 'Cancelación de proceso | Gestoria'; // titulo

	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";
	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        $para = $promotor['email'];

	        // para el gerente  -------------------------------------------------
	        $subject2 = 'Cancelación de proceso | Gestoria';

	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        // para el Gerente
	        //$arrRespo['gerente'] = mail($gerente['email'], $subject2, $mensaje, $cabecerasAdmin);
	         if($this->appProduction){

		        if ($para !=null){
	            	$arrRespo['promotor'] = mail($para, $subject, $mensaje, $cabeceras);
	        	}

	            $qGerentes = $this->musuario->getGerentes2($idFraccionamiento);
	            if( !is_numeric($qGerentes) ){
	                foreach($qGerentes->result() as $gteV){
	                    $para = $this->musuario->getCampo("email", $gteV->id);
	                    if ($para){
	                        $arrRespo['gerente'] = mail($para, $subject2, $mensaje, $cabecerasAdmin);
	                    }
	                }
	            }

		        // para el gestor  -------------------------------------------------
		        $arrRespo['gestor'] = mail($gestor['email'], $subject2, $mensaje, $cabecerasAdmin);


		        // para el gerente  -------------------------------------------------
		        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
		        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

		        // Cabeceras adicionales
		        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

		        // Copy developer  -------------------------------------------------
		        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

		        return $arrRespo;
		    } else{
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);    
	            mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);    
	            mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);

	            return true;    
	        }

	        
	    }
	}
 ?>