<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Estimadoxdia extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'estimadoxdia'; // form validation variable
            $this->mainView = 'estimadoxdia';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/estimadoxdia/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mestimadoxdia','mestimacion','mestimaciones','mestimados','musuario','mfraccionamiento','mprototipoxfraccionamiento','mprototipos', 'mpaquete', 'mcategoriamo', 'mactividadmo', 'mactividadesprototipo', 'mpresupuestomo', 'mconstructores', 'munidades', 'mmanoobra', 'mavanceobra'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));
            //$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
           valSession("obra",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->mestimacion->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'idFraccionamiento' => ($row->idFraccionamiento != '')? $this->mfraccionamiento->getCampo('titulo',$row->idFraccionamiento):'',
                    'idPrototipo' => ($row->idPrototipo != '')? $this->mprototipos->getCampo('nombre',$row->idPrototipo):'',
                    'estimaciones' =>  ($row->idPrototipo != '')? $this->mprototipos->getCampo('estimaciones',$row->idPrototipo):'',
                    'paquete' => ($row->idPaquete != '')? $this->mpaquete->getCampo('titulo',$row->idPaquete):'',
                    'acciones' => accionesEstimaciones($row->id,$this->router->class,false, false, true, true)
                );
            }
        } else{
            $array['aaData'][] = array(
                'idFraccionamiento' => 'No hay registros',
                'idPrototipo' => 'No hay registros',
                'estimaciones' => 'No hay registros',
                'paquete' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }
        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes}
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data['fraccionamientos'] = $this->mfraccionamiento->getAll();
            $idFraccionamiento = $this->input->post('idFraccionamiento', TRUE);
            if ($idFraccionamiento != '' && $idFraccionamiento > 0 ) {
                $data['prototipos'] =  $this->getPrototiposByFraccForSelect($idFraccionamiento);
                $idPrototipo = $this->input->post('idPrototipo', TRUE);
                if($idPrototipo != '' && $idPrototipo > 0){
                    $data['paquetes'] =  $this->getPaquetesByFraccProtForSelect($idFraccionamiento, $idPrototipo);
                }
            }
            else {
                $data['paquetes'] = [];
                $data['prototipos'] = [];
            }
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
            $pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
            $pData['idPaquete'] = $this->input->post('idPaquete', TRUE);

            $pData['status'] = 1;
            $id = $this->mestimacion->insertar($pData);
            set_time_limit(300);

            if(is_numeric($id)){
                $eData['idEstimacion'] = $id;
                $contar = $this->input->post('estimaciones', TRUE);
                $fecha_inicio = new DateTime($this->mpaquete->getCampo('fecha_inicio', $pData['idPaquete']));
                $intervalo = new DateInterval('P7D');
                $qManoObra = $this->mmanoobra->getByIdPaquete($pData['idPaquete']);
                // Aqui empieza el guardado de las estimaciones en base al prototipo
                for ($i=1; $i <= $contar; $i++) {
                    $eData['nEstimacion'] = $i;
                    $eData['fecha'] = $fecha_inicio->format('Y-m-d');
                    //aqui se suma la semana
                    $fecha_inicio->add($intervalo);
                    $idE = $this->mestimaciones->insertar($eData);
                    if(is_numeric($idE)){
                        //Aqui empieza el guardado de estimados por estimaciones (Estimacion 1, estimacion 2, etc.)
                        $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($pData['idPrototipo']);
                        foreach ($qCatProt->result() as $CategoriaProt) {
                            $qActProt = $this->mactividadesprototipo->getAllByPrototipoCategoria($pData['idPrototipo'], $CategoriaProt->idCategoria);
                            foreach ($qActProt->result() as $ActividadProt) {
                                $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($qManoObra['id'], $ActividadProt->id);
                                $esData['estimacion'] = 0;
                                $esData['idEstimaciones'] = $idE;
                                $esData['idPresupuesto'] = $qPresupuesto['id'];
                                $idE2 = $this->mestimados->insertar($esData);
                                $avData['idEstimado'] = $idE2;
                                $idA = $this->mavanceobra->insertar($avData);
                            }
                        }
                    }
                }
            }
            redirect($this->router->class);
        }
    }

    public function detalle($id = null){
        $data['id'] = $id;
        $idPaquete = $this->mestimacion->getCampo('idPaquete', $id);
        $idPrototipo = $this->mestimacion->getCampo('idPrototipo', $id);
        $idFraccionamiento = $this->mestimacion->getCampo('idFraccionamiento', $id);
        $qPaquete = $this->mpaquete->getById($idPaquete);
        // Datos generales
        if(!is_numeric($qPaquete)){
            $paquete = array('titulo' => $qPaquete['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento), 
                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
                'manzana' => $qPaquete['manzana'],
                'fecha_inicio' => $qPaquete['fecha_inicio'],
                'fecha_fin' => $qPaquete['fecha_fin']
            );
            $idContratista = $qPaquete['fecha_inicio'];
            $lotes = contarLotes($qPaquete['rango_lotes']);
        }
        $data['paquete'] = $paquete;
        // No. de estimaciones (Estimacion1, estimacion 2, etc...)
        $qEstimaciones = $this->mestimaciones->getByIdEstimacion($id);
        if(!is_numeric($qEstimaciones)){
            foreach ($qEstimaciones->result() as $estis) {
                $estimaciones[] = array('id' => $estis->id,
                    'nEstimacion' => $estis->nEstimacion,
                    'fecha' => $estis->fecha
                );
            }
        }
        $data['estimaciones'] = $estimaciones;
        // Aquí empieza el guardado de actividates por estimacion.
        $qManoObra = $this->mmanoobra->getByIdPaquete($idPaquete);
        $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($idPrototipo);
        if(!is_numeric($qCatProt)){
            // Se separan por categoria
            foreach ($qCatProt->result() as $CategoriaProt) {
                $qActProt = $this->mactividadesprototipo->getAllByPrototipoCategoria($idPrototipo, $CategoriaProt->idCategoria);
                $actividades = array();
                if(!is_numeric($qActProt)){
                    $precioUC = 0;
                    $importeC = 0;
                    $porPackC = 0;
                    $pendiPagarC = 0;
                    $acuPagarC = 0;
                    // Aqui separara por actividades
                    foreach ($qActProt->result() as $ActividadProt) {
                        $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                        $estimados = array();
                        $pendiPagar = 0;
                        $pendiLotes = 0;
                        if(!is_numeric($qActividad)){
                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($qManoObra['id'], $ActividadProt->id);
                            $qEstimado = $this->mestimados->getAllByIdPresupuesto($qPresupuesto['id']);
                            $precioUnitario = ($qPresupuesto['precioUnitario'] > 0)? $qPresupuesto['precioUnitario']: '';
                            if(!is_numeric($precioUnitario)){
                                $tipoC = $this->mconstructores->getCampo('tipoConstructor', $idContratista);
                                $precioUnitario = ($tipoC == 1)? $qActividad['precioUnitarioContratista'] : $qActividad['precioUnitarioDestajista'];
                            }
                            $porPaquete = $lotes * $qPresupuesto['importe'];
                            // Aqui va a llenar los estimados por actividad
                            if(!is_numeric($qEstimado)){
                                $acuPagar = 0;
                                $acuLotes = 0;
                                foreach ($qEstimado->result() as $esdos) {
                                    $pagar = $esdos->estimacion * $qPresupuesto['importe'];
                                    $estimados[$esdos->idEstimaciones] = array('id' => $esdos->id,
                                        'clave' => $qActividad['clave'],
                                        'descripcion' => $qActividad['descripcion'],
                                        'lotes' => $esdos->estimacion,
                                        'estimacion' => $pagar
                                    );
                                }
                            }
                            $acuLotes = $this->mestimados->getLotesGuardados($qPresupuesto['id']);
                            $acuPagar = $qPresupuesto['importe'] * $acuLotes;
                            $pendiPagar = $porPaquete - $acuPagar;
                            //Al guardar el array de actividad, tendra todos los estimados de una vez.
                            $actividades[] = array('id' => $ActividadProt->idActividad,
                                'clave' => $qActividad['clave'],
                                'descripcion' => $qActividad['descripcion'],
                                'unidad' => ($qActividad['idUnidad'] > 0)? $this->munidades->getCampo('abreviatura', $qActividad['idUnidad']) : 'N/A',
                                'cantidad' => $ActividadProt->cantidad,
                                'precioU' => $precioUnitario,
                                'importe' => $qPresupuesto['importe'],
                                'xPaquete' => $porPaquete,
                                'acuPagar' => $acuPagar,
                                'acuLotes' => $acuLotes,
                                'pendiPagar' => $pendiPagar,
                                'pendiLotes' => $lotes - $acuLotes,
                                'estimados' => $estimados
                            );
                            $precioUC = $precioUC + $precioUnitario;
                            $importeC = $importeC + $qPresupuesto['importe'];
                            $porPackC = $porPackC + $porPaquete;
                            $acuPagarC = $acuPagarC + $acuPagar;
                            $pendiPagarC = $pendiPagarC + $pendiPagar;
                        }
                    }
                    //El array de categorias traera el array de actividades que le pertenecen.
                    $categorias[] = array( 'id' => $CategoriaProt->idCategoria,
                        'clave' => $this->mcategoriamo->getCampo('clave', $CategoriaProt->idCategoria),
                        'categoria' => $this->mcategoriamo->getCampo('categoria', $CategoriaProt->idCategoria),
                        'actividades' => $actividades,
                        'precioU' => $precioUC,
                        'importe' => $importeC,
                        'xPaquete' => $porPackC,
                        'acuPagar' => $acuPagarC,
                        'pendiPagar' => $pendiPagarC,

                    );
                }
            }
        }
        $data['categorias'] = $categorias;
        $this->data['contenido'] = $this->load->view($this->mainView . '/detalle_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mestimacion->getById($id);
        $cValor = "true";
        $qEstimaciones = $this->mestimaciones->getByIdEstimacion($id);
        if(is_numeric($qEstimaciones)){
            foreach ($qEstimaciones->result() as $esti) {
                $qEstimado = $this->mestimados->getAllByIdEstimaciones($esti->id);
                if(is_numeric($qEstimaciones)){
                    foreach ($qEstimado->result() as $edos) {
                        $qAvance = $this->mavanceobra->getAllByIdEstimado($edos->id);
                        if(is_numeric($qEstimaciones)){
                            foreach ($qAvance->result() as $ava) {
                                $valorBorrar = $this->mavanceobra->borrar($ava->id);
                            }
                        }
                        $valorBorrar = $this->mestimaciones->borrar($edos->id);
                    }
                }
                $valorBorrar = $this->mestimaciones->borrar($esti->id);
            }
        }
        $valorBorrar = $this->mestimacion->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function getPrototiposByFraccForSelect($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $response[$value->idPrototipo] = $this->mprototipos->getCampo('nombre',$value->idPrototipo);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPaquetesByFraccProtForSelect($idFrac='',$idProt='')
    {
        $paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo2($idFrac, $idProt);
        $array = array();
        $response = array();
        if ( !is_numeric($paquetes) ) {
            foreach ($paquetes->result() as $key => $value) {
                $response[$value->id] = $value->titulo;
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPaquetesByFraccProt($idFrac='',$idProt='')
    {
        $paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo2($idFrac, $idProt);
        $array = array();
        $response = array();
        if ( !is_numeric($paquetes) ) {
            foreach ($paquetes->result() as $key => $value) {
                $array = array(
                    'id' => $value->id,
                    'titulo' => $value->titulo,
                    'estimaciones' => $this->mprototipos->getCampo('estimaciones',$idProt)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function actualizar()
    {
        $vacio = true;
        $err = '';
        $errores = false;
        $datitos['valor'] = $_POST['valor'];
        // Error por si ponen otra cosa que no sea un numero
        if(!is_numeric($_POST['valor'])){
            $vacio = true;
            $errores = true;
        }
        //Si es numero, verificara que no se pase de lotes
        else{
            $idPresuxEstimado = $this->mestimados->getCampo('idPresupuesto', $_POST['id']);
            // Cuantos lotes hay por esta actividad (con idPresupuesto)
            $estimacionxPresupuesto = $this->mestimados->getLotesGuardados($idPresuxEstimado);
            $anterior = $this->mestimados->getCampo('estimacion', $_POST['id']);
            // La "suma" resta los lotes que habia agregado en este estimado, a los lotes que ya habia en total por actividad y sumara el nuevo valor del estimado 
            $suma = ($estimacionxPresupuesto - $anterior) + $_POST['valor'];
            $idMO = $this->mpresupuestomo->getCampo('idManoObra', $idPresuxEstimado);
            $idPack = $this->mmanoobra->getCampo('idPaquete', $idMO);
            $lotes = contarLotes($this->mpaquete->getCampo('rango_lotes', $idPack));
            $idActiProt = $this->mpresupuestomo->getCampo('idActividadPrototipo', $idPresuxEstimado);
            // Varifica que los lotes no vayan a sobrepasar los puestos por el paquete
            if($suma > $lotes && $anterior != $_POST['valor']){
                $errores = true;
                $idActi = $this->mactividadesprototipo->getCampo('idActividad', $idActiProt);
                $err = $err . 'LA ACTIVIDAD ' . ' CON LA CLAVE ' . $this->mactividadmo->getCampo('clave', $idActi) . ' NO PUDO ACTUALIZARSE. <br/>';
            }
        }
        if($errores){
            // Valores para el modal en caso de un error (no sea numero o no puede agregar mas lotes)
            $datitos['valor'] = 'error';
            $err = $err . '<br/>ASEGURESE DE QUE LOS LOTES QUE ESTA INGRESANDO NO REVASEN EL NÚMERO DE LOTES EN EL PAQUETE.';
            $datitos['titulo'] = 'ERROR AL ACTUALIZAR';
            $datitos['texto'] = '<p>A OCURRIDO UN ERROR AL MOMENTO DE ACTUALIZAR LA ESTIMACIÓN.<br/>
                        INTENTELO OTRA VEZ.</p>' . $err;
        }
        else{
            //Si no hay errores, puede continuar con la actualizacion
            $pData['estimacion'] = $_POST['valor'];
            $this->mestimados->actualizar($pData, $_POST['id']);
             //Va a llamar a todos los estimados en base al presupuesto para obtener los que se cambiaran en la tabla
            $estimadosxP = $this->mestimados->getAllByIdPresupuesto($idPresuxEstimado);
            foreach ($estimadosxP->result() as $key) {
                $ids[] = $key->id;
            }
            $importe = $this->mpresupuestomo->getCampo('importe', $idPresuxEstimado);
            $datitos['ids'] = $ids;
            // lo que se pagaría por por estimado
            $datitos['estimacion'] = $_POST['valor'] * $importe;
            // cambios que se haran por actividad
            $datitos['acuLotes'] = $suma;
            $datitos['acuPagar'] = $suma  * $importe;
            $datitos['pendiLotes'] = $lotes - $suma;
            $datitos['pendiPagar'] = ($lotes * $importe) - $datitos['acuPagar'];
            $idCategoria = $this->mactividadesprototipo->getCampo('idCategoria', $idActiProt);
            $idPrototipo = $this->mactividadesprototipo->getCampo('idPrototipo', $idActiProt);
            // id de la categoria que se va a modificar en la tabla
            $datitos['categoria'] = $idCategoria;
            $qActividades = $this->mactividadesprototipo->getAllByPrototipoCategoria($idPrototipo, $idCategoria);
            $acuPagarC = 0;
            $pendiPagarC = 0;
            // Son las actividades de la categoria que se actualiza
            foreach ($qActividades->result() as $actividad) {
                $presT = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idMO, $actividad->id);
                $ltT = $this->mestimados->getLotesGuardados($presT['id']);
                $acuPagarT = $ltT * $presT['importe'];
                $acuPagarC = $acuPagarC + $acuPagarT;
                $pendiPagarT = ($lotes * $presT['importe']) - $acuPagarT;
                $pendiPagarC = $pendiPagarC + $pendiPagarT;
            }
            $datitos['acuPagarC'] = $acuPagarC;
            $datitos['pendiPagarC'] = $pendiPagarC;
            $datitos['valor'] = 'correcto';
            $datitos['titulo'] = 'DATOS ACTUALIZADOS';
            $datitos['texto'] = 'SE HAN GUARDADO LOS CAMBIOS.';
        }

        echo json_encode($datitos);
    }
}


