<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Estimaciones_programa extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'estimaciones_programa'; // form validation variable
            $this->mainView = 'estimaciones_programa';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/estimaciones_programa/listado.js?v=0.7" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mestimacionprograma','mestimacionesprograma', 'mestimadosprograma','musuario','mfraccionamiento',
            'mprototipoxfraccionamiento','mprototipos', 'mconstructores','mpaquete', 'mdetallepaquete', 'mcategoriamo', 'mactividadmo', 
            'mactividadesprototipo', 'mpresupuestomo', 'munidades', 'mmanoobra', 'mavanceobra', 'mproyecto', 'mpaquetepresupuesto', 'mordenpago', 
            'mdetalleop','marranque','mestimaciones_ss'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            $this->load->library('excel');
            // Lbrerias
            // $this->load->library(array('email','session'));
            //$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
            valSession("obra",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->mestimaciones_ss->get_datatables();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $eliminar=true;
                $qArranque = $this->db->query("SELECT * FROM arranque WHERE status = 1 AND FIND_IN_SET('$row->idPaquete',idPaquetes) AND estatus_arranque > 1");
                if($qArranque->num_rows() > 0){
                    $eliminar=false;
                }
                $idMO = ($row->idPaquete != '')? $this->mpaquete->getCampo('idManoObra', $row->idPaquete) : '';
                $qMO = (is_numeric($idMO))? $this->mmanoobra->getById($idMO) : 0;
                //totales
                $totalPMO=0;
                $MOPagado=0;
                $rango_lotes = $this->mpaquete->getCampo('rango_lotes', $row->idPaquete);
                if( !empty($rango_lotes) ){
                    $lotesManzana = contarLotesManzanas($rango_lotes);
                    $lotes = $lotesManzana['total'];
                    $idMO = $this->mpaquete->getCampo('idManoObra', $row->idPaquete);
                    $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitarioAjustes($idMO,$row->idPaquete);
                    $totalPMO = $totalUnitarioMO * $lotes;
                    $oden_pago = $this->mordenpago->getTotalFacturadoPagadoByIdPaquete($row->idPaquete);
                    $total_orden_pago = (!is_numeric($oden_pago)) ? $oden_pago->row()->total : 0;
                    $MOPagado = $total_orden_pago;
                }
                $array[] = array(
                    'idFraccionamiento' => (!is_numeric($qMO))? $this->mfraccionamiento->getCampo('titulo', $qMO['idFraccionamiento']):'',
                    'idPrototipo' => (!is_numeric($qMO))? $this->mprototipos->getCampo('nombre', $qMO['idPrototipo']) : '',
                    'estimaciones' =>  (!is_numeric($qMO))? $this->mprototipos->getCampo('estimaciones', $qMO['idPrototipo']) : '',
                    'paquete' => ($row->idPaquete != '')? $this->mpaquete->getCampo('titulo',$row->idPaquete):'',
                    'totalMO' => "$".number_format($totalPMO,2),
                    'moPagado' => "$".number_format($MOPagado,2),
                    'moPorPagar' => "$".number_format($totalPMO - $MOPagado,2),
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","estimaciones_programa")['w']))? accionesEstimaciones(array('id' => $row->id,'id_prototipo' => $qMO['idPrototipo']),$this->router->class,false, false, $eliminar, false, true, true, true) : ''
                );
            }
        }else{
            $array=[];
        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->mestimaciones_ss->count_all(),
            "recordsFiltered" => $this->mestimaciones_ss->count_filtered(),
            "data" => $array,
        );
        //output to json format
        echo json_encode($output);
    }

    public function nuevo()
    {
        $data['msg'] = '';
        $debug=true;
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            //$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
            $data['paquetes'] = $this->mpaquete->getAllByNotInEstimacion();
            /*$idFraccionamiento = $this->input->post('idFraccionamiento', TRUE);
            if ($idFraccionamiento != '' && $idFraccionamiento > 0 ) {
                $data['prototipos'] =  $this->getPrototiposByFraccForSelect($idFraccionamiento);
                $idPrototipo = $this->input->post('idPrototipo', TRUE);
                if($idPrototipo != '' && $idPrototipo > 0){
                    $data['paquetes'] =  $this->getPaquetesByFraccProtForSelect($idFraccionamiento, $idPrototipo);
                }
            }
            else {
                $data['paquetes'] = [];
                $data['prototipos'] = [];
            }*/
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            try {
                $this->db->trans_begin();
                //$pData['idFraccionamiento'] = $this->input->post('idFraccionamiento', TRUE);
                //$pData['idPrototipo'] = $this->input->post('idPrototipo', TRUE);
                $pData['idPaquete'] = $this->input->post('idPaquete', TRUE);

                $pData['status'] = 1;
                $id = $this->mestimacionprograma->insertar($pData);
                if(is_numeric($id)){
                    $idManoObra = $this->mpaquete->getCampo('idManoObra', $pData['idPaquete']);
                    $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idManoObra);
                    $eData['idEstimacion'] = $id;
                    $contar = $this->input->post('estimaciones', TRUE);
                    $fecha_inicio = new DateTime($this->mpaquete->getCampo('fecha_inicio', $pData['idPaquete']));
                    $intervalo = new DateInterval('P7D');
                    // Aqui empieza el guardado de las estimaciones en base al prototipo
                    for ($i=1; $i <= $contar; $i++) {
                        $eData['nEstimacion'] = $i;
                        $eData['tipo'] = 1;
                        $eData['fecha'] = $fecha_inicio->format('Y-m-d');
                        //aqui se suma la semana
                        $fecha_inicio->add($intervalo);
                        $idE = $this->mestimacionesprograma->insertar($eData);
                        if($idE > 0){
                            //Aqui empieza el guardado de estimados por estimaciones (Estimacion 1, estimacion 2, etc.)
                            $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($idManoObra);
                            if(!is_numeric($qCatProt)){
                                foreach ($qCatProt->result() as $CategoriaProt) {
                                    $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($idManoObra, $CategoriaProt->idCategoria);
                                    if(!is_numeric($qActProt)){
                                        echo ($debug) ? "In : $CategoriaProt->idCategoria <br>" : '';
                                        foreach ($qActProt->result() as $ActividadProt) {
                                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idManoObra, $ActividadProt->id);
                                            if(!is_numeric($qPresupuesto)){
                                                $esData['idEstimaciones'] = $idE;
                                                $esData['idPresupuesto'] = $qPresupuesto['id'];
                                                $esData['estimacion'] = 0;//'Mon_0 Tue_0 Wed_0 Thu_0 Fri_0 Sat_0';
                                                $idE2 = $this->mestimadosprograma->insertar($esData);
                                                $avData['idEstimado'] = $idE2;
                                                $idA = $this->mavanceobra->insertar($avData);
                                            }
                                        }
                                    }
                                    else{
                                        echo ($debug) ? "qActProt : $CategoriaProt->idCategoria <br>" : '';
                                        $fallo = false;
                                    }
                                }
                            }
                            else{
                                echo ($debug) ? 'qCatProt<br>' : '';
                                $fallo = false;
                            }
                        }
                        else{
                            echo ($debug) ? 'idEstimacion<br>' : '';
                            $fallo = false;
                        }
                    }
                }
                if ($this->db->trans_status() === FALSE){
                    echo ($debug) ? 'Rollback<br>' : '';
                    $this->db->trans_rollback();
                }
                else{
                    echo ($debug) ? 'Fallo'.strval($fallo).'<br>' : '';
                    if(!isset($fallo)){
                        $this->db->trans_commit();
                        redirect($this->router->class.'/detalle/'.$id);
                    }
                    else{
                        echo ($debug) ? 'Rollback2<br>' : '';
                        $this->db->trans_rollback();
                    }
                }
            }
            catch (\Exception $e)
            {
                if ($this->db->trans_status() === FALSE){
                    $this->db->trans_rollback();
                    die($e->getMessage());
                }
            }
        }
    }
    
    #detalle para estimados por dia
    /*public function detalleEstDia($id = null,$idPrototipo = null){
        $data['id'] = $id;

        $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $id);
        $idPrototipo = $this->mestimacionprograma->getCampo('idPrototipo', $id);
        $idFraccionamiento = $this->mestimacionprograma->getCampo('idFraccionamiento', $id);
        $qPaquete = $this->mpaquete->getById($idPaquete);

                #validar is el idprototipo tiene valor
        if ($idPrototipo > 0 && $idPaquete>0) {
            #consultar estatus del paquete con idprototipo
            $qEstPaq = $this->db->query('SELECT statusPaquete FROM paquetes WHERE idPrototipo = '.$idPrototipo.' AND id='.$idPaquete.'');
            $estPaq = $qEstPaq->row_array();
            if (isset($estPaq)) {
                # valor en aarray data para validar en la vista ...
                $data['statusPaquete'] = $estPaq['statusPaquete'];
            }
        }

        // Datos generales
        if(!is_numeric($qPaquete)){
            $paquete = array(
                'idPaquete' => $qPaquete['id'],
                'titulo' => $qPaquete['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento),
                'idPrototipo' => $idPrototipo,
                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
                'manzana' => $qPaquete['manzana'],
                'fecha_inicio' => $qPaquete['fecha_inicio'],
                'fecha_fin' => $qPaquete['fecha_fin']
                );
            $idContratista = $qPaquete['fecha_inicio'];
            $lotes = contarLotes($qPaquete['rango_lotes']);
        }
        $data['paquete'] = $paquete;
        // No. de estimaciones (Estimacion1, estimacion 2, etc...)
        $qEstimaciones = $this->mestimacionesprograma->getByIdEstimacion($id);
        if(!is_numeric($qEstimaciones)){
            foreach ($qEstimaciones->result() as $estis) {
                $estimaciones[] = array('id' => $estis->id,
                    'nEstimacion' => $estis->nEstimacion,
                    'fecha' => $estis->fecha
                    );
            }
        }
        $data['estimaciones'] = $estimaciones;
        // Aquí empieza el guardado de actividates por estimacion.
        $qManoObra = $this->mmanoobra->getByIdPaquete($idPaquete);
        $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($idPrototipo);
        if(!is_numeric($qCatProt)){
            // Se separan por categoria
            $arrayName = array();
            foreach ($qCatProt->result() as $CategoriaProt) {
                $qActProt = $this->mactividadesprototipo->getAllByPrototipoCategoria($idPrototipo, $CategoriaProt->idCategoria);
                $actividades = array();
                if(!is_numeric($qActProt)){
                    $precioUC = 0;
                    $importeC = 0;
                    $porPackC = 0;
                    $pendiPagarC = 0;
                    $acuPagarC = 0;
                    // Aqui separara por actividades
                    foreach ($qActProt->result() as $ActividadProt) {
                        $arrayName [] = $ActividadProt->idActividad;
                        $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                        $estimados = array();
                        $pendiPagar = 0;
                        $pendiLotes = 0;
                        if(!is_numeric($qActividad)){
                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($qManoObra['id'], $ActividadProt->id);
                            $qEstimado = $this->mestimadosprograma->getAllByIdPresupuesto($qPresupuesto['id']);
                            $precioUnitario = ($qPresupuesto['precioUnitario'] > 0)? $qPresupuesto['precioUnitario']: '';
                            if(!is_numeric($precioUnitario)){
                                $tipoC = $this->mconstructores->getCampo('tipoConstructor', $idContratista);
                                $precioUnitario = ($tipoC == 1)? $qActividad['precioUnitarioContratista'] : $qActividad['precioUnitarioDestajista'];
                            }
                            $porPaquete = $lotes * $qPresupuesto['importe'];
                            // Aqui va a llenar los estimados por actividad
                            if(!is_numeric($qEstimado)){
                                $acuPagar = 0;
                                $acuLotes = 0;
                                foreach ($qEstimado->result() as $esdos) {
                                    $lots = lotesEstimados($esdos->estimados_dia);
                                    $pagar = $lots * $qPresupuesto['importe'];
                                    if (!is_null($esdos->estimados_dia)) {
                                        $dias = explode(' ', $esdos->estimados_dia);
                                        foreach ($dias as $de) {
                                            $d = explode('_', $de);
                                            $diEs[$d[0]] = $d[1];
                                        }
                                    }

                                    $estimados[$esdos->idEstimaciones] = array('id' => $esdos->id,
                                        'clave' => $qActividad['clave'],
                                        'descripcion' => $qActividad['descripcion'],
                                        'lotes' => $lots,
                                        'estimacion' => precio_format($pagar),
                                        'mon' => (isset($diEs['Mon'])) ? $diEs['Mon'] : 0,
                                        'tue' => (isset($diEs['Tue'])) ? $diEs['Tue'] : 0,
                                        'wen' => (isset($diEs['Wed'])) ? $diEs['Wed'] : 0,
                                        'thu' => (isset($diEs['Thu'])) ? $diEs['Thu'] : 0,
                                        'fri' => (isset($diEs['Fri'])) ? $diEs['Fri'] : 0,
                                        'sat' => (isset($diEs['Sat'])) ? $diEs['Sat'] : 0
                                        );
                                }
                            }
                            $arrLots = $this->mestimadosprograma->getLotesGuardados($qPresupuesto['id']);
                            $acuLotes = 0;
                            if(!is_numeric($arrLots)){
                                foreach ($arrLots->result() as $Dlts) {
                                    $temLots = lotesEstimados($Dlts->estimados_dia);
                                    $acuLotes = $acuLotes + $temLots;
                                }
                            }
                            $acuPagar = $qPresupuesto['importe'] * $acuLotes;
                            $pendiPagar = $porPaquete - $acuPagar;
                            //Al guardar el array de actividad, tendra todos los estimados de una vez.
                            //$ActividadProt->idActividad
                            $actividades[] = array('id' => $ActividadProt->idActividad,
                                'clave' => $qActividad['clave'],
                                'descripcion' => '<input id="actividad" type="hidden" value="'.$qActividad["id"].'"/>'.$qActividad['descripcion'],
                                'unidad' => ($qActividad['idUnidad'] > 0)? $this->munidades->getCampo('abreviatura', $qActividad['idUnidad']) : 'N/A',
                                'cantidad' => $ActividadProt->cantidad,
                                'precioU' => precio_format($precioUnitario),
                                'importe' => precio_format($qPresupuesto['importe']),
                                'xPaquete' => precio_format($porPaquete),
                                'acuPagar' => precio_format($acuPagar),
                                'acuLotes' => $acuLotes,
                                'pendiPagar' => precio_format($pendiPagar),
                                'pendiLotes' => $lotes - $acuLotes,
                                'estimados' => $estimados
                                );
                            $precioUC = $precioUC + $precioUnitario;
                            $importeC = $importeC + $qPresupuesto['importe'];
                            $porPackC = $porPackC + $porPaquete;
                            $acuPagarC = $acuPagarC + $acuPagar;
                            $pendiPagarC = $pendiPagarC + $pendiPagar;
                        }
                    } 
                    //El array de categorias traera el array de actividades que le pertenecen.
                    $categorias[] = array( 'id' => $CategoriaProt->idCategoria,
                        'clave' => $this->mcategoriamo->getCampo('clave', $CategoriaProt->idCategoria),
                        'categoria' => $this->mcategoriamo->getCampo('categoria', $CategoriaProt->idCategoria),
                        'actividades' => $actividades,
                        'precioU' => precio_format($precioUC),
                        'importe' => precio_format($importeC),
                        'xPaquete' => precio_format($porPackC),
                        'acuPagar' => precio_format($acuPagarC),
                        'pendiPagar' => precio_format($pendiPagarC),

                        );
                }
            }
        }
        $data['categorias'] = $categorias;
        $this->data['contenido'] = $this->load->view($this->mainView . '/detalle_dias_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }*/
    
    # Detalle resumen de estimaciones totales
    public function detalle($id = null, $tempEsti = null){
        if( is_numeric($tempEsti) && !is_null($tempEsti) ){
            $this->cargarEstimacion($tempEsti);
        }
        $data['id'] = $id;
        $data['tempEsti'] = $tempEsti;
        $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $id);
        $data["idPaquete"]=$idPaquete;
        $qPaquete = $this->mpaquete->getById($idPaquete);
        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $qPaquete['idManoObra']);
        $idFraccionamiento = $this->mmanoobra->getCampo('idFraccionamiento', $qPaquete['idManoObra']);
        $detallepaquete = $this->mdetallepaquete->getProyectosByPaquete($idPaquete);
        $data["detallepaquete"] = $detallepaquete;
        $manzana = '';
        $arraySelect = array();
        $arrayMonto = array();

        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($qPaquete["idManoObra"],$idPaquete);
        $totalUnitario = $totalPresupuestoMO;
        $lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
        $lotes = $lotesManzana['total'];
        $totalPaquete = $totalUnitario * $lotes;

        // Datos generales
        if(!is_numeric($qPaquete)){
            foreach($lotesManzana['arrayMzs'] as $mz => $lotes){
                $manzana = $manzana . $mz . ', ';
            }
            $arranque=$this->marranque->getByIdPaquete($idPaquete);
            $manzana = substr($manzana, 0, -2);
            $paquete = array('titulo' => $qPaquete['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento), 
                'prototipo' => $this->mprototipos->getCampo('nombre', $idPrototipo),
                'manzana' => $manzana,
                'statusPaquete' => $qPaquete['statusPaquete'],
                'fecha_inicio' => $qPaquete['fecha_inicio'],
                'fecha_fin' => $qPaquete['fecha_fin'],
                'contratista' => $this->mconstructores->getCampo("CONCAT(nombre,' ',apellidoP,' ',apellidoM)", $qPaquete['idConstructor']),
                'rango_lotes' => $lotesManzana['lotes'],
                'total_unitario' => "$".number_format($totalUnitario,2),
                'total_paquete' => "$".number_format($totalPaquete,2),
                'anticipo' => "$".number_format($qPaquete['anticipo'],2),
                'estatus_arranque' => !is_numeric($arranque) ? $arranque["estatus_arranque"] : ["estatus_arranque" => 0]
            );
            $idContratista = $qPaquete['idConstructor'];
            $lotes = $lotesManzana['total'];
        }
        $data['paquete'] = $paquete;
        // No. de estimaciones (Estimacion1, estimacion 2, etc...)
        $qEstimaciones = $this->mestimacionesprograma->getByIdEstimacion($id);
        if(!is_numeric($qEstimaciones)){
            foreach ($qEstimaciones->result() as $estis) {
                $fecha_fin = new DateTime($estis->fecha);
                $intervalo = new DateInterval('P6D');
                $orden = $this->mordenpago->getActiveByIdEstimaciones($estis->id);
                if ( !is_numeric($orden) ){
                    $activar = false;
                    $qPaquete['anticipo'] = $qPaquete['anticipo'] - $orden['retencionAnticipo'];
                }
                else{
                    $activar = true;
                }
                $fecha_fin->add($intervalo);
                $estimaciones[] = array('id' => $estis->id,
                    'nEstimacion' => $estis->nEstimacion,
                    'fecha' => $estis->fecha,
                    'fecha_fin' => $fecha_fin->format('Y-m-d'),
                    'activar' => $activar
                );
                if($estis->fecha <= date('Y-m-d') && $activar){
                    $arraySelect[$estis->id] = 'Estimación ' . $estis->nEstimacion . ' (' . $estis->fecha . ' - ' . $fecha_fin->format('Y-m-d') . ')';
                    $tempMonto = $this->mestimadosprograma->getSumEstimadosXImporteByIdEstimaciones($estis->id);
                    $arrayMonto[$estis->id] = $tempMonto;
                }
            }
            $fecha_ini = new DateTime($fecha_fin->format('Y-m-d'));
            $intervalo = new DateInterval('P1D');
            $fecha_ini->add($intervalo);
            $ultimaEstimacion = $estis->nEstimacion + 1;
            $data['nuevo_inicio'] = ($fecha_ini->format('Y-m-d') >= date('Y-m-d'))? $fecha_ini->format('Y-m-d') : date('Y-m-d');
        }
        $data['paquete']['anticipo'] = "$".number_format($qPaquete['anticipo'],2);
        $data['estimaciones'] = $estimaciones;
        // Aquí empieza el guardado de actividates por estimacion.
        $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($qPaquete["idManoObra"]);
        if(!is_numeric($qCatProt)){
            // Se separan por categoria
            foreach ($qCatProt->result() as $CategoriaProt) {
                $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($qPaquete['idManoObra'], $CategoriaProt->idCategoria);
                $actividades = array();
                if(!is_numeric($qActProt)){
                    $precioUC = 0;
                    $importeC = 0;
                    $porPackC = 0;
                    $pendiPagarC = 0;
                    $acuPagarC = 0;
                    // Aqui separara por actividades
                    foreach ($qActProt->result() as $ActividadProt) {
                        $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                        $estimados = array();
                        $acuPagar = 0;
                        $acuLotes = 0;
                        $pendiPagar = 0;
                        $pendiLotes = 0;
                        if(!is_numeric($qActividad)){
                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($qPaquete['idManoObra'], $ActividadProt->id);
                            $precioUnitario = ($qPresupuesto['precioUnitario'] > 0)? $qPresupuesto['precioUnitario']: '';
                            if(!is_numeric($precioUnitario)){
                                $precioUnitario = $qActividad['precioUnitario'];
                            }
                            $porPaquete = $lotes * $qPresupuesto['importe'];
                            // Aqui va a llenar el estimado de la estimacion "cargada"
                            if( is_numeric($tempEsti) && !is_null($tempEsti) ){
                                $qEstimado = $this->mestimadosprograma->getEstimacionByIdPresupuestoIdEstimaciones($qPresupuesto['id'], $tempEsti);
                                if(!is_numeric($qEstimado)){
                                    $lots = $qEstimado['estimacion']; //lotesEstimados($esdos->estimados_dia);
                                    $pagar = $lots * $qPresupuesto['importe'];
                                    $qAvance = $this->mavanceobra->getByIdEstimado($qEstimado['id']);
                                    $lotAv = 0;
                                    if( !is_numeric($qAvance) ){
                                        $lotesComA = explode(',', $qAvance['lotes']);
                                        foreach($lotesComA as $ltsCA){
                                            $ltMzas = explode('/', $ltsCA);
                                            if(!is_numeric($ltsCA) && !empty($ltsCA) && count($ltMzas) == 2 ){
                                                $lotAv = $lotAv + 1;
                                            }
                                        }
                                    }
                                    $estimados = array('id' => $qEstimado['id'],
                                        'clave' => $qActividad['clave'],
                                        'descripcion' => $qActividad['descripcion'],
                                        'lotes' => $lots,
                                        'estimacion' => precio_format($pagar),
                                        'avanceLt' => $lotAv
                                    );
                                }
                                $acuLotes = $this->mestimadosprograma->getLotesGuardados($qPresupuesto['id'], $idPaquete);
                                $acuPagar = $qPresupuesto['importe'] * $acuLotes;
                                $pendiPagar = $porPaquete - $acuPagar;
                            }
                            $actividades[] = array('id' => $ActividadProt->idActividad,
                                'clave' => $qActividad['clave'],
                                'descripcion' => $qActividad['descripcion'],
                                'unidad' => ($qActividad['idUnidad'] > 0)? $this->munidades->getCampo('abreviatura', $qActividad['idUnidad']) : 'N/A',
                                'cantidad' => $ActividadProt->cantidad,
                                'precioU' => precio_format($precioUnitario),
                                'importe' => precio_format($qPresupuesto['importe']),
                                'xPaquete' => precio_format($porPaquete),
                                'acuPagar' => precio_format($acuPagar),
                                'acuLotes' => $acuLotes,
                                'pendiPagar' => precio_format($pendiPagar),
                                'pendiLotes' => $lotes - $acuLotes,
                                'estimados' => $estimados
                            );
                            $precioUC = $precioUC + $precioUnitario;
                            $importeC = $importeC + $qPresupuesto['importe'];
                            $porPackC = $porPackC + $porPaquete;
                            $acuPagarC = $acuPagarC + $acuPagar;
                            $pendiPagarC = $pendiPagarC + $pendiPagar;
                        }
                    }
                    //El array de categorias traera el array de actividades que le pertenecen.
                    if(!empty($actividades)){
                        $categorias[] = array( 'id' => $CategoriaProt->idCategoria,
                            'clave' => $this->mcategoriamo->getCampo('clave', $CategoriaProt->idCategoria),
                            'categoria' => $this->mcategoriamo->getCampo('categoria', $CategoriaProt->idCategoria),
                            'actividades' => $actividades,
                            'precioU' => precio_format($precioUC),
                            'importe' => precio_format($importeC),
                            'xPaquete' => precio_format($porPackC),
                            'acuPagar' => precio_format($acuPagarC),
                            'pendiPagar' => precio_format($pendiPagarC)
                        );
                    }
                }
            }
        }
        $data["nViviendas"]=$lotesManzana["total"];
        $data['categorias'] = $categorias;
        $data['arrayE'] = $arraySelect;
        $data['ultimaEstimacion'] = $ultimaEstimacion;
        $data['montos'] = $arrayMonto;
        $this->data['contenido'] = $this->load->view($this->mainView . '/detalle_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar($id=0){
        $id = isset($_POST["elid"]) ? $_POST["elid"] : $id;
        $this->db->query("DELETE FROM estimados_programa WHERE idEstimaciones IN (SELECT id FROM estimaciones_programa WHERE idEstimacion=$id)");
        $this->db->query("DELETE FROM estimaciones_programa WHERE idEstimacion=$id");
        $q = $this->mestimacionprograma->getById($id);
        $cValor = "true";
        $valorBorrar = $this->mestimacionprograma->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function getPrototiposByFraccForSelect($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $response[$value->idPrototipo] = $this->mprototipos->getCampo('nombre',$value->idPrototipo);
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPaquetesByFraccProtForSelect($idFrac='',$idProt='')
    {
        $paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo2($idFrac, $idProt);
        $array = array();
        $response = array();
        if ( !is_numeric($paquetes) ) {
            foreach ($paquetes->result() as $key => $value) {
                $response[$value->id] = $value->titulo;
            }
        }
        else {
            $response = [];
        }
        return $response;
    }

    public function getPaquetesByFraccProt($idFrac='',$idProt='')
    {
        $paquetes = $this->mpaquete->getByIdFraccionamientoPrototipo2($idFrac, $idProt);
        $array = array();
        $response = array();
        if ( !is_numeric($paquetes) ) {
            foreach ($paquetes->result() as $key => $value) {
                $array = array(
                    'id' => $value->id,
                    'titulo' => $value->titulo,
                    'estimaciones' => $this->mprototipos->getCampo('estimaciones',$idProt)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    public function getPrototiposByFracc($id='')
    {
        $prototipos = $this->mprototipoxfraccionamiento->getByIdFraccionamiento($id);
        $array = array();
        $response = array();
        if ( !is_numeric($prototipos) ) {
            foreach ($prototipos->result() as $key => $value) {
                $array = array(
                    'id' => $value->idPrototipo,
                    'titulo' => $this->mprototipos->getCampo('nombre',$value->idPrototipo)
                );
                array_push($response, $array);
            }
        }
        else {
            $response = 0;
        }
        echo json_encode($response);
    }

    # Crear el listado para la estimación en detalle
    public function generarEstimacion(){
        $idEstimaciones = $_POST['idEstimaciones'];
        $idEstimacion = $this->mestimacionesprograma->getCampo('idEstimacion', $idEstimaciones);
        $nEstimacion = $this->mestimacionesprograma->getCampo('nEstimacion', $idEstimaciones);
        $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $idEstimacion);
        $qPaquete = $this->mpaquete->getById($idPaquete);
        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $qPaquete['idManoObra']);

        $lotesManzana = contarLotesManzanas($qPaquete['rango_lotes']);
        $lotes = $lotesManzana['total'];

        // Aquí empieza el guardado de actividates por estimacion.
        $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($qPaquete['idManoObra']);
        if(!is_numeric($qCatProt)){
            // Se separan por categoria
            foreach ($qCatProt->result() as $CategoriaProt) {
                $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($qPaquete['idManoObra'], $CategoriaProt->idCategoria);
                $actividades = array();
                if(!is_numeric($qActProt)){
                    $precioUC = 0;
                    $importeC = 0;
                    $porPackC = 0;
                    $pendiPagarC = 0;
                    $acuPagarC = 0;
                    // Aqui separara por actividades
                    foreach ($qActProt->result() as $ActividadProt) {
                        $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                        $estimados = array();
                        $pendiPagar = 0;
                        $pendiLotes = 0;
                        if(!is_numeric($qActividad)){
                            $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($qPaquete['idManoObra'], $ActividadProt->id);
                            $qEstimado = $this->mestimadosprograma->getEstimacionByIdPresupuestoIdEstimaciones($qPresupuesto['id'], $idEstimaciones);
                            $precioUnitario = ($qPresupuesto['precioUnitario'] > 0)? $qPresupuesto['precioUnitario']: '';
                            if(!is_numeric($precioUnitario)){
                                $precioUnitario = $qActividad['precioUnitario'];
                            }
                            $porPaquete = $lotes * $qPresupuesto['importe'];
                            // Aqui va a llenar los estimados por actividad
                            if(!is_numeric($qEstimado)){
                                $acuPagar = 0;
                                $acuLotes = 0;
                                $lots = $qEstimado['estimacion']; //lotesEstimados($esdos->estimados_dia);
                                $pagar = $lots * $qPresupuesto['importe'];
                                $qAvance = $this->mavanceobra->getByIdEstimado($qEstimado['id']);
                                $lotAv = 0;
                                if( !is_numeric($qAvance) ){
                                    $lotesComA = explode(',', $qAvance['lotes']);
                                    foreach($lotesComA as $ltsCA){
										$ltMzas = explode('/', $ltsCA);
                                        if(!is_numeric($ltsCA) && !empty($ltsCA) && count($ltMzas) == 2 ){
                                            $lotAv = $lotAv + 1;
                                        }
                                    }
                                }
                                $estimados = array('id' => $qEstimado['id'],
                                    'clave' => $qActividad['clave'],
                                    'descripcion' => $qActividad['descripcion'],
                                    'lotes' => $lots,
                                    'estimacion' => precio_format($pagar),
                                    'avanceLt' => $lotAv
                                );
                            }
                            if(!empty($estimados)){
                                $acuLotes = $this->mestimadosprograma->getLotesGuardados($qPresupuesto['id'], $idPaquete);
                                $acuPagar = $qPresupuesto['importe'] * $acuLotes;
                                $pendiPagar = $porPaquete - $acuPagar;
                                //Al guardar el array de actividad, tendra todos los estimados de una vez.
                                $actividades[] = array('id' => $ActividadProt->idActividad,
                                    'clave' => $qActividad['clave'],
                                    'descripcion' => $qActividad['descripcion'],
                                    'unidad' => ($qActividad['idUnidad'] > 0)? $this->munidades->getCampo('abreviatura', $qActividad['idUnidad']) : 'N/A',
                                    'cantidad' => $ActividadProt->cantidad,
                                    'precioU' => precio_format($precioUnitario),
                                    'importe' => precio_format($qPresupuesto['importe']),
                                    'xPaquete' => precio_format($porPaquete),
                                    'acuPagar' => precio_format($acuPagar),
                                    'acuLotes' => $acuLotes,
                                    'pendiPagar' => precio_format($pendiPagar),
                                    'pendiLotes' => $lotes - $acuLotes,
                                    'estimados' => $estimados
                                );
                                $precioUC = $precioUC + $precioUnitario;
                                $importeC = $importeC + $qPresupuesto['importe'];
                                $porPackC = $porPackC + $porPaquete;
                                $acuPagarC = $acuPagarC + $acuPagar;
                                $pendiPagarC = $pendiPagarC + $pendiPagar;
                            }
                        }
                    }
                    //El array de categorias traera el array de actividades que le pertenecen.
                    if(!empty($actividades)){
                        $categorias[] = array( 'id' => $CategoriaProt->idCategoria,
                            'clave' => $this->mcategoriamo->getCampo('clave', $CategoriaProt->idCategoria),
                            'categoria' => $this->mcategoriamo->getCampo('categoria', $CategoriaProt->idCategoria),
                            'actividades' => $actividades,
                            'precioU' => precio_format($precioUC),
                            'importe' => precio_format($importeC),
                            'xPaquete' => precio_format($porPackC),
                            'acuPagar' => precio_format($acuPagarC),
                            'pendiPagar' => precio_format($pendiPagarC),
                        );
                    }
                }
            }
        }
        $data['categorias'] = $categorias;
        $data['nEstimacion'] = $nEstimacion;
        echo json_encode($data);
    }

    #actualizar dias
    /*public function actualizarDias()
    {   
        $vacio = true;
        $err = '';
        $errores = true;
        $updId = $_POST['id'];
        $diaUpd = $_POST['dia'];
        // Error por si ponen otra cosa que no sea un numero
        if(!is_numeric($_POST['valor'])){
        $alDat['tipo'] = 'error';
        $alert = alertMessage($alDat);
        #si no es numerico, traer estimados_dia,  valor anterior ...
            if (!is_numeric($qEst)) {
                $estimDia =  $qEst->first_row('array');
                $dias = explode(' ',  $estimDia['estimados_dia']);
                foreach ($dias as $value) {
                    $val = explode('_', $value);
                    if ($val[0] == $diaUpd) {
                        #cuando el dia coincida guardas su valor ...
                        $datitos['val'] = $val[1];
                    }
                }
            }
            $vacio = true;
            // Valores para el modal en caso de un error (no sea numero o no puede agregar mas lotes)
            $datitos['alert'] = $alert;
            $datitos['valor'] = 'error';
            $err = $err . '<br/>EL VALOR INGRESADO DEBE SER NUMÉRICO.';
            $datitos['titulo'] = 'ERROR AL ACTUALIZAR';
            $datitos['texto'] = $err;//'<p>A OCURRIDO UN ERROR AL MOMENTO DE ACTUALIZAR LA ESTIMACIÓN.<br/>INTENTELO OTRA VEZ.</p>' . $err;
            $errores = false;
        }
        elseif($errores){
                $limite = true;
                $idPres = $this->input->post('actividad');
                $idProt = $this->input->post('prototipo');
                $idPaquete = $this->input->post('idPaquete');
                $rango = 0;
                #consultar rango de apquetes
                $qRango = $this->db->query('SELECT rango_lotes FROM paquetes WHERE idPrototipo ="'.$idProt.'" AND id ="'.$idPaquete.'"');
                $rowRang = $qRango->row();
                if (isset($rowRang))
                {
                    $rango = contarLotes($rowRang->rango_lotes);
                }
                #consultar estimados_dia segun actividad(idPresupuesto)
                $idPres = $this->mestimadosprograma->getCampo("idPresupuesto",$updId);
                $qEstLim = $this->db->query('SELECT id, idPresupuesto, estimados_dia FROM estimados WHERE idPresupuesto = "'.$idPres.'"');
                #checar limite de estimados
                if (!is_numeric($qEstLim)) {
                    $tot = 0; // variable para sumar total de estimados
                    foreach ($qEstLim->result() as $val) {
                        # sumar las catidades de estimados_dias ...
                        $dys = lotesEstimados($val->estimados_dia);
                        $tot += $dys; 
                    }
                    $anterior = $this->mestimadosprograma->getCampo('estimados_dia', $_POST['id']);
                    if(is_string($anterior) && !is_null($anterior)){
                        $dias = explode(' ',  $anterior);
                        $valAnterior = 0;
                        $restante = 0;
                        foreach ($dias as $value) {
                            $val = explode('_', $value);
                            if ($val[0] == $diaUpd) {
                                $valAnterior = $val[1];
                            }
                        }
                    }
                    $suma = ($tot - $valAnterior) + $_POST['valor'];
                    $limite = ($suma > $rango) ? false : true ; // validar total de estimados_dia
                }
                # si limite menor a 32(true), prosigue con la actualizacion
                if ($limite) {
                        #traer estimados_dia para actualizar el valor
                        $qDiaEst = $this->db->query('SELECT estimados_dia FROM estimados WHERE id = "'.$updId.'"');
                        if (!is_numeric($qDiaEst)) {
                                $estimDia =  $qDiaEst->first_row('array');
                                $dias = explode(' ',  $estimDia['estimados_dia']);
                                foreach ($dias as $value) {
                                    # code...
                                    $val = explode('_', $value);
                                    if ($val[0] == $diaUpd) {
                                            # code...
                                        $datUpd [] = $val[0].'_'.$_POST['valor'];
                                    }else{
                                        $datUpd [] = $val[0].'_'.$val[1];
                                    }
                                }
                            } 
                                // actualizar datos 
                                $dat['estimados_dia'] = join(" ",$datUpd);
                                #consulta para actualizar
                                $this->mestimadosprograma->actualizar($dat, $_POST['id']);
                                $datitos['titulo'] = 'DATOS ACTUALIZADOS';
                                $datitos['valor'] = 'correcto';
                                $datitos['texto'] = '<p style = "text-align:center;">SE HAN GUARDADO LOS CAMBIOS.</p>';
                }
                else{                        
                        $datitos['valor'] = 'limite';
                        //$err = 'LIMITE MÁXIMO DE ESTIMADOS REBASADO';
                        $datitos['titulo'] = 'MAXIMO DE ESTIMADOS';
                        $datitos['texto'] = '<p style = "text-align:center;"> SE HA EXCEDIDO EL NÚMERO PERMITIDO PARA EL PAQUETE. ' . $err.'</p>';
                }
            }
            echo json_encode($datitos);
    }*/

    public function actualizar()
    {
        $vacio = true;
        $err = '';
        $errores = false;
        $datitos['valor'] = $_POST['valor'];
        // Error por si ponen otra cosa que no sea un numero
        if(!is_numeric($_POST['valor'])){
            $vacio = true;
            $errores = true;
            $err = '<br/>EL VALOR INGRESADO DEBE SER NUMÉRICO.';
            $anterior = $this->mestimadosprograma->getCampo('estimacion', $_POST['id']);
        }
        //Si es numero, verificara que no se pase de lotes
        else{
            $idPresuxEstimado = $this->mestimadosprograma->getCampo('idPresupuesto', $_POST['id']);
            $idMO = $this->mpresupuestomo->getCampo('idManoObra', $idPresuxEstimado);
            $idSemana = $this->mestimadosprograma->getCampo('idEstimaciones', $_POST['id']);
            $idEstimacion = $this->mestimacionesprograma->getCampo('idEstimacion', $idSemana);
            $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $idEstimacion);
            //$qPaquete = $this->mpaquete->getById($idPaquete);
            // Cuantos lotes hay por esta actividad (con idPresupuesto)
            $estimacionxPresupuesto = $this->mestimadosprograma->getLotesGuardados($idPresuxEstimado, $idPaquete);
            $anterior = $this->mestimadosprograma->getCampo('estimacion', $_POST['id']);
            // La "suma" resta los lotes que habia agregado en este estimado, a los lotes que ya habia en total por actividad y sumara el nuevo valor del estimado 
            $suma = ($estimacionxPresupuesto - $anterior) + $_POST['valor'];
            $lotes = $this->mdetallepaquete->getByIdPaquete($idPaquete);
            $lotes = $lotes->num_rows();
            //$lotes = contarLotes($qPaquete['rango_lotes']);
            $idActiProt = $this->mpresupuestomo->getCampo('idActividadPrototipo', $idPresuxEstimado);
            // Varifica que los lotes no vayan a sobrepasar los puestos por el paquete
            if($suma > $lotes && $anterior != $_POST['valor']){
                $errores = true;
                $idActi = $this->mactividadesprototipo->getCampo('idActividad', $idActiProt);
                $err = '<p style = "text-align:center;"> SE HA EXCEDIDO EL NÚMERO PERMITIDO PARA EL PAQUETE. </p>';
            }
        }
        if($errores){
            // Valores para el modal en caso de un error (no sea numero o no puede agregar mas lotes)
            $datitos['valor'] = 'error';
            $datitos['titulo'] = 'ERROR AL ACTUALIZAR';
            $datitos['texto'] = $err;
            $datitos['anterior'] = $anterior;
        }
        else{
            //Si no hay errores, puede continuar con la actualizacion
            $pData['estimacion'] = $_POST['valor'];
            $this->mestimadosprograma->actualizar($pData, $_POST['id']);
             //Va a llamar a todos los estimados en base al presupuesto para obtener los que se cambiaran en la tabla
            $estimadosxP = $this->mestimadosprograma->getAllByIdPresupuestoIdPaquete($idPresuxEstimado, $idPaquete);
            foreach ($estimadosxP->result() as $key) {
                $ids[] = $key->id;
            }
            $importe = $this->mpresupuestomo->getCampo('importe', $idPresuxEstimado);
            $datitos['ids'] = $ids;
            // lo que se pagaría por por estimado
            $datitos['estimacion'] = $_POST['valor'] * $importe;
            // cambios que se haran por actividad
            $datitos['acuLotes'] = $suma;
            $datitos['acuPagar'] = $suma  * $importe;
            $datitos['pendiLotes'] = $lotes - $suma;
            $datitos['pendiPagar'] = ($lotes * $importe) - $datitos['acuPagar'];
            $idCategoria = $this->mactividadesprototipo->getCampo('idCategoria', $idActiProt);
            $idPrototipo = $this->mactividadesprototipo->getCampo('idPrototipo', $idActiProt);
            // id de la categoria que se va a modificar en la tabla
            $datitos['categoria'] = $idCategoria;
            $qActividades = $this->mactividadesprototipo->getAllByPrototipoCategoria($idPrototipo, $idCategoria);
            $acuPagarC = 0;
            $pendiPagarC = 0;
            // Son las actividades de la categoria que se actualiza
            foreach ($qActividades->result() as $actividad) {
                $presT = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idMO, $actividad->id);
                if( !is_numeric($presT) ){
                    $ltT = $this->mestimadosprograma->getLotesGuardados($presT['id'], $idPaquete);
                    $acuPagarT = $ltT * $presT['importe'];
                    $acuPagarC = $acuPagarC + $acuPagarT;
                    $pendiPagarT = ($lotes * $presT['importe']) - $acuPagarT;
                    $pendiPagarC = $pendiPagarC + $pendiPagarT;
                }
            }
            $datitos['acuPagarC'] = $acuPagarC;
            $datitos['pendiPagarC'] = $pendiPagarC;
            $datitos['valor'] = 'correcto';
            $datitos['titulo'] = 'DATOS ACTUALIZADOS';
            $datitos['texto'] = 'SE HAN GUARDADO LOS CAMBIOS.';
        }

        echo json_encode($datitos);
    }

    public function obtener_avance(){
        $idEstimado=$this->input->post("idEstimado");
        $idPaquete=$this->input->post("idPaquete");
        $avance=$this->mavanceobra->getAvanceByEstimado($idPaquete,$idEstimado);
        echo json_encode($avance);
    }

    public function actualizar_avance(){
        $idEstimado=$this->input->post("idEstimado");
        $proyectos=$this->input->post("proyectos");
        $lotesMza="";
        $count=0;
        if(is_array($proyectos)){
            $count=COUNT($proyectos);
            for ($i=0; $i < $count; $i++) {
                $coma=($i>0)?',':'';
                $lotesMza.=$coma.$this->mproyecto->getCampo("CONCAT(lote,'/',manzana)",$proyectos[$i]);
            }
        }
        $this->db->query("UPDATE avanceobra SET lotes='$lotesMza' WHERE idEstimado=$idEstimado");
        echo json_encode($count);
    }

    public function exportar($idEstimacion){
        $estimacion = $this->mestimacionprograma->getById($idEstimacion);
        if(!is_numeric($estimacion)){
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
			$objPHPExcel->getActiveSheet()->setTitle('Programa De Obra');
			$objPHPExcel->setActiveSheetIndex(0);
			$paquete = $this->mpaquete->getById($estimacion['idPaquete']);
			if (!is_numeric($paquete)) {
				$prototipo = $this->mprototipos->getCampo2('nombre', $paquete['idPrototipo']);
				$lotes = contarLotes($paquete['rango_lotes']);
				$dateInicio = date_create($paquete['fecha_inicio']);
				$inicioProgramado = date_format($dateInicio, 'd-m-Y');
				$dateFin = date_create($paquete['fecha_fin']);
				$finProgramado = date_format($dateFin, 'd-m-Y');
				$constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
				$constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
				$constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
				$constructor = $constructorNombre.' '.$constructorApellidoP.' '.$constructorApellidoM;
                $manzana = $paquete['manzana'];
                if($paquete['fecha_inicio_real'] != ''){
                    $fechaInicio = date_create($paquete['fecha_inicio_real']);
                    $inicioReal = date_format($fechaInicio, 'd-m-Y');
                }else{
                    $inicioReal = '';
                }
                $terminoReal = getStatusPaquete($paquete['status']);
				//$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'LOGO');
				$objPHPExcel->getActiveSheet()->mergeCells('A1:A6');

				$gdImage = imagecreatefromjpeg(base_url().'/img/bg1.jpg');
				// Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
				$objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
				$objDrawing->setName('Logo Vviend');
				$objDrawing->setDescription('Logo Viviend');
				$objDrawing->setImageResource($gdImage);
				$objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
				$objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
				$objDrawing->setOffsetX(150); 
				$objDrawing->setOffsetY(0); 
				$objDrawing->setWidth(900); 
				$objDrawing->setHeight(120);
				$objDrawing->setCoordinates('A1');
				$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

				$objPHPExcel->getActiveSheet()->SetCellValue('B2', 'PROTOTIPO:');
				$objPHPExcel->getActiveSheet()->mergeCells('B2:D2');
				$objPHPExcel->getActiveSheet()->SetCellValue('B3', 'NO. VIVIENDAS:');
				$objPHPExcel->getActiveSheet()->mergeCells('B3:D3');
				$objPHPExcel->getActiveSheet()->SetCellValue('B4', 'INICIO PROGRAMADO:');
				$objPHPExcel->getActiveSheet()->mergeCells('B4:D4');
				$objPHPExcel->getActiveSheet()->SetCellValue('B5', 'TERMINO PROGRAMADO:');
				$objPHPExcel->getActiveSheet()->mergeCells('B5:D5');

				$objPHPExcel->getActiveSheet()->SetCellValue('E2', $prototipo);
				$objPHPExcel->getActiveSheet()->mergeCells('E2:G2');
				$objPHPExcel->getActiveSheet()->SetCellValue('E3', $lotes);
				$objPHPExcel->getActiveSheet()->mergeCells('E3:G3');
				$objPHPExcel->getActiveSheet()->SetCellValue('E4', $inicioProgramado);
				$objPHPExcel->getActiveSheet()->mergeCells('E4:G4');
				$objPHPExcel->getActiveSheet()->SetCellValue('E5', $finProgramado);
				$objPHPExcel->getActiveSheet()->mergeCells('E5:G5');

				$objPHPExcel->getActiveSheet()->SetCellValue('H2', 'CONTRATISTA:');
				$objPHPExcel->getActiveSheet()->mergeCells('H2:I2');
				$objPHPExcel->getActiveSheet()->SetCellValue('H3', 'MANZANA:');
				$objPHPExcel->getActiveSheet()->mergeCells('H3:I3');
				$objPHPExcel->getActiveSheet()->SetCellValue('H4', 'INICIO REAL:');
				$objPHPExcel->getActiveSheet()->mergeCells('H4:I4');
				$objPHPExcel->getActiveSheet()->SetCellValue('H5', 'TERMINO REAL:');
				$objPHPExcel->getActiveSheet()->mergeCells('H5:I5');

				$objPHPExcel->getActiveSheet()->SetCellValue('J2', $constructor);
				$objPHPExcel->getActiveSheet()->mergeCells('J2:L2');
				$objPHPExcel->getActiveSheet()->SetCellValue('J3', $manzana);
				$objPHPExcel->getActiveSheet()->mergeCells('J3:L3');
				$objPHPExcel->getActiveSheet()->SetCellValue('J4', $inicioReal);
				$objPHPExcel->getActiveSheet()->mergeCells('J4:L4');
				$objPHPExcel->getActiveSheet()->SetCellValue('J5', $terminoReal);
				$objPHPExcel->getActiveSheet()->mergeCells('J5:L5');

				$objPHPExcel->getActiveSheet()->SetCellValue('A7', 'CONCEPTO');
				$objPHPExcel->getActiveSheet()->mergeCells('A7:A11');
				$inicial = 'A';
				$final = '';
				$estimacion = $this->mestimacionprograma->getByIdPaquete($paquete['id']);
				if (!is_numeric($estimacion)) {
					$estimaciones = $this->mestimacionesprograma->getByIdEstimacion($estimacion['id']);
					if (!is_numeric($estimaciones)) {
						$letra = 'B';
						$diaEstimado = 'B';
						$diaInicial = 1;
						$rowFinal = 0;
						//$mes = 0;
						//$diasMes = 31;
						//$semana = 0;
						//$diasSemana = 7;
						foreach ($estimaciones->result() as $e) {
							$rowInicial = 1;
							$rowFinal = 7;
							$letraInicial = $letra;
							$objPHPExcel->getActiveSheet()->SetCellValue($letra . '8', 'SEMANA ' . $e->nEstimacion);
							$objPHPExcel->getActiveSheet()->SetCellValue($letra . '11', 'AVANCES');
							for ($rowInicial; $rowInicial <= $rowFinal; $rowInicial++) {
								switch ($rowInicial) {
									case 1:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'L');
										break;
									case 2:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'M');
										break;
									case 3:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'M');
										break;
									case 4:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'J');
										break;
									case 5:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'V');
										break;
									case 6:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'S');
										break;
									case 7:
										$objPHPExcel->getActiveSheet()->SetCellValue($letra . '9', 'D');
										break;
								}
								
								$objPHPExcel->getActiveSheet()->SetCellValue($letra . '10', $diaInicial);

								if ($rowInicial == 7) {
									//$semana++;
									//$calculoDias = $semana * $diasSemana;
									$objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '8:' . $letra . '8');
									$objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '11:' . $letra . '11');
									$objPHPExcel->getActiveSheet()->getStyle($letraInicial . '11')->getAlignment()->applyFromArray(
										array(
											'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
											'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
										)
									);
								}

								if ($diaInicial == 31) {
									$diaInicial = 0;
								}


								$objPHPExcel->getActiveSheet()->getStyle($letra . '9')->getAlignment()->applyFromArray(
									array(
										'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
										'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
									)
								);
								$letra++;
								$diaInicial++;
							}
							$final = $letra;

							$arrayCategoria = array();
							$arrayActividades = array();
							$estimados = $this->mestimadosprograma->getEstimadosDias($e->id);
							$inicialEstimado = '';
							if(!is_numeric($estimados)){
								$rowCount = 12;
								foreach($estimados->result() as $row){
									$rowInicialEstimado = 1;
									$rowFinalEstimado = 7;
									$inicialEstimado = $diaEstimado;
									if (!array_key_exists($row->claveCategoria, $arrayCategoria)) {
										$arrayCategoria[$row->claveCategoria] = array('Categoria' => 'Alta');
										$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, ($row->categoria != '') ? $row->categoria : '');
										$objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount)->getFill()->setFillType(PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB('D9D9D9');
										if (!array_key_exists($row->claveActividad, $arrayActividades)) {
											$rowCount++;
											$arrayActividades[$row->claveActividad] = array('Actividad' => 'Alta');
											$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, ($row->actividad != '') ? $this->wordlimit($row->actividad, 7, '...') : '');
											for ($rowInicialEstimado; $rowInicialEstimado <= $rowFinalEstimado; $rowInicialEstimado++) {
												$estimadosDia = explode(' ',$row->estimados_dia);
												$lunes = $estimadosDia[0];
												$martes = $estimadosDia[1];
												$miercoles = $estimadosDia[2];
												$jueves = $estimadosDia[3];
												$viernes = $estimadosDia[4];
												$sabado = $estimadosDia[5];
												switch ($rowInicialEstimado) {
													case 1://Lunes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($lunes, 4) > 0) ? substr($lunes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 2://Martes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($martes, 4) > 0) ? substr($martes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 3://Miercoles
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($miercoles, 4) > 0) ? substr($miercoles, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 4://Jueves
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($jueves, 4) > 0) ? substr($jueves, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 5://Viernes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($viernes, 4) > 0) ? substr($viernes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 6://Sabado
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($sabado, 4) > 0) ? substr($sabado, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 7://Domingo
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, '');
														break;
												}
			
												$inicialEstimado++;
											}
										}else{
											for ($rowInicialEstimado; $rowInicialEstimado <= $rowFinalEstimado; $rowInicialEstimado++) {
												$estimadosDia = explode(' ',$row->estimados_dia);
												$lunes = $estimadosDia[0];
												$martes = $estimadosDia[1];
												$miercoles = $estimadosDia[2];
												$jueves = $estimadosDia[3];
												$viernes = $estimadosDia[4];
												$sabado = $estimadosDia[5];
												switch ($rowInicialEstimado) {
													case 1://Lunes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($lunes, 4) > 0) ? substr($lunes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 2://Martes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($martes, 4) > 0) ? substr($martes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 3://Miercoles
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($miercoles, 4) > 0) ? substr($miercoles, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 4://Jueves
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($jueves, 4) > 0) ? substr($jueves, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 5://Viernes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($viernes, 4) > 0) ? substr($viernes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 6://Sabado
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($sabado, 4) > 0) ? substr($sabado, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 7://Domingo
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, '');
														break;
												}
			
												$inicialEstimado++;
											}
										}
									}else{
										if (!array_key_exists($row->claveActividad, $arrayActividades)) {
											$arrayActividades[$row->claveActividad] = array('Actividad' => 'Alta');
											$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, ($row->actividad != '') ? $this->wordlimit($row->actividad, 7, '...') : '');
											for ($rowInicialEstimado; $rowInicialEstimado <= $rowFinalEstimado; $rowInicialEstimado++) {
												$estimadosDia = explode(' ',$row->estimados_dia);
												$lunes = $estimadosDia[0];
												$martes = $estimadosDia[1];
												$miercoles = $estimadosDia[2];
												$jueves = $estimadosDia[3];
												$viernes = $estimadosDia[4];
												$sabado = $estimadosDia[5];
												switch ($rowInicialEstimado) {
													case 1://Lunes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($lunes, 4) > 0) ? substr($lunes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 2://Martes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($martes, 4) > 0) ? substr($martes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 3://Miercoles
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($miercoles, 4) > 0) ? substr($miercoles, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 4://Jueves
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($jueves, 4) > 0) ? substr($jueves, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 5://Viernes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($viernes, 4) > 0) ? substr($viernes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 6://Sabado
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($sabado, 4) > 0) ? substr($sabado, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 7://Domingo
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, '');
														break;
												}
			
												$inicialEstimado++;
											}
										}else{
											for ($rowInicialEstimado; $rowInicialEstimado <= $rowFinalEstimado; $rowInicialEstimado++) {
												$estimadosDia = explode(' ',$row->estimados_dia);
												$lunes = $estimadosDia[0];
												$martes = $estimadosDia[1];
												$miercoles = $estimadosDia[2];
												$jueves = $estimadosDia[3];
												$viernes = $estimadosDia[4];
												$sabado = $estimadosDia[5];
												switch ($rowInicialEstimado) {
													case 1://Lunes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($lunes, 4) > 0) ? substr($lunes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 2://Martes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($martes, 4) > 0) ? substr($martes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 3://Miercoles
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($miercoles, 4) > 0) ? substr($miercoles, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 4://Jueves
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($jueves, 4) > 0) ? substr($jueves, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 5://Viernes
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($viernes, 4) > 0) ? substr($viernes, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 6://Sabado
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, (substr($sabado, 4) > 0) ? substr($sabado, 4) : '');
														$objPHPExcel->getActiveSheet()->getStyle($inicialEstimado . $rowCount)->getAlignment()->applyFromArray(
															array(
																'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
																'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
															)
														);
														break;
													case 7://Domingo
														$objPHPExcel->getActiveSheet()->SetCellValue($inicialEstimado . $rowCount, '');
														break;
												}
			
												$inicialEstimado++;
											}
										}
									}
									$rowCount++;
									$rowFinal = $rowCount;
								}
								$diaEstimado = $inicialEstimado;
							}
						}

					}
				}
			}
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(false);
			$objPHPExcel->getActiveSheet()->getColumnDimensionByColumn('A')->setWidth('60');
			/*foreach (range('A', 'A') as $columnID) {
					$objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(false);
					$objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($columnID)->setWidth('60');
				}*/
			$objPHPExcel->getActiveSheet()->getStyle($inicial . '1:' . $final . '11')->getAlignment()->applyFromArray(
				array(
					'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
					'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
				)
			);

			$objPHPExcel->getActiveSheet()->getStyle('C2:D5')->getAlignment()->applyFromArray(
				array(
					'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
				)
			);

			$objPHPExcel->getActiveSheet()->getStyle('H2:I5')->getAlignment()->applyFromArray(
				array(
					'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
					'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
				)
			);
			$name = 'Programa de Obra';
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="' . $name . '_' . date('Ymd') . '.xls"');
			header('Cache-Control: max-age=0'); //no cache
			$objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
			// Forzamos a la descarga
			$objWriter->save('php://output');
        }
    }

    public function wordlimit($string, $length = 50, $ellipsis = "...")
    {
        $words = explode(' ', $string);
        if (count($words) > $length) {
            return implode(' ', array_slice($words, 0, $length)) . " " . $ellipsis;
        } else {
            return $string;
        }
    }

    public function getEstimacionesByPaquete($idPaquete){
        $data['estimaciones'] = '';
        if(is_numeric($idPaquete)){
            $idMO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idMO);
            if(is_numeric($idPrototipo)){
                $estima = $this->mprototipos->getCampo('estimaciones', $idPrototipo);
                $data['estimaciones'] = $estima;
            }
        }
        echo json_encode($data);
    }

    public function cargarEstimacion($idEstimaciones=0){
        $datitos['msg'] = 'Debe seleccionar la semana';
        $arrayLotes = array();
        $idEstimaciones=(isset($_POST["idEstimaciones"])) ? $_POST['idEstimaciones'] : $idEstimaciones;
        $qEstimaciones = $this->mestimacionesprograma->getById($idEstimaciones);
        if(!is_numeric($qEstimaciones)){
            $qEstimados = $this->mestimadosprograma->getAllByIdEstimaciones($qEstimaciones['id']);
            if(!is_numeric($qEstimados)){
                foreach($qEstimados->result() as $esdos){
                    $qAvance = $this->mavanceobra->getByIdEstimado($esdos->id);
                    $lotes = explode(',', $qAvance['lotes']);
                    $cantEstimados = 0;
                    foreach($lotes as $lt){
                        if(!empty($lt)){
                            $cantEstimados = $cantEstimados + 1;
                        }
                    }
                    $data['estimacion'] = $cantEstimados;
                    $idEstimado = $this->mestimadosprograma->actualizar($data, $esdos->id);
                }
                $datitos['msg'] = '';
            }
        }
        echo json_encode($datitos);
    }

    public function nuevaEstimacionAtrasada(){
        $datitos['msg'] = 'Ocurrió un error, vuelva a intentar.';
        if( is_numeric($_POST['idEstis']) && is_numeric($_POST['ultEsti']) ){
            try {
                $this->db->trans_begin();
                $lastWeek = $this->mestimacionesprograma->getLastWeekByIdEstimacion($_POST['idEstis']);
                $intervalo = new DateInterval('P6D');
                $fecha_finL = new DateTime($lastWeek['fecha']);
                $fecha_finL->add($intervalo);
                $texto = str_replace('/', '-', $_POST['fecha_inicioN']);
                $fecha_iniN = new DateTime( str_replace('/', '-', $_POST['fecha_inicioN']) );
                if($fecha_finL->format('Y-m-d') < $fecha_iniN->format('Y-m-d')){
                    $dEstis['idEstimacion'] = $_POST['idEstis'];
                    $dEstis['fecha'] = $fecha_iniN->format('Y-m-d');
                    $dEstis['nEstimacion'] = $_POST['ultEsti'];
                    $dEstis['tipo'] = 2;
                    $idEstimaciones = $this->mestimacionesprograma->insertar($dEstis);
                    if(is_numeric($idEstimaciones)){
                        $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $_POST['idEstis']);
                        $idManoObra = $this->mpaquete->getCampo('idManoObra', $idPaquete);
                        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idManoObra);
                        //Aqui empieza el guardado de estimados por estimaciones (Estimacion 1, estimacion 2, etc.)
                        $qCatProt = $this->mactividadesprototipo->getCategoriasByManoObra($idManoObra);
                        if(!is_numeric($qCatProt)){
                            foreach ($qCatProt->result() as $CategoriaProt) {
                                $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($idManoObra, $CategoriaProt->idCategoria);
                                if(!is_numeric($qActProt)){
                                    foreach ($qActProt->result() as $ActividadProt) {
                                        $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($idManoObra, $ActividadProt->id);
                                        if(!is_numeric($qPresupuesto)){
                                            $esData['idEstimaciones'] = $idEstimaciones;
                                            $esData['idPresupuesto'] = $qPresupuesto['id'];
                                            $esData['estimacion'] = 0;
                                            $idE2 = $this->mestimadosprograma->insertar($esData);
                                            $avData['idEstimado'] = $idE2;
                                            $idA = $this->mavanceobra->insertar($avData);
                                        }
                                    }
                                }
                                else{
                                    $fallo = false;
                                }
                            }
                        }
                        else{
                            $fallo = false;
                        }
                        if ($this->db->trans_status() === FALSE){
                            $this->db->trans_rollback();
                        }
                        else{
                            if(!isset($fallo)){
                                $this->db->trans_commit();
                                $datitos['msg'] = '';
                            }
                            else{
                                $this->db->trans_rollback();
                            }
                        }
                    }
                }
                else{
                    $datitos['msg'] = 'La fecha que ingresó pertenecé a otra estimación.';
                }
            }
            catch (\Exception $e)
            {
                if ($this->db->trans_status() === FALSE){
                    $this->db->trans_rollback();
                    $datitos['msg'] = 'Ocurrió un error, vuelva a intentar.';
                    //die($e->getMessage());
                }
            }    
        }
        echo json_encode($datitos);
    }

    public function guardarOP(){
        $datitos['msg'] = '';
        $arrayLotes = array();
        $qEstimaciones = $this->mestimacionesprograma->getById($_POST['idEstimaciones']);
        if(!is_numeric($qEstimaciones) && is_numeric($_POST['retencionV']) && is_numeric($_POST['anticipo'])){
            $qEstimacionesHay = $this->mestimacionesprograma->getEstimacionesAnterioresById($qEstimaciones['id']);
            $eIds = array();
            if(!is_numeric($qEstimacionesHay)){
                foreach($qEstimacionesHay->result() as $estiAnterior){
                    $hayOrdenes = $this->mordenpago->getActiveByIdEstimaciones($estiAnterior->id);
                    if(is_numeric($hayOrdenes)){
                        $eIds[] = $estiAnterior->id;
                    }
                }
            }
            $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $qEstimaciones['idEstimacion']);
            $idManoObra = $this->mpaquete->getCampo('idManoObra', $idPaquete);
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo', $idManoObra);
            $totalS = 0;
            $textEsti = '';
            $total = array();
            foreach($eIds as $eId){
                $qEstimado = $this->mestimadosprograma->getAllByIdEstimaciones($eId);
                if(!is_numeric($qEstimado)){
                    foreach ($qEstimado->result() as $esdos) {
                        $importe = $this->mpresupuestomo->getCampo('importe', $esdos->idPresupuesto);
                        $acumulado = $esdos->estimacion * $importe;
                        if($esdos->estimacion > 0){
                            if(!array_key_exists($esdos->idPresupuesto, $total)){
                                $total[$esdos->idPresupuesto] = array('idPresupuesto' => $esdos->idPresupuesto,
                                    'lotes' => $esdos->estimacion,
                                    'precioU' => $importe,
                                    'aPagar' => $acumulado
                                );
                            }
                            else{
                                $tempAcumulado = $total[$esdos->idPresupuesto]['aPagar'] + $acumulado;
                                $tempLotesE = $total[$esdos->idPresupuesto]['lotes'] + $esdos->estimacion;
                                $total[$esdos->idPresupuesto]['aPagar'] = $tempAcumulado;
                                $total[$esdos->idPresupuesto]['lotes'] = $tempLotesE;
                            }
                        }
                        $totalS = $totalS + $acumulado;
                    }
                    $textEsti= $textEsti . $eId . ',';
                }
            }
            if($totalS > 0){
                $oData['idPaquete'] = $idPaquete;
                $oData['idEstimaciones'] = substr($textEsti, 0, -1);
                $oData['monto'] = $totalS;
                $oData['statusPago'] = 1;
                $retencion = $this->mpaquete->getCampo('porcentaje_retencion', $idPaquete);
                $oData['retencion'] = $totalS * ($retencion / 100);
                $oData['retencionvicios'] = $_POST['retencionV'];
                $oData['retencionAnticipo'] = $_POST['anticipo'];
                $oData['formaPago'] = $_POST['formaPago'];
                $oData['nota'] = $_POST['nota'];
                $id = $this->mordenpago->insertar($oData);
                if(is_numeric($id) && $id > 0){
                    set_time_limit(300);
                    foreach ($total as $key) {
                        $dData['idPresupuesto'] = $key['idPresupuesto'];
                        $dData['idOrdenPago'] = $id;
                        $dData['lotes'] = $key['lotes'];
                        $dData['precioUnitario'] = $key['precioU'];
                        $dData['monto'] = $key['aPagar'];
                        $idD = $this->mdetalleop->insertar($dData);
                    }
                }
                $datitos['msg'] = '';
            }
            else{
                $datitos['msg'] = 'No hay actividades en esta semana';
            }
        }
        else{
            $datitos['msg'] = 'Debe colocar toda la inf. correctamente';
        }
        if(!is_numeric($_POST['retencionV'])){
            $datitos['msg'] = $datitos['msg'] . '</br>Otros debe ser númerico';
        }
        if(!is_numeric($_POST['anticipo'])){
            $datitos['msg'] = $datitos['msg'] . '</br>Anticipo debe ser númerico';
        }

        echo json_encode($datitos);
    }

    public function exportarPE($idEstimacion)
    {
        $estimacion = $this->mestimacionprograma->getById($idEstimacion);
        if (!is_numeric($estimacion)) {
            $paquete = $this->mpaquete->getById($estimacion['idPaquete']);
            $totalContrato = 0;
            $paqueteLotes = 0;
            if (!is_numeric($paquete)) {
                $manoObra = $this->mmanoobra->getById($paquete['idManoObra']);
                $fraccionamiento = (!is_numeric($manoObra)) ? $this->mfraccionamiento->getCampo2('titulo', $manoObra['idFraccionamiento']) : '';
                $prototipo = (!is_numeric($manoObra)) ? $this->mprototipos->getCampo2('nombre', $manoObra['idPrototipo']) : '';
                $paqueteLotes = contarLotesManzanas($paquete['rango_lotes']);
                $lotes = $paqueteLotes['lotes'];
                $manzanas = implode(", ", array_keys($paqueteLotes["arrayMzs"]));
                $paqueteLotes = $paqueteLotes['total'];
                $constructorNombre = $this->mconstructores->getCampo2('nombre', $paquete['idConstructor']);
                $constructorApellidoP = $this->mconstructores->getCampo2('apellidoP', $paquete['idConstructor']);
                $constructorApellidoM = $this->mconstructores->getCampo2('apellidoM', $paquete['idConstructor']);
                $constructor = $constructorNombre . ' ' . $constructorApellidoP . ' ' . $constructorApellidoM;
                $totalViviendas = $paqueteLotes;
                $presupuestoUnit = 0;
                //$totalContrato = 0;
                $fechaInicio = date_format(date_create($paquete['fecha_inicio']), 'd-m-Y');
                $fechaFin = date_format(date_create($paquete['fecha_fin']), 'd-m-Y');
                $actividadesPresupuesto = $this->mpresupuestomo->getByIdManoObra($paquete['idManoObra']);
                $empty = true;
                $arrayPresupuestoMO = array();
                $countArray = 0;
                if (!is_numeric($actividadesPresupuesto)) {
                    foreach ($actividadesPresupuesto->result() as $row) {
                        $existe = 0;
                        $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                        if (!is_numeric($actividadPrototipo)) {
                            $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                            if (!is_numeric($actividad)) {
                                $empty = false;
                                $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                                if (!is_numeric($categoria)) {
                                    if (count($arrayPresupuestoMO) > 0) {
                                        $countArray = count($arrayPresupuestoMO) - 1;
                                        for ($j = 0; $j <= $countArray; $j++) {
                                            if ($arrayPresupuestoMO[$j]['clave'] == $categoria['clave']) {
                                                $existe++;
                                                $precioUnitario = $arrayPresupuestoMO[$j]['precioUnitario'] + $row->precioUnitario;
                                                $importe = $arrayPresupuestoMO[$j]['importe'] + $row->importe;
                                                $arrayPresupuestoMO[$j]['precioUnitario'] = $precioUnitario;
                                                $arrayPresupuestoMO[$j]['importe'] = $importe;
                                            }
                                        }
                                        if ($existe == 0) {
                                            array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                        }
                                    } else {
                                        array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                    }
                                }

                                $unidad = $this->munidades->getById($actividad['idUnidad']);
                                if (!is_numeric($unidad)) {
                                    array_push($arrayPresupuestoMO, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe));
                                }
                            }
                        }
                    }
                }
            }
            if (!$empty) {
                if (count($arrayPresupuestoMO) > 0) {
                    $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                    $objPHPExcel->getActiveSheet()->setTitle('PRESUPUESTO MANO OBRA PAQUETE');
                    $objPHPExcel->setActiveSheetIndex(0);

                    $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                    $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                    // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                    $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                    $objDrawing->setName('Logo Vviend');
                    $objDrawing->setDescription('Logo Viviend');
                    $objDrawing->setImageResource($gdImage);
                    $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                    $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                    $objDrawing->setOffsetX(150);
                    $objDrawing->setOffsetY(0);
                    $objDrawing->setWidth(900);
                    $objDrawing->setHeight(140);
                    $objDrawing->setCoordinates('A1');
                    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                    $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CLAVE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'DESCRIPCION');
                    $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'UNIDAD');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'CANTIDAD');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'PRECIO UNITARIO');
                    $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'IMPORTE');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'IMPORTE POR PAQUETE');

                    $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );

                    $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B9', $fraccionamiento);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'PROTOTIPO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B10', $prototipo);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'CONTRATISTA:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B11', $constructor);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'NO. DE VIV:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B12', $totalViviendas);
                    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                    //

                    $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANAS');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D9', $manzanas);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'LOTES:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D10', $lotes);

                    $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'PRESUPUESTO UNIT.:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));

                    $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'TOTAL CONTRATO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    //

                    $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'INICIO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G9', $fechaInicio);

                    $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'TERMINO PROGRAMADO:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G10', $fechaFin);

                    $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'INICIO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G11', '');

                    $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'TERMINO REAL:');
                    $objPHPExcel->getActiveSheet()->SetCellValue('G12', '');

                    $rowCount = 14;
                    $rowCategoria = 0;
                    $importeCategoria = 0;
                    $importePaqueteCategoria = 0;
                    foreach ($arrayPresupuestoMO as $row) {
                        if ($row['tipo'] == 'C') {
                            $clave = $row['clave'];
                            $descripcion = $row['descripcion'];
                            $unidad = '';
                            $cantidad = '';
                            $precioUnitario = '';
                            $importe = '';
                            $importePaquete = '';
                            $rowCategoria = $rowCount;
                            $importeCategoria = 0;
                            $importePaqueteCategoria = 0;

                            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCategoria . ':B' . $rowCategoria)->applyFromArray(
                                array('fill' => array(
                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                    'color' => array('rgb' => 'D9D9D9')
                                ))
                            );

                            $objPHPExcel->getActiveSheet()->getStyle('C' . $rowCategoria . ':G' . $rowCategoria)->applyFromArray(
                                array('fill' => array(
                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                    'color' => array('rgb' => '595959')
                                ))
                            );
                        } else {
                            $clave = $row['clave'];
                            $descripcion = $row['descripcion'];
                            $unidad = $row['unidad'];
                            $cantidad = $row['cantidad'];
                            $precioUnitario = precio_format($row['precioUnitario']);
                            $importe = $row['importe'];
                            $presupuestoUnit = $presupuestoUnit + $importe;
                            $importePaquete = $row['importe'] * $paqueteLotes;
                            $totalContrato = $totalContrato + $importePaquete;

                            $importeCategoria = $importeCategoria + $importe;
                            $importePaqueteCategoria = $importePaqueteCategoria + $importePaquete;

                            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':G' . $rowCount)->applyFromArray(
                                array('fill' => array(
                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                    'color' => array('rgb' => 'FFFFFF')
                                ))
                            );
                        }

                        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $clave);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $descripcion);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $unidad);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $cantidad);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $precioUnitario);
                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($importe));
                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($importePaquete));

                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCategoria, precio_format($importeCategoria));
                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCategoria, precio_format($importePaqueteCategoria));

                        $rowCount++;
                    }

                    $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format($presupuestoUnit));
                    $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format($totalContrato));

                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($presupuestoUnit));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format($totalContrato));

                    $styleArray = array(
                        'borders' => array(
                            'allBorders' => array(
                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                            )
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle(
                        'A13:G' . $rowCount
                    )->applyFromArray($styleArray);

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);


                    //Funcionalidad para agregar las estimaciones cantidad e importe
                    $inicial = 'A';
                    $final = '';
                    $letra = 'I';
                    $diaEstimado = 'I';
                    $diaInicial = 1;
                    $rowFinal = 0;
                    $lastColumn = '';
                    $arrayAcumulado = array();
                    $countArrayAcumulado = 0;
                    $arrayEjecutar = array();
                    $countArrayEjecutar = 0;
                    $totalEstimaciones = 0;
                    $totalAnticipo = 0;
                    $totalFG = 0;
                    $totalOtras = 0;
                    $estimaciones = $this->mestimacionesprograma->getByIdEstimacion($estimacion['id']);
                    if (!is_numeric($estimaciones)) {
                        $tituloFactura = 'Factura';
                        $tituloAvance = '% Avance';
                        $tituloEstimacion = 'Estimación';
                        $tituloAnticipo = 'Ret Anticipo';
                        $tituloFg = 'Ret FG';
                        $tituloOtras = 'Ret Otras';
                        $tituloSubtotal = 'Subtotal';
                        $tituloIva = 'I.V.A. (excento)';
                        $tituloTotal = 'Total';
                        $tituloPago = 'Pago';
                        $tituloFecha = 'Fecha';
                        $tituloPdtePago = 'Pdte de Pago';
                        foreach ($estimaciones->result() as $e) {
                            $qOrdenPagoEstimacion = $this->mordenpago->getByIdEstimaciones($e->id);
                            if(!is_numeric($qOrdenPagoEstimacion) || is_numeric($qOrdenPagoEstimacion)){
                                $actividadesPresupuesto = $this->db->query('SELECT p.*, e.estimacion FROM estimados_programa AS e INNER JOIN presupuesto_mo AS p ON e.idPresupuesto = p.id
                                                                            WHERE e.idEstimaciones = '.$e->id.' ORDER BY (SELECT idCategoria FROM actividadesprototipo WHERE id=idActividadPrototipo) ASC');
                                $arrayPresupuestoEstimacion = $arrayPresupuestoMO;
                                if ($actividadesPresupuesto->num_rows() > 0) {
                                    foreach ($actividadesPresupuesto->result() as $row) {
                                        $existe = 0;
                                        $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                                        if (!is_numeric($actividadPrototipo)) {
                                            $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                                            if (!is_numeric($actividad)) {
                                                $empty = false;
                                                $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                                                if (!is_numeric($categoria)) {
                                                    $found_key = array_search($categoria['clave'], array_column($arrayPresupuestoEstimacion, 'clave'));
                                                    $arrayPresupuestoEstimacion[$found_key]['estimacion'] = '';
                                                }

                                                $unidad = $this->munidades->getById($actividad['idUnidad']);
                                                if (!is_numeric($unidad)) {
                                                    $found_key = array_search($actividad['clave'], array_column($arrayPresupuestoEstimacion, 'clave'));
                                                    $arrayPresupuestoEstimacion[$found_key]['estimacion'] = $row->estimacion;
                                                }
                                            }
                                        }
                                    }

                                    foreach ($actividadesPresupuesto->result() as $row) {
                                        $existe = 0;
                                        $existeActividad = 0;
                                        $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                                        if (!is_numeric($actividadPrototipo)) {
                                            $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                                            if (!is_numeric($actividad)) {
                                                $empty = false;
                                                $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                                                if (!is_numeric($categoria)) {
                                                    if (count($arrayAcumulado) > 0) {
                                                        $countArrayAcumulado = count($arrayAcumulado) - 1;
                                                        for ($j = 0; $j <= $countArrayAcumulado; $j++) {
                                                            if ($arrayAcumulado[$j]['clave'] == $categoria['clave']) {
                                                                $existe++;
                                                                $precioUnitario = $arrayAcumulado[$j]['precioUnitario'] + $row->precioUnitario;
                                                                $importe = $arrayAcumulado[$j]['importe'] + $row->importe;
                                                                $arrayAcumulado[$j]['precioUnitario'] = $precioUnitario;
                                                                $arrayAcumulado[$j]['importe'] = $importe;
                                                            }
                                                        }
                                                        if ($existe == 0) {
                                                            array_push($arrayAcumulado, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' => ''));
                                                        }
                                                    } else {
                                                        array_push($arrayAcumulado, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' => ''));
                                                    }
                                                }

                                                $unidad = $this->munidades->getById($actividad['idUnidad']);
                                                if (!is_numeric($unidad)) {
                                                    $countArrayAcumulado = count($arrayAcumulado) - 1;
                                                    for ($j = 0; $j <= $countArrayAcumulado; $j++) {
                                                        if ($arrayAcumulado[$j]['clave'] == $actividad['clave']) {
                                                            $existeActividad++;
                                                            /*$precioUnitario = $arrayAcumulado[$j]['precioUnitario'] + $row->precioUnitario;
                                                            $importe = $arrayAcumulado[$j]['importe'] + $row->importe;
                                                            $arrayAcumulado[$j]['precioUnitario'] = $precioUnitario;
                                                            $arrayAcumulado[$j]['importe'] = $importe;*/
                                                            $estimacionesAcumulado = $arrayAcumulado[$j]['estimacion'] + $row->estimacion;
                                                            $arrayAcumulado[$j]['estimacion'] = $estimacionesAcumulado;
                                                        }
                                                    }
                                                    if($existeActividad == 0){
                                                        array_push($arrayAcumulado, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' =>  $row->estimacion));
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    $arrayEjecutar = $arrayAcumulado;
                                    $countArrayEjecutar = count($arrayEjecutar) - 1;
                                    if($countArrayEjecutar > 0){
                                        for ($j = 0; $j <= $countArrayEjecutar; $j++) {
                                            if ($arrayEjecutar[$j]['tipo'] == 'A') {
                                                $ejecutarEstimacion = $paqueteLotes - $arrayEjecutar[$j]['estimacion'];
                                                $arrayEjecutar[$j]['estimacion'] = $ejecutarEstimacion;
                                            }
                                        }
                                    }

                                    /*foreach ($actividadesPresupuesto->result() as $row) {
                                        $existe = 0;
                                        $existeActividad = 0;
                                        $actividadPrototipo = $this->mactividadesprototipo->getById($row->idActividadPrototipo);
                                        if (!is_numeric($actividadPrototipo)) {
                                            $actividad = $this->mactividadmo->getById($actividadPrototipo['idActividad']);
                                            if (!is_numeric($actividad)) {
                                                $empty = false;
                                                $categoria = $this->mcategoriamo->getById($actividad['idCategoria']);
                                                if (!is_numeric($categoria)) {
                                                    if (count($arrayEjecutar) > 0) {
                                                        $countArrayEjecutar = count($arrayEjecutar) - 1;
                                                        for ($j = 0; $j <= $countArrayEjecutar; $j++) {
                                                            if ($arrayEjecutar[$j]['clave'] == $categoria['clave']) {
                                                                $existe++;
                                                                $precioUnitario = $arrayEjecutar[$j]['precioUnitario'] + $row->precioUnitario;
                                                                $importe = $arrayEjecutar[$j]['importe'] + $row->importe;
                                                                $arrayEjecutar[$j]['precioUnitario'] = $precioUnitario;
                                                                $arrayEjecutar[$j]['importe'] = $importe;
                                                            }
                                                        }
                                                        if ($existe == 0) {
                                                            array_push($arrayEjecutar, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' => ''));
                                                        }
                                                    } else {
                                                        array_push($arrayEjecutar, array('categoria' => $actividad['idCategoria'], 'tipo' => 'C', 'idPresupuesto' => 0, 'clave' => $categoria['clave'], 'descripcion' => $categoria['categoria'], 'unidad' => '', 'cantidad' => '', 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' => ''));
                                                    }
                                                }

                                                $unidad = $this->munidades->getById($actividad['idUnidad']);
                                                if (!is_numeric($unidad)) {
                                                    $countArrayEjecutar = count($arrayEjecutar) - 1;
                                                    for ($j = 0; $j <= $countArrayEjecutar; $j++) {
                                                        if ($arrayEjecutar[$j]['clave'] == $actividad['clave']) {
                                                            $existeActividad++;
                                                            $precioUnitario = $arrayAcumulado[$j]['precioUnitario'] + $row->precioUnitario;
                                                            $importe = $arrayAcumulado[$j]['importe'] + $row->importe;
                                                            $arrayAcumulado[$j]['precioUnitario'] = $precioUnitario;
                                                            $arrayAcumulado[$j]['importe'] = $importe;
                                                            $estimacionesEjecutar = $arrayEjecutar[$j]['estimacion'] + $row->estimacion;
                                                            $arrayEjecutar[$j]['estimacion'] = $estimacionesEjecutar;
                                                        }
                                                    }
                                                    if ($existeActividad == 0) {
                                                        $ejecutarEstimacion = $paqueteLotes - $row->estimacion;
                                                        array_push($arrayEjecutar, array('categoria' => $actividad['idCategoria'], 'tipo' => 'A', 'idPresupuesto' => $row->id, 'clave' => $actividad['clave'], 'descripcion' => $actividad['descripcion'], 'unidad' => $unidad['abreviatura'], 'cantidad' => $actividadPrototipo['cantidad'], 'precioUnitario' => $row->precioUnitario, 'importe' => $row->importe, 'estimacion' =>  $ejecutarEstimacion));
                                                    }
                                                }
                                            }
                                        }
                                    }*/

                                    $rowInicial = 1;
                                    $rowFinal = 2;
                                    $letraInicial = $letra;
                                    $date = date_create($e->fecha);
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '11', date_format($date, 'd-m-Y'));
                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '12', 'ESTIMACION ' . $e->nEstimacion);

                                    $fontStyle = array(
                                        'font' => array(
                                            'size' => 12
                                        )
                                    );

                                    $objPHPExcel->getActiveSheet()->getStyle($letra . '11')->applyFromArray($fontStyle);
                                    $objPHPExcel->getActiveSheet()->getStyle($letra . '12')->applyFromArray($fontStyle);

                                    for ($rowInicial; $rowInicial <= $rowFinal; $rowInicial++) {
                                        $styleArrayS = array(
                                            'borders' => array(
                                                'outline' => array(
                                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                                )
                                            )
                                        );
                                        switch ($rowInicial) {
                                            case 1:
                                                $rowCountPagos = 0;
                                                $rowCountPagosInicial = 1;
                                                $rowCountPagosFinal = 14;
                                                if(count($arrayPresupuestoEstimacion) > 0){
                                                    $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setWidth(13);
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '13', 'CANTIDAD');
                                                    $rowCount = 14;
                                                    $rowCategoria = 0;
                                                    $cantidadCategoria = 0;
                                                    $totalCantidad = 0;
                                                    /*echo "<pre>";
                                                    print_r($arrayPresupuestoEstimacion);
                                                    exit();*/
                                                    foreach($arrayPresupuestoEstimacion as $r){
                                                        if ($r['tipo'] == 'C') {
                                                            $cantidad = '';
                                                            $rowCategoria = $rowCount;
                                                            $cantidadCategoria = 0;

                                                            $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCategoria)->applyFromArray(
                                                                array('fill' => array(
                                                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                    'color' => array('rgb' => '262626')
                                                                ))
                                                            );

                                                            $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCategoria)->applyFromArray(
                                                                array('font' => array(
                                                                    'color' => array('rgb' => 'FFFFFF')
                                                                ))
                                                            );
                                                        }else{
                                                            $cantidad = (isset($r['estimacion'])) ? $r['estimacion'] : 0;
                                                            $cantidadCategoria = $cantidadCategoria + $cantidad;
                                                            $totalCantidad = $totalCantidad + $cantidad;
                                                        }
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra. $rowCount, $cantidad);
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCategoria, $cantidadCategoria);
                                                        $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray($styleArrayS);
                                                        $rowCount++;
                                                    }

                                                    $rowCountPagos = $rowCount + 3;

                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCount, $totalCantidad);

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray(
                                                        array('fill' => array(
                                                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                            'color' => array('rgb' => '262626')
                                                        ))
                                                    );

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray(
                                                        array('font' => array(
                                                            'color' => array('rgb' => 'FFFFFF')
                                                        ))
                                                    );

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray($styleArrayS);

                                                }

                                                for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                    switch ($rowCountPagosInicial) {
                                                        case 1:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloFactura);
                                                            break;
                                                        case 2:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloAvance);
                                                            break;
                                                        case 3:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloEstimacion);
                                                            break;
                                                        case 4:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloAnticipo);
                                                            break;
                                                        case 5:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloFg);
                                                            break;
                                                        case 6:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloOtras);
                                                            break;
                                                        case 7:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloSubtotal);
                                                            break;
                                                        case 8:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloIva);
                                                            break;
                                                        case 9:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloTotal);
                                                            break;
                                                        case 10:

                                                            break;
                                                        case 11:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloPago);
                                                            break;
                                                        case 12:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloFecha);
                                                            break;
                                                        case 13:

                                                            break;
                                                        case 14:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, $tituloPdtePago);
                                                            break;
                                                    }
                                                    $rowCountPagos++;
                                                }
                                                break;
                                            case 2:
                                                $rowCountPagos = 0;
                                                $rowCountPagosInicial = 1;
                                                $rowCountPagosFinal = 14;
                                                $rowCount = 14;
                                                $rowCategoria = 0;
                                                $importeCategoria = 0;
                                                $totalImporte = 0;
                                                if (count($arrayPresupuestoEstimacion) > 0) {
                                                    $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setWidth(13);
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . '13', 'IMPORTE');
                                                    foreach ($arrayPresupuestoEstimacion as $r) {
                                                        if ($r['tipo'] == 'C') {
                                                            $importe = '';
                                                            $rowCategoria = $rowCount;
                                                            $importeCategoria = 0;

                                                            $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCategoria)->applyFromArray(
                                                                array('fill' => array(
                                                                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                    'color' => array('rgb' => '262626')
                                                                ))
                                                            );

                                                            $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCategoria)->applyFromArray(
                                                                array('font' => array(
                                                                    'color' => array('rgb' => 'FFFFFF')
                                                                ))
                                                            );

                                                        } else {
                                                            $cantidad = (isset($r['estimacion'])) ? $r['estimacion'] : 0;
                                                            $importe = $cantidad * $r['importe'];
                                                            $importeCategoria = $importeCategoria + $importe;
                                                            $totalImporte = $totalImporte + $importe;
                                                        }
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCount, precio_format($importe));
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCategoria, precio_format($importeCategoria));

                                                        $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray($styleArrayS);
                                                        $rowCount++;
                                                    }

                                                    $rowCountPagos = $rowCount + 3;

                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCount, precio_format($totalImporte));

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray(
                                                        array('fill' => array(
                                                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                            'color' => array('rgb' => '262626')
                                                        ))
                                                    );

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray(
                                                        array('font' => array(
                                                            'color' => array('rgb' => 'FFFFFF')
                                                        ))
                                                    );

                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCount)->applyFromArray($styleArrayS);
                                                }

                                                $ordenPagoEstimacion = $this->mordenpago->getByIdEstimaciones($e->id);
                                                $anticipo = 0;
                                                $fg = 0;
                                                $otras = 0;
                                                $subtotal = 0;
                                                $iva = 0;
                                                $total = 0;
                                                $statusPago = '';
                                                $fechaPago = '';
                                                if(!is_numeric($ordenPagoEstimacion)){
                                                    $anticipo = $ordenPagoEstimacion['retencionAnticipo'];
                                                    $fg = $ordenPagoEstimacion['retencion'];
                                                    $otras = $ordenPagoEstimacion['retencionvicios'];
                                                    $statusPago = $ordenPagoEstimacion['statusPago'];
                                                    $fechaPago = $ordenPagoEstimacion['fechaAplicado'];
                                                }

                                                for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                    switch ($rowCountPagosInicial) {
                                                        case 1:
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                            break;
                                                        case 2:
                                                            $porcentaje = $totalImporte / $totalContrato * 100;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, round($porcentaje, 2).'%');
                                                            break;
                                                        case 3:
                                                            $totalEstimaciones = $totalEstimaciones + $totalImporte;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($totalImporte));
                                                            break;
                                                        case 4:
                                                            $totalAnticipo = $totalAnticipo + $anticipo;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($anticipo));
                                                            break;
                                                        case 5:
                                                            $totalFG = $totalFG + $fg;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($fg));
                                                            break;
                                                        case 6:
                                                            $totalOtras = $totalOtras + $otras;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($otras));
                                                            break;
                                                        case 7:
                                                            $subtotal = $totalImporte - $anticipo - $fg - $otras;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($subtotal));
                                                            break;
                                                        case 8:
                                                            $iva = $subtotal * 0.16;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                            break;
                                                        case 9:
                                                            //$total = $subtotal + $iva;
                                                            $total = $subtotal + 0;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($total));
                                                            break;
                                                        case 10:

                                                            break;
                                                        case 11:
                                                            /*if($statusPago != ''){
                                                                switch ($statusPago) {
                                                                    case 1:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, 'Pendiente');
                                                                        break;
                                                                    case 2:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, 'Pagado');
                                                                        break;
                                                                    default:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                                        break;
                                                                }
                                                            }else{
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                            }*/
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($subtotal));
                                                            break;
                                                        case 12:
                                                            if($fechaPago != ''){
                                                                $date = date_create($fechaPago);
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, date_format($date, 'd-m-Y'));
                                                            }else{
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                            }
                                                            break;
                                                        case 13:

                                                            break;
                                                        case 14:
                                                            /*if ($statusPago != '') {
                                                                switch ($statusPago) {
                                                                    case 1:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($total));
                                                                        break;
                                                                    case 2:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                                        break;
                                                                    default:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                                        break;
                                                                }
                                                            } else {
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                            }*/
                                                            $pendiente = $total - $subtotal;
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($pendiente));
                                                            break;
                                                    }
                                                    $objPHPExcel->getActiveSheet()->getStyle($letra . $rowCountPagos)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                                                    $rowCountPagos++;
                                                }
                                                break;
                                        }

                                        if ($rowInicial == 2) {
                                            $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '11:' . $letra . '11');
                                            $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '12:' . $letra . '12');

                                            $styleArrayS = array(
                                                'borders' => array(
                                                    'outline' => array(
                                                        'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                                    )
                                                )
                                            );

                                            $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '11:' . $letra . '11')->applyFromArray($styleArrayS);
                                            $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '12:' . $letra . '12')->applyFromArray($styleArrayS);
                                            $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '13:' . $letra . '13')->applyFromArray($styleArrayS);
                                        }

                                        $objPHPExcel->getActiveSheet()->getStyle($letra . '11')->getAlignment()->applyFromArray(
                                            array(
                                                'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                                'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                            )
                                        );

                                        $objPHPExcel->getActiveSheet()->getStyle($letra . '12')->getAlignment()->applyFromArray(
                                            array(
                                                'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                                'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                            )
                                        );

                                        $objPHPExcel->getActiveSheet()->getStyle($letra . '13')->getAlignment()->applyFromArray(
                                            array(
                                                'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                                'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                            )
                                        );

                                        $letra++;
                                    }
                                    $final = $letra;

                                    $tituloFactura = '';
                                    $tituloAvance = '';
                                    $tituloEstimacion = '';
                                    $tituloAnticipo = '';
                                    $tituloFg = '';
                                    $tituloOtras = '';
                                    $tituloSubtotal = '';
                                    $tituloIva = '';
                                    $tituloTotal = '';
                                    $tituloPago = '';
                                    $tituloFecha = '';
                                    $tituloPdtePago = '';
                                }

                                $lastColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();
                            }
                        }

                        $letra++;
                        $letraAcumulado = $letra;
                        $diaInicial = 1;
                        $diaFinal = 2;
                        for ($diaInicial; $diaInicial <= $diaFinal; $diaInicial++) {
                            $rowInicial = 1;
                            $rowFinal = 2;
                            $letraInicial = $letraAcumulado;

                            if($diaInicial == 1){
                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '12', 'ACUMULADO');

                                $fontStyle = array(
                                    'font' => array(
                                        'size' => 12
                                    )
                                );

                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '11')->applyFromArray($fontStyle);
                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '12')->applyFromArray($fontStyle);
                                for ($rowInicial; $rowInicial <= $rowFinal; $rowInicial++) {
                                    $styleArrayS = array(
                                        'borders' => array(
                                            'outline' => array(
                                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                            )
                                        )
                                    );
                                    switch ($rowInicial) {
                                        case 1:
                                            $rowCountPagos = 0;
                                            $rowCountPagosInicial = 1;
                                            $rowCountPagosFinal = 14;
                                            if (count($arrayAcumulado) > 0) {
                                                $objPHPExcel->getActiveSheet()->getColumnDimension($letraAcumulado)->setWidth(13);
                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '13', 'CANTIDAD');
                                                $rowCount = 14;
                                                $rowCategoria = 0;
                                                $cantidadCategoria = 0;
                                                $totalCantidad = 0;
                                                foreach ($arrayAcumulado as $r) {
                                                    if ($r['tipo'] == 'C') {
                                                        $cantidad = '';
                                                        $rowCategoria = $rowCount;
                                                        $cantidadCategoria = 0;

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('fill' => array(
                                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                'color' => array('rgb' => '262626')
                                                            ))
                                                        );

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('font' => array(
                                                                'color' => array('rgb' => 'FFFFFF')
                                                            ))
                                                        );

                                                    } else {
                                                        $cantidad = $r['estimacion'];
                                                        $cantidadCategoria = $cantidadCategoria + $cantidad;
                                                        $totalCantidad = $totalCantidad + $cantidad;
                                                    }
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, $cantidad);
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCategoria, $cantidadCategoria);
                                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                                    $rowCount++;
                                                }

                                                $rowCountPagos = $rowCount + 3;

                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, $totalCantidad);

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('fill' => array(
                                                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                        'color' => array('rgb' => '262626')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('font' => array(
                                                        'color' => array('rgb' => 'FFFFFF')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                            }

                                            for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                switch ($rowCountPagosInicial) {
                                                    case 1:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFactura);
                                                        break;
                                                    case 2:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloAvance);
                                                        break;
                                                    case 3:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloEstimacion);
                                                        break;
                                                    case 4:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloAnticipo);
                                                        break;
                                                    case 5:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFg);
                                                        break;
                                                    case 6:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloOtras);
                                                        break;
                                                    case 7:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloSubtotal);
                                                        break;
                                                    case 8:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloIva);
                                                        break;
                                                    case 9:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloTotal);
                                                        break;
                                                    case 10:

                                                        break;
                                                    case 11:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloPago);
                                                        break;
                                                    case 12:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFecha);
                                                        break;
                                                    case 13:

                                                        break;
                                                    case 14:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloPdtePago);
                                                        break;
                                                }
                                                $rowCountPagos++;
                                            }
                                            break;
                                        case 2:
                                            $rowCountPagos = 0;
                                            $rowCountPagosInicial = 1;
                                            $rowCountPagosFinal = 14;
                                            $rowCount = 14;
                                            $rowCategoria = 0;
                                            $importeCategoria = 0;
                                            $totalImporte = 0;
                                            if (count($arrayAcumulado) > 0) {
                                                $objPHPExcel->getActiveSheet()->getColumnDimension($letraAcumulado)->setWidth(13);
                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '13', 'IMPORTE');
                                                foreach ($arrayAcumulado as $r) {
                                                    if ($r['tipo'] == 'C') {
                                                        $importe = '';
                                                        $rowCategoria = $rowCount;
                                                        $importeCategoria = 0;

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('fill' => array(
                                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                'color' => array('rgb' => '262626')
                                                            ))
                                                        );

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('font' => array(
                                                                'color' => array('rgb' => 'FFFFFF')
                                                            ))
                                                        );

                                                    } else {
                                                        $importe = $r['estimacion'] * $r['importe'];
                                                        $importeCategoria = $importeCategoria + $importe;
                                                        $totalImporte = $totalImporte + $importe;
                                                    }
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, precio_format($importe));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCategoria, precio_format($importeCategoria));

                                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                                    $rowCount++;
                                                }

                                                $rowCountPagos = $rowCount + 3;

                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, precio_format($totalImporte));

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('fill' => array(
                                                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                        'color' => array('rgb' => '262626')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('font' => array(
                                                        'color' => array('rgb' => 'FFFFFF')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                            }

                                            $ordenPagoEstimacion = $this->mordenpago->getByIdEstimaciones($e->id);
                                            $anticipo = 0;
                                            $fg = 0;
                                            $otras = 0;
                                            $subtotal = 0;
                                            $iva = 0;
                                            $total = 0;
                                            $statusPago = '';
                                            $fechaPago = '';
                                            if (!is_numeric($ordenPagoEstimacion)) {
                                                $anticipo = $ordenPagoEstimacion['retencionAnticipo'];
                                                $fg = $ordenPagoEstimacion['retencion'];
                                                $otras = $ordenPagoEstimacion['retencionvicios'];
                                                $statusPago = $ordenPagoEstimacion['statusPago'];
                                                $fechaPago = $ordenPagoEstimacion['fechaAplicado'];
                                            }

                                            for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                switch ($rowCountPagosInicial) {
                                                    case 1:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                    case 2:
                                                        $porcentaje = $totalEstimaciones / $totalContrato * 100;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, round($porcentaje, 2) . '%');
                                                        break;
                                                    case 3:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($totalEstimaciones));
                                                        break;
                                                    case 4:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($totalAnticipo));
                                                        break;
                                                    case 5:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($totalFG));
                                                        break;
                                                    case 6:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($totalOtras));
                                                        break;
                                                    case 7:
                                                        $subtotal = $totalEstimaciones - $totalAnticipo - $totalFG - $totalOtras;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($subtotal));
                                                        break;
                                                    case 8:
                                                        $iva = $subtotal * 0.16;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format(0));
                                                        break;
                                                    case 9:
                                                        //$total = $subtotal + $iva;
                                                        $total = $subtotal + 0;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($total));
                                                        break;
                                                    case 10:

                                                        break;
                                                    case 11:
                                                        /*if($statusPago != ''){
                                                                switch ($statusPago) {
                                                                    case 1:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, 'Pendiente');
                                                                        break;
                                                                    case 2:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, 'Pagado');
                                                                        break;
                                                                    default:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                                        break;
                                                                }
                                                            }else{
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, '');
                                                            }*/
                                                        //$objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($subtotal));
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                    case 12:
                                                        if ($fechaPago != '') {
                                                            $date = date_create($fechaPago);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, date_format($date, 'd-m-Y'));
                                                        } else {
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        }
                                                        break;
                                                    case 13:

                                                        break;
                                                    case 14:
                                                        /*if ($statusPago != '') {
                                                                switch ($statusPago) {
                                                                    case 1:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format($total));
                                                                        break;
                                                                    case 2:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                                        break;
                                                                    default:
                                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                                        break;
                                                                }
                                                            } else {
                                                                $objPHPExcel->getActiveSheet()->SetCellValue($letra . $rowCountPagos, precio_format(0));
                                                            }*/
                                                        $pendiente = $total - $subtotal;
                                                        //$objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($pendiente));
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                }
                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCountPagos)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                                                $rowCountPagos++;
                                            }
                                            break;
                                    }

                                    if ($rowInicial == 2) {
                                        $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '11:' . $letraAcumulado . '11');
                                        $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '12:' . $letraAcumulado . '12');

                                        $styleArrayS = array(
                                            'borders' => array(
                                                'outline' => array(
                                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                                )
                                            )
                                        );

                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '11:' . $letraAcumulado . '11')->applyFromArray($styleArrayS);
                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '12:' . $letraAcumulado . '12')->applyFromArray($styleArrayS);
                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '13:' . $letraAcumulado . '13')->applyFromArray($styleArrayS);
                                    }

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '11')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '12')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '13')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $letraAcumulado++;
                                }
                            }else if($diaInicial == 2){
                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '12', 'POR EJECUTAR');

                                $fontStyle = array(
                                    'font' => array(
                                        'size' => 12
                                    )
                                );

                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '11')->applyFromArray($fontStyle);
                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '12')->applyFromArray($fontStyle);

                                for ($rowInicial; $rowInicial <= $rowFinal; $rowInicial++) {
                                    $styleArrayS = array(
                                        'borders' => array(
                                            'outline' => array(
                                                'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                            )
                                        )
                                    );
                                    switch ($rowInicial) {
                                        case 1:
                                            $rowCountPagos = 0;
                                            $rowCountPagosInicial = 1;
                                            $rowCountPagosFinal = 14;
                                            if (count($arrayEjecutar) > 0) {
                                                $objPHPExcel->getActiveSheet()->getColumnDimension($letraAcumulado)->setWidth(13);
                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '13', 'CANTIDAD');
                                                $rowCount = 14;
                                                $rowCategoria = 0;
                                                $cantidadCategoria = 0;
                                                $totalCantidad = 0;
                                                foreach ($arrayEjecutar as $r) {
                                                    if ($r['tipo'] == 'C') {
                                                        $cantidad = '';
                                                        $rowCategoria = $rowCount;
                                                        $cantidadCategoria = 0;

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('fill' => array(
                                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                'color' => array('rgb' => '262626')
                                                            ))
                                                        );

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('font' => array(
                                                                'color' => array('rgb' => 'FFFFFF')
                                                            ))
                                                        );

                                                    } else {
                                                        $cantidad = $r['estimacion'];
                                                        $cantidadCategoria = $cantidadCategoria + $cantidad;
                                                        $totalCantidad = $totalCantidad + $cantidad;
                                                    }
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, $cantidad);
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCategoria, $cantidadCategoria);
                                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                                    $rowCount++;
                                                }

                                                $rowCountPagos = $rowCount + 3;

                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, $totalCantidad);

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('fill' => array(
                                                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                        'color' => array('rgb' => '262626')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('font' => array(
                                                        'color' => array('rgb' => 'FFFFFF')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                            }

                                            for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                switch ($rowCountPagosInicial) {
                                                    case 1:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFactura);
                                                        break;
                                                    case 2:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloAvance);
                                                        break;
                                                    case 3:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloEstimacion);
                                                        break;
                                                    case 4:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloAnticipo);
                                                        break;
                                                    case 5:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFg);
                                                        break;
                                                    case 6:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloOtras);
                                                        break;
                                                    case 7:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloSubtotal);
                                                        break;
                                                    case 8:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloIva);
                                                        break;
                                                    case 9:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloTotal);
                                                        break;
                                                    case 10:

                                                        break;
                                                    case 11:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloPago);
                                                        break;
                                                    case 12:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloFecha);
                                                        break;
                                                    case 13:

                                                        break;
                                                    case 14:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, $tituloPdtePago);
                                                        break;
                                                }
                                                $rowCountPagos++;
                                            }
                                            break;
                                        case 2:
                                            $rowCountPagos = 0;
                                            $rowCountPagosInicial = 1;
                                            $rowCountPagosFinal = 14;
                                            $rowCount = 14;
                                            $rowCategoria = 0;
                                            $importeCategoria = 0;
                                            $totalImporte = 0;
                                            if (count($arrayEjecutar) > 0) {
                                                $objPHPExcel->getActiveSheet()->getColumnDimension($letraAcumulado)->setWidth(13);
                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . '13', 'IMPORTE');
                                                foreach ($arrayEjecutar as $r) {
                                                    if ($r['tipo'] == 'C') {
                                                        $importe = '';
                                                        $rowCategoria = $rowCount;
                                                        $importeCategoria = 0;

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('fill' => array(
                                                                'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                'color' => array('rgb' => '262626')
                                                            ))
                                                        );

                                                        $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCategoria)->applyFromArray(
                                                            array('font' => array(
                                                                'color' => array('rgb' => 'FFFFFF')
                                                            ))
                                                        );

                                                    } else {
                                                        $importe = $r['estimacion'] * $r['importe'];
                                                        $importeCategoria = $importeCategoria + $importe;
                                                        $totalImporte = $totalImporte + $importe;
                                                    }
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, precio_format($importe));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCategoria, precio_format($importeCategoria));

                                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                                    $rowCount++;
                                                }

                                                $rowCountPagos = $rowCount + 3;

                                                $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCount, precio_format($totalImporte));

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('fill' => array(
                                                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                        'color' => array('rgb' => '262626')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray(
                                                    array('font' => array(
                                                        'color' => array('rgb' => 'FFFFFF')
                                                    ))
                                                );

                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCount)->applyFromArray($styleArrayS);
                                            }

                                            $ordenPagoEstimacion = $this->mordenpago->getByIdEstimaciones($e->id);
                                            $anticipo = 0;
                                            $fg = 0;
                                            $otras = 0;
                                            $subtotal = 0;
                                            $iva = 0;
                                            $total = 0;
                                            $statusPago = '';
                                            $fechaPago = '';
                                            if (!is_numeric($ordenPagoEstimacion)) {
                                                $anticipo = $ordenPagoEstimacion['retencionAnticipo'];
                                                $fg = $ordenPagoEstimacion['retencion'];
                                                $otras = $ordenPagoEstimacion['retencionvicios'];
                                                $statusPago = $ordenPagoEstimacion['statusPago'];
                                                $fechaPago = $ordenPagoEstimacion['fechaAplicado'];
                                            }

                                            for ($rowCountPagosInicial; $rowCountPagosInicial <= $rowCountPagosFinal; $rowCountPagosInicial++) {
                                                switch ($rowCountPagosInicial) {
                                                    case 1:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                    case 2:
                                                        $porcentaje = $totalImporte / $totalContrato * 100;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, round($porcentaje, 2) . '%');
                                                        break;
                                                    case 3:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($totalImporte));
                                                        break;
                                                    case 4:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($anticipo));
                                                        break;
                                                    case 5:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($fg));
                                                        break;
                                                    case 6:
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($otras));
                                                        break;
                                                    case 7:
                                                        $subtotal = $totalImporte - $anticipo - $fg - $otras;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($subtotal));
                                                        break;
                                                    case 8:
                                                        $iva = $subtotal * 0.16;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format(0));
                                                        break;
                                                    case 9:
                                                        //$total = $subtotal + $iva;
                                                        $total = $subtotal + 0;
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($total));
                                                        break;
                                                    case 10:

                                                        break;
                                                    case 11:
                                                        //$objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($subtotal));
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                    case 12:
                                                        if ($fechaPago != '') {
                                                            $date = date_create($fechaPago);
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, date_format($date, 'd-m-Y'));
                                                        } else {
                                                            $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        }
                                                        break;
                                                    case 13:

                                                        break;
                                                    case 14:
                                                        $pendiente = $total - $subtotal;
                                                        //$objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, precio_format($pendiente));
                                                        $objPHPExcel->getActiveSheet()->SetCellValue($letraAcumulado . $rowCountPagos, '');
                                                        break;
                                                }
                                                $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . $rowCountPagos)->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                                                $rowCountPagos++;
                                            }
                                            break;
                                    }

                                    if ($rowInicial == 2) {
                                        $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '11:' . $letraAcumulado . '11');
                                        $objPHPExcel->getActiveSheet()->mergeCells($letraInicial . '12:' . $letraAcumulado . '12');

                                        $styleArrayS = array(
                                            'borders' => array(
                                                'outline' => array(
                                                    'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                                                )
                                            )
                                        );

                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '11:' . $letraAcumulado . '11')->applyFromArray($styleArrayS);
                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '12:' . $letraAcumulado . '12')->applyFromArray($styleArrayS);
                                        $objPHPExcel->getActiveSheet()->getStyle($letraInicial . '13:' . $letraAcumulado . '13')->applyFromArray($styleArrayS);
                                    }

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '11')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '12')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $objPHPExcel->getActiveSheet()->getStyle($letraAcumulado . '13')->getAlignment()->applyFromArray(
                                        array(
                                            'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                            'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                                        )
                                    );

                                    $letraAcumulado++;
                                }
                            }
                        }

                    }
                    //Finaliza Funcionalidad

                    $name = $paquete["id"] . "." . $paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
                
            }
        }
    }

    public function exportarOrdenPago($idOrdenPago){
        //$ordenpago = $this->mordenpago->getById($idOrdenPago);
        $info = $this->mordenpago->getById($idOrdenPago);
        if (!is_numeric($info)) {
            switch ($info['statusPago']) {
                case 1:
                    $statusP = 'Pendiente por pagar';
                    break;
                case 2:
                    $statusP = 'Pagado';
                    break;
                case 3:
                    $statusP = 'Facturado';
                    break;
                case 4:
                    $statusP = 'Cancelado';
                    break;
                default:
                    $statusP = '';
                        break;
            }
            //Inicia armado de reporte de orden pago
            $paquete = $this->mpaquete->getById($info['idPaquete']);
            $data['paquete'] = $this->mpaquete->getCampo('titulo', $info['idPaquete']);
            $estimaciones = explode(',', $info['idEstimaciones']);
            $semana = '';
            foreach($estimaciones as $esti){
                $semana = $semana . $this->mestimacionesprograma->getCampo('nEstimacion', $esti) . ', ';
            }
            $data['semana'] = substr($semana, 0 , -2);
            $data['status'] = $statusP;
            $data['monto'] = precio_format($info['monto']);
            $data['rvicios'] = precio_format($info['retencionvicios']);
            $data['retencion'] = precio_format($info['retencion']);
            $data['anticipo'] = precio_format($info['retencionAnticipo']);
            $data['total'] = precio_format($info['monto'] - ($info['retencionvicios'] + $info['retencion'] + $info['retencionAnticipo']));
            $qDetalles = $this->mdetalleop->getAllByIdOrdenPago($info['id']);

            //Inicia armado de excel
            $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
            $objPHPExcel->getActiveSheet()->setTitle('ORDEN DE PAGO');
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

            $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
            // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
            $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
            $objDrawing->setName('Logo Vviend');
            $objDrawing->setDescription('Logo Viviend');
            $objDrawing->setImageResource($gdImage);
            $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
            $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
            $objDrawing->setOffsetX(150);
            $objDrawing->setOffsetY(0);
            $objDrawing->setWidth(1200);
            $objDrawing->setHeight(140);
            $objDrawing->setCoordinates('A1');
            $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'PAQUETE');
            $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'SEMANA');
            $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'ORDEN PAGO');
            $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'ESTADO');

            $objPHPExcel->getActiveSheet()->SetCellValue('B9', $data['paquete']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B10', $data['semana']);
            $objPHPExcel->getActiveSheet()->SetCellValue('B11', $idOrdenPago);
            $objPHPExcel->getActiveSheet()->SetCellValue('B12', $data['status']);

            $objPHPExcel->getActiveSheet()->getStyle("B9:B12")->getAlignment()->applyFromArray(
                array(
                    'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                    'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                array('fill' => array(
                    'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFE699')
                ))
            );
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);

            if(!is_numeric($info)){
                if(!is_numeric($qDetalles)){
                    foreach ($qDetalles->result() as $detalle) {
                        $lotes = $detalle->lotes;
                        $idActProt = $this->mpresupuestomo->getCampo('idActividadPrototipo', $detalle->idPresupuesto);
                        $idAct = $this->mactividadesprototipo->getCampo('idActividad', $idActProt);
                        $idCat = $this->mactividadesprototipo->getCampo('idCategoria', $idActProt);
                        $clave = $this->mactividadmo->getCampo('clave', $idAct);
                        $acti = $this->mactividadmo->getCampo('descripcion', $idAct);
                        $actividades[$idCat][] = array(
                            'lotes' => $lotes,
                            'clave' => $clave,
                            'descripcion' => $acti,
                            'precioU' => precio_format($detalle->precioUnitario),
                            'pagar' => precio_format($detalle->monto)
                        );
                        if(isset($categoria)){
                                if(!in_array($idCat, $categoria) ){
                                $categoria[$idCat] = array('id' => $idCat,
                                    'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                                );
                            }
                        }
                        else{
                            $categoria[$idCat] = array('id' => $idCat,
                                'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                            );
                        }
                    }
                    $nrow=14;
                    $categorias = $categoria;

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
                    //$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(false);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
                    foreach ($categorias as $cate) { 
                        $objPHPExcel->getActiveSheet()->mergeCells("A$nrow:E$nrow");
                        $objPHPExcel->getActiveSheet()->SetCellValue("A$nrow", $cate['categoria']);
                        $objPHPExcel->getActiveSheet()->SetCellValue("A$nrow", $cate['categoria']);
                        $objPHPExcel->getActiveSheet()->getStyle("A$nrow:E$nrow")->getAlignment()->applyFromArray(
                            array(
                                'horizontal' => PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                'vertical' => PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                            )
                        );
                        $nrow++;

                        $objPHPExcel->getActiveSheet()->SetCellValue("A$nrow", "CLAVE");
                        $objPHPExcel->getActiveSheet()->SetCellValue("B$nrow", "DESCRIPCIÓN");
                        $objPHPExcel->getActiveSheet()->SetCellValue("C$nrow", "LOTES");
                        $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "POR ACTIVIDAD");
                        $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", "POR PAGAR");
                        $nrow++;
                        foreach ($actividades[$cate['id']] as $acti) {
                            $objPHPExcel->getActiveSheet()->SetCellValue("A$nrow", $acti['clave']);
                            $objPHPExcel->getActiveSheet()->SetCellValue("B$nrow", $acti['descripcion']);
                            $objPHPExcel->getActiveSheet()->SetCellValue("C$nrow", $acti['lotes']);
                            $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", $acti['precioU']);
                            $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $acti['pagar']);
                            $nrow++;
                        }
                    } 
                    $rowFinal=$nrow+4;
                    $objPHPExcel->getActiveSheet()->getStyle("D$nrow:E$rowFinal")->applyFromArray(
                        array('fill' => array(
                            'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'color' => array('rgb' => 'FFE699')
                        ))
                    );
                    $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "SUBTOTAL");
                    $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $data["monto"]);
                    $nrow++;
                    $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "RETENCIÓN");
                    $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $data["retencion"]);
                    $nrow++;
                    $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "RETENCIÓN DE VICIOS OCULTOS");
                    $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $data["rvicios"]);
                    $nrow++;
                    $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "RETENCIÓN DE ANTICIPO");
                    $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $data["anticipo"]);
                    $nrow++;
                    $objPHPExcel->getActiveSheet()->SetCellValue("D$nrow", "TOTAL");
                    $objPHPExcel->getActiveSheet()->SetCellValue("E$nrow", $data["total"]);
                    $nrow++;

                    //Finaliza
                    $name = "Detalle Orden Pago -" . $paquete["titulo"];
                    header('Content-Type: application/vnd.ms-excel');
                    header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                    header('Cache-Control: max-age=0'); //no cache
                    $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                    // Forzamos a la descarga
                    $objWriter->save('php://output');
                }
                
            }
        }
    }

    public function listarOrdenes($id){
        $idPaquete = $this->mestimacionprograma->getCampo('idPaquete', $id);
        $q = $this->mordenpago->getAllbyIdPaquete($idPaquete);
        if (!is_numeric($q)){
            foreach ($q->result() as $a => $row){
                $totalN = 0;
                $ac = false;
                switch ($row->statusPago) {
                    case 1:
                        $statusP = 'Pendiente por pagar';
                        $ac = true;
                        break;
                    case 2:
                        $statusP = 'Pagado';
                        break;
                    case 3:
                        $statusP = 'Facturado';
                        break;
                    case 4:
                        $statusP = 'Cancelado';
                        break;
                    default:
                        $statusP = '';
                        break;
                }
                $totalN = $row->monto - ($row->retencion + $row->retencionvicios + $row->retencionAnticipo);
                $array['aaData'][] = array(
                    'semana' =>  $a + 1,
                    'monto' => ($row->monto != '')? "$".number_format($row->monto,2) : '',
                    'retencion' => ($row->retencion != '')? "$".number_format($row->retencion,2) : '',
                    'retencionV' => ($row->retencionvicios != '')? "$".number_format($row->retencionvicios,2) : '',
                    'retencionA' => ($row->retencionAnticipo != '')? "$".number_format($row->retencionAnticipo,2) : '',
                    'totalN' => "$".number_format($totalN,2),
                    'statusPago' => $statusP,
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","estimaciones_programa")['w']))? accionesOrdenes($row->id, $this->router->class, true, false, $ac, $ac) : '',
                    '_monto' => $row->monto,
                    '_retencion' => $row->retencion,
                    '_retencionV' => $row->retencionvicios,
                    '_retencionA' => $row->retencionAnticipo,
                    '_totalN' => $totalN
                );
            }
        }else{
            $array['aaData'][] = array(
                'semana' => 'No hay registros',
                'monto' => 'No hay registros',
                'retencion' => 'No hay registros',
                'retencionV' => 'No hay registros',
                'retencionA' => 'No hay registros',
                'totalN' => 'No hay registros',
                'statusPago' => 'No hay registros',
                'acciones' => 'No hay registros',
                '_monto' => 0,
                '_retencion' => 0,
                '_retencionV' => 0,
                '_retencionA' => 0,
                '_totalN' => 0,
            );
        }
        echo json_encode($array);
    }

    public function verOrden($id = null){
        $info = $this->mordenpago->getById($id);
        if(!is_numeric($info)){
            switch ($info['statusPago']) {
                    case 1:
                        $statusP = 'Pendiente por pagar';
                        break;
                    case 2:
                        $statusP = 'Pagado';
                        break;
                    case 3:
                        $statusP = 'Facturado';
                        break;
                    case 4:
                        $statusP = 'Cancelado';
                        break;
                    default:
                        $statusP = '';
                        break;
                }
            $data['paquete'] = $this->mpaquete->getCampo('titulo', $info['idPaquete']);
            $estimaciones = explode(',', $info['idEstimaciones']);
            $semana = '';
            foreach($estimaciones as $esti){
                $semana = $semana . $this->mestimacionesprograma->getCampo('nEstimacion', $esti) . ', ';
            }
            $data['semana'] = substr($semana, 0 , -2);
            $data['status'] = $statusP;
            $data['monto'] = precio_format($info['monto']);
            $data['rvicios'] = precio_format($info['retencionvicios']);
            $data['retencion'] = precio_format($info['retencion']);
            $data['anticipo'] = precio_format($info['retencionAnticipo']);
            $data['total'] = precio_format($info['monto'] - ($info['retencionvicios'] + $info['retencion'] + $info['retencionAnticipo']));
            $qDetalles = $this->mdetalleop->getAllByIdOrdenPago($info['id']);
            
            if(!is_numeric($qDetalles)){
                foreach ($qDetalles->result() as $detalle) {
                    $lotes = $detalle->lotes;
                    /*$ltA = explode(',', $detalle->lotes);
                    foreach ($ltA as $lots) {
                        $lotes = (!empty($lots))? $lotes + 1 : $lotes;
                    }*/
                    $idActProt = $this->mpresupuestomo->getCampo('idActividadPrototipo', $detalle->idPresupuesto);
                    $idAct = $this->mactividadesprototipo->getCampo('idActividad', $idActProt);
                    $idCat = $this->mactividadesprototipo->getCampo('idCategoria', $idActProt);
                    $clave = $this->mactividadmo->getCampo('clave', $idAct);
                    $acti = $this->mactividadmo->getCampo('descripcion', $idAct);
                    $actividades[$idCat][] = array(
                        'lotes' => $lotes,
                        'clave' => $clave,
                        'descripcion' => $acti,
                        'precioU' => precio_format($detalle->precioUnitario),
                        'pagar' => precio_format($detalle->monto)
                    );
                    if(isset($categoria)){
                            if(!in_array($idCat, $categoria) ){
                            $categoria[$idCat] = array('id' => $idCat,
                                'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                            );
                        }
                    }
                    else{
                        $categoria[$idCat] = array('id' => $idCat,
                            'categoria' => $this->mcategoriamo->getCampo('categoria', $idCat)
                        );
                    }
                }
            }
        }
        $data['id'] = $id;
        $data['categorias'] = $categoria;
        $data['actividades'] = $actividades;
        $this->data['contenido'] = $this->load->view($this->mainView . '/orden_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function actualizarPagado(){
        if(isset($_POST['id'])){
            $data['statusPago'] = 2;
            $data['fechaAplicado'] = date('Y-m-d');
            $this->mordenpago->actualizar($data, $_POST['id']);
        }
    }

    public function actualizarCancelado(){
        if(isset($_POST['id'])){
            $data['statusPago'] = 4;
            $this->mordenpago->actualizar($data, $_POST['id']);
        }
    }

    public function updateTotalEst()
    {
        $response['total'] = 0;
        if(isset($_POST['idEstimacion'])){
            $response['total'] = $this->mestimadosprograma->getSumEstimadosXImporteByIdEstimaciones($_POST['idEstimacion']);
            $response['total'] = "$".number_format($response['total'],2);
        }
        echo json_encode($response);
    }
}