<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');
	class Encuesta extends MX_Controller {

		public $data,$vParameters,$mainView,$fv;

		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			// if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login'); // Validate session
			$this->fv = 'encuesta'; // form validation variable
			$this->mainView = 'encuesta';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/encuesta/encuesta.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('mencuestavivienda', 'maltaventa', 'musuario', 'mproyecto', 'mprospecto','mfraccionamiento'));

			// Lbrerias
			// $this->load->library(array('email','session'));
			// $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

			// Debugging
			// $this->output->enable_profiler(false);
           //Validación de usuarios
			valSession("calidad",$this->fv);
		}

		public function index() {
			$data['q'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/listado_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}

		public function responder( $id = null ) {
			$data['q'] = '';
			$data['id'] = $id;

			$data['statusEncuesta'] = $this->maltaventa->getCampo('statusEncuesta',$id);
			/* obtiene el idProspecto de Alta venta por medio del $id de alta venta de la tabla Maltaventa*/
			$idProspecto=$this->maltaventa->getCampo('idProspecto',$id);
			$data['nombre']=$this->mprospecto->getCampo('nombre',$idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$idProspecto);
			$idProyecto=$this->maltaventa->getCampo('idProyecto',$id);
			$data['lote']=$this->mproyecto->getCampo('lote',$idProyecto);
			$data['manzana']=$this->mproyecto->getCampo('manzana',$idProyecto);
			$idFraccionamiento=$this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
			$data['fraccionamiento']=$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
			

			if ( $data['statusEncuesta'] == 0 ) {
				$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
				// $this->load->view('templates/main_template',$this->data);
				$this->load->view('templates/encuesta_template',$this->data);
			}
			else {
				redirect($this->router->class);
			}
		}

		public function listado(){
	        $q = $this->maltaventa->getJoinEntrega();
	        if (!is_numeric($q)){
	        	// print_r($q->result()); exit();
	            foreach ($q->result() as $row){
	            	
	            	/*Esta variable trae los datos guardados en la encuesta */
	            	$rowEncuesta = $this->mencuestavivienda->getByIdAltaVenta($row->idAltaVenta);
/*	            	print_r($rowEncuesta);
	            	exit();*/
	            	if(!is_numeric($rowEncuesta)){
	            	/*indices para imprimir*/
	            	$razonEleccion= $rowEncuesta['razonEleccion'];
	            	$tratoAsesor= $rowEncuesta['tratoAsesor'];
	            	$nosotros= $rowEncuesta['nosotros'];
	            	$casaMuestra= $rowEncuesta['casaMuestra'];
	            	$viviendaAdquirir= $rowEncuesta['viviendaAdquirir'];
	            	$tiempoTramite= $rowEncuesta['tiempoTramite'];
	            	$gradoAceptacionFracc= $rowEncuesta['gradoAceptacionFracc'];
	            	$mejorasVivienda= $rowEncuesta['mejorasVivienda'];
	            	$mejorasfracc= $rowEncuesta['mejorasfracc'];
	            	$condicionEntregaVivienda= $rowEncuesta['condicionEntregaVivienda'];
	            	$recomendacionCompra= $rowEncuesta['recomendacionCompra'];
	            	$fechaEncuesta= $rowEncuesta['created'];
	            /*	print_r($razonEleccion);
	            	exit();*/
	            	}else{
	            		$razonEleccion = "";
	                    $tratoAsesor = "";
	                    $nosotros = "";
	                    $casaMuestra = "";
	                    $viviendaAdquirir = "";
	                    $tiempoTramite = "";
	                    $gradoAceptacionFracc = "";
	                    $mejorasVivienda = "";
	                    $mejorasfracc = "";
	                    $condicionEntregaVivienda = "";
	                    $recomendacionCompra = "";
	                    $fechaEncuesta = '0000-00-00';
	            	}
		            	
	            	

	                $array['aaData'][] = array(
	                	'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
	                    'nombre' => strtoupper($row->nombre.' '.$row->apellidoP.' '.$row->apellidoM),
	                    'telefono' => $row->telefono,
	                    'fechaEncuesta' =>($fechaEncuesta != '0000-00-00' && $fechaEncuesta!='')?date('d/m/Y',strtotime($fechaEncuesta)):'',
	                    'nss' => $row->nss,
	                    'promotor' => $this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor),
	                    'lote' => $row->lote,
	                    /*datos para la encuesta*/
	                    'razonEleccion' => $razonEleccion,
	                    'tratoAsesor' => strtoupper(respEnc($tratoAsesor)),
	                    'nosotros' => strtoupper(respEnc2($nosotros)),
	                    'casaMuestra' => strtoupper(respEnc3($casaMuestra)),
	                    'viviendaAdquirir' => strtoupper(respEnc3($viviendaAdquirir)),
	                    'tiempoTramite' => strtoupper(respEnc3($tiempoTramite)),
	                    'gradoAceptacionFracc' => strtoupper(respEnc($gradoAceptacionFracc)),
	                    'mejorasVivienda' => strtoupper($mejorasVivienda),
	                    'mejorasfracc' => strtoupper($mejorasfracc),
	                    'condicionEntregaVivienda' => strtoupper(respEnc($condicionEntregaVivienda)),
	                    'recomendacionCompra' => strtoupper(respEnc3($recomendacionCompra)),
	                    /* termina datos para la encuesta*/
	                    'manzana' => $row->manzana,
	                    'cuv' => $row->cuv,
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'statusGestoria' => $row->statusGestoria,
	                    // 'statusEncuesta' => $row->statusEncuesta,
	                    'statusEncuesta' => $row->statusEncuesta!=0?'<label style="width: 100%;text-align: center;"><i class="fa fa-check" style="font-size: 20px;"></i></label>':'',
	                    'statusVivienda' => estatus_proyecto_reporte($row->statusVenta),
	                    'acciones' => ( $row->statusEncuesta == 0 ? accionesEncesta($row->id,$this->router->class, false, true, false) : accionesEncesta($row->id,$this->router->class, true, false, false) )
	                    );
	            }
	        } else{
	            $array['aaData'][] = array(
	            	'fraccionamiento' => 'No hay registros',
	                    'nombre' => 'No hay registros',
	                    'telefono' => 'No hay registros',
	                    'fechaEncuesta' =>'No hay registros',
	                    'nss' => 'No hay registros',
	                    'promotor' => 'No hay registros',
	                    'lote' => 'No hay registros',
	                    /*datos para la encuesta*/
	                    'razonEleccion' => 'No hay registros',
	                    'tratoAsesor' => 'No hay registros',
	                    'nosotros' => 'No hay registros',
	                    'casaMuestra' => 'No hay registros',
	                    'viviendaAdquirir' => 'No hay registros',
	                    'tiempoTramite' => 'No hay registros',
	                    'gradoAceptacionFracc' => 'No hay registros',
	                    'mejorasVivienda' => 'No hay registros',
	                    'mejorasfracc' => 'No hay registros',
	                    'condicionEntregaVivienda' =>'No hay registros',
	                    'recomendacionCompra' => 'No hay registros',
	                    /* termina datos para la encuesta*/
	                    'manzana' => 'No hay registros',
	                    'cuv' => 'No hay registros',
	                    'precioVenta' => 'No hay registros',
	                    'avaluo' => 'No hay registros',
	                    'statusGestoria' => 'No hay registros',
	                    // 'statusEncuesta' => $row->statusEncuesta,
	                    'statusEncuesta' => 'No hay registros',
	                    'statusVivienda' => 'No hay registros',
	                    'acciones' =>'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }

		public function guardar() {
			// $data['q'] = '';
			// $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			// $this->load->view('templates/main_template',$this->data);

			$idAltaVenta = $this->input->post('id-alta-venta', TRUE);

			$pData["idAltaVenta"] = $idAltaVenta;
			$pData["fecha"] = $this->input->post('date-enc', TRUE);
			$pData["tratoAsesor"] = $this->input->post('sel-trato-asesor', TRUE);
			$pData["tratoAsesorWhy"] = $this->input->post('why-sel-trato-asesor', TRUE);
			$pData["nosotros"] = ($this->input->post('group-we', TRUE)!='')?$this->input->post('group-we', TRUE):0;
			$pData["nosotrosOtro"] = $this->input->post('input-other-', TRUE);
			$pData["casaMuestra"] = ($this->input->post('group-home', TRUE)!='')?$this->input->post('group-home', TRUE):0;
			$pData["viviendaAdquirir"] = ($this->input->post('group-viviend', TRUE)!='')?$this->input->post('group-viviend', TRUE):0;
			$pData["tiempoTramite"] = ($this->input->post('group-time-tram', TRUE)!='')?$this->input->post('group-time-tram', TRUE):0;
			$pData["gradoAceptacionFracc"] = ($this->input->post('sel-our-fracc', TRUE)!='')?$this->input->post('sel-our-fracc', TRUE):0;
			$pData["razonEleccion"] = $this->input->post('reason-election', TRUE);
			$pData["mejorasVivienda"] = $this->input->post('upgrade-viviend', TRUE);
			$pData["mejorasfracc"] = $this->input->post('upgrade-fracc', TRUE);
			$pData["condicionEntregaVivienda"] = ($this->input->post('sel-delivery-viviend', TRUE)!='')?$this->input->post('sel-delivery-viviend', TRUE):0;
			$pData["condicionEntregaViviendaWhy"] = $this->input->post('why-sel-delivery-viviend', TRUE);
			$pData["recomendacionCompra"] = ($this->input->post('group-recomend', TRUE)!='')?$this->input->post('group-recomend', TRUE):0;
			$pData["recomendacionCompraWhy"] = $this->input->post('why-radio-recomend', TRUE);
			$pData["status"] = 1;

			$id = $this->mencuestavivienda->insertar($pData);

			$pDataAV["statusEncuesta"] = 1;
			$idAV = $this->maltaventa->actualizar($pDataAV, $idAltaVenta);

			//$autores = $this->autoRespuesta( $id );

			redirect($this->router->class);
	    	// print_r( $pData );
		}

		public function ver( $id = null ) {
			$data['q'] = '';
			// $data['id'] = $id;

			// $data["altaventa"] = $this->maltaventa->getById($id);
			$data["dEncuesta"] = $this->mencuestavivienda->getByIdAltaVenta($id);
			// print_r($data["dEncuesta"]); exit();
			$idProspecto=$this->maltaventa->getCampo('idProspecto',$id);
			$data['nombre']=$this->mprospecto->getCampo('nombre',$idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$idProspecto);
			$idProyecto=$this->maltaventa->getCampo('idProyecto',$id);
			$data['lote']=$this->mproyecto->getCampo('lote',$idProyecto);
			$idFraccionamiento=$this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
			$data['fraccionamiento']=$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);

			$this->data['contenido'] = $this->load->view($this->mainView.'/ver_view',$data,true);
			// $this->load->view('templates/main_template',$this->data);
			$this->load->view('templates/encuesta_template',$this->data);
		}


		public function autoRespuesta( $idEncuesta = null ) {
	        // $copias = "ruben@navegantes.mx";
	        $copiasNV = 'ruben@navegantes.mx'. ', ';
	        $copiasNV .= 'sistemas@viviend.mx';
	        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
	        $copiasNV .= 'esalinas@viviend.mx';*/

	        // $para = $emailCliente; // Comprador

	        $subject = 'Notificación de encuesta';

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";

	        $cuerpo = '';

	        // $data = array();


	        $encuesta = $this->mencuestavivienda->getById($idEncuesta);
	        $idProyecto = $this->maltaventa->getCampo('idProyecto', $encuesta['idAltaVenta']);
	        $idProspecto = $this->maltaventa->getCampo('idProspecto', $encuesta['idAltaVenta']);
	        // Get info tables
	        $proyecto = $this->mproyecto->getById($idProyecto);
	        $prospecto = $this->mprospecto->getById($idProspecto);
	        $promotor = $this->musuario->getCampo('nombre',$prospecto['idPromotor'])." ";
	        $promotor .= $this->musuario->getCampo('apellidoP',$prospecto['idPromotor'])." ";
	        $promotor .= $this->musuario->getCampo('apellidoM',$prospecto['idPromotor']);

	        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
	        $idFraccionamiento = $proyecto['idFraccionamiento'];
	        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
	        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';

	        /*--------------------------------------------------------------CLIENTE------------------------------------------------------------------------*/
	        $cuerpo .= '
	        			<table id="table-encuesta" style="width: 80%;margin: 30px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        				<thead>
	        					<tr>
	        						<th colspan="2">CLIENTE</th>
	        					</tr>
	        				</thead>
	        				<tbody>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NSS: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nss'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Promotor: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$promotor.' </td>
	                            </tr>
	        				</tbody>
	        			</table>';
	        /*--------------------------------------------------------------PROYECTO------------------------------------------------------------------------*/
	        $cuerpo .= '
	        			<table id="table-encuesta" style="width: 80%;margin: 30px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        				<thead>
	        					<tr>
	        						<th colspan="2">PROYECTO</th>
	        					</tr>
	        				</thead>
	        				<tbody>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Lote: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['lote'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Manzana: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['manzana'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Calle: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['calle'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> No. Oficial: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$proyecto['nOficial'].' </td>
	                            </tr>
	        				</tbody>
	        			</table>';
	        /*--------------------------------------------------------------ENCUESTA------------------------------------------------------------------------*/
	        $whyTrato = '';
	        if ( $encuesta['tratoAsesor'] < 4 ) {
	        	$whyTrato = '<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Porque? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['tratoAsesorWhy'].' </td>
	                            </tr>';
	        }
	        $other = '';
	        if ( $encuesta['nosotros'] == 8 ) {
	        	$other = '<tr>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">  </td>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['nosotrosOtro'].' </td>
                        </tr>';
	        }
	        $condicionEntrega = '';
	        if ( $encuesta['condicionEntregaVivienda'] < 4 ) {
	        	$condicionEntrega = '<tr>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Porque? </td>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['condicionEntregaViviendaWhy'].' </td>
                        </tr>';
	        }
	        //
	        $recomendacion = '';
	        if ( $encuesta['recomendacionCompra'] == 2 ) {
	        	$recomendacion = '<tr>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Porque? </td>
                            <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['recomendacionCompraWhy'].' </td>
                        </tr>';
	        }
	        $cuerpo .= '
	        			<table id="table-encuesta" style="width: 80%;margin: 30px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        				<thead>
	        					<tr>
	        						<th colspan="2">ENCUESTA</th>
	        					</tr>
	        				</thead>
	        				<tbody>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Cómo califica el trato del asesor de venta? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.type_qualification_selected($encuesta['tratoAsesor']).' </td>
	                            </tr>
	                            '.$whyTrato.'
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Proyecto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.radio_info_we($encuesta['nosotros']).' </td>
	                            </tr>
	                            '.$other.'
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Se mostró la casa muestra? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.($encuesta['casaMuestra'] == 1 ? 'Si' : 'No').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Se mostró la vivienda a adquirir? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.($encuesta['viviendaAdquirir'] == 1 ? 'Si' : 'No').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Le explicaron sobre el tiempo de trámite de su crédito? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.($encuesta['tiempoTramite'] == 1 ? 'Si' : 'No').' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Que grado de aceptación encuentra nuestro fraccionamiento? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.type_qualification_selected($encuesta['gradoAceptacionFracc']).' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Cuál fue la razón por la que fuimos su elección? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['razonEleccion'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Que mejoras haría a la vivienda? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['mejorasVivienda'].' </td>
	                            </tr>
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Que mejoras haría al fraccionamiento? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$encuesta['mejorasfracc'].' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Cúal fue la condición de entrega de su vivienda? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.type_qualification_selected($encuesta['condicionEntregaVivienda']).' </td>
	                            </tr>
	                            '.$condicionEntrega.'
	                            <tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> ¿Nos recomendaría o compraría nuevamente? </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.($encuesta['recomendacionCompra'] == 1 ? 'Si' : 'No').' </td>
	                            </tr>
	                            '.$recomendacion.'
	        					<!--<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de inicio: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($encuesta['fecha']), 'd-m-Y').' </td>
	                            </tr>-->
	        				</tbody>
	        			</table>';


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$urlLogoFracc.'" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Encuesta de vivienda </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        $para = "sistemas@viviend.mx";

	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        if ($para != null){
	            mail($para, $subject, $mensaje, $cabeceras);
	        }

	        $subject2 = $subject;

	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

	        return true;
	    }
}


?>