<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Electronica extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$allowed;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'electronica'; // form validation variable
            $this->mainView = 'electronica';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/electronica/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mactivos','musuario','mcategoria','mcartaasignacion'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';
           $this->allowed=permisos("administracion",$this->fv);
           //Validación de usuarios
	        valSession("administracion",$this->fv);
    }

	public function index(){
        $data['allowed'] = $this->allowed;
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

     public function listado(){
        $q = $this->mactivos->getAll(3);

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $array['aaData'][] = array(
                    'marca' => $row->marca,
                    'serie' => $row->serie,
                    'accesorios' => $row->descripcion,
                    'modelo' => $row->modelo,
                    'inventarioInterno' => $row->inventarioInterno,
                    'categoria' => $this->mcategoria->getCampo("titulo",$row->idCategoria),
                    'txtstatus' => $row->txtstatus,
                    'acciones' => acciones($row->id,$this->router->class),

                    );
            }
        }else{
            $array['aaData'][] = array(
                'marca' => 'No hay registros',
                'serie' => 'No hay registros',
                'accesorios' => 'No hay registros',
                'modelo' => 'No hay registros',
                'inventarioInterno' => 'No hay registros',
                'categoria' => 'No hay registros',
                'txtstatus' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';
        $data['categorias'] = $this->mcategoria->getAll();

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['idActivo'] = 3;
            $pData['marca'] = $this->input->post('marca', TRUE);
            $pData['serie'] = $this->input->post('serie', TRUE);
            $pData['descripcion'] = $this->input->post('accesorios', TRUE);
            $pData['modelo'] = $this->input->post('modelo', TRUE);
            $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);
            $pData['idCategoria'] = $this->input->post('idCategoria', TRUE);
            $pData['status'] = 1;
            $id = $this->mactivos->insertar($pData);
            redirect($this->router->class);
        }

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['marca'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['marca'] = $this->input->post('marca', TRUE);
                $pData['serie'] = $this->input->post('serie', TRUE);
                $pData['descripcion'] = $this->input->post('accesorios', TRUE);
                $pData['modelo'] = $this->input->post('modelo', TRUE);
                $pData['inventarioInterno'] = $this->input->post('inventarioInterno', TRUE);
                $pData['idCategoria'] = $this->input->post('idCategoria', TRUE);
                $pData['status'] =$this->input->post('status',TRUE);
                if ($pData['status'] == 0){
                    $validaAsignacion = $this->mcartaasignacion->getByIdActivo($id);
                    if(!is_numeric($validaAsignacion)){
                        $this->mcartaasignacion->actualizar(
                            array(
                                'fechaDesasignacion' => date_format(new DateTime(),"Y-m-d"),
                                'statusCarta' => 0
                            )
                        ,$validaAsignacion['id']);
                    }
                }
                $this->mactivos->actualizar($pData, $id);
                redirect($this->router->class."?close");
            }
        }
        // Obteniendo la información
        $info = $this->mactivos->getById($id);

        $data = $info;
        $data['categorias'] = $this->mcategoria->getAll();
        $data['msg']=$msg;
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mactivos->getById($id);
        $cValor = "true";
        $this->mactivos->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }


}


