<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Depositos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
            $this->nsession = $this->config->item('nsession');
            if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'depositos'; // form validation variable
            $this->mainView = 'depositos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/depositos/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('maltaventa','mprospecto','mproyecto','musuario','mcomisionbono','mdeposito','mprototipos','mprototipoxfraccionamiento','mfraccionamiento','mfraccionamientoxusuario','mautorizacion'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/comisiones_bonos/';


            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
            valSession("ventas",$this->fv);
    }

	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->maltaventa->getJoinAutorizaciones();//por ahora usamos la misma query que la de autorizaciones
        if (!is_numeric($q)){
            // echo "<pre>"; print_r($q->result()); echo "</pre>"; exit();
            foreach ($q->result() as $row){
                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
            
                $dAutorizaciones = $this->mautorizacion->getByIdAV($row->id);
                if(!is_numeric($dAutorizaciones)){
                    $primerPagoP = ($dAutorizaciones['primerPagoPromotor']>0)?$dAutorizaciones['primerPagoPromotor']:0.00;
                    $segundoPagoP = ($dAutorizaciones['segundoPagoPromotor']>0)?$dAutorizaciones['segundoPagoPromotor']:0.00;
                    $totComisiones = $primerPagoP + $segundoPagoP;
                    $totBonificacion = ($dAutorizaciones['bonificacion']>0)?:0.00;
                }else{
                    $totComisiones = 0.00;
                    $totBonificacion = 0.00;
                }
                $dDepositos = $this->mdeposito->getByIdAV($row->id);
                $totDepositos = (!is_numeric($dDepositos))?$dDepositos['pagoUno']+$dDepositos['pagoDos']+$dDepositos['pagoTres']+$dDepositos['pagoCuatro']+$dDepositos['pagoCinco']+$dDepositos['pagoSeis']+$dDepositos['pagoSiete']+$dDepositos['pagoOcho']:0;
                $array['aaData'][] = array(
                    'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
                    'lote' => $this->mproyecto->getCampo('lote',$row->idProyecto),
                    'manzana' => $row->manzana,
                    'totalPagoComisiones' => precio_format($totComisiones),
                    'totalPagoBonificacion' => precio_format($totBonificacion),
                    'lineaCredito' => $row->lineaCredito,
                    'cliente' => strtoupper($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$row->idProspecto)),
                    'nss' => $row->nss,
                    'promotor' => strtoupper($this->musuario->getCampo("nombre",$row->idPromotor)." ".$this->musuario->getCampo("apellidoP",$row->idPromotor)." ".$this->musuario->getCampo("apellidoM",$row->idPromotor)),
                    'avaluo' => precio_format($row->avaluo),
                    'ahorroVol' => precio_format($row->ahorroVol),
                    'precioVentaOci' => precio_format($row->precioVentaOci),
                    'precioVenta' => precio_format($row->precioVenta),
                    'sumaFinal' => precio_format($row->sumaFinal),
                    'difPropioPeculio' => precio_format($row->difPropioPeculio),
                    'numeroCredito' => $row->numeroCredito,
                    'resultado' => precio_format($row->resultado),
                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
                    'saldo' => precio_format($row->saldo),
                    'cierre' => precio_format($row->cierre),
                    'tipoPromotor' => strtoupper($this->musuario->getCampo('tipoPromotor',$row->idPromotor)),
                    'comision' => $this->musuario->getCampo("comision",$row->idPromotor)."%",
                    'importeComision' => precio_format($row->importeComision),
                    'diferenciaVendedor' => precio_format($row->diferenciaVendedor),
                    'netoVenta' => precio_format($row->netoVenta),
                    'comentarios' => $row->comentarios,
                    'primerPagoPromotor' => (!is_numeric($dAutorizaciones)?precio_format($dAutorizaciones['primerPagoPromotor']):''),
                    'fechaPrimerPagoPromotor' => (!is_numeric($dAutorizaciones) && $dAutorizaciones['fechaPrimerPagoPromotor']!=''?date_format(new DateTime($dAutorizaciones['fechaPrimerPagoPromotor']),'d/m/Y'):''),
                    'segundoPagoPromotor' => (!is_numeric($dAutorizaciones)?precio_format($dAutorizaciones['segundoPagoPromotor']):''),
                    'fechaSegundoPagoPromotor' => (!is_numeric($dAutorizaciones) && $dAutorizaciones['fechaSegundoPagoPromotor']!=''?date_format(new DateTime($dAutorizaciones['fechaSegundoPagoPromotor']),'d/m/Y'):''),
                    'primerPagoCoordinador' => (!is_numeric($dAutorizaciones)?precio_format($dAutorizaciones['primerPagoCoordinador']):''),
                    'fechaPrimerPagoCoordinador' => (!is_numeric($dAutorizaciones) && $dAutorizaciones['fechaPrimerPagoCoordinador']!=''?date_format(new DateTime($dAutorizaciones['fechaPrimerPagoCoordinador']),'d/m/Y'):''),
                    'segundoPagoCoordinador' => (!is_numeric($dAutorizaciones)?precio_format($dAutorizaciones['segundoPagoCoordinador']):''),
                    'fechaSegundoPagoCoordinador' => (!is_numeric($dAutorizaciones) && $dAutorizaciones['fechaSegundoPagoCoordinador']!=''?date_format(new DateTime($dAutorizaciones['fechaSegundoPagoCoordinador']),'d/m/Y'):''),
                    'bonificacion' => (!is_numeric($dAutorizaciones)?precio_format($dAutorizaciones['bonificacion']):''),
                    'fechaBonificacion' => (!is_numeric($dAutorizaciones) && $dAutorizaciones['fechaBonificacion']!=''?date_format(new DateTime($dAutorizaciones['fechaBonificacion']),'d/m/Y'):''),
                    'pagoUno' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoUno']):''),
                    'fechaPagoUno' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoUno']!=''?date_format(new DateTime($dDepositos['fechaPagoUno']),'d/m/Y'):''),
                    'pagoDos' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoDos']):''),
                    'fechaPagoDos' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoDos']!=''?date_format(new DateTime($dDepositos['fechaPagoDos']),'d/m/Y'):''),
                    'pagoTres' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoTres']):''),
                    'fechaPagoTres' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoTres']!=''?date_format(new DateTime($dDepositos['fechaPagoTres']),'d/m/Y'):''),
                    'pagoCuatro' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoCuatro']):''),
                    'fechaPagoCuatro' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoCuatro']!=''?date_format(new DateTime($dDepositos['fechaPagoCuatro']),'d/m/Y'):''),
                    'pagoCinco' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoCinco']):''),
                    'fechaPagoCinco' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoCinco']!=''?date_format(new DateTime($dDepositos['fechaPagoCinco']),'d/m/Y'):''),
                    'pagoSeis' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoSeis']):''),
                    'fechaPagoSeis' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoSeis']!=''?date_format(new DateTime($dDepositos['fechaPagoSeis']),'d/m/Y'):''),
                    'pagoSiete' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoSiete']):''),
                    'fechaPagoSiete' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoSiete']!=''?date_format(new DateTime($dDepositos['fechaPagoSiete']),'d/m/Y'):''),
                    'pagoOcho' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoOcho']):''),
                    'fechaPagoOcho' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoOcho']!=''?date_format(new DateTime($dDepositos['fechaPagoOcho']),'d/m/Y'):''),
                    'pagoNueve' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoNueve']):''),
                    'fechaPagoNueve' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoNueve']!=''?date_format(new DateTime($dDepositos['fechaPagoNueve']),'d/m/Y'):''),
                    'pagoDiez' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoDiez']):''),
                    'fechaPagoDiez' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoDiez']!=''?date_format(new DateTime($dDepositos['fechaPagoDiez']),'d/m/Y'):''),
                    'pagoOnce' => (!is_numeric($dDepositos)?precio_format($dDepositos['pagoOnce']):''),
                    'fechaPagoOnce' => (!is_numeric($dDepositos) && $dDepositos['fechaPagoOnce']!=''?date_format(new DateTime($dDepositos['fechaPagoOnce']),'d/m/Y'):''),

                    'totDepositos' => precio_format($totDepositos),
                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
                    'estatus' => (!is_numeric($this->mdeposito->getByIdAV($row->id))?strtoupper($this->mdeposito->getByIdAV($row->id)['statusAutorizacion']):'' ) ,
                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("ventas","depositos_edit")['r'])) ? acciones($row->id,$this->router->class, true, true, false) : accionesNoEdit($row->id,$this->router->class)
                    );
            }
        } else{
            $array['aaData'][] = array(
                'fraccionamiento' => 'No hay registros',
                'lote' => 'No hay registros',
                'manzana' => 'No hay registros',
                'totalPagoComisiones' => 'No hay registros',
                'totalPagoBonificacion' => 'No hay registros',
                'lineaCredito' => 'No hay registros',
                'cliente' => 'No hay registros',
                'nss' => 'No hay registros',
                'promotor' => 'No hay registros',
                'avaluo' => 'No hay registros',
                'ahorroVol' => 'No hay registros',
                'precioVentaOci' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'sumaFinal' => 'No hay registros',
                'difPropioPeculio' => 'No hay registros',
                'numeroCredito' => 'No hay registros',
                'resultado' => 'No hay registros',
                'bonoEquipamiento' => 'No hay registros',
                'saldo' => 'No hay registros',
                'cierre' => 'No hay registros',
                'tipoPromotor' => 'No hay registros',
                'comision' => 'No hay registros',
                'importeComision' => 'No hay registros',
                'diferenciaVendedor' => 'No hay registros',
                'netoVenta' => 'No hay registros',
                'comentarios' => 'No hay registros',
                'primerPagoPromotor' => 'No hay registros',
                'fechaPrimerPagoPromotor' => 'No hay registros',
                'segundoPagoPromotor' => 'No hay registros',
                'fechaSegundoPagoPromotor' => 'No hay registros',
                'primerPagoCoordinador' => 'No hay registros',
                'fechaPrimerPagoCoordinador' => 'No hay registros',
                'segundoPagoCoordinador' => 'No hay registros',
                'fechaSegundoPagoCoordinador' => 'No hay registros',
                'bonificacion' => 'No hay registros',
                'fechaBonificacion' => 'No hay registros',
                'pagoUno' => 'No hay registros',
                'fechaPagoUno' => 'No hay registros',
                'pagoDos' => 'No hay registros',
                'fechaPagoDos' => 'No hay registros',
                'pagoTres' => 'No hay registros',
                'fechaPagoTres' => 'No hay registros',
                'pagoCuatro' => 'No hay registros',
                'fechaPagoCuatro' => 'No hay registros',
                'pagoCinco' => 'No hay registros',
                'fechaPagoCinco' => 'No hay registros',
                'pagoSeis' => 'No hay registros',
                'fechaPagoSeis' => 'No hay registros',
                'pagoSiete' => 'No hay registros',
                'fechaPagoSiete' => 'No hay registros',
                'pagoOcho' => 'No hay registros',
                'fechaPagoOcho' => 'No hay registros',
                'pagoNueve' => 'No hay registros',
                'fechaPagoNueve' => 'No hay registros',
                'pagoDiez' => 'No hay registros',
                'fechaPagoDiez' => 'No hay registros',
                'pagoOnce' => 'No hay registros',
                'fechaPagoOnce' => 'No hay registros',
                'totDepositos' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'estatus' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }

        echo json_encode($array);
    }

    public function nuevo()// esta funcion no se está usando en este controlador xahora
    {
        // Mensajes
        $data['msg'] = '';
        $resultado = true;
        $data['proyectos'] = $this->mproyecto->getSelectResultForComision();
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
        } else {
            $pData['idAltaVenta'] = $this->input->post('idAltaVenta', TRUE);
            $difPropioPeculio = $this->input->post('difPropioPeculio', TRUE);
            $pData['difPropioPeculio'] = toInt($difPropioPeculio);
            $resultado = $this->input->post('resultado', TRUE);
            $pData['resultado'] = toInt($resultado);
            $saldo = $this->input->post('saldo', TRUE);
            $pData['saldo'] = toInt($saldo);
            $cierre = $this->input->post('cierre', TRUE);
            $pData['cierre'] = toInt($cierre);
            $importeComision = $this->input->post('importeComision', TRUE);
            $pData['importeComision'] = toInt($importeComision); // como viene de un formato de moneda lo convertimos a entero
            $netoVenta = $this->input->post('netoVenta', TRUE);
            $pData['netoVenta'] = toInt($netoVenta);
            try{
                $this->db->trans_start();
                $this->mcomisionbono->insertar($pData);
                $avData['statusValidacion'] = 5; // indica que la venta se encuentra en etapa de gestoría
                $this->maltaventa->actualizar($avData,$pData['idAltaVenta']);
                $this->db->trans_complete();

                if ($this->db->trans_status() === FALSE)
                {
                    $db_error = $this->db->error();
                    $resultado = false;
                    $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                }

            }catch(Exception $e){
                $resultado = false;
                $data['msgInvalid'] = 'error: '.$e->getMessage();
            }

            if ($resultado == true){
                redirect($this->router->class);
            }

        }

        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);

    }

    public function editar($id=null,$idDeposito=null) //$id viene del join getJoinAutorizaciones es equivalente al id de la tabla alta_venta
    {
        // Mensajes
        $data['msg'] = '';
        $resultadoProceso = true;

        // Obteniendo la información
        $info = $this->maltaventa->getByIdForDepositos($id);
        // echo "<pre>"; print_r($info); echo "</pre>"; exit();
        $rowDeposito = (!is_numeric($info))?1:0;
        // validar la información, caso que el registro NO existe en la tabla depositos
        $info = (!is_numeric($info))?$info:$this->maltaventa->getByIdForGestoria($id);
        // echo "<pre>"; print_r($info); echo "</pre>"; exit();
        $data = (!is_numeric($info))?$info:'';
        $data['disabled'] = (!is_numeric($info))?false:true;
        $data['id'] = $id;
        
        $data['rowDeposito'] = $rowDeposito;
        
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['pagoUno'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
                //exit();
            } else {
                $pData['idAltaVenta'] = $id;
                $montoTotal = $this->input->post('montoTotal', TRUE);
                $pData['montoTotal'] = ($montoTotal!='')?toInt($montoTotal):0.00;
                $difPropioPeculio = $this->input->post('difPropioPeculio', TRUE);
                $pData['difPropPeculio'] = ($difPropioPeculio!='')?toInt($difPropioPeculio):0.00;
                $resultado = $this->input->post('resultado', TRUE);
                $pData['resultado'] = ($resultado!='')?toInt($resultado):0.00;
                $propVenta = $this->input->post('propVenta', TRUE);
                $pData['propVenta'] = ($propVenta!='')?toInt($propVenta):0.00;
                $statusAutorizacion = $this->input->post('autorizacion', TRUE);
                $pData['statusAutorizacion'] = $statusAutorizacion;
                $depositoInfonavit = $this->input->post('depositoInfonavit', TRUE);
                $pData['depositoInfonavit'] = ($depositoInfonavit!='')?toInt($depositoInfonavit):0.00;
                $depositoConavi = $this->input->post('depositoConavi', TRUE);
                $pData['depositoConavi'] = ($depositoConavi!='')?toInt($depositoConavi):0.00;
                $fechaDeposito = $this->input->post('fechaDeposito', TRUE);
                $fechaDeposito =  str_replace('/', '-', $fechaDeposito);
                $pData['fechaDeposito'] = ($fechaDeposito!='')?date('Y-m-d', strtotime($fechaDeposito)):NULL;//date_format(new DateTime($fechaDeposito),'Y-m-d');//
                $pData['cuentaDepositada'] = $this->input->post('cuentaDepositada', TRUE);
                
                $pagoUno = $this->input->post('pagoUno', TRUE);
                $pData['pagoUno'] = ($pagoUno!='')?toInt($pagoUno):0.00;
                $fechaPagoUno = $this->input->post('fechaPagoUno', TRUE);
                $fechaPagoUno = str_replace('/', '-', $fechaPagoUno);
                $pData['fechaPagoUno'] = ($fechaPagoUno!='')?date('Y-m-d', strtotime($fechaPagoUno)):NULL;//date_format(new DateTime($fechaPagoUno),'Y-m-d');
                $pagoDos = $this->input->post('pagoDos', TRUE);
                $pData['pagoDos'] = ($pagoDos!='')?toInt($pagoDos):0.00;
                $fechaPagoDos = $this->input->post('fechaPagoDos', TRUE);
                $fechaPagoDos = str_replace('/', '-', $fechaPagoDos);
                $pData['fechaPagoDos'] = ($fechaPagoDos!='')?date('Y-m-d', strtotime($fechaPagoDos)):NULL;//date_format(new DateTime($fechaPagoDos),'Y-m-d');
                $pagoTres = $this->input->post('pagoTres', TRUE);
                $pData['pagoTres'] = ($pagoTres!='')?toInt($pagoTres):0.00;
                $fechaPagoTres = $this->input->post('fechaPagoTres', TRUE);
                $fechaPagoTres = str_replace('/', '-', $fechaPagoTres);
                $pData['fechaPagoTres'] = ($fechaPagoTres!='')?date('Y-m-d', strtotime($fechaPagoTres)):NULL;//date_format(new DateTime($fechaPagoTres),'Y-m-d');
                $pagoCuatro = $this->input->post('pagoCuatro', TRUE);
                $pData['pagoCuatro'] = ($pagoCuatro!='')?toInt($pagoCuatro):0.00;
                $fechaPagoCuatro = $this->input->post('fechaPagoCuatro', TRUE);
                $fechaPagoCuatro = str_replace('/', '-', $fechaPagoCuatro);
                $pData['fechaPagoCuatro'] = ($fechaPagoCuatro!='')?date('Y-m-d', strtotime($fechaPagoCuatro)):NULL;//date_format(new DateTime($fechaPagoCuatro),'Y-m-d');
                $pagoCinco = $this->input->post('pagoCinco', TRUE);
                $pData['pagoCinco'] = ($pagoCinco!='')?toInt($pagoCinco):0.00;
                $fechaPagoCinco = $this->input->post('fechaPagoCinco', TRUE);
                $fechaPagoCinco = str_replace('/', '-', $fechaPagoCinco);
                $pData['fechaPagoCinco'] = ($fechaPagoCinco!='')?date('Y-m-d', strtotime($fechaPagoCinco)):NULL;//date_format(new DateTime($fechaPagoCinco),'Y-m-d');
                $pagoSeis = $this->input->post('pagoSeis', TRUE);
                $pData['pagoSeis'] = ($pagoSeis!='')?toInt($pagoSeis):0.00;
                $fechaPagoSeis = $this->input->post('fechaPagoSeis', TRUE);
                $fechaPagoSeis = str_replace('/', '-', $fechaPagoSeis);
                $pData['fechaPagoSeis'] = ($fechaPagoSeis!='')?date('Y-m-d', strtotime($fechaPagoSeis)):NULL;//date_format(new DateTime($fechaPagoSeis),'Y-m-d');
                $pagoSiete = $this->input->post('pagoSiete', TRUE);
                $pData['pagoSiete'] = ($pagoSiete!='')?toInt($pagoSiete):0.00;
                $fechaPagoSiete = $this->input->post('fechaPagoSiete', TRUE);
                $fechaPagoSiete = str_replace('/', '-', $fechaPagoSiete);
                $pData['fechaPagoSiete'] = ($fechaPagoSiete)?date('Y-m-d', strtotime($fechaPagoSiete)):NULL;//date_format(new DateTime($fechaPagoSiete),'Y-m-d');
                $pagoOcho = $this->input->post('pagoOcho', TRUE);
                $pData['pagoOcho'] = ($pagoOcho!='')?toInt($pagoOcho):0.00;
                $fechaPagoOcho = $this->input->post('fechaPagoOcho', TRUE);
                $fechaPagoOcho = str_replace('/', '-', $fechaPagoOcho);
                $pData['fechaPagoOcho'] = ($fechaPagoOcho)?date('Y-m-d', strtotime($fechaPagoOcho)):NULL;//date_format(new DateTime($fechaPagoOcho),'Y-m-d');
                $pagoNueve = $this->input->post('pagoNueve', TRUE);
                $pData['pagoNueve'] = ($pagoNueve!='')?toInt($pagoNueve):0.00;
                $fechaPagoNueve = $this->input->post('fechaPagoNueve', TRUE);
                $fechaPagoNueve = str_replace('/', '-', $fechaPagoNueve);
                $pData['fechaPagoNueve'] = ($fechaPagoNueve)?date('Y-m-d', strtotime($fechaPagoNueve)):NULL;//date_format(new DateTime($fechaPagoOcho),'Y-m-d');
                $pagoDiez = $this->input->post('pagoDiez', TRUE);
                $pData['pagoDiez'] = ($pagoDiez!='')?toInt($pagoDiez):0.00;
                $fechaPagoDiez = $this->input->post('fechaPagoDiez', TRUE);
                $fechaPagoDiez = str_replace('/', '-', $fechaPagoDiez);
                $pData['fechaPagoDiez'] = ($fechaPagoDiez)?date('Y-m-d', strtotime($fechaPagoDiez)):NULL;//date_format(new DateTime($fechaPagoOcho),'Y-m-d');
                $pagoOnce = $this->input->post('pagoOnce', TRUE);
                $pData['pagoOnce'] = ($pagoOnce!='')?toInt($pagoOnce):0.00;
                $fechaPagoOnce = $this->input->post('fechaPagoOnce', TRUE);
                $fechaPagoOnce = str_replace('/', '-', $fechaPagoOnce);
                $pData['fechaPagoOnce'] = ($fechaPagoOnce)?date('Y-m-d', strtotime($fechaPagoOnce)):NULL;//date_format(new DateTime($fechaPagoOcho),'Y-m-d');
                
                // echo "<pre>"; print_r($pData); echo "</pre>"; exit();
                
                try{

                    $this->db->trans_start();
                    $insertUpdate = ($idDeposito!=null)?$this->mdeposito->actualizar($pData,$idDeposito):$this->mdeposito->insertar($pData);
                    
                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE)
                    {
                        $db_error = $this->db->error();
                        $resultadoProceso = false;
                        $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                    }

                }catch(Exception $e){
                    $resultadoProceso = false;
                    $data['msgInvalid'] = 'error: '.$e->getMessage();
                }
                //print_r($data);exit();
                if ($resultadoProceso == true){
                    // Envio de autoRespuesta
                    $autores = $this->autoRespuesta($id);
                    // Redirección 
                    redirect($this->router->class."?close");
                }


            }
        }
        
        $data['mpromotor'] = $this->musuario;
        
        $info_ = $this->maltaventa->getByIdForAutorizaciones($id);
        $info_ = (!is_numeric($info_))?$info_:$this->maltaventa->getByIdForGestoria($id);
        $data['dAutorizaciones'] = $info_;
        
        $info2_ = $this->maltaventa->getByIdForComisiones($id);
        $data['dComisiones'] = $info2_;
        $idProspecto=$this->maltaventa->getCampo('idProspecto',$id);
        $idFraccionamiento=$this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
        $data['fraccionamiento'] =$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function ver($id = null)
    {
        //Obtenemos el id del Proyecto a aprtir de id alta venta
        $id = $this->maltaventa->getCampo("idProyecto",$id);
        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';

/*        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;

                }

                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }

                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }

                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }

                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }

                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:

                break;
        }*/

        $data['etapa_alta_venta'] = true;
        $data['etapa_validacion_venta'] = true;
        $data['etapa_gestoria'] = true;
        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
        if ( !is_numeric($comisiones) ) {
            $data['etapa_comisionbono'] = true;
            $data['detalle_comisionbono'] = $comisiones;

        }

        $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($autorizaciones) ) {
            $data['etapa_autorizaciones'] = true;
            $data['detalle_autorizaciones'] = $autorizaciones;
        }

        $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($deposito) ) {
            $data['etapa_deposito'] = true;
            $data['detalle_deposito'] = $deposito;
        }

        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->maltaventa->getById($id);
        $cValor = "true";
        $this->maltaventa->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }
    
    
    public function autoRespuesta( $idAltaVenta = null ) {
        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';

        // $para = $emailCliente; // Comprador

        $subject = 'Notificación de depósito | Depósitos';

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$this->maltaventa->getCampo('idProyecto',$idAltaVenta));
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';
        
        $data = array();
        
        $info = $this->maltaventa->getByIdForDepositos($idAltaVenta);
        
        
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CLIENTE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL CLIENTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['nombre'].' '.$info['apellidoP'].' '.$info['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['lote'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['manzana'].' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
        $nomPromotor = $this->musuario->getCampo('nombre',$info['idPromotor'])." ";
        $nomPromotor .= $this->musuario->getCampo('apellidoP',$info['idPromotor'])." ";
        $nomPromotor .= $this->musuario->getCampo('apellidoM',$info['idPromotor']);
        $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">PROMOTOR</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
        // $idGerente = $this->musuario->getCampo('created_by',$info['idPromotor']);
        // $idGerente = $this->musuario->getGerente();
        $nomGerente = $this->musuario->getCampo('nombre',$this->musuario->getGerente())." ";
        $nomGerente .= $this->musuario->getCampo('apellidoP',$this->musuario->getGerente())." ";
        $nomGerente .= $this->musuario->getCampo('apellidoM',$this->musuario->getGerente());
        $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">GERENTE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL GERENTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomGerente.' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
        $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase; margin-top: 50px;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA DETONADO</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO DE CRÉDITO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['numeroCredito'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO TOTAL: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['montoTotalDepositos']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['peculioDepositos']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['resultadoDepositos']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PROPUESTO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['bonoEquipamiento']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PROP DE VENTA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['propVentaDepositos']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO DE VENTA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> AUTORIZACIÓN: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['statusAutorizacionDepositos'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DEPÓSITO INFONAVIT: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['depositoInfonavit']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DEPÓSITO CONAVI: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['depositoConavi']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> FECHA DEPÓSITO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($info['fechaDeposito']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CUENTA DEPOSITADA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['cuentaDepositada'].' </td>
                            </tr>
                        </tbody>
                    </table>';
        
        
        
        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de depósito </h3>
                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';
        
        $subject2 = $subject;
        
        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";
        
        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        
        $dContadores = $this->mfraccionamientoxusuario->getContabilidadSelectResultByIdFracc($idFraccionamiento);
        if ( !is_numeric($dContadores) ) {
            foreach ($dContadores->result() as $row) { 
                mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabecerasAdmin);
            }
        }

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }

}