<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cortes extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$allowed;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'cortes'; // form validation variable
            $this->mainView = 'cortes';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/cortes/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mcortes','musuario'));
            
           //Validación de usuarios
           valSession("obra",$this->fv);
    }

    public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->mcortes->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                switch ($row->statusCorte) {
                    case 1:
                        $editar=true;
                        $borrar=true;
                        $confirmar=false;
                        break;
                    case 2:
                        $editar=true;
                        $borrar=false;
                        $confirmar=true;
                        break;
                    case 3:
                        $editar=false;
                        $borrar=false;
                        $confirmar=false;
                        break;
                }
                $array['aaData'][] = array(
                    'id' => $row->id,
                    'semana' => $row->semana,
                    'fechaCorte' => $row->fechaCorte,
                    'txtstatus' => $this->getStatus($row->statusCorte),
                    'acciones' => accionesCorte($row->id,$this->router->class,$editar,$borrar,$confirmar)
                );
            }
        } else{
            $array['aaData']=[];
        }
        echo json_encode($array);
    }

    public function getStatus($index){
        $status=[
            1 => "Pendiente",
            2 => "Preorden",
            3 => "Finalizado",
        ];
        return $status[$index];
    }

    public function nuevo()
    {
        // Mensajes
        $data['msg'] = '';

        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $data["cortes"] = [];
            $valCorte=$this->mcortes->valCorteActual();
            if(is_numeric(($valCorte))){
                $corteActual=$this->mcortes->getCorteActual();
                $data["cortes"]=[0=>"Semana ".$corteActual->semana." | ".$corteActual->fechaCorte];
            }else{
                $data["cortes"] = [0=>"Sin cortes pendientes"];
            }
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $valCorte=$this->mcortes->valCorteActual();
            if($valCorte==0){
                $corteActual=$this->mcortes->getCorteActual();
                $pData['semana'] = $corteActual->semana;
                $pData['fechaCorte'] = $corteActual->fechaCorte;
                $pData['statusCorte'] = 1;
                $pData['status'] = 1;
                $id = $this->mcortes->insertar($pData);
            }
            redirect($this->router->class);
        }
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mcortes->getById($id);
        $cValor = "true";
        $this->mcortes->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

	public function changeStatus(){
		if(isset($_POST["id"]) && isset($_POST["estatus"])){
            $valCorte=$this->mcortes->valCorteActual($_POST["id"]);
            if(!is_numeric(($valCorte))){
				$corte=$valCorte->row();
                $id=$_POST["id"];
                $estatus=$_POST["estatus"];
                $this->db->query("UPDATE ordenes_pago SET statusPago=1 WHERE semanaAnual=$corte->semana AND $corte->ano=YEAR(fecha)");
                $this->mcortes->actualizar(["statusCorte"=>$estatus],$id);
                echo json_encode("ok");
            }
		}
	}

}


