<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Contado extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
    $this->nsession = $this->config->item('nsession');
	if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'contado'; // form validation variable
            $this->mainView = 'contado';
            $this->data['fjs'] = '';
            $this->data['js'] = '
                                <script src="assets/js/contado/listado.js" type="text/javascript"></script> 
                                <script src="assets/js/contado/detalle.js" type="text/javascript"></script> 
                                <script src="assets/js/contado/acciones.js" type="text/javascript"></script> 
                                ';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('mcontado','musuario','mfraccionamiento','mproyecto','maltaventa','mprospecto','mprototipos','mcontadocuentas','mcontadodetalle','mavaluoproyecto','mfoliosavaluo','mgestoria'));

            // Lbrerias
            $this->load->library('csvimport');
            $this->load->library('excel');
            //
            $this->keyTest = 'ang8sw4ezm3iw8nave2s';
            $this->keyProduction = 'ity8sw4ezm3iw8pwpo6w';
            $this->appProduction = false;
            $this->keyActive = ($this->appProduction) ? $this->keyProduction : $this->keyTest;
            
            valSession("ventas",$this->fv);
    }

	public function index()
	{
		$data['q'] = '';
        //$data['tiendas']=$this->mcontado->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $list = $this->mcontado->get_datatables();
        if(!is_numeric($list)){
            foreach ($list->result() as $row) {
                $idProyecto = $this->maltaventa->getCampo('idProyecto',$row->idAltaVenta);
                $idProspecto = $this->maltaventa->getCampo('idProspecto',$row->idAltaVenta);
                $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
                $idPrototipo = $this->mproyecto->getCampo('idPrototipo',$idProyecto);
                $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
                $supTerreno = $this->mproyecto->getCampo('supTerreno',$idProyecto);

                $prototipo = $this->mprototipos->getCampo('nombre',$idPrototipo);

                $nombre = $this->mprospecto->getCampo('nombre',$idProspecto);
                $apellidoP = $this->mprospecto->getCampo('apellidoP',$idProspecto);
                $apellidoM = $this->mprospecto->getCampo('apellidoM',$idProspecto);
                $idGestoria = $this->mgestoria->getIdByIdAv($row->idAltaVenta);
                $statusGestoria = $this->mgestoria->getCampo('statusGestoria', $idGestoria);
                

                $array[] = array(
                    'id' =>  createLink("contado/detalle/".$row->id.'/'.$row->idAltaVenta,$row->id,"","","_blank"),
                    'acciones' => accionesContado($row->id,$row->idAltaVenta,$this->router->class, ( $row->statusCuenta == 0 || $row->statusCuenta == 3 )? true: false, false, ( $row->statusCuenta < 2 && $statusGestoria != 'detonado' )? true : false,true,true),
                    'idAltaVenta' =>  $row->idAltaVenta,
                    'monto' => precio_format($row->monto),
                    'monto_' => $row->monto,
                    'saldo' => precio_format($row->saldo),
                    'saldo_' => $row->saldo,
                    'statusCuenta' => statusCuenta($row->statusCuenta),
                    'fraccionamiento' =>$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento),
                    'manzana' =>$this->mproyecto->getCampo('manzana',$idProyecto),
                    'lote' =>$this->mproyecto->getCampo('lote',$idProyecto),
                    'nOficial' =>$this->mproyecto->getCampo('nOficial',$idProyecto),
                    'prospecto' =>  $nombre.' '.  $apellidoP.' '. $apellidoM,
                    'nomPromotor' => $this->musuario->getCampo("nombre",$idPromotor),
                    'prototipo' => $prototipo,
                    'supTerreno' => $supTerreno,
                    'plazo' => $row->plazos,
                    'pagos' => precio_format($row->pagos),
                    'pagos_' => $row->pagos,
                    'fecha' => date_format(new DateTime($row->fecha),"d-m-Y"),
                );
            }
        }else{
            $array[] = array(
                'id' => 'No hay registros',
                'idAltaVenta' => 'No hay registros',
                'monto' => 'No hay registros',
                'monto_' => 'No hay registros',
                'saldo' => 'No hay registros',
                'saldo_' => 'No hay registros',
                'statusCuenta' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'nOficial' => 'No hay registros',
                'prospecto' => 'No hay registros',
                'nomPromotor' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'supTerreno' => 'No hay registros',
                'plazo' => 'No hay registros',
                'pagos' => 'No hay registros',
                'pagos_' => 'No hay registros',
                'fecha' => 'No hay registros',
                'acciones' => 'No hay registros'
            );
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mcontado->count_all(),
                        "recordsFiltered" => $this->mcontado->count_filtered(),
                        "data" => $array,
                );
        //output to json format
        echo json_encode($output);
    }

    public function detalle($id='',$idAV=''){
        $data['id'] = $id;
        $data['idAltaVenta'] = $idAV;
         
        $idProyecto = $this->maltaventa->getCampo('idProyecto',$idAV);
        $idProspecto = $this->maltaventa->getCampo('idProspecto',$idAV);
        $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
        $idPrototipo = $this->mproyecto->getCampo('idPrototipo',$idProyecto);

        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
        $data['manzana'] = $this->mproyecto->getCampo('manzana',$idProyecto);
        $data['lote'] = $this->mproyecto->getCampo('lote',$idProyecto);
        $data['nOficial'] = $this->mproyecto->getCampo('nOficial',$idProyecto);
        $data['cliente'] = $this->mprospecto->getCampo('nombre',$idProspecto).' '.$this->mprospecto->getCampo('apellidoP',$idProspecto).' '. $this->mprospecto->getCampo('apellidom',$idProspecto);
        $data['nomPromotor'] = $this->musuario->getCampo("nombre",$idPromotor);
        $data['prototipo'] = $this->mprototipos->getCampo('nombre',$idPrototipo);
        $data['supTerreno'] = $this->mproyecto->getCampo('supTerreno',$idProyecto);
        /*Data de tabla contado_cuentas*/
        $data['monto'] = $this->mcontadocuentas->getCampo('monto',$id);
        $data['pagos'] = $this->mcontadocuentas->getCampo('pagos',$id);
        $data['saldo'] = $this->mcontadocuentas->getCampo('saldo',$id);
        $data['statusCuenta'] = statusCuenta($this->mcontadocuentas->getCampo('statusCuenta',$id));


        $this->data['contenido'] = $this->load->view($this->mainView.'/detalle_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado_detalle($id){
        $list = $this->mcontadodetalle->get_datatables($id);
        /*echo '<pre>';  print_r($list); exit();*/
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $contadoDet) {

            $comprobante = '';
            if($contadoDet->comprobante != ''){
                $ext = substr($contadoDet->comprobante, -4, 4);
                $class = '';
                $target = 'target="_blank"';
                if($ext != '.pdf'){
                    $class = "magnificPopup";
                    $target = "";
                }
                $comprobante = '<a class="'.$class.'" href="'.base_url().'/uploads/contado_detalle/'.$contadoDet->comprobante.'" '.$target.'>';
                $comprobante .='   <img height="60" src="'.base_url().'/uploads/contado_detalle/'.$contadoDet->comprobante.'" style="display:none"><i class="fa fa-eye" aria-hidden="true"></i>';
                $comprobante .='</a>';
            }

            $no++;
            $row = array();
            $acciones = '';
            if($contadoDet->tipo != 2){
                //$acciones = '<a href="formatospdf/reciboPago/'.$contadoDet->id.'"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>'.'&ensp;&ensp;&ensp;'. '<a target="_blank" href="uploads/contado_detalle/'.$contadoDet->comprobante.'"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                $acciones = '<a href="formatospdf/reciboPago/'.$contadoDet->id.'"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>'.'&ensp;&ensp;&ensp;'. $comprobante;
            }
            //$row[] = $no;
            $row[] = $acciones;
            /*$row[] = ;*/
            $row[] = $contadoDet->cuenta;
            $row[] = $contadoDet->formaPago;
            $row[] = tipostatusDetalle($contadoDet->tipo);
            $row[] = $contadoDet->descripcion;
            $row[] = precio_format($contadoDet->importe);
            $row[] = precio_format($contadoDet->saldo);
            $row[] = statusDetalle($contadoDet->statusDetalle);
            $row[] = $contadoDet->movimiento;
            $row[] = date_format(new DateTime($contadoDet->fecha),"d-m-Y");

            $data[] = $row;
        }

        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->mcontadodetalle->count_all(),
                        "recordsFiltered" => $this->mcontadodetalle->count_filtered(),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    public function getDatosModal(){
        $id = $_POST['idContado'];
        $datitos['msg'] = '';
        $datitos['status'] = 0;
        if ( is_numeric($id) && $id > 0 && is_numeric($_POST['tipo']) && $_POST['tipo'] > 0 ){
            
            $qContadoC = $this->mcontadocuentas->getById($id);
            $qContadoDetalleAnticipo = $this->mcontadodetalle->getByIdContadoAnticipo($id);
            $anticipo = (!is_numeric($qContadoDetalleAnticipo)) ? $qContadoDetalleAnticipo['importe'] : 0;

            if( !is_numeric($qContadoC) ){
                $arrayStatus = array( "POR LIQUIDAR", "LIQUIDADA", "CANCELADA", "CANCELADA/POR LIQUIDAR");
                $idProspecto = $this->maltaventa->getCampo('idProspecto', $qContadoC['idAltaVenta']);
                $cliente = $this->mprospecto->getCampo('nombre', $idProspecto) . ' ' . $this->mprospecto->getCampo('apellidoP', $idProspecto) . ' ' . $this->mprospecto->getCampo('apellidoM', $idProspecto);
                $datitos['fechaContrato'] = date("d/m/Y", strtotime($qContadoC['fecha']));
                $datitos['cliente'] =  $cliente;
                $datitos['statusContrato'] = $arrayStatus[$qContadoC['statusCuenta']];
                $datitos['statusCuenta'] = $qContadoC['statusCuenta'];
                $datitos['monto'] =  $qContadoC['monto'];
                $datitos['saldo'] = $qContadoC['saldo'];
                $datitos['cuenta'] = '0330679992';
                $datitos['pagado'] = $qContadoC['pagos'];
                switch($_POST['tipo']){
                    case 1:
                        if( $qContadoC['statusCuenta'] < 2 ){
                            $tempDatitos['fecha'] = $qContadoC['fecha'];
                            $tempDatitos['plazos'] = $qContadoC['plazos'];
                            $tempDatitos['monto'] = $qContadoC['monto'] - $anticipo;
                            $tempDatitos['interes'] = $qContadoC['interes'];
                            $amortizacion = calcularAmortizacion($tempDatitos);
                            $tempIni = date( 'Y-m-d');
                            foreach($amortizacion as $amort){
                                if( $amort['id'] == 'Préstamo'){
                                    $tempIni = str_replace('/', '-', $amort['fecha']);
                                    $tempIni = date( 'Y-m-d', strtotime($tempIni) );
                                    $saldo = $amort['saldo'];
                                    $pago = $amort['pago'];
                                }else{
                                    $tempFin = str_replace('/', '-', $amort['fecha']);
                                    $tempFin = date( 'Y-m-d', strtotime($tempFin) );
                                    if(  $tempFin <= date('Y-m-d') ){
                                        $fecha_ini = $tempIni;
                                        $fecha_fin = $tempFin;
                                        $saldo = $amort['saldo'];
                                        $pago = $amort['pago'];
                                    }
                                    $tempIni = $tempFin;
                                }
                                $pago = $amort['pago'];
                            }
                            if( $saldo == $qContadoC['monto'] ){
                                $datitos['saldoDetalle'] = 0;
                            } else if( $saldo == 0 ){
                                $datitos['saldoDetalle'] = $qContadoC['monto'];
                            } else{
                                $datitos['saldoDetalle'] = $qContadoC['monto'] - ( $saldo + $pago );
                            }
                            $datitos['importe'] = ( ($qContadoC['monto'] - $datitos['pagado']) < $pago )? ($qContadoC['monto'] - $datitos['pagado']) : $pago;
                        }
                        else{
                            $datitos['importe'] = $qContadoC['saldo'] * -1;
                            $datitos['saldoDetalle'] = 0;
                        }
                        break;
                    case 2: 
                        $datitos['saldoDetalle'] = $datitos['pagado'];
                        $datitos['importe'] = 0.00;
                        break;
                    case 3:
                        $datitos['fechaPago'] = date('d/m/Y');
                        $datitos['saldoDetalle'] = $datitos['pagado'];
                        $penalizacion = round( ($qContadoC['monto'] * .20), 2);
                        $datitos['devolucion'] = ( $datitos['pagado'] < $penalizacion )? 0.00 : ($datitos['pagado'] - $penalizacion);
                        $datitos['saldoTexto'] = ( $datitos['pagado'] < $penalizacion )? precio_format($datitos['pagado'] - $penalizacion) : precio_format($datitos['pagado'] - ($penalizacion + $datitos['devolucion'] ) );
                        $porcentajePagado = round( ( ($datitos['pagado'] * 100) / $qContadoC['monto'] ), 2);
                        $datitos['porcentaje'] = ($porcentajePagado <= 20)? $porcentajePagado : 20;
                        $datitos['porPendiente'] = ($porcentajePagado <= 20)? (20 - $porcentajePagado) : 0;
                        $datitos['penalizacionT'] = $penalizacion;
                        $datitos['penalizacion'] = ( $datitos['pagado'] < $penalizacion )? $datitos['pagado'] : $penalizacion;
                        break;
                    default:
                        break;
                }
                $datitos['statusDetalle'] = ( $datitos['saldoDetalle'] <= $datitos['pagado'] )? 1 : 2;
                $datitos['status'] = 1;
            }else{
                $datitos['msg'] = "No se encontró la información";
            }
        }
        else{
            $datitos['msg'] = "No esta proporcionando todos los datos.";
        }
        echo json_encode($datitos);
    }

    public function guardarDeposito(){
        $this->data['fotos_www'] = $this->config->item('base_www').'/contado_detalle/';
        $datitos['msg'] = 'Debe llenar todos los campos.';
        $datitos['status'] = 0;
        $seguir = false;
        if (isset($_FILES) && count($_FILES) > 0) {
            $seguir = true;
        }
        $formaPago = array('spei' => 'SPEI', 'efectivo' => 'EFECTIVO', 'cheque' => 'CHEQUE' );
        if ( is_numeric($_POST['id']) && array_key_exists($_POST['formaPago'], $formaPago) && $_POST['fechaPago'] != '' && $_POST['importe'] != '$' && $_POST['importe'] != '' && $_POST['saldoDetalle'] != '$' && $_POST['saldoDetalle'] != '' && $_POST['minimo'] != ''  && $_POST['movimiento'] != '' && isset($_POST['descripcion']) && isset($_POST['cuenta']) && $seguir ){
            $cdData['idCuenta'] = $_POST['id'];
            $statusCuenta = $this->mcontadocuentas->getCampo('statusCuenta', $cdData['idCuenta']);
            $idAltaVenta = $this->mcontadocuentas->getCampo('idAltaVenta', $cdData['idCuenta']);
            $idAltaVenta = ($idAltaVenta != false) ? $idAltaVenta : 0;
            $monto = $this->mcontadocuentas->getCampo('monto', $cdData['idCuenta']);
            $cdData['saldo'] = toInt($_POST['saldoDetalle']);
            $cdData['importe'] = toInt($_POST['importe']);
            $ccData['saldo'] = $monto - $cdData['saldo'];
            if( $statusCuenta < 2){
                $permitir = ( $cdData['saldo'] <= $monto )? true : false;
                $ccData['pagos'] = $cdData['saldo'];
                $ccData['statusCuenta'] = ( $ccData['saldo'] == 0 )? 1 : 0;
                $cdData['statusDetalle'] = ($_POST['minimo'] <= $cdData['saldo'] )? 1 : 2;
                //
                /*require('Cronjob.php');
                $cronjob = new Cronjob();
                $infoSendWhatsapp = $this->maltaventa->getInfoForSendWhatsApp($idAltaVenta);
                if(!is_numeric($infoSendWhatsapp)){

                    $telefono = $infoSendWhatsapp->row()->celular;
                    $telefono = '9993791189';
                    $name = $infoSendWhatsapp->row()->cliente;

                    $dataSendWhatsapp['to'] = '521'.$telefono;
                    $dataSendWhatsapp['message2'] = 'HOLA '.$name.' TIENES UN DEPOSITO VENCIDO';
                    $dataSendWhatsapp['message'] = 'HOLA '.$name.' TIENES DEPOSITO VENCIDO';
                    $dataSendWhatsapp['key'] = $this->keyActive;


                    if($cdData['statusDetalle'] == 2){
                        $valid = $cronjob->sendWhatsapp($pData2);
                    }
                }*/
            }else{
                $permitir = ( $cdData['saldo'] <= 0 )? true : false;
                $pagos = $this->mcontadocuentas->getCampo('pagos', $cdData['idCuenta']);
                $ccData['saldo'] = $cdData['saldo'];
                $ccData['pagos'] = $pagos + $cdData['importe'];
                $ccData['statusCuenta'] = ( $ccData['saldo'] == 0 )? 2 : 3;
            }
            if( $permitir ){
                //Subida de Imagen
                $config = array();
                $this->load->library('upload', $config);
                $this->load->library('image_lib');
    
                if (isset($_FILES)){
                    $imagenes = array();
                    foreach($_FILES as $key=>$value){
                        if ($_FILES[$key]['size'] > 0){
                            $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                            $imagenes[] = $key;
                        }
                    }
                    $totalImagenes = count($imagenes);
                    for($i=0; $i< $totalImagenes; $i++){
                        $ext = pathinfo($_FILES[$imagenes[$i]]['name'], PATHINFO_EXTENSION);
                        //Configuracion del thumbnail
                        if ($imagenes[$i] != 'foto') {
                            $nCampoC = explode("_", $imagenes[$i]);
                            $tipo = $nCampoC[0];
                            $v = $nCampoC[1];
                        } else {
                            $v = 0;
                            $tipo = 'foto';
                        }
    
                        if ($tipo == 'foto'){
                            $uploaddir = $this->data['fotos_www'];
                            $config['upload_path'] = $uploaddir;
                            $config['image_library'] = 'gd2';
                            $config['create_thumb'] = FALSE;
                            $config['maintain_ratio'] = FALSE;
                            //$configT['width'] = 150;
                            //$configT['height'] = 150;
                            //Configuracion de la libreria upload
                            $nextId = $this->mcontadodetalle->nextId();
                            $config['file_name'] =  $nextId."_".$v;
                            $config['overwrite'] = TRUE;
                            $config['upload_path'] = $uploaddir;
                            $config['max_size'] = '3072';
                            $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
                            $this->upload->initialize($config);
    
                            if ( ! $this->upload->do_upload($imagenes[$i]))
                            {
                                $redirect = 1;
                                $data['msg'] = $this->upload->display_errors();
                            }
                            else
                            {
                                $dataFile = $this->upload->data($imagenes[$i]);
                                $fotoI = 'comprobante';
                                if ($v == 0){
                                    //Foto default
                                    $cdData['comprobante'] = $nextId.'_'.$v.'.'.$ext;
                                    $config['source_image'] = $uploaddir.$cdData['comprobante'];
                                    if($ext != 'pdf'){
                                        $this->image_lib->clear();
                                        $this->image_lib->initialize($config);
                                        $this->image_lib->resize();
                                    }
                                } else {
                                    $cdData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                                    $config['source_image'] = $uploaddir.$cdData[$fotoI];
                                    if($ext != 'pdf'){
                                        $this->image_lib->clear();
                                        $this->image_lib->initialize($config);
                                        $this->image_lib->resize();
                                    }
                                }
                            }
                        }
                    }
                }
                $fechaPago = $_POST['fechaPago'];
                $fechaPago =  str_replace('/', '-', $fechaPago);
                $cdData['fecha'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
                $cdData['formaPago'] = $_POST['formaPago'];
                $cdData['tipo'] = 1;
                $cdData['descripcion'] = $_POST['descripcion'];
                $cdData['movimiento'] = $_POST['movimiento'];
                $cdData['cuenta'] = $_POST['cuenta'];
                $cdData['status'] = 1;
                $id = $this->mcontadodetalle->insertar($cdData);
                $this->mcontadocuentas->actualizar($ccData, $cdData['idCuenta']);
                $idAltaVenta = $this->mcontadocuentas->getCampo('idAltaVenta', $cdData['idCuenta']);
                $idProyecto = $this->maltaventa->getCampo('idProyecto',$idAltaVenta);
                $lineaCredito = $this->mproyecto->getCampo('lineaCredito',$idProyecto);
                $statusObra = $this->mproyecto->getCampo('statusObra',$idProyecto);
                if($lineaCredito == 1 && $statusObra < 2 && $ccData['pagos'] >= 200000 ){
                    $pData['statusObra'] = 2;
                    $this->mproyecto->actualizar($pData, $idProyecto);
                }
                $datitos['status'] = 1;
                $datitos['msg'] = 'Se ha guardado el depósito con éxito.';
            }else{
                $datitos['msg'] = 'Esta depositando más del saldo pendiente.';
            }
        }
        echo json_encode($datitos);
    }

    public function exportar($id='',$idAV='')
    {

                 $idProyecto = $this->maltaventa->getCampo('idProyecto',$idAV);
                 $idProspecto = $this->maltaventa->getCampo('idProspecto',$idAV);
                 $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
                 $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
                 $idPrototipo = $this->mproyecto->getCampo('idPrototipo',$idProyecto);

                 $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
                 $data['manzana'] = $this->mproyecto->getCampo('manzana',$idProyecto);
                 $data['lote'] = $this->mproyecto->getCampo('lote',$idProyecto);
                 $data['nOficial'] = $this->mproyecto->getCampo('nOficial',$idProyecto);
                 $data['cliente'] = $this->mprospecto->getCampo('nombre',$idProspecto).' '.$this->mprospecto->getCampo('apellidoP',$idProspecto).' '. $this->mprospecto->getCampo('apellidom',$idProspecto);
                 $data['nomPromotor'] = $this->musuario->getCampo("nombre",$idPromotor);
                 $data['prototipo'] = $this->mprototipos->getCampo('nombre',$idPrototipo);
                 $data['supTerreno'] = $this->mproyecto->getCampo('supTerreno',$idProyecto);
                 /*Data de tabla contado_cuentas*/
                 $data['monto'] = precio_format($this->mcontadocuentas->getCampo('monto',$id));
                 $data['pagos'] = precio_format($this->mcontadocuentas->getCampo('pagos',$id));
                 $data['saldo'] = precio_format($this->mcontadocuentas->getCampo('saldo',$id));
                 $data['statusCuenta'] = statusCuenta($this->mcontadocuentas->getCampo('statusCuenta',$id));

      /*
      */
                $objPHPExcel = new PhpOffice\PhpSpreadsheet\Spreadsheet();
                $objPHPExcel->getActiveSheet()->setTitle('Contado');
                $objPHPExcel->setActiveSheetIndex(0);

                $objPHPExcel->getActiveSheet()->mergeCells('A1:B7');

                $gdImage = imagecreatefromjpeg(base_url() . '/img/bg1.jpg');
                // Add a drawing to the worksheetecho date('H:i:s') . " Add a drawing to the worksheet\n";
                $objDrawing = new PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing();
                $objDrawing->setName('Logo Vviend');
                $objDrawing->setDescription('Logo Viviend');
                $objDrawing->setImageResource($gdImage);
                $objDrawing->setRenderingFunction(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::RENDERING_JPEG);
                $objDrawing->setMimeType(PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing::MIMETYPE_DEFAULT);
                $objDrawing->setOffsetX(150);
                $objDrawing->setOffsetY(0);
                $objDrawing->setWidth(900);
                $objDrawing->setHeight(140);
                $objDrawing->setCoordinates('A1');
                $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

                $objPHPExcel->getActiveSheet()->SetCellValue('A13', 'CUENTA');
                $objPHPExcel->getActiveSheet()->SetCellValue('B13', 'FORMA PAGO');
                $objPHPExcel->getActiveSheet()->SetCellValue('C13', 'TIPO');
                $objPHPExcel->getActiveSheet()->SetCellValue('D13', 'DESCRIPCION');
                $objPHPExcel->getActiveSheet()->SetCellValue('E13', 'IMPORTE');
                $objPHPExcel->getActiveSheet()->SetCellValue('F13', 'SALDO');
                $objPHPExcel->getActiveSheet()->SetCellValue('G13', 'ESTATUS');
                $objPHPExcel->getActiveSheet()->SetCellValue('H13', 'MOVIMIENTO');
                $objPHPExcel->getActiveSheet()->SetCellValue('I13', 'FECHA');

                $objPHPExcel->getActiveSheet()->getStyle('B9:B12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('D9:D12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->getStyle('G9:G12')->applyFromArray(
                    array('fill' => array(
                        'fillType' => PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'FFE699')
                    ))
                );

                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'FRACCIONAMIENTO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B9', strtoupper($data['fraccionamiento']));

                $objPHPExcel->getActiveSheet()->SetCellValue('A10', '# EXT:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B10', $data['nOficial']);

                $objPHPExcel->getActiveSheet()->SetCellValue('A11', 'PROTOTIPO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B11', $data['prototipo']);

                $objPHPExcel->getActiveSheet()->SetCellValue('A12', 'PAGOS:');
                $objPHPExcel->getActiveSheet()->SetCellValue('B12', $data['pagos']);
                $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setHorizontal(PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
                //

                $objPHPExcel->getActiveSheet()->SetCellValue('C9', 'MANZANA');
                $objPHPExcel->getActiveSheet()->SetCellValue('D9',  $data['manzana']);

                $objPHPExcel->getActiveSheet()->SetCellValue('C10', 'CLIENTE:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D10', strtoupper($data['cliente']));

                $objPHPExcel->getActiveSheet()->SetCellValue('C11', 'SUPERFICIE');
                $objPHPExcel->getActiveSheet()->SetCellValue('D11', $data['supTerreno']);

                $objPHPExcel->getActiveSheet()->SetCellValue('C12', 'SALDO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('D12',  $data['saldo']);

                //

                $objPHPExcel->getActiveSheet()->mergeCells('E9:F9');
                $objPHPExcel->getActiveSheet()->SetCellValue('E9', 'LOTE:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G9', $data['lote']);

                $objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
                $objPHPExcel->getActiveSheet()->SetCellValue('E10', 'PROMOTOR:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G10',  strtoupper($data['nomPromotor']));

                $objPHPExcel->getActiveSheet()->mergeCells('E11:F11');
                $objPHPExcel->getActiveSheet()->SetCellValue('E11', 'MONTO:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G11',  $data['monto']);

                $objPHPExcel->getActiveSheet()->mergeCells('E12:F12');
                $objPHPExcel->getActiveSheet()->SetCellValue('E12', 'STATUS:');
                $objPHPExcel->getActiveSheet()->SetCellValue('G12', strtoupper($data['statusCuenta']));

                $rowCount = 14;
                $rowCategoria = 0;
                $importeCategoria = 0;
                $importePaqueteCategoria = 0;

                $info = $this->mcontadodetalle->getByIdContado($id);

                $pagos = '';

                if(!is_numeric($info)){
                    foreach ($info->result() as $row) {

                        //$pagos = $this->mcontadocuentas->getCampo('pagos',$row->idCuenta);
            
                        $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $row->cuenta);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, strtoupper($row->formaPago));
                        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, strtoupper(tipostatusDetalle($row->tipo)));
                        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, strtoupper($row->descripcion));
                        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, precio_format($row->importe));
                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format($row->saldo));
                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, strtoupper(statusDetalle($row->statusDetalle)));
                        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $row->movimiento);
                        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, date_format(new DateTime($row->fecha),"d-m-Y"));
            

                        $rowCount++;
                    }
                }

               /* $objPHPExcel->getActiveSheet()->SetCellValue('D11', precio_format('$presupuestoUnit'));
                $objPHPExcel->getActiveSheet()->SetCellValue('D12', precio_format('$totalContrato'));*/

               /* $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, precio_format('$presupuestoUnit'));
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, precio_format('$totalContrato'));*/

                $styleArray = array(
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        )
                    )
                );

                $objPHPExcel->getActiveSheet()->getStyle(
                    'A13:I' . $rowCount
                )->applyFromArray($styleArray);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
                $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);

                // $name = $paquete["id"].".".$paquete["titulo"];
                $name = 'Contado'.' '. 'Detalle';
                header('Content-Type: application/vnd.ms-excel');
                header('Content-Disposition: attachment;filename="' . $name . '(' . date('d-m-Y') . ').xls"');
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xls');
                // Forzamos a la descarga
                $objWriter->save('php://output');
            /*}*/
        /*}*/
    }
    
    public function exportarIndex()
    {
        $list = $this->mcontadocuentas->getAll();
        $array = array();
        $columnas = array(
            0 => 'MONTO',
            1 => 'PAGO',
            2 => 'SALDO',
            3 => 'STATUS CUENTA',
            4 => 'FRACCIONAMIENTO',
            5 => 'MANZANA',
            6 => 'LOTE',
            7 => '# EXT',
            8 => 'PROSPECTO',
            9 => 'PROMOTOR',
            10 => 'PROTOTIPO',
            11 => 'SUPERFICIE',
            12 => 'PLAZOS',
            13 => 'FECHA',
        );
        $nombre = 'contado_listado';
        if(!is_numeric($list)){
            $i = 0;
            $totalMonto = 0;
            $totalPagos = 0;
            $totalSaldo = 0;
            foreach ($list->result() as $row) {
                $idProyecto = $this->maltaventa->getCampo('idProyecto',$row->idAltaVenta);
                $idProspecto = $this->maltaventa->getCampo('idProspecto',$row->idAltaVenta);
                $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
                $idPrototipo = $this->mproyecto->getCampo('idPrototipo',$idProyecto);
                $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
                $supTerreno = $this->mproyecto->getCampo('supTerreno',$idProyecto);

                $prototipo = $this->mprototipos->getCampo('nombre',$idPrototipo);

                $nombre = $this->mprospecto->getCampo('nombre',$idProspecto);
                $apellidoP = $this->mprospecto->getCampo('apellidoP',$idProspecto);
                $apellidoM = $this->mprospecto->getCampo('apellidoM',$idProspecto);

                $totalMonto = $totalMonto + $row->monto;
                $totalPagos = $totalPagos + $row->pagos;
                $totalSaldo = $totalSaldo + $row->saldo;

                $array[$i] = array(
                    'monto' => precio_format($row->monto),
                    'pagos' => precio_format($row->pagos),
                    'saldo' => precio_format($row->saldo),
                    'statusCuenta' => statusCuenta($row->statusCuenta),
                    'fraccionamiento' =>$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento),
                    'manzana' =>$this->mproyecto->getCampo('manzana',$idProyecto),
                    'lote' =>$this->mproyecto->getCampo('lote',$idProyecto),
                    'nOficial' =>$this->mproyecto->getCampo('nOficial',$idProyecto),
                    'prospecto' =>  $nombre.' '.  $apellidoP.' '. $apellidoM,
                    'nomPromotor' => $this->musuario->getCampo("nombre",$idPromotor),
                    'prototipo' => $prototipo,
                    'supTerreno' => $supTerreno,
                    'plazo' => $row->plazos,
                    'fecha' => date_format(new DateTime($row->fecha),"d-m-Y"),
                );

                $i++;
            }

            $array[$i] = array(
                'monto' => precio_format($totalMonto),
                'pagos' => precio_format($totalPagos),
                'saldo' => precio_format($totalSaldo),
                'statusCuenta' => '',
                'fraccionamiento' => '',
                'manzana' => '',
                'lote' => '',
                'nOficial' => '',
                'prospecto' => '',
                'nomPromotor' => '',
                'prototipo' => '',
                'supTerreno' => '',
                'plazo' => '',
                'fecha' => '',
            );
        }

        crearExcel($array,$nombre,$columnas,'array');
    }

    public function guardarCancelacion(){
        $datitos['msg'] = 'Debe llenar todos los campos.';
        $datitos['status'] = 0;
        $seguir = false;
        if ( is_numeric($_POST['id']) && $_POST['devolucion'] != '$' && $_POST['devolucion'] != '' && $_POST['penalizacion'] != '$' && $_POST['penalizacion'] != '' && $_POST['saldoDetalle'] != '$' && $_POST['saldoDetalle'] != '' && $_POST['minimo'] != '' && $_POST['movimiento'] != '' && isset($_POST['descripcion']) && isset($_POST['cuenta']) ){
            $cdData['idCuenta'] = $_POST['id'];
            $idAltaVenta = $this->mcontadocuentas->getCampo('idAltaVenta', $cdData['idCuenta']);
            // inf. de la penalizacion
            $monto = $this->mcontadocuentas->getCampo('monto', $cdData['idCuenta']);
            $pagado = $this->mcontadocuentas->getCampo('pagos', $cdData['idCuenta']);
            $penalizacionT = $_POST['minimo'];
            $penalizacion = toInt($_POST['penalizacion']);
            $devolucion = toInt($_POST['devolucion']);
            $porcentajePagado = round( ( ($penalizacion * 100) / $monto ), 2);
            $porcentaje = $porcentajePagado;
            $porPendiente = 20 - $porcentajePagado;
            // Fin inf. de la penalizacion
            $cdData['importe'] = ( $devolucion > 0 )? $devolucion : $penalizacion;
            $cdData['saldo'] = ( $devolucion > 0 )? $pagado - $devolucion : $pagado - $penalizacion ;
            $cdData['fecha'] =  date('Y-m-d');
            $cdData['tipo'] = 2;
            $cdData['descripcion'] = ( $devolucion > 0 )? $_POST['descripcion'] . ' Devolución.' : $_POST['descripcion'];
            $cdData['movimiento'] = $_POST['movimiento'];
            $cdData['cuenta'] = $_POST['cuenta'];
            $cdData['status'] = 1;
                        
            $this->db->trans_start();
            $id = $this->mcontadodetalle->insertar($cdData);
            $cdData['importe'] = $penalizacion;
            // Retiro de la penalizacion
            if( $devolucion > 0){
                $cdData['descripcion'] = $_POST['descripcion'];
                $cdData['saldo'] = 0;
                $id = $this->mcontadodetalle->insertar($cdData);
            }
            // Deposito de la penalizacion
            $cdData['tipo'] = 1;
            $cdData['saldo'] = toInt($_POST['saldoDetalle']);
            $cdData['statusDetalle'] = 3;
            $cdData['descripcion'] .= ' Penalizacion 20% es de ' . precio_format($penalizacion) . '. Penalizacion pagado %' . $porcentajePagado . '. Penalizacion pendiente %' . $porPendiente . '.';
            $id = $this->mcontadodetalle->insertar($cdData);

            //Actualizar la inf. de la cuenta
            $ccData['saldo'] = $cdData['saldo'];
            $ccData['pagos'] = $cdData['importe'];
            $ccData['statusCuenta'] = ( $cdData['saldo'] < 0 )? 3 : 2;
            $this->mcontadocuentas->actualizar($ccData, $cdData['idCuenta']);

            //Cancelar lo que esta en alta_venta
		    $idProyecto = $this->maltaventa->getCampo("idProyecto",$idAltaVenta);
			$idProspecto = $this->maltaventa->getCampo("idProspecto",$idAltaVenta);
	    	$dateCancel = date('Y-m-d');
            $motivoCancelacion = $cdData['descripcion'];

			$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdProyectoProspecto($idProyecto,$idProspecto);

	    	$r['alta_venta'] = $this->db->query("UPDATE alta_venta SET status=0, statusValidacion=0, statusValidacion2='', motivoCancelacionAv = '".$motivoCancelacion."', idMotivo = '13', fechaCancelacionAv = '".$dateCancel."' WHERE id=".$idAltaVenta);
            $r['proyecto'] = $this->db->query("UPDATE proyectos SET statusVenta=0, folioAvaluo='' WHERE id=".$idProyecto);
			$r['prospecto'] = $this->db->query("UPDATE prospectos SET status=0 WHERE id=".$idProspecto);
	    	$r['area_status'] = $this->db->query("DELETE FROM area_status WHERE idAltaVenta=".$idAltaVenta);

			if (!is_numeric($rowAvaluoProyecto)){
	    		$ap['statusAsignacion'] = 0;
	    		$ap['fechaDesAsignacion'] = date('Y-m-d');
		    	$this->mavaluoproyecto->actualizar($ap,$rowAvaluoProyecto['id']);
		    	$idFolioAvaluo = $rowAvaluoProyecto['idAvaluo'];
				$rowAvaluoProyecto = $this->mavaluoproyecto->getByIdAvaluo($idFolioAvaluo);
	    		if($rowAvaluoProyecto->num_rows() <3){
	    			$fa['disponible'] = 1;
		    		$this->mfoliosavaluo->actualizar($fa,$idFolioAvaluo);
		    	}
		    }
			$this->db->trans_complete();

            $datitos['status'] = 1;
            $datitos['msg'] = 'La cancelación se ha realizado con éxito.';
        }
        echo json_encode($datitos);
    }
}
