<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Comisiones_bonos extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'comisiones_bonos'; // form validation variable
            $this->mainView = 'comisiones_bonos';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/comisiones_bonos/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('maltaventa','mprospecto','mproyecto','musuario','mcomisionbono','mfraccionamiento','mfraccionamientoxusuario','mprototipos','mprototipoxfraccionamiento','mgestoria','mautorizacion','mdeposito','mentrega','mareastatus','mdiferenciapromotor'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/comisiones_bonos/';


            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("contabilidad",$this->fv);

           $this->idFraccionamiento = 0;

           $this->urlLogo = '';
    }

    public function setLogo()
    {
        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
    }

    public function guardaPrimerPago(){
        $idAltaVenta = $this->input->post('idAltaVenta', TRUE);
        $tPago1 = $this->input->post('tPago1', TRUE);
        $pctjeComision = $this->input->post('pctjeComision', TRUE);
        $pctjeComision = ($pctjeComision>0)?$pctjeComision:2;

        $id = $this->maltaventa->getCampo('idProyecto',$idAltaVenta);
        $id = ($id>0)?$id:0;//$this->input->post('idProyecto', TRUE);
        if ($id > 0){
            $info = $this->maltaventa->getGestoriaByIdProy($id);
            if (!is_numeric($info)){
                $rowCB = $this->mcomisionbono->getByIdAV($info['id']);
                $data['id'] = $info['id'];//id en tabla alta venta
                $idProspecto=$this->maltaventa->getCampo('idProspecto',$info['id']);
                $data['idProyecto'] = $info['idProyecto'];
                $data['nombre']=$info['nombre']." ".$this->mprospecto->getCampo('apellidoP',$idProspecto);

                $idFraccionamiento=$this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
                $data['fraccionamiento']=$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
                $idProyecto=$this->maltaventa->getCampo('idProyecto',$info['id']);
                $data['lote']=$this->mproyecto->getCampo('lote',$idProyecto);
                $data['manzana']=$this->mproyecto->getCampo('manzana',$idProyecto);
                $avaluo = $info['avaluo'];
                $data['avaluo'] = precio_format($avaluo);
                $precioVentaOci = $info['precioVentaOci'];
                $data['precioVentaOci'] = precio_format($precioVentaOci);
                $precioVenta = $info['precioVenta'];
                $diferenciaEmpresa = $info['diferenciaEmpresa'];
                $data['precioVenta'] = precio_format($precioVenta);
                $montoFinal = $info['sumaFinal'];
                $data['montoFinal'] = precio_format($montoFinal);
                $data['difPropioPeculio'] = ($info['difPropioPeculioTitulacion']>0)?precio_format($info['difPropioPeculioTitulacion']):0.00;
                $data['numeroCredito'] = $info['numeroCredito'];
                $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $data['resultado'] = precio_format($resultado);
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $data['bonoPresupuestoInicial'] = precio_format($bonoPresupuestoInicial);
                $saldo = $resultado - $bonoPresupuestoInicial;
                $data['saldo'] = precio_format($saldo);
                $cierre = $montoFinal - $bonoPresupuestoInicial;
                $data['cierre'] = precio_format($cierre);
                $data['nombrePromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
                $data['tipoPromotor'] = $this->musuario->getCampo("tipoPromotor",$info['idPromotor']);
                $data['comision'] = $this->musuario->getCampo("comision",$info['idPromotor']);
                //El primer pago siempre es del 2%
                $importeComision = ($precioVenta - $diferenciaEmpresa) * ($pctjeComision/100);//0.02;//$data['comision']/100;
                $data['importeComision'] = precio_format($importeComision);
                $netoVenta = $cierre - $importeComision;
                $data['netoVenta'] = precio_format($netoVenta);
                $data['fecha'] = date_format(new DateTime($info['fecha']),'d/m/Y');

                ////////////////PARA GUARDAR EN LA BD/////////////////
                //$precioVenta = $info['precioVenta'];

                $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $montoFinal = $info['sumaFinal'];
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $data['comision'] = $this->musuario->getCampo("comision",$info['idPromotor']);
                //en tabla comisiones
                $pData['idAltaVenta'] = $idAltaVenta;
                $pData['difPropioPeculio'] = ($info['difPropioPeculioTitulacion']>0)?$info['difPropioPeculioTitulacion']>0:0.00;                
                $pData['resultado'] = $resultado;                
                $pData['saldo'] = $resultado - $bonoPresupuestoInicial;
                $pData['cierre'] = $montoFinal - $bonoPresupuestoInicial;
                $pData['importeComision'] = $importeComision;//($precioVenta - $diferenciaEmpresa) * $data['comision']/100;
                $pData['netoVenta'] = $pData['cierre'] - $pData['importeComision'];
                $pData['diferenciaVendedor'] = 0.00;
                $pData['comentarios'] = '';

                //en tabla autorizaciones
                $aData['primerPagoPromotor'] = 0.9 * $pData['importeComision'];
                $aData['fechaPrimerPagoPromotor'] = date('Y-m-d');
                $aData['tPago1'] = $tPago1;
                $aData['segundoPagoPromotor'] = 0.00;
                $aData['fechaSegundoPagoPromotor'] = "0000-00-00";

                $aData['pctjeComisionTotal'] = $pctjeComision;

                //insertamos la diferencia existente para este promotor
                $rowdp = $this->mdiferenciapromotor->getByIdPromotor($info['idPromotor']);
                $aData['diferencia1'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;
                $aData['diferencia2'] = 0.00;

                $aData['primerPagoCoordinador'] = 0.00;
                $aData['fechaPrimerPagoCoordinador'] = null;
                $aData['segundoPagoCoordinador'] = 0.00;
                $aData['fechaSegundoPagoCoordinador'] = null;
                $aData['bonificacion'] = 0.00;
                $aData['fechaBonificacion'] = "0000-00-00";
                $aData['statusAutorizacion'] = 'autorizado';
                //echo $diferenciaEmpresa;
                //echo "<pre>";
                //print_r($info);
                //print_r($data);
                //print_r($pData);
                //print_r($aData);
                //exit();

                $resultadoTrans = true;
                try{

                    $this->db->trans_start();
                    $id = $this->mcomisionbono->insertar($pData);
                    $validarAutorizacion=$this->mautorizacion->getByIdAV($pData['idAltaVenta']);
                    if(is_numeric($validarAutorizacion)){   
                        $aData['idAltaVenta']=$pData['idAltaVenta'];
                        $idAutorizacion = $this->mautorizacion->insertar($aData);
                    }

                    if ($_SESSION['viv']['rol']==1){
                        $idPromotor = $this->maltaventa->getCampo("created_by",$pData['idAltaVenta']);
                        $idGte = $this->musuario->getCampo('created_by',$idPromotor);
                        $updateComisiones = ($idGte>0)?$this->mcomisionbono->update($id,array('created_by' =>$idGte,'updated_by' =>$idGte)):'';
                    }

                    $avData['statusValidacion'] = 5; // indica que la venta se encuentra en etapa de gestoría
                    $this->maltaventa->actualizar($avData,$pData['idAltaVenta']);

                    //***********Insertamos en tabla cargos/abonos diferencia asesor***********//
                    if(!is_numeric($rowdp)){
                        $dpData['idAltaventa'] = $idAltaVenta;
                        $dpData['idPromotor'] = $info['idPromotor'];
                        $dpData['abono'] = $aData['primerPagoPromotor'];
                        $saldoAnterior = (!is_numeric($rowdp))?$rowdp->row()->saldo:0.00;
                        $dpData['saldo'] = ($saldoAnterior<0)?$saldoAnterior + $aData['primerPagoPromotor']:0.00;
                        $this->mdiferenciapromotor->insertar($dpData);
                    }

                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE)
                    {
                        $db_error = $this->db->error();
                        $resultadoTrans = false;
                        $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                        $data['success'] = 0;
                    }


                    }catch(Exception $e){
                        $resultadoTrans = false;
                        $data['msgInvalid'] = 'error: '.$e->getMessage();
                        $data['success'] = 0;
                    }

                    if ($resultadoTrans == true){
                        /*echo $idAutorizacion;exit();*/
                        // Autorespuesta
                        $autores = $this->autoRespuesta($pData['idAltaVenta']);
                        // Redirección
                        //redirect($this->router->class);
                        $data['success'] = 1;
                }


                //$data['success'] = 1;

                /*echo "<pre>";
                print_r($pData);
                echo "</pre>";*/
            }else{
                $data['success'] = 0;
            }
        }else{
            $data['success'] = 0;
        }
        //exit();
        echo json_encode($data);
    }

    public function guardarSeegundoPago(){
        $idAltaVenta = $this->input->post('idAltaVenta', TRUE);
        $productividad = toInt($this->input->post('productividad', TRUE));
        $pctjeComision = $this->input->post('pctjeComision',TRUE);
        $tPago2 = $this->input->post('tPago2', TRUE);
        $pctjeComisionTotal2 = $this->input->post('pctjeComisionTotal2', TRUE);//en caso de no existir productividad y de no existir primer pago de comisión
        $noProductividadNoComision1 = false;
        $aData['pctjeProductividad'] = 0.00;
        $aData['productividad'] = 0.00;
        $aData['tPago2'] = $tPago2;
        $rowComisiones = $this->mcomisionbono->getByIdAv($idAltaVenta);
        $rowPagos = $this->mautorizacion->getByIdAv($idAltaVenta);
        $rowEntrega = $this->mentrega->getByIdAV($idAltaVenta);
        if((!is_numeric($rowEntrega))){ // !is_numeric($rowComisiones) && !is_numeric($rowPagos) && 

            $rowIdProy = $this->maltaventa->getCampo('idProyecto',$idAltaVenta);
            $idProyecto = ($rowIdProy>0)?$rowIdProy:0;
            $info = $this->maltaventa->getGestoriaByIdProy($idProyecto);
            if(!is_numeric($info)){
                $cantidadRecibir = $info['precioVentaOci'] - $info['difPropioPeculioTitulacion'];//anterormente jalaba de $detalle_comisionbono['difPropioPeculio'];
                $avaluo = 2100;
                $fideicomiso = 870;
                $terreno = ($info['valorTerreno']>0)?$info['valorTerreno']:92160;//92160;
                $ahorroVol = ($info['ahorroVol']>0)?$info['ahorroVol']:0.00;
                $seguroCalidad = $info['seguroCalidad'];//aplica solo cuando es línea 2
                $valorCufrisa = $cantidadRecibir - $ahorroVol - $avaluo - $terreno;
                $importeCufrisa = $valorCufrisa * 0.017;
                $iva = $importeCufrisa * 0.16;
                $neto = $importeCufrisa + $iva;
                $importeSinTerreno = $valorCufrisa - $neto;
                $valorNeto = $importeSinTerreno + $terreno;
                $precioVivienda = $info['precioVenta'];
                $comisionSindical = $cantidadRecibir * 0.04;//0.0225;
                $valorNeto2 = $valorNeto - $comisionSindical;
                $saldo = $valorNeto2 - $precioVivienda - $fideicomiso;                
                $saldoConsiderar = $saldo * 0.25;

                $tresPorciento = $saldo * 0.03;
                $bonificacion = $saldo - $tresPorciento;  
                                        //echo precio_format($bonificacion); 
            }else{
                $bonificacion = 0.00;
            }

            $importeComision = $rowComisiones['importeComision'];
            $primerPagoPromotor = $rowPagos['primerPagoPromotor'];
            $aData['segundoPagoPromotor'] = ($primerPagoPromotor>0)?$importeComision - $primerPagoPromotor:$importeComision;
            $aData['fechaSegundoPagoPromotor'] = date('Y-m-d');

            if($productividad>0){
               $aData['pctjeProductividad'] = $pctjeComision; //***** en realiad guarda el % de productividad en base al total de vieidndas vendidas 
            }else{
                $aData['pctjeProductividad'] = 0.00;
            }         

            $aData['productividad'] = $productividad;
            $aData['bonificacion'] = $bonificacion;
            $aData['fechaBonificacion'] = date('Y-m-d');
            $aData['statusAutorizacion'] = 'autorizado';

            //insertamos la diferencia existente para este promotor
            $rowdp = $this->mdiferenciapromotor->getByIdPromotor($info['idPromotor']);
            $aData['diferencia2'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;


            $resultadoTrans = true;
            $existeEnAutorizaciones = true;
            if(!is_numeric($rowComisiones)){
                if(is_numeric($rowPagos)){
                    $existeEnAutorizaciones = false;
                    $aData1['idAltaVenta'] = $idAltaVenta; 
                    $idAutorizacion = $this->mautorizacion->insertar($aData1);
                }else{
                    $idAutorizacion = $rowPagos['id'];
                }
                if($existeEnAutorizaciones==false){ // si no existe en autorizaciones es que se pago toda la comision al entregar
                    $aData['primerPagoPromotor'] = 0.00;//0.7 * $pData['importeComision'];
                    $aData['fechaPrimerPagoPromotor'] = date('Y-m-d');
                }            

                $r['pago2'] = $this->mautorizacion->actualizar($aData,$idAutorizacion);
            }else{
                //si no existe ninguna comision agregada en comisiones
                ////////////////PARA GUARDAR EN LA BD/////////////////
                $precioVenta = $info['precioVenta'];
                $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $montoFinal = $info['sumaFinal'];
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $data['comision'] = $this->musuario->getCampo("comision",$info['idPromotor']);
                //en tabla comisiones
                $pData['idAltaVenta'] = $idAltaVenta;
                $pData['difPropioPeculio'] = ($info['difPropioPeculioTitulacion']>0)?$info['difPropioPeculioTitulacion']>0:0.00;                
                $pData['resultado'] = $resultado;                
                $pData['saldo'] = $resultado - $bonoPresupuestoInicial;
                $pData['cierre'] = $montoFinal - $bonoPresupuestoInicial;

                if($productividad>0){
                    $pctjeFinalComision = 0.02;
                }else{//sino existe productividad y no exiet pago 1 de comision
                    $pctjeFinalComision = $pctjeComisionTotal2/100;
                }

                $pData['importeComision'] = ($precioVenta - $info['diferenciaEmpresa']) * $pctjeFinalComision;//$data['comision']/100;


                $pData['netoVenta'] = $pData['cierre'] - $pData['importeComision'];
                $pData['diferenciaVendedor'] = 0.00;
                $pData['comentarios'] = '';

                //en tabla autorizaciones
                $aData['primerPagoPromotor'] = 0.00;//0.7 * $pData['importeComision'];
                $aData['fechaPrimerPagoPromotor'] = date('Y-m-d');
                $aData['segundoPagoPromotor'] = $pData['importeComision'];
                //$aData['fechaSegundoPagoPromotor'] = date('Y-m-d');//viene arriba declarado

                $aData['pctjeComisionTotal'] = $pctjeComisionTotal2;

                $aData['primerPagoCoordinador'] = 0.00;
                $aData['fechaPrimerPagoCoordinador'] = null;
                $aData['segundoPagoCoordinador'] = 0.00;
                $aData['fechaSegundoPagoCoordinador'] = null;
                //$aData['bonificacion'] = 0.00; //viene declarado arriba
                //$aData['fechaBonificacion'] = "0000-00-00"; // viene declaradoa arriba
                $aData['statusAutorizacion'] = 'autorizado';

                
                try{

                    $this->db->trans_start();
                    $id = $this->mcomisionbono->insertar($pData);
                    $validarAutorizacion=$this->mautorizacion->getByIdAV($pData['idAltaVenta']);
                    if(is_numeric($validarAutorizacion)){   
                        $aData['idAltaVenta']=$pData['idAltaVenta'];
                        $idAutorizacion = $this->mautorizacion->insertar($aData);
                    }

                    if ($_SESSION['viv']['rol']==1){
                        $idPromotor = $this->maltaventa->getCampo("created_by",$pData['idAltaVenta']);
                        $idGte = $this->musuario->getCampo('created_by',$idPromotor);
                        $updateComisiones = ($idGte>0)?$this->mcomisionbono->update($id,array('created_by' =>$idGte,'updated_by' =>$idGte)):'';
                    }

                    $avData['statusValidacion'] = 5; // indica que la venta se encuentra en etapa de gestoría
                    $this->maltaventa->actualizar($avData,$pData['idAltaVenta']);
                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE)
                    {
                        $db_error = $this->db->error();
                        $resultadoTrans = false;
                        $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                        $response = array(
                            'success' => FALSE,
                            'msg' => 'Id alta venta con valor null'
                        );
                    }

                }catch(Exception $e){
                    $resultadoTrans = false;
                    $data['msgInvalid'] = 'error: '.$e->getMessage();
                    $response = array(
                        'success' => FALSE,
                        'msg' => 'Id alta venta con valor null'
                    );
                }

                if ($resultadoTrans == true){
                    // Autorespuesta
                    //$autores = $this->autoRespuesta($pData['idAltaVenta']);
                    // Redirección

                    
                }
            }            

            if($resultadoTrans==true){
                //Insertamos en tabla cargos/abonos diferencia asesor
                if(!is_numeric($rowdp)){
                    $totalAbono = $aData['segundoPagoPromotor'] + $aData['productividad'];
                    $dpData['idAltaventa'] = $idAltaVenta;
                    $dpData['idPromotor'] = $info['idPromotor'];
                    $dpData['abono'] = $totalAbono;
                    $saldoAnterior = (!is_numeric($rowdp))?$rowdp->row()->saldo:0.00;
                    $dpData['saldo'] = ($saldoAnterior<0)?$saldoAnterior + $totalAbono:0.00;
                    $this->mdiferenciapromotor->insertar($dpData);
                }

                //$eData['fechaEntrega'] = date('Y-m-d');
                $eData['statusPago2'] = 1;
                $r['statusPago2'] = $this->mentrega->actualizar($eData,$rowEntrega['id']);
                $response = array(
                    'success' => TRUE,
                    'idAltaVenta' => $idAltaVenta,
                    'idProyecto' => '',
                    'responseUpd' => '',
                );
            }

        }else{
            $response = array(
                'success' => FALSE,
                'msg' => 'Id alta venta con valor null'
            );
        }

        echo json_encode( $response );
    }

    public function todosPendientesPago(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query = $this->maltaventa->todosPendientesPago();
        $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
        $date=new DateTime();
        $name = "Comisiones-Pendientes-".$date->format("d-m-Y").".csv";
        force_download($name, $csv);
    }

/*    public function csvPrimerComision(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query = $this->maltaventa->csvPrimerComision();
        $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
        $date=new DateTime();
        $name = "Comisiones-Pendientes-".$date->format("d-m-Y").".csv";
        force_download($name, $csv);
    }

    public function csvComisiones(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query = $this->maltaventa->csvComisiones();
        $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
        $date=new DateTime();
        $name = "Comisiones-".$date->format("d-m-Y").".csv";
        force_download($name, $csv);
    }

    public function csvDepositos(){
        $this->load->dbutil();
        $this->load->helper('download');
        $query = $this->maltaventa->csvDepositos();
        $csv = mb_convert_encoding($this->dbutil->csv_from_result($query, ",", "\n"), "ISO-8859-1", "UTF-8");
        $date=new DateTime();
        $name = "Bonificaciones-".$date->format("d-m-Y").".csv";
        force_download($name, $csv);
    }*/

	public function index(){
		$data['q'] = '';
        $data['diferenciaPromotores'] = $this->mdiferenciapromotor->getPendientes();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->maltaventa->getJoinComisiones();

        if (!is_numeric($q)){
            $primerPagoPromotor='';
            foreach ($q->result() as $row){
            $rowautorizaciones=$this->mautorizacion->getByIdAV($row->idAltaVenta);
            $dDepositos = $this->mdeposito->getByIdAV($row->id);
            $totDepositos = (!is_numeric($dDepositos))?$dDepositos['pagoUno']+$dDepositos['pagoDos']+$dDepositos['pagoTres']+$dDepositos['pagoCuatro']+$dDepositos['pagoCinco']+$dDepositos['pagoSeis']+$dDepositos['pagoSiete']+$dDepositos['pagoOcho']:0;
            $pctjeComisionTotal = 0.00;
            $productividad = 0.00;

            if(!is_numeric($rowautorizaciones)){   

                $diferenciaTP1 = $rowautorizaciones['diferencia1'];
                $diferencia1 = $rowautorizaciones['primerPagoPromotor'] - $rowautorizaciones['diferencia1'];
                $totPago1 = ($diferencia1 < 0)?0.00:$diferencia1;

                $diferenciaTP2 = $rowautorizaciones['diferencia2'];
                $diferencia2 = ($rowautorizaciones['segundoPagoPromotor'] + $rowautorizaciones['productividad']) - $rowautorizaciones['diferencia2'];
                $totPago2 = ($diferencia2 < 0)?0.00:$diferencia2;

                $primerPagoPromotor= $rowautorizaciones['primerPagoPromotor'];
                $fechaPrimerPagoPromotor= $rowautorizaciones['fechaPrimerPagoPromotor'];
                $tPago1 = $rowautorizaciones['tPago1'];
                $segundoPagoPromotor= $rowautorizaciones['segundoPagoPromotor'];
                $fechaSegundoPagoPromotor= $rowautorizaciones['fechaSegundoPagoPromotor'];
                $tPago2 = $rowautorizaciones['tPago2'];
                $primerPagoCoordinador= $rowautorizaciones['primerPagoCoordinador'];
                $fechaPrimerPagoCoordinador= $rowautorizaciones['fechaPrimerPagoCoordinador'];
                $segundoPagoCoordinador= $rowautorizaciones['segundoPagoCoordinador'];
                $fechaSegundoPagoCoordinador= $rowautorizaciones['fechaSegundoPagoCoordinador'];
                $bonificacion= $rowautorizaciones['bonificacion'];
                $fechaBonificacion= $rowautorizaciones['fechaBonificacion'];
                $pctjeComisionTotal = $rowautorizaciones['pctjeComisionTotal'];//($rowautorizaciones['segundoPagoPromotor']==0.00)?2.00:$rowautorizaciones['pctjeComisionTotal'];
                $productividad = $rowautorizaciones['productividad'];
            }else{ 
                $diferenciaTP1 = 0.00;
                $totPago1 = 0.00;
                $diferenciaTP2 = 0.00;
                $totPago2 = 0.00;

                $primerPagoPromotor= "";
                $fechaPrimerPagoPromotor= "";
                $tPago1 = "";
                $segundoPagoPromotor= "";
                $fechaSegundoPagoPromotor= "";
                $tPago2 = "";
                $primerPagoCoordinador= "";
                $fechaPrimerPagoCoordinador= "";
                $segundoPagoCoordinador= "";
                $fechaSegundoPagoCoordinador= "";
                $bonificacion= "";
                $fechaBonificacion= "";

            }    
                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
                $array['aaData'][] = array(
                    'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
                    'lote' => $this->mproyecto->getCampo('lote',$row->idProyecto),
                    'manzana' => $row->manzana,
                    'lineaCredito' => $row->lineaCredito,
                    'ronda' => '',
                    'cliente' =>strtoupper ($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$row->idProspecto)),
                    'nss' => $row->nss,
                    'promotor' => strtoupper($this->musuario->getCampo("nombre",$row->idPromotor)." ".$this->musuario->getCampo("apellidoP",$row->idPromotor)." ".$this->musuario->getCampo("apellidoM",$row->idPromotor)),
                    'avaluo' => precio_format($row->avaluo),
                    'ahorroVol' => precio_format($row->ahorroVol),
                    'precioVentaOci' => precio_format($row->precioVentaOci),
                    'precioVenta' => precio_format($row->precioVenta),
                    'sumaFinal' => precio_format($row->sumaFinal),
                    'difPropioPeculio' => precio_format($row->difPropioPeculio),
                    'numeroCredito' => $row->numeroCredito,
                    'resultado' => precio_format($row->resultado),
                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
                    'saldo' => precio_format($row->saldo),
                    'cierre' => precio_format($row->cierre),
                    'tipoPromotor' =>strtoupper ($this->musuario->getCampo('tipoPromotor',$row->idPromotor)),
                    'comision' => ($pctjeComisionTotal>0)?$pctjeComisionTotal." %":$this->musuario->getCampo("comision",$row->idPromotor)."%",
                    'importeComision' => precio_format($row->importeComision),
                    'diferenciaCliente' => precio_format($row->diferenciaCliente),
                    'diferenciaAsesor' => precio_format($row->diferenciaAsesor),
                    'diferenciaEmpresa' => precio_format($row->diferenciaEmpresa),
                    'diferenciaVendedor' => precio_format(abs($diferenciaTP1)),//precio_format($row->diferenciaCliente + $row->diferenciaAsesor + $row->diferenciaEmpresa),//precio_format($row->diferenciaVendedor),
                    'productividad' =>  precio_format($productividad),
                    /*campos que vienen de autorizacion*/
                    'netoVenta' => precio_format($row->netoVenta),
                    'comentarios' => strtoupper($row->comentarios),
                    'primerPagoPromotor' => precio_format($primerPagoPromotor),
                    'totPago1' => precio_format($totPago1),
                    'fechaPrimerPagoPromotor' => ($fechaPrimerPagoPromotor!='0000-00-00' && $fechaPrimerPagoPromotor!='')?date('d/m/Y',strtotime($fechaPrimerPagoPromotor)):'',
                    'tPago1' =>  $tPago1,
                    'diferenciaVendedor2' => precio_format(abs($diferenciaTP2)),
                    'segundoPagoPromotor' => precio_format($segundoPagoPromotor),
                    'totPago2' => precio_format($totPago2),
                    'fechaSegundoPagoPromotor' => ($fechaSegundoPagoPromotor!='0000-00-00' && $fechaSegundoPagoPromotor!='')?date('d/m/Y',strtotime($fechaSegundoPagoPromotor)):'',
                    'tPago2' =>  $tPago2,
                    'primerPagoCoordinador' => $primerPagoCoordinador,
                    'fechaPrimerPagoCoordinador' => ($fechaPrimerPagoCoordinador!='0000-00-00' && $fechaPrimerPagoCoordinador!='')?date('d/m/Y',strtotime($fechaPrimerPagoCoordinador)):'',
                    'segundoPagoCoordinador' =>$segundoPagoCoordinador,
                    'fechaSegundoPagoCoordinador' => ($fechaSegundoPagoCoordinador!='0000-00-00' && $fechaSegundoPagoCoordinador!='')?date('d/m/Y',strtotime($fechaSegundoPagoCoordinador)):'',
                    'bonificacion' => precio_format((int)$bonificacion),
                    'fechaBonificacion' => ($fechaBonificacion!='0000-00-00' && $fechaBonificacion!='')?date('d/m/Y',strtotime($fechaBonificacion)):'',
                    /*Termina campos que vienen de autorizacion*/
                    /*'totDepositos' => precio_format($totDepositos),*/
                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
                    'totDepositos' => precio_format($totDepositos),
                    'estatus' => (!is_numeric($this->mautorizacion->getByIdAV($row->id))?strtoupper($this->mautorizacion->getByIdAV($row->id)['statusAutorizacion']):'' ),
                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("ventas","comisiones_bonos_edit")["r"])) ? acciones($row->id,$this->router->class, true, true, false) : accionesNoEdit($row->id,$this->router->class)
                    );
            }
        }else{
            $array['aaData'][] = array(
                'fraccionamiento' => 'No hay registros',
                'lote' =>  'No hay registros',
                'manzana' =>  'No hay registros',
                'lineaCredito' =>  'No hay registros',
                'ronda' => 'No hay registros',
                'cliente' =>  'No hay registros',
                'nss' => 'No hay registros',
                'promotor' => 'No hay registros',
                'avaluo' =>  'No hay registros',
                'ahorroVol' =>  'No hay registros',
                'precioVentaOci' =>  'No hay registros',
                'precioVenta' =>  'No hay registros',
                'sumaFinal' =>  'No hay registros',
                'difPropioPeculio' =>  'No hay registros',
                'numeroCredito' =>  'No hay registros',
                'resultado' =>  'No hay registros',
                'bonoEquipamiento' =>  'No hay registros',
                'saldo' =>  'No hay registros',
                'cierre' =>  'No hay registros',
                'tipoPromotor' =>  'No hay registros',
                'comision' =>  'No hay registros',
                'importeComision' =>  'No hay registros',
                'diferenciaCliente' => 'No hay registros',
                'diferenciaAsesor' => 'No hay registros',
                'diferenciaEmpresa' => 'No hay registros',
                'diferenciaVendedor' =>  'No hay registros',
                'productividad' =>  'No hay registros',
                /*campos que vienen de autorizacion*/
                'netoVenta' =>  'No hay registros',
                'comentarios' =>  'No hay registros',
                'primerPagoPromotor' =>  'No hay registros',
                'fechaPrimerPagoPromotor' =>  'No hay registros',
                'tPago1' =>  'No hay registros',
                'segundoPagoPromotor' =>  'No hay registros',
                'fechaSegundoPagoPromotor' => 'No hay registros',
                'tPago2' =>  'No hay registros',
                'primerPagoCoordinador' =>  'No hay registros',
                'fechaPrimerPagoCoordinador' =>  'No hay registros',
                'segundoPagoCoordinador' => 'No hay registros',
                'fechaSegundoPagoCoordinador' =>  'No hay registros',
                'bonificacion' =>  'No hay registros',
                'fechaBonificacion' =>  'No hay registros',
                'totDepositos' => 'No hay registros',
                'statusVivienda' =>  'No hay registros',
                'totDepositos' =>  'No hay registros',
                'estatus' =>  'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function listado2(){
        $q = $this->maltaventa->todosPendientesPagoHtml();
        if ($q->num_rows()>0){
            foreach ($q->result() as $row){
                $existeEnComisiones = $this->mcomisionbono->getByIdAV($row->id);
                $existeEntrega = $this->mentrega->getByIdAV($row->id);
                $idPromotor = $this->mprospecto->getCampo('idPromotor',$row->idProspecto);
                $comisionP = 2.0;//($idPromotor>0)?$this->musuario->getCampo('comision',$idPromotor):0.00;
                $totComision = $row->pVenta * ($comisionP/100);
                if(in_array($_SESSION["viv"]["rol"], permisos("ventas","comisiones_bonos_edit")["r"])){
                    if(is_numeric($existeEnComisiones) && is_numeric($existeEntrega)){
                        $acciones = '
                        <a class="btn blue" href="javascript:void(0);" onclick="modalPrimerPago('.$row->id.')" style="margin-bottom:10px;">Validar Pago 1</a>
                        <a class="btn blue" href="'.$this->router->class.'/nuevo/'.$row->idProyecto.'">Editar</a>
                        ';
                    }else{
                        $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalSegundoPago('.$row->id.')">Validar Pago 2</a>';
                    } 
                }else{ 
                    $acciones = ''; 
                }

                $array['aaData'][] = array(
                    'statusPago' => ($row->statusPago!='0000-00-00' && $row->statusPago!='')?date('d/m/Y',strtotime($row->statusPago)):'',
                    'tCred' => $row->tCred,
                    'promotor' => $row->promotor,
                    'cliente' => $row->cliente,
                    'curp' => ($row->idProspecto>0)?strtoupper($this->mprospecto->getCampo('curp',$row->idProspecto)):'',
                    'rfc' => ($row->idProspecto>0)?strtoupper($this->mprospecto->getCampo('rfc',$row->idProspecto)):'',
                    'fraccionamiento' => $row->fraccionamiento,
                    'manzana' => $row->manzana,
                    'lote' => $row->lote,
                    'tCred2' => $row->tCred2,
                    'pVenta' => precio_format($row->pVenta),
                    'totComision' => precio_format($totComision),//precio_format($row->totComision),
                    'otrosDesc' => $row->otrosDesc,
                    'retencionComision' => precio_format($row->retencionComision),
                    'comisionAl100' => precio_format($row->comisionAl100),
                    'primerComision' => precio_format($row->primerComision),
                    'fecha1Pago' => ($row->fecha1Pago!='0000-00-00' && $row->fecha1Pago!='')?date('d/m/Y',strtotime($row->fecha1Pago)):'',
                    'segundaComision' => (!is_numeric($existeEntrega))?precio_format($row->segundaComision):'',
                    'saldo' => (!is_numeric($existeEntrega))?precio_format($row->saldo):'',
                    'bonificacion' => (!is_numeric($existeEntrega))?precio_format($row->bonificacion):'',
                    'saldoConsiderar' => (!is_numeric($existeEntrega))?$row->saldoConsiderar:'',
                    'bonoEquipamiento' => (!is_numeric($existeEntrega))?precio_format($row->bonoEquipamiento):'',
                    'retencion' => (!is_numeric($existeEntrega))?$row->retencion:'',
                    'totalPagar' => (!is_numeric($existeEntrega))?$row->totalPagar:'',
                    'fecha2Pago' => (!is_numeric($existeEntrega) && $row->fecha2Pago!='0000-00-00' && $row->fecha2Pago!='')?date('d/m/Y',strtotime($row->fecha2Pago)):'',
                    'acciones' => $acciones
                    );
            }
        }else{
            $array['aaData'][] = array(
                'statusPago' => 'No hay registros',
                'tCred' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'curp' => 'No hay registros',
                'rfc' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'tCred2' => 'No hay registros',
                'pVenta' => 'No hay registros',
                'totComision' => 'No hay registros',
                'otrosDesc' => 'No hay registros',
                'retencionComision' => 'No hay registros',
                'comisionAl100' => 'No hay registros',
                'primerComision' => 'No hay registros',
                'fecha1Pago' => 'No hay registros',
                'segundaComision' => 'No hay registros',
                'saldo' => 'No hay registros',
                'bonificacion' => 'No hay registros',
                'saldoConsiderar' => 'No hay registros',
                'bonoEquipamiento' => 'No hay registros',
                'retencion' => 'No hay registros',
                'totalPagar' => 'No hay registros',
                'fecha2Pago' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);

    }


/*    public function listado2(){
        $q = $this->maltaventa->getComisionesPendientes();
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
                $array['aaData'][] = array(
                    'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)),
                    'lote' => $this->mproyecto->getCampo('lote',$row->idProyecto),
                    'manzana' => $row->manzana,
                    'lineaCredito' => $row->lineaCredito,
                    'cliente' => strtoupper($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$row->idProspecto)),
                    'nss' => $row->nss,
                    'promotor' => strtoupper($this->musuario->getCampo("nombre",$row->idPromotor)." ".$this->musuario->getCampo("apellidoP",$row->idPromotor)." ".$this->musuario->getCampo("apellidoM",$row->idPromotor)),
                    'avaluo' => precio_format($row->avaluo),
                    'precioVentaOci' => precio_format($row->precioVentaOci),
                    'precioVenta' => precio_format($row->precioVenta),
                    'sumaFinal' => precio_format($row->sumaFinal),
                    'difPropioPeculio' => '',//precio_format($row->difPropioPeculio),
                    'numeroCredito' => $row->numeroCredito,
                    'resultado' => '',//precio_format($row->resultado),
                    'bonoEquipamiento' => precio_format($row->bonoEquipamiento),
                    'saldo' => '',//precio_format($row->saldo),
                    'cierre' => '',//precio_format($row->cierre),
                    'comision' => $this->musuario->getCampo("comision",$row->idPromotor)."%",
                    'importeComision' => '',//precio_format($row->importeComision),
                    'diferenciaVendedor' => '',//precio_format($row->diferenciaVendedor),
                    'statusVivienda' => strtoupper(estatus_proyecto_reporte($row->statusVenta)),
                    'acciones' => (in_array($_SESSION["viv"]["rol"], permisos("ventas","comisiones_bonos_edit")["r"])) ? '<a class="btn blue" href="'.$this->router->class.'/nuevo/'.$row->idProyecto.'">Validar</a>' : ''
                    );
            }
        }else{
            $array['aaData'][] = array(
                'fraccionamiento' => 'No hay registros',
                'lote' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lineaCredito' => 'No hay registros',
                'cliente' =>  'No hay registros',
                'nss' => 'No hay registros',
                'promotor' => 'No hay registros',
                'avaluo' => 'No hay registros',
                'precioVentaOci' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'sumaFinal' => 'No hay registros',
                'difPropioPeculio' => 'No hay registros',
                'numeroCredito' => 'No hay registros',
                'resultado' => 'No hay registros',
                'bonoEquipamiento' => 'No hay registros',
                'saldo' => 'No hay registros',
                'cierre' => 'No hay registros',
                'comision' => 'No hay registros',
                'importeComision' => 'No hay registros',
                'diferenciaVendedor' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }*/

    public function nuevo($idProyecto=null)
    {
        // Mensajes
        $data['msg'] = '';
        $resultado = true;
        $data['proyectos'] = $this->mproyecto->getSelectResultForComision();
        $data['idProyecto'] = ($idProyecto!=null)?$idProyecto:'';
        $data['idAltaVenta'] = 0;
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $pData['idAltaVenta'] = $this->input->post('idAltaVenta', TRUE);
            $data['idAltaVenta'] = $pData['idAltaVenta'];
            //print_r($data['msg']);exit();
        } else {
            $pData['idAltaVenta'] = $this->input->post('idAltaVenta', TRUE);
            $data['idAltaVenta'] = $pData['idAltaVenta'];
            $difPropioPeculio = $this->input->post('difPropioPeculio', TRUE);
            $pData['difPropioPeculio'] = toInt($difPropioPeculio);
            $resultado = $this->input->post('resultado', TRUE);
            $pData['resultado'] = toInt($resultado);
            $saldo = $this->input->post('saldo', TRUE);
            $pData['saldo'] = toInt($saldo);
            $cierre = $this->input->post('cierre', TRUE);
            $pData['cierre'] = toInt($cierre);
            $comision = $this->input->post('comision', TRUE);
            $importeComision = $this->input->post('importeComision', TRUE);
            $pData['importeComision'] = toInt($importeComision); // como viene de un formato de moneda lo convertimos a entero
            $netoVenta = $this->input->post('netoVenta', TRUE);
            $pData['netoVenta'] = toInt($netoVenta);
            $diferenciaVendedor = $this->input->post('diferenciaVendedor', TRUE);
            $pData['diferenciaVendedor'] = ($diferenciaVendedor!='')?toInt($diferenciaVendedor):0.00;
            $pData['comentarios'] = $this->input->post('comentarios', TRUE);

            //****guardamos el % de la comision total
            $aData['pctjeComisionTotal'] = ($comision>0)?$comision:2;
            /*Estos son los los datos para Importe de comisión total*/
            $primerPagoPromotor = $this->input->post('primerPagoPromotor', TRUE); //este dato viene en porcentaje
            $aData['porcentajePrimerPago'] = ($primerPagoPromotor>0)?$primerPagoPromotor:0.00;

            $calculo1erPago = ($primerPagoPromotor>0)?($primerPagoPromotor/100) * ($pData['importeComision']):0.00;

            $aData['primerPagoPromotor'] = $calculo1erPago;//($primerPagoPromotor!='')?toInt($primerPagoPromotor):0.00;
            $fechaPrimerPagoPromotor = $this->input->post('fechaPrimerPagoPromotor', TRUE);
            $fechaPrimerPagoPromotor = str_replace('/', '-', $fechaPrimerPagoPromotor);//date_format(new DateTime($fechaPrimerPagoPromotor),'Y-m-d');
            $aData['fechaPrimerPagoPromotor'] = ($fechaPrimerPagoPromotor!='')?date('Y-m-d', strtotime($fechaPrimerPagoPromotor)):'0000-00-00';
            $segundoPagoPromotor = $this->input->post('segundoPagoPromotor', TRUE);

            //***********insertamos la diferencia existente para este promotor*************///////
            $idProspecto = $this->maltaventa->getCampo('idProspecto',$pData['idAltaVenta']);
            $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProspecto);
            $rowdp = $this->mdiferenciapromotor->getByIdPromotor($idPromotor);
            $aData['diferencia1'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;
            $aData['diferencia2'] = 0.00;         

            $aData['segundoPagoPromotor'] = 0.00;//($segundoPagoPromotor!='')?toInt($segundoPagoPromotor):0.00;
            $fechaSegundoPagoPromotor = $this->input->post('fechaSegundoPagoPromotor', TRUE);
            $fechaSegundoPagoPromotor = str_replace('/', '-', $fechaSegundoPagoPromotor);
            $aData['fechaSegundoPagoPromotor'] = '0000-00-00';//($fechaSegundoPagoPromotor!='')?date('Y-m-d', strtotime($fechaSegundoPagoPromotor)):'0000-00-00';
            $primerPagoCoordinador = $this->input->post('primerPagoCoordinador', TRUE);
            $aData['primerPagoCoordinador'] = ($primerPagoCoordinador!='')?toInt($primerPagoCoordinador):0.00;
            $fechaPrimerPagoCoordinador = $this->input->post('fechaPrimerPagoCoordinador', TRUE);
            $fechaPrimerPagoCoordinador = str_replace('/', '-', $fechaPrimerPagoCoordinador);
            $aData['fechaPrimerPagoCoordinador'] = ($fechaPrimerPagoCoordinador!='')?date('Y-m-d', strtotime($fechaPrimerPagoCoordinador)):'0000-00-00';
            $segundoPagoCoordinador = $this->input->post('segundoPagoCoordinador', TRUE);
            $aData['segundoPagoCoordinador'] = ($segundoPagoCoordinador!='')?toInt($segundoPagoCoordinador):0.00;
            $fechaSegundoPagoCoordinador = $this->input->post('fechaSegundoPagoCoordinador', TRUE);
            $fechaSegundoPagoCoordinador = str_replace('/', '-', $fechaSegundoPagoCoordinador);
            $aData['fechaSegundoPagoCoordinador'] = ($fechaSegundoPagoCoordinador!='')?date('Y-m-d', strtotime($fechaSegundoPagoCoordinador)):'0000-00-00';
            $bonificacion = $this->input->post('bonificacion', TRUE);
            $aData['bonificacion'] = 0.00;//($bonificacion!='')?toInt($bonificacion):0.00;
            $fechaBonificacion = $this->input->post('fechaBonificacion', TRUE);
            $fechaBonificacion = str_replace('/', '-', $fechaBonificacion);
            $aData['fechaBonificacion'] = '0000-00-00';//($fechaBonificacion!='')?date('Y-m-d', strtotime($fechaBonificacion)):'0000-00-00';
            $statusAutorizacion = $this->input->post('autorizacion', TRUE);
            $aData['statusAutorizacion'] = $statusAutorizacion;
            $aData['tPago1'] = $this->input->post('tPago1', TRUE);
            /*
            echo "<pre>";
            print_r($pData);
            echo "</pre>";
            exit();
            */
            try{

                $this->db->trans_start();
                $id = $this->mcomisionbono->insertar($pData);
                $validarAutorizacion=$this->mautorizacion->getByIdAV($pData['idAltaVenta']);
                if(is_numeric($validarAutorizacion)){   
                    $aData['idAltaVenta']=$pData['idAltaVenta'];
                    $idAutorizacion = $this->mautorizacion->insertar($aData);
                }

                if ($_SESSION['viv']['rol']==1){
                    $idPromotor = $this->maltaventa->getCampo("created_by",$pData['idAltaVenta']);
                    $idGte = $this->musuario->getCampo('created_by',$idPromotor);
                    $updateComisiones = ($idGte>0)?$this->mcomisionbono->update($id,array('created_by' =>$idGte,'updated_by' =>$idGte)):'';
                }

                $avData['statusValidacion'] = 5; // indica que la venta se encuentra en etapa de gestoría
                $this->maltaventa->actualizar($avData,$pData['idAltaVenta']);

                //***********Insertamos en tabla cargos/abonos diferencia asesor***********//
                if(!is_numeric($rowdp)){
                    $dpData['idAltaventa'] = $pData['idAltaVenta'];
                    $dpData['idPromotor'] = $idPromotor;
                    $dpData['abono'] = $aData['primerPagoPromotor'];
                    $saldoAnterior = (!is_numeric($rowdp))?$rowdp->row()->saldo:0.00;
                    $dpData['saldo'] = ($saldoAnterior<0)?$saldoAnterior + $aData['primerPagoPromotor']:0.00;
                    $this->mdiferenciapromotor->insertar($dpData);
                }


                $this->db->trans_complete();

                if ($this->db->trans_status() === FALSE)
                {
                    $db_error = $this->db->error();
                    $resultado = false;
                    $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                }


            }catch(Exception $e){
                $resultado = false;
                $data['msgInvalid'] = 'error: '.$e->getMessage();
            }

            if ($resultado == true){
                /*echo $idAutorizacion;exit();*/
                // Autorespuesta
                $autores = $this->autoRespuesta($pData['idAltaVenta']);
                // Redirección
                redirect($this->router->class);
            }



            /*
            if ($this->db->trans_status() === FALSE)
            {
                $resultado = false;
                $data['msgInvalid'] = $this->db->_error_message();
            }
            if ($resultado==true) {
                redirect($this->router->class);
            }*/



            /*
            echo "<pre>";
            print_r($pData);
            echo "</pre>";
            exit();*/




            /*
            $pData['idProyecto'] = $this->input->post('idProyecto', TRUE);
            $pData['idProspecto'] = $this->input->post('idProspecto', TRUE);
            $pData['descripcion'] = $this->input->post('descripcion', TRUE);
            $pData['monto'] = $this->input->post('monto', TRUE);
            $pData['subCuenta'] = $this->input->post('subCuenta', TRUE);
            $pData['gastosOperacion'] = $this->input->post('gastosOperacion', TRUE);
            $pData['total'] = $pData['monto'] + $pData['subCuenta'] - $pData['gastosOperacion'];
            $fechaPreca = $this->input->post('fechaPreca', TRUE);
            $pData['fechaPreca'] = date_format(new DateTime($fechaPreca),'Y-m-d');
            $pData['status'] = 1;

            $id = $this->maltaventa->insertar($pData);

            $proData['nombre'] = $this->input->post('nombre', TRUE);
            $proData['apellidoP'] = $this->input->post('apellidoP', TRUE);
            $proData['apellidoM'] = $this->input->post('apellidoM', TRUE);
            $proData['rfc'] = $this->input->post('rfc', TRUE);
            $proData['telefono'] = $this->input->post('telefono', TRUE);
            $fecha = $this->input->post('fecha', TRUE);
            $proData['fecha'] = date_format(new DateTime($fecha),'Y-m-d');
            $fechaNac = $this->input->post('fechaNac', TRUE);
            $proData['fechaNac'] = date_format(new DateTime($fechaNac),'Y-m-d');
            $proData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);

            $this->mprospecto->actualizar($proData, $pData['idProspecto']);*/

        }

        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);

    }

    public function editar($id=null,$idComision=null) //$id viene del join getJoinComisiones es equivalente al id de la tabla alta_venta
    {
        // Mensajes
        $data['msg'] = '';
        $resultado = true;
      
        $this->load->library('form_validation');

        if (isset($_POST['comision'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                $pData['idAltaVenta'] = $id;
                $difPropioPeculio = $this->input->post('difPropioPeculio', TRUE);
                //$pData['difPropioPeculio'] = toInt($difPropioPeculio);//se quita acción para guardar 05nov2020
                $resultado = $this->input->post('resultado', TRUE);
                //$pData['resultado'] = toInt($resultado); //se quita acción para guardar 05nov2020
                $saldo = $this->input->post('saldo', TRUE);
                //$pData['saldo'] = toInt($saldo);//se quita acción para guardar 05nov2020
                $cierre = $this->input->post('cierre', TRUE);
                //$pData['cierre'] = toInt($cierre);//se quita acción para guardar 05nov2020
                $importeComision = $this->input->post('importeComision', TRUE);
                //$pData['importeComision'] = toInt($importeComision); //se quita acción para guardar 05nov2020 // como viene de un formato de moneda lo convertimos a entero
                $netoVenta = $this->input->post('netoVenta', TRUE);
                //$pData['netoVenta'] = toInt($netoVenta);//se quita acción para guardar 05nov2020
                $diferenciaVendedor = $this->input->post('diferenciaVendedor', TRUE);
                //$pData['diferenciaVendedor'] = ($diferenciaVendedor)?toInt($diferenciaVendedor):0.00; //se quita acción para guardar 05nov2020
                $pData['comentarios'] = $this->input->post('comentarios', TRUE);
                $idPromotor = $this->input->post('idPromotor', TRUE); // para actualizar en la tabla usuarios el % de la comisión
                //$proData['comision'] = $this->input->post('comision', TRUE);//se quita acción para guardar 05nov2020

                /*Estos son los los datos para Importe de comisión total*/
                //$primerPagoPromotor = $this->input->post('primerPagoPromotor', TRUE);
                //$aData['primerPagoPromotor'] = ($primerPagoPromotor!='')?toInt($primerPagoPromotor):0.00;
                
                $primerPagoPromotor = $this->input->post('primerPagoPromotor', TRUE); //este dato viene en porcentaje
                //$aData['porcentajePrimerPago'] = ($primerPagoPromotor>0)?$primerPagoPromotor:0.00;//se quita acción para guardar 05nov2020
                $calculo1erPago = ($primerPagoPromotor>0)?($primerPagoPromotor/100) * ($pData['importeComision']):0.00;
                //$aData['primerPagoPromotor'] = $calculo1erPago;

                $fechaPrimerPagoPromotor = $this->input->post('fechaPrimerPagoPromotor', TRUE);
                $fechaPrimerPagoPromotor = str_replace('/', '-', $fechaPrimerPagoPromotor);//date_format(new DateTime($fechaPrimerPagoPromotor),'Y-m-d');
                //$aData['fechaPrimerPagoPromotor'] = ($fechaPrimerPagoPromotor!='')?date('Y-m-d', strtotime($fechaPrimerPagoPromotor)):'0000-00-00';//se quita acción para guardar 05nov2020
                $segundoPagoPromotor = $this->input->post('segundoPagoPromotor', TRUE);
                //$aData['segundoPagoPromotor'] = 0.00;//($segundoPagoPromotor!='')?toInt($segundoPagoPromotor):0.00;
                $fechaSegundoPagoPromotor = $this->input->post('fechaSegundoPagoPromotor', TRUE);
                $fechaSegundoPagoPromotor = str_replace('/', '-', $fechaSegundoPagoPromotor);
                //$aData['fechaSegundoPagoPromotor'] = '0000-00-00';//($fechaSegundoPagoPromotor!='')?date('Y-m-d', strtotime($fechaSegundoPagoPromotor)):'0000-00-00';
                $primerPagoCoordinador = $this->input->post('primerPagoCoordinador', TRUE);
                $aData['primerPagoCoordinador'] = ($primerPagoCoordinador!='')?toInt($primerPagoCoordinador):0.00;
                $fechaPrimerPagoCoordinador = $this->input->post('fechaPrimerPagoCoordinador', TRUE);
                $fechaPrimerPagoCoordinador = str_replace('/', '-', $fechaPrimerPagoCoordinador);
                $aData['fechaPrimerPagoCoordinador'] = ($fechaPrimerPagoCoordinador!='')?date('Y-m-d', strtotime($fechaPrimerPagoCoordinador)):'0000-00-00';
                $segundoPagoCoordinador = $this->input->post('segundoPagoCoordinador', TRUE);
                $aData['segundoPagoCoordinador'] = ($segundoPagoCoordinador!='')?toInt($segundoPagoCoordinador):0.00;
                $fechaSegundoPagoCoordinador = $this->input->post('fechaSegundoPagoCoordinador', TRUE);
                $fechaSegundoPagoCoordinador = str_replace('/', '-', $fechaSegundoPagoCoordinador);
                $aData['fechaSegundoPagoCoordinador'] = ($fechaSegundoPagoCoordinador!='')?date('Y-m-d', strtotime($fechaSegundoPagoCoordinador)):'0000-00-00';
                $bonificacion = $this->input->post('bonificacion', TRUE);
                //$aData['bonificacion'] = 0.00;//($bonificacion!='')?toInt($bonificacion):0.00;
                $fechaBonificacion = $this->input->post('fechaBonificacion', TRUE);
                $fechaBonificacion = str_replace('/', '-', $fechaBonificacion);
                //$aData['fechaBonificacion'] = '0000-00-00';//($fechaBonificacion!='')?date('Y-m-d', strtotime($fechaBonificacion)):'0000-00-00';
                $statusAutorizacion = $this->input->post('autorizacion', TRUE);
                $aData['statusAutorizacion'] = $statusAutorizacion;
                $aData['tPago1'] = $this->input->post('tPago1', TRUE);

                try{

                    $this->db->trans_start();
                    $this->mcomisionbono->actualizar($pData,$idComision);

                     $validarAutorizacion=$this->mautorizacion->getByIdAV($pData['idAltaVenta']);
                    
                    if(!is_numeric($validarAutorizacion)){   
                        $aData['idAltaVenta']=$pData['idAltaVenta'];
                        $idAutorizacion = $this->mautorizacion->actualizar($aData,$validarAutorizacion['id']);
                    }

                    if ($_SESSION['viv']['rol']==1){
                        $idGte = $this->musuario->getCampo('created_by',$idPromotor);
                        $updateComisiones = ($idGte>0)?$this->mcomisionbono->update($id,array('created_by' =>$idGte,'updated_by' =>$idGte)):'';
                    }
                    //$this->musuario->actualizar($proData,$idPromotor);
                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE)
                    {
                        $db_error = $this->db->error();
                        $resultado = false;
                        $data['msgInvalid'] = 'El registro no pudo ser insertado en la BD, verifique la información que intenta guardar. Error: '.$db_error['message'];
                    }

                }catch(Exception $e){
                    $resultado = false;
                    $data['msgInvalid'] = 'error: '.$e->getMessage();
                }

                if ($resultado == true){
                    // Autorespuesta
                    //$autores = $this->autoRespuesta($pData['idAltaVenta']);
                    // Redirección
                    redirect($this->router->class."?close");
                }


            }
        }
        // Obteniendo la información
        $info = $this->maltaventa->getByIdForComisiones($id);
        $data = $info;
        $data['mpromotor'] = $this->musuario;

        //verificamos si existe diferencia del asesor(venedor)
        $rowdp = $this->mdiferenciapromotor->getByIdPromotor($info['idPromotor']);
        $data['diferenciaPendiente'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;        

        $data['infoA'] = $this->maltaventa->getByIdForAutorizaciones($id);

        $idProspecto=$this->maltaventa->getCampo('idProspecto',$id);
        $data['nombre']=$this->mprospecto->getCampo('nombre',$idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$idProspecto)." ".$this->mprospecto->getCampo('apellidoM',$idProspecto);
        
            /*consulta para obteener el nombre del frac por id*/
        $idProspecto=$this->maltaventa->getCampo('idProspecto',$id);
        $idFraccionamiento=$this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
        $data['fraccionamiento'] =$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function getDatosModal1(){
        $id = $this->input->post('idAltaVenta', TRUE);
        $pctjeComision = $this->input->post('pctjeComision', TRUE);
        if ($id>0){
            $rowP = $this->maltaventa->getByIdAll($id);

            $idProyecto = (!is_numeric($rowP))?$rowP['idProyecto']:0;
            $idPrototipo = ($idProyecto>0)?$this->mproyecto->getCampo('idPrototipo',$idProyecto):0;
            $data['prototipo'] = ($idPrototipo>0)?$this->mprototipos->getCampo('nombre',$idPrototipo):'';
            $idPromotor = $this->mprospecto->getCampo('idPromotor',$rowP['idProspecto']);
            $rowdp = $this->mdiferenciapromotor->getByIdPromotor($idPromotor);
            $data['pVenta'] = $rowP['precioVenta'] - $rowP['diferenciaEmpresa'];
            $data['diferenciaPendiente'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;
            $data['totalComision1'] = ($rowP['precioVenta'] - $rowP['diferenciaEmpresa']) * $pctjeComision;
            $data['comision1'] = $data['totalComision1'] * 0.9;

            $data['totPagoC1'] = ($data['comision1'] > $data['diferenciaPendiente'])?$data['comision1'] - $data['diferenciaPendiente']:0.00;

            $data['success'] = 1;
            echo json_encode($data);

        }
    }

    public function getComision1(){
        $id = $this->input->post('idAltaVenta', TRUE);
        $pctjeComision = $this->input->post('pctjeComision', TRUE);
        $statusComision = $this->input->post('statusComision', TRUE);
        $ajusteComision = ($statusComision==1)?$pctjeComision:0.02;

        $data = array();
        $data['success'] = 0;
        if ($id>0){

            $rowA = $this->mautorizacion->getByIdAV($id);
            $rowP = $this->maltaventa->getByIdAll($id);
            $rowTC = $this->mcomisionbono->getByIdAV($id);

            $idProspecto = $this->maltaventa->getCampo('idProspecto',$id);
            $idPromotor = ($idProspecto>0)?$this->mprospecto->getCampo('idPromotor',$idProspecto):0;
            $data['comision1'] = (!is_numeric($rowA))?$rowA['primerPagoPromotor']:0.00;
            $data['pVenta'] = (!is_numeric($rowP))?$rowP['precioVenta']:0.00;
            $fechaVenta = (!is_numeric($rowP))?$rowP['fechaVenta']:'';
            $data['mesVenta'] = ($fechaVenta!='')?date('m/Y',strtotime($fechaVenta)):'';
            $cantidadVentas = $this->mcomisionbono->getVentasMes($idPromotor,$fechaVenta);
            $data['cantidadVentas'] = $cantidadVentas;
            $data['pctje'] = pctjeProductividad($cantidadVentas);

            if(!is_numeric($rowA)){// validamos si el % de productividad es mayor a la comision
                /*if($rowA['pctjeComisionTotal'] < $data['pctje']){
                    $data['pctje'] = $data['pctje'] - $rowA['pctjeComisionTotal'];
                    $productividadMayor = true;
                }*/
            }

            $pctje = $data['pctje']/100;
            $diferenciaEmpresa = $this->maltaventa->getCampo('diferenciaEmpresa',$id);
            $diferenciaEmpresa = ($diferenciaEmpresa>0)?$diferenciaEmpresa:0;
            $pVentaReal = $data['pVenta'] - $diferenciaEmpresa;

            $productividad = $pVentaReal * $pctje;
            $existeComision = true;
            if(is_numeric($rowTC)){
                $comision2pctj = $pVentaReal * $ajusteComision;//0.02;
                $existeComision = false;
            }else{
                $comision2pctj = $rowTC['importeComision'];
            }
            $importeComision = $comision2pctj;//(!is_numeric($rowTC))?$comision2pctj:0.00;
            $importeProductividad = $productividad - $importeComision;//($productividadMayor==true)?$productividad:$productividad - $importeComision;
            $data['productividad'] = ($importeProductividad > 0 && $statusComision==0)?$importeProductividad:0.00;
            $idProyecto = (!is_numeric($rowP))?$rowP['idProyecto']:0;
            $idPrototipo = ($idProyecto>0)?$this->mproyecto->getCampo('idPrototipo',$idProyecto):0;
            $data['prototipo'] = ($idPrototipo>0)?$this->mprototipos->getCampo('nombre',$idPrototipo):'';
            if($existeComision){
                $data['comision2'] = (!is_numeric($rowTC))?$rowTC['importeComision'] - $rowA['primerPagoPromotor']:0.00;
            }else{
                $data['comision2'] = $comision2pctj;
            }

            //verificamos si existe diferencia del asesor(venedor)
            $rowdp = $this->mdiferenciapromotor->getByIdPromotor($idPromotor);
            $data['diferenciaPendiente'] = (!is_numeric($rowdp))?abs($rowdp->row()->saldo):0.00;
            $sumaComision2Productividad = $data['productividad'] + $data['comision2'];
            $data['totPagoC2'] = ($sumaComision2Productividad > $data['diferenciaPendiente'])?$sumaComision2Productividad - $data['diferenciaPendiente']:0.00;

            $data['success'] = 1;
        }
        echo json_encode($data);
    }

    public function getInfoVenta() { //obtenenmos los datos de venta (vivienda que ya está validada por gestoría)
        $id = $this->input->post('idProyecto', TRUE);
        if ($id > 0){
            $info = $this->maltaventa->getGestoriaByIdProy($id);
             /*print_r($info); exit();*/
            if (!is_numeric($info)){
                $rowCB = $this->mcomisionbono->getByIdAV($info['id']);
                $rowAut = $this->mautorizacion->getByIdAV($info['id']);
                $comisionTotal = (!is_numeric($rowAut))?$rowAut['pctjeComisionTotal']:0;
                $data['id'] = $info['id'];//id en tabla alta venta
                $idProspecto=$this->maltaventa->getCampo('idProspecto',$info['id']);
                $data['idProyecto'] = $info['idProyecto'];
                $data['nombre']=$info['nombre']." ".$this->mprospecto->getCampo('apellidoP',$idProspecto);
                $idFraccionamiento=$this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
                $data['fraccionamiento']=$this->mfraccionamiento->getCampo('titulo',$idFraccionamiento);
                $idProyecto=$this->maltaventa->getCampo('idProyecto',$info['id']);
                $data['lote']=$this->mproyecto->getCampo('lote',$idProyecto);
                $data['manzana']=$this->mproyecto->getCampo('manzana',$idProyecto);
                $avaluo = $info['avaluo'];
                $data['avaluo'] = precio_format($avaluo);
                $precioVentaOci = $info['precioVentaOci'];
                $data['precioVentaOci'] = precio_format($precioVentaOci);
                $precioVenta = $info['precioVenta'];
                $diferenciaEmpresa = $info['diferenciaEmpresa'];
                $data['precioVenta'] = precio_format($precioVenta);
                $montoFinal = $info['sumaFinal'];
                $data['montoFinal'] = precio_format($montoFinal);

                $diferenciaAsesor = $info['diferenciaAsesor'];
                $data['diferenciaAsesor'] = precio_format($diferenciaAsesor);

                $data['difPropioPeculio'] = ($info['difPropioPeculioTitulacion']>0)?precio_format($info['difPropioPeculioTitulacion']):0.00;//(!is_numeric($rowCB))?precio_format($rowCB['difPropioPeculio']):precio_format($info['precioVentaOci'] - $info['sumaFinal']);
                $data['numeroCredito'] = $info['numeroCredito'];
                $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
                $data['resultado'] = precio_format($resultado);
                $bonoPresupuestoInicial = $info['bonoEquipamiento'];
                $data['bonoPresupuestoInicial'] = precio_format($bonoPresupuestoInicial);
                $saldo = $resultado - $bonoPresupuestoInicial;
                $data['saldo'] = precio_format($saldo);
                $cierre = $montoFinal - $bonoPresupuestoInicial;//$data['bonoPresupuestoInicial'];
                $data['cierre'] = precio_format($cierre);
                $data['nombrePromotor'] = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
                $data['tipoPromotor'] = $this->musuario->getCampo("tipoPromotor",$info['idPromotor']);
                $data['comision'] = ($comisionTotal>0)?$comisionTotal:$this->musuario->getCampo("comision",$info['idPromotor']);
                $importeComision = ($precioVenta - $diferenciaEmpresa) * $data['comision']/100;
                $data['importeComision'] = precio_format($importeComision);
                $netoVenta = $cierre - $importeComision;
                $data['netoVenta'] = precio_format($netoVenta);
                $data['fecha'] = date_format(new DateTime($info['fecha']),'d/m/Y');
                $data['success'] = 1;
            }else{
                $data['success'] = 0;
            }
        }else{
            $data['success'] = 0;
        }
        echo json_encode($data);
    }

    public function ver($id = null)
    {
        //Obtenemos el id del Proyecto a aprtir de id alta venta
        $id = $this->maltaventa->getCampo("idProyecto",$id);
        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';

/*        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;

                }

                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }

                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }

                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }

                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }

                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:

                break;
        }*/

        $data['etapa_alta_venta'] = true;
        $data['etapa_validacion_venta'] = true;
        $data['etapa_gestoria'] = true;
        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
        if ( !is_numeric($comisiones) ) {
            $data['etapa_comisionbono'] = true;
            $data['detalle_comisionbono'] = $comisiones;

        }

        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->maltaventa->getById($id);
        $cValor = "true";
        $this->maltaventa->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function condiciones($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $data['etapa_comisionbono'] = false;

        $info = $this->maltaventa->getByIdAll($id);
        $data = $info;

        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($data['idProyecto']);
        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($comisiones) ) {
            $data['etapa_comisionbono'] = true;
            $data['detalle_comisionbono'] = $comisiones;
        }

        $data['mpromotor'] = $this->musuario;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $data['mprototipo'] = $this->mprototipoxfraccionamiento;

        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";
        // exit();
        $this->idFraccionamiento = $data['detalle_venta']['idFraccionamiento'];
        $this->setLogo();
        $html = $this->load->view('comisiones_bonos/formatopdf_view.php',$data,true);
        /*
        echo $html;
        exit();*/
        $this->mpdf_lib->downloadPDF($html,"condiciones",0,'footer','header',$this->urlLogo);
    }

    public function condicionesFinales($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $data['etapa_comisionbono'] = false;

        $info = $this->maltaventa->getByIdAll($id);
        $data = $info;

        $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($data['idProyecto']);
        $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);
        if ( !is_numeric($comisiones) ) {
            $data['etapa_comisionbono'] = true;
            $data['detalle_comisionbono'] = $comisiones;
        }

        $data['mpromotor'] = $this->musuario;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $data['mprototipo'] = $this->mprototipoxfraccionamiento;

        $this->idFraccionamiento = $data['detalle_venta']['idFraccionamiento'];
        $this->setLogo();
        $html = $this->load->view('comisiones_bonos/condicionesfinales_view.php',$data,true);

        $this->mpdf_lib->downloadPDF($html,"condicionesFinales",0,'footer','header',$this->urlLogo);
    }

    public function autoRespuesta( $idAltaVenta = null ) {

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';

        // $para = $emailCliente; // Comprador

        $subject = 'Notificación de comisión | Comisiones o bonos';

        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$this->maltaventa->getCampo('idProyecto',$idAltaVenta));
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';

        $data = array();

        // $comisionesbonos = $this->mcomisionbono->getById($idComision);
        $alta_venta = $this->maltaventa->getById($idAltaVenta);
        $info = $this->maltaventa->getGestoriaByIdProy($alta_venta['idProyecto']);
        $idProyecto=$this->maltaventa->getCampo('idProyecto',$idAltaVenta);
        $lote=$this->mproyecto->getCampo('lote',$idProyecto);
        $manzana = $this->mproyecto->getCampo('manzana',$idProyecto);
        $idCliente = $this->maltaventa->getCampo('idProspecto',$idAltaVenta);
        $nombre = $this->mprospecto->getCampo('nombre',$idCliente);
        $apellidoP = $this->mprospecto->getCampo('apellidoP',$idCliente);
        $apellidoM = $this->mprospecto->getCampo('apellidoM',$idCliente);
     /*   echo $idProyecto; exit();*/
   /*     $apellidoP =$this->mprospecto->getCampo('apellidoP',$idAltaVenta));
        $clienteM =$this->mprospecto->getCampo('apellidoM',$idAltaVenta));*/


        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
        $montoFinal = $info['sumaFinal'];
        $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
        $bonoPresupuestoInicial = $info['bonoEquipamiento'];
        $saldo = $resultado - $bonoPresupuestoInicial;
        /*variables tercer bloque*/
        $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
        $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
    /*    $importeComision = $cierre * $comision/100;*/
        $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
        $info2 = $this->maltaventa->getByIdForAutorizaciones($idAltaVenta);
        $importeComision = $info2['importeComision'];
        $netoVenta = $info2['netoVenta'];
        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">CUANDO SEA DETONADO</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;">CLIENTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombre." ".$apellidoP.' '.$apellidoM.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> LOTE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$lote.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MANZANA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$manzana.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> VALOR AVALÚO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['avaluo']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA OCI: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVentaOci']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> PRECIO VENTA EMPRESA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVenta']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> MONTO FINAL: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($montoFinal).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> DIF PROPIO PECULIO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($info['precioVentaOci'] - $info['sumaFinal']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NÚMERO DE CRÉDITO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$info['numeroCredito'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                            </tr>
                             <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                            </tr>
                        </tbody>
                    </table>';
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
      /*  $resultado = ($info['precioVenta']<$info['precioVentaOci'])?$info['sumaFinal'] - $info['precioVenta']:$info['sumaFinal'] - $info['precioVentaOci'];
        $bonoPresupuestoInicial = $info['bonoEquipamiento'];
        $saldo = $resultado - $bonoPresupuestoInicial;*/
       /* $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 50px auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">SALDOS</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RESULTADO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format( $resultado ).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> BONO PRESUPUESTO INICIAL: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($bonoPresupuestoInicial).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> SALDO: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($saldo).' </td>
                            </tr>
                        </tbody>
                    </table>';*/
        /*-----------------------------------------------------------------------------------------------------------------------------------------*/
     /*   $cierre = $montoFinal - $bonoPresupuestoInicial;//$info['bonoPresupuestoInicial'];
        $comision = $this->musuario->getCampo("comision",$info['idPromotor']);
        $importeComision = $cierre * $comision/100;
        $nombrePromotor = $this->musuario->getCampo("nombre",$info['idPromotor'])." ".$this->musuario->getCampo("apellidoP",$info['idPromotor']);
        $netoVenta = $cierre - $importeComision;*/
       /* $cuerpo .= '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <thead>
                            <tr>
                                <th colspan="2" style="color: #57ba47;text-transform: uppercase;font-size: 18px;font-weight: bolder;">VALORES FINALES</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> CIERRE: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($cierre).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> TIPO DE PROMOTOR: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$this->musuario->getCampo("tipoPromotor",$info['idPromotor']).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> COMISIÓN: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$comision.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> IMPORTE COMISIÓN: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($importeComision).' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NOMBRE DEL PROMOTOR: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nombrePromotor.' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> NETO DE VENTA: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($netoVenta).' </td>
                            </tr>
                        </tbody>
                    </table>';*/



        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                        <tr>
                            <td>
                                <a href="'.$liga3.'" target="_blank">
                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                        <tr>
                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                <img width="280" src="'.$urlLogoFracc.'" />
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                    <tr>
                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Notificación de comisión </h3>
                                            <!--<h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De  </h4>-->
                                            <br><br>
                                            '.$cuerpo.'
                                        </td>
                                    </tr>
                                </table>
                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                            </td>
                        </tr>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

   /*     echo $mensaje; exit();*/
        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

        // $idGerente = $this->musuario->getCampo('created_by',$info['idPromotor']);
        // $mailGerente = $this->musuario->getCampo('email',$idGerente);
        // $mailGerente = $this->musuario->getCampo('email',$this->musuario->getGerente());
        $mailGerente = $this->musuario->getCampo('email',$this->musuario->getGerente2($idFraccionamiento));
        // $para = "sistemas@viviend.mx";
        $para = $mailGerente;

        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
        if ($para != null){
            //mail($para, $subject, $mensaje, $cabeceras);
        }

        $dGestores = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($idFraccionamiento);
        if ( !is_numeric($dGestores) ) {
            foreach ($dGestores->result() as $row) { 
                mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
            }
        }

        $dContadores = $this->mfraccionamientoxusuario->getContabilidadSelectResultByIdFracc($idFraccionamiento);
        if ( !is_numeric($dContadores) ) {
            foreach ($dContadores->result() as $row) { 
                mail($this->musuario->getCampo('email',$row->id), $subject, $mensaje, $cabeceras);
            }
        }

        $subject2 = $subject;

        // para el gerente  -------------------------------------------------
        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // para el administrador
        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

        return true;
    }

}