<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Comisiones extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'comisiones'; // form validation variable
            $this->mainView = 'comisiones';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/comisiones/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('maltaventa','mprospecto','mproyecto','musuario','mcomisionbono','mfraccionamiento','mfraccionamientoxusuario','mprototipos','mprototipoxfraccionamiento','mgestoria','mautorizacion','mdeposito','mentrega','mareastatus','mdiferenciapromotor', 'mcomisiones', 'mmatrizcomisiones', 'mmovimientospromotor', 'mcomisionesfraccionamientos', 'mlogscomisiones'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/comisiones_bonos/';


            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("contabilidad",$this->fv);

           $this->idFraccionamiento = 0;

           $this->urlLogo = '';
    }

	public function index(){
        $data = $this->updateTabs();
		$data['q'] = '';
        //$data['diferenciaPromotores'] = $this->mdiferenciapromotor->getPendientes();
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado($return = 0){
        $q = $this->maltaventa->todosPendientesComisiones();
        $count = 0;
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                $acciones = '
                <a class="btn blue" href="javascript:void(0);" onclick="modalFirstPago('.$row->id.','.$autorizado.')" style="margin-bottom:10px;">Pago 1</a>';

                $ventasMes = $this->mcomisiones->getVentasMes($row->idPromotor, $row->statusPago);
                $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $row->tipoPromotor);
                $porcentajeComision = (!is_numeric($matrizComisiones)) ? $matrizComisiones['porcentajeVentas'] : 0;
                $alCien = $row->pVenta * ($porcentajeComision / 100);
                $alNoventa = $alCien * (90 / 100);
                $imtosNueve = $alNoventa * (9 / 100);
                $totalPago1 = $alNoventa - $imtosNueve;

                $array['aaData'][] = array(
                    'acciones' => ( in_array($_SESSION[$this->nsession]["rol"], permisos("ventas","comisiones_edit")['r']) ) ? $acciones : '',
                    'porcentajeComision' => $porcentajeComision.'%',
                    'fechaDetonacion' => ($row->statusPago!='0000-00-00' && $row->statusPago!='')?date('d/m/Y',strtotime($row->statusPago)):'',
                    'linea' => $row->tCred,
                    'promotor' => $row->promotor,
                    'cliente' => $row->cliente,
                    'fraccionamiento' => $row->fraccionamiento,
                    'ronda' => $row->ronda,
                    'manzana' => $row->manzana,
                    'lote' => $row->lote,
                    'precioVenta' => precio_format($row->pVenta),
                    '100%' => precio_format($alCien),
                    '90%' => precio_format($alNoventa),
                    'imtos9%' => precio_format($imtosNueve),
                    'diferenciaAsesor' => '',
                    'totalPago1' => precio_format($totalPago1),
                );

                $count++;
            }
        }else{
            $array['aaData'][] = array(
                'acciones' => 'No hay registros',
                'porcentajeComision' => 'No hay registros',
                'fechaDetonacion' => 'No hay registros',
                'linea' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'ronda' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                '100%' => 'No hay registros',
                '90%' => 'No hay registros',
                'imtos9%' => 'No hay registros',
                'diferenciaAsesor' => 'No hay registros',
                'totalPago1' => 'No hay registros',
            );
        }

        if($return == 0){
            echo json_encode($array);
        }else{
            return $count;
        }
    }

    public function listado2($return = 0)
    {
        $q = $this->mcomisiones->getAll();
        $count = 0;
        if(!is_numeric($q)){
            foreach($q->result() as $row){

                $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                $resultComsion = $qComision->result_array();
                $tipoAutorizacion = '';
                $acciones = '';
                $seguir = false;

                if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == false){
                    if(validSesionAdmin(array(4))){
                        $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalFirstPago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Pago 1</a>';
                    }else{
                        $acciones = '';
                    }
                    $tipoAutorizacion = 'Primera Comisión';
                    $seguir = true;
                }else if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == false){
                    if(validSesionAdmin(array(4))){
                        $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalAjustePago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Ajuste</a>';
                    }else{
                        $acciones = '';
                    }
                    $tipoAutorizacion = 'Ajuste';
                    $seguir = true;
                }else if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == false){
                    if(validSesionAdmin(array(4))){
                        $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalSegundPago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Pago 2</a>';
                    }else{
                        $acciones = '';
                    }
                    $tipoAutorizacion = 'Segunda Comisión';
                    $seguir = true;
                }

                if($seguir){
                    $count++;
                    $array['aaData'][] = array(
                        'acciones' => $acciones,
                        'tipoAutorizacion' => $tipoAutorizacion,
                        'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                        'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                        'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                        'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                        'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                        'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                        'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                        'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                        'precioVenta' => precio_format((count($resultComsion) > 0) ? $resultComsion[0]['pVenta'] : 0),
                    );
                }
            }

            if($count == 0){
                $array['aaData'][] = array(
                    'acciones' => 'No hay registros',
                    'tipoAutorizacion' => 'No hay registros',
                    'fechaDetonacion' => 'No hay registros',
                    'linea' => 'No hay registros',
                    'promotor' => 'No hay registros',
                    'cliente' => 'No hay registros',
                    'fraccionamiento' => 'No hay registros',
                    'ronda' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'lote' => 'No hay registros',
                    'precioVenta' => 'No hay registros',
                );
            }
        }else{
            $array['aaData'][] = array(
                'acciones' => 'No hay registros',
                'tipoAutorizacion' => 'No hay registros',
                'fechaDetonacion' => 'No hay registros',
                'linea' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'ronda' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'precioVenta' => 'No hay registros',
            );
        }

        if($return == 0){
            echo json_encode($array);
        }else{
            return $count;
        }
    }

    public function listado3($return = 0)
    {
        $q = $this->mcomisiones->getAll();
        $count = 0;
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                $acciones = '
                <a class="btn blue" href="javascript:void(0);" onclick="modalAjustePago('.$row->idAltaVenta.','.$autorizado.','.$row->id.')" style="margin-bottom:10px;">Ajuste</a>';

                $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                $resultComsion = $qComision->result_array();
                $idProyecto = (count($resultComsion) > 0 && $resultComsion[0]['idProyecto']) ? $resultComsion[0]['idProyecto'] : 0;
                $idFraccionamiento = $this->mproyecto->getCampo2('idFraccionamiento', $idProyecto);
                $idFraccionamiento = ($idFraccionamiento != '') ? $idFraccionamiento : 0;
                $qComisionFija = $this->mcomisionesfraccionamientos->getByIdFraccionamiento2($idFraccionamiento);
                $comisionFija = (!is_numeric($qComisionFija)) ? $qComisionFija->row()->porcentajeComision : 0;
                $idPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['idPromotor'] : 0;
                $tipoPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['tipoPromotor'] : '';
                $seguir = false;

                $ventasMes = $this->mcomisiones->getVentasMes($idPromotor, $row->fechaDetonacion);
                $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $tipoPromotor);
                
                $NuevoporcentajeComision = ($row->tipoComision == 'Matriz') ? $matrizComisiones['porcentajeVentas'] : $comisionFija;
                //$NuevoporcentajeComision = 3;
                if((int)$NuevoporcentajeComision != (int)$row->porcentajeComision && $row->totalAjuste == ''){
                    $seguir = true;
                    $NuevoporcentajeComision = (int)$NuevoporcentajeComision - (int)$row->porcentajeComision;
                    $alCien = $row->precioVenta * ($NuevoporcentajeComision / 100);
                    $alNoventa = $alCien * (90 / 100);
                    $imtosNueve = $alNoventa * (9 / 100);
                    $totalAjuste = $alNoventa - $imtosNueve;
                }

                if($seguir){
                    $count++;
                    $array['aaData'][] = array(
                        'acciones' => ( in_array($_SESSION[$this->nsession]["rol"], permisos("ventas","comisiones_edit")['r']) ) ? $acciones : '',
                        'porcentajeComision' => (int)$row->porcentajeComision.'%',
                        'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                        'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                        'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                        'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                        'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                        'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                        'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                        'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                        'precioVenta' => precio_format($row->precioVenta),
                        '100%' => precio_format($row->comision),
                        '90%' => precio_format($row->pago1),
                        'imtos9%' => precio_format($row->imptoPago1),
                        'totalPago1' => precio_format($row->totalPago1),
                        'porcentajeComisionAjuste' => $NuevoporcentajeComision.'%',
                        'comisionAjuste' => precio_format($alCien),
                        'ajuste' => precio_format($alNoventa),
                        'imptoAjuste' => precio_format($imtosNueve),
                        'totalAjuste' => precio_format($totalAjuste),
                    );
                }
            }
            
            if($count == 0){
                $array['aaData'][] = array(
                    'acciones' => 'No hay registros',
                    'porcentajeComision' => 'No hay registros',
                    'fechaDetonacion' => 'No hay registros',
                    'linea' => 'No hay registros',
                    'promotor' => 'No hay registros',
                    'cliente' => 'No hay registros',
                    'fraccionamiento' => 'No hay registros',
                    'ronda' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'lote' => 'No hay registros',
                    'precioVenta' => 'No hay registros',
                    '100%' => 'No hay registros',
                    '90%' => 'No hay registros',
                    'imtos9%' => 'No hay registros',
                    'totalPago1' => 'No hay registros',
                    'porcentajeComisionAjuste' => 'No hay registros',
                    'comisionAjuste' => 'No hay registros',
                    'ajuste' => 'No hay registros',
                    'imptoAjuste' => 'No hay registros',
                    'totalAjuste' => 'No hay registros',
                );
            }
        }else{
            $array['aaData'][] = array(
                'acciones' => 'No hay registros',
                'porcentajeComision' => 'No hay registros',
                'fechaDetonacion' => 'No hay registros',
                'linea' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'ronda' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                '100%' => 'No hay registros',
                '90%' => 'No hay registros',
                'imtos9%' => 'No hay registros',
                'totalPago1' => 'No hay registros',
                'porcentajeComisionAjuste' => 'No hay registros',
                'comisionAjuste' => 'No hay registros',
                'ajuste' => 'No hay registros',
                'imptoAjuste' => 'No hay registros',
                'totalAjuste' => 'No hay registros',
            );
        }

        if($return == 0){
            echo json_encode($array);
        }else{
            return $count;
        }
    }

    public function listado4($return = 0)
    {
        $q = $this->mcomisiones->getAll();
        $count = 0;
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                $acciones = '
                <a class="btn blue" href="javascript:void(0);" onclick="modalSegundPago('.$row->idAltaVenta.','.$autorizado.','.$row->id.')" style="margin-bottom:10px;">Pago 2</a>';
                $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                $resultComsion = $qComision->result_array();
                $idProyecto = (count($resultComsion) > 0 && $resultComsion[0]['idProyecto']) ? $resultComsion[0]['idProyecto'] : 0;
                $idFraccionamiento = $this->mproyecto->getCampo2('idFraccionamiento', $idProyecto);
                $idFraccionamiento = ($idFraccionamiento != '') ? $idFraccionamiento : 0;
                $qComisionFija = $this->mcomisionesfraccionamientos->getByIdFraccionamiento2($idFraccionamiento);
                $comisionFija = (!is_numeric($qComisionFija)) ? $qComisionFija->row()->porcentajeComision : 0;
                $idPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['idPromotor'] : 0;
                $tipoPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['tipoPromotor'] : '';
                $seguir = false;

                $ventasMes = $this->mcomisiones->getVentasMes($idPromotor, $row->fechaDetonacion);
                $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $tipoPromotor);
                $porcentajeComision = ($row->tipoComision == 'Matriz') ? $matrizComisiones['porcentajeVentas'] : $comisionFija;

                if($row->statusEntrega && $row->totalPago2 == ''){
                    $seguir = true;
                    $statusEntrega = 'Entregado';
                    $alCien = $row->precioVenta * ($porcentajeComision / 100);
                    $alDiez = $alCien * (10 / 100);
                    $imtosNueve = $alDiez * (9 / 100);
                    $totalPago2 = $alDiez - $imtosNueve;
                }

                if($seguir){
                    $count++;
                    $array['aaData'][] = array(
                        'acciones' => ( in_array($_SESSION[$this->nsession]["rol"], permisos("ventas","comisiones_edit")['r']) ) ? $acciones : '',
                        'statusEntrega' => $statusEntrega,
                        'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                        'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                        'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                        'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                        'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                        'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                        'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                        'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                        'precioVenta' => precio_format((count($resultComsion) > 0) ? $resultComsion[0]['pVenta'] : 0),
                        '10%' => precio_format($alDiez),
                        'imtos9%' => precio_format($imtosNueve),
                        'totalPago2' => precio_format($totalPago2),
                    );
                }
            }

            if($count == 0){
                $array['aaData'][] = array(
                    'acciones' => 'No hay registros',
                    'statusEntrega' => 'No hay registros',
                    'fechaDetonacion' => 'No hay registros',
                    'linea' => 'No hay registros',
                    'promotor' => 'No hay registros',
                    'cliente' => 'No hay registros',
                    'fraccionamiento' => 'No hay registros',
                    'ronda' => 'No hay registros',
                    'manzana' => 'No hay registros',
                    'lote' => 'No hay registros',
                    'precioVenta' => 'No hay registros',
                    '10%' => 'No hay registros',
                    'imtos9%' => 'No hay registros',
                    'totalPago2' => 'No hay registros',
                );
            }
        }else{
            $array['aaData'][] = array(
                'acciones' => 'No hay registros',
                'statusEntrega' => 'No hay registros',
                'fechaDetonacion' => 'No hay registros',
                'linea' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'ronda' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                '10%' => 'No hay registros',
                'imtos9%' => 'No hay registros',
                'totalPago2' => 'No hay registros',
            );
        }

        if($return == 0){
            echo json_encode($array);
        }else{
            return $count;
        }
    }

    public function listado5()
    {
        $q = $this->mcomisiones->getAllServerSide();
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                $resultComsion = $qComision->result_array();
                $tipoPromotor = (count($resultComsion) > 0 && $resultComsion[0]['tipoPromotor'] != '') ? $resultComsion[0]['tipoPromotor'] : '';
                $autorizacionPago1 = '';
                $autorizacionAjuste = '';
                $autorizacionPago2 = 'PENDIENTE POR PAGAR';
                $linkReciboPago1 = '';
                $linkReciboPago2 = '';
                $linkReciboAjuste = '';
                $asistioAsesor = '';

                if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == true){
                    $autorizacionPago1 = 'AUTORIZADO';
                    $linkReciboPago1 = '<a href="'.base_url().'formatospdf/reciboPagoComision/'.$row->idAltaVenta.'" target="_blank" rel="noopener noreferrer">
                                            <strong style="font-size:14px;text-decoration: underline;"> RECIBO PAGO 1</strong> 
                                        </a>';
                }else if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == false){
                    $autorizacionPago1 = 'NO AUTORIZADO';
                }

                if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == true){
                    $autorizacionAjuste = 'AUTORIZADO';
                    $linkReciboAjuste = '<a href="'.base_url().'formatospdf/reciboPagoComision3/'.$row->idAltaVenta.'" target="_blank" rel="noopener noreferrer">
                                            <strong style="font-size:14px;text-decoration: underline;"> RECIBO AJUSTE</strong> 
                                        </a>';
                }else if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == false){
                    $autorizacionAjuste = 'NO AUTORIZADO';
                }

                if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == true){
                    $autorizacionPago2 = 'AUTORIZADO';
                    $linkReciboPago2 = '<a href="'.base_url().'formatospdf/reciboPagoComision2/'.$row->idAltaVenta.'" target="_blank" rel="noopener noreferrer">
                                            <strong style="font-size:14px;text-decoration: underline;"> RECIBO PAGO 2</strong> 
                                        </a>';
                }else if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == false){
                    $autorizacionPago2 = 'NO AUTORIZADO';
                }

                if($row->asistioEntregaAsesor != '' && $row->asistioEntregaAsesor == 1){
                    $asistioAsesor = 'ASISTIÓ';
                }else if($row->asistioEntregaAsesor != '' && $row->asistioEntregaAsesor == 0){
                    $asistioAsesor = 'NO ASISTIÓ';
                }

                $alDiez = $row->comision * (10 / 100);
                $imtosNueve = $alDiez * (9 / 100);
                $totalPago2 = $alDiez - $imtosNueve;

                $options = '';

                for ($i=2; $i <= 5; $i++) { 
                    if($i == $row->porcentajeComision){
                        $options .= '<option value="'.$i.'" selected="selected">'.$i.'</option>';
                    }else{
                        $options .= '<option value="'.$i.'">'.$i.'</option>';
                    }
                }

                $editarComision = '<select id="'.$row->id.'" name="'.$row->id.'" class="form-control mgleftcero" onchange="editarComision($(this));">
                                        '.$options.'
                                    </select>';


                $array[] = array(
                    'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                    'linea' => $row->tCred,
                    'promotor' => $row->promotor,
                    'cliente' => $row->cliente,
                    'fraccionamiento' => $row->fraccionamiento,
                    'ronda' => $row->ronda,
                    'manzana' => $row->manzana,
                    'lote' => $row->lote,
                    'precioVenta' => precio_format($row->pVenta),
                    'porcentajeComision' => ($row->tipoComision == 'Matriz' && $tipoPromotor != '' && $tipoPromotor == 'Interno' && validSesionAdmin(array(4)) && $row->comisionAjuste == '' && (($row->totalPago1 != '' && $row->statusAutorizacionPago1 == true) || ($row->totalPago2 != '' && $row->statusAutorizacionPago2 == true))) ?  $editarComision : (int)$row->porcentajeComision.'%',
                    'Comision' => precio_format($row->comision),
                    'Comision_' => $row->comision,
                    'pago1' => precio_format($row->pago1),
                    'pago1_' => $row->pago1,
                    'imptoPago1' => precio_format($row->imptoPago1),
                    'imptoPago1_' => $row->imptoPago1,
                    'diferenciaAsesorPago1' => precio_format($row->diferenciaAsesorPago1),
                    'diferenciaAsesorPago1_' => $row->diferenciaAsesorPago1,
                    'totalPago1' => precio_format($row->totalPago1),
                    'totalPago1_' => $row->totalPago1,
                    'fechaPago1' => ($row->fechaPago1!='0000-00-00' && $row->fechaPago1!='')?date('d/m/Y',strtotime($row->fechaPago1)):'',
                    'formaPago1' => $row->formaPago1,
                    'autorizacionPago1' => $autorizacionPago1,
                    'linkReciboPago1' => $linkReciboPago1,
                    'saldo' => precio_format($row->saldo),
                    'porcentajeComisionAjuste' => ($row->porcentajeComisionAjuste != '') ? (int)$row->porcentajeComisionAjuste.'%' : '',
                    'comisionAjuste' => ($row->comisionAjuste != '') ? precio_format($row->comisionAjuste) : '',
                    'comisionAjuste_' => ($row->comisionAjuste != '') ? $row->comisionAjuste : '',
                    'ajuste' => ($row->ajuste != '') ? precio_format($row->ajuste) : '',
                    'ajuste_' => ($row->ajuste != '') ? $row->ajuste : '',
                    'imptoAjuste' => ($row->imptoAjuste != '') ? precio_format($row->imptoAjuste) : '',
                    'imptoAjuste_' => ($row->imptoAjuste != '') ? $row->imptoAjuste : '',
                    'diferenciaAsesorAjuste' => ($row->diferenciaAsesorAjuste != '') ? precio_format($row->diferenciaAsesorAjuste) : '',
                    'diferenciaAsesorAjuste_' => ($row->diferenciaAsesorAjuste != '') ? $row->diferenciaAsesorAjuste : '',
                    'totalAjuste' => ($row->totalAjuste != '') ? precio_format($row->totalAjuste) : '',
                    'totalAjuste_' => ($row->totalAjuste != '') ? $row->totalAjuste : '',
                    'formaPagoAjuste' => $row->formaPagoAjuste,
                    'autorizacionAjuste' => $autorizacionAjuste,
                    'linkReciboAjuste' => $linkReciboAjuste,
                    'saldoAjuste' => ($row->saldoAjuste != '') ? precio_format($row->saldoAjuste) : '',
                    'pago2' => ($row->pago2 != '') ? precio_format($row->pago2) : precio_format($alDiez),
                    'pago2_' => ($row->pago2 != '') ? $row->pago2 : $alDiez,
                    'imptoPago2' => ($row->imptoPago2 != '') ? precio_format($row->imptoPago2) : precio_format($imtosNueve),
                    'imptoPago2_' => ($row->imptoPago2 != '') ? $row->imptoPago2 : $imtosNueve,
                    'diferenciaAsesorPago2' => ($row->diferenciaAsesorPago2 != '') ? precio_format($row->diferenciaAsesorPago2) : '',
                    'diferenciaAsesorPago2_' => ($row->diferenciaAsesorPago2 != '') ? $row->diferenciaAsesorPago2 : '',
                    'totalPago2' => ($row->totalPago2 != '') ? precio_format($row->totalPago2) : precio_format($totalPago2),
                    'totalPago2_' => ($row->totalPago2 != '') ? $row->totalPago2 : $totalPago2,
                    'fechaPago2' => ($row->fechaPago2!='0000-00-00' && $row->fechaPago2!='')?date('d/m/Y',strtotime($row->fechaPago2)):'',
                    'formaPago2' => $row->formaPago2,
                    'asistioEntregaAsesor' => $asistioAsesor,
                    'autorizacionPago2' => $autorizacionPago2,
                    'linkReciboPago2' => $linkReciboPago2,
                );

            }
        }else{
            $array[] = array(
                'fechaDetonacion' => 'No hay registros',
                'linea' => 'No hay registros',
                'promotor' => 'No hay registros',
                'cliente' => 'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'ronda' => 'No hay registros',
                'manzana' => 'No hay registros',
                'lote' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'porcentajeComision' => 'No hay registros',
                'Comision' => 'No hay registros',
                'Comision_' => 'No hay registros',
                'pago1' => 'No hay registros',
                'pago1_' => 'No hay registros',
                'imptoPago1' => 'No hay registros',
                'imptoPago1_' => 'No hay registros',
                'diferenciaAsesorPago1' => 'No hay registros',
                'diferenciaAsesorPago1_' => 'No hay registros',
                'totalPago1' => 'No hay registros',
                'totalPago1_' => 'No hay registros',
                'fechaPago1' => 'No hay registros',
                'formaPago1' => 'No hay registros',
                'autorizacionPago1' => 'No hay registros',
                'linkReciboPago1' => 'No hay registros',
                'saldo' => 'No hay registros',
                'porcentajeComisionAjuste' => 'No hay registros',
                'comisionAjuste' => 'No hay registros',
                'comisionAjuste_' => 'No hay registros',
                'ajuste' => 'No hay registros',
                'ajuste_' => 'No hay registros',
                'imptoAjuste' => 'No hay registros',
                'imptoAjuste_' => 'No hay registros',
                'diferenciaAsesorAjuste' => 'No hay registros',
                'diferenciaAsesorAjuste_' => 'No hay registros',
                'totalAjuste' => 'No hay registros',
                'totalAjuste_' => 'No hay registros',
                'formaPagoAjuste' => 'No hay registros',
                'autorizacionAjuste' => 'No hay registros',
                'linkReciboAjuste' => 'No hay registros',
                'saldoAjuste' => 'No hay registros',
                'pago2' => 'No hay registros',
                'pago2_' => 'No hay registros',
                'imptoPago2' => 'No hay registros',
                'imptoPago2_' => 'No hay registros',
                'diferenciaAsesorPago2' => 'No hay registros',
                'diferenciaAsesorPago2_' => 'No hay registros',
                'totalPago2' => 'No hay registros',
                'totalPago2_' => 'No hay registros',
                'fechaPago2' => 'No hay registros',
                'formaPago2' => 'No hay registros',
                'asistioEntregaAsesor' => 'No hay registros',
                'autorizacionPago2' => 'No hay registros',
                'linkReciboPago2' => 'No hay registros',
            );
        }

        $total_ = (!is_numeric($this->mcomisiones->getAllServerSide())) ? $this->mcomisiones->getAllServerSide()->num_rows() : 0;

        $output = array(
                            "draw" => $_POST['draw'],
                            "recordsTotal" => $total_,
                            "recordsFiltered" => $total_,
                            "data" => $array,
                    );

        echo json_encode($output);
    }

    public function listado6($return = 0)
    {
        $q = $this->mmovimientospromotor->getPendientes();
        $count = 0;
        if(!is_numeric($q)){
            foreach($q->result() as $row){
                $seguir = false;

                if($row->saldo > 0){
                    $seguir = true;
                }

                if($seguir){
                    $count++;
                    $array['aaData'][] = array(
                        'promotor' => $row->promotor,
                        'tipo' => $row->tipo,
                        'saldo' => precio_format($row->saldo),
                    );
                }
            }

            if($count == 0){
                $array['aaData'][] = array(
                    'promotor' => 'No hay registros',
                    'tipo' => 'No hay registros',
                    'saldo' => 'No hay registros',
                );
            }
        }else{
            $array['aaData'][] = array(
                'promotor' => 'No hay registros',
                'tipo' => 'No hay registros',
                'saldo' => 'No hay registros',
            );
        }

        if($return == 0){
            echo json_encode($array);
        }else{
            return $count;
        }
    }

    public function modalFirstPago()
    {
        $array['status'] = 0;
        $idAltaVenta = $this->input->post('idAltaVenta',TRUE);
        $autorizar = $this->input->post('autorizar',TRUE);
        $idComision = $this->input->post('idComision',TRUE);
        $data['autorizar'] = $autorizar;
        $data['idComision'] = $idComision;
        $comisionesPendiente = ($autorizar && $idComision != null) ?  $this->mcomisiones->getComisionesInsert($idAltaVenta) : $this->maltaventa->todosPendientesComisiones($idAltaVenta);
        if(!is_numeric($comisionesPendiente)){
            $ingresos = $this->mmovimientospromotor->getSumIngresos($comisionesPendiente->row()->idPromotor);
            $egresos = $this->mmovimientospromotor->getSumEgresos($comisionesPendiente->row()->idPromotor);
            $saldo = $ingresos - $egresos;
            $data['diferencia'] = ($autorizar && $idComision != null && $saldo > 0) ? $this->mcomisiones->getCampo('diferenciaAsesorPago1', $idComision) : 0;
            $data['saldo'] = ($data['diferencia'] > 0) ? $data['diferencia'] : $ingresos - $egresos;
            $data['formaPago1'] = ($autorizar && $idComision != null) ? $this->mcomisiones->getCampo('formaPago1', $idComision) : '';
            $array['status'] = 1;
            $data['comisiones'] = $comisionesPendiente;
            $idProyecto = ($comisionesPendiente->row()->idProyecto != '') ? $comisionesPendiente->row()->idProyecto : 0;
            $idFraccionamiento = $this->mproyecto->getCampo2('idFraccionamiento', $idProyecto);
            $idFraccionamiento = ($idFraccionamiento != '') ? $idFraccionamiento : 0;
            $data['comisionFija'] = $this->mcomisionesfraccionamientos->getByIdFraccionamiento2($idFraccionamiento);
            $data['checkTipoComision'] = ($autorizar && $idComision != null) ? $this->mcomisiones->getCampo('tipoComision', $idComision) : 'Fija';
            $modal = $this->load->view($this->mainView.'/firstpago_view',$data,true);
            $array['idModal'] = 'modalFirstPago_'.$idAltaVenta;
            $array['modal'] = $modal;
        }

        echo json_encode($array);
    }

    public function saveFirstPagoComision()
    {
        $array['status'] = 0;
        $array['link'] = '';
        $infoFirstPagoComision = $this->input->post('info',TRUE);
        $pData = json_decode($infoFirstPagoComision, true);
        $autorizar = $pData['autorizar'];
        $idComision = $pData['idComision'];
        $idPromotor = $pData['idPromotor'];
        unset($pData['autorizar']);
        unset($pData['idComision']);
        unset($pData['idPromotor']);
        unset($pData['aplicarDiferencia']);
        //unset($pData['comision']);
        if($autorizar){
            $fechaPago1 =  str_replace('/', '-', $pData['fechaPago1']);
            $pData['fechaPago1'] = date('Y-m-d', strtotime($fechaPago1));

            if(isset($pData['diferenciaAsesor']) && $pData['diferenciaAsesor'] > 0){
                $dData['idAltaVenta'] = $pData['idAltaVenta'];
                $dData['idPromotor'] = $idPromotor;
                $dData['cargo'] = $pData['diferenciaAsesor'];
                $dData['tipo'] = 'Egresos';
                $this->mmovimientospromotor->insertar($dData);
            }

            $array['link'] = base_url().'formatospdf/reciboPagoComision/'.$pData['idAltaVenta'];
        }
        if(isset($pData['diferenciaAsesor'])){
            $pData['diferenciaAsesorPago1'] = $pData['diferenciaAsesor'];
            unset($pData['diferenciaAsesor']);
        }
        $pData['saldo'] = number_format((float)$pData['comision'] - (float)$pData['pago1'], 2, '.', '');
        if($idComision == null){
            $idComision = $this->mcomisiones->insertar($pData);

            if(is_numeric($idComision)){
                $array['status'] = 1;
            }
        }else{
            $idComision = $this->mcomisiones->actualizar($pData, $idComision);
            if($idComision){
                $array['status'] = 1;
            }
        }
        sleep(2);
        echo json_encode($array);
    }

    public function modalAjustePago()
    {
        $array['status'] = 0;
        $idAltaVenta = $this->input->post('idAltaVenta',TRUE);
        $autorizar = $this->input->post('autorizar',TRUE);
        $idComision = $this->input->post('idComision',TRUE);
        $data['autorizar'] = $autorizar;
        $data['idComision'] = $idComision;
        $comisionesPendiente = $this->mcomisiones->getComisionesInsert($idAltaVenta);
        $comision = $this->mcomisiones->getById($idComision);
        if(!is_numeric($comisionesPendiente) && !is_numeric($comision)){
            $ingresos = $this->mmovimientospromotor->getSumIngresos($comisionesPendiente->row()->idPromotor);
            $egresos = $this->mmovimientospromotor->getSumEgresos($comisionesPendiente->row()->idPromotor);
            $saldo = $ingresos - $egresos;
            $data['diferencia'] = ($autorizar && $saldo > 0) ? $this->mcomisiones->getCampo('diferenciaAsesorAjuste', $idComision) : 0;
            $data['saldo'] = ($data['diferencia'] > 0) ? $data['diferencia'] : $ingresos - $egresos;
            $data['formaPagoAjuste'] = ($autorizar) ? $this->mcomisiones->getCampo('formaPagoAjuste', $idComision) : '';
            $array['status'] = 1;
            $data['comisiones'] = $comisionesPendiente;
            $data['comision'] = $comision;
            $modal = $this->load->view($this->mainView.'/ajustepago_view',$data,true);
            $array['idModal'] = 'modalAjustePago_'.$idAltaVenta;
            $array['modal'] = $modal;
        }

        echo json_encode($array);
    }

    public function modalSegundPago()
    {
        $array['status'] = 0;
        $idAltaVenta = $this->input->post('idAltaVenta',TRUE);
        $autorizar = $this->input->post('autorizar',TRUE);
        $idComision = $this->input->post('idComision',TRUE);
        $data['autorizar'] = $autorizar;
        $data['idComision'] = $idComision;
        $comisionesPendiente = $this->mcomisiones->getComisionesInsert($idAltaVenta);
        $comision = $this->mcomisiones->getById($idComision);
        if(!is_numeric($comisionesPendiente) && !is_numeric($comision)){
            $ingresos = $this->mmovimientospromotor->getSumIngresos($comisionesPendiente->row()->idPromotor);
            $egresos = $this->mmovimientospromotor->getSumEgresos($comisionesPendiente->row()->idPromotor);
            $saldo = $ingresos - $egresos;
            $data['diferencia'] = ($autorizar && $saldo > 0) ? $this->mcomisiones->getCampo('diferenciaAsesorPago2', $idComision) : 0;
            $data['saldo'] = ($data['diferencia'] > 0) ? $data['diferencia'] : $ingresos - $egresos;
            $data['formaPago2'] = ($autorizar) ? $this->mcomisiones->getCampo('formaPago2', $idComision) : '';
            $array['status'] = 1;
            $data['comisiones'] = $comisionesPendiente;
            $data['comision'] = $comision;
            $checkAsistioAsesor = ($this->mcomisiones->getCampo('asistioEntregaAsesor', $idComision) != '') ? $this->mcomisiones->getCampo('asistioEntregaAsesor', $idComision) : 1;
            $data['checkAsistioAsesor'] = ($autorizar) ? $checkAsistioAsesor : 1;
            $modal = $this->load->view($this->mainView.'/segundpago_view',$data,true);
            $array['idModal'] = 'modalSegundPago_'.$idAltaVenta;
            $array['modal'] = $modal;
        }

        echo json_encode($array);
    }

    public function saveAjustePagoComision()
    {
        $array['status'] = 0;
        $array['link'] = '';
        $infoAjustePagoComision = $this->input->post('info',TRUE);
        $pData = json_decode($infoAjustePagoComision, true);
        $idAltaVenta = $pData['idAltaVenta'];
        $idPromotor = $pData['idPromotor'];
        $autorizar = $pData['autorizar'];
        $idComision = $pData['idComision'];
        unset($pData['autorizar']);
        unset($pData['idComision']);
        unset($pData['idAltaVenta']);
        unset($pData['idPromotor']);
        unset($pData['porcentajeComision']);
        unset($pData['aplicarDiferencia']);
        if($autorizar){
            $fechaAjuste =  str_replace('/', '-', $pData['fechaAjuste']);
            $pData['fechaAjuste'] = date('Y-m-d', strtotime($fechaAjuste));

            if(isset($pData['diferenciaAsesor']) && $pData['diferenciaAsesor'] > 0){
                $dData['idAltaVenta'] = $idAltaVenta;
                $dData['idPromotor'] = $idPromotor;
                $dData['cargo'] = $pData['diferenciaAsesor'];
                $dData['tipo'] = 'Egresos';
                $this->mmovimientospromotor->insertar($dData);
            }

            $array['link'] = base_url().'formatospdf/reciboPagoComision3/'.$idAltaVenta;
        }
        if(isset($pData['diferenciaAsesor'])){
            $pData['diferenciaAsesorAjuste'] = $pData['diferenciaAsesor'];
            unset($pData['diferenciaAsesor']);
        }
        $pData['saldoAjuste'] = number_format((float)$pData['comisionAjuste'] - (float)$pData['ajuste'], 2, '.', '');
        if($idComision != null && $idComision != ''){
            $idComision = $this->mcomisiones->actualizar($pData, $idComision);
            if($idComision){
                $array['status'] = 1;
            }
        }

        sleep(2);
        echo json_encode($array);
    }

    public function saveSegundPagoComision()
    {
        $array['status'] = 0;
        $array['link'] = '';
        $infoSegundPagoComision = $this->input->post('info',TRUE);
        $pData = json_decode($infoSegundPagoComision, true);
        $idAltaVenta = $pData['idAltaVenta'];
        $idPromotor = $pData['idPromotor'];
        $autorizar = $pData['autorizar'];
        $idComision = $pData['idComision'];
        unset($pData['autorizar']);
        unset($pData['idComision']);
        unset($pData['idAltaVenta']);
        unset($pData['idPromotor']);
        unset($pData['porcentajeComision']);
        unset($pData['comision']);
        unset($pData['aplicarDiferencia']);

        if($autorizar){
            $fechaPago2 =  str_replace('/', '-', $pData['fechaPago2']);
            $pData['fechaPago2'] = date('Y-m-d', strtotime($fechaPago2));

            if(isset($pData['diferenciaAsesor']) && $pData['diferenciaAsesor'] > 0){
                $dData['idAltaVenta'] = $idAltaVenta;
                $dData['idPromotor'] = $idPromotor;
                $dData['cargo'] = $pData['diferenciaAsesor'];
                $dData['tipo'] = 'Egresos';
                $this->mmovimientospromotor->insertar($dData);
            }

            $array['link'] = base_url().'formatospdf/reciboPagoComision2/'.$idAltaVenta;
        }

        if(isset($pData['diferenciaAsesor'])){
            $pData['diferenciaAsesorPago2'] = $pData['diferenciaAsesor'];
            unset($pData['diferenciaAsesor']);
        }

        if($idComision != null && $idComision != ''){
            $idComision = $this->mcomisiones->actualizar($pData, $idComision);
            if($idComision){
                $array['status'] = 1;
            }
        }

        sleep(2);
        echo json_encode($array);
    }

    public function excel($tipo)
    {
        $array = array();
        switch ($tipo) {
            case 1:
                $columnas = array(
                    0 => '% COMISION',
                    1 => 'FECHA DETONACION',
                    2 => 'LINEA',
                    3 => 'PROMOTOR',
                    4 => 'CLIENTE',
                    5 => 'FRACCIONAMIENTO',
                    6 => 'RONDA',
                    7 => 'MANZANA',
                    8 => 'LOTE',
                    9 => 'PRECIO VENTA',
                    10 => 'AL 100%',
                    11 => 'AL 90%',
                    12 => 'IMPTOS AL 9%',
                    13 => 'TOTAL PAGO 1',
                );
                $nombre = '_pendientes';
                $q = $this->maltaventa->todosPendientesComisiones();
                if(!is_numeric($q)){
                    $i = 0;
                    foreach($q->result() as $row){
                        $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                        $acciones = '
                        <a class="btn blue" href="javascript:void(0);" onclick="modalFirstPago('.$row->id.','.$autorizado.')" style="margin-bottom:10px;">Pago 1</a>';
        
                        $ventasMes = $this->mcomisiones->getVentasMes($row->idPromotor, $row->statusPago);
                        $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $row->tipoPromotor);
                        $porcentajeComision = (!is_numeric($matrizComisiones)) ? $matrizComisiones['porcentajeVentas'] : 0;
                        $alCien = $row->pVenta * ($porcentajeComision / 100);
                        $alNoventa = $alCien * (90 / 100);
                        $imtosNueve = $alNoventa * (9 / 100);
                        $totalPago1 = $alNoventa - $imtosNueve;
        
                        $array[$i] = array(
                            'porcentajeComision' => $porcentajeComision.'%',
                            'fechaDetonacion' => ($row->statusPago!='0000-00-00' && $row->statusPago!='')?date('d/m/Y',strtotime($row->statusPago)):'',
                            'linea' => $row->tCred,
                            'promotor' => $row->promotor,
                            'cliente' => $row->cliente,
                            'fraccionamiento' => $row->fraccionamiento,
                            'ronda' => $row->ronda,
                            'manzana' => $row->manzana,
                            'lote' => $row->lote,
                            'precioVenta' => precio_format($row->pVenta),
                            '100%' => precio_format($alCien),
                            '90%' => precio_format($alNoventa),
                            'imtos9%' => precio_format($imtosNueve),
                            'totalPago1' => precio_format($totalPago1),
                        );

                        $i++;
                    }
                }
                break;
            case 2:
                $columnas = array(
                    0 => 'TIPO AUTORIZACION',
                    1 => 'FECHA DETONACION',
                    2 => 'LINEA',
                    3 => 'PROMOTOR',
                    4 => 'CLIENTE',
                    5 => 'FRACCIONAMIENTO',
                    6 => 'RONDA',
                    7 => 'MANZANA',
                    8 => 'LOTE',
                    9 => 'PRECIO VENTA',
                );
                $nombre = '_autorizar';
                $q = $this->mcomisiones->getAll();
                if(!is_numeric($q)){
                    $i=0;
                    foreach($q->result() as $row){
                        $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                        $resultComsion = $qComision->result_array();
                        $tipoAutorizacion = '';
                        $acciones = '';
                        $seguir = false;
        
                        if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == false){
                            if(validSesionAdmin(array(4))){
                                $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalFirstPago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Pago 1</a>';
                            }else{
                                $acciones = '';
                            }
                            $tipoAutorizacion = 'Primera Comisión';
                            $seguir = true;
                        }else if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == false){
                            if(validSesionAdmin(array(4))){
                                $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalAjustePago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Ajuste</a>';
                            }else{
                                $acciones = '';
                            }
                            $tipoAutorizacion = 'Ajuste';
                            $seguir = true;
                        }else if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == false){
                            if(validSesionAdmin(array(4))){
                                $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalSegundPago('.$row->idAltaVenta.',1,'.$row->id.')" style="margin-bottom:10px;">Autorizar Pago 2</a>';
                            }else{
                                $acciones = '';
                            }
                            $tipoAutorizacion = 'Segunda Comisión';
                            $seguir = true;
                        }
        
                        if($seguir){
                            $array[$i] = array(
                                'tipoAutorizacion' => $tipoAutorizacion,
                                'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                                'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                                'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                                'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                                'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                                'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                                'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                                'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                                'precioVenta' => precio_format((count($resultComsion) > 0) ? $resultComsion[0]['pVenta'] : 0),
                            );

                            $i++;
                        }
                    }
                }
                break;
            case 3:
                $columnas = array(
                    0 => '% COMISION',
                    1 => 'FECHA DETONACION',
                    2 => 'LINEA',
                    3 => 'PROMOTOR',
                    4 => 'CLIENTE',
                    5 => 'FRACCIONAMIENTO',
                    6 => 'RONDA',
                    7 => 'MANZANA',
                    8 => 'LOTE',
                    9 => 'PRECIO VENTA',
                    10 => 'AL 100%',
                    11 => 'AL 90%',
                    12 => 'IMPTOS AL 9%',
                    13 => 'TOTAL PAGO 1',
                    14 => '% COMISION AJUSTE',
                    15 => 'COMISION AJUSTE',
                    16 => 'AJUSTE',
                    17 => 'IMPTOS AJUSTE',
                    18 => 'TOTAL AJUSTE',
                );
                $nombre = '_ajuste';
                $q = $this->mcomisiones->getAll();
                if(!is_numeric($q)){
                    $i=0;
                    foreach($q->result() as $row){
                        $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                        $acciones = '
                        <a class="btn blue" href="javascript:void(0);" onclick="modalAjustePago('.$row->idAltaVenta.','.$autorizado.','.$row->id.')" style="margin-bottom:10px;">Ajuste</a>';
        
                        $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                        $resultComsion = $qComision->result_array();
                        $idPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['idPromotor'] : 0;
                        $tipoPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['tipoPromotor'] : '';
                        $seguir = false;
        
                        $ventasMes = $this->mcomisiones->getVentasMes($idPromotor, $row->fechaDetonacion);
                        $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $tipoPromotor);
                        $NuevoporcentajeComision = $matrizComisiones['porcentajeVentas'];
                        //$NuevoporcentajeComision = 3;
                        if((int)$NuevoporcentajeComision != (int)$row->porcentajeComision && $row->totalAjuste == ''){
                            $seguir = true;
                            $NuevoporcentajeComision = (int)$NuevoporcentajeComision - (int)$row->porcentajeComision;
                            $alCien = $row->precioVenta * ($NuevoporcentajeComision / 100);
                            $alNoventa = $alCien * (90 / 100);
                            $imtosNueve = $alNoventa * (9 / 100);
                            $totalAjuste = $alNoventa - $imtosNueve;
                        }
        
                        if($seguir){
                            $array[$i] = array(
                                'porcentajeComision' => (int)$row->porcentajeComision.'%',
                                'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                                'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                                'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                                'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                                'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                                'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                                'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                                'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                                'precioVenta' => precio_format($row->precioVenta),
                                '100%' => precio_format($row->comision),
                                '90%' => precio_format($row->pago1),
                                'imtos9%' => precio_format($row->imptoPago1),
                                'totalPago1' => precio_format($row->totalPago1),
                                'porcentajeComisionAjuste' => $NuevoporcentajeComision.'%',
                                'comisionAjuste' => precio_format($alCien),
                                'ajuste' => precio_format($alNoventa),
                                'imptoAjuste' => precio_format($imtosNueve),
                                'totalAjuste' => precio_format($totalAjuste),
                            );

                            $i++;
                        }
                    }
                }
                break;
            case 4:
                $columnas = array(
                    0 => 'ESTATUS ENTREGA',
                    1 => 'FECHA DETONACION',
                    2 => 'LINEA',
                    3 => 'PROMOTOR',
                    4 => 'CLIENTE',
                    5 => 'FRACCIONAMIENTO',
                    6 => 'RONDA',
                    7 => 'MANZANA',
                    8 => 'LOTE',
                    9 => 'PRECIO VENTA',
                    10 => 'AL 10%',
                    11 => 'IMPTOS AL 9%',
                    12 => 'TOTAL PAGO 2',
                );
                $nombre = '_entrega';
                $q = $this->mcomisiones->getAll();
                if(!is_numeric($q)){
                    $i=0;
                    foreach($q->result() as $row){
                        $autorizado = (validSesionAdmin(array(4))) ? 1 : 0;
                        $acciones = '
                        <a class="btn blue" href="javascript:void(0);" onclick="modalSegundPago('.$row->idAltaVenta.','.$autorizado.','.$row->id.')" style="margin-bottom:10px;">Pago 2</a>';
                        $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                        $resultComsion = $qComision->result_array();
                        $idPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['idPromotor'] : 0;
                        $tipoPromotor = (count($resultComsion) > 0) ? $resultComsion[0]['tipoPromotor'] : '';
                        $seguir = false;
        
                        $ventasMes = $this->mcomisiones->getVentasMes($idPromotor, $row->fechaDetonacion);
                        $matrizComisiones = $this->mmatrizcomisiones->getByVentasTipoPromotor($ventasMes, $tipoPromotor);
                        $porcentajeComision = $matrizComisiones['porcentajeVentas'];
        
                        if($row->statusEntrega && $row->totalPago2 == ''){
                            $seguir = true;
                            $statusEntrega = 'Entregado';
                            $alCien = $row->precioVenta * ($porcentajeComision / 100);
                            $alDiez = $alCien * (10 / 100);
                            $imtosNueve = $alDiez * (9 / 100);
                            $totalPago2 = $alDiez - $imtosNueve;
                        }
        
                        if($seguir){
                            $array[$i] = array(
                                'statusEntrega' => $statusEntrega,
                                'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                                'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                                'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                                'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                                'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                                'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                                'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                                'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                                'precioVenta' => precio_format((count($resultComsion) > 0) ? $resultComsion[0]['pVenta'] : 0),
                                '10%' => precio_format($alDiez),
                                'imtos9%' => precio_format($imtosNueve),
                                'totalPago2' => precio_format($totalPago2),
                            );

                            $i++;
                        }
                    }
                }
                break;
            case 5:
                $columnas = array(
                    0 => 'FECHA DETONACION',
                    1 => 'LINEA',
                    2 => 'PROMOTOR',
                    3 => 'CLIENTE',
                    4 => 'FRACCIONAMIENTO',
                    5 => 'RONDA',
                    6 => 'MANZANA',
                    7 => 'LOTE',
                    8 => 'PRECIO VENTA',
                    9 => '% COMISION',
                    10 => 'AL 100%',
                    11 => 'AL 90%',
                    12 => 'IMPTOS AL 9%',
                    13 => 'DIF. ASESOR PAGO 1',
                    14 => 'TOTAL PAGO 1',
                    15 => 'FECHA PAGO 1',
                    16 => 'FORMA PAGO 1',
                    17 => 'ESTATUS AUTORIZACION PAGO 1',
                    18 => '% COMISION AJUSTE',
                    19 => 'AJUSTE 100%',
                    20 => 'AJUSTE 90%',
                    21 => 'IMPTOS AL 9%',
                    22 => 'DIF. ASESOR AJUSTE',
                    23 => 'TOTAL PAGO AJUSTE',
                    24 => 'FORMA PAGO AJUSTE',
                    25 => 'ESTATUS AUTORIZACION AJUSTE',
                    26 => 'AL 10%',
                    27 => 'IMPTOS 9%',
                    28 => 'DIF. ASESOR PAGO 2',
                    29 => 'TOTAL PAGO 2',
                    30 => 'FECHA PAGO 2',
                    31 => 'FORMA PAGO 2',
                    32 => 'ASISTIO ENTREGA ASESOR',
                    33 => 'ESTATUS AUTORIZACION PAGO 2',
                );
                $nombre = '_inventario';

                $q = $this->mcomisiones->getAll();
                if(!is_numeric($q)){
                    $i = 0;
                    $total_comision = 0;
                    $total_pago1 = 0;
                    $total_imptoPago1 = 0;
                    $total_diferenciaAsesorPago1 = 0;
                    $total_totalPago1 = 0;
                    $total_comisionAjuste = 0;
                    $total_ajuste = 0;
                    $total_imptoAjuste = 0;
                    $total_diferenciaAsesorAjuste = 0;
                    $total_totalAjuste = 0;
                    $total_pago2 = 0;
                    $total_imptoPago2 = 0;
                    $total_diferenciaAsesorPago2 = 0;
                    $total_totalPago2 = 0;
                    foreach($q->result() as $row){
                        $qComision = $this->mcomisiones->getComisionesInsert($row->idAltaVenta);
                        $resultComsion = $qComision->result_array();
                        $autorizacionPago1 = '';
                        $autorizacionAjuste = '';
                        $autorizacionPago2 = 'PENDIENTE POR PAGAR';
                        $linkReciboPago1 = '';
                        $linkReciboPago2 = '';
                        $asistioAsesor = '';
        
                        if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == true){
                            $autorizacionPago1 = 'AUTORIZADO';
                            $linkReciboPago1 = '<a href="'.base_url().'formatospdf/reciboPagoComision/'.$row->idAltaVenta.'" target="_blank" rel="noopener noreferrer">
                                                    <strong style="font-size:14px;text-decoration: underline;"> RECIBO PAGO 1</strong> 
                                                </a>';
                        }else if($row->statusAutorizacionPago1 != '' && $row->statusAutorizacionPago1 == false){
                            $autorizacionPago1 = 'NO AUTORIZADO';
                        }
        
                        if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == true){
                            $autorizacionAjuste = 'AUTORIZADO';
                        }else if($row->statusAutorizacionAjuste != '' && $row->statusAutorizacionAjuste == false){
                            $autorizacionAjuste = 'NO AUTORIZADO';
                        }
        
                        if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == true){
                            $autorizacionPago2 = 'AUTORIZADO';
                            $linkReciboPago2 = '<a href="'.base_url().'formatospdf/reciboPagoComision2/'.$row->idAltaVenta.'" target="_blank" rel="noopener noreferrer">
                                                    <strong style="font-size:14px;text-decoration: underline;"> RECIBO PAGO 2</strong> 
                                                </a>';
                        }else if($row->statusAutorizacionPago2 != '' && $row->statusAutorizacionPago2 == false){
                            $autorizacionPago2 = 'NO AUTORIZADO';
                        }

                        if($row->asistioEntregaAsesor != '' && $row->asistioEntregaAsesor == 1){
                            $asistioAsesor = 'ASISTIO';
                        }else if($row->asistioEntregaAsesor != '' && $row->asistioEntregaAsesor == 0){
                            $asistioAsesor = 'NO ASISTIO';
                        }

                        $alDiez = $row->comision * (10 / 100);
                        $imtosNueve = $alDiez * (9 / 100);
                        $totalPago2 = $alDiez - $imtosNueve;
        

                        $total_comision += ($row->comision != '') ? (float)$row->comision : 0;
                        $total_pago1 += ($row->pago1 != '') ? (float)$row->pago1 : 0;
                        $total_imptoPago1 += ($row->imptoPago1 != '') ? (float)$row->imptoPago1 : 0;
                        $total_diferenciaAsesorPago1 += ($row->diferenciaAsesorPago1 != '') ? (float)$row->diferenciaAsesorPago1 : 0;
                        $total_totalPago1 += ($row->totalPago1 != '') ? (float)$row->totalPago1 : 0;
                        $total_comisionAjuste +=  ($row->comisionAjuste != '') ? (float)$row->comisionAjuste : 0;
                        $total_ajuste += ($row->ajuste != '') ? (float)$row->ajuste : 0;
                        $total_imptoAjuste += ($row->imptoAjuste != '') ? (float)$row->imptoAjuste : 0;
                        $total_diferenciaAsesorAjuste += ($row->diferenciaAsesorAjuste != '') ? (float)$row->diferenciaAsesorAjuste : 0;
                        $total_totalAjuste += ($row->totalAjuste != '') ? (float)$row->totalAjuste : 0;
                        $total_pago2 += ($row->pago2 != '') ? (float)$row->pago2 : (float)$alDiez;
                        $total_imptoPago2 += ($row->imptoPago2 != '') ? (float)$row->imptoPago2 : (float)$imtosNueve;
                        $total_diferenciaAsesorPago2 += ($row->diferenciaAsesorPago2 != '') ? (float)$row->diferenciaAsesorPago2 : 0;
                        $total_totalPago2 += ($row->totalPago2 != '') ? (float)$row->totalPago2 : (float)$totalPago2;
        
                        $array[$i] = array(
                            'fechaDetonacion' => ($row->fechaDetonacion!='0000-00-00' && $row->fechaDetonacion!='')?date('d/m/Y',strtotime($row->fechaDetonacion)):'',
                            'linea' => (count($resultComsion) > 0) ? $resultComsion[0]['tCred'] : '',
                            'promotor' => (count($resultComsion) > 0) ? $resultComsion[0]['promotor'] : '',
                            'cliente' => (count($resultComsion) > 0) ? $resultComsion[0]['cliente'] : '',
                            'fraccionamiento' => (count($resultComsion) > 0) ? $resultComsion[0]['fraccionamiento'] : '',
                            'ronda' => (count($resultComsion) > 0) ? $resultComsion[0]['ronda'] : '',
                            'manzana' => (count($resultComsion) > 0) ? $resultComsion[0]['manzana'] : '',
                            'lote' => (count($resultComsion) > 0) ? $resultComsion[0]['lote'] : '',
                            'precioVenta' => precio_format((count($resultComsion) > 0) ? $resultComsion[0]['pVenta'] : 0),
                            'porcentajeComision' => (int)$row->porcentajeComision.'%',
                            'Comision' => precio_format($row->comision),
                            'pago1' => precio_format($row->pago1),
                            'imptoPago1' => precio_format($row->imptoPago1),
                            'diferenciaAsesorPago1' => precio_format($row->diferenciaAsesorPago1),
                            'totalPago1' => precio_format($row->totalPago1),
                            'fechaPago1' => ($row->fechaPago1!='0000-00-00' && $row->fechaPago1!='')?date('d/m/Y',strtotime($row->fechaPago1)):'',
                            'formaPago1' => strtoupper($row->formaPago1),
                            'autorizacionPago1' => $autorizacionPago1,
                            //'saldo' => precio_format($row->saldo),
                            'porcentajeComisionAjuste' => ($row->porcentajeComisionAjuste != '') ? (int)$row->porcentajeComisionAjuste.'%' : '',
                            'comisionAjuste' => ($row->comisionAjuste != '') ? precio_format($row->comisionAjuste) : '',
                            'ajuste' => ($row->ajuste != '') ? precio_format($row->ajuste) : '',
                            'imptoAjuste' => ($row->imptoAjuste != '') ? precio_format($row->imptoAjuste) : '',
                            'diferenciaAsesorAjuste' => ($row->diferenciaAsesorAjuste != '') ? precio_format($row->diferenciaAsesorAjuste) : '',
                            'totalAjuste' => ($row->totalAjuste != '') ? precio_format($row->totalAjuste) : '',
                            'formaPagoAjuste' => strtoupper($row->formaPagoAjuste),
                            'autorizacionAjuste' => $autorizacionAjuste,
                            //'saldoAjuste' => ($row->saldoAjuste != '') ? precio_format($row->saldoAjuste) : '',
                            'pago2' => ($row->pago2 != '') ? precio_format($row->pago2) : precio_format($alDiez),
                            'imptoPago2' => ($row->imptoPago2 != '') ? precio_format($row->imptoPago2) : precio_format($imtosNueve),
                            'diferenciaAsesorPago2' => ($row->diferenciaAsesorPago2 != '') ? precio_format($row->diferenciaAsesorPago2) : '',
                            'totalPago2' => ($row->totalPago2 != '') ? precio_format($row->totalPago2) : precio_format($totalPago2),
                            'fechaPago2' => ($row->fechaPago2!='0000-00-00' && $row->fechaPago2!='')?date('d/m/Y',strtotime($row->fechaPago2)):'',
                            'formaPago2' => strtoupper($row->formaPago2),
                            'asistioEntregaAsesor' => $asistioAsesor,
                            'autorizacionPago2' => $autorizacionPago2,
                        );

                        $i++;
                    }

                    $array[$i] = array(
                        'fechaDetonacion' => 'TOTALES:',
                        'linea' => '',
                        'promotor' => '',
                        'cliente' => '',
                        'fraccionamiento' => '',
                        'ronda' => '',
                        'manzana' => '',
                        'lote' => '',
                        'precioVenta' => '',
                        'porcentajeComision' => '',
                        'Comision' => precio_format($total_comision),
                        'pago1' => precio_format($total_pago1),
                        'imptoPago1' => precio_format($total_imptoPago1),
                        'diferenciaAsesorPago1' => precio_format($total_diferenciaAsesorPago1),
                        'totalPago1' => precio_format($total_totalPago1),
                        'fechaPago1' => '',
                        'formaPago1' => '',
                        'autorizacionPago1' => '',
                        //'saldo' => precio_format($row->saldo),
                        'porcentajeComisionAjuste' => '',
                        'comisionAjuste' => precio_format($total_comisionAjuste),
                        'ajuste' => precio_format($total_ajuste),
                        'imptoAjuste' => precio_format($total_imptoAjuste),
                        'diferenciaAsesorAjuste' => precio_format($total_diferenciaAsesorAjuste),
                        'totalAjuste' => precio_format($total_totalAjuste),
                        'formaPagoAjuste' => '',
                        'autorizacionAjuste' => '',
                        //'saldoAjuste' => ($row->saldoAjuste != '') ? precio_format($row->saldoAjuste) : '',
                        'pago2' => precio_format($total_pago2),
                        'imptoPago2' => precio_format($total_imptoPago2),
                        'diferenciaAsesorPago2' => precio_format($total_diferenciaAsesorPago2),
                        'totalPago2' => precio_format($total_totalPago2),
                        'fechaPago2' => '',
                        'formaPago2' => '',
                        'asistioEntregaAsesor' => '',
                        'autorizacionPago2' => '',
                    );

                }
                break;
            case 6:
                $columnas = array(
                    0 => 'NOMBRE PROMOTOR',
                    1 => 'TIPO PROMOTOR',
                    2 => 'DIFERENCIA TOTAL',
                );
                $nombre = '_diferencia_asesores';
                $q = $this->mmovimientospromotor->getPendientes();
                if(!is_numeric($q)){
                    $i=0;
                    foreach($q->result() as $row){
                        $seguir = false;
        
                        if($row->saldo > 0){
                            $seguir = true;
                        }
        
                        if($seguir){
                            $array[$i] = array(
                                'promotor' => $row->promotor,
                                'tipo' => $row->tipo,
                                'saldo' => precio_format($row->saldo),
                            );

                            $i++;
                        }
                    }
                }
                break;
        }

        crearExcel($array,'comisiones'.$nombre,$columnas,'array');
    }

    public function updateTabs($json = 0)
    {
        $data['cierreRonda'] = $this->listado(1);
        $data['porAutorizar'] = $this->listado2(1);
        $data['ajuste'] = $this->listado3(1);
        $data['entrega'] = $this->listado4(1);
        $data['inventario'] = (!is_numeric($this->mcomisiones->getAll())) ? $this->mcomisiones->getAll()->num_rows() : 0;
        $data['diferenciaPromotores'] = $this->listado6(1);
        if($json == 0){
            return $data;
        }else{
            echo json_encode($data);
        }
    }

    public function editarComision()
    {
        $response['status'] = 0;
        $idComision = $this->input->post('idComision',TRUE);
        $comision = $this->input->post('comision',TRUE);
        $insertarLogs = false;
        $comisionAnterior = 0;
        if($idComision != '' && $comision != ''){
            $qComision = $this->mcomisiones->getById($idComision);
            if(!is_numeric($qComision)){
                if($qComision['totalPago1'] != '' && $qComision['statusAutorizacionPago1'] == true && $qComision['fechaAutorizacionPago1'] != ''){
                    $comisionAnterior = $qComision['porcentajeComision'];
                    $porcentajeComision = (int)$comision;
                    $alCien = number_format((float)$qComision['precioVenta'], 2, '.', '') * ($porcentajeComision / 100);
                    $porcentajeAlNoventa = (int)$qComision['porcentajePago1'];
                    $alNoventa = number_format((float)$alCien, 2, '.', '') * ($porcentajeAlNoventa / 100);
                    $porcentajeImptosNueve = (int)$qComision['porcentajeImptoPago1'];
                    $imptosNueve = number_format((float)$alNoventa, 2, '.', '') * ($porcentajeImptosNueve / 100);
                    $diferenciaAsesor = ($qComision['diferenciaAsesorPago1'] != '') ? number_format((float)$qComision['diferenciaAsesorPago1'], 2, '.', '') : number_format((float)0.00, 2, '.', '');
                    $totalPago1 = number_format((float)$alNoventa, 2, '.', '') - number_format((float)$imptosNueve, 2, '.', '') - $diferenciaAsesor;

                    $uData['porcentajeComision'] = $porcentajeComision;
                    $uData['comision'] = $alCien;
                    $uData['porcentajePago1'] = $porcentajeAlNoventa;
                    $uData['pago1'] = $alNoventa;
                    $uData['porcentajeImptoPago1'] = $porcentajeImptosNueve;
                    $uData['imptoPago1'] = $imptosNueve;
                    $uData['totalPago1'] = $totalPago1;
                    $uData['saldo'] = $alCien - $alNoventa;

                    $this->mcomisiones->actualizar($uData, $idComision);

                    $insertarLogs = true;

                    $response['status'] = 1;
                }

                if($qComision['totalPago2'] != '' && $qComision['statusAutorizacionPago2'] == true && $qComision['fechaAutorizacionPago2'] != ''){
                    $comisionAnterior = $qComision['porcentajeComision'];
                    $porcentajeComision = (int)$comision;
                    $alCien = number_format((float)$qComision['precioVenta'], 2, '.', '') * ($porcentajeComision / 100);
                    $porcentajeAlDiez = (int)$qComision['porcentajePago2'];
                    $alDiez = number_format((float)$alCien, 2, '.', '') * ($porcentajeAlDiez / 100);
                    $porcentajeImptosNueve = (int)$qComision['porcentajeImptoPago2'];
                    $imptosNueve = number_format((float)$alDiez, 2, '.', '') * ($porcentajeImptosNueve / 100);
                    $totalPago2 = number_format((float)$alDiez, 2, '.', '') - number_format((float)$imptosNueve, 2, '.', '');

                    $uData2['porcentajePago2'] = $porcentajeAlDiez;
                    $uData2['pago2'] = $alDiez;
                    $uData2['porcentajeImptoPago2'] = $porcentajeImptosNueve;
                    $uData2['imptoPago2'] = $imptosNueve;
                    $uData2['totalPago2'] = $totalPago2;

                    $this->mcomisiones->actualizar($uData2, $idComision);

                    $insertarLogs = true;

                    $response['status'] = 1;
                }

                if($insertarLogs){

                    $pData['idComision'] = $idComision;
                    $pData['comisionAnterior'] = $comisionAnterior;
                    $pData['comisionNueva'] = (int)$comision;
                    $pData['status'] = 1;

                    $this->mlogscomisiones->insertar($pData);
                }
            }
        }

        echo json_encode($response);

    }

}