<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cartas extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$allowed;
	public function __construct(){
	$this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'cartas'; // form validation variable
            $this->mainView = 'cartas';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/cartas/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mcartaasignacion','musuario','mactivos'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           $this->data['fotos_www'] = $this->config->item('base_www').'/cartas/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
	        valSession("administracion",$this->fv);
            $this->allowed=permisos("administracion",$this->fv);
    }

	public function index(){
        $data['allowed'] = $this->allowed;
        $data['usuarios'] = $this->musuario->getAll();
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $info=$_REQUEST['info'];
        $q = $this->mcartaasignacion->getReporte($info);
        $acciones = '';
        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $leyendaAccion = ($row->pdf_1=='')?'Subir Carta':'Ver';
                $statusDescarga = ($row->pdf_1=='')?true:false;
                $acciones = accionesAsignar($row->id,$this->router->class,true,true,$leyendaAccion,$statusDescarga);
                $array['aaData'][] = array(
                    'idActivo' => strtoupper($this->mactivos->getActivo($row->idActivo)),
                    'tipoActivo' => strtoupper($this->getTipoActivo($row->idActivo)),
                    'idUsuario' => ($row->idUsuario != 0) ? strtoupper($this->musuario->getCampo("nombre",$row->idUsuario)) : "SIN ASIGNAR",
                    'notas' => strtoupper($row->notas),
                    'fechaAsignacion' => date_format(new DateTime($row->fechaAsignacion),"d-m-Y"),
                    'fechaDesasignacion' => ($row->fechaDesasignacion != null) ? date_format(new DateTime($row->fechaDesasignacion),"d-m-Y") : "",
                    'pdfCarta' => ($row->pdf_1!='')?'<a href="uploads/cartas/'.$row->pdf_1.'">Descargar</a>':'',
                    'statusCarta' =>($row->statusCarta==1) ?strtoupper( "Activo") : "INACTIVO",
                    'acciones' => $acciones,

                    );
            }
        }else{
            $array['aaData'][] = array(
                'idActivo' => 'No hay registros',
                'tipoActivo' => 'No hay registros',
                'idUsuario' => 'No hay registros',
                'notas' => 'No hay registros',
                'fechaAsignacion' => 'No hay registros',
                'fechaDesasignacion' => 'No hay registros',
                'pdfCarta' => 'No hay registros',
                'statusCarta' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }
        echo json_encode($array);
    }

    public function getTipoActivo($idActivo){
        $idActivo=$this->mactivos->getCampo("idActivo",$idActivo);
        switch ($idActivo){
            case 1:
                return "Mobiliario";
                break;
            case 2:
                return "Otro";
                break;
            case 3:
                return "Electrónica";
                break;
            case 4:
                return "Vehículo";
                break;
        }
    }

    public function nuevo(){
        // Mensajes
        $data['msg'] = '';
        $data["activos"]=$this->mactivos->getActivos(1);
        $data["usuarios"]=$this->musuario->getAll();
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        }else{
            $pData['idActivo'] = $this->input->post('idActivo', TRUE);
            $pData['idUsuario'] = $this->input->post('idUsuario', TRUE);
            $pData['notas'] = $this->input->post('notas', TRUE);
            $pData['fechaAsignacion'] = date_format(new DateTime(),"Y-m-d");
            $pData['statusCarta'] = 1;
            $pData['status'] = 1;
            $id = $this->mcartaasignacion->insertar($pData);
            $this->mactivos->actualizar(array('disponible' => 0), $this->input->post('idActivo'));
            redirect($this->router->class);
        }
    }

    public function editar($id){
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['idUsuario'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            }else{


                // Subida de pdf
                $config = array();
                $this->load->library('upload', $config);

                if (isset($_FILES)){
                    $imagenes = array();
                    foreach($_FILES as $key=>$value){
                        if ($_FILES[$key]['size'] > 0){
                            $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                            $imagenes[] = $key;
                        }
                    }
                    $totalImagenes = count($imagenes);

                    for($i=0; $i< $totalImagenes; $i++){
                        $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                        //Configuracion del thumbnail
                        if($imagenes[$i]!='pdf'){
                            $nCampoC = explode("_",$imagenes[$i]);
                            $tipo = $nCampoC[0];
                            $v = $nCampoC[1];

                        } else {
                            $v = 0;
                            $tipo = 'pdf';
                        }
                        if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
                            //echo 'es tipo foto<br>';
                            $uploaddir = $this->data['fotos_www'];
                            $nextId = $id;
                            $config['file_name'] =  $nextId."_".$v;
                            $config['overwrite'] = TRUE;
                            $config['upload_path'] = $uploaddir;
                            $config['max_size'] = '20000';
                            $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                            $this->upload->initialize($config);
                            if ( ! $this->upload->do_upload($imagenes[$i]) )
                            {
                                $redirect = 1;
                                $data['error'] = $this->upload->display_errors();
                            }
                            else
                            {
                                $dataFile = $this->upload->data($imagenes[$i]);
                                $fotoI = 'pdf_'.$v;
                                //$thumbI = 'thumbnail_'.$v;
                                if ($v == 0){
                                    //Foto default
                                    $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                                } else {
                                    $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                                    $this->mcartaasignacion->actualizar($pData,$id);
                                }
                            }
                        }

                    }
                }

                $idUsuario=$this->input->post('idUsuario', TRUE);
                if($this->mcartaasignacion->getCampo("idUsuario",$id) != $idUsuario){
                    $pData['idActivo'] = $this->input->post('idActivo', TRUE);
                    $pData['idUsuario'] = $idUsuario;
                    $pData['notas'] = $this->input->post('notas', TRUE);
                    $pData['fechaAsignacion'] = date_format(new DateTime(),"Y-m-d");
                    $pData['statusCarta'] = 1;
                    $pData['status'] = 1;

                    $this->mcartaasignacion->insertar($pData);
                    $this->mcartaasignacion->actualizar(
                        array(
                            'fechaDesasignacion' => date_format(new DateTime(),"Y-m-d"),
                            'statusCarta' => 0
                        )
                    ,$id);
                    redirect($this->router->class);
                }else{
                    redirect($this->router->class);
                }
            }
        }
        // Obteniendo la información
        $info = $this->mcartaasignacion->getById($id);

        $data = $info;
        $data['msg']=$msg;
        $data["activos"]=$this->mactivos->getActivos();
        $data["usuarios"]=$this->musuario->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function reasignar($id){
        // Mensajes
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['idUsuario'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            }else{
                $idUsuario=$this->input->post('idUsuario', TRUE);
                if($this->mcartaasignacion->getCampo("idUsuario",$id) != $idUsuario){
                    $pData['idActivo'] = $this->input->post('idActivo', TRUE);
                    $pData['idUsuario'] = $idUsuario;
                    $pData['notas'] = $this->input->post('notas', TRUE);
                    $pData['fechaAsignacion'] = date_format(new DateTime(),"Y-m-d");
                    $pData['statusCarta'] = 1;
                    $pData['status'] = 1;

                    $this->mcartaasignacion->insertar($pData);
                    $this->mcartaasignacion->actualizar(
                        array(
                            'fechaDesasignacion' => date_format(new DateTime(),"Y-m-d"),
                            'statusCarta' => 0
                        )
                    ,$id);
                    redirect($this->router->class);
                }else{
                    redirect($this->router->class);
                }
            }
        }
        // Obteniendo la información
        $info = $this->mcartaasignacion->getById($id);

        $data = $info;
        $data['msg']=$msg;
        $data["activos"]=$this->mactivos->getActivos();
        $data["usuarios"]=$this->musuario->getAll();
        $this->data['contenido'] = $this->load->view($this->mainView . '/reasignar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->mcartaasignacion->getById($id);
        $cValor = "true";
        $this->mcartaasignacion->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function eliminar_archivo()
    {

        if (isset($_POST['elid'])){
            $id = $this->input->post('elid');
            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
            if($campo !="0"){
                $archivo = $this->mcartaasignacion->getCampo('pdf_'.$campo,$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf_'.$campo] ='';
                    $this->mcartaasignacion->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }else{
                $archivo = $this->mcartaasignacion->getCampo('pdf',$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf'] ='';
                    $this->mcartaasignacion->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;

        }
    }


}


