<?php  
	defined('BASEPATH') OR exit('No direct script access allowed');
	
	class cancelaciones_gestoria extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'cancelaciones_gestoria'; // form validation variable
			$this->mainView = 'cancelaciones_gestoria';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/cancelaciones_gestoria/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text','security'));
			// Modelos
			$this->load->model(array('maltaventa','mprospecto','mfraccionamiento','musuario', 'mgestoria','mnotaria','mproyecto'));//maltaventa tiene los datos para gestoria, mgestoria se usa para obtener la funcion getNext id al guardar archivos
			
			// Lbrerias
			// $this->load->library(array('email','session'));
			$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/gestoria/';
			
			// Debugging
			$this->output->enable_profiler(false);
			
			//Validación de usuarios
			valSession("ventas",$this->fv);
		}
		
		public function index() {
			$data['q'] = '';
			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}
		
		public function listado(){
	        $q = $this->maltaventa->getJoinGestoriaCancel();
	        if (!is_numeric($q)){
	            foreach ($q->result() as $row){

	            	$existeEnGestoria = $this->mgestoria->getByIdAv($row->id);
	            	$idMotivo = (!is_numeric($existeEnGestoria))?$existeEnGestoria['idMotivo']:0;
	            	if($row->fechaCancelacion!='' && $row->fechaCancelacion!='0000-00-00'){
	            		$fechaCancelacion = $row->fechaCancelacion;
	            	}elseif($row->fechaCancelacionAv!='' && $row->fechaCancelacionAv!='0000-00-00'){
            			$fechaCancelacion = $row->fechaCancelacionAv;
            		}else{
            			$fechaCancelacion = '';
            		}

	            	switch ($row->statusValidacion) {
	            		case '0':
	            			$modulo = 'Alta Venta';
	            			break;
            			case '1':
	            			$modulo = 'Alta Venta';
	            			break;
            			case '2':
	            			$modulo = 'Gestoria';
	            			break;
            			case '3':
	            			$modulo = 'Gestoria';
	            			break;
            			case '4':
	            			$modulo = 'Titulación';
	            			break;
            			case '5':
	            			$modulo = 'Titulación';
	            			break;
	            		
	            		default:
	            			$modulo = 'Prospectos';
	            			break;
	            	}
	            	$idProspecto = $row->idProspecto;
	            	$idFraccionamiento = $this->mprospecto->getCampo('idFraccionamiento',$idProspecto);
	                $array['aaData'][] = array(
	                    'nombre' => strtoupper($row->nombre.' '.$row->apellidoP.' '.$row->apellidoM),
	                    'nss' => $row->nss,
	                    'fraccionamiento' =>  $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento),
	                    'promotor' => strtoupper($this->musuario->getCampo('nombre',$row->idPromotor)." ".$this->musuario->getCampo('apellidoP',$row->idPromotor)." ".$this->musuario->getCampo('apellidoM',$row->idPromotor)),
	                    'lote' => $row->lote,
	                    'manzana' => $row->manzana,
	                    'modulo' => strtoupper($modulo),
	                    'cuv' => $row->cuv,
	                    'precioVenta' => precio_format($row->precioVenta),
	                    'avaluo' => precio_format($row->avaluo),
	                    'fechaAv' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',
	                    'statusVivienda' => estatus_proyecto_reporte($row->statusVenta),
	                    'statusGestoria' => $row->statusGestoria,
	                    'idMotivo' => strtoupper(getMotivo(($idMotivo>0)?$idMotivo:$row->idMotivo)),
	                    'motivoCancelacion' => strtoupper(($row->motivoCancelacion=='')?$row->motivoCancelacionAv:$row->motivoCancelacion),
	                    'fechaCancelacion' => ($fechaCancelacion!='')?date_format(new DateTime($fechaCancelacion), 'd/m/Y'):'',
	                    'acciones' => '<a class="btn blue" href="validacion_venta/nuevo/'.$row->idProspecto.'/1">Re-Activar</a>'//acciones($row->id,$this->router->class, false, true, false)
	                    );
	            }
	        } else{
	            $array['aaData'][] = array(
	                'nombre' => 'No hay registros',
	                'nss' => 'No hay registros',
	                'fraccionamiento' => 'No hay registros',
	                'promotor' => 'No hay registros',
	                'lote' => 'No hay registros',
	                'modulo' => 'No hay registros',
	                'manzana' => 'No hay registros',
	                'cuv' => 'No hay registros',
	                'precioVenta' => 'No hay registros',
	                'avaluo' => 'No hay registros',
	                'statusVivienda' => 'No hay registros',
	                'statusGestoria' => 'No hay registros',
	                'idMotivo' => 'No hay registros',
	                'motivoCancelacion' => 'No hay registros',
	                'fechaCancelacion' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }

	}
?>