<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bonificaciones extends MX_Controller {
	public $data,$vParameters,$mainView,$fv;
	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'bonificaciones'; // form validation variable
            $this->mainView = 'bonificaciones';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/bonificaciones/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('musuario', 'maltaventa', 'mbonificacion', 'mbonificaciones_descuentos'));

            // Lbrerias
            // $this->load->library(array('email','session'));
           	//$this->data['fotos_www'] = $this->config->item('base_www').'/bonificaciones/';


            // Debugging
            $this->output->enable_profiler(false);

           //Validación de usuarios
	        valSession("contabilidad",$this->fv);
    }


	public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    //listado del "inventario"
    public function listado(){
        $_SESSION['listadoBInventario'] = 0;
        $q = $this->mbonificacion->get_datatables();
        $count = 0;
        if ( !is_numeric($q) ){
            foreach($q->result() as $pendiente){
                $sumBonificacionDesc = $this->mbonificaciones_descuentos->getSumByIdBonificacion($pendiente->id);

                $link = '<a id="'.$pendiente->id.'" href="javascript:void(0);" rel="noopener noreferrer" onclick="modalDescuento($(this));">
                            <strong style="font-size:14px;text-decoration: underline;"> '.precio_format($sumBonificacionDesc).' </strong> 
                        </a>';

                $array[] = array(
                    'linea' =>  $pendiente->linea,
                    'cliente' =>  $pendiente->cliente,
                    'precio' =>  precio_format($pendiente->precioVenta),
                    'ronda' => $pendiente->ronda,
                    'lote' =>  $pendiente->lote,
                    'manzana' =>  $pendiente->manzana,
                    'fraccionamiento' => $pendiente->fraccionamiento,
                    'total' => precio_format($pendiente->bonificacion),
                    'total_' => $pendiente->bonificacion,
                    'descuento' => ($sumBonificacionDesc > 0) ? $link : precio_format($sumBonificacionDesc),
                    'descuento_' => $sumBonificacionDesc,
                    'fecha' => date("d/m/Y", strtotime($pendiente->fechaPago) ),
                    'status' => 'Pagado',
                    'tipo' =>  $pendiente->tipo,
                    'fechaAutorizado' => date("d/m/Y", strtotime($pendiente->fechaAutorizado) )
                );
                $count++;
            }
        }else{
            $array[] = array(
                'linea' =>  'No hay registros',
                'cliente' =>  'No hay registros',
                'precio' =>  'No hay registros',
                'ronda' => 'No hay registros',
                'lote' =>  'No hay registros',
                'manzana' =>  'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'total' => 'No hay registros',
                'total_' => 'No hay registros',
                'descuento' => 'No hay registros',
                'descuento_' => 'No hay registros',
                'fecha' => 'No hay registros',
                'tipo' => 'No hay registros',
                'status' => 'No hay registros',
                'fechaAutorizado' => 'No hay registros'
                );
        }

        $_SESSION['listadoBInventario'] = $count;

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->mbonificacion->count_all(),
            "recordsFiltered" => $this->mbonificacion->count_filtered(),
            "data" => $array,
        );
        //output to json format
        echo json_encode($output);
    }

    //listado del "pendientes"
    public function listado2(){
        $_SESSION['listadoBPendientes'] = 0;
        $count = 0;
        $q = $this->maltaventa->todosPendientesBonificacion();
        if ( $q->num_rows() > 0 ){
            /*$fideicomiso = 870;
            $avaluo = 2100;*/
            foreach($q->result() as $pendiente){
                /*$cantidadRecibir = $pendiente->precioVentaOci - $pendiente->difPropioPeculioTitulacion;
                $ahorroVol = ($pendiente->ahorroVol > 0)? $pendiente->ahorroVol : 0.00;
                $valorCufrisa = $cantidadRecibir - $ahorroVol - $avaluo - $pendiente->valorTerreno;
                $importeCufrisa = $valorCufrisa * 0.017;
                $iva = $importeCufrisa * 0.16;
                $neto = $importeCufrisa + $iva;
                $importeSinTerreno = $valorCufrisa - $neto;
                $valorNeto = $importeSinTerreno + $pendiente->valorTerreno;
                $comisionSindical = $cantidadRecibir * 0.04;
                $valorNeto2 = $valorNeto - $comisionSindical;
                $saldo = $valorNeto2 - $pendiente->precioVenta - $fideicomiso;
                $tresPorciento = $saldo * 0.1;
                $bonificacion = $saldo - $tresPorciento;*/
                $acciones = ( in_array($_SESSION[$this->nsession]["rol"], permisos("ventas","bonificaciones_edit")['r']) )? '<a class="btn blue" href="javascript:void(0);" onclick="modalPago('.$pendiente->id.',0)" style="margin-bottom:10px;">Pagar</a>' : '';

                $array['aaData'][] = array(
                    'linea' =>  $pendiente->linea,
                    'cliente' =>  $pendiente->cliente,
                    'precio' =>  precio_format($pendiente->precioVenta),
                    'ronda' => $pendiente->ronda,
                    'lote' =>  $pendiente->lote,
                    'manzana' =>  $pendiente->manzana,
                    'fraccionamiento' => $pendiente->fraccionamiento,
                    'total' => precio_format($pendiente->bonificacion),
                    'acciones' => $acciones
                    );

                $count++;
            }
        }else{
            $array['aaData'][] = array(
                'linea' =>  'No hay registros',
                'cliente' =>  'No hay registros',
                'precio' =>  'No hay registros',
                'ronda' => 'No hay registros',
                'lote' =>  'No hay registros',
                'manzana' =>  'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'total' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }

        $_SESSION['listadoBPendientes'] = $count;

        echo json_encode($array);
    }

    //listado "por autorizar"
    public function listado3(){
        $_SESSION['listadoBAutorizar'] = 0;
        $count = 0;
        $q = $this->mbonificacion->get_datatables();
        if ( !is_numeric($q) ){
            foreach($q->result() as $pendiente){
                $acciones = '';
                if(in_array($_SESSION[$this->nsession]["rol"], permisos("ventas","bonificaciones_edit")['r']) && $_SESSION[$this->nsession]["rol"] == 1 ){
                    $acciones = '<a class="btn blue" href="javascript:void(0);" onclick="modalPago('.$pendiente->idAltaVenta.',1)">Pagar</a>'; //<a class="btn blue" href="javascript:void(0);" onclick="modalAutorizar('.$pendiente->id.')" style="margin-bottom:10px;">Autorizar</a>
                }

                $array[] = array(
                    'linea' =>  $pendiente->linea,
                    'cliente' =>  $pendiente->cliente,
                    'precio' =>  precio_format($pendiente->precioVenta),
                    'ronda' => $pendiente->ronda,
                    'lote' =>  $pendiente->lote,
                    'manzana' =>  $pendiente->manzana,
                    'fraccionamiento' => $pendiente->fraccionamiento,
                    'total' => precio_format($pendiente->bonificacion),
                    'fecha' => date("d/m/Y", strtotime($pendiente->fechaPago) ),
                    //'manzana' =>  $pendiente->tipo,
                    'tipo' =>  $pendiente->tipo,
                    'acciones' => $acciones
                    );

                $count++;
            }
        }else{
            $array[] = array(
                'linea' =>  'No hay registros',
                'cliente' =>  'No hay registros',
                'precio' =>  'No hay registros',
                'ronda' => 'No hay registros',
                'lote' =>  'No hay registros',
                'manzana' =>  'No hay registros',
                'fraccionamiento' => 'No hay registros',
                'total' => 'No hay registros',
                'fecha' => 'No hay registros',
                'tipo' => 'No hay registros',
                'acciones' => 'No hay registros'
                );
        }

        $_SESSION['listadoBAutorizar'] = $count;

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->mbonificacion->count_all(),
            "recordsFiltered" => $this->mbonificacion->count_filtered(),
            "data" => $array,
        );
        //output to json format
        echo json_encode($output);
    }

    public function getDatosModal(){
        $id = $_POST['idAltaVenta'];
        $datitos['msg'] = '';
        $datitos['status'] = 0;
        if ( is_numeric($id) && $id > 0 ){
            
            $qBonificacion = $this->maltaventa->todosPendientesBonificacion($id);

            if( $qBonificacion->num_rows() > 0){
                $datitos['fechaDetona'] = date("d/m/Y", strtotime($qBonificacion->row()->fechaDetona));
                $datitos['linea'] =  $qBonificacion->row()->linea;
                $datitos['cliente'] =  $qBonificacion->row()->cliente;
                $datitos['promotor'] =  $qBonificacion->row()->promotor;
                $datitos['precioVenta'] =  $qBonificacion->row()->precioVenta;
                $datitos['ronda'] = $qBonificacion->row()->ronda;
                $datitos['lote'] =  $qBonificacion->row()->lote;
                $datitos['manzana'] = $qBonificacion->row()->manzana;
                $datitos['fraccionamiento'] = $qBonificacion->row()->fraccionamiento;
                $datitos['bonificacion'] = precio_format($qBonificacion->row()->bonificacion);
                if( $_POST['editar'] ){
                    $qEditar = $this->mbonificacion->getByIdAV($id);
                    $datitos['id'] = $qEditar['id'];
                    $datitos['fechaPago'] = date("d/m/Y", strtotime($qEditar['fechaPago']) );
                    $datitos['idTipo'] = $qEditar['idTipo'];
                    $datitos['bonificacion'] = precio_format($qEditar['bonificacion']);
                    $qBonificacionDesc = $this->mbonificaciones_descuentos->getByIdBonificacion($datitos['id']);
                    $sumBonificacionDesc = $this->mbonificaciones_descuentos->getSumByIdBonificacion($datitos['id']);
                    $datitos['bonificacionDesc'] = $qBonificacionDesc->result_array();
                    $datitos['bonificacionDescRows'] = $qBonificacionDesc->num_rows();
                    $datitos['bonificacion2'] = number_format($qEditar['bonificacion'] + $sumBonificacionDesc, 2, '.', '');

                }
                $datitos['status'] = 1;
            }else{
                $datitos['msg'] = "No se encontró la información";
            }
        }
        else{
            $datitos['msg'] = "No esta proporcionando todos los datos.";
        }
        echo json_encode($datitos);
    }
    
    public function guardarPago(){

        //$concepto =  $_POST['concepto'];
        $infoDesc =  $_POST['infoDesc'];
        $infoDesc =  json_decode($infoDesc, true);

        $fechaPago = $_POST['fechaPago'];
        $tipo = array( 1 => 'TRANSFERENCIA', 2 => 'CHEQUE' );
        $datitos['msg'] = 'Debe llenar todos los campos.';
        $datitos['status'] = 0;
        if ( is_numeric($_POST['idAltaVenta']) && array_key_exists($_POST['tipo'], $tipo) && $fechaPago != '' && $_POST['bonificacion'] != '$' && $_POST['bonificacion'] != '' && count($infoDesc) > 0){
            $bData['idAltaVenta'] = $_POST['idAltaVenta'];
            $bData['bonificacion'] = toInt($_POST['bonificacion']);
            $fechaPago =  str_replace('/', '-', $fechaPago);
            $bData['fechaPago'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
            $bData['idTipo'] = $_POST['tipo'];
            $bData['tipo'] = $tipo[$_POST['tipo']];
            if( $_SESSION[$this->nsession]["rol"] == 1 ){
                $bData['statusAutorizado'] = 1;
                $bData['fechaAutorizado'] = date('Y-m-d');
            }
            $id = $this->mbonificacion->insertar($bData);
            //Se recorre el array de descuento
            foreach($infoDesc as $key=>$val){
                $pData['idBonificacion'] = $id;
                $pData['concepto'] = $val['concepto'];
                $pData['importe'] = $val['importe'];
                $pData['status'] = 1;

                $idBonificacionDesc = $this->mbonificaciones_descuentos->insertar($pData);
            }
            $datitos['status'] = 1;
            $datitos['msg'] = 'Se ha guardado la bonificación con éxito.';
        }
        echo json_encode($datitos);
    }

    public function excel($tipo){
        switch ($tipo) {
            case 1:
               $q = $this->maltaventa->getAllExcelRowsBonPendientes();
               $columnas = array(
                            0 => 'STATUS',
                            1 => 'LINEA',
                            2 => 'CLIENTE',
                            3 => 'FRACCIONAMIENTO',
                            4 => 'PRECIO',
                            5 => 'RONDA',
                            6 => 'MANZANA',
                            7 => 'LOTE',
                            8 => 'BONIFICACION'
                );
                $nombre = '_pendiente';
                break;
            case 2:
                $q = $this->mbonificacion->getAllExcelRows(0);
                $columnas = array(
                            0 => 'STATUS',
                            1 => 'LINEA',
                            2 => 'CLIENTE',
                            3 => 'FRACCIONAMIENTO',
                            4 => 'PRECIO',
                            5 => 'RONDA',
                            6 => 'MANZANA',
                            7 => 'LOTE',
                            8 => 'BONIFICACION',
                            9 => 'FECHA PAGO',
                            10 => 'TIPO PAGO'
                );
                $nombre = '_por_autorizar';
                break;
            case 3:
                $q = $this->mbonificacion->getAllExcelRows(1);
                $columnas = array(
                            0 => 'STATUS',
                            1 => 'FECHA AUTORIZADO',
                            2 => 'LINEA',
                            3 => 'CLIENTE',
                            4 => 'FRACCIONAMIENTO',
                            5 => 'PRECIO',
                            6 => 'RONDA',
                            7 => 'MANZANA',
                            8 => 'LOTE',
                            9 => 'BONIFICACION',
                            10 => 'FECHA PAGO',
                            11 => 'TIPO PAGO'
                );
                $nombre = '_inventario';
                break;
            default:
                $q = 0;
                break;
        }
       crearExcel($q,'bonificaciones'.$nombre,$columnas);
    }
    
    public function editarPago(){
     
        $infoDesc =  $_POST['infoDesc'];
        $infoDesc =  json_decode($infoDesc, true);

        $fechaPago = $_POST['fechaPago'];
        $tipo = array( 1 => 'TRANSFERENCIA', 2 => 'CHEQUE' );
        $datitos['msg'] = 'Debe llenar todos los campos.';
        $datitos['status'] = 0;
        if ( is_numeric($_POST['id']) && array_key_exists($_POST['tipo'], $tipo) && $fechaPago != '' && $_POST['bonificacion'] != '$' && $_POST['bonificacion'] != '' && count($infoDesc) > 0){
            $bData['bonificacion'] = toInt($_POST['bonificacion']);
            $fechaPago =  str_replace('/', '-', $fechaPago);
            $bData['fechaPago'] = ($fechaPago != '')? date('Y-m-d', strtotime($fechaPago)) : NULL;
            $bData['idTipo'] = $_POST['tipo'];
            $bData['tipo'] = $tipo[$_POST['tipo']];
            if( $_SESSION[$this->nsession]["rol"] == 1 ){
                $bData['statusAutorizado'] = 1;
                $bData['fechaAutorizado'] = date('Y-m-d');
            }
            $id = $this->mbonificacion->actualizar($bData, $_POST['id']);
            //Se recorre el array de descuento
            foreach($infoDesc as $key=>$val){
                if($val['id'] == ''){
                    $pData['idBonificacion'] = $_POST['id'];
                    $pData['concepto'] = $val['concepto'];
                    $pData['importe'] = $val['importe'];
                    $pData['status'] = 1;

                    $idBonificacionDesc = $this->mbonificaciones_descuentos->insertar($pData);
                }else{
                    $pData['concepto'] = $val['concepto'];
                    $pData['importe'] = $val['importe'];

                    $this->mbonificaciones_descuentos->actualizar($pData, $val['id']);
                }
            }
            $datitos['status'] = 1;
            $datitos['msg'] = 'Se ha actualizado la bonificación con éxito.';
        }
        echo json_encode($datitos);
    }

    public function autorizarPago(){
        $datitos['msg'] = 'Debe llenar todos los campos.';
        $datitos['status'] = 0;
        if ( is_numeric($_POST['id']) ){
            $bData['statusAutorizado'] = 1;
            $bData['fechaAutorizado'] = date('Y-m-d');
            $id = $this->mbonificacion->actualizar($bData, $_POST['id']);
            $datitos['status'] = 1;
            $datitos['msg'] = 'Se ha actualizado la bonificación con éxito.';
        }
        echo json_encode($datitos);
    }

    public function updateTabs()
    {
        $data['pendientes'] = $_SESSION['listadoBPendientes'];
        $data['autorizar'] = $_SESSION['listadoBAutorizar'];
        $data['inventario'] = $_SESSION['listadoBInventario'];
        echo json_encode($data);
    }

    public function modalDescuento()
    {
        $array['status'] = 0;
        $idBonificacion = $this->input->post('idBonificacion',TRUE);
        $qBonificacionDesc = $this->mbonificaciones_descuentos->getByIdBonificacion($idBonificacion);
        if(!is_numeric($qBonificacionDesc)){
            $data['id'] = $idBonificacion;
            $data['qBonificacionDesc'] = $qBonificacionDesc;
            $modal = $this->load->view($this->mainView.'/modaldesc_view',$data,true);
            $array['idModal'] = 'modalDescuentos_'.$idBonificacion;
            $array['modal'] = $modal;
            $array['status'] = 1;
        }

        echo json_encode($array);
    }
}