<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	date_default_timezone_set('America/Mexico_City');
	class Blackboard extends MX_Controller {
		public $data,$vParameters,$mainView,$fv;
		public function __construct() {
			$this->nsession = $this->config->item('nsession');
			if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
			$this->fv = 'blackboard'; // form validation variable
			$this->mainView = 'blackboard';
			$this->data['fjs'] = '';
			$this->data['js'] = '<script src="assets/js/blackboard/listado.js" type="text/javascript"></script>';
			$this->data['css'] = '';
			// Tools
			$this->load->helper(array('tools','numeros','url','form','date','text'));
			// Modelos
			$this->load->model(array('mblackboard', 'mfraccionamiento', 'musuario'));

			// Lbrerias
			// $this->load->library(array('email','session'));
			// $this->data['fotos_www'] = $this->config->item('base_www').'/inicio/';

			// Debugging
            $this->output->enable_profiler(false);

           	//Validación de usuarios
			//valSession("ventas",$this->fv);
		}

		public function index() {
			$data['allowed']=permisos("ventas","blackboard_edit");
			$data['q'] = '';

			$this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
		}

		public function listado(){
			$permisos=permisos("ventas","blackboard_edit");
			// $q = $this->mblackboard->getAll();
			$q = $this->mblackboard->getAllList();
	        if (!is_numeric($q)){

	        	$date_ = date('Y-m-d');
	            foreach ($q->result() as $row){
	            	$txtDelegados = '';
	            	// $test = tiempoTranscurridoFechas($date_,$row->fechaTermino);
	            	// $test = tiempoTranscurridoFechas($row->fechaTermino,$date_);
	            	// print_r($test); exit();
	            	$expIds = explode(' ', $row->idUsuario);
	            	$delegados = $this->musuario->getEmailLike($expIds);
	            	//print_r($delegados->result());exit();
	            	if (!is_numeric($delegados)){
	            		foreach ($delegados->result() as $d) {
	            			$txtDelegados .= $d->nombre." ".$d->apellidoP.",";
	            		}
	            	}
	            	if($_SESSION['viv']['rol']==8){
		            	if (in_array($_SESSION['viv']['id'], $expIds)){
		                	$array['aaData'][] = array(
		                	'proyecto' => $row->proyecto,
		                    'asunto' => $row->asunto,
		                    'delegado' => $txtDelegados." ".$row->nombreOtros,//$row->delegado,
		                    // 'fechaInicio' => $row->fechaInicio,
		                    'fechaInicio' => date_format(new DateTime($row->fechaInicio), 'd/m/Y'),
		                    // 'fechaTermino' => $row->fechaTermino,
		                    'fechaTermino' => date_format(new DateTime($row->fechaTermino), 'd/m/Y'),
		                    'faltantes' => tiempoTranscurridoFechas($date_,$row->fechaTermino),
		                    // 'checked' => $row->checked,
		                    'checked' => actionCheckedBlackboard($row->id, $row->checked),
		                    'cumplimiento' => actionCompleteBlackboard($row->id,$row->statusCumplido),
		                    'acciones' => (in_array($this->config->item("rol"), $permisos["r"])) ? accionesBlackboard($row->id,$this->router->class,false,($row->checked == 1 && $row->statusCumplido == 1 ? false : true),true) : ""
		                    );
		            	}
	            	}else{
	                	$array['aaData'][] = array(
	                	'proyecto' => $row->proyecto,
	                    'asunto' => $row->asunto,
	                    'delegado' => $txtDelegados." ".$row->nombreOtros,//$row->delegado,
	                    // 'fechaInicio' => $row->fechaInicio,
	                    'fechaInicio' => date_format(new DateTime($row->fechaInicio), 'd/m/Y'),
	                    // 'fechaTermino' => $row->fechaTermino,
	                    'fechaTermino' => date_format(new DateTime($row->fechaTermino), 'd/m/Y'),
	                    'faltantes' => tiempoTranscurridoFechas($date_,$row->fechaTermino),
	                    // 'checked' => $row->checked,
	                    'checked' => actionCheckedBlackboard($row->id, $row->checked),
	                    'cumplimiento' => actionCompleteBlackboard($row->id,$row->statusCumplido),
	                    'acciones' => (in_array($this->config->item("rol"), $permisos["r"])) ? accionesBlackboard($row->id,$this->router->class,false,($row->checked == 1 && $row->statusCumplido == 1 ? false : true),true) : ""
	                    );
	            	}

	            }
	        } else{
	            $array['aaData'][] = array(
	            	'proyecto' => 'No hay registros',
	                'asunto' => 'No hay registros',
	                'delegado' => 'No hay registros',
	                'fechaInicio' => 'No hay registros',
	                'fechaTermino' => 'No hay registros',
	                'faltantes' => 'No hay registros',
	                'checked' => 'No hay registros',
	                'cumplimiento' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }

	    public function listado2(){
			$permisos=permisos("ventas","blackboard_edit");

			$q = $this->mblackboard->getAllListComplete();
	        if (!is_numeric($q)){

	        	$date_ = date('Y-m-d');
	            foreach ($q->result() as $row){
	            	$txtDelegados = '';
	            	// $test = tiempoTranscurridoFechas($date_,$row->fechaTermino);
	            	// $test = tiempoTranscurridoFechas($row->fechaTermino,$date_);
	            	// print_r($test); exit();
	            	$expIds = explode(' ', $row->idUsuario);
	            	$delegados = $this->musuario->getEmailLike($expIds);
	            	//print_r($delegados);
	            	if (!is_numeric($delegados)){
	            		foreach ($delegados->result() as $d) {
	            			$txtDelegados .= $d->nombre." ".$d->apellidoP.",";
	            		}
	            	}
	            	if($_SESSION['viv']['rol']==8){
		            	if (in_array($_SESSION['viv']['id'], $expIds)){
		                	$array['aaData'][] = array(
		                	'proyecto' => $row->proyecto,
		                    'asunto' => $row->asunto,
		                    'delegado' => $txtDelegados." ".$row->nombreOtros,//$row->delegado,
		                    // 'fechaInicio' => $row->fechaInicio,
		                    'fechaInicio' => date_format(new DateTime($row->fechaInicio), 'd/m/Y'),
		                    // 'fechaTermino' => $row->fechaTermino,
		                    'fechaTermino' => date_format(new DateTime($row->fechaTermino), 'd/m/Y'),
		                    'faltantes' => tiempoTranscurridoFechas($date_,$row->fechaTermino),
		                    // 'checked' => $row->checked,
		                    'checked' => actionCheckedBlackboard($row->id, $row->checked),
		                    'cumplimiento' => actionCompleteBlackboard($row->id,$row->statusCumplido),
		                    'acciones' => (in_array($this->config->item("rol"), $permisos["r"])) ? accionesBlackboard($row->id,$this->router->class,false,($row->checked == 1 ? false : true),true) : ""
		                    );
		            	}
	            	}else{
	                	$array['aaData'][] = array(
	                	'proyecto' => $row->proyecto,
	                    'asunto' => $row->asunto,
	                    'delegado' => $txtDelegados." ".$row->nombreOtros,//$row->delegado,
	                    // 'fechaInicio' => $row->fechaInicio,
	                    'fechaInicio' => date_format(new DateTime($row->fechaInicio), 'd/m/Y'),
	                    // 'fechaTermino' => $row->fechaTermino,
	                    'fechaTermino' => date_format(new DateTime($row->fechaTermino), 'd/m/Y'),
	                    'faltantes' => tiempoTranscurridoFechas($date_,$row->fechaTermino),
	                    // 'checked' => $row->checked,
	                    'checked' => actionCheckedBlackboard($row->id, $row->checked),
	                    'cumplimiento' => actionCompleteBlackboard($row->id,$row->statusCumplido),
	                    'acciones' => (in_array($this->config->item("rol"), $permisos["r"])) ? accionesBlackboard($row->id,$this->router->class,false,($row->checked == 1 ? false : true),true) : ""
	                    );
	            	}


	            }
	        } else{
	            $array['aaData'][] = array(
	            	'proyecto' => 'No hay registros',
	                'asunto' => 'No hay registros',
	                'delegado' => 'No hay registros',
	                'fechaInicio' => 'No hay registros',
	                'fechaTermino' => 'No hay registros',
	                'faltantes' => 'No hay registros',
	                'checked' => 'No hay registros',
	                'cumplimiento' => 'No hay registros',
	                'acciones' => 'No hay registros'
	                );

	        }

	        echo json_encode($array);
	    }

	    public function getEmails(){
	    	$txtMails = '';
	    	$ids = $this->input->post('id', TRUE);
	    	$emails=$this->musuario->getEmails($ids);
	    	if (!is_numeric($emails)){
	    		foreach ($emails->result() as $e) {
	    			$txtMails .=  $e->email.",";
	    		}
	    		$data['success'] = 1;
	    	}else{
	    		$data['success'] = 0;
	    	}
	    	$data['emails'] = $txtMails;

	    	echo json_encode($data);
	    	//print_r($emails->result());
	    	//exit();

	    }

	    public function nuevo() {
	    	$msg = "";
	    	// $data['fraccionamientos'] = $this->mfraccionamiento->getAll();

	    	$this->load->library('form_validation');
	    	if ($this->form_validation->run($this->fv) == FALSE) {
	    		$data['msg'] = validation_errors();
	    		$data['usuarios'] = $this->musuario->getAll();
	    		$data['fraccionamientos'] = $this->mfraccionamiento->getAll();

	    		$this->data['contenido'] = $this->load->view($this->mainView.'/nuevo_view',$data,true);
				$this->load->view('templates/main_template',$this->data);
	    	}
	    	else {
	    		$pData['asunto'] = $this->input->post('asunto', TRUE);
	    		$pData['proyecto'] = $this->input->post('proyecto', TRUE);
	    		$pData['delegado'] = $this->input->post('delegado', TRUE);
	    		//$pData['idUsuario'] = $this->input->post('usuarios', TRUE);
	    		$pData['mail'] = substr($this->input->post('mail', TRUE), 0, -1);
	    		$fechaInicio = $this->input->post('fechaInicio', TRUE);
	    		$fechaInicio =  str_replace('/', '-', $fechaInicio);
	    		$pData['fechaInicio'] = date('Y-m-d', strtotime($fechaInicio));
	    		//$pData['fechaInicio'] = date_format(new DateTime($fechaInicio), 'Y-m-d');
	    		$fechaTermino = $this->input->post('fechaTermino', TRUE);
	    		$fechaTermino =  str_replace('/', '-', $fechaTermino);
	    		$pData['fechaTermino'] = date('Y-m-d', strtotime($fechaTermino));
	    		//$pData['fechaTermino'] = date_format(new DateTime($fechaTermino), 'Y-m-d');
	    		$pData['status'] = 1;
	    		$pData['checked'] = 0;
	    		$pData['statusCumplido'] = 0;
	    		$pData['statusAlert'] = 0;
	    		$pData['idFraccionamiento'] = $_SESSION[$this->nsession]['idFraccionamiento'];

	    		//Delegados del sistema
	    		$usuarios = $_POST['usuarios'];
	    		$idUsuarios = '';
	    		if (is_array($usuarios) && count($usuarios)>0){
	    			for ($i=0; $i < count($usuarios); $i++) {
	    				# code...
	    				$idUsuarios .= $usuarios[$i]." ";
	    			}
	    		}

	    		$pData['idUsuario'] = substr($idUsuarios, 0, -1);

	    		//Otros Delegados
    			$emailOtros = $_POST['emailOtros'];
    			$nombreOtros = $_POST['nombreOtros'];
    			$emailsO = '';
    			$nombreO = '';
    			if (is_array($emailOtros) && count($emailOtros)>0){
    				for ($i=0; $i < count($emailOtros); $i++) {
    					if ($emailOtros[$i] !=''){
    						$emailsO .= $emailOtros[$i].",";
    						$nombreO .= $nombreOtros[$i].", ";
    					}
    				}
    			}
    			$pData['nombreOtros'] = ($nombreO!='')?substr($nombreO, 0, -2):'';
    			$pData['emailOtros'] = ($emailsO!='')?substr($emailsO, 0, -1):'';

	    		//echo $nombreO." - ".$emailsO."<br>";
	    		/* echo "<pre>";
	    		print_r($pData);
	    		echo "</pre>";
	    		exit();*/

	    		// print_r($pData); exit();
	    		$id = $this->mblackboard->insertar($pData);

	    		$autores = $this->autoRespuesta($id, 'Nuevo Pendiente  |  Blackboard', 'Nuevo Pendiente');

	    		redirect($this->router->class);
	    	}
	    }

	    public function multiple(){
	    	$data['q'] = '';
	    	$pData = array();
	    	if(isset($_POST['proyecto'])){

	    		$arrayProyectos = (isset($_POST["proyecto"])) ? $_POST["proyecto"] : [];
	    		$delegado = $this->input->post('delegado', TRUE);
	    		$fechaInicio = (isset($_POST["fechaInicio"])) ? $_POST["fechaInicio"] : [];
	    		$fechaTermino = (isset($_POST["fechaTermino"])) ? $_POST["fechaTermino"] : [];
	    		$asunto = (isset($_POST["asunto"])) ? $_POST["asunto"] : [];
	    		$mail = (isset($_POST["mail"])) ? $_POST["mail"] : [];				    		
				/*
				echo "<pre>";
	    		print_r($_POST);
	    		echo "</pre><br><br>";*/
	    		foreach ($arrayProyectos as $key => $row) {
	    			if($row!='0'){ //validamos para obtener solamente los apartados donde se seleccionó un proyecto
	    				//echo $key."<br>";
	    				$pData['proyecto'] = $row;
	    				$fechaIni = $fechaInicio[$key];
    					$fechaIni =  ($fechaIni!='' && $fechaIni!='0000-00-00')?str_replace('/', '-', $fechaIni):null;
	    				$pData['fechaInicio'] = ($fechaIni!=null)?date('Y-m-d', strtotime($fechaIni)):null;
	    				$fechaTerm = $fechaTermino[$key];
			    		$fechaTerm =  ($fechaTerm!='' && $fechaTerm!='0000-00-00')?str_replace('/', '-', $fechaTerm):null;
			    		$pData['fechaTermino'] = ($fechaTerm!=null)?date('Y-m-d', strtotime($fechaTerm)):null;
			    		$pData['asunto'] = $asunto[$key];
			    		$pData['mail'] = $mail[$key];

			    		$pData['status'] = 1;
			    		$pData['checked'] = 0;
			    		$pData['statusCumplido'] = 0;
			    		$pData['statusAlert'] = 0;
			    		$pData['idFraccionamiento'] = $_SESSION[$this->nsession]['idFraccionamiento'];

			    		//Delegados del sistema
			    		$usuarios = $_POST['usuarios'];
			    		$idUsuarios = '';
			    		if (is_array($usuarios[$key]) && count($usuarios[$key])>0){
			    			for ($i=0; $i < count($usuarios[$key]); $i++) {
			    				$idUsuarios .= $usuarios[$key][$i]." ";
			    			}
			    		}
			    		$pData['idUsuario'] = substr($idUsuarios, 0, -1);
			    		//Otros Delegados
		    			$emailOtros = $_POST['emailOtros'];
		    			$nombreOtros = $_POST['nombreOtros'];
		    			$emailsO = '';
		    			$nombreO = '';
		    			if (is_array($emailOtros[$key]) && count($emailOtros[$key])>0){
		    				for ($i=0; $i < count($emailOtros[$key]); $i++) {
		    					if ($emailOtros[$key][$i] !=''){
		    						$emailsO .= $emailOtros[$key][$i].",";
		    						$nombreO .= $nombreOtros[$key][$i].", ";
		    					}
		    				}
		    			}
		    			$pData['nombreOtros'] = ($nombreO!='')?substr($nombreO, 0, -2):'';
		    			$pData['emailOtros'] = ($emailsO!='')?substr($emailsO, 0, -1):'';

		    			$id = $this->mblackboard->insertar($pData);

	    				$autores = $this->autoRespuesta($id, 'Nuevo Pendiente  |  Blackboard', 'Nuevo Pendiente');
	    		
						/*						
						echo "<pre>";
			    		print_r($pData);
		    			echo "</pre><br><br>";*/
	    			}
	    			
	    		}
	    		//exit();
	    		if(isset($id) && $id>0){
	    			redirect($this->router->class);
	    		}
	    		//exit();
	    	}
	    	$data['usuarios'] = $this->musuario->getAll();
    		$data['fraccionamientos'] = $this->mfraccionamiento->getAll();
	    	$this->data['contenido'] = $this->load->view($this->mainView.'/multiple_view',$data,true);
			$this->load->view('templates/main_template',$this->data);
	    }

	    public function editar_( $id = null ) {
	    	$msg = "";

	    	$this->load->library('form_validation');
	    	if ($this->form_validation->run($this->fv) == FALSE) {
	    		$data = $this->mblackboard->getById($id);
	    		$data['msg'] = validation_errors();

	    		$this->data['contenido'] = $this->load->view($this->mainView.'/editar_view',$data,true);
				$this->load->view('templates/main_template',$this->data);
	    	}
	    	else {
	    		$pData['asunto'] = $this->input->post('asunto', TRUE);
	    		$pData['proyecto'] = $this->input->post('proyecto', TRUE);
	    		$pData['delegado'] = $this->input->post('delegado', TRUE);
	    		$fechaInicio = $this->input->post('fechaInicio', TRUE);
	    		$pData['fechaInicio'] = date_format(new DateTime($fechaInicio), 'Y-m-d');
	    		$fechaTermino = $this->input->post('fechaTermino', TRUE);
	    		$pData['fechaTermino'] = date_format(new DateTime($fechaTermino), 'Y-m-d');
	    		$pData['status'] = $this->input->post('status', TRUE);
	    		$pData['idFraccionamiento'] = $_SESSION[$this->nsession]['idFraccionamiento'];
	    		print_r($pData);
	    		exit();
	    		// $upd = $this->mblackboard->actualizar($pData, $id);
	    		// redirect($this->router->class);
	    	}
	    }

	    public function editar($id)
	    {
	        // Mensajes
	        $msg = '';

	        /* VALIDAR FORMULARIO*/
	        $this->load->library('form_validation');

	        if (isset($_POST['asunto'])) {
	            if ($this->form_validation->run($this->fv) == FALSE) {
	                $msg = validation_errors();
	                // print_r( $msg);exit();
	            } else {
	                $pData['asunto'] = $this->input->post('asunto', TRUE);
		    		$pData['proyecto'] = $this->input->post('proyecto', TRUE);
		    		$pData['delegado'] = $this->input->post('delegado', TRUE);
		    		$fechaInicio = $this->input->post('fechaInicio', TRUE);
	    			$fechaInicio =  str_replace('/', '-', $fechaInicio);
	    			$pData['fechaInicio'] = date('Y-m-d', strtotime($fechaInicio));
		    		$fechaTermino = $this->input->post('fechaTermino', TRUE);
	    			$fechaTermino =  str_replace('/', '-', $fechaTermino);
	    			$pData['fechaTermino'] = date('Y-m-d', strtotime($fechaTermino));
		    		$pData['idFraccionamiento'] = $_SESSION[$this->nsession]['idFraccionamiento'];
		    		$pData['mail'] = (substr($this->input->post('mail', TRUE), -1)==',')?substr($this->input->post('mail', TRUE), 0, -1):$this->input->post('mail', TRUE);//$this->input->post('mail', TRUE);


		    		//Delegados del sistema
		    		$usuarios = $_POST['usuarios'];
		    		$idUsuarios = '';
		    		if (is_array($usuarios) && count($usuarios)>0){
		    			for ($i=0; $i < count($usuarios); $i++) {
		    				# code...
		    				$idUsuarios .= $usuarios[$i]." ";
		    			}
		    		}
		    		$pData['idUsuario'] = substr($idUsuarios, 0, -1);
		    		//Otros Delegados
	    			$emailOtros = $_POST['emailOtros'];
	    			$nombreOtros = $_POST['nombreOtros'];
	    			$emailsO = '';
	    			$nombreO = '';
	    			if (is_array($emailOtros) && count($emailOtros)>0){
	    				for ($i=0; $i < count($emailOtros); $i++) {
	    					if ($emailOtros[$i] !=''){
	    						$emailsO .= $emailOtros[$i].",";
	    						$nombreO .= $nombreOtros[$i].", ";
	    					}
	    				}
	    			}
	    			$pData['nombreOtros'] = ($nombreO!='')?substr($nombreO, 0, -2):'';
	    			$pData['emailOtros'] = ($emailsO!='')?substr($emailsO, 0, -1):'';

		    		//$pData['status'] = $this->input->post('status', TRUE);
		    		// print_r($pData); exit();
		    		$emailOld = $this->mblackboard->getCampo('mail',$id);
		    		$emailOldOtros = $this->mblackboard->getCampo('emailOtros',$id);
	                $this->mblackboard->actualizar($pData, $id);
		    		if ( $emailOld != $pData['mail'] || $emailOldOtros != $pData['emailOtros']) {
		    			$autores = $this->autoRespuesta($id, 'Nuevo Pendiente  |  Blackboard', 'Nuevo Pendiente');
		    			//echo "distinto";exit();
		    		}
	                redirect($this->router->class);
	            }
	        }
	        // Obteniendo la información
	        $info = $this->mblackboard->getById($id);
	        $data = $info;
	        $data['msg']=$msg;
	        $data['usuarios'] = $this->musuario->getAll();

	        $exp = explode(' ', (!is_numeric($info))?$info['idUsuario']:0);
	        //print_r($exp);exit();
	        //echo $info['idUsuario'];exit();
	        $setUsuario = $this->musuario->getDelegadosBlackboard($exp);
	        //print_r($setUsuario->result());exit();
	        $data['setUsuario'] = '';
	        if (!is_numeric($setUsuario)){
	            foreach ($setUsuario->result() as $su) {
	                $data['setUsuario'] .= "-".$su->id;
	            }
	        }
	        //print_r($data);exit();
	        $data['fraccionamientos'] = $this->mfraccionamiento->getAll();

	        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
	        $this->load->view('templates/main_template', $this->data);
	    }

	    public function activarDesactivar($id = null,$checked = null){
	    	// $id = $this->input->post('id', TRUE);
	    	// $checked = $this->input->post('checked', TRUE);
	    	if ( $id > 0 && !is_null($id) ) {
	    		$pData['checked'] = $checked;
	    		$pData['statusAlert'] = 1;
	    		$this->mblackboard->actualizar($pData,$id);

	    		$autores = $this->autoRespuesta($id, 'Finalización de pendiente  |  Blackboard', 'Finalización de pendiente');


	    		$data['autorespuesta'] = $autores;
	    		$data['success'] = 1;
	    	}else{
	    		$data['success'] = 0;
	    	}
	    	$data['id'] = $id;
	    	// echo json_encode($data);
	    	return $data;
	    }

	    public function activarDesactivar2($id = null,$checked = null){
	    	// $id = $this->input->post('id', TRUE);
	    	// $checked = $this->input->post('checked', TRUE);
	    	if ( $id > 0 && !is_null($id) ) {
	    		$pData['statusCumplido'] = $checked;
	    		// $pData['statusAlert'] = 1;
	    		$this->mblackboard->actualizar($pData,$id);

	    		$autores = $this->autoRespuesta($id, 'Tarea completada  |  Blackboard', 'Tarea cumplida');


	    		$data['autorespuesta'] = $autores;
	    		$data['success'] = 1;
	    	}else{
	    		$data['success'] = 0;
	    	}
	    	$data['id'] = $id;
	    	// echo json_encode($data);
	    	return$data;
	    }


		public function autoRespuesta( $idBlackboard = null, $subject = null, $titulo = null ) {
	        /*$copiasNV = "sistemas@viviend.mx,";
	        $copiasNV .= "ruben@navegantes.mx";*/
	        $copiasNV = 'hsalinas@viviend.mx'. ', ';
	        $copiasNV .= 'mejora@viviend.mx'. ', ';
	        $copiasNV .= 'sistemas@viviend.mx'. ', ';
	        $copiasNV .= 'esalinas@viviend.mx';

	        // $para = $emailCliente; // Comprador

	        $subject = $subject;//'Viviend - ' .

	        $liga="http://viviend.mx/sistema/emailresources/";
	        $liga2="http://viviend.mx/sistema/img/";
	        $liga3="http://viviend.mx/sistema/";
	        $tp = '';

	        $data = array();

	        $blackboard = $this->mblackboard->getById($idBlackboard);


	        $cuerpo = '<table id="table-blackboard" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
	        				<tbody>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Asunto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['asunto'].' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Proyecto: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['proyecto'].' </td>
	                            </tr>
	        					<!--<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre Delegado: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$blackboard['delegado'].' </td>
	                            </tr>-->
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de inicio: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').' </td>
	                            </tr>
	        					<tr>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de termino: </td>
	                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').' </td>
	                            </tr>
	        				</tbody>
	        			</table>
	        			<!--<span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Asunto: '.$blackboard['asunto'].'
	                    </span><br>
	                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Proyecto: '.$blackboard['proyecto'].'
	                    </span><br>
	                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Nombre Delegado: '.$blackboard['delegado'].'
	                    </span><br>
	                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Fecha de inicio: '.date_format(new DateTime($blackboard['fechaInicio']), 'd-m-Y').'
	                    </span><br>
	                    <span class="lato-light" style="color: #7b7a7a; font-size: 18px; text-decoration: none; width: 100%;">
	                        Fecha de termino: '.date_format(new DateTime($blackboard['fechaTermino']), 'd-m-Y').'
	                    </span><br>-->';


	        $mensaje = '
	        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	        <html xmlns="http://www.w3.org/1999/xhtml">
	        <head>
	            <title>Email</title>
	            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
	            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
	            <style>
	                body, tr, td, span, div, p, a, li {
	                    -moz-text-size-adjust:none !important;
	                    -webkit-text-size-adjust:none !important;
	                    margin:0px !important;
	                    -ms-text-size-adjust:none !important;
	                    white-space: wrap;
	                }
	                .lato-light{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 300;
	                }
	                .lato-bold{
	                    font-family: "lato" sans-serif !important;
	                    font-weight: 700;
	                }
	                td img {
	                    display: block;
	                }
	                .ReadMsgBody {
	                    width: 100%;
	                }
	                .ExternalClass * {
	                    line-height: 100%;
	                }
	                @media only screen and (max-width:480px) {
	                    #logosim{
	                        padding:0!important;
	                    }
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 320px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	                @media only screen and (min-width:480px) and (max-width:599px) {
	                    *[class="code4email_wrapper"] {
	                        width: 100% !important;
	                    }
	                    *[class="code4email_main_table"] {
	                        width: 480px !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_hide"] {
	                        display: none !important;
	                    }
	                    *[class="code4email_center"] {
	                        text-align: center !important;
	                        padding:10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_clear"] {
	                        width: 100% !important;
	                        clear: both !important;
	                        float: left !important;
	                    }
	                    *[class="code4email_br"] {
	                        display:block !important;
	                        width: 1px !important;
	                        height:6px !important;
	                        clear: both !important;
	                    }
	                    *[class="code4email_text_p10"] {
	                        padding: 0px 10px 10px 10px !important;
	                        height:20px !important;
	                    }
	                    *[class="code4email_w20"] {
	                        width: 20px !important;
	                    }
	                    *[class="code4email_h20"] {
	                        height: 20px !important;
	                    }
	                    *[class="code4email_h20_center"] {
	                        height: 20px !important;
	                        text-align: center !important;
	                    }
	                }
	            </style>
	        </head>
	        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
	            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
	                <tr>
	                    <td align="center" valign="top" bgcolor="#FFFFFE"><table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
	                        <tr>
	                            <td>
	                                <a href="'.$liga3.'" target="_blank">
	                                    <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
	                                        <tr>
	                                            <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
	                                                <img src="'.$liga2.'logo-300.png" />
	                                            </td>
	                                        </tr>
	                                    </table>
	                                </a>
	                            </td>
	                        </tr>
	                        <tr>
	                            <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
	                                <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
	                                    <tr>
	                                        <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center"><span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">
	                                            <!--<h1 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;">'.$titulo.'</h1>-->
	                                            <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> '.$titulo.' </h3>
	                                            <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> <!--De--> '.$blackboard['delegado'].' </h4>
	                                            <br><br>
	                                            '.$cuerpo.'
	                                        </td>
	                                    </tr>
	                                </table>
	                                <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
	                            </td>
	                        </tr>
	                    </td>
	                </tr>
	            </table>
	        </body>
	        </html>';

	        // para el gerente de ventas -------------------------------------------------
	        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
	        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
	        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

	        // $para = "sistemas@viviend.mx";
	        $para = $blackboard['mail'];
	        $para.= ($blackboard['emailOtros']!='')?",".$blackboard['emailOtros']:'';

	        // Cabeceras adicionales
	        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";
	        if ($para != null){
	            mail($para, $subject, $mensaje, $cabeceras);
	        }

	        $subject2 = $subject;

	        // para el gerente  -------------------------------------------------
	        $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
	        $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

	        // Cabeceras adicionales
	        $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

	        // para el administrador
	        mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);

	        return true;
	    }

	    public function eliminar(){
	        $id = $this->input->post('elid');
	        $q = $this->mblackboard->getById($id);
	        $cValor = "true";
	        $this->mblackboard->borrar($id);
	        $data = json_encode(array("valor" => $cValor));
	        echo $data;
	    }

	    public function aplicarCambios() {
	    	$finish = (isset($_POST["finish"])) ? $_POST["finish"] : [];
	    	$complete = (isset($_POST["complete"])) ? $_POST["complete"] : [];
	    	$response =array(
	    		"finish" => [],
	    		"complete" => []
	    	);

	    	// update finish
	    	if ( $finish != [] ) {
	    		foreach ($finish as $pos) {
		    		$response['finish'][] = $this->activarDesactivar($pos, 1);
		    	}
	    	}

	    	// update complete
	    	if ( $complete != [] ) {
	    		foreach ($complete as $pos) {
		    		$response['complete'][] = $this->activarDesactivar2($pos, 1);
		    	}
	    	}
	    	$response['success'] = TRUE;
	    	echo json_encode($response);
	    }
	}

?>