<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Arranque extends MX_Controller {
    public $data,$vParameters,$mainView,$fv;
    public function __construct(){
    $this->nsession = $this->config->item('nsession');
    if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'arranque'; // form validation variable
            $this->mainView = 'arranque';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/arranque/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">';
            // Tools
            $this->load->helper(array('tools','numeros','url','form','date','text','security'));
            // Modelos
            $this->load->model(array('mactividadmo','musuario','munidades','mcategoriamo','marranque','mpaquete', 'mfraccionamiento', 'mmanoobra', 'mmaterial', 'mestimacionprograma', 'mdetallepaquete','mprototipos','mpresupuestomat','mpresupuestomo', 'malmacenes','mproyecto','maltaventa','mprospecto', 'mconstructores'));
            $this->config->set_item('rol', $_SESSION[$this->nsession]['rol']);
            // Lbrerias
            // $this->load->library(array('email','session'));
            $this->data['fotos_www'] = $this->config->item('base_www').'/arranque/';
           // $this->data['fotos_www'] = '/home/puntapro/www/uploads/inicio/';

           //Validación de usuarios
           $this->config->set_item('rol',$_SESSION[$this->nsession]['rol']);
           //$this->allowed=sesiones($this->uri->segment(2),$_SESSION[$this->nsession]['rol'],permisos($this->fv));
						valSession("obra",$this->fv);
    }

    public function index(){
        $data['q'] = '';
        /*$data['notificacion'] = '';
        $data['showNotification'] = 0;
        $data['isTable'] = 0;
        if(isset($_SESSION['notificacion']) && isset($_SESSION['showNotification'])){
            $data['notificacion'] = $_SESSION['notificacion'];
            $data['showNotification'] = json_decode($_SESSION['showNotification']);
            $data['isTable'] = json_decode($_SESSION['isTable']);
            unset($_SESSION['notificacion']);
            unset($_SESSION['showNotification']);
            unset($_SESSION['isTable']);
        }*/
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function formatos($id){
        $data['q'] = '';
        $data['id'] =$id;
        $this->data['contenido'] = $this->load->view($this->mainView.'/formatos_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
    }

    public function listado(){
        $q = $this->marranque->getAll();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $editar = true;
                $encurso = false;
                $finalizado = false;
                switch ($row->estatus_arranque) {
                    case 1:
                        $editar = true;
                        $count = 0;
                        /*$countIdPaq = explode(',', $row->idPaquetes);
                        $countArray = count($countIdPaq);

                        foreach ($countIdPaq as $key => $value) {
                            $qPaquete = $this->mpaquete->getById($value);
                            if(!is_numeric($qPaquete)){
                                $manoObra = $this->mmanoobra->getById($qPaquete['idManoObra']);
                                $material = $this->mmaterial->getByIdPaquete($qPaquete['id']);
                                $estimacion = $this->mestimacionprograma->getByIdPaquete($qPaquete['id']);
                                $detallePaquete = $this->mdetallepaquete->getByIdPaquete($qPaquete['id']);

                                if($manoObra['id'] != '' && $material['id'] != '' && $estimacion['id'] != '' && $detallePaquete->num_rows() > 0){
                                    $count++;
                                }
                            }
                        }

                        if($count == $countArray){
                            $encurso = true;
                        }*/
                        $encurso = true;
                        $finalizado = false;
                        break;
                    case 2:
                        $editar = false;
                        $encurso = false;
                        $finalizado = true;
                        break;
                    case 3:
                        $editar = false;
                        $encurso = false;
                        $finalizado = false;
                        break;
                }

                $paquetes = explode( ',', $row->idPaquetes);
                $ids = '';
                $i = 0;
                $nompaquetes = '';
                $totalArranque = 0;
                $totalArranqueMAT = 0;
                $totalArranqueMO = 0;
                foreach ($paquetes as $paq) {
                    $nompaquetes .= $this->mpaquete->getCampo('titulo',$paq).",";
                    $rango_lotes = $this->mpaquete->getCampo('rango_lotes', $paq);
                    if( !empty($rango_lotes) ){
                        $lotesManzana = contarLotesManzanas($rango_lotes);
                        $lotes = $lotesManzana['total'];
                        $qMaterial = $this->mmaterial->getByIdPaquete($paq);
                        if(!is_numeric($qMaterial)){
                            $totalUnitarioMAT = $this->mpresupuestomat->getSumTotalUnitario($row->id);
                            $totalPMAT = $totalUnitarioMAT * $lotes;
                        } else{
                            $totalPMAT = 0;
                        }
                        $idMO = $this->mpaquete->getCampo('idManoObra', $paq);
                        $totalUnitarioMO = $this->mpresupuestomo->getSumTotalUnitario($idMO);
                        $totalPMO = $totalUnitarioMO * $lotes;
                    } else {
                        $totalPMAT = 0;
                        $totalPMO = 0;
                    }
                    $totalArranqueMAT = $totalPMAT + $totalArranqueMAT;
                    $totalArranqueMO = $totalArranqueMO + $totalPMO;
                }
                $totalArranque = $totalArranqueMAT + $totalArranqueMO;

                $array['aaData'][] = array(
                    'titulo' => $row->titulo,
                    'idPaquetes' => substr($nompaquetes, 0, -1),
                    'numeroContrato' => $row->numeroContrato,
	               	'totalMO' => precio_format($totalArranqueMO),
	               	'totalMat' => precio_format($totalArranqueMAT),
	                'totalArranque' => precio_format($totalArranque),
                    'estatusArranque' => bgStatus($row->estatus_arranque),
                    'fecha_inicio' => ($row->fecha_inicio!='0000-00-00' && $row->fecha_inicio!='')?date('d/m/Y',strtotime($row->fecha_inicio)):'',
                    'fecha_fin' => ($row->fecha_fin!='0000-00-00' && $row->fecha_fin!='')?date('d/m/Y',strtotime($row->fecha_fin)):'',
                    'acciones' => (in_array($_SESSION[$this->nsession]['rol'], permisos("obra","arranque")['w']))? accionesArranque($row->id,$this->router->class,true, $editar, true,true, $encurso, $finalizado) : ''
                    );
            }
        } else{
            $array['aaData'][] = array(
                'titulo' => 'No hay registros',
                'idPaquetes' => 'No hay registros',
                'numeroContrato' => 'No hay registros',
                'totalMO' => 'No hay registros',
                'totalMat' => 'No hay registros',
                'totalArranque' => 'No hay registros',
                'estatusArranque' => 'No hay registros',
                'fecha_inicio' => 'No hay registros',
                'fecha_fin' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }
        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $data['paketes'] = '';
        $data['msg'] = '';
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();

            $data['paquetes']= $this->mpaquete->getSelectResult();
           /*     echo '<pre>'; print_r($data['paquetes']->result()); exit();*/
            $data['categoria']= $this->mcategoriamo->getSelectResult();
            $data['residentes']  = $this->musuario->getResidentesByPaquetes();
            $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
            $this->load->view('templates/main_template', $this->data);
        } else {
            $pData['titulo'] = $this->input->post('titulo', TRUE);
            $paketes = $_POST["paketes"];
                /*echo '<pre>'; print_r($paketes); exit();*/
            $pData['idSupervisor'] = $this->input->post('idSupervisor', TRUE);
            $pData['retencionfg'] = $this->input->post('retencionfg', TRUE);

            $fecha_inicio = $this->input->post('fecha_inicio', TRUE);
            $fecha_inicio =  str_replace('/', '-', $fecha_inicio);
            $pData['fecha_inicio'] = ($fecha_inicio!='')?date('Y-m-d', strtotime($fecha_inicio)):'0000-00-00';

            $fecha_fin = $this->input->post('fecha_fin', TRUE);
            $fecha_fin =  str_replace('/', '-', $fecha_fin);
            $pData['fecha_fin'] = ($fecha_fin!='')?date('Y-m-d', strtotime($fecha_fin)):'0000-00-00';

            $fechaFirma = $this->input->post('fechaFirma', TRUE);
            $fechaFirma =  str_replace('/', '-', $fechaFirma);
            $pData['fechaFirma'] = ($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):'0000-00-00';

            $push_paketes = array();
            if (is_array($paketes) && !empty($paketes) && count($paketes)>0){
                $i=0;
                $pData['idPaquetes'] = '';
                foreach ($paketes as $t) {
                    $pData['idPaquetes'] .= ($i==0 ) ? $t : ",".$t;
                    $i+=1;
                }
                $idMO = $this->mpaquete->getCampo('idManoObra', $t);
                array_push($push_paketes, $paketes);
            }
            $fraccionamiento = $this->mfraccionamiento->getCampo("titulo", $this->mmanoobra->getCampo("idFraccionamiento", $idMO) );

            $this->db->query("UPDATE paquetes SET porcentaje_retencion=".$pData['retencionfg']." WHERE id IN (".$pData['idPaquetes'].")");
            $pData['status'] = 1;
            $pData['estatus_arranque'] = 1;
            $id = $this->marranque->insertar($pData);
            $uData['numeroContrato'] = strtoupper(substr($fraccionamiento, 0, 3) ) . date('d', strtotime($fechaFirma)) . date('m', strtotime($fechaFirma)) . substr(date('Y', strtotime($fechaFirma)), -2) . '-' . $id;
            $this->marranque->actualizar($uData, $id);
            redirect($this->router->class);
        }
    }

    public function editar($id)
    {
        $info = $this->marranque->getById($id);
        //echo '<pre>'; print_r($info); exit();
        $data = $info;
        $data['paketes'] = '';
        $msg = '';
        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        /*if (isset($_POST['clave'])) {*/
           /*     echo $_POST['clave']; exit();*/
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
            } else {
                 /*   $data['paketes'] = '';*/
                    $pData['titulo'] = $this->input->post('titulo', TRUE);
                   /*     echo $pData['titulo']; exit();*/
                    /*$pData['idPaquetes'] = $this->input->post('idPaquetes', TRUE);  */
                    $paketes = $_POST["paketes"];
                   /* echo $paketes; exit();*/
                    $pData['numeroContrato'] = $this->input->post('numeroContrato', TRUE);
                    $pData['idSupervisor'] = $this->input->post('idSupervisor', TRUE);
                    $pData['retencionfg'] = $this->input->post('retencionfg', TRUE);

                    $fecha_inicio = $this->input->post('fecha_inicio', TRUE);
                    $fecha_inicio =  str_replace('/', '-', $fecha_inicio);
                    $pData['fecha_inicio'] = ($fecha_inicio!='')?date('Y-m-d', strtotime($fecha_inicio)):'0000-00-00';

                    $fecha_fin = $this->input->post('fecha_fin', TRUE);
                    $fecha_fin =  str_replace('/', '-', $fecha_fin);
                    $pData['fecha_fin'] = ($fecha_fin!='')?date('Y-m-d', strtotime($fecha_fin)):'0000-00-00';

                    $fechaFirma = $this->input->post('fechaFirma', TRUE);
                    $fechaFirma =  str_replace('/', '-', $fechaFirma);
                    $pData['fechaFirma'] = ($fechaFirma!='')?date('Y-m-d', strtotime($fechaFirma)):'0000-00-00';

                    if (is_array($paketes) && !empty($paketes) && count($paketes)>0){
                        $i=0;
                        foreach ($paketes as $t) {
                            $pData['idPaquetes'] .= ($i==0 ) ? $t : ",".$t;
                            $i+=1;
                        }
                        array_push($paketes);
                    }
                $this->db->query("UPDATE paquetes SET porcentaje_retencion=".$pData['retencionfg']." WHERE id IN (".$pData['idPaquetes'].")");
                redirect($this->router->class."?close");
            }
            // Mensajes
       /* } */
        // Obteniendo la información
        $data['residentes']  = $this->musuario->getResidentesByPaquetes();
        $data['paketes']  = str_replace(",", "-", $this->marranque->getCampo('idPaquetes',$id));
        $data['msg']=$msg;
        $data['unidad']= $this->munidades->getSelectResult();
        $data['categoria']= $this->mcategoriamo->getSelectResult();
        $data['paquetes']= $this->mpaquete->getSelectResult();

        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

     public function ver($id){
        // Obtenemos la informacion de arranque por id
         $info = $this->marranque->getById($id);

        $ids[] = 0;
        $temp = explode(',', $info['idPaquetes']);
        if( !empty($temp[0]) ){
            foreach($temp as $v){
                if( !in_array($v, $ids, true) && is_numeric($v)){
                    $ids[] = $v;
                }
            }
        }

        $data['rows'] = '';
        $paquetes = $this->mpaquete->getInIds($ids);

         $sum = 0;
        foreach ($paquetes->result() as $row) {
            $idPrototipo = $this->mmanoobra->getCampo('idPrototipo',$row->idManoObra);
            $idpaquete   = $row->id;
            $fechaFormatIni = ($row->fecha_inicio!='')?date('d/m/Y', strtotime($row->fecha_inicio)):'0000-00-00';
            $fechaFormatFin = ($row->fecha_fin!='')?date('d/m/Y', strtotime($row->fecha_fin)):'0000-00-00';
            $dataInfo['nompaquete']   = strtoupper($row->titulo);
            $dataInfo['idProto']   = $this->mprototipos->getCampo('nombre',$idPrototipo);
            $dataInfo['fechaIni']   = $fechaFormatIni;
            $dataInfo['fechaFin']   = $fechaFormatFin;
            $dataInfo['noViviendas']   = $row->rango_lotes;
            //LLAMAR GET INFO VER
            $getInfo = $this->getInfoVer($idpaquete);
            $sum += ($getInfo != 0) ?  $getInfo['totalEncabezado'] : 0.00;


          if($getInfo != 0){
                $dataInfo['prototipo'] = $getInfo['prototipo'];
                $dataInfo['fraccionamiento'] = $getInfo['fraccionamiento'];
                $dataInfo['rangoLotes'] = $getInfo['rangoLotes'];
                $dataInfo['presupuestoViv'] = $getInfo['presupuestoViv'];
                $dataInfo['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                $dataInfo['total_unitario'] = $getInfo['total_unitario'];
                $dataInfo['total_paquete'] = $getInfo['total_paquete'];
                $dataInfo['costoM2'] = $getInfo['costoM2'];
                $dataInfo['m2Viv'] = $getInfo['m2Viv'];
                $dataInfo['totalEncabezado'] = $sum;
                $dataInfo['pptoTotal'] = $getInfo['pptoTotal'];
                $dataInfo['contratista'] = $getInfo['contratista'];
                //ppt unitario materuales
            }else{
                $dataInfo['prototipo'] = '';
                $dataInfo['fraccionamiento'] = '';
                $dataInfo['rangoLotes'] = '';
                $dataInfo['presupuestoViv'] = '';
                $dataInfo['presupuestoPaq'] = '';
                $dataInfo['total_unitario'] = '';
                $dataInfo['total_paquete'] = '';
                $dataInfo['costoM2'] = '';
                $dataInfo['pptoTotal'] = '';
                $dataInfo['m2Viv'] = '';
                $dataInfo['totalEncabezado'] = '';
                $dataInfo['contratista'] = '';
            }

            $data['rows'] .=  $this->load->view($this->mainView . '/rows_view', $dataInfo, true);

        }

        $data['total'] = $sum;
        $data['info'] = $this->marranque->getById($id);
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->marranque->getById($id);
        $cValor = "true";
        $valorBorrar = $this->marranque->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

   public function getInfoVer($idPaquete)
    {
        $paquete = $this->mpaquete->getById($idPaquete);
        $qManoObra = $this->mmanoobra->getById($paquete['idManoObra']);
        $superficieM2 = $this->mprototipos->getCampo('superficieM2',$qManoObra['idPrototipo']);
        $prototipo = $this->mprototipos->getById($qManoObra['idPrototipo']);
        $qContratista = $this->mconstructores->getById($paquete['idConstructor']);
        $contratista = (!is_numeric($qContratista)) ? $qContratista['nombre'].' '.$qContratista['apellidoP'].' '.$qContratista['apellidoM'] : '';

        $totalPresupuestoMO = $this->mpresupuestomo->getSumTotalUnitario($paquete["idManoObra"]);
        $totalUnitario = $totalPresupuestoMO;
        $lotesManzana = contarLotesManzanas($paquete['rango_lotes']);
        $lotes = $lotesManzana['total'];
        $totalPaquete = $totalUnitario * $lotes;

        $material = $this->mmaterial->getByIdFraccIdProtIdMO($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $idPaquete);
        $detalle = $this->mdetallepaquete->getByIdPaquete($idPaquete);
        // Ppto. Total = Ppto. X paquete mo + Ppto. X paquete mat.
         $totalEncabezado = '';
        if (!is_numeric($paquete) && !is_numeric($prototipo)) {
            $presupuestoViv = (!is_numeric($material))?$this->mpresupuestomat->getSumTotalImporte($material['id']):0;
            //$lotes = (!is_numeric($detalle)) ? $detalle->num_rows() : 0;
            $presupuestoPaq = $presupuestoViv * $lotes;
            $costoM2 = $presupuestoViv / $superficieM2;
            $pptoTotal = $totalPaquete + $presupuestoPaq;
            //$totalEncabezado += $pptoTotal;
            $response = array('prototipo' => $prototipo['titulo'],
                'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                'rangoLotes' => (!is_numeric($detalle))? $detalle->num_rows() : 0,
                'presupuestoViv' => precio_format($presupuestoViv),
                'presupuestoPaq' => precio_format($presupuestoPaq),
                'total_unitario' => "$".number_format($totalUnitario,2),
                'total_paquete' => "$".number_format($totalPaquete,2),
                'pptoTotal' => "$".number_format($pptoTotal,2),
                'costoM2' => precio_format($costoM2),
                'totalEncabezado' => $pptoTotal,
                'm2Viv' => $prototipo['superficieM2'],
                'contratista' => $contratista
            );
        } else {
            $response = 0;
        }
        return $response;
    }

    public function sendNotification($idProyecto, $tipo=5){
        $cuerpo = '';
        $htmlArra = '';
        $textNotif = statusNotif($tipo);
        $imgStatus = imgStatus($tipo);
        $leyendaNotif = leyendaNotif($tipo);
        $leyendaIniciado = leyendaConstruyendo($tipo);
        $logoConstruyendo = logoConstruyendo($tipo);
        $etapa = '';
        $fracc = '';
        $idFraccionamiento = $this->mproyecto->getCampo('idFraccionamiento',$idProyecto);
        $fraccionamiento = $this->mfraccionamiento->getCampo('titulo',$idFraccionamiento );

        $idProspecto = $this->maltaventa->getCampo('idProspecto',$idProyecto);
        $cliente = $this->mprospecto->getCampo('nombre', $idProspecto).' '.$this->mprospecto->getCampo('apellidoP', $idProspecto) .' '.$this->mprospecto->getCampo('apellidoM', $idProspecto);
        $idPromotor = $this->mprospecto->getCampo('idPromotor',$idProyecto);
        $promotor =  $this->musuario->getCampo('nombre', $idPromotor).' '.$this->musuario->getCampo('apellidoP', $idPromotor) .' '.$this->musuario->getCampo('apellidoM', $idPromotor);
        $celular = $this->musuario->getCampo('celular', $idPromotor);
        $info =  $this->mproyecto->getById($idProyecto);
        $lote = $this->mproyecto->getCampo('lote', $idProyecto);
        $manzana = $this->mproyecto->getCampo('manzana', $idProyecto);
        $idPrototipo = $this->mproyecto->getCampo('idPrototipo', $idProyecto);
        $nomPrototipo = $this->mprototipos->getCampo('nombre',$idPrototipo);



        if ($tipo !=5) {
             $etapa = '
                <tr >
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > ETAPA: </td>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow" >'.$textNotif.'</td>
                </tr';
        }

        if ($tipo == 1 || $tipo == 2|| $tipo == 3 || $tipo == 4) {
             $fracc = '
                <tr>
                    <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > FRACCIONAMIENTO: </td>
                    <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$fraccionamiento.'  </td>
                </tr> ';
        }else{
             $fracc = '';
        }

        $cuerpo .= '

                    <tr id="testdiv" >
                        <td style="padding:10px;" class="paddinginfo " >  </td>
                        <td style="padding:10px;" class="paddinginfo " >    </td>
                    </tr>

                    '. $etapa.'

                    <tr >
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;" class="paddinginfo borderyellow greentitle fs-notif" > CLIENTE: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" >  '.strtoupper($cliente).' </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" > ASESOR: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.strtoupper($promotor).'</td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >TEL.PROMOTOR:</td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"   class="paddinginfo borderyellow" > '.$celular.'  </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >   PROTOTIPO: </td>
                        <td  style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$nomPrototipo.'  </td>
                    </tr>
                    '. $fracc.'
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >  LOTE: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow" > '.$lote.'  </td>
                    </tr>
                    <tr>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"  class="paddinginfo borderyellow greentitle fs-notif" >  MANZANA: </td>
                        <td style="color:#248d3b; font-weight:bold;padding:10px;border: 1px solid #f2a930;"    class="paddinginfo borderyellow" >  '.$manzana.' </td>
                    </tr>

                ';




           $htmlArra ='
                        <tr>
                            <td style="padding: 30px 30px 30px 30px;" class="innerpadding borderbottom">
                                <!-- [if (gte mso 9)|(IE)]>
                                <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                    <td>
                                <![endif]-->
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                <tr>
                                    <td>
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                    <td  style="padding:10px;" class="paddinginfo" >
                                                        '.$imgStatus.'

                                                    </td>
                                                    <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaNotif.'
                                                    </td>
                                                </tr>
                                                <br>
                                                '.$cuerpo.'
                                        </table>
                                    </td>
                                </tr>
                                </table>
                                <!--[if (gte mso 9)|(IE)]>
                                    </td>
                                    </tr>
                                </table>
                                <![endif]-->
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 0px 30px 30px 30px;" class="innerpadding borderbottom">

                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                    <tr>
                                        <td>
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td  style="padding:10px;color:#248d3b;font-weight:bold;" class="paddinginfo greentitle" >'.$leyendaIniciado.'
                                                        </td>
                                                    </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>

                            </td>
                        </tr>
                    ';
                    $subject = "HOLA ".$cliente." NOTIFICACIÓN DE ARRANQUE EN CURSO";

                    $destMail = '';

                    $notificacion = email_notificaciones($htmlArra,$subject,'sistemas@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'sistemas@viviend.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'alfredo@navegantes.mx',$logoConstruyendo);
                    $notificacion = email_notificaciones($htmlArra,$subject,'alvaro@navegantes.mx',$logoConstruyendo);
                    // echo $notificacion; exit();
    }


    public function cambioEstatus($id, $estatus)
    {
        if(isset($_SESSION['viv']['idEmpresa'])){ //$_SESSION['viv']['idEmpresa'] != 0     ---Se modifico la validación el 25/08/2021  ---Restaurar para validar correctamente
            $info = $this->marranque->getById($id);
            $msg = array();
            $sesion = 0;
            $isTable = 0;
            $showNotification = 0;
            $seguir = false;
            if($estatus == 2){
                $showNotification = 1;
                $count = 0;
                $modificacion = true; //Se agrego esta linea, cuando se restaure la funcionalidad hay que eliminarlo y descomentar desde $countIdPaq hasta el cierre del foreach  --- 25/08/2021
                /*$countIdPaq = explode(',', $info['idPaquetes']);
                $countArray = count($countIdPaq);
                foreach ($countIdPaq as $key => $value) {
                    $qPaquete = $this->mpaquete->getById($value);
                    if(!is_numeric($qPaquete)){
                        $manoObra = $this->mmanoobra->getById($qPaquete['idManoObra']);
                        $material = $this->mmaterial->getByIdPaquete($qPaquete['id']);
                        $estimacion = $this->mestimacionprograma->getByIdPaquete($qPaquete['id']);
                        $detallePaquete = $this->mdetallepaquete->getByIdPaquete($qPaquete['id']);

                        if($manoObra['id'] != '' && $material['id'] != '' && $estimacion['id'] && $detallePaquete->num_rows() > 0){
                            $count++;
                        }else{
                            $isTable = 1;

                            $msg[$qPaquete['titulo']]['paquete'] = $qPaquete['titulo'];
                            if($manoObra['id'] != ''){
                                $msg[$qPaquete['titulo']]['pmo'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                            }else{
                                $msg[$qPaquete['titulo']]['pmo'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                            }
                            if($material['id'] != ''){
                                $msg[$qPaquete['titulo']]['pmat'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                            }else{
                                $msg[$qPaquete['titulo']]['pmat'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                            }
                            if($estimacion['id'] != ''){
                                $msg[$qPaquete['titulo']]['estimaciones'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                            }else{
                                $msg[$qPaquete['titulo']]['estimaciones'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                            }
                            if($detallePaquete->num_rows() > 0){
                                $msg[$qPaquete['titulo']]['residentes'] = '<i class="fa fa-check" style="color: green;" aria-hidden="true"></i>';
                            }else{
                                $msg[$qPaquete['titulo']]['residentes'] = '<i class="fa fa-times" style="color: red;" aria-hidden="true"></i>';
                            }
                        }
                    }
                }*/

                if($modificacion){ //$count == $countArray    ---Se cambio la validacion se agrego una variable de emergencia --- hay que restaurarlo  --- 25/08/2021
                    $seguir = false;  //Se cambio $seguir = true;     -----------25/08/2021

                    //Se descomento, desde $isTable hasta el actualizar, cuando se restaure la funcionalidad hay que comentarlo de nuevo --- 25/08/2021
                    $isTable = 0;
                    $msg = 'EL ARRANQUE '.$info['titulo'].' SE PONDRÁ EN CURSO';

                    $pData['estatus_arranque'] = 2;
                    $this->marranque->actualizar($pData, $info['id']);
                    $this->insertTasks($id);
                }

                if($seguir){

                    $ids[] = 0;
                    $temp = explode(',', $info['idPaquetes']);
                    if( !empty($temp[0]) ){
                        foreach($temp as $v){
                            if( !in_array($v, $ids, true) && is_numeric($v)){
                                $ids[] = $v;
                            }
                        }
                    }

                    $paquetes = $this->mpaquete->getInIds($ids);

                    $destinatarioMail = correosNotificaciones('arranque');
                   /* print_r ($destinatarioMail); exit();*/
                    $cuerpo = '';
                    $htmlArra = '';
                    $sum = 0;

                    foreach ($paquetes->result() as $row) {
                        $idPrototipo = $this->mmanoobra->getCampo('idPrototipo',$row->idManoObra);
                        $idpaquete   = $row->id;
                        $fechaFormatIni = ($row->fecha_inicio!='')?date('d/m/Y', strtotime($row->fecha_inicio)):'0000-00-00';
                        $fechaFormatFin = ($row->fecha_fin!='')?date('d/m/Y', strtotime($row->fecha_fin)):'0000-00-00';
                        $nompaquete   = strtoupper($row->titulo);
                        $idProto   = $this->mprototipos->getCampo('nombre',$idPrototipo);
                        $fechaIni   = $fechaFormatIni;
                        $fechaFin   = $fechaFormatFin;
                        $noViviendas   = $row->rango_lotes;
                        //LLAMAR GET INFO VER
                        $getInfo = $this->getInfoVer($idpaquete);
                        $sum +=  $getInfo['totalEncabezado'];

                        if($getInfo != 0){
                            $data['prototipo'] = $getInfo['prototipo'];
                            $data['fraccionamiento'] = $getInfo['fraccionamiento'];
                            $data['rangoLotes'] = $getInfo['rangoLotes'];
                            $data['presupuestoViv'] = $getInfo['presupuestoViv'];
                            $data['presupuestoPaq'] = $getInfo['presupuestoPaq'];
                            $data['total_unitario'] = $getInfo['total_unitario'];
                            $data['total_paquete'] = $getInfo['total_paquete'];
                            $data['costoM2'] = $getInfo['costoM2'];
                            $data['m2Viv'] = $getInfo['m2Viv'];
                            $data['totalEncabezado'] = $sum;
                            $data['pptoTotal'] = $getInfo['pptoTotal'];
                            //ppt unitario materuales
                        }else{
                            $data['prototipo'] = '';
                            $data['fraccionamiento'] = '';
                            $data['rangoLotes'] = '';
                            $data['presupuestoViv'] = '';
                            $data['presupuestoPaq'] = '';
                            $data['total_unitario'] = '';
                            $data['total_paquete'] = '';
                            $data['costoM2'] = '';
                            $data['pptoTotal'] = '';
                            $data['m2Viv'] = '';
                            $data['totalEncabezado'] = '';
                        }

                        $cuerpo .= '
                            <tr >
                                <td class="paddinginfo " >  </td>
                                <td class="paddinginfo " >    </td>
                            </tr>
                            <tr >
                                <td class="paddinginfo borderyellow greentitle" > PAQUETE: </td>
                                <td class="paddinginfo borderyellow" > '. $nompaquete.'    </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" > PROTOTIPO: </td>
                                <td class="paddinginfo borderyellow" > '. $idProto.'    </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" >  FECHA INICIO: </td>
                                <td class="paddinginfo borderyellow" > '. $fechaIni.'    </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" >  FECHA FINAL: </td>
                                <td class="paddinginfo borderyellow" > '. $fechaFin.'    </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" >  No. VIVIENDAS: </td>
                                <td class="paddinginfo borderyellow" > '. $data['rangoLotes'] .'    </td>
                            </tr>
                                <tr>
                                <td class="paddinginfo borderyellow greentitle" > PPTO. UNITARIO MO: </td>
                                <td class="paddinginfo borderyellow" >'.$data['total_unitario'].'  </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" > PPTO. X PAQUETE MO: </td>
                                <td class="paddinginfo borderyellow" > '.$data['total_paquete'].' </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" > PPTO. UNITARIO MAT: </td>
                                <td class="paddinginfo borderyellow" > '.$data['presupuestoViv'] .' </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" > PPTO. X PAQUETE MAT: </td>
                                <td class="paddinginfo borderyellow" > '.$data['presupuestoPaq'] .' </td>
                            </tr>
                            <tr>
                                <td class="paddinginfo borderyellow greentitle" > PPTO. TOTAL: </td>
                                <td class="paddinginfo borderyellow" >  '.$data['pptoTotal'].' </td>
                            </tr>
                        ';

                    }   //Termina el foreach

                    $htmlArra ='
                        <tr>
                            <td class="innerpadding borderbottom">
                                <!-- [if (gte mso 9)|(IE)]>
                                <table width="380" align="left" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                    <td>
                                <![endif]-->
                                <table class="col380" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 100%;">
                                <tr>
                                    <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                            <tr>
                                                <td class="paddinginfo greentitle" > </td>
                                                <td class="paddinginfo" >
                                                    <table border="0" cellspacing="0" cellpadding="0">
                                                        <tr>
                                                            <td class="paddingencabezados greentitle" > Arranque: </td>
                                                            <td class="" > '.$info['titulo'].' </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="paddingencabezados greentitle" > N° Contrato: </td>
                                                            <td class="" > '.$info['numeroContrato'].' </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="paddingencabezados greentitle" > Fecha Inicio:</td>
                                                            <td class="" >'.date('d/m/Y', strtotime($info['fecha_inicio'])).'</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="paddingencabezados greentitle" > Total:</td>
                                                            <td class="" >'.precio_format($data['totalEncabezado']).'</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                            <br>
                                            '.$cuerpo.'


                                        <!--  <tr>
                                                <td class="paddinginfo borderyellow greentitle" > PAQUETE: </td>
                                                <td class="paddinginfo borderyellow" > 1    </td>
                                            </tr> -->


                                    </table>
                                    </td>
                                </tr>
                                </table>
                                <!--[if (gte mso 9)|(IE)]>
                                    </td>
                                    </tr>
                                </table>
                                <![endif]-->
                            </td>
                        </tr>
                    ';
                    $subject = $info['titulo'].' '.'En Curso' ;

                    $destMail = $destinatarioMail['to'];

                    $notificacion = email_notificaciones($htmlArra,$subject,$destMail,'');

                    //$url = 'https://www.servercreactivo.com/Clientes/Viviend_Inmobiliaria/';
                    //$url = $notificacion;
                    /*$url = 'https://navegantes.mx/web/viviend/cronjob/notificaciones_etapas/926/1';

                    $data = json_decode(file_get_contents('http://api.rest7.com/v1/html_to_image.php?url=' . $url . '&format=png'));

                    if (@$data->success !== 1)
                    {
                        die('Failed');
                    }
                    $image = file_get_contents($data->file);

                    file_put_contents($this->data['fotos_www'].'/mail_whats.png', $image);*/

                     /*   echo $notificacion; exit();*/



                    require('Almacenes.php');

                    $almacenes = new Almacenes();

                    $mData = array();

                    if(!is_numeric($info)){
                        $array = explode(',', $info['idPaquetes']);
                        $countPq = 0;
                        $countAlmacenes = 0;
                        $msgError = '';
                        foreach ($array as $key => $value) {
                            $qPaquete = $this->mpaquete->getById($value);
                            if(!is_numeric($qPaquete)){
                                $countPq++;
                                $mData['un'] = $_SESSION["viv"]['idEmpresa'];
                                $mData['nombre'] = $qPaquete['titulo'];
                                $mData['nombre_abrev'] = $qPaquete['titulo'];
                                $mData['ciudad_id'] = "0";
                                $mData['cp'] = "";
                                $mData['telefono1'] = "";
                                $mData['telefono2'] = "";

                                $response = $almacenes->addAlmacen($mData);

                                if($response['error'] == false){
                                    if($response['responseObject']){
                                        unset($mData['un']);
                                        $mData['ciudad'] = $mData['ciudad_id'];
                                        unset($mData['ciudad_id']);
                                        $idEmpresa = $_SESSION["viv"]['idEmpresa'];
                                        $mData['idEmpresa'] = $idEmpresa;
                                        $mData['idPaquete'] = $qPaquete['id'];
                                        $mData['id'] = $response['resultado']['id'];

                                        if($this->malmacenes->valInsert($mData['id'],$idEmpresa)){
                                            $idAlmacen = $this->malmacenes->insertar($mData);
                                            $countAlmacenes++;
                                        }
                                    }else{
                                        $msgError .= $response['error_message'].'<br><br>';
                                    }
                                }else{
                                    $msgError .= $response['error_message'].'<br><br>';
                                }
                            }
                        }

                        if($countPq == $countAlmacenes){
                            $isTable = 0;
                            $msg = 'EL ARRANQUE '.$info['titulo'].' SE PONDRÁ EN CURSO';

                            $pData['estatus_arranque'] = 2;
                            $this->marranque->actualizar($pData, $info['id']);

                            /*require('Cronjob.php');
                            $cronjob = new Cronjob();

                            $arrayLotes = $cronjob->getLotes($info['id']);
                            foreach($arrayLotes as $key => $value){
                                $pData2['idProyecto'] = $value['idProyecto'];
                                $pData2['tipo'] = 'arranque';

                                $insert = $cronjob->insertLogsNotifications($pData2);
                            }*/

                        }else{
                            $isTable = 0;
                            $msg = 'ERRORES ECONTRADOS AL CREAR LOS ALMACENES DEL ARRANQUE <br><br><br>'.$msgError;
                        }
                    }
                }

            }else if($estatus == 3){
                $isTable = 0;
                $showNotification = 1;
                $msg = 'EL ARRANQUE '.$info['titulo'].' SE PONDRÁ EN FINALIZADO';
                $pData['estatus_arranque'] = 3;
                $this->marranque->actualizar($pData, $info['id']);
            }
        }else{
            $sesion = 1;
            $isTable = 0;
            $showNotification = 1;
            $msg = 'ES NECESARIO QUE INICIE SESIÓN EN UNA EMPRESA';
        }

        //$_SESSION['notificacion'] = json_encode($msg);
        //$_SESSION['showNotification'] = json_encode($showNotification);
        //$_SESSION['isTable'] = json_encode($isTable);
        $data['notificacion'] = $msg;
        $data['showNotification'] = $showNotification;
        $data['isTable'] = $isTable;
        $data['sesion'] = $sesion;
        // variables para arranque y excedenete
        echo json_encode($data);
        //redirect($this->router->class);
    }

    function insertTasks($idArranque=0){
        $tasks=array(
            array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>0, 'descripcion' => 'arranque', 'tipo' => 1, 'status' => 0),
            array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>1, 'descripcion' => 'obra negra, acabados,entrega', 'tipo' => 2, 'status' => 0),
            //array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>0, 'descripcion' => 'arranque', 'tipo' => 2, 'status' => 0),
            //array('url_func' => 'sendNotifications','idItem' => $idArranque,'periodo'=>1, 'descripcion' => 'obra negra, acabados,entrega', 'tipo' => 2, 'status' => 0),
        );
        if (count($tasks)>0 && !empty($tasks) ) {
            $this->db->insert_batch('tasks', $tasks);
        }
    }
}


