<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Alta_venta extends MX_Controller {
	public $data,$vParameters,$mainView,$fv,$appProduction;

	public function __construct(){
        $this->nsession = $this->config->item('nsession');
        if (!isset($_SESSION[$this->nsession]) || (($_SESSION[$this->nsession]['usuario'] == ""))) redirect('login');
            $this->fv = 'alta_venta'; // form validation variable
            $this->mainView = 'alta_venta';
            $this->data['fjs'] = '';
            $this->data['js'] = ' <script src="assets/js/alta_venta/listado.js" type="text/javascript"></script>';
            $this->data['css'] = '';
            // Tools
            $this->load->helper(array('tools','url','form','date','text','security','numeros'));
            // Modelos
            $this->load->model(array('maltaventa','mprospecto','mproyecto','mfraccionamiento','musuario','mprototipoxfraccionamiento','mfraccionamientoxusuario','mprototipos','mgestoria'));
             $this->appProduction = $this->config->item('appProduction');
            // Lbrerias
            // $this->load->library(array('email','session'));
           	$this->data['fotos_www'] = $this->config->item('base_www').'/alta_venta/';

            // Debugging
            $this->output->enable_profiler(false);

            //Validación de usuarios
            valSession("ventas",$this->fv);
            
            $this->idFraccionamiento = 0;
            $this->urlLogo = '';
    }

    public function setLogo()
    {
        $logoFraccionamiento = $this->mfraccionamiento->getCampo('foto',$this->idFraccionamiento);
        $nomFracc = $this->mfraccionamiento->getCampo('titulo',$this->idFraccionamiento);
        $this->urlLogo = ($logoFraccionamiento!='')?"<img height='80' src='uploads/fraccionamientos/".$logoFraccionamiento."' />":$nomFracc;
    }

    public function index(){
		$data['q'] = '';
        $this->data['contenido'] = $this->load->view($this->mainView.'/index_view',$data,true);
        $this->load->view('templates/main_template',$this->data);
	}

    public function listado(){
        $q = $this->maltaventa->getAll();
        //print_r($q->result()); exit();

        if (!is_numeric($q)){
            foreach ($q->result() as $row){
                $total = $row->monto + $row->subCuenta - $row->gastosOperacion;
                $fechaProspeccion = $this->mprospecto->getCampo('created',$row->idProspecto);
                $calcelarProceso = ($row->statusValidacion<3)?true:false;
                $array['aaData'][] = array(
                    'fraccionamiento' => ($row->idProyecto>0)?$this->mfraccionamiento->getCampo('titulo',$this->mproyecto->getCampo('idFraccionamiento',$row->idProyecto)):'',
                    'promotor' =>strtoupper ($this->musuario->getCampo('nombre',$row->idPromotor).' '.$this->musuario->getCampo('apellidoP',$row->idPromotor)),
                    'nombre' => strtoupper($this->mprospecto->getCampo('nombre',$row->idProspecto)." ".$this->mprospecto->getCampo('apellidoP',$row->idProspecto)),
                    'colonia' => $row->colonia, // colonia prospecto
                    'ciudad' => $row->ciudad,  // ciudad del prospecto
                    'nss' => $this->mprospecto->getCampo('nss',$row->idProspecto),
                    'lote' => ($row->idProyecto>0)?$this->mproyecto->getCampo('lote',$row->idProyecto):'',
                    'manzana' => ($row->idProyecto>0)?$this->mproyecto->getCampo('manzana',$row->idProyecto):'',
                    'nOficial' => ($row->idProyecto>0)?$this->mproyecto->getCampo('nOficial',$row->idProyecto):'',
                    'calle' => ($row->idProyecto>0)?$this->mproyecto->getCampo('calle',$row->idProyecto):'',
                    'monto' => precio_format($row->monto),
                    'subCuenta' => precio_format($row->subCuenta),
                    'gastosOperacion' => precio_format($row->gastosOperacion),
                    'total' => ($total>0)?precio_format($total):"$ ".number_format($total,2),
                    'precioVenta' => precio_format($row->precioVenta),
                    'statusVivienda' => ($row->idProyecto>0)?strtoupper(estatus_proyecto_reporte($this->mproyecto->getCampo('statusVenta',$row->idProyecto))):'',
                    'fechaPreca' => date('d/m/Y',strtotime($row->fechaPreca)),//date_format(new DateTime($row->fechaPreca), 'd-m-Y'),
                    'fechaCambio' => date('d/m/Y',strtotime($row->fechaCambio)),//date_format(new DateTime($row->fechaPreca), 'd-m-Y'),
                    'fecha' => ($row->created!='' && $row->created!='000-00-00')?date('d/m/Y',strtotime($row->created)):'',//fecha alta
                    'fechaProspeccion' => ($fechaProspeccion!='' && $fechaProspeccion!='000-00-00')?date('d/m/Y',strtotime($fechaProspeccion)):'',
                    'lineaCredito' => $row->lineaCredito,
                    'cuv' => $row->cuv,
                    'claveCatastral' => $row->claveCatastral,
                    'empresaTrabajador' => $row->empresaTrabajador,
                    'prototipo' => ($row->idPrototipo>0)?$this->mprototipos->getCampo("nombre",$row->idPrototipo):'',
                    'porcentajeAvance' => $row->porcentajeAvance."%",
                    'acciones' => getSession("ventas","alta_venta_edit") ? acciones($row->id,$this->router->class, true, true, false,'','',false,0,$calcelarProceso) : accionesNoEdit($row->id,$this->router->class)
                    //'acciones' => acciones($row->id,$this->router->class, true, true, false,'','',false,0,$calcelarProceso)
                    );
            }
        } else{
            $array['aaData'][] = array(
                'fraccionamiento' => 'No hay registros',
                'promotor'=> 'No hay registros',
                'nombre' => 'No hay registros',
                'colonia' => 'No hay registros',
                'ciudad' => 'No hay registros',
                'nss' => 'No hay registros',
                'lote' => 'No hay registros',
                'manzana' => 'No hay registros',
                'nOficial' => 'No hay registros',
                'calle' => 'No hay registros',
                'monto' => 'No hay registros',
                'subCuenta' => 'No hay registros',
                'gastosOperacion' => 'No hay registros',
                'total' => 'No hay registros',
                'precioVenta' => 'No hay registros',
                'statusVivienda' => 'No hay registros',
                'fechaPreca' => 'No hay registros',
                'fechaCambio' => 'No hay registros',
                'fecha' => 'No hay registros',
                'fechaProspeccion' => 'No hay registros',
                'lineaCredito' => 'No hay registros',
                'cuv' => 'No hay registros',
                'claveCatastral' => 'No hay registros',
                'empresaTrabajador' => 'No hay registros',
                'prototipo' => 'No hay registros',
                'porcentajeAvance' => 'No hay registros',
                'acciones' => 'No hay registros'
                );

        }

        echo json_encode($array);
    }

    public function nuevo()
    {
        // Mensajes
        $contadorArchivos = 0;
        $data['msg'] = '';
        $data['error'] = '';
        $data['prospectos'] = $this->mprospecto->getNSS();
        $data['infoConyuge'] = $this->input->post('credito', TRUE);
        //$data['proyectos'] = $this->mproyecto->getBySelectResult();
        $this->load->library('form_validation');
        if ($this->form_validation->run($this->fv) == FALSE) {
            $data['msg'] = validation_errors();
            // echo "<pre>"; print_r($data); echo "</pre>"; exit();

        } else {

                // Subida de pdf
            $config = array();
            $this->load->library('upload', $config);

            if (isset($_FILES)){
                $imagenes = array();
                foreach($_FILES as $key=>$value){
                    if ($_FILES[$key]['size'] > 0){
                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                        $imagenes[] = $key;
                    }
                }
                $totalImagenes = count($imagenes);

                for($i=0; $i< $totalImagenes; $i++){
                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                    //Configuracion del thumbnail
                    if($imagenes[$i]!='pdf'){
                        $nCampoC = explode("_",$imagenes[$i]);
                        $tipo = $nCampoC[0];
                        $v = $nCampoC[1];

                    } else {
                        $v = 0;
                        $tipo = 'pdf';
                    }
                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
                        //echo 'es tipo foto<br>';
                        $uploaddir = $this->data['fotos_www'];
                        //$configT['upload_path'] = $uploaddir;
                        //$configT['image_library'] = 'gd2';
                        //$configT['create_thumb'] = TRUE;
                        //$configT['maintain_ratio'] = FALSE;
                        //$configT['width'] = 150;
                        //$configT['height'] = 150;
                        //Configuracion de la libreria upload
                        $nextId = $this->maltaventa->nextId();
                        $config['file_name'] =  $nextId."_".$v;
                        $config['overwrite'] = TRUE;
                        $config['upload_path'] = $uploaddir;
                        $config['max_size'] = '18000';
                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload($imagenes[$i]) )
                        {
                            $redirect = 1;
                            $data['error'] = $this->upload->display_errors();
                        }
                        else
                        {
                            $contadorArchivos++;
                            $dataFile = $this->upload->data($imagenes[$i]);
                            $fotoI = 'pdf_'.$v;
                            //$thumbI = 'thumbnail_'.$v;
                            if ($v == 0){
                                //Foto default
                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                            } else {
                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                            }
                        }
                    }

                }
            }

            //echo $contadorArchivos;
            //exit();

            if ($contadorArchivos==1){
                $pData['idProyecto'] = NULL;//$this->input->post('idProyecto', TRUE);
                $pData['idProspecto'] = $this->input->post('idProspecto', TRUE);
                $pData['descripcion'] = $this->input->post('descripcion', TRUE);
                $pData['monto'] = $this->input->post('monto', TRUE);
                $pData['subCuenta'] = $this->input->post('subCuenta', TRUE);
                $pData['gastosOperacion'] = $this->input->post('gastosOperacion', TRUE);
                $pData['total'] = floatval($pData['monto']) + floatval($pData['subCuenta']) - floatval($pData['gastosOperacion']);
                $fechaPreca = $this->input->post('fechaPreca', TRUE);
                $fechaPreca =  str_replace('/', '-', $fechaPreca);
                $pData['fechaPreca'] = ($fechaPreca!='')?date('Y-m-d', strtotime($fechaPreca)):'0000-00-00';//date_format(new DateTime($fechaPreca),'Y-m-d');
                $pData['diferencia'] = 0.00;
                $pData['bonoEquipamiento'] = 0.00;
                $pData['montoPagare'] = 0.00;
                $pData['fechaCambio'] = date("Y-m-d H:i:s");
                $pData['status'] = 1;

                $id = $this->maltaventa->insertar($pData);

                $created_by = $this->mprospecto->getCampo("idPromotor",$pData['idProspecto']);
                $updateAv = ($created_by!=false)?$this->maltaventa->update($id,array('created_by' =>$created_by,'updated_by' =>$created_by)):'';

                //info de prospecto
                $proData['nombre'] = $this->input->post('nombre', TRUE);
                $proData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                $proData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                $proData['genero'] = $this->input->post('genero', TRUE);
                $proData['curp'] = $this->input->post('curp', TRUE);
                $proData['rfc'] = $this->input->post('rfc', TRUE);
                $proData['telefono'] = $this->input->post('telefono', TRUE);
                $fecha = $this->input->post('fecha', TRUE);
                $fecha =  str_replace('/', '-', $fecha);
                $proData['fecha'] = date('Y-m-d', strtotime($fecha));//date_format(new DateTime($fecha),'Y-m-d');
                $fechaNac = $this->input->post('fechaNac', TRUE);
                $fechaNac =  str_replace('/', '-', $fechaNac);
                $proData['fechaNac'] = date('Y-m-d', strtotime($fechaNac));//date_format(new DateTime($fechaNac),'Y-m-d');
                $proData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);

                $proData['claveElector'] = $this->input->post('claveElector', TRUE);
                $proData['calleProspecto'] = $this->input->post('calleProspecto', TRUE);
                $proData['numeroCasa'] = $this->input->post('numeroCasa', TRUE);
                $proData['numeroInterior'] = $this->input->post('numeroInterior', TRUE);
                $proData['codigoPostal'] = $this->input->post('codigoPostal', TRUE);
                $proData['colonia'] = $this->input->post('colonia', TRUE);
                $proData['ciudad'] = $this->input->post('ciudad', TRUE);
                $proData['empresaTrabajador'] = $this->input->post('empresaTrabajador', TRUE);
                $proData['ocupacion'] = $this->input->post('ocupacion', TRUE);

                //Nuevos datos para
                $proData['nombre2'] = $this->input->post('nombre2', TRUE);
                $proData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
                $proData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
                $proData['rfc2'] = $this->input->post('rfc2', TRUE);
                $proData['telefono2'] = $this->input->post('telefono2', TRUE);
                $proData['claveElector2'] = $this->input->post('claveElector2', TRUE);
                $proData['empresaTrabajador2'] = $this->input->post('empresaTrabajador2', TRUE);
                $fechaNac2 = $this->input->post('fechaNac2', TRUE);
                $fechaNac2 =  str_replace('/', '-', $fechaNac2);
                $proData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';

                $proData['nss2'] = $this->input->post('nss2', TRUE);
                $proData['curp2'] = $this->input->post('curp2', TRUE);
                $proData['celular2'] = $this->input->post('celular2', TRUE);
                $proData['email2'] = $this->input->post('email2', TRUE);
                $proData['nrp2'] = $this->input->post('nrp2', TRUE);
                $proData['telEmpresa2'] = $this->input->post('telEmpresa2', TRUE);
                //Nuevos datos para formato
                $proData['email'] = $this->input->post('email', TRUE);
                $proData['celular'] = $this->input->post('celular', TRUE);
                $proData['regimen'] = $this->input->post('regimen', TRUE);
                $proData['edoCivil'] = $this->input->post('edoCivil', TRUE);
                $proData['credito'] = $this->input->post('credito', TRUE);
                $proData['entidad'] = $this->input->post('entidad', TRUE);
                $proData['entidadNac'] = $this->input->post('entidadNac', TRUE);
                $proData['tipoVivienda'] = $this->input->post('tipoVivienda', TRUE);
                $proData['telEmpresa'] = $this->input->post('telEmpresa', TRUE);
                $proData['nrp'] = $this->input->post('nrp', TRUE);

                $proData['nombreR1'] = $this->input->post('nombreR1', TRUE);
                $proData['apellidoMR1'] = $this->input->post('apellidoMR1', TRUE);
                $proData['apellidoPR1'] = $this->input->post('apellidoPR1', TRUE);
                $proData['telR1'] = $this->input->post('telR1', TRUE);
                $proData['celR1'] = $this->input->post('celR1', TRUE);
                $proData['nombreR2'] = $this->input->post('nombreR2', TRUE);
                $proData['apellidoMR2'] = $this->input->post('apellidoMR2', TRUE);
                $proData['apellidoPR2'] = $this->input->post('apellidoPR2', TRUE);
                $proData['telR2'] = $this->input->post('telR2', TRUE);
                $proData['celR2'] = $this->input->post('celR2', TRUE);



                $this->mprospecto->actualizar($proData, $pData['idProspecto']);
                $pyData['statusVenta'] = 1;
                //$resPry = ($pData['idProyecto']>0)?$this->mproyecto->actualizar($pyData, $pData['idProyecto']):'';

                //$autores = $this->autoRespuesta($pData);

                require('Cronjob.php');
                $cronjob = new Cronjob();
                $pData2['idProyecto'] = 0;
                $pData2['idAltaVenta'] = $id;
                $pData2['tipo'] = 'alta de venta';
                $insert = $cronjob->insertLogsNotifications($pData2);

                redirect($this->router->class);
            }else{
               $data['error'] = '<span style="color:red;">Es necesario subir todos los documentos</span>';
            }


        }

        $this->data['contenido'] = $this->load->view($this->mainView . '/nuevo_view', $data, true);
        $this->load->view('templates/main_template', $this->data);

    }

    public function editar($id)
    {
        // Mensajes
        $msg = '';
        $contadorArchivos = 0;
        $idProyecto_old = $this->maltaventa->getCampo('idProyecto',$id);
        // Obteniendo la información
        $info = $this->maltaventa->getById($id);

        $data = $info;

        /* VALIDAR FORMULARIO*/
        $this->load->library('form_validation');

        if (isset($_POST['nombre'])) {
            if ($this->form_validation->run($this->fv) == FALSE) {
                $msg = validation_errors();
                //print_r($msg);exit();
            } else {

            // Subida de pdf
            $config = array();
            $this->load->library('upload', $config);

            if (isset($_FILES)){
                $imagenes = array();
                foreach($_FILES as $key=>$value){
                    if ($_FILES[$key]['size'] > 0){
                        $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                        $imagenes[] = $key;
                    }
                }
                $totalImagenes = count($imagenes);

                for($i=0; $i< $totalImagenes; $i++){
                    $ext = pathinfo($_FILES[$imagenes[$i]]['name'],PATHINFO_EXTENSION);
                    //Configuracion del thumbnail
                    if($imagenes[$i]!='pdf'){
                        $nCampoC = explode("_",$imagenes[$i]);
                        $tipo = $nCampoC[0];
                        $v = $nCampoC[1];

                    } else {
                        $v = 0;
                        $tipo = 'pdf';
                    }
                    if ($tipo == 'pdf' || $tipo == 'jpg' || $tipo == 'png'){
                        //echo 'es tipo foto<br>';
                        $uploaddir = $this->data['fotos_www'];
                        $nextId = $id;
                        $config['file_name'] =  $nextId."_".$v;
                        $config['overwrite'] = TRUE;
                        $config['upload_path'] = $uploaddir;
                        $config['max_size'] = '18000';
                        $config['allowed_types'] = 'pdf|jpg|jpeg|png|gif';
                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload($imagenes[$i]) )
                        {
                            $redirect = 1;
                            $data['error'] = $this->upload->display_errors();
                        }
                        else
                        {
                            $contadorArchivos++;
                            $dataFile = $this->upload->data($imagenes[$i]);
                            $fotoI = 'pdf_'.$v;
                            //$thumbI = 'thumbnail_'.$v;
                            if ($v == 0){
                                //Foto default
                                $pData['pdf'] = $nextId.'_'.$v.'.'.$ext;//
                            } else {
                                $pData[$fotoI] = $nextId.'_'.$v.'.'.$ext;
                            }
                        }
                    }

                }
            }
            //echo $contadorArchivos;exit();
            //if ($contadorArchivos==6){
                if($idProyecto_old>0){
                    //no actualizamos el id del proyecto si existe en alta venta
                }else{
                    $pData['idProyecto'] = NULL;//$this->input->post('idProyecto', TRUE);
                }

                $pData['idProspecto'] = $this->input->post('idProspecto', TRUE);
                $pData['descripcion'] = $this->input->post('descripcion', TRUE);
                $pData['monto'] = $this->input->post('monto', TRUE);
                $pData['subCuenta'] = $this->input->post('subCuenta', TRUE);
                $pData['gastosOperacion'] = $this->input->post('gastosOperacion', TRUE);
                $pData['total'] = floatval($pData['monto']) + floatval($pData['subCuenta']) - floatval($pData['gastosOperacion']);
                $fechaPreca = $this->input->post('fechaPreca', TRUE);
                $fechaPreca =  str_replace('/', '-', $fechaPreca);
                $pData['fechaPreca'] = ($fechaPreca!='')?date('Y-m-d', strtotime($fechaPreca)):'0000-00-00';
                $pData['diferencia'] = 0.00;
                $pData['bonoEquipamiento'] = 0.00;
                $pData['montoPagare'] = 0.00;
                $statusValidacion_old = $this->maltaventa->getCampo('statusValidacion2', $id);
                if ($statusValidacion_old != $pData['statusValidacion2']){ //validamos si hubo cambio en el status
                    $pData['fechaCambio'] = date("Y-m-d H:i:s");
                }
                //$pData['status'] =$this->input->post('status',TRUE);
                $this->maltaventa->actualizar($pData, $id);
                $created_by = $this->mprospecto->getCampo("idPromotor",$pData['idProspecto']);
                $updateAv = ($created_by!=false)?$this->maltaventa->update($id,array('created_by' =>$created_by,'updated_by' =>$created_by)):'';
                //info de prospecto
                $proData['nombre'] = $this->input->post('nombre', TRUE);
                $proData['apellidoP'] = $this->input->post('apellidoP', TRUE);
                $proData['apellidoM'] = $this->input->post('apellidoM', TRUE);
                $proData['genero'] = $this->input->post('genero', TRUE);
                $proData['curp'] = $this->input->post('curp', TRUE);
                $proData['rfc'] = $this->input->post('rfc', TRUE);
                $proData['telefono'] = $this->input->post('telefono', TRUE);
                $fecha = $this->input->post('fecha', TRUE);
                $fecha =  str_replace('/', '-', $fecha);
                $proData['fecha'] = date('Y-m-d', strtotime($fecha));
                $fechaNac = $this->input->post('fechaNac', TRUE);
                $fechaNac =  str_replace('/', '-', $fechaNac);
                $proData['fechaNac'] = date('Y-m-d', strtotime($fechaNac));
                $proData['statusProspecto'] = $this->input->post('statusProspecto', TRUE);

                $proData['claveElector'] = $this->input->post('claveElector', TRUE);
                $proData['claveElector2'] = $this->input->post('claveElector2', TRUE);
                $proData['calleProspecto'] = $this->input->post('calleProspecto', TRUE);
                $proData['numeroCasa'] = $this->input->post('numeroCasa', TRUE);
                $proData['numeroInterior'] = $this->input->post('numeroInterior', TRUE);
                $proData['codigoPostal'] = $this->input->post('codigoPostal', TRUE);
                $proData['colonia'] = $this->input->post('colonia', TRUE);
                $proData['ciudad'] = $this->input->post('ciudad', TRUE);
                $proData['empresaTrabajador'] = $this->input->post('empresaTrabajador', TRUE);
                $proData['ocupacion'] = $this->input->post('ocupacion', TRUE);
                $proData['empresaTrabajador2'] = $this->input->post('empresaTrabajador2', TRUE);
                //Nuevos datos para  el conyuge
                $proData['nombre2'] = $this->input->post('nombre2', TRUE);
                $proData['apellidoP2'] = $this->input->post('apellidoP2', TRUE);
                $proData['apellidoM2'] = $this->input->post('apellidoM2', TRUE);
                $proData['rfc2'] = $this->input->post('rfc2', TRUE);
                $proData['telefono2'] = $this->input->post('telefono2', TRUE);

                $proData['nss2'] = $this->input->post('nss2', TRUE);
                $proData['curp2'] = $this->input->post('curp2', TRUE);
                $proData['celular2'] = $this->input->post('celular2', TRUE);
                $proData['email2'] = $this->input->post('email2', TRUE);
                $proData['nrp2'] = $this->input->post('nrp2', TRUE);
                $proData['telEmpresa2'] = $this->input->post('telEmpresa2', TRUE);


                $fechaNac2 = $this->input->post('fechaNac2', TRUE);
                $fechaNac2 =  str_replace('/', '-', $fechaNac2);
                $proData['fechaNac2'] = ($fechaNac2!='')?date('Y-m-d', strtotime($fechaNac2)):'0000-00-00';
                //Nuevos datos para formato
                $proData['email'] = $this->input->post('email', TRUE);
                $proData['celular'] = $this->input->post('celular', TRUE);
                $proData['regimen'] = $this->input->post('regimen', TRUE);
                $proData['edoCivil'] = $this->input->post('edoCivil', TRUE);
                $proData['credito'] = $this->input->post('credito', TRUE);
                $proData['entidad'] = $this->input->post('entidad', TRUE);
                $proData['entidadNac'] = $this->input->post('entidadNac', TRUE);
                $proData['tipoVivienda'] = $this->input->post('tipoVivienda', TRUE);
                $proData['telEmpresa'] = $this->input->post('telEmpresa', TRUE);
                $proData['nrp'] = $this->input->post('nrp', TRUE);

                $proData['nombreR1'] = $this->input->post('nombreR1', TRUE);
                $proData['apellidoMR1'] = $this->input->post('apellidoMR1', TRUE);
                $proData['apellidoPR1'] = $this->input->post('apellidoPR1', TRUE);
                $proData['telR1'] = $this->input->post('telR1', TRUE);
                $proData['celR1'] = $this->input->post('celR1', TRUE);
                $proData['nombreR2'] = $this->input->post('nombreR2', TRUE);
                $proData['apellidoMR2'] = $this->input->post('apellidoMR2', TRUE);
                $proData['apellidoPR2'] = $this->input->post('apellidoPR2', TRUE);
                $proData['telR2'] = $this->input->post('telR2', TRUE);
                $proData['celR2'] = $this->input->post('celR2', TRUE);

                $statusVentaOld = ($idProyecto_old>0)?$this->mproyecto->getCampo('statusVenta',$idProyecto_old):0;
                $dProyecto_old['statusVenta'] = 0;
                //if ($idProyecto_old>0){
                if ($idProyecto_old != $pData['idProyecto']){ //Validamos si se hizo cambio de lote
                    //$this->mproyecto->actualizar($dProyecto_old,$idProyecto_old);
                }
                $pyData['statusVenta'] = ($statusVentaOld>0)?$statusVentaOld:1;
                //$resPry = $this->mproyecto->actualizar($pyData, $pData['idProyecto']);

                $this->mprospecto->actualizar($proData, $pData['idProspecto']);

                redirect($this->router->class."?close");
            //}else{
            //   $data['msg'] = 'Es necesario subir todos los documentos';
            //}

            }
        }


        $info2 = $this->mprospecto->getById($data['idProspecto']);
        // print_r($data); exit();
        $data['info_prospeccion'] = $info2;


        //echo $data['info_prospeccion']['idPromotor'];exit();
        $idPromotor = $data['info_prospeccion']['idPromotor'];
        $data['nombre_promotor'] = $this->musuario->getCampo('nombre',$idPromotor)." ".$this->musuario->getCampo('apellidoP',$idPromotor)." ".$this->musuario->getCampo('apellidoM',$idPromotor);
        $data['msg']=$msg;
        $data['prospectos'] = $this->mprospecto->getNSS();
        $data['projectSelected'] = $this->mproyecto->getById($data['idProyecto']);
        // $data['proyectos'] = $this->mproyecto->getBySelectResult();
        $data['fraccionamiento'] = $this->mfraccionamiento->getCampo('titulo',$info2['idFraccionamiento']);
        $data['proyectos'] = $this->mproyecto->getBySelectResult2($info2['idFraccionamiento']);
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $this->data['contenido'] = $this->load->view($this->mainView . '/editar_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }

    public function ver($id = null)
    {
        //Obtenemos el id del Proyecto a aprtir de id alta venta
        $id = $this->maltaventa->getCampo("idProyecto",$id);
        $info = $this->mproyecto->getById($id);
        $data = $info;
        $data['etapa_alta_venta'] = false;
        $data['etapa_validacion_venta'] = false;
        $data['etapa_gestoria'] = false;
        $data['etapa_comisionbono'] = false;
        $data['etapa_autorizaciones'] = false;
        $data['etapa_deposito'] = false;
        $data['etapa_entrega'] = false;
        $data['etapa_encuesta'] = false;
        $data['etapa_postventa'] = false;

        $altaVenta = $this->maltaventa->getStatusByIdProyecto($id);
        $idAltaVenta = $this->maltaventa->getIdAltaVentaByIdProyecto($id);
        $statusProyecto = (!is_numeric($altaVenta))?$altaVenta->row()->statusValidacion:'';


        /*
        switch ($statusProyecto) {
            case '0':
                $data['etapa_alta_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);
                break;
            case '1':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '2':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['detalle_venta'] = $this->maltaventa->getValidacionVentaByIdProy($id);
                break;
            case '3':
            case '4':
            case '5':
                $data['etapa_alta_venta'] = true;
                $data['etapa_validacion_venta'] = true;
                $data['etapa_gestoria'] = true;
                $data['detalle_venta'] = $this->maltaventa->getGestoriaByIdProy($id);

                $comisiones = $this->mcomisionbono->getByIdAV($data['detalle_venta']['id']);//($idAltaVenta->row()->id);
                if ( !is_numeric($comisiones) ) {
                    $data['etapa_comisionbono'] = true;
                    $data['detalle_comisionbono'] = $comisiones;

                }

                $autorizaciones = $this->mautorizacion->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($autorizaciones) ) {
                    $data['etapa_autorizaciones'] = true;
                    $data['detalle_autorizaciones'] = $autorizaciones;
                }

                $deposito = $this->mdeposito->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($deposito) ) {
                    $data['etapa_deposito'] = true;
                    $data['detalle_deposito'] = $deposito;
                }

                $entrega = $this->mentrega->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_entrega'] = true;
                    $data['detalle_entrega'] = $entrega;
                }

                $encuesta = $this->mencuestavivienda->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($entrega) ) {
                    $data['etapa_encuesta'] = true;
                    $data['detalle_encuesta'] = $encuesta;
                }

                $postventa = $this->mpostventa->getByIdAV($data['detalle_venta']['id']);
                if ( !is_numeric($postventa) ) {
                    $data['etapa_postventa'] = true;
                    $data['detalle_postventa'] = $postventa;
                }
                break;
            default:

                break;
        }*/

        $data['etapa_alta_venta'] = true;
        $data['detalle_venta'] = $this->maltaventa->getAltaVentaByIdProy($id);

        $data['module'] = 0;//( !is_null($module) ? 'busqueda_vivienda' : 0);
        $data['mpromotor'] = $this->musuario;
        $data['mprototipoxfraccionamiento'] = $this->mprototipoxfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $this->data['contenido'] = $this->load->view($this->mainView . '/ver_view', $data, true);
        $this->load->view('templates/main_template', $this->data);
    }


    public function cancelProcess()
    {
        $idAltaVenta = $this->input->post('idAltaVenta', TRUE);
        $idMotivo = $this->input->post('idMotivo', TRUE);
        $motivoCancelacion = $this->input->post('motivoCancelacion', TRUE);
        if ( $idAltaVenta != null && $idAltaVenta != '' && $idAltaVenta > 0) {
            //$idAltaVenta = $this->mgestoria->getCampo("idAltaVenta",$idGestoria);
            $idProyecto = $this->maltaventa->getCampo("idProyecto",$idAltaVenta);
            $idProspecto = $this->maltaventa->getCampo("idProspecto",$idAltaVenta);
            // $alta_venta = $this->maltaventa->getById($idAltaVenta);
            $dateCancel = date('Y-m-d');

            //penmdiente un update status 0 en prospectos

            //$autores = $this->autoRespuestaCancel($idGestoria);
            // exit();

            //$r['gestoria'] = $this->db->query("UPDATE gestoria SET status = 0, motivoCancelacion = '".$motivoCancelacion."', fechaCancelacion = '".$dateCancel."' WHERE id=".$idGestoria);
            $r['alta_venta'] = $this->db->query("UPDATE alta_venta SET status=0, statusValidacion=0, statusValidacion2='', motivoCancelacionAv = '".$motivoCancelacion."', idMotivo = '".$idMotivo."', fechaCancelacionAv = '".$dateCancel."' WHERE id=".$idAltaVenta);
            $this->db->query("UPDATE alta_venta SET idProyecto=NULL WHERE id=".$idAltaVenta);
            $r['proyecto'] = ($idProyecto>0)?$this->db->query("UPDATE proyectos SET statusVenta=0 WHERE id=".$idProyecto):0;
            $r['prospecto'] = $this->db->query("UPDATE prospectos SET status=0 WHERE id=".$idProspecto);
            $r['area_status'] = $this->db->query("DELETE FROM area_status WHERE idAltaVenta=".$idAltaVenta);
            
            $response = array(
                'success' => TRUE,
                //'idGestoria' => $idGestoria,
                'idAltaVenta' => $idAltaVenta,
                'idProyecto' => $idProyecto,
                'responseUpd' => $r,
                //'responseMail' =>$autores
            );
        }
        else {
            $response = array(
                'success' => FALSE,
                'msg' => 'Id alta venta con valor null'
            );
        }
        echo json_encode( $response );
    }

    public function eliminar(){
        $id = $this->input->post('elid');
        $q = $this->maltaventa->getById($id);
        $cValor = "true";
        $this->maltaventa->borrar($id);
        $data = json_encode(array("valor" => $cValor));
        echo $data;
    }

    public function eliminar_archivo()
    {

        if (isset($_POST['elid'])){
            $id = $this->input->post('elid');
            $campo = $this->input->post('elcampo'); //Obteniendo el nombre de la foto y thumbnail
            if($campo !="0"){
                $archivo = $this->maltaventa->getCampo('pdf_'.$campo,$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf_'.$campo] ='';
                    $this->maltaventa->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }else{
                $archivo = $this->maltaventa->getCampo('pdf',$id);
                if(unlink($this->data['fotos_www'].$archivo)){// Haciendo update a la tabla
                    $c_data['pdf'] ='';
                    $this->maltaventa->actualizar($c_data,$id);
                    $c_valor = "true";
                    //$this->msomos->borrar($id);
                }else{ $c_valor = "false";}
            }
            $data = json_encode(array("valor"=>$c_valor));
            echo $data;

        }
    }

    public function promesa($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $info = $this->maltaventa->getByIdAll($id);

        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $data['mpromotor'] = $this->musuario;
        $data['mprototipo'] = $this->mprototipos;
        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();
        // echo "<pre>"; print_r($data); echo "</pre>"; exit();
        $html = $this->load->view('formatospdf/promesa_view.php',$data,true);
            // echo $html;
            // exit();
        $this->mpdf_lib->downloadPDF($html,"promesa",0,'footer','header',$this->urlLogo);
    }

    public function generales($id = null){
        $this->load->library("mpdf_lib");
        $data = '';
        $info = $this->maltaventa->getByIdAll($id);
        // $info = $this->maltaventa->getByIdForGestoria($id);
        $data = $info;
        $data['mfraccionamiento'] = $this->mfraccionamiento;
        $data['mprototipos'] = $this->mprototipos;
        $data['musuario'] = $this->musuario;

        $this->idFraccionamiento = $info['idFraccionamiento'];
        $this->setLogo();

        $html = $this->load->view('formatospdf/generales_view.php',$data,true);

        //echo $html; exit();

        $this->mpdf_lib->downloadPDF($html,"generales",0,'footer','header',$this->urlLogo,'titHeader');
    }


    function autoRespuesta( $altaventa = null ) {
        $copiasNV = 'sistemas@viviend.mx,';
        $copiasNV .= 'ruben@navegantes.mx';

        /*$copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx';*/

        $copiasNV = 'hsalinas@viviend.mx'. ', ';
        $copiasNV .= 'esalinas@viviend.mx'. ', ';
        $copiasNV .= 'mejora@viviend.mx'. ', ';
        $copiasNV .= 'sistemas@viviend.mx';


        // $para = $emailCliente; // Comprador

        $subject = 'Nueva alta de venta'; // titulo


        $liga="http://viviend.mx/sistema/emailresources/";
        $liga2="http://viviend.mx/sistema/img/";
        $liga3="http://viviend.mx/sistema/";
        // $idFraccionamiento = $_SESSION['viv']['idFraccionamiento'];
        $idFraccionamiento = $this->mprospecto->getCampo('idFraccionamiento', $altaventa['idProspecto']);
        $fotoFracc = $this->mfraccionamiento->getCampo('foto',$idFraccionamiento);
        $urlLogoFracc = ($fotoFracc!=false)?'http://viviend.mx/sistema/uploads/fraccionamientos/'.$fotoFracc:'http://viviend.mx/sistema/img/logo-300.png';
        $tp = '';

        $data = array();

        // Datos de prospecto
        $prospecto = $this->mprospecto->getById($altaventa['idProspecto']);
        // Datos de proyecto
        //$proyecto = $this->mproyecto->getById($altaventa['idProyecto']);
        // Datos de fraccionamiento
        $fraccionamiento = $this->mfraccionamiento->getById($prospecto['idFraccionamiento']);
        // Datos de promotor
        $promotor = $this->musuario->getById($prospecto['idPromotor']);
        $nomPromotor = $promotor["nombre"]." ".$promotor["apellidoP"]." ".$promotor["apellidoM"];

        $cuerpo = '<table id="table-alta-venta" style="width: 80%;margin: 0 auto;border: 3px solid #EAC633;border-spacing: 0px;text-transform: uppercase;">
                        <tbody>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fecha de prospecci&oacute;n: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.date_format(new DateTime($prospecto['fecha']), 'd/m/Y').' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre prospecto: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['nombre'].' '.$prospecto['apellidoP'].' '.$prospecto['apellidoM'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> RFC: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['rfc'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Tel&eacute;fono: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$prospecto['telefono'].' </td>
                            </tr>
                            <!--<tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Nombre promotor: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$nomPromotor.' </td>
                            </tr>-->
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Fraccionamiento: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['titulo'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Estado: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['estado'].' </td>
                            </tr>
                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Municipio: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.$fraccionamiento['municipio'].' </td>
                            </tr>

                            <tr>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 15px;color: #548C43;font-weight: 800;"> Precio venta: </td>
                                <td style="border: 1px solid #F6E6C2;width: 50%;padding-left: 10px;font-size: 16px;color: #000;"> '.precio_format($altaventa['total']).' </td>
                            </tr>
                        </tbody>
                    </table>';

        $mensaje = '
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
        <html xmlns="http://www.w3.org/1999/xhtml">
        <head>
            <title>Email</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes" />
            <link href="https://fonts.googleapis.com/css?family=Lato:300,700" rel="stylesheet" type="text/css">
            <style>
                body, tr, td, span, div, p, a, li {
                    -moz-text-size-adjust:none !important;
                    -webkit-text-size-adjust:none !important;
                    margin:0px !important;
                    -ms-text-size-adjust:none !important;
                    white-space: wrap;
                }
                .lato-light{
                    font-family: "lato" sans-serif !important;
                    font-weight: 300;
                }
                .lato-bold{
                    font-family: "lato" sans-serif !important;
                    font-weight: 700;
                }
                td img {
                    display: block;
                }
                .ReadMsgBody {
                    width: 100%;
                }
                .ExternalClass * {
                    line-height: 100%;
                }
                @media only screen and (max-width:480px) {
                    #logosim{
                        padding:0!important;
                    }
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 320px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
                @media only screen and (min-width:480px) and (max-width:599px) {
                    *[class="code4email_wrapper"] {
                        width: 100% !important;
                    }
                    *[class="code4email_main_table"] {
                        width: 480px !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_hide"] {
                        display: none !important;
                    }
                    *[class="code4email_center"] {
                        text-align: center !important;
                        padding:10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_clear"] {
                        width: 100% !important;
                        clear: both !important;
                        float: left !important;
                    }
                    *[class="code4email_br"] {
                        display:block !important;
                        width: 1px !important;
                        height:6px !important;
                        clear: both !important;
                    }
                    *[class="code4email_text_p10"] {
                        padding: 0px 10px 10px 10px !important;
                        height:20px !important;
                    }
                    *[class="code4email_w20"] {
                        width: 20px !important;
                    }
                    *[class="code4email_h20"] {
                        height: 20px !important;
                    }
                    *[class="code4email_h20_center"] {
                        height: 20px !important;
                        text-align: center !important;
                    }
                }
            </style>
        </head>
        <body marginheight="0" marginwidth="0" leftmargin="0" topmargin="0" bgcolor="#FFFFFE" style="-moz-text-size-adjust:none !important; padding:0px !important; -webkit-text-size-adjust:none !important; margin:0px ! important; -ms-text-size-adjust:none !important; white-space: wrap;">
            <table class="code4email_wrapper" width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                <tr> <td colspan="" style="text-align: right !important;"> Fecha: '.date('d/m/Y').' </td> </tr>
                <tr>
                    <td align="center" valign="top" bgcolor="#FFFFFE">
                        <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650px" style="width:650px;">
                            <tr>
                                <td>
                                    <a href="'.$liga3.'" target="_blank">
                                        <table   height="135px" background="" class="code4email_wrapper"  width="650px" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                                <td  valign="middle" width="200" height="109" style="margin:0px; padding:10px 225px 10px 225px; height:109px; width: 200px;">
                                                    <img width="280" src="'.$urlLogoFracc.'" />
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td align="left" valign="top" style="line-height:12px; padding:0px; margin:0px; font-size:12px; width:650px;">
                                    <table class="code4email_wrapper" align="center" border="0" cellpadding="0" cellspacing="0" width="650" style="width:650px;">
                                        <tr>
                                            <td align="left" valign="middle" width="600" height="91" bgcolor="#FFFFFE" style="width:630px; margin:0px; height:91px; padding-bottom:15px; padding-top:25px; font-family: Arial, Helvetica, sans-serif; color: #333333; font-size: 14px; mso-line-height-rule:exactly; white-space: wrap; line-height:20px;" class="code4email_center">
                                                <!--<span style="color: #5b5b5f; font-size: 14px; text-decoration: none;" class="lato-light">-->
                                                    <h3 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:24px;margin-bottom: 0px;"> Nueva alta de venta </h3>
                                                    <h4 style="color: #57BA47;font-weight: bold;text-align: center;text-transform: uppercase;font-size:16px;margin-top: 10px;"> De '.$nomPromotor.' </h4>
                                                    <br><br>
                                                    '.$cuerpo.'
                                                <!--</span>-->
                                            </td>
                                        </tr>
                                    </table>
                                    <div style="background: #548C43; width: 100%; border: 1px solid #548C43; height: 25px; margin-top: 75px !important;"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </body>
        </html>';

        // para el gerente de ventas -------------------------------------------------
        // Para enviar un correo HTML, debe establecerse la cabecera Content-type
        $cabeceras  = 'MIME-Version: 1.0' . "\r\n";
        $cabeceras .= "Content-type:text/html;charset=utf-8" . "\n";

        // Cabeceras adicionales
        $cabeceras .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

        // $para = $this->musuario->getCampo("email", $this->musuario->getGerente());
        //$para = $this->musuario->getCampo("email", $this->musuario->getGerente2($idFraccionamiento));
        if($this->appProduction){
            $qGerentes = $this->musuario->getGerentes2($idFraccionamiento);
            if( !is_numeric($qGerentes) ){
                foreach($qGerentes->result() as $gteV){
                    $para = $this->musuario->getCampo("email", $gteV->id);
                    if ($para){
                        mail($para, $subject, $mensaje, $cabeceras);
                    }
                }
            }


            /*----------------------------------------------------------------*/
            $gestor = $this->mfraccionamientoxusuario->getGestoriaSelectResultByIdFracc($fraccionamiento['id']);
            if (!is_numeric($gestor)) {
                foreach ($gestor->result() as $row) {
                    $mail = $this->musuario->getCampo('email',$row->id);
                    if (!is_null($mail)) { mail($mail, $subject, $mensaje, $cabeceras); }
                }
            }


            $subject2 = $subject;

            // para el gerente  -------------------------------------------------
            $cabecerasAdmin  = 'MIME-Version: 1.0' . "\r\n";
            $cabecerasAdmin .= "Content-type:text/html;charset=utf-8" . "\n";

            // Cabeceras adicionales
            $cabecerasAdmin .= 'From: Viviend <contacto@viviend.mx>' . "\r\n";

            // para el administrador
            mail($copiasNV, $subject2, $mensaje, $cabecerasAdmin);
        }else{
             mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             mail('sistemas@viviend.mx', $subject, $mensaje, $cabeceras);
             mail('alfredo@navegantes.mx', $subject, $mensaje, $cabeceras);
             mail('alvaro@navegantes.mx', $subject, $mensaje, $cabeceras);
        }
        return true;
    }


}